<?php

class ControllerAndroidCommonNotification extends Controller
{
    private $model_name;

    private $notification_module = [];

    public function index()
    {
        //load model
        $this->load->model('android/common/notification');
        $this->model_name = $this->model_android_common_notification;

        $this->notification_module = $this->model_name->getNotificationModule();

        //load required file
        require DIR_SYSTEM . "/library/start_api.php";
    }

    public function push($params)
    {
        $user_id = $params['user_id'];
        $notification = $params['notification'];
        $notification['sound'] = "default";
        $notification_type = $params['notification_type'];
        $data = $params['data'];

        $this->load->model('android/common/notification');


        $this->load->library('fcm');
        $this->fcm = new FCM($this->registry);

        $tokens = $this->model_android_common_notification->getTokens($user_id);
        if (!empty($tokens)) {
            $proceed = true;
            if (!empty($params['module']) && !empty($params['action'])) {
                $setting = $this->model_android_common_notification->getUserSetting($user_id, $params['module'], $params['action']);
                if (!empty($setting)) {
                    if ($setting['app'] == '0') {
                        $proceed = false;
                    }
                }
            }

            if ($proceed) {
                $this->fcm->setUrl(NOTIFICATION_FCM_URL);
                $this->fcm->setKey(NOTIFICATION_FCM_KEY);
                $this->fcm->sendTo($tokens);
                $this->fcm->setData($data);
                $this->fcm->setNotification($notification);

                list($request, $response, $error) = $this->fcm->push_notification();
                //log in DB
                $device_id = array();
                foreach ($tokens as $token) {
                    $device_id[] = $this->model_android_common_notification->getDeviceIdByToken($token);
                }


                $log_data = array(
                    "user_id" => $user_id,
                    "device_id" => json_encode($device_id),
                    "notification" => json_encode($notification),
                    "fcm_data" => json_encode($data),
                    "request" => $request,
                    "response" => $response,
                    "error" => $error,
                );

                // var_dump($log_data);
                // die();
                $log_id = $this->model_android_common_notification->addFirebaseLog($log_data);
                if ($log_id) {
                    //log into notification history
                    $history_data = array(
                        "user_id" => $user_id,
                        "log_id" => $log_id,
                        "notification_type" => $notification_type,
                        "notification" => json_encode($notification),
                        "fcm_data" => json_encode($data),
                    );
                    $history_id = $this->model_android_common_notification->addNotificationHistory($history_data);
                }
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function send_notification()
    {
        $json = $this->json;

        if ($this->push($json)) {
            $output = $this->response->setResponse2(200, new stdClass(), "success", "notification");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setResponse2(400, new stdClass(), "failed", "notification");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_users()
    {
        $all_users = [];
        $users = $this->model_name->getUsers();
        $this->load->model('setting/store');
        $db_stores = $this->model_setting_store->getStores();
        $stores = [];
        $stores[0] = htmlspecialchars_decode($this->config->get('config_name'));
        foreach ($db_stores as $store) {
            $stores[$store['store_id']] = $store['name'];
        }

        $all_actions = 0;
        foreach ($this->notification_module as $module => $actions) {
            foreach ($actions as $action) {
                $all_actions++;
            }
        }

        foreach ($users as $user) {
            $name = trim($user['firstname'] . " " . $user['lastname']);
            $image = $user['image'] ? $user['image'] : null;
            if (!empty($user) && $user['image'] && is_file(DIR_IMAGE . $user['image'])) {
                $image = HTTPS_IMAGE . $user['image'];
            } else {
                $image = "https://ui-avatars.com/api/?background=random&bold=true&size=120&name=" . str_replace(' ', '+', $name);
            }
            $store_name = $stores[$this->session->data['store_id']];
            $position = "Staff";
            if ($user['position'] == '2') {
                $position = "Doctor";
            }
            $user_id = $user['user_id'];
            $user_settings = $this->model_name->getUserNotificationSetting($user_id);
            if (!empty($user_settings)) {
                $not_allowed = 0;
                foreach ($user_settings as $setting) {
                    if ($setting['app'] == "0" && $setting['email'] == "0" && $setting['sms'] == "0") {
                        $not_allowed++;
                    }
                }
                $allowed_actions = $all_actions - $not_allowed;
            } else {
                $allowed_actions = $all_actions;
            }

            $allowed_text = "$allowed_actions of $all_actions actions allowed";

            $all_users[] = [
                "user_id"       => $user_id,
                "name"          => $name,
                "image"         => $image,
                "store_name"    => $store_name,
                "position"      => $position,
                "allowed_text"  => $allowed_text
            ];
        }

        // $return_result = [
        //     // "all_actions" => $all_actions,
        //     // "action_list" => $action_list,
        //     "all_users" => $all_users,
        // ];

        $output = $this->response->setCachedResponse(200, $all_users, "Get list success", "notification");
        $this->api->trackResponse($output);
        return;
    }

    protected function get_user_detail()
    {
        $user_id = !empty($this->request->get['user_id']) ? $this->request->get['user_id'] : $this->session->data['user_id'];
        $user = $this->model_name->getUser($user_id);

        //user info
        $this->load->model('setting/store');
        $db_stores = $this->model_setting_store->getStores();
        $stores = [];
        $stores[0] = htmlspecialchars_decode($this->config->get('config_name'));
        foreach ($db_stores as $store) {
            $stores[$store['store_id']] = $store['name'];
        }

        $name = trim($user['firstname'] . " " . $user['lastname']);
        $image = $user['image'] ? $user['image'] : null;
        if (!empty($user) && $user['image'] && is_file(DIR_IMAGE . $user['image'])) {
            $image = HTTPS_IMAGE . $user['image'];
        } else {
            $image = "https://ui-avatars.com/api/?background=random&bold=true&size=120&name=" . str_replace(' ', '+', $name);
        }
        $store_name = $stores[$this->session->data['store_id']];
        $position = "Staff";
        if ($user['position'] == '2') {
            $position = "Doctor";
        }

        $user_detail = [
            "user_id"       => $user_id,
            "name"          => $name,
            "image"         => $image,
            "store_name"    => $store_name,
            "position"      => $position,
        ];

        //notification info
        $action_list = [];
        foreach ($this->notification_module as $module => $actions) {
            foreach ($actions as $key => $value) {
                $action_list[] = [
                    "code" => $module . "__" . $key,
                    "label" => $value['label'],
                    "desc" => $value['desc']
                ];
            }
        }

        $user_settings = $this->model_name->getUserNotificationSetting($user_id);

        $return_actions = [];
        foreach ($action_list as $list) {
            list($module, $action) = explode("__", $list['code']);
            $return_actions[$list['code']] = [
                "code"  => $list['code'],
                "label" => $list['label'],
                "desc"  => $list['desc'],
                "push"  => true,
                "email" => true,
                "sms"   => true,
            ];

            if (!empty($user_settings)) {
                foreach ($user_settings as $setting) {
                    if ($setting['module'] == $module && $setting['action'] == $action) {
                        $return_actions[$list['code']] = [
                            "code"  => $list['code'],
                            "label" => $list['label'],
                            "desc"  => $list['desc'],
                            "push"  => (bool)$setting['app'],
                            "email" => (bool)$setting['email'],
                            "sms"   => (bool)$setting['sms'],
                        ];
                    }
                }
            }
        }

        $return_actions = array_values($return_actions);

        $result = [
            "user_info" => $user_detail,
            "notification_list" => $return_actions
        ];
        $output = $this->response->setCachedResponse(200, $result, "Get list success", "notification");
        $this->api->trackResponse($output);
        return;
    }

    protected function update_notification_setting()
    {
        $json = $this->json;
        if (empty($json)) {
            $output = $this->response->setResponse2(400, new stdClass(), "missing json body", "notification");
            $this->api->trackResponse($output);
            return;
        }
        if (empty($json['notification_list'])) {
            $output = $this->response->setResponse2(400, new stdClass(), "notification_list required", "notification");
            $this->api->trackResponse($output);
            return;
        }

        $user_id = !empty($json['user_id']) ? $json['user_id'] : $this->session->data['user_id'];

        foreach ($json['notification_list'] as $data) {
            $this->model_name->updateNotificationSetting($user_id, $data);
        }
        $output = $this->response->setResponse2(200, new stdClass(), "success", "notification");
        $this->api->trackResponse($output);
        return;
    }


    #region internal function

    #endregion
}
