<?php

class ControllerAndroidBrewingTopUpCredit extends Controller {

    private $app_hash;
    private $call_back;
    private $call_function;
    private $currency;
    private $currency_code;
    private $hash;
    private $is_ver20;
    private $push_currency_code;
    private $store_id;
    private $s;
    private $opencart_version;
    private $post_data;
    private $selected_store;
    private $selected_shipping_method;
    private $output;

    const MODULE_CODE = 16;
    const MODULE_VERSION = '1.1.11';
    const DEBUG_MODE = false;
    const MOB_ASSIST_API_KEY = 'AIzaSyDIq4agB70Zv7AkB9pVuF2KxcU4WQ94CVI';

    public function index() {
        @date_default_timezone_get('UTC');
        $this->check_version();

        $this->load->model('android/setting');
        $this->load->model('android/connector');
        $this->load->model('android/brewing_quotation_api');
        $this->load->model('android/customer');

        $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');
        $this->config->set('config_language_id', $this->model_android_brewing_quotation_api->getlangugeId());

        if (!isset($this->s['andassist_status'])) {
            $data['error_code'] = [
                'error' => -1,
                'msj' => 'API disabled',
                'app_hash' => $this->app_hash
            ];
            $this->generate_output($data);
        }

        $post = $this->request->post;
        $request = $this->request->request;

        if (isset($request['call_back']) && strlen($request['call_back']) > 0) {
            $this->call_back = $request['call_back'];
        }

        if (isset($request['call_function']) && strlen($request['call_function']) > 0) {
            $this->call_function = $request['call_function'];
        }

        if (isset($request['hash']) && strlen($request['hash']) > 0) {
            $this->hash = $request['hash'];
        }

        if (isset($request['app_hash']) && strlen($request['app_hash']) > 0) {
            $this->app_hash = $request['app_hash'];
        }

        if (empty($this->call_function)) {
            $this->run_self_test();
        }

        if (!$this->check_confing()) {
            $data['error_code'] = [
                'error' => -1,
                'msj' => 'API disable',
                'app_hash' => $this->app_hash
            ];
            $this->generate_output($data);
        }

        if (!$this->check_auth()) {
            $data['error_code'] = [
                'error' => -2,
                'msj' => 'Password Not Match',
            ];
            $this->generate_output($data);
        }

        if ($this->call_function == 'test_config') {
            $this->generate_output(array('test' => 1));
        }

        $params = $this->_validate_types($request, array(
        ));

        foreach ($params as $k => $value) {
            $this->{$k} = $value;
        }

        $this->post_data = $post;

        foreach ($this->post_data as $k => $value) {
            $this->{$k} = $value;
        }

        if (empty($this->currency_code) || $this->currency_code == 'not_set') {
            $this->currency = '';
        } else if ($this->currency_code == 'base_currency') {
            $this->currency = $this->config->get('config_currency');
        } else {
            $this->currency = $this->currency_code;
        }

        print_r($this->currency_code);

        if (empty($this->push_currency_code) || $this->push_currency_code == 'not_set') {
            $this->push_currency_code = '';
        }

        if ($this->store_id == '') {
            $this->store_id = -1;
        }

        $this->store_id = intval($this->store_id);

        if (!method_exists($this, $this->call_function)) {
            $this->generate_output('old_module');
        }

        $result = call_user_func(array($this, $this->call_function));
        $this->generate_output($result);
    }

    private function check_version() {
        if (class_exists('MijoShop')) {
            $base = MijoShop::get('base');

            $installed_ms_version = (array) $base->getMijoshopVersion();
            $mijo_version = $installed_ms_version[0];
            if (version_compare($mijo_version, '3.0.0', '>=') && version_compare(VERSION, '2.0.0.0', '<')) {
                $this->opencart_version = '2.0.1.0';
            } else {
                $this->opencart_version = VERSION;
            }
        } else {
            $this->opencart_version = VERSION;
        }
        $this->is_ver20 = version_compare($this->opencart_version, '2.0.0', '>=');
    }

    private function check_confing() {
        $this->load->model('android/brewing_quotation_api');
        $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');

        if (isset($this->request->request['app_hash'])) {
            if (md5($this->s['andassist_login'] . $this->s['andassist_pass']) == $this->request->request['app_hash'] && $this->s['andassist_status'] == 1) {
                return true;
            }
        }
        return false; //return true or false only can be one, either one return, the other one will stop.
    }

    private function check_auth() {
        $userColData = $this->revers_base64($this->hash);
        $user_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE username = '" . $this->db->escape($userColData['user_name']) . "' AND (password = SHA1(CONCAT(salt, SHA1(CONCAT(salt, SHA1('" . $this->db->escape($userColData['password']) . "'))))) OR password = '" . $this->db->escape(md5($userColData['password'])) . "') AND status = 1 AND position = '2'");
        if ($user_query->num_rows) {
            $store_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_to_store s LEFT JOIN " . DB_PREFIX . "setting l ON (s.store_id = l.store_id) WHERE s.user_id = '" . (int) $user_query->row['user_id'] . "' AND s.store_id = '" . $userColData['store_id'] . "' AND l.key = 'config_language'");
            if ($store_query->num_rows) {
                if (strtotime($user_query->row['periodto']) > strtotime(date("Y-m-d"))) {
                    return true;
                } else {
                    return false;
                }
            }
        }
        return false;
    }

    private function revers_base64($data) {
        $user_info = base64_decode($data);
        $userColData = json_decode($user_info, true);
        return $userColData;
    }

    private function _validate_types($array, $names) {
        foreach ($names as $name => $type) {
            if (isset($array["$name"])) {
                switch ($type) {
                    case 'INT':
                        $array["$name"] = intval($array["$name"]);
                        break;
                    case 'FLOAT':
                        $array["$name"] = floatval($array["$name"]);
                        break;
                    case 'STR':
                        $array["$name"] = str_replace(array("\r", "\n"), ' ', addslashes(htmlspecialchars(trim(url_encode($array["$name"])))));
                        break;
                    default:
                        $array["$name"] = '';
                }
            } else {
                $array["$name"] = '';
            }
        }
        return $array;
    }

    private function generate_output($data) {
        $add_bridge_version = false;

        if (in_array($this->call_function, array("test_config", "get_store_title", "get_store_stats", "get_data_graphs"))) {
            if (is_array($data) && $data != 'auth_error' && $data != 'connection_error' && $data != 'old_bridge') {
                $add_bridge_version = true;
            }
        }

        if (!is_array($data)) {
            $data = array($data);
        }

        if ($add_bridge_version) {
            $data['module_version'] = self::MODULE_CODE;
        }

        if (is_array($data)) {
            array_walk_recursive($data, array($this, 'reset_null'));
        }

        $data = json_encode($data);

        if ($this->callback) {
            header('Content-Type: text/javascript;charset=utf-8');
            die($this->callback . '(' . $data . ');');
        } else {
            $this->response->addHeader('Content-Type: application/json');
            $this->response->setOutput($data);
        }
    }

    public function setOutput($output) {
        $this->output = $output;
    }

    public function setHeader($header) {
        $this->headers = array();
        if (is_array($header)) {
            foreach ($header as $h)
                $this->headers[] = $h;
        } else {
            $this->headers[] = $header;
        }
    }

    private function reset_null(&$item) {
        if (empty($item) && $item != 0) {
            $item = '';
        }

        // $item = trim($item);

        $item = $item;
    }

    private function getPaymentMethod() {

        $this->load->model('android/brewing/top_up_credit');

        $payment_address = $this->getBuyerAddress();

        if (!empty($payment_address)) {
            $api_url = HTTP_API . 'index.php?route=etcm/brewing/store/getPaymentMethod';

            $post_data = [
                'payment_address' => $payment_address['data']
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

//            echo"<pre>";
//            print_r($result);
//             echo"</pre>";

            curl_close($ch);

            $result_arr = json_decode($result, true);
        }

        if ($result_arr['error'] == '0') {
            $payment_method_returns = $result_arr['data'];

            $json['error_code'] = [
                'error' => 0,
                'msj' => 'get payment method success'
            ];

            $json['data'] = $payment_method_returns;
        } else {
            $json['error_code'] = [
                'error' => 1,
                'msj' => 'api not response'
            ];
        }

        return $json;
    }

    private function getPaymentMethod2() {

        $this->load->model('android/brewing/top_up_credit');

        $payment_address = $this->getBuyerAddress();

        if (!empty($payment_address)) {
            $api_url = HTTP_API . 'index.php?route=etcm/brewing/store/getChildPaymentMethod';

            $post_data = [
                'payment_address' => $payment_address['data']
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

//            echo"<pre>";
//            print_r($result);
//             echo"</pre>";

            curl_close($ch);

            $result_arr = json_decode($result, true);
        }

        if ($result_arr['error'] == '0') {
            $payment_method_returns = $result_arr['data'];

            $json['error_code'] = [
                'error' => 0,
                'msj' => 'get payment method success'
            ];

            $json['data'] = $payment_method_returns;
        } else {
            $json['error_code'] = [
                'error' => 1,
                'msj' => 'api not response'
            ];
        }

        return $json;
    }

    public function getBuyerAddress() {
        $json = [];
        $addresses = [];

        $api_url = HTTP_API . 'index.php?route=etcm/wholesale/get_buyer_addresses';

        $post_data = [
            'hosting' => HTTP_SERVER
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        $address_arr = json_decode($result, true);

        if ($address_arr['error'] == '0') {
            if (!empty($address_arr['data'])) {
                foreach ($address_arr['data'] as $address) {
                    $address_1 = !empty($address['address_1']) ? $address['address_1'] . ', ' : '';
                    $address_2 = !empty($address['address_2']) ? $address['address_2'] . ', ' : '';
                    $postcode = !empty($address['postcode']) ? $address['postcode'] . ' ' : '';
                    $city = !empty($address['city']) ? $address['city'] . ', ' : '';
                    $zone_name = !empty($address['zone_name']) ? $address['zone_name'] . ', ' : '';
                    $country_name = !empty($address['country_name']) ? $address['country_name'] . '.' : '';

                    $full_address = $address_1 . $address_2 . $postcode . $city . $zone_name . $country_name;

                    $addresses[] = [
                        'address_id' => $address['address_id'],
                        'name' => $address['name'],
                        'company' => $address['company'],
                        'address_1' => $address['address_1'],
                        'address_2' => $address['address_2'],
                        'postcode' => $address['postcode'],
                        'city' => $address['city'],
                        'country_id' => $address['country_id'],
                        'country_name' => $address['country_name'],
                        'zone_id' => $address['zone_id'],
                        'zone_name' => $address['zone_name'],
                        'full_address' => $full_address
                    ];
                }
            }
        }

        $json['error_code'] = [
            'error' => 0,
            'msj' => 'get buyer addresses success'
        ];

        $json['data'] = $addresses;

        return $json;
    }

    public function setTopUpAmount() {
        $top_up_amount = isset($this->request->post['top_up_amount']) ? $this->request->post['top_up_amount'] : false;

        if (!($top_up_amount)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($top_up_amount) {

            $post_data = [
                'top_up_amount' => $top_up_amount,
                'hosting' => HTTPS_SERVER
            ];

            $store_list = HTTP_API . 'index.php?route=etcm/brewing/top_up_credit/setTopUpAmount';

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_URL, $store_list);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            curl_close($ch);

            $final_result = json_decode($result, true);
        }

        if ($final_result) {
            $json['top_up_amount'] = $final_result;
            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'Set Top Up amount Success',
            );
        } else {

            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'Failed to set Top Up amount',
            );
        }

        return $json;
    }

    public function CheckoutOrder2() {
        $top_up_amount = isset($this->request->post['top_up_amount']) ? $this->request->post['top_up_amount'] : false;
        $payment_method_code = isset($this->request->post['payment_method_code']) ? $this->request->post['payment_method_code'] : false;

        if (!($top_up_amount && $payment_method_code)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        $post_data = [
            'hosting' => HTTPS_SERVER,
            'payment_method_code' => $payment_method_code,
            'top_up_amount' => $top_up_amount
        ];

        $store_list = HTTP_API . 'index.php?route=etcm/brewing/top_up_credit/CheckoutOrder2';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_URL, $store_list);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        $json['payment_details'] = json_decode($result, true);

        if ($json['payment_details']) {
            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'succes'
            );
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'Insert error',
            );
        }
        return $json;
    }

    public function CheckoutOrder() {

        $payment_method_code = isset($this->request->post['payment_method_code']) ? $this->request->post['payment_method_code'] : false;

        $post_data = [
            'hosting' => HTTPS_SERVER,
            'payment_method_code' => $payment_method_code
        ];

        $store_list = HTTP_API . 'index.php?route=etcm/brewing/top_up_credit/CheckoutOrder';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_URL, $store_list);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        echo '<pre>';
        print_r($result);
        echo '</pre>';

        curl_close($ch);

        $final_result = json_decode($result, true);
    }

    public function setPaymentMethod() {
        $this->load->model('android/brewing/top_up_credit');

        if (isset($this->request->post)) {
            $payment_method_code = isset($this->request->post['payment_method_code']) ? $this->request->post['payment_method_code'] : false;

            if (!($payment_method_code)) {
                $json['error_code'] = array(
                    'error' => 1,
                    'code' => 1001,
                    'msj' => 'Missing Parameter'
                );

                return $json;
            }

            if ($payment_method_code) {

                $payment_method = $this->getChildPaymentMethod();

                if (!empty($payment_method['data'])) {
                    foreach ($payment_method['data'] as $payments) {
                        if ($payments['code'] == $payment_method_code) {
                            $json['payment_method'] = $payments;
                        }
                    }
                }

                if ($json['payment_method']) {
                    $json['error_code'] = array(
                        'error' => 0,
                        'msj' => 'Successful set payment method'
                    );
                } else {
                    $json['error_code'] = array(
                        'error' => 1,
                        'msj' => 'Failed to set payment method',
                    );
                }
            }
        } else {
            $json['error_code'] = [
                'error' => 1,
                'msj' => 'cannot get post data'
            ];
        }

        return $json;
    }

    public function getChildPaymentMethod() {
        $this->load->model('android/brewing/product');

        $top_up_amount = isset($this->request->post['top_up_amount']) ? $this->request->post['top_up_amount'] : false;


        $post_data = [
            'total' => $top_up_amount
        ];

        $store_list = HTTP_API . 'index.php?route=etcm/brewing/store/getChildPaymentMethod';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_URL, $store_list);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        $final_result = json_decode($result, true);

        if ($final_result['error'] == '0') {
            $fpx_payment_method_returns = $final_result['data'];
            $json['data'] = $fpx_payment_method_returns;

            $json['error_code'] = [
                'error' => 0,
                'msj' => 'get child payment method success'
            ];
        } else {
            $json['error_code'] = [
                'error' => 1,
                'msj' => 'api not response'
            ];
        }

        return $json;
    }

    public function tseaased() {
        ###App Hash
        $username = 'huang';
        $password = md5('huang');
        echo md5($username . $password);
    }

}

?>