<?php

class ControllerAndroidBrewingStore extends Controller {

    private $app_hash;
    private $call_back;
    private $call_function;
    private $currency;
    private $currency_code;
    private $hash;
    private $is_ver20;
    private $push_currency_code;
    private $store_id;
    private $s;
    private $opencart_version;
    private $post_data;
    private $selected_store;
    private $selected_shipping_method;
    private $output;

    const MODULE_CODE = 16;
    const MODULE_VERSION = '1.1.11';
    const DEBUG_MODE = false;
    const MOB_ASSIST_API_KEY = 'AIzaSyDIq4agB70Zv7AkB9pVuF2KxcU4WQ94CVI';

    public function index() {
        @date_default_timezone_get('UTC');
        $this->check_version();

        $this->load->model('android/setting');
        $this->load->model('android/connector');
        $this->load->model('android/brewing_quotation_api');
        $this->load->model('android/customer');

        $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');
        $this->config->set('config_language_id', $this->model_android_brewing_quotation_api->getlangugeId());

        if (!isset($this->s['andassist_status'])) {
            $data['error_code'] = [
                'error' => -1,
                'msj' => 'API disabled',
                'app_hash' => $this->app_hash
            ];
            $this->generate_output($data);
        }

        $post = $this->request->post;
        $request = $this->request->request;

        if (isset($request['call_back']) && strlen($request['call_back']) > 0) {
            $this->call_back = $request['call_back'];
        }

        if (isset($request['call_function']) && strlen($request['call_function']) > 0) {
            $this->call_function = $request['call_function'];
        }

        if (isset($request['hash']) && strlen($request['hash']) > 0) {
            $this->hash = $request['hash'];
        }

        if (isset($request['app_hash']) && strlen($request['app_hash']) > 0) {
            $this->app_hash = $request['app_hash'];
        }

        if (empty($this->call_function)) {
            $this->run_self_test();
        }

        if (!$this->check_confing()) {
            $data['error_code'] = [
                'error' => -1,
                'msj' => 'API disable',
                'app_hash' => $this->app_hash
            ];
            $this->generate_output($data);
        }

        if (!$this->check_auth()) {
            $data['error_code'] = [
                'error' => -2,
                'msj' => 'Password Not Match',
            ];
            $this->generate_output($data);
        }

        if ($this->call_function == 'test_config') {
            $this->generate_output(array('test' => 1));
        }

        $params = $this->_validate_types($request, array());

        foreach ($params as $k => $value) {
            $this->{$k} = $value;
        }

        $this->post_data = $post;

        foreach ($this->post_data as $k => $value) {
            $this->{$k} = $value;
        }

        if (empty($this->currency_code) || $this->currency_code == 'not_set') {
            $this->currency = '';
        } else if ($this->currency_code == 'base_currency') {
            $this->currency = $this->config->get('config_currency');
        } else {
            $this->currency = $this->currency_code;
        }

        print_r($this->currency_code);

        if (empty($this->push_currency_code) || $this->push_currency_code == 'not_set') {
            $this->push_currency_code = '';
        }

        if ($this->store_id == '') {
            $this->store_id = -1;
        }

        $this->store_id = intval($this->store_id);

        if (!method_exists($this, $this->call_function)) {
            $this->generate_output('old_module');
        }

        $result = call_user_func(array($this, $this->call_function));
        return $this->generate_output($result);
    }

    private function check_version() {
        if (class_exists('MijoShop')) {
            $base = MijoShop::get('base');

            $installed_ms_version = (array) $base->getMijoshopVersion();
            $mijo_version = $installed_ms_version[0];
            if (version_compare($mijo_version, '3.0.0', '>=') && version_compare(VERSION, '2.0.0.0', '<')) {
                $this->opencart_version = '2.0.1.0';
            } else {
                $this->opencart_version = VERSION;
            }
        } else {
            $this->opencart_version = VERSION;
        }
        $this->is_ver20 = version_compare($this->opencart_version, '2.0.0', '>=');
    }

    private function check_confing() {
        $this->load->model('android/brewing_quotation_api');
        $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');

        if (isset($this->request->request['app_hash'])) {
            if (md5($this->s['andassist_login'] . $this->s['andassist_pass']) == $this->request->request['app_hash'] && $this->s['andassist_status'] == 1) {
                return true;
            }
        }
        return false; //return true or false only can be one, either one return, the other one will stop.
    }

    private function check_auth() {
        $userColData = $this->revers_base64($this->hash);
        $user_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE username = '" . $this->db->escape($userColData['user_name']) . "' AND (password = SHA1(CONCAT(salt, SHA1(CONCAT(salt, SHA1('" . $this->db->escape($userColData['password']) . "'))))) OR password = '" . $this->db->escape(md5($userColData['password'])) . "') AND status = 1 AND position = '2'");
        if ($user_query->num_rows) {
            $store_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_to_store s LEFT JOIN " . DB_PREFIX . "setting l ON (s.store_id = l.store_id) WHERE s.user_id = '" . (int) $user_query->row['user_id'] . "' AND s.store_id = '" . $userColData['store_id'] . "' AND l.key = 'config_language'");
            if ($store_query->num_rows) {
                if (strtotime($user_query->row['periodto']) > strtotime(date("Y-m-d"))) {
                    return true;
                } else {
                    return false;
                }
            }
        }
        return false;
    }

    private function revers_base64($data) {
        $user_info = base64_decode($data);
        $userColData = json_decode($user_info, true);
        return $userColData;
    }

    private function _validate_types($array, $names) {
        foreach ($names as $name => $type) {
            if (isset($array["$name"])) {
                switch ($type) {
                    case 'INT':
                        $array["$name"] = intval($array["$name"]);
                        break;
                    case 'FLOAT':
                        $array["$name"] = floatval($array["$name"]);
                        break;
                    case 'STR':
                        $array["$name"] = str_replace(array("\r", "\n"), ' ', addslashes(htmlspecialchars(trim(url_encode($array["$name"])))));
                        break;
                    default:
                        $array["$name"] = '';
                }
            } else {
                $array["$name"] = '';
            }
        }
        return $array;
    }

    private function generate_output($data) {
        $add_bridge_version = false;

        if (in_array($this->call_function, array("test_config", "get_store_title", "get_store_stats", "get_data_graphs"))) {
            if (is_array($data) && $data != 'auth_error' && $data != 'connection_error' && $data != 'old_bridge') {
                $add_bridge_version = true;
            }
        }

        if (!is_array($data)) {
            $data = array($data);
        }

        if ($add_bridge_version) {
            $data['module_version'] = self::MODULE_CODE;
        }

        if (is_array($data)) {
            array_walk_recursive($data, array($this, 'reset_null'));
        }

        $data = json_encode($data);

        if ($this->callback) {
            header('Content-Type: text/javascript;charset=utf-8');
            die($this->callback . '(' . $data . ');');
        } else {
            $this->response->addHeader('Content-Type: application/json');
            $this->response->setOutput($data);
        }
    }

    public function setOutput($output) {
        $this->output = $output;
    }

    public function setHeader($header) {
        $this->headers = array();
        if (is_array($header)) {
            foreach ($header as $h)
                $this->headers[] = $h;
        } else {
            $this->headers[] = $header;
        }
    }

    private function reset_null(&$item) {
        if (empty($item) && $item != 0) {
            $item = '';
        }

// $item = trim($item);

        $item = $item;
    }

    private function access_etcm_api($data, $path) {
        $hash = $this->config->get('etcm_hash');

        $curl = curl_init();

// Set SSL if required
        if (substr(HTTP_API, 0, 5) == 'https') {
            curl_setopt($curl, CURLOPT_PORT, 443);
        }

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_FORBID_REUSE, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_URL, HTTP_API . 'index.php?route=etcm/api&hash=' . $hash . $path);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));

        $response = curl_exec($curl);

        $response_encode = json_decode($response, true);
        return $response_encode;
    }

    public function getStoreList() {

        $this->load->model('android/brewing/product');

//        $page = isset($this->request->get['page']) ? $this->request->get['page'] : false;
        $search = isset($this->request->get['search']) ? $this->request->get['search'] : false;
//        $show = isset($this->request->get['show']) ? $this->request->get['show'] : false;

        $herbal_request_id = isset($this->request->get['herbal_request_id']) ? $this->request->get['herbal_request_id'] : false;
        $store_id = isset($this->request->post['store_id']) ? $this->request->post['store_id'] : false;

        if (!($herbal_request_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_request_id) {
            $herbal_info = $this->model_android_brewing_product->getDetails($herbal_request_id);

            $decode_data = !empty($herbal_info) ? json_decode($herbal_info, true) : [];

            if (!empty($decode_data)) {
                $customer_data = $decode_data;

                if ($decode_data['address'] != NULL) {
                    $json['products'] = [];

                    if (!empty($customer_data['product'])) {
                        foreach ($customer_data['product'] as $product_list) {
                            $json['products'][] = [
                                'product_id' => $product_list['product_id'],
                                'quantity' => $product_list['quantity']
                            ];
                        }
                    }

                    $prescription = $decode_data['prescription'];

                    $post_data = [
                        'product' => $json['products'],
                        'brewingtype' => $customer_data['brewingtype'],
                        'customer_address' => $customer_data['address'],
                        'store_id' => $store_id,
                        'search' => $search,
                        'prescription' => $prescription,
                        'hosting' => HTTPS_SERVER
                    ];

                    $store_list = HTTP_API . 'index.php?route=etcm/brewing/store/getStoreList';

                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_HEADER, false);
                    curl_setopt($ch, CURLINFO_HEADER_OUT, true);
                    curl_setopt($ch, CURLOPT_URL, $store_list);
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                    $result = curl_exec($ch);

                    curl_close($ch);

                    $json = json_decode($result, true);

                    if (!empty($json)) {

                        $json['error_code'] = array(
                            'error' => 0,
                            'msj' => 'Get Store List Success',
                        );
                    } else {

                        $json['error_code'] = array(
                            'error' => 1,
                            'msj' => 'No Result Found',
                        );
                    }
                } else {
                    $json['error_code'] = array(
                        'error' => 1,
                        'msj' => 'no address selected',
                    );
                }
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'No Data Found',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'failed to get data',
            );
        }

        return $json;
    }

    public function setStore() {

        $this->load->model('android/brewing/brewing');

        $herbal_request_id = isset($this->request->get['herbal_request_id']) ? $this->request->get['herbal_request_id'] : false;
        $store_id = isset($this->request->get['store_id']) ? $this->request->get['store_id'] : false;

        if (!($herbal_request_id && $store_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_request_id && $store_id) {

            $herbal_request_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $decoded_customer_data = json_decode($herbal_request_info['data'], true);

            if ($decoded_customer_data['address'] != NULL) {
                $etcm_url = HTTP_API . 'index.php?route=etcm/brewing/store/setShippingPaymentMethodForSetStore';

                $prescription = $decoded_customer_data['prescription'];

                $brewing_type_id = $decoded_customer_data['brewingtype'];

                $post_data = [
                    'store_id' => $store_id,
                    'customer_address' => $decoded_customer_data['address'],
                    'product' => $decoded_customer_data['product'],
                    'hosting' => HTTPS_SERVER,
                    'dosage' => !empty($prescription['dosage']) ? $prescription['dosage'] : '',
                    'daily_take' => !empty($prescription['daily_take']) ? $prescription['daily_take'] : '',
                    'volume' => !empty($prescription['volume']) ? $prescription['volume'] : '',
                    'brewing_type_id' => $brewing_type_id
                ];

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $etcm_url);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                $result = curl_exec($ch);

                curl_close($ch);

                $final_result = json_decode($result, true);

                $this->setDefaultPaymentMethod();

                $store_list = $this->getStoreList($store_id);

                foreach ($store_list['store_list'] as $store_list_detail) {
                    if ($store_list_detail['store_id'] == $store_id) {
                        $decoded_customer_data['selected_store'] = [
                            'store_id' => $store_list_detail['store_id'],
                            'store_name' => $store_list_detail['store_name']
                        ];
                    }
                }

                $decoded_customer_data['product'] = $final_result['product'];

                $decoded_customer_data['total'] = $final_result['total_data'];

                $decoded_customer_data['shipping_method'] = $final_result['shipping_method'];

                if (!empty($final_result['total_data'])) {
                    foreach ($final_result['total_data'] as $total) {
                        if ($total['sort_order'] == 9) {
                            $total_amount = $total['value'];
                        }
                    }
                }

                $decoded_customer_data['enable_credit'] = 0;

                if (!empty($decoded_customer_data['total'])) {
                    foreach ($decoded_customer_data['total'] as $total_arr) {
                        if ($total_arr['sort_order'] == 7) {
                            $decoded_customer_data['enable_credit'] = 1;
                        }
                    }
                }

                $post_data2 = [
                    'customer_address' => $decoded_customer_data['address'],
                    'hosting' => HTTPS_SERVER,
                    'total' => $decoded_customer_data['total'],
                    'enable_credit' => $decoded_customer_data['enable_credit']
                ];

                $store_list = HTTP_API . 'index.php?route=etcm/brewing/store/getPaymentMethod2';

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_HEADER, false);
                curl_setopt($ch, CURLINFO_HEADER_OUT, true);
                curl_setopt($ch, CURLOPT_URL, $store_list);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data2));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                $result2 = curl_exec($ch);

                curl_close($ch);

                $final_result2 = json_decode($result2, true);

                $payment_methods = $final_result2;

                if ($total_amount == 0) {
                    if (!empty($payment_methods['data'])) {
                        foreach ($payment_methods['data'] as $payment_method) {
                            if ($payment_method['code'] == 'free_checkout') {
                                $decoded_customer_data['payment_method'] = $payment_method;
                            }
                        }
                    }
                }

                $decoded_customer_data['total_product_weight'] = [];

                $decoded_customer_data['total_product_weight'] = !empty($final_result['total_product_weight']) ? $final_result['total_product_weight'] : '';

                $customer_data = json_encode($decoded_customer_data);

                if ($customer_data && $herbal_request_id) {
                    $this->model_android_brewing_product->updateHerbalRequestData($customer_data, $herbal_request_id, $total_amount);

                    $json['error_code'] = array(
                        'error' => 0,
                        'msj' => 'Successful selected store'
                    );
                } else {
                    $json['error_code'] = array(
                        'error' => 1,
                        'msj' => 'failed to select store',
                    );
                }
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'no address selected',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'failed to post data',
            );
        }

        return $json;
    }

    public function get_bank_transfer_instruction($language) {
        $post_data = [];
        $return_data = [];

        $api_url = HTTP_API . 'index.php?route=etcm/wholesale/get_wholesaler_bank_transfer_instruction';

        $post_data = [
            'language' => $language,
            'hosting' => HTTPS_SERVER
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        $result_arr = json_decode($result, true);

        if ($result_arr['error'] == '0') {
            $return_data = $result_arr['data'];
        }

        return $return_data;
    }

    public function get_fpx_details($payment_method, $is_placed_order = false) {
        $post_data = [];
        $return_data = [];

        if ($calling_api) {
            $api_url = HTTP_API . 'index.php?route=etcm/wholesale/get_ipay_fpx_details';

            $post_data = [
                'payment_method' => $payment_method,
                'hosting' => HTTPS_SERVER
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            curl_close($ch);

            $result_arr = json_decode($result, true);

            if ($result_arr['error'] == '0') {
                $return_data = $result_arr['data'];
            }
        }

        return $return_data;
    }

    public function get_visamaster_details($is_placed_order = false) {
        $post_data = [];
        $return_data = [];

        if ($calling_api) {
            $api_url = HTTP_API . 'index.php?route=etcm/wholesale/get_ipay_visamaster_details';

            $post_data = [
                'hosting' => HTTPS_SERVER
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            curl_close($ch);

            $result_arr = json_decode($result, true);

            if ($result_arr['error'] == '0') {
                $return_data = $result_arr['data'];
            }
        }

        return $return_data;
    }

    public function getShippingMethodSelection() {
        $this->load->model('android/brewing/product');

        $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
        $store_id = isset($this->request->post['store_id']) ? $this->request->post['store_id'] : false;

        if (!($herbal_request_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_request_id) {
            $herbal_info = $this->model_android_brewing_product->getDetails($herbal_request_id);

            $decode_data = json_decode($herbal_info, true);

            $customer_data = $decode_data;

            $json['products'] = [];

            if (!empty($customer_data['product'])) {
                foreach ($customer_data['product'] as $product_list) {
                    $json['products'][] = [
                        'product_id' => $product_list['product_id'],
                        'quantity' => $product_list['quantity']
                    ];
                }
            }

            $prescription = $customer_data['prescription'];

            $post_data = [
                'product' => $json['products'],
                'brewingtype' => $customer_data['brewingtype'],
                'customer_address' => $customer_data['address'],
                'store_id' => $store_id,
                'dosage' => !empty($prescription['dosage']) ? $prescription['dosage'] : '',
                'daily_take' => !empty($prescription['daily_take']) ? $prescription['daily_take'] : '',
                'volume' => !empty($prescription['volume']) ? $prescription['volume'] : '',
            ];

            $store_list = HTTP_API . 'index.php?route=etcm/brewing/store/getShippingChargesSelection';

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_URL, $store_list);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

//            echo '<pre>';
//            print_r($result);
//            echo '</pre>';

            curl_close($ch);

            $final_result = json_decode($result, true);
        }

        if (!empty($final_result)) {

            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'Get Store List Success',
            );
        } else {

            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'No Result Found',
            );
        }

        return $final_result;
    }

    public function getShippingMethodSelectionWithSeller() {
        $this->load->model('android/brewing/product');

        $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
        $store_id = isset($this->request->post['store_id']) ? $this->request->post['store_id'] : false;

        if (!($herbal_request_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_request_id) {
            $herbal_info = $this->model_android_brewing_product->getDetails($herbal_request_id);

            $decode_data = json_decode($herbal_info, true);

            $customer_data = $decode_data;

            $json['products'] = [];

            if (!empty($customer_data['product'])) {
                foreach ($customer_data['product'] as $product_list) {
                    $json['products'][] = [
                        'product_id' => $product_list['product_id'],
                        'quantity' => $product_list['quantity']
                    ];
                }
            }

            $prescription = $customer_data['prescription'];

            $post_data = [
                'product' => $json['products'],
                'brewingtype' => $customer_data['brewingtype'],
                'customer_address' => $customer_data['address'],
                'store_id' => $store_id,
                'dosage' => !empty($prescription['dosage']) ? $prescription['dosage'] : '',
                'daily_take' => !empty($prescription['daily_take']) ? $prescription['daily_take'] : '',
                'volume' => !empty($prescription['volume']) ? $prescription['volume'] : ''
            ];

            $store_list = HTTP_API . 'index.php?route=etcm/brewing/store/getShippingChargesSelectionWithSeller';

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_URL, $store_list);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);
//
//            echo '<pre>';
//            print_r($result);
//            echo '</pre>';

            curl_close($ch);

            $final_result = json_decode($result, true);
        }

        if (!empty($final_result)) {

            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'Get Store List Success',
            );
        } else {

            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'No Result Found',
            );
        }

        return $final_result;
    }

    public function setShippingMethod() {
        $this->load->model('android/brewing/brewing');
        $this->load->model('android/brewing/product');

        $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
        $store_id = isset($this->request->post['store_id']) ? $this->request->post['store_id'] : false;
        $code = isset($this->request->post['code']) ? $this->request->post['code'] : false;

        if (!($herbal_request_id && $store_id && $code)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_request_id && $store_id && $code) {
            $herbal_request_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $decoded_customer_data = json_decode($herbal_request_info['data'], true);

            $shipping_methods = $this->getShippingMethodSelection();

            $prescription = $decoded_customer_data['prescription'];

            $brewing_type_id = $decoded_customer_data['brewingtype'];

            foreach ($shipping_methods['shipping_charges'] as $shipping_method) {

                if ($shipping_method['code'] == $code) {
                    $selected_shipping_method = [
                        'title' => $shipping_method['title'],
                        'code' => $shipping_method['code'],
                        'sort_order' => $shipping_method['sort_order'],
                        'cost' => $shipping_method['cost'],
                        'value' => $shipping_method['value'],
                        'tax_class_id' => $shipping_method['tax_class_id'],
                        'text' => $shipping_method['text'],
                        'error' => $shipping_method['error']
                    ];
                }
            }

            $etcm_url = HTTP_API . 'index.php?route=etcm/brewing/store/setShippingMethodForCheckout';

            $post_data = [
                'shipping_method' => $selected_shipping_method,
                'customer_address' => $decoded_customer_data['address'],
                'product' => $decoded_customer_data['product'],
                'store_id' => $store_id,
                'hosting' => HTTPS_SERVER,
                'dosage' => !empty($prescription['dosage']) ? $prescription['dosage'] : '',
                'daily_take' => !empty($prescription['daily_take']) ? $prescription['daily_take'] : '',
                'volume' => !empty($prescription['volume']) ? $prescription['volume'] : '',
                'brewing_type_id' => $brewing_type_id,
                'enable_credit' => $decoded_customer_data['enable_credit']
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $etcm_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            curl_close($ch);

            $final_result = json_decode($result, true);

            $decoded_customer_data['product'] = $final_result['product'];

            $decoded_customer_data['total'] = $final_result['total_data'];

            $decoded_customer_data['shipping_method'] = $selected_shipping_method;

            foreach ($final_result['total_data'] as $total_data) {
                if ($total_data['code'] == 'total') {
                    $total_value = $total_data['value'];
                }
            }

            $post_data = [
                'hosting' => HTTPS_SERVER
            ];

            $store_list = HTTP_API . 'index.php?route=etcm/brewing/brewing/getCreditLimit';

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_URL, $store_list);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            curl_close($ch);

            $final_result = json_decode($result, true);

            $decoded_customer_data['credit_balance'] = !empty($final_result['credit_limit']) ? $final_result['credit_limit'] : '';

            $credit_balance_2 = 0;

            if ($decoded_customer_data['credit_balance'] != 0) {
                $credit_balance_format = number_format($decoded_customer_data['credit_balance'], 2, '.', '');

                $credit_balance_2 = $credit_balance_format;
            } else {
                $credit_balance_2 = 0;
            }

            if ($decoded_customer_data['credit_balance'] > 0) {
                $decoded_customer_data['enable_credit'] = 1;
            } else {
                $decoded_customer_data['enable_credit'] = 0;
            }

            $customer_data = json_encode($decoded_customer_data);

            if (!empty($customer_data && $herbal_request_id)) {
                $this->model_android_brewing_product->updateHerbalRequestDetail($customer_data, $herbal_request_id, $total_value);

                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'Successful set shipping method'
                );
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'Failed to set shipping method',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'Failed to post data',
            );
        }

        return $json;
    }

    public function getPaymentMethod() {
        $this->load->model('android/brewing/product');

        $herbal_request_id = isset($this->request->get['herbal_request_id']) ? $this->request->get['herbal_request_id'] : false;

        if (!($herbal_request_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_request_id) {
            $herbal_info = $this->model_android_brewing_product->getDetails($herbal_request_id);

            $decode_data = json_decode($herbal_info, true);

            $customer_data = $decode_data;

            $enable_credit = !empty($customer_data['enable_credit']) ? $customer_data['enable_credit'] : 0;

            $total_data = $customer_data['total'];

            $post_data = [
                'customer_address' => $customer_data['address'],
                'hosting' => HTTPS_SERVER,
                'total' => $total_data,
                'enable_credit' => $enable_credit
            ];

            $store_list = HTTP_API . 'index.php?route=etcm/brewing/store/getPaymentMethod';

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_URL, $store_list);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            curl_close($ch);

            $final_result = json_decode($result, true);
        }

        if (!empty($final_result)) {

            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'Get Store List Success',
            );
        } else {

            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'No Result Found',
            );
        }

        return $final_result;
    }

    public function getChildPaymentMethod() {
        $this->load->model('android/brewing/product');

        $herbal_request_id = isset($this->request->get['herbal_request_id']) ? $this->request->get['herbal_request_id'] : false;

        if (!($herbal_request_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if (isset($herbal_request_id)) {

            $herbal_info = $this->model_android_brewing_product->getDetails($herbal_request_id);

            $decode_data = json_decode($herbal_info, true);

            $customer_data = $decode_data;

            if (!empty($customer_data['total'])) {
                foreach ($customer_data['total'] as $total) {
                    if ($total['sort_order'] == 9) {
                        $total_value = $total['value'];
                    }
                }
            }

            $post_data = [
                'customer_address' => $customer_data['address'],
                'total' => $total_value
            ];

            $store_list = HTTP_API . 'index.php?route=etcm/brewing/store/getChildPaymentMethod';

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_URL, $store_list);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            curl_close($ch);

            $final_result = json_decode($result, true);

            if ($final_result['error'] == '0') {
                $fpx_payment_method_returns = $final_result['data'];
                $json['data'] = $fpx_payment_method_returns;

                $json['error_code'] = [
                    'error' => 0,
                    'msj' => 'get child payment method success'
                ];
            } else {
                $json['error_code'] = [
                    'error' => 1,
                    'msj' => 'api not response'
                ];
            }
        } else {
            $json['error_code'] = [
                'error' => 1,
                'msj' => 'cannot get post data'
            ];
        }

        return $json;
    }

    public function setPaymentMethod() {
        $this->load->model('android/brewing/brewing');
        $this->load->model('android/brewing/product');

        if (isset($this->request->post)) {
            $herbal_request_id = isset($this->request->get['herbal_request_id']) ? $this->request->get['herbal_request_id'] : false;
            $payment_method_code = isset($this->request->get['payment_method_code']) ? $this->request->get['payment_method_code'] : false;

            if (!($herbal_request_id && $payment_method_code)) {
                $json['error_code'] = array(
                    'error' => 1,
                    'code' => 1001,
                    'msj' => 'Missing Parameter'
                );

                return $json;
            }

            if ($herbal_request_id && $payment_method_code) {
                $herbal_request_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

                $decoded_customer_data = json_decode($herbal_request_info['data'], true);

                foreach ($decoded_customer_data['total'] as $total) {
                    if ($total['code'] == 'total') {
                        $total_value = $total['value'];
                    }
                }

                if ($total_value == 0) {
                    $payment_method = $this->getPaymentMethod();

                    if (!empty($payment_method['data'])) {
                        foreach ($payment_method['data'] as $payments) {
                            if ($payments['code'] == $payment_method_code) {
                                $decoded_customer_data['payment_method'] = $payments;
                            }
                        }
                    }
                } else {
                    $payment_method = $this->getChildPaymentMethod();

                    if (!empty($payment_method['data'])) {
                        foreach ($payment_method['data'] as $payments) {
                            if ($payments['code'] == $payment_method_code) {
                                $decoded_customer_data['payment_method'] = $payments;
                            }
                        }
                    }
                }

                $customer_data = json_encode($decoded_customer_data);

                if ($customer_data && $herbal_request_id) {
                    $this->model_android_brewing_product->updateProductCartToHerbalRequest($customer_data, $herbal_request_id);

                    $json['error_code'] = array(
                        'error' => 0,
                        'msj' => 'Successful set payment method'
                    );
                } else {
                    $json['error_code'] = array(
                        'error' => 1,
                        'msj' => 'Failed to set payment method',
                    );
                }
            }
        } else {
            $json['error_code'] = [
                'error' => 1,
                'msj' => 'cannot get post data'
            ];
        }

        return $json;
    }

    public function setDefaultPaymentMethod() {
        $this->load->model('android/brewing/brewing');
        $this->load->model('android/brewing/product');

        if (isset($this->request->post)) {
            $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;

            $latest_order_payment_code = (string) $this->getOrderPaymentByCustomer();

            if ($herbal_request_id) {
                $herbal_request_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

                $decoded_customer_data = json_decode($herbal_request_info['data'], true);

                $payment_methods = $this->getChildPaymentMethod();

                $decoded_customer_data['payment_method'] = [];

                if (!empty($latest_order_payment_code)) {
                    foreach ($payment_methods['data'] as $payment_method) {
                        if ((string) $payment_method['code'] == (string) $latest_order_payment_code) {
                            $decoded_customer_data['payment_method'] = [
                                'title' => $payment_method['title'],
                                'code' => $payment_method['code'],
                                'terms' => $payment_method['terms'],
                                'sort_order' => $payment_method['sort_order'],
                                'image' => $payment_method['image']
                            ];
                        }
                    }
                }

                $customer_data = json_encode($decoded_customer_data);

                $this->model_android_brewing_product->updateHerbalRequest($customer_data, $herbal_request_id);
            }
        } else {
            $json['error_code'] = [
                'error' => 1,
                'msj' => 'api not response'
            ];
        }
    }

    private function getOrderPaymentByCustomer() {
        $this->load->model('android/brewing/product');

        $post_data = [
            'hosting' => HTTPS_SERVER
        ];

        $store_list = HTTP_API . 'index.php?route=etcm/brewing/store/getOrderPaymentByCustomer';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_URL, $store_list);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        $final_result = json_decode($result, true);

        $order_latest_payment_method = $final_result['payment_method'];

        return $order_latest_payment_method;
    }

    public function setPayByCredit() {
        $this->load->model('android/brewing/brewing');
        $this->load->model('android/brewing/product');

        $herbal_request_id = isset($this->request->get['herbal_request_id']) ? $this->request->get['herbal_request_id'] : false;

        if (!($herbal_request_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_request_id) {
            $herbal_request_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $decoded_customer_data = !empty($herbal_request_info) ? json_decode($herbal_request_info['data'], true) : '';

            $store_data = $decoded_customer_data['selected_store'];

            $prescription = $decoded_customer_data['prescription'];

            $brewing_type_id = $decoded_customer_data['brewingtype'];

            $store_id = $store_data['store_id'];

            if (!empty($decoded_customer_data['total'])) {
                foreach ($decoded_customer_data['total'] as $total) {
                    if ($total['sort_order'] == 9) {
                        $total_value = $total['value'];
                    }
                }
            }

            $post_data = [
                'herbal_request_id' => $herbal_request_id,
                'hosting' => HTTPS_SERVER,
                'total' => $total_value,
                'product' => $decoded_customer_data['product'],
                'address' => $decoded_customer_data['address'],
                'store_id' => $store_id,
                'shipping_method' => $decoded_customer_data['shipping_method'],
                'dosage' => !empty($prescription['dosage']) ? $prescription['dosage'] : '',
                'daily_take' => !empty($prescription['daily_take']) ? $prescription['daily_take'] : '',
                'volume' => !empty($prescription['volume']) ? $prescription['volume'] : '',
                'brewing_type_id' => $brewing_type_id
            ];

            $store_list = HTTP_API . 'index.php?route=etcm/brewing/store/setPayByCredit';

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_URL, $store_list);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            curl_close($ch);

            $final_result = json_decode($result, true);

            if ($final_result['credit_balance'] > 0) {
                $decoded_customer_data['total'] = $final_result['total_data'];

                foreach ($decoded_customer_data['total'] as $total) {
                    if ($total['code'] == 'total') {
                        $total_value = $total['value'];
                    }
                }

                $post_data2 = [
                    'customer_address' => $decoded_customer_data['address'],
                    'hosting' => HTTPS_SERVER,
                    'total' => $decoded_customer_data['total'],
                    'enable_credit' => $decoded_customer_data['enable_credit']
                ];

                $store_list = HTTP_API . 'index.php?route=etcm/brewing/store/getPaymentMethod2';

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_HEADER, false);
                curl_setopt($ch, CURLINFO_HEADER_OUT, true);
                curl_setopt($ch, CURLOPT_URL, $store_list);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data2));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                $result2 = curl_exec($ch);

                curl_close($ch);

                $final_result2 = json_decode($result2, true);

                $payment_methods = $final_result2;

                $selected_payment_method = [];

                if ($total_value == 0) {
                    foreach ($payment_methods['data'] as $payment_method) {
                        if ($payment_method['code'] == 'free_checkout') {
                            $decoded_customer_data['payment_method'] = $payment_method;

                            $selected_payment_method = !empty($payment_method) ? $payment_method : NULL;
                        }
                    }
                }

                $decoded_customer_data['credit_limit'] = $final_result['credit_balance'];

                $decoded_customer_data['enable_credit'] = 1;

                $customer_data = json_encode($decoded_customer_data);

                if ($customer_data && $herbal_request_id) {
                    $this->model_android_brewing_product->updateHerbalRequestData($customer_data, $herbal_request_id, $total_value);

                    $json['payment_method'] = $selected_payment_method;
                    $json['error_code'] = array(
                        'error' => 0,
                        'msj' => 'Successful set pay by credit'
                    );
                } else {
                    $json['error_code'] = array(
                        'error' => 1,
                        'msj' => 'Failed to set pay by credit',
                    );
                }
            } else {
                $decoded_customer_data['enable_credit'] = 0;

                $decoded_customer_data['credit_balance'] = '';

                $customer_data = json_encode($decoded_customer_data);

                $this->model_android_brewing_product->updateHerbalRequestData($customer_data, $herbal_request_id, $total_value);

                $json['error_code'] = [
                    'error' => 1,
                    'msj' => 'Your current credit is 0'
                ];
            }
        } else {
            $json['error_code'] = [
                'error' => 1,
                'msj' => 'Cannot get post data'
            ];
        }

        return $json;
    }

    public function unsetPayByCredit() {
        $this->load->model('android/brewing/brewing');
        $this->load->model('android/brewing/product');

        $herbal_request_id = isset($this->request->get['herbal_request_id']) ? $this->request->get['herbal_request_id'] : false;

        if (!($herbal_request_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_request_id) {
            $herbal_request_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $decoded_customer_data = !empty($herbal_request_info) ? json_decode($herbal_request_info['data'], true) : '';

            $store_data = $decoded_customer_data['selected_store'];

            $prescription = $decoded_customer_data['prescription'];

            $brewing_type_id = $decoded_customer_data['brewingtype'];

            $store_id = $store_data['store_id'];

            if (!empty($decoded_customer_data['total'])) {
                foreach ($decoded_customer_data['total'] as $total) {
                    if ($total['sort_order'] == 9) {
                        $total_value = $total['value'];
                    }
                }
            }

            $post_data = [
                'herbal_request_id' => $herbal_request_id,
                'hosting' => HTTPS_SERVER,
                'total' => $total_value,
                'product' => $decoded_customer_data['product'],
                'address' => $decoded_customer_data['address'],
                'store_id' => $store_id,
                'shipping_method' => $decoded_customer_data['shipping_method'],
                'dosage' => !empty($prescription['dosage']) ? $prescription['dosage'] : '',
                'daily_take' => !empty($prescription['daily_take']) ? $prescription['daily_take'] : '',
                'volume' => !empty($prescription['volume']) ? $prescription['volume'] : '',
                'brewing_type_id' => $brewing_type_id
            ];

            $store_list = HTTP_API . 'index.php?route=etcm/brewing/store/unsetPayByCredit';

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_URL, $store_list);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            curl_close($ch);

            $final_result = json_decode($result, true);

            $decoded_customer_data['total'] = $final_result['total_data'];

            foreach ($decoded_customer_data['total'] as $total) {
                if ($total['sort_order'] == 9) {
                    $total_value = $total['value'];
                }
            }

            $decoded_customer_data['payment_method'] = NULL;

            $decoded_customer_data['enable_credit'] = 0;

            $customer_data = json_encode($decoded_customer_data);

            $unset_pay_by_credit = $this->model_android_brewing_product->updateHerbalRequestData($customer_data, $herbal_request_id, $total_value);

            if ($unset_pay_by_credit == 0) {
                $json['payment_method'] = NULL;
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'Successful unset pay by credit'
                );
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'Failed to unset pay by credit',
                );
            }
        } else {
            $json['error_code'] = [
                'error' => 1,
                'msj' => 'Cannot get post data'
            ];
        }

        return $json;
    }

}
