<?php

class ControllerAndroidBrewingSellerOrder extends Controller {

    private $app_hash;
    private $call_back;
    private $call_function;
    private $currency;
    private $currency_code;
    private $hash;
    private $is_ver20;
    private $push_currency_code;
    private $store_id;
    private $s;
    private $opencart_version;
    private $post_data;

    const MODULE_CODE = 16;
    const MODULE_VERSION = '1.1.11';
    const DEBUG_MODE = false;
    const MOB_ASSIST_API_KEY = 'AIzaSyDIq4agB70Zv7AkB9pVuF2KxcU4WQ94CVI';

    public function index() {
        @date_default_timezone_get('UTC');
        $this->check_version();

        $this->load->model('android/setting');
        $this->load->model('android/connector');
        $this->load->model('android/brewing_quotation_api');
        $this->load->model('android/customer');

        $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');
        $this->config->set('config_language_id', $this->model_android_brewing_quotation_api->getlangugeId());

        if (!isset($this->s['andassist_status'])) {
            $data['error_code'] = [
                'error' => -1,
                'msj' => 'API disabled',
                'app_hash' => $this->app_hash
            ];
            return $this->generate_output($data);
        }

        $post = $this->request->post;
        $request = $this->request->request;

        if (isset($request['call_back']) && strlen($request['call_back']) > 0) {
            $this->call_back = $request['call_back'];
        }

        if (isset($request['call_function']) && strlen($request['call_function']) > 0) {
            $this->call_function = $request['call_function'];
        }

        if (isset($request['hash']) && strlen($request['hash']) > 0) {
            $this->hash = $request['hash'];
        }

        if (isset($request['app_hash']) && strlen($request['app_hash']) > 0) {
            $this->app_hash = $request['app_hash'];
        }

        if (empty($this->call_function)) {
            $this->run_self_test();
        }

        if (!$this->check_confing()) {
            $data['error_code'] = [
                'error' => -1,
                'msj' => 'API disable',
                'app_hash' => $this->app_hash
            ];
            return $this->generate_output($data);
        }

        if (!$this->check_auth()) {
            $data['error_code'] = [
                'error' => -2,
                'msj' => 'Password Not Match',
            ];
            return $this->generate_output($data);
        }

        if ($this->call_function == 'test_config') {
            return $this->generate_output(array('test' => 1));
        }

        $params = $this->_validate_types($request, array());

        foreach ($params as $k => $value) {
            $this->{$k} = $value;
        }

        $this->post_data = $post;

        foreach ($this->post_data as $k => $value) {
            $this->{$k} = $value;
        }

        if (empty($this->currency_code) || $this->currency_code == 'not_set') {
            $this->currency = '';
        } else if ($this->currency_code == 'base_currency') {
            $this->currency = $this->config->get('config_currency');
        } else {
            $this->currency = $this->currency_code;
        }

        print_r($this->currency_code);

        if (empty($this->push_currency_code) || $this->push_currency_code == 'not_set') {
            $this->push_currency_code = '';
        }

        if ($this->store_id == '') {
            $this->store_id = -1;
        }

        $this->store_id = intval($this->store_id);

        if (!method_exists($this, $this->call_function)) {
            return $this->generate_output('old_module');
        }

        $result = call_user_func(array($this, $this->call_function));
        return $this->generate_output($result);
    }

    private function check_version() {
        if (class_exists('MijoShop')) {
            $base = MijoShop::get('base');

            $installed_ms_version = (array) $base->getMijoshopVersion();
            $mijo_version = $installed_ms_version[0];
            if (version_compare($mijo_version, '3.0.0', '>=') && version_compare(VERSION, '2.0.0.0', '<')) {
                $this->opencart_version = '2.0.1.0';
            } else {
                $this->opencart_version = VERSION;
            }
        } else {
            $this->opencart_version = VERSION;
        }
        $this->is_ver20 = version_compare($this->opencart_version, '2.0.0', '>=');
    }

    private function run_self_test() {
        $html = '<h2>Mobile Assistant Connector Self Test Tool</h2>'
                . '<div style="padding: 5px; margin: 10px 0;">This tool checks your website to make sure there are no issues in your hosting configuration.<br />Your hosting support can solve all issues found here.</div><br/>'
                . '<table cellpadding=4><tr><th>Test Title</th><th>Result</th></tr>'
                . '<tr><td>Module Version</td><td>' . self::MODULE_VERSION . '</td><td></td></tr>'
                . '<tr><td>Cart Version</td><td>' . $this->opencart_version . '</td><td></td></tr>';

        if (class_exists('MijoShop')) {
            $base = MijoShop::get('base');

            $installed_ms_version = (array) $base->getMijoshopVersion();
            $mijo_version = $installed_ms_version[0];

            $html .= '<tr><td>MijoShop Version</td><td>' . $mijo_version . '</td><td></td></tr>';
            $html .= '<tr><td>MijoShop Opencart Version</td><td>' . VERSION . '</td><td></td></tr>';
        }

        $html .= '<tr><td>Default Login and Password Changed</td><td>'
                . (($res = $this->test_default_password_is_changed()) ? '<span style="color: #008000;">Yes</span>' : '<span style="color: #ff0000;">Fail</span>') . '</td>';

        if (!$res) {
            $html .= '<td>Change your login credentials in Mobile Assistant Connector to make your connection secure</td>';
        }

        $html .= '</table><br/>'
                . '<div style="margin-top: 15px; font-size: 13px;">Mobile Assistant Connector by <a href="http://emagicone.com" target="_blank" style="color: #15428B">eMagicOne</a></div>';

        die($html);
    }

    private function check_confing() {
        $this->load->model('android/brewing_quotation_api');
        $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');

        if (isset($this->request->request['app_hash'])) {
            if (md5($this->s['andassist_login'] . $this->s['andassist_pass']) == $this->request->request['app_hash'] && $this->s['andassist_status'] == 1) {
                return true;
            }
        }
        return false; //return true or false only can be one, either one return, the other one will stop.
    }

    private function check_auth() {
        $userColData = $this->revers_base64($this->hash);
        $user_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE username = '" . $this->db->escape($userColData['user_name']) . "' AND (password = SHA1(CONCAT(salt, SHA1(CONCAT(salt, SHA1('" . $this->db->escape($userColData['password']) . "'))))) OR password = '" . $this->db->escape(md5($userColData['password'])) . "') AND status = 1 AND position = '2'");
        if ($user_query->num_rows) {
            $store_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_to_store s LEFT JOIN " . DB_PREFIX . "setting l ON (s.store_id = l.store_id) WHERE s.user_id = '" . (int) $user_query->row['user_id'] . "' AND s.store_id = '" . $userColData['store_id'] . "' AND l.key = 'config_language'");
            if ($store_query->num_rows) {
                if (strtotime($user_query->row['periodto']) > strtotime(date("Y-m-d"))) {
                    return true;
                } else {
                    return false;
                }
            }
        }
        return false;
    }

    private function revers_base64($data) {
        $user_info = base64_decode($data);
        $userColData = json_decode($user_info, true);
        return $userColData;
    }

    private function _validate_types($array, $names) {
        foreach ($names as $name => $type) {
            if (isset($array["$name"])) {
                switch ($type) {
                    case 'INT':
                        $array["$name"] = intval($array["$name"]);
                        break;
                    case 'FLOAT':
                        $array["$name"] = floatval($array["$name"]);
                        break;
                    case 'STR':
                        $array["$name"] = str_replace(array("\r", "\n"), ' ', addslashes(htmlspecialchars(trim(url_encode($array["$name"])))));
                        break;
                    default:
                        $array["$name"] = '';
                }
            } else {
                $array["$name"] = '';
            }
        }
        return $array;
    }

    private function generate_output($data) {
        $add_bridge_version = false;

        if (in_array($this->call_function, array("test_config", "get_store_title", "get_store_stats", "get_data_graphs"))) {
            if (is_array($data) && $data != 'auth_error' && $data != 'connection_error' && $data != 'old_bridge') {
                $add_bridge_version = true;
            }
        }

        if (!is_array($data)) {
            $data = array($data);
        }

        if ($add_bridge_version) {
            $data['module_version'] = self::MODULE_CODE;
        }

        if (is_array($data)) {
            //array_walk_recursive($data, array($this, 'reset_null'));
        }

        $data = json_encode($data);

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput($data);
    }

    public function setOutput($output) {
        $this->output = $output;
    }

    public function setHeader($header) {
        $this->headers = array();
        if (is_array($header)) {
            foreach ($header as $h)
                $this->headers[] = $h;
        } else {
            $this->headers[] = $header;
        }
    }

    private function reset_null(&$item) {
        if (empty($item) && $item != 0) {
            $item = '';
        }

        // $item = trim($item);

        $item = $item;
    }

    private function curl($data, $path) {
        $hash = $this->config->get('etcm_hash');

        $curl = curl_init();

        // Set SSL if required
        if (substr(HTTP_API, 0, 5) == 'https') {
            curl_setopt($curl, CURLOPT_PORT, 443);
        }

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_FORBID_REUSE, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_URL, HTTP_API . 'index.php?route=etcm/brewing/seller&hash=' . $hash . $path);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));

        $response = curl_exec($curl);

        $response_encode = json_decode($response, true);
        return $response_encode;
    }

    public function getBrewingOrderList() {
        $this->load->model('android/brewing/seller_order');

        $this->load->model('android/brewing/brewing');

        $this->load->library('currency');
        $this->currency = new Currency($this->registry);

        $json = [];

        $json['orders'] = [];

        $data['page'] = isset($this->request->get['page']) ? $this->request->get['page'] : false;
        $data['show'] = isset($this->request->get['show']) ? $this->request->get['show'] : $this->config->get('config_limit_admin');
        $data['search'] = isset($this->request->get['search']) ? $this->request->get['search'] : '';
        $data['order'] = isset($this->request->get['order']) ? $this->request->get['order'] : 'DESC';
        $data['sort_by'] = isset($this->request->get['sort_by']) ? $this->request->get['sort_by'] : 'invoice_no';

        if ($data['page'] !== null && !empty($data['page']) && $data['show'] !== null && !empty($data['show'])) {
            $data['page'] = ($data['page'] - 1) * $data['show'];
            $data['show'] = $data['show'];
        }

        $orders = $this->model_android_brewing_seller_order->getBrewingOrderList($data);

        if (!empty($orders)) {
            foreach ($orders as $order) {

                $order_status = $this->model_android_brewing_brewing->getOrderStatus($order['order_status_id']);

                $json['orders'][] = [
                    'herbal_order_id' => $order['herbal_order_id'],
                    'invoice_prefix' => $order['invoice_prefix'],
                    'customer_name' => $order['buyer_store_name'],
                    'email' => $order['buyer_store_email'],
                    'telephone' => '+60' . $order['buyer_store_phone'],
                    'total' => $this->currency->format($order['total'], $this->config->get('config_currency')),
                    'date_added' => date('Y-m-d', strtotime($order['date_added'])),
                    'paid_status' => 'Paid',
                    'status' => $order_status,
                    'invoice_no' => $order['invoice_no'],
                    'order_status_id' => $order['order_status_id']
                ];
            }
        }

        if (!empty($json['orders'])) {

            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'succes',
            );
        } else {

            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'No Result Found',
            );
        }

        return $json;
    }

    protected function getProducts($order_id) {
        $this->load->model('android/brewing/seller_order');
        $result = [];
        $products = $this->model_android_brewing_seller_order->getProducts($order_id);
        if (!empty($products)) {
            foreach ($products as $product) {
                $stock_text = empty($product['stock']) ? 'Stock not enough' : '';
                $available_text = empty($product['available']) ? 'No have this product' : '';

                $result[] = [
                    'product_id' => $product['product_id'],
                    'name' => $product['model'],
                    'code' => $product['code'],
                    'quantity' => $product['quantity'],
                    'weight' => (int) $product['weight'],
                    'weight_text' => $product['unit'],
                    'price' => $this->currency->format($product['price'], $this->config->get('config_currency')),
                    'tax' => $this->currency->format($product['tax'], $this->config->get('config_currency')),
                    'total' => $this->currency->format($product['total'], $this->config->get('config_currency')),
                    'stock' => $product['stock'],
                    'stock_text' => $stock_text,
                    'available' => $product['available'],
                    'available_text' => $available_text,
                ];
            }
        }
        return $result;
    }

    protected function getTotal($order_id) {
        $this->load->model('android/brewing/seller_order');
        $result = [];
        $totals = $this->model_android_brewing_seller_order->getTotal($order_id);
        if (!empty($totals)) {
            foreach ($totals as $total) {
                $result[] = [
                    'code' => $total['code'],
                    'title' => $total['title'],
                    'value' => $total['value'],
                    'value_text' => $this->currency->format($total['value'], $this->config->get('config_currency')),
                ];
            }
        }
        return $result;
    }

    public function getAvailableOrderStatus() {
        $herbal_order_id = isset($this->request->get['herbal_order_id']) ? $this->request->get['herbal_order_id'] : false;

        if (!($herbal_order_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_order_id) {
            $api_url = HTTP_API . 'index.php?route=etcm/brewing/brewing/getAvailableOrderStatus';

            $post_data = [];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            curl_close($ch);

            $result_arr = json_decode($result, true);

            $order_status_array = !empty($result_arr['order_status']) ? $result_arr['order_status'] : [];

            foreach ($order_status_array as $order_status_arr) {
                if ($order_status_arr['order_status_id'] == 3 || $order_status_arr['order_status_id'] == 5 || $order_status_arr['order_status_id'] == 7 || $order_status_arr['order_status_id'] == 15 || $order_status_arr['order_status_id'] == 25) {
                    $json['order_status'][] = [
                        'name' => $order_status_arr['name'],
                        'order_status_id' => $order_status_arr['order_status_id']
                    ];
                }
            }

            if (!empty($json['order_status'])) {
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'succes',
                );
            } else {

                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'No Result Found',
                );
            }
        }

        return $json;
    }

    public function updateHerbalOrderStatus() {
        $this->load->model('android/brewing/seller_order');

        $this->load->model('android/brewing/brewing');

        $herbal_order_id = isset($this->request->get['herbal_order_id']) ? $this->request->get['herbal_order_id'] : false;
        $order_status_id = isset($this->request->get['order_status_id']) ? $this->request->get['order_status_id'] : false;
        $remark = isset($this->request->get['remark']) ? $this->request->get['remark'] : false;

        if (!($herbal_order_id && $order_status_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_order_id && $order_status_id) {
            $herbal_order_info = $this->model_android_brewing_seller_order->getOrderDetails($herbal_order_id);

            $customer_name = !empty($herbal_order_info['shipping_firstname']) ? $herbal_order_info['shipping_firstname'] : '';

            if ($order_status_id == 15) {
                $shipped_status = 1;
            } else {
                $shipped_status = 0;
            }

            $this->model_android_brewing_seller_order->updateOrderStatus($order_status_id, $herbal_order_id, $remark, $shipped_status);

            $this->model_android_brewing_seller_order->saveRemarkIntoSeller($herbal_order_id, $remark, $order_status_id);

            $api_url = HTTP_API . 'index.php?route=etcm/brewing/brewing/getHerbalOrderStatusWithRemark';

            $post_data = [
                'herbal_request_id' => $herbal_order_info['buyer_herbal_request_id'],
                'hosting' => HTTP_SERVER,
                'order_status_id' => $order_status_id,
                'remark' => $remark,
                'shipped_status' => $shipped_status
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            curl_close($ch);

            $result_arr = json_decode($result, true);

            $order_status = $this->model_android_brewing_brewing->getOrderStatus($order_status_id);

            $user_info = $this->revers_base64($this->hash);

            $notification_template = $this->config->get('config_gcm_herbal_order_status');

            if ($notification_template['status'] == '1') {
                $template_title = $notification_template['title'];
                $template_message = $notification_template['message'];

                $find_title = array(
                    '{customer_name}'
                );

                $replace_title = array(
                    'customer_name' => $customer_name
                );

                $find_message = array(
                    '{invoice_prefix}',
                    '{order_status}'
                );

                $replace_message = array(
                    'invoice_prefix' => $herbal_order_info['invoice_prefix'],
                    'order_status' => $order_status
                );

                $notification_title = str_replace($find_title, $replace_title, $template_title);
                $notification_message = str_replace($find_message, $replace_message, $template_message);

                $notification_data = array(
                    'body' => $notification_title,
                    'badge' => 1,
                    'sound' => 'ping.aiff'
                );

                $data_gcm = array(
                    'title' => $notification_title,
                    'message' => $notification_message,
                    'user_id' => $user_info['user_id'],
                    'type' => 2
                );

                $doctor_device = $this->model_android_brewing_brewing->getDoctorDevice($user_info['user_id']);

                if (!empty($doctor_device)) {
                    $gcm = new GCM($this->registry);
                    $gcm->sendTo($gcm->get_user_token($user_info['user_id']))
                            ->setData($data_gcm)
                            ->setIosNotification($notification_data)
                            ->setContentAvailable(true)
                            ->send();
                }
            }

            $notification = new Notification($this->registry);

            $notification_data = [
                'herbal_request_id' => $herbal_order_id,
                'invoice_prefix' => $herbal_order_info['invoice_prefix'],
                'customer_name' => $customer_name,
                'order_status' => $order_status_id
            ];

            if (($notification->new_clinical_sale_notification_status == '1') && ($notification->notification_status == '1')) {
                $notification->add_notification('herbal_request_order_status_notification', $notification_data);
            }

            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'Sucessfully updated order status!',
            );
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'Failed to update order status!',
            );
        }

        return $json;
    }

    public function updateReceivedOrderStatus() {
        $this->load->model('android/brewing/seller_order');
        $this->load->model('android/brewing/brewing_order');
        $this->load->model('android/brewing/brewing');

        if (!empty($this->request->post)) {
            $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
            $buyer_store_id = isset($this->request->post['customer_id']) ? $this->request->post['customer_id'] : false;
            $order_status_id = isset($this->request->post['order_status_id']) ? $this->request->post['order_status_id'] : false;
            $remark = isset($this->request->post['remark']) ? $this->request->post['remark'] : false;

            $this->model_android_brewing_seller_order->completeStatusForSeller($herbal_request_id, $buyer_store_id, $order_status_id);

            $herbal_order_info = $this->model_android_brewing_brewing_order->getHerbalOrderInfoByRequest($herbal_request_id, $buyer_store_id);

            $this->model_android_brewing_seller_order->saveRemarkIntoSeller($herbal_order_info['herbal_order_id'], $remark, $order_status_id);

            $order_status = $this->model_android_brewing_brewing->getOrderStatus($order_status_id);

            $users_info = $this->model_android_brewing_brewing_order->getAllDoctors();

            $notification_template = $this->config->get('config_gcm_herbal_order_status');

            if ($notification_template['status'] == '1') {
                $template_title = $notification_template['title'];
                $template_message = $notification_template['message'];

                $find_title = array(
                    '{customer_name}'
                );

                $replace_title = array(
                    'customer_name' => $herbal_order_info['shipping_firstname']
                );

                $find_message = array(
                    '{invoice_prefix}',
                    '{order_status}'
                );

                $replace_message = array(
                    'invoice_prefix' => $herbal_order_info['invoice_prefix'],
                    'order_status' => $order_status
                );

                $notification_title = str_replace($find_title, $replace_title, $template_title);
                $notification_message = str_replace($find_message, $replace_message, $template_message);

                $notification_data = array(
                    'body' => $notification_title,
                    'badge' => 1,
                    'sound' => 'ping.aiff'
                );

                foreach ($users_info as $user_info) {
                    $data_gcm = array(
                        'title' => $notification_title,
                        'message' => $notification_message,
                        'user_id' => $user_info['user_id'],
                        'type' => 2
                    );

                    $doctor_device = $this->model_android_brewing_brewing->getDoctorDevice($user_info['user_id']);

                    if (!empty($doctor_device)) {
                        $gcm = new GCM($this->registry);
                        $gcm->sendTo($gcm->get_user_token($user_info['user_id']))
                                ->setData($data_gcm)
                                ->setIosNotification($notification_data)
                                ->setContentAvailable(true)
                                ->send();
                    }
                }

                $notification = new Notification($this->registry);

                $notification_data = [
                    'herbal_order_id' => $herbal_order_info['herbal_order_id'],
                    'invoice_prefix' => $herbal_order_info['invoice_prefix'],
                    'customer_name' => $herbal_order_info['shipping_firstname'],
                    'order_status' => $order_status
                ];

                if (($notification->new_clinical_sale_notification_status == '1') && ($notification->notification_status == '1')) {
                    $notification->add_notification('new_herbal_order_notification', $notification_data);
                }
            }
        }
    }

    public function updateStatusToShipped() {

        $this->load->model('android/brewing/seller_order');

        $this->load->model('android/brewing/brewing');

        $herbal_order_id = isset($this->request->get['herbal_order_id']) ? $this->request->get['herbal_order_id'] : false;
        $order_status_id = isset($this->request->get['order_status_id']) ? $this->request->get['order_status_id'] : false;
        $remark = isset($this->request->get['remark']) ? $this->request->get['remark'] : false;

        if (!($herbal_order_id && $order_status_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_order_id && $order_status_id) {
            $herbal_order_info = $this->model_android_brewing_seller_order->getOrderDetails($herbal_order_id);

            $customer_name = !empty($herbal_order_info['shipping_firstname']) ? $herbal_order_info['shipping_firstname'] : '';

            $this->model_android_brewing_seller_order->updateOrderStatusToShipped($order_status_id, $herbal_order_id, $remark);

            $this->model_android_brewing_seller_order->saveRemarkIntoSeller($herbal_order_id, $remark, $order_status_id);

            $api_url = HTTP_API . 'index.php?route=etcm/brewing/brewing/updateStatusToShipped';

            $post_data = [
                'herbal_request_id' => $herbal_order_info['buyer_herbal_request_id'],
                'hosting' => HTTP_SERVER,
                'order_status_id' => $order_status_id,
                'remark' => $remark
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            curl_close($ch);

            $result_arr = json_decode($result, true);

            $order_status = $this->model_android_brewing_brewing->getOrderStatus($order_status_id);

            $user_info = $this->revers_base64($this->hash);

            $notification_template = $this->config->get('config_gcm_herbal_order_status');

            if ($notification_template['status'] == '1') {
                $template_title = $notification_template['title'];
                $template_message = $notification_template['message'];

                $find_title = array(
                    '{customer_name}'
                );

                $replace_title = array(
                    'customer_name' => $customer_name
                );

                $find_message = array(
                    '{invoice_prefix}',
                    '{order_status}'
                );

                $replace_message = array(
                    'invoice_prefix' => $herbal_order_info['invoice_prefix'],
                    'order_status' => $order_status
                );

                $notification_title = str_replace($find_title, $replace_title, $template_title);
                $notification_message = str_replace($find_message, $replace_message, $template_message);

                $notification_data = array(
                    'body' => $notification_title,
                    'badge' => 1,
                    'sound' => 'ping.aiff'
                );

                $data_gcm = array(
                    'title' => $notification_title,
                    'message' => $notification_message,
                    'user_id' => $user_info['user_id'],
                    'type' => 2
                );

                $doctor_device = $this->model_android_brewing_brewing->getDoctorDevice($user_info['user_id']);

                if (!empty($doctor_device)) {
                    $gcm = new GCM($this->registry);
                    $gcm->sendTo($gcm->get_user_token($user_info['user_id']))
                            ->setData($data_gcm)
                            ->setIosNotification($notification_data)
                            ->setContentAvailable(true)
                            ->send();
                }
            }

            $notification = new Notification($this->registry);

            $notification_data = [
                'herbal_request_id' => $herbal_order_id,
                'invoice_prefix' => $herbal_order_info['invoice_prefix'],
                'customer_name' => $customer_name,
                'order_status' => $order_status_id
            ];

            if (($notification->new_clinical_sale_notification_status == '1') && ($notification->notification_status == '1')) {
                $notification->add_notification('herbal_request_order_status_notification', $notification_data);
            }

            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'Sucessfully updated order status to shipped!',
            );
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'Failed to update order status!',
            );
        }

        return $json;
    }

    private function getBrewingOrderDetails() {
        $this->load->model('android/brewing/seller_order');
        $this->load->library('currency');
        $this->currency = new Currency($this->registry);

        $json = [];

        $order_id = isset($this->request->get['order_id']) ? $this->request->get['order_id'] : false;

        if (empty($order_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'Empty Order ID !',
            );
        } else {
            $details = $this->model_android_brewing_seller_order->getOrderDetails($order_id);
            if (!empty($details)) {

                $post_data = [
                    'buyer_id' => $details['buyer_store_id']
                ];

                $store_list = HTTP_API . 'index.php?route=etcm/brewing/brewing/getBuyerImage';

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_HEADER, false);
                curl_setopt($ch, CURLINFO_HEADER_OUT, true);
                curl_setopt($ch, CURLOPT_URL, $store_list);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                $result = curl_exec($ch);

                curl_close($ch);

                $final_result = json_decode($result, true);

                $customer_hosting = $final_result['customer_hosting'];

                $post_data_buyer = [
                    'buyer_request_id' => $details['buyer_herbal_request_id']
                ];

                $buyer_hosting = $customer_hosting . 'index.php?route=android/brewing/brewing/getBuyerImage';

                $ch2 = curl_init();
                curl_setopt($ch2, CURLOPT_HEADER, false);
                curl_setopt($ch2, CURLINFO_HEADER_OUT, true);
                curl_setopt($ch2, CURLOPT_URL, $buyer_hosting);
                curl_setopt($ch2, CURLOPT_POST, true);
                curl_setopt($ch2, CURLOPT_POSTFIELDS, http_build_query($post_data_buyer));
                curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);

                $result2 = curl_exec($ch2);

                curl_close($ch2);

                $final_result2 = json_decode($result2, true);

                $json['order_id'] = $details['herbal_order_id'];
                $json['order_id_text'] = '#' . $details['herbal_order_id'];
                $json['invoice_prefix'] = $details['invoice_prefix'];
                $json['customer_name'] = $details['shipping_firstname'];
                $json['telephone'] = $details['buyer_store_phone'];
                $json['order_status_id'] = $details['order_status_id'];
                $json['order_status_text'] = ($details['order_status_id'] == 1) ? 'Pending' : 'Processed';
                $json['email'] = $details['buyer_store_email'];
                $payment_address = $details['payment_address_1'] . ' ' . $details['payment_address_2'] . ' ' . $details['payment_address_3'] . ' ' . $details['payment_postcode'] . ' ' . $details['payment_city'] . ' ' . $details['payment_zone'] . ' ' . $details['payment_country'];
                $json['payment_address'] = [
                    'customer' => $details['payment_firstname'] . $details['payment_lastname'],
                    'telephone' => '',
                    'address' => $payment_address
                ];
                $shipping_address = $details['shipping_address_1'] . ' ' . $details['shipping_address_2'] . ' ' . $details['shipping_address_3'] . ' ' . $details['shipping_postcode'] . ' ' . $details['shipping_city'] . ' ' . $details['shipping_zone'] . ' ' . $details['shipping_country'];
                $json['shipping_address'] = [
                    'customer' => $details['shipping_firstname'] . $details['shipping_lastname'],
                    'telephone' => '',
                    'address' => $shipping_address
                ];
                $json['payment_method'] = $details['payment_method'];
                $json['final_total'] = $details['total'];
                $json['final_total_text'] = $this->currency->format($details['total'], $this->config->get('config_currency'));
                $json['products'] = $this->getProducts($order_id);
                $json['total'] = $this->getTotal($order_id);
                $json['status'] = $details['status'];
                $json['shipped_status'] = $details['shipped_status'];
                $json['customer_image'] = !empty($final_result2['customer_image']) ? $final_result2['customer_image'] : [];

                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'succes',
                );
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'No Result Found !',
                );
            }
        }

        return $json;
    }

    private function updateOrderStatus() {
        $this->load->model('android/brewing/seller_order');

        $json = [];

        $order_id = isset($this->request->post['order_id']) ? $this->request->post['order_id'] : false;
        $status = isset($this->request->post['status']) ? $this->request->post['status'] : false;

        if (empty($order_id) || empty($status)) {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'Order ID and Status can be empty !',
            );
            $this->generate_output($json);
        } else {
            // write API to ETCM to update order status and the buyer order status
            // Email notification
            // Push notification
            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'succes',
            );
        }

        return $json;
    }

    public function getHerbalOrderRemark() {
        $this->load->model('android/brewing/seller_order');

        $this->load->model('android/brewing/brewing');

        $herbal_order_id = isset($this->request->get['herbal_order_id']) ? $this->request->get['herbal_order_id'] : false;

        if (!($herbal_order_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_order_id) {
            $herbal_order_remarks = $this->model_android_brewing_seller_order->getHerbalOrderRemark($herbal_order_id);

            $single_herbal_order_remark = $this->model_android_brewing_seller_order->getSingleHerbalOrderRemark($herbal_order_id);

            $json['herbal_order_remarks'] = [];

            foreach ($herbal_order_remarks as $herbal_order_remark) {

                $order_status_name = $this->model_android_brewing_brewing->getOrderStatus($herbal_order_remark['order_status_id']);

                if ($single_herbal_order_remark['herbal_order_remark_id'] == $herbal_order_remark['herbal_order_remark_id']) {
                    $json['herbal_order_remarks'][] = [
                        'herbal_order_remark_id' => $herbal_order_remark['herbal_order_remark_id'],
                        'remark' => !empty($herbal_order_remark['remark']) ? $herbal_order_remark['remark'] : '',
                        'order_status_name' => !empty($order_status_name) ? $order_status_name : '',
                        'date' => date('d M', strtotime($herbal_order_remark['date_added'])),
                        'time' => date('H:iA', (strtotime($herbal_order_remark['date_added']))),
                        'color' => 1,
                        'dot' => 1
                    ];
                } else {
                    $json['herbal_order_remarks'][] = [
                        'herbal_order_remark_id' => $herbal_order_remark['herbal_order_remark_id'],
                        'remark' => !empty($herbal_order_remark['remark']) ? $herbal_order_remark['remark'] : '',
                        'order_status_name' => !empty($order_status_name) ? $order_status_name : '',
                        'date' => date('d M', strtotime($herbal_order_remark['date_added'])),
                        'time' => date('H:iA', (strtotime($herbal_order_remark['date_added']))),
                        'color' => 0,
                        'dot' => 0
                    ];
                }

                $sort_order = [];

                foreach ($json['herbal_order_remarks'] as $key => $value) {
                    $sort_order[$key] = $value['herbal_order_remark_id'];
                }

                array_multisort($sort_order, SORT_DESC, $json['herbal_order_remarks']);
            }

            if (!empty($json['herbal_order_remarks'])) {
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'Successful get herbal order remarks'
                );
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'fail to get herbal order remarks',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'No Result Found',
            );
        }

        return $json;
    }

    public function getSingleHerbalOrderRemark() {
        $this->load->model('android/brewing/brewing');

        $this->load->model('android/brewing/seller_order');

        $herbal_order_id = isset($this->request->get['herbal_order_id']) ? $this->request->get['herbal_order_id'] : false;

        if (!($herbal_order_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_order_id) {
            $herbal_order_remark = $this->model_android_brewing_seller_order->getSingleHerbalOrderRemark($herbal_order_id);

            if ($herbal_order_remark) {
                $order_status_id = !empty($herbal_order_remark['order_status_id']) ? $herbal_order_remark['order_status_id'] : '';

                $json['herbal_order_remark'] = [];

                $order_status_name = $this->model_android_brewing_brewing->getOrderStatus($order_status_id);

                $json['herbal_order_remark'] = [
                    'herbal_order_remark_id' => $herbal_order_remark['herbal_order_remark_id'],
                    'remark' => !empty($herbal_order_remark['remark']) ? $herbal_order_remark['remark'] : '',
                    'order_status_name' => !empty($order_status_name) ? $order_status_name : '',
                    'date' => !empty($herbal_order_remark['date_added']) ? date($this->language->get('date_format_short'), strtotime($herbal_order_remark['date_added'])) : '',
                    'time' => !empty($herbal_order_remark['date_added']) ? date('h:i:sA', (strtotime($herbal_order_remark['date_added']))) : ''
                ];

                if (!empty($json['herbal_order_remark'])) {
                    $json['error_code'] = array(
                        'error' => 0,
                        'msj' => 'Successful get single herbal order remark'
                    );
                } else {
                    $json['error_code'] = array(
                        'error' => 1,
                        'msj' => 'fail to get single herbal order remark',
                    );
                }
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'No Result Found',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'Fail to get herbal order remark id',
            );
        }

        return $json;
    }

}
