<?php 
class ControllerAndroidBrewingProductApi extends Controller {
	private $app_hash;
	private $call_back;
	private $call_function;
	private $currency;
	private $currency_code;
	private $hash;
	private $is_ver20;
	private $push_currency_code;
	private $store_id;
	private $s;
	private $opencart_version;
	private $post_data;

	private $selected_store;
	private $selected_shipping_method;

	const MODULE_CODE    	   = 16;
	const MODULE_VERSION 	   = '1.1.11';
	const DEBUG_MODE           = false;
    const MOB_ASSIST_API_KEY   = 'AIzaSyDIq4agB70Zv7AkB9pVuF2KxcU4WQ94CVI';

    public function index() {
        @date_default_timezone_get('UTC');
            $this->check_version();
    
            $this->load->model('android/setting');
            $this->load->model('android/connector');
            $this->load->model('android/brewing_quotation_api');
    
            $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');
            $this->config->set('config_language_id', $this->model_android_brewing_quotation_api->getlangugeId());
    
            if (!isset($this->s['andassist_status'])) {
                $data['error_code'] = [
                    'error'     => -1,
                    'msj'       => 'API disabled',
                    'app_hash'  => $this->app_hash
                ];
                $this->generate_output($data);
            }
    
            $post    = $this->request->post; 
            $request = $this->request->request;
    
            if (isset($request['call_back']) && strlen($request['call_back']) > 0) {
                $this->call_back = $request['call_back'];
            }
    
            if (isset($request['call_function']) && strlen($request['call_function']) > 0) {
                $this->call_function = $request['call_function'];
            }
    
            if (isset($request['hash']) && strlen($request['hash']) > 0) {
                $this->hash = $request['hash'];
            }
    
            if (isset($request['app_hash']) && strlen($request['app_hash']) > 0) {
                $this->app_hash = $request['app_hash'];
            }
    
            if (empty($this->call_function)) {
                $this->run_self_test();
            }
    
            if (!$this->check_confing()) {
                $data['error_code'] = [
                    'error'    => -1,
                    'msj'      => 'API disable',
                    'app_hash' => $this->app_hash
                ];
                $this->generate_output($data);
            }
    
            if (!$this->check_auth()) {
                $data['error_code'] = [
                    'error' => -2,
                    'msj'   => 'Password Not Match',
                ];
                $this->generate_output($data);
            }
    
            if ($this->call_function == 'test_config') {
                $this->generate_output(array('test' => 1));
            }
    
            $params = $this->_validate_types($request, array(
    
            ));
    
            foreach ($params as $k => $value) {
                $this->{$k} = $value;
            }
    
            $this->post_data = $post;
    
            foreach ($this->post_data as $k => $value) {
                $this->{$k} = $value;
            }
    
            if (empty($this->currency_code) || $this->currency_code == 'not_set') {
                $this->currency = '';
            } else if ($this->currency_code == 'base_currency') {
                $this->currency = $this->config->get('config_currency');
            } else {
                $this->currency = $this->currency_code;
            }
    
            print_r($this->currency_code);
    
            if (empty($this->push_currency_code) || $this->push_currency_code == 'not_set') {
                $this->push_currency_code = '';
            }
    
            if ($this->store_id == '') {
                $this->store_id = -1;
            }
    
            $this->store_id = intval($this->store_id);
    
            if (!method_exists($this, $this->call_function)) {
                $this->generate_output('old_module');
            }
    
            $result = call_user_func(array($this, $this->call_function));
            $this->generate_output($result);
        }

        public function get_products_list(){
        $this->load->model('android/brewing/product');
    	$json = new StdClass;
		$data = new StdClass;
		if (!empty($this->request->get)) {
			foreach ($this->request->get as $g => $get) {
				$data->$g = $get;
			}
        }
        $data->language_id = isset($data->language) ? ($data->language == 'cn' ? 2 : 1 ) : $this->config->get('config_language_id');
		$data->pagination_entry  = !empty($data->pagination_entry) ? $data->pagination_entry : $this->config->get('config_limit_admin');
		$data->pagination_offset = !empty($data->pagination_offset) ? (($data->pagination_offset - 1) * $data->pagination_entry) : 0; 
        $results = json_decode(base64_decode($this->model_android_product->get_products_list($this->hashed($data))),true);
        
        if (!empty($results)) {
			$products = array();
			foreach ($results as $result) {
				$products[] = [
					'product_id'   => (int)$result['product_id'],
					'product_name' => $result['product_name'],
				];
			}
			$json->products_list = $products;
		} else {
			$json->error_msg   = 'No Results !';
			$json->error_code  =  1;
		}
    	return $json;
        }

        private function check_version() {
            if (class_exists('MijoShop')) {
                $base = MijoShop::get('base');
    
                $installed_ms_version = (array) $base->getMijoshopVersion();
                $mijo_version = $installed_ms_version[0];
                if (version_compare($mijo_version, '3.0.0', '>=') && version_compare(VERSION, '2.0.0.0', '<')) {
                    $this->opencart_version = '2.0.1.0';
                } else {
                    $this->opencart_version = VERSION;
                }
            } else {
                $this->opencart_version = VERSION;
            }
            $this->is_ver20 = version_compare($this->opencart_version, '2.0.0', '>=');
        }

        private function generate_output($data) {
            $add_bridge_version = false;
            if (in_array($this->call_function, array('test_config','generate_store_title','get_store_stats','get_data_graphs'))) {
                if (is_array($data) && $data != 'auth_error' && $data != 'connection_error' && $data != 'old_bridge') {
                    $add_bridge_version = true;
                }
            }
    
            /*if (!is_array($data)) {
                $data = array($data);
            }*/
    
            if ($add_bridge_version) {
                $data['module_version'] = self::MODULE_VERSION;
            }
    
            if (is_array($data)) {
                array_walk_recursive($data, array($this, 'reset_null'));
            }
    
            $data = json_encode($data);
    
            if ($this->call_back) {
                header('Content-Type: text/javascript;charset=utf-8');
                die($this->call_back . '(' . $data . ');');
            } else {
                header('Content-Type: text/javascript;charset=uft-8');
                die($data);
            }
        }

        private function run_self_test() {
            $html = '<h2>Mobile Assistant Connector Self Test Tool</h2>'
                . '<div style="padding: 5px; margin: 10px 0;">This tool checks your website to make sure there are no issues in your hosting configuration.<br />Your hosting support can solve all issues found here.</div><br/>'
                . '<table cellpadding=4><tr><th>Test Title</th><th>Result</th></tr>'
                . '<tr><td>Module Version</td><td>' . self::MODULE_VERSION . '</td><td></td></tr>'
                . '<tr><td>Cart Version</td><td>' . $this->opencart_version . '</td><td></td></tr>';
    
            if(class_exists('MijoShop')) {
                $base = MijoShop::get('base');
    
                $installed_ms_version = (array)$base->getMijoshopVersion();
                $mijo_version = $installed_ms_version[0];
    
                $html .= '<tr><td>MijoShop Version</td><td>' . $mijo_version . '</td><td></td></tr>';
                $html .= '<tr><td>MijoShop Opencart Version</td><td>' . VERSION . '</td><td></td></tr>';
            }
    
            $html .= '<tr><td>Default Login and Password Changed</td><td>'
                . (( $res = $this->test_default_password_is_changed() ) ? '<span style="color: #008000;">Yes</span>' : '<span style="color: #ff0000;">Fail</span>') . '</td>';
    
            if(!$res) {
                $html .= '<td>Change your login credentials in Mobile Assistant Connector to make your connection secure</td>';
            }
    
            $html .= '</table><br/>'
                . '<div style="margin-top: 15px; font-size: 13px;">Mobile Assistant Connector by <a href="http://emagicone.com" target="_blank" style="color: #15428B">eMagicOne</a></div>';
    
            die($html);
        }

        private function check_confing() {
            $this->load->model('android/brewing_quotation_api');
            $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');
    
            if (isset($this->request->request['app_hash'])) {
                if (md5($this->s['andassist_login'] . $this->s['andassist_pass']) == $this->request->request['app_hash'] && $this->s['andassist_status'] == 1) {
                    return true;
                }
            }
            return false;//return true or false only can be one, either one return, the other one will stop.
        }

        private function revers_base64($data){
            $user_info   = base64_decode($data);
            $userColData = json_decode($user_info, true);
            return $userColData;
        }

        private function check_auth() {
            $userColData = $this->revers_base64($this->hash);
            $user_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE username = '" . $this->db->escape($userColData['user_name']) . "' AND (password = SHA1(CONCAT(salt, SHA1(CONCAT(salt, SHA1('" . $this->db->escape($userColData['password']) . "'))))) OR password = '" . $this->db->escape(md5($userColData['password'])) . "') AND status = 1 AND position = '2'");
            if ($user_query->num_rows) {
                $store_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_to_store s LEFT JOIN " . DB_PREFIX . "setting l ON (s.store_id = l.store_id) WHERE s.user_id = '" . (int)$user_query->row['user_id'] . "' AND s.store_id = '" . $userColData['store_id'] . "' AND l.key = 'config_language'");
                if ($store_query->num_rows) {
                    if (strtotime($user_query->row['periodto']) > strtotime(date("Y-m-d"))) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
            return false;
        }

        private function _validate_types($array, $names) {
            foreach ($names as $name => $type) {
                if (isset($array["$name"])) {
                    switch ($type) {
                        case 'INT':
                            $array["$name"] = intval($array["$name"]);
                            break;
                        case 'FLOAT':
                            $array["$name"] = floatval($array["$name"]);
                            break;
                        case 'STR':
                            $array["$name"] = str_replace(array("\r", "\n"), ' ', addslashes(htmlspecialchars(trim(url_encode($array["$name"])))));
                            break;
                        default:
                            $array["$name"] = '';
                    }
                } else {
                    $array["$name"] = '';
                }
            }
            return $array;
        }

        protected function hashed($data) {
            return base64_encode(json_encode($data));
        }
    
        protected function unhashed($data) {
            return json_decode(base64_decode($data));
        }

}
