<?php

class ControllerAndroidBrewingProduct extends Controller {

    private $app_hash;
    private $call_back;
    private $call_function;
    private $currency;
    private $currency_code;
    private $hash;
    private $is_ver20;
    private $push_currency_code;
    private $store_id;
    private $s;
    private $opencart_version;
    private $post_data;
    private $selected_store;
    private $selected_shipping_method;
    private $output;

    const MODULE_CODE = 16;
    const MODULE_VERSION = '1.1.11';
    const DEBUG_MODE = false;
    const MOB_ASSIST_API_KEY = 'AIzaSyDIq4agB70Zv7AkB9pVuF2KxcU4WQ94CVI';

    public function index() {
        @date_default_timezone_get('UTC');
        $this->check_version();

        $this->load->model('android/setting');
        $this->load->model('android/connector');
        $this->load->model('android/brewing_quotation_api');
        $this->load->model('android/customer');

        $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');
        $this->config->set('config_language_id', $this->model_android_brewing_quotation_api->getlangugeId());

        if (!isset($this->s['andassist_status'])) {
            $data['error_code'] = [
                'error' => -1,
                'msj' => 'API disabled',
                'app_hash' => $this->app_hash
            ];
            $this->generate_output($data);
        }

        $post = $this->request->post;
        $request = $this->request->request;

        if (isset($request['call_back']) && strlen($request['call_back']) > 0) {
            $this->call_back = $request['call_back'];
        }

        if (isset($request['call_function']) && strlen($request['call_function']) > 0) {
            $this->call_function = $request['call_function'];
        }

        if (isset($request['hash']) && strlen($request['hash']) > 0) {
            $this->hash = $request['hash'];
        }

        if (isset($request['app_hash']) && strlen($request['app_hash']) > 0) {
            $this->app_hash = $request['app_hash'];
        }

        if (empty($this->call_function)) {
            $this->run_self_test();
        }

        if (!$this->check_confing()) {
            $data['error_code'] = [
                'error' => -1,
                'msj' => 'API disable',
                'app_hash' => $this->app_hash
            ];
            $this->generate_output($data);
        }

        if (!$this->check_auth()) {
            $data['error_code'] = [
                'error' => -2,
                'msj' => 'Password Not Match',
            ];
            $this->generate_output($data);
        }

        if ($this->call_function == 'test_config') {
            $this->generate_output(array('test' => 1));
        }

        $params = $this->_validate_types($request, array());

        foreach ($params as $k => $value) {
            $this->{$k} = $value;
        }

        $this->post_data = $post;

        foreach ($this->post_data as $k => $value) {
            $this->{$k} = $value;
        }

        if (empty($this->currency_code) || $this->currency_code == 'not_set') {
            $this->currency = '';
        } else if ($this->currency_code == 'base_currency') {
            $this->currency = $this->config->get('config_currency');
        } else {
            $this->currency = $this->currency_code;
        }

        print_r($this->currency_code);

        if (empty($this->push_currency_code) || $this->push_currency_code == 'not_set') {
            $this->push_currency_code = '';
        }

        if ($this->store_id == '') {
            $this->store_id = -1;
        }

        $this->store_id = intval($this->store_id);

        if (!method_exists($this, $this->call_function)) {
            $this->generate_output('old_module');
        }

        $result = call_user_func(array($this, $this->call_function));
        return $this->generate_output($result);
    }

    private function check_version() {
        if (class_exists('MijoShop')) {
            $base = MijoShop::get('base');

            $installed_ms_version = (array) $base->getMijoshopVersion();
            $mijo_version = $installed_ms_version[0];
            if (version_compare($mijo_version, '3.0.0', '>=') && version_compare(VERSION, '2.0.0.0', '<')) {
                $this->opencart_version = '2.0.1.0';
            } else {
                $this->opencart_version = VERSION;
            }
        } else {
            $this->opencart_version = VERSION;
        }
        $this->is_ver20 = version_compare($this->opencart_version, '2.0.0', '>=');
    }

    private function check_confing() {
        $this->load->model('android/brewing_quotation_api');
        $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');

        if (isset($this->request->request['app_hash'])) {
            if (md5($this->s['andassist_login'] . $this->s['andassist_pass']) == $this->request->request['app_hash'] && $this->s['andassist_status'] == 1) {
                return true;
            }
        }
        return false; //return true or false only can be one, either one return, the other one will stop.
    }

    private function check_auth() {
        $userColData = $this->revers_base64($this->hash);
        $user_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE username = '" . $this->db->escape($userColData['user_name']) . "' AND (password = SHA1(CONCAT(salt, SHA1(CONCAT(salt, SHA1('" . $this->db->escape($userColData['password']) . "'))))) OR password = '" . $this->db->escape(md5($userColData['password'])) . "') AND status = 1 AND position = '2'");
        if ($user_query->num_rows) {
            $store_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_to_store s LEFT JOIN " . DB_PREFIX . "setting l ON (s.store_id = l.store_id) WHERE s.user_id = '" . (int) $user_query->row['user_id'] . "' AND s.store_id = '" . $userColData['store_id'] . "' AND l.key = 'config_language'");
            if ($store_query->num_rows) {
                if (strtotime($user_query->row['periodto']) > strtotime(date("Y-m-d"))) {
                    return true;
                } else {
                    return false;
                }
            }
        }
        return false;
    }

    private function revers_base64($data) {
        $user_info = base64_decode($data);
        $userColData = json_decode($user_info, true);
        return $userColData;
    }

    private function _validate_types($array, $names) {
        foreach ($names as $name => $type) {
            if (isset($array["$name"])) {
                switch ($type) {
                    case 'INT':
                        $array["$name"] = intval($array["$name"]);
                        break;
                    case 'FLOAT':
                        $array["$name"] = floatval($array["$name"]);
                        break;
                    case 'STR':
                        $array["$name"] = str_replace(array("\r", "\n"), ' ', addslashes(htmlspecialchars(trim(url_encode($array["$name"])))));
                        break;
                    default:
                        $array["$name"] = '';
                }
            } else {
                $array["$name"] = '';
            }
        }
        return $array;
    }

    private function generate_output($data) {
        $add_bridge_version = false;

        if (in_array($this->call_function, array("test_config", "get_store_title", "get_store_stats", "get_data_graphs"))) {
            if (is_array($data) && $data != 'auth_error' && $data != 'connection_error' && $data != 'old_bridge') {
                $add_bridge_version = true;
            }
        }

        if (!is_array($data)) {
            $data = array($data);
        }

        if ($add_bridge_version) {
            $data['module_version'] = self::MODULE_CODE;
        }

        if (is_array($data)) {
            array_walk_recursive($data, array($this, 'reset_null'));
        }

        $data = json_encode($data);

        if ($this->callback) {
            header('Content-Type: text/javascript;charset=utf-8');
            die($this->callback . '(' . $data . ');');
        } else {
            $this->response->addHeader('Content-Type: application/json');
            $this->response->setOutput($data);
        }
    }

    public function setOutput($output) {
        $this->output = $output;
    }

    public function setHeader($header) {
        $this->headers = array();
        if (is_array($header)) {
            foreach ($header as $h)
                $this->headers[] = $h;
        } else {
            $this->headers[] = $header;
        }
    }

    private function reset_null(&$item) {
        if (empty($item) && $item != 0) {
            $item = '';
        }

// $item = trim($item);

        $item = $item;
    }

    private function access_etcm_api($data, $path) {
        $hash = $this->config->get('etcm_hash');

        $curl = curl_init();

// Set SSL if required
        if (substr(HTTP_API, 0, 5) == 'https') {
            curl_setopt($curl, CURLOPT_PORT, 443);
        }

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_FORBID_REUSE, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_URL, HTTP_API . 'index.php?route=etcm/api&hash=' . $hash . $path);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));

        $response = curl_exec($curl);

        $response_encode = json_decode($response, true);
        return $response_encode;
    }

    public function getProductListFromETCM() {

        $this->load->library('herbal_request_brewing_cart');
        $this->cart = new Herbal_request_brewing_cart($this->registry);

        $product_cart = $this->cart->GetProductCart();

        foreach ($product_cart['product'] as $products) {
            $requested_product[] = $products['product_id'];
        }

        $product_list = HTTP_API . 'index.php?route=etcm/brewing/product/getProductList';

        $data['store_url'] = HTTPS_SERVER;
        $data['user_agent'] = $this->request->server['HTTP_USER_AGENT'];

        $page = isset($this->request->get['page']) ? $this->request->get['page'] : false;
        $search = isset($this->request->get['search']) ? $this->request->get['search'] : false;
        $show = isset($this->request->get['show']) ? $this->request->get['show'] : false;

        $post_data = [
            'page' => $page,
            'show' => $show,
            'search' => $search,
            'store_url' => HTTPS_SERVER,
            'user_agent' => $this->request->server['HTTP_USER_AGENT']
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $product_list);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        $final_result = json_decode($result, true);

        foreach ($final_result['products'] as $product_etcm) {
            $product_etcm_id[] = $product_etcm['product_id'];
        }

        if (in_array($requested_product, $product_etcm_id)) {
            $tick_to_top = 1;
        } else {
            $tick_to_top = 0;
        }

        echo '<pre>';
        print_r($requested_product);
        echo '</pre>';

        echo '<pre>';
        print_r($product_etcm_id);
        echo '</pre>';

        echo '<pre>';
        print_r($tick_to_top);
        echo '</pre>';

        return $final_result;
    }

    public function getProductListFromETCM2() {

        $product_list = HTTP_API . 'index.php?route=etcm/brewing/product/getProductList2';

        $data['store_url'] = HTTPS_SERVER;
        $data['user_agent'] = $this->request->server['HTTP_USER_AGENT'];

        $page = isset($this->request->get['page']) ? $this->request->get['page'] : false;
        $search = isset($this->request->get['search']) ? $this->request->get['search'] : false;
        $show = isset($this->request->get['show']) ? $this->request->get['show'] : false;

        $post_data = [
            'page' => $page,
            'show' => $show,
            'search' => $search,
            'store_url' => HTTPS_SERVER,
            'user_agent' => $this->request->server['HTTP_USER_AGENT']
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $product_list);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        $final_result = json_decode($result, true);

        return $final_result;
    }

    public function getProductListFromETCM3() {

        $this->load->model('android/brewing/brewing');

        $herbal_request_id = isset($this->request->get['herbal_request_id']) ? $this->request->get['herbal_request_id'] : false;
        $search = isset($this->request->get['search']) ? $this->request->get['search'] : false;
        $data['page'] = isset($this->request->get['page']) ? $this->request->get['page'] : false;
        $data['show'] = isset($this->request->get['show']) ? $this->request->get['show'] : false;

        $data['store_url'] = HTTPS_SERVER;
        $data['user_agent'] = $this->request->server['HTTP_USER_AGENT'];


        if (!$herbal_request_id) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_request_id) {

            $herbal_request_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            if (!empty($herbal_request_info['data'])) {
                $decoded_customer_data = json_decode($herbal_request_info['data'], true);

                foreach ($decoded_customer_data['product'] as $product) {
                    $product_list[] = [
                        'product_id' => $product['product_id'],
                        'quantity' => $product['quantity']
                    ];
                }

                $etcm_url = HTTP_API . 'index.php?route=etcm/brewing/product/getProductList3';

                $post_data = [
                    'search' => $search,
                    'page' => $data['page'],
                    'show' => $data['show'],
                    'herbal_request_id' => $herbal_request_id,
                    'product_list' => !empty($product_list) ? $product_list : '',
                    'store_url' => HTTPS_SERVER,
                    'user_agent' => $this->request->server['HTTP_USER_AGENT']
                ];

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $etcm_url);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                $result = curl_exec($ch);

                curl_close($ch);

                $json = json_decode($result, true);

                if (!empty($json)) {

                    $json['error_code'] = array(
                        'error' => 0,
                        'msj' => 'Get Product List Success',
                    );
                } else {

                    $json['error_code'] = array(
                        'error' => 1,
                        'msj' => 'No Result Found',
                    );
                }
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'No Herbal Request Data Found',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'No Herbal Request ID found',
            );
        }

        return $json;
    }

    public function getPrescriptionFromETCM() {
        $this->load->model('android/brewing/product');
        $this->load->model('android/brewing/brewing');

        $herbal_request_id = isset($this->request->get['herbal_request_id']) ? $this->request->get['herbal_request_id'] : false;
        $search = isset($this->request->get['search']) ? $this->request->get['search'] : false;
        $data['page'] = isset($this->request->get['page']) ? $this->request->get['page'] : false;
        $data['show'] = isset($this->request->get['show']) ? $this->request->get['show'] : false;

        if (!$herbal_request_id) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );
            return $json;
        }

        if ($herbal_request_id) {

            $etcm_url = HTTP_API . 'index.php?route=etcm/brewing/product/getPrescription';

            $post_data = [
                'search' => $search,
                'page' => $data['page'],
                'show' => $data['show'],
                'herbal_request_id' => $herbal_request_id,
                'store_url' => HTTPS_SERVER
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $etcm_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            curl_close($ch);

            $prescriptions = json_decode($result, true);

            $json['prescriptions'] = $prescriptions['prescriptions'];

            if (!empty($json['prescriptions'])) {

                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'Get Product List Success',
                );
            } else {

                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'No Result Found',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'No Herbal Request ID found',
            );
        }

        return $json;
    }

    public function addPrescriptionProduct() {
        $this->load->model('android/brewing/brewing');
        $this->load->model('android/brewing/product');

        $this->load->library('herbal_request_brewing_cart');
        $this->cart = new Herbal_request_brewing_cart($this->registry);

//        $this->cart->clear();

        $herbal_request_id = isset($this->request->get['herbal_request_id']) ? $this->request->get['herbal_request_id'] : false;
        $prescription_id = isset($this->request->get['prescription_id']) ? $this->request->get['prescription_id'] : false;

        if (!($herbal_request_id && $prescription_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );
            return $json;
        }

        if ($herbal_request_id && $prescription_id) {
            $etcm_url = HTTP_API . 'index.php?route=etcm/brewing/product/getPrescriptionProduct';

            $post_data = [
                'prescription_id' => $prescription_id
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $etcm_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            curl_close($ch);

            $result_arr = json_decode($result, true);

            $prescription_products = !empty($result_arr['prescription_products']) ? $result_arr['prescription_products'] : NULL;

            if (!empty($prescription_products)) {
                foreach ($prescription_products as $prescription_product) {

                    $product_cart = $this->cart->GetProductCart();

                    if (isset($product_cart['product'][$prescription_product['product_id']])) {

                        $quantity_cart = $product_cart['product'][$prescription_product['product_id']]['quantity'];

                        $final_quantity = $prescription_product['quantity'] + $quantity_cart;
                    } else {
                        $final_quantity = $prescription_product['quantity'];
                    }

                    $this->cart->addProduct($prescription_product['product_id'], $final_quantity);
                }
            }

            $product_cart_result = $this->getProductCart();

            $herbal_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $decoded_customer_data = json_decode($herbal_info['data'], true);

            $decoded_customer_data['product'] = call_user_func_array('array_merge', $product_cart_result);

            $customer_data = json_encode($decoded_customer_data);

            if ($customer_data && $herbal_request_id) {
                $this->model_android_brewing_product->updateProductCartToHerbalRequest($customer_data, $herbal_request_id);

                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'Successful added prescription into cart'
                );

                $json['product_cart'] = !empty($product_cart_result) ? array_values($product_cart_result) : '';
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'failed to add prescription',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'failed to post data',
            );
        }
        return $json;
    }

    public function getProductCart() {
        $json = [];

        $this->load->library('herbal_request_brewing_cart');
        $this->cart = new Herbal_request_brewing_cart($this->registry);

        $product_cart = $this->cart->GetProductCart();

        if (!empty($product_cart)) {
            foreach ($product_cart as $product) {
                foreach ($product as $pr) {
                    $json['product_cart'][] = [
                        'product_id' => $pr['product_id'],
                        'quantity' => $pr['quantity']
                    ];
                }
            }
        }

        $post_data = [
            'product' => !empty($json['product_cart']) ? $json['product_cart'] : []
        ];

        $product_list = HTTP_API . 'index.php?route=etcm/brewing/product/getProductDetail';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_URL, $product_list);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        $final_result = json_decode($result, true);

        return $final_result;
    }

    public function addProductToCart() {
        $json = [];

        $this->load->model('android/brewing/brewing');
        $this->load->model('android/brewing/product');

        $this->load->library('herbal_request_brewing_cart');
        $this->cart = new Herbal_request_brewing_cart($this->registry);

        $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
        $product_id = isset($this->request->post['product_id']) ? $this->request->post['product_id'] : false;
        $quantity = isset($this->request->post['quantity']) ? $this->request->post['quantity'] : false;

        if (!($product_id && $quantity && $herbal_request_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($product_id && $quantity && $herbal_request_id) {

            $product_cart = $this->getProductCart();

            if (isset($product_cart['product'][$product_id])) {
                $quantity_cart = $product_cart['product'][$product_id]['quantity'];

                $quantity += $quantity_cart;
            }

            $add_product = $this->cart->addProduct($product_id, $quantity);

            $product_cart_result = $this->getProductCart();

            $herbal_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $decoded_customer_data = json_decode($herbal_info['data'], true);

            $decoded_customer_data['product'] = call_user_func_array('array_merge', $product_cart_result);

            $customer_data = json_encode($decoded_customer_data);

            $this->model_android_brewing_product->updateProductCartToHerbalRequest($customer_data, $herbal_request_id);

            if ($add_product) {
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'Successful added product'
                );

                $json['product_cart'] = !empty($product_cart_result) ? array_values($product_cart_result) : '';
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'failed to add product',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'fail to post data',
            );
        }

        return $json;
    }

    public function increaseProductQuantity() {
        $json = [];

        $this->load->model('android/brewing/brewing');
        $this->load->model('android/brewing/product');

        $this->load->library('herbal_request_brewing_cart');
        $this->cart = new Herbal_request_brewing_cart($this->registry);

        $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
        $product_id = isset($this->request->post['product_id']) ? $this->request->post['product_id'] : false;

        if (!($product_id && $herbal_request_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($product_id && $herbal_request_id) {
            $product_cart = $this->cart->GetProductCart();

            if (isset($product_cart['product'][$product_id])) {
                $quantity_cart = $product_cart['product'][$product_id]['quantity'];

                $quantity_cart += 1;
            }

            $increase_product = $this->cart->addProduct($product_id, !empty($quantity_cart) ? $quantity_cart : 1);

            $product_cart_result = $this->getProductCart();

            $herbal_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $decoded_customer_data = json_decode($herbal_info['data'], true);

            $decoded_customer_data['product'] = call_user_func_array('array_merge', $product_cart_result);

            $customer_data = json_encode($decoded_customer_data);

            $this->model_android_brewing_product->updateProductCartToHerbalRequest($customer_data, $herbal_request_id);

            if ($increase_product) {
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'Successful added 1 quantity to current product'
                );

                $json['product_cart'] = !empty($product_cart_result) ? array_values($product_cart_result) : '';
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'failed to add quantity',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'failed to post data',
            );
        }
        return $json;
    }

    public function minusProductQuantity() {
        $json = [];

        $this->load->model('android/brewing/brewing');
        $this->load->model('android/brewing/product');

        $this->load->library('herbal_request_brewing_cart');
        $this->cart = new Herbal_request_brewing_cart($this->registry);

        $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
        $product_id = isset($this->request->post['product_id']) ? $this->request->post['product_id'] : false;

        if (!($product_id && $herbal_request_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($product_id && $herbal_request_id) {
            $product_cart = $this->cart->GetProductCart();

            if (isset($product_cart['product'][$product_id])) {
                $quantity_cart = $product_cart['product'][$product_id]['quantity'];

                $quantity_cart -= 1;
            }

            if ($quantity_cart > 0) {
                $deduct_product = $this->cart->addProduct($product_id, $quantity_cart);
            } else {
                $deduct_product = $this->cart->RemoveProduct($product_id);
            }

            $product_cart_result = $this->getProductCart();

            $herbal_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $decoded_customer_data = json_decode($herbal_info['data'], true);

            $decoded_customer_data['product'] = call_user_func_array('array_merge', $product_cart_result);

            $customer_data = json_encode($decoded_customer_data);

            $this->model_android_brewing_product->updateProductCartToHerbalRequest($customer_data, $herbal_request_id);

            if (!empty($deduct_product)) {
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'Successful deduct 1 quantity from current product'
                );

                $json['product_cart'] = !empty($product_cart_result) ? array_values($product_cart_result) : '';
            } elseif (empty($deduct_product)) {
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'Successful remove product from cart'
                );
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'failed to deduct quantity',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'failed to post data',
            );
        }
        return $json;
    }

    public function updateProductQuantity() {
        $json = [];

        $this->load->model('android/brewing/brewing');
        $this->load->model('android/brewing/product');

        $this->load->library('herbal_request_brewing_cart');
        $this->cart = new Herbal_request_brewing_cart($this->registry);

        $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
        $product_id = isset($this->request->post['product_id']) ? $this->request->post['product_id'] : false;
        $quantity = isset($this->request->post['quantity']) ? $this->request->post['quantity'] : false;

        if (!($product_id && $quantity && $herbal_request_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );
            return $json;
        }

        if ($product_id && $quantity && $herbal_request_id) {

            $edit_product = $this->cart->addProduct($product_id, $quantity);

            $product_cart_result = $this->getProductCart();

            $herbal_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $decoded_customer_data = json_decode($herbal_info['data'], true);

            $decoded_customer_data['product'] = call_user_func_array('array_merge', $product_cart_result);

            $customer_data = json_encode($decoded_customer_data);

            $this->model_android_brewing_product->updateProductCartToHerbalRequest($customer_data, $herbal_request_id);

            if ($edit_product) {
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'Successful edited product quantity'
                );

                $json['product_cart'] = !empty($product_cart_result) ? array_values($product_cart_result) : '';
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'failed to edit product quantity',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'failed to post data'
            );
        }

        return $json;
    }

    public function deleteProductFromCart() {
        $json = [];

        $this->load->model('android/brewing/brewing');
        $this->load->model('android/brewing/product');

        $this->load->library('herbal_request_brewing_cart');
        $this->cart = new Herbal_request_brewing_cart($this->registry);

        $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
        $product_id = isset($this->request->post['product_id']) ? $this->request->post['product_id'] : false;

        if (!($product_id && $herbal_request_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );
            return $json;
        }

        if ($product_id && $herbal_request_id) {
            $this->cart->RemoveProduct($product_id);

            $product_cart = $this->getProductCart();

            $herbal_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $decoded_customer_data = json_decode($herbal_info['data'], true);

            $decoded_customer_data['product'] = call_user_func_array('array_merge', $product_cart);

            $customer_data = json_encode($decoded_customer_data);

            $this->model_android_brewing_product->updateProductCartToHerbalRequest($customer_data, $herbal_request_id);

            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'remove from cart success'
            );

            $json['product_cart'] = !empty($product_cart) ? array_values($product_cart) : '';
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'Cannot get post data'
            );
        }

        return $json;
    }

}
