<?php

class ControllerAndroidBrewingImage extends Controller {

    private $app_hash;
    private $call_back;
    private $call_function;
    private $currency;
    private $currency_code;
    private $hash;
    private $is_ver20;
    private $push_currency_code;
    private $store_id;
    private $s;
    private $opencart_version;
    private $post_data;
    private $selected_store;
    private $selected_shipping_method;
    private $output;

    const MODULE_CODE = 16;
    const MODULE_VERSION = '1.1.11';
    const DEBUG_MODE = false;
    const MOB_ASSIST_API_KEY = 'AIzaSyDIq4agB70Zv7AkB9pVuF2KxcU4WQ94CVI';

    public function index() {
        @date_default_timezone_get('UTC');
        $this->check_version();

        $this->load->model('android/setting');
        $this->load->model('android/connector');
        $this->load->model('android/brewing_quotation_api');
        $this->load->model('android/customer');

        $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');
        $this->config->set('config_language_id', $this->model_android_brewing_quotation_api->getlangugeId());

        if (!isset($this->s['andassist_status'])) {
            $data['error_code'] = [
                'error' => -1,
                'msj' => 'API disabled',
                'app_hash' => $this->app_hash
            ];
            $this->generate_output($data);
        }

        $post = $this->request->post;
        $request = $this->request->request;

        if (isset($request['call_back']) && strlen($request['call_back']) > 0) {
            $this->call_back = $request['call_back'];
        }

        if (isset($request['call_function']) && strlen($request['call_function']) > 0) {
            $this->call_function = $request['call_function'];
        }

        if (isset($request['hash']) && strlen($request['hash']) > 0) {
            $this->hash = $request['hash'];
        }

        if (isset($request['app_hash']) && strlen($request['app_hash']) > 0) {
            $this->app_hash = $request['app_hash'];
        }

        if (empty($this->call_function)) {
            $this->run_self_test();
        }

        if (!$this->check_confing()) {
            $data['error_code'] = [
                'error' => -1,
                'msj' => 'API disable',
                'app_hash' => $this->app_hash
            ];
            $this->generate_output($data);
        }

        if (!$this->check_auth()) {
            $data['error_code'] = [
                'error' => -2,
                'msj' => 'Password Not Match',
            ];
            $this->generate_output($data);
        }

        if ($this->call_function == 'test_config') {
            $this->generate_output(array('test' => 1));
        }

        $params = $this->_validate_types($request, array(
        ));

        foreach ($params as $k => $value) {
            $this->{$k} = $value;
        }

        $this->post_data = $post;

        foreach ($this->post_data as $k => $value) {
            $this->{$k} = $value;
        }

        if (empty($this->currency_code) || $this->currency_code == 'not_set') {
            $this->currency = '';
        } else if ($this->currency_code == 'base_currency') {
            $this->currency = $this->config->get('config_currency');
        } else {
            $this->currency = $this->currency_code;
        }

        print_r($this->currency_code);

        if (empty($this->push_currency_code) || $this->push_currency_code == 'not_set') {
            $this->push_currency_code = '';
        }

        if ($this->store_id == '') {
            $this->store_id = -1;
        }

        $this->store_id = intval($this->store_id);

        if (!method_exists($this, $this->call_function)) {
            $this->generate_output('old_module');
        }

        $result = call_user_func(array($this, $this->call_function));
        $this->generate_output($result);
    }

    private function check_version() {
        if (class_exists('MijoShop')) {
            $base = MijoShop::get('base');

            $installed_ms_version = (array) $base->getMijoshopVersion();
            $mijo_version = $installed_ms_version[0];
            if (version_compare($mijo_version, '3.0.0', '>=') && version_compare(VERSION, '2.0.0.0', '<')) {
                $this->opencart_version = '2.0.1.0';
            } else {
                $this->opencart_version = VERSION;
            }
        } else {
            $this->opencart_version = VERSION;
        }
        $this->is_ver20 = version_compare($this->opencart_version, '2.0.0', '>=');
    }

    private function check_confing() {
        $this->load->model('android/brewing_quotation_api');
        $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');

        if (isset($this->request->request['app_hash'])) {
            if (md5($this->s['andassist_login'] . $this->s['andassist_pass']) == $this->request->request['app_hash'] && $this->s['andassist_status'] == 1) {
                return true;
            }
        }
        return false; //return true or false only can be one, either one return, the other one will stop.
    }

    private function check_auth() {
        $userColData = $this->revers_base64($this->hash);
        $user_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE username = '" . $this->db->escape($userColData['user_name']) . "' AND (password = SHA1(CONCAT(salt, SHA1(CONCAT(salt, SHA1('" . $this->db->escape($userColData['password']) . "'))))) OR password = '" . $this->db->escape(md5($userColData['password'])) . "') AND status = 1 AND position = '2'");
        if ($user_query->num_rows) {
            $store_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_to_store s LEFT JOIN " . DB_PREFIX . "setting l ON (s.store_id = l.store_id) WHERE s.user_id = '" . (int) $user_query->row['user_id'] . "' AND s.store_id = '" . $userColData['store_id'] . "' AND l.key = 'config_language'");
            if ($store_query->num_rows) {
                if (strtotime($user_query->row['periodto']) > strtotime(date("Y-m-d"))) {
                    return true;
                } else {
                    return false;
                }
            }
        }
        return false;
    }

    private function revers_base64($data) {
        $user_info = base64_decode($data);
        $userColData = json_decode($user_info, true);
        return $userColData;
    }

    private function _validate_types($array, $names) {
        foreach ($names as $name => $type) {
            if (isset($array["$name"])) {
                switch ($type) {
                    case 'INT':
                        $array["$name"] = intval($array["$name"]);
                        break;
                    case 'FLOAT':
                        $array["$name"] = floatval($array["$name"]);
                        break;
                    case 'STR':
                        $array["$name"] = str_replace(array("\r", "\n"), ' ', addslashes(htmlspecialchars(trim(url_encode($array["$name"])))));
                        break;
                    default:
                        $array["$name"] = '';
                }
            } else {
                $array["$name"] = '';
            }
        }
        return $array;
    }

    private function generate_output($data) {
        $add_bridge_version = false;

        if (in_array($this->call_function, array("test_config", "get_store_title", "get_store_stats", "get_data_graphs"))) {
            if (is_array($data) && $data != 'auth_error' && $data != 'connection_error' && $data != 'old_bridge') {
                $add_bridge_version = true;
            }
        }

        if (!is_array($data)) {
            $data = array($data);
        }

        if ($add_bridge_version) {
            $data['module_version'] = self::MODULE_CODE;
        }

        if (is_array($data)) {
            array_walk_recursive($data, array($this, 'reset_null'));
        }

        $data = json_encode($data);

        if ($this->callback) {
            header('Content-Type: text/javascript;charset=utf-8');
            die($this->callback . '(' . $data . ');');
        } else {
            $this->response->addHeader('Content-Type: application/json');
            $this->response->setOutput($data);
        }
    }

    public function setOutput($output) {
        $this->output = $output;
    }

    public function setHeader($header) {
        $this->headers = array();
        if (is_array($header)) {
            foreach ($header as $h)
                $this->headers[] = $h;
        } else {
            $this->headers[] = $header;
        }
    }

    private function reset_null(&$item) {
        if (empty($item) && $item != 0) {
            $item = '';
        }

        // $item = trim($item);

        $item = $item;
    }

    /**
     * options[UploadImage][post][']=upload image to herbal request.
     * options[UploadImage][post][security]=public
     * options[UploadImage][post][parameter][]=herbal_request_id : int
     * options[UploadImage][post][parameter][]=image : string
     */
    public function UploadImage() {
        $this->load->model('android/brewing/image');
        $this->load->model('android/brewing/brewing');
        $this->load->model('android/brewing/product');

        $data['error_code'] = array(
            'error' => 1,
            'msj' => 'failure',
        );

        $data['herbal_request_id'] = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;

        $data['image'] = isset($_FILES['image']) ? $_FILES['image'] : false;

        if (!($data['herbal_request_id'] && $data['image'])) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        $brewing_request_info = $this->model_android_brewing_brewing->getHerbalListById($data['herbal_request_id']);

        $decoded_customer_data = json_decode($brewing_request_info['data'], true);

        if (!empty($brewing_request_info)) {
            $img_allowed = array('gif', 'jpeg', 'png', 'jpg');

            if ($data['image']['error'] == 0) {
                $img_filename = $data['image']['name'];
                $ext = pathinfo($img_filename, PATHINFO_EXTENSION);
                if (!in_array(strtolower($ext), $img_allowed)) {
                    $json['error_code'] = array(
                        'error' => 1,
                        'code' => 1002,
                        'msj' => 'Invalid image format'
                    );

                    return $json;
                }
            } else {
                if ($data['image']['error'] == 0) {
                    $img_filename = $data['image']['name'];
                    $ext = pathinfo($img_filename, PATHINFO_EXTENSION);
                    if (!in_array($ext, $img_allowed)) {
                        $json['error_code'] = array(
                            'error' => 1,
                            'code' => 1002,
                            'msj' => 'Invalid image format'
                        );

                        return $json;
                    }
                }
            }

            $product_cart = $this->load->controller('android/brewing/product/getProductCart');

            $upload_image = $this->model_android_brewing_image->UploadImage($data, $decoded_customer_data, $product_cart['product']);

            $brewing_request_info2 = $this->model_android_brewing_brewing->getHerbalListById($data['herbal_request_id']);

            $decoded_for_product = json_decode($brewing_request_info2['data'], true);

            $decoded_for_product['product'] = $product_cart['product'];

            if (!empty($decoded_for_product['no_product'])) {
                foreach ($decoded_for_product['no_product'] as $not_available_product) {
                    $product_info = $this->model_android_brewing_brewing->getNotAvailableProducts($not_available_product['product_id']);

                    $not_avaialble_product[] = [
                        'product_name' => $product_info['name'],
                        'product_id' => $product_info['product_id'],
                        'available_in_etcm' => 0
                    ];
                }
            }

            $decoded_for_product['no_product'] = $not_avaialble_product;

            $product_cart_added_encode = json_encode($decoded_for_product);

            $this->model_android_brewing_product->updateProductCartToHerbalRequest($product_cart_added_encode, $data['herbal_request_id']);

            if ($upload_image == 0) {
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'succes'
                );
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'Insert error',
                );
            }
        }

        return $json;
    }

    /**
     * options[getImageList][post][']=view images of a selected herbal request.
     * options[getImageList][post][security]=public
     * options[getImageList][post][parameter][]=herbal_request_id : int
     */
    public function getImageList() {
        $this->load->model('android/brewing/image');
        $this->load->model('android/brewing/brewing');

        $data['error_code'] = array(
            'error' => 1,
            'msj' => 'failure',
        );

        $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;

        if (!($herbal_request_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        $json['images'] = [];

        if ($herbal_request_id) {
            $brewing_request_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $decoded_customer_data = json_decode($brewing_request_info['data'], true);

            $images1 = $decoded_customer_data['image'];

            $images = array_values($images1);

            foreach ($images as $image) {
                $json['images'][] = HTTPS_IMAGE . $image;
            }
        }

        if (!empty($json['images'])) {

            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'succes',
            );
        } else {

            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'No Result Found',
            );
        }
        return $json;
    }

    public function DeleteImage() {

        $user_data = $this->revers_base64($this->hash);

        $this->load->model('android/brewing/image');
        $this->load->model('android/brewing/brewing');
        $this->load->model('android/brewing/product');

        $data['herbal_request_id'] = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
        $data['image_id'] = isset($this->request->post['image_id']) ? $this->request->post['image_id'] : false;

        if (!($data['herbal_request_id'] && $data['image_id'] != NULL)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($data['herbal_request_id'] && $data['image_id'] != NULL) {
            $brewing_request_info = $this->model_android_brewing_brewing->getHerbalListById($data['herbal_request_id']);

            $data['user_id'] = $user_data['user_id'];

            $decoded_customer_data = json_decode($brewing_request_info['data'], true);

            array_splice($decoded_customer_data['image'], $data['image_id'], 1);

            $product_cart = $this->load->controller('android/brewing/product/getProductCart');

            $updated_delete_image_data = $this->model_android_brewing_image->updateDataDeletedImage($data, $decoded_customer_data);

            $brewing_request_info2 = $this->model_android_brewing_brewing->getHerbalListById($data['herbal_request_id']);

            $decoded_for_product = json_decode($brewing_request_info2['data'], true);

            $decoded_for_product['product'] = $product_cart['product'];

            if (!empty($decoded_for_product['no_product'])) {
                foreach ($decoded_for_product['no_product'] as $not_available_product) {
                    $product_info = $this->model_android_brewing_brewing->getNotAvailableProducts($not_available_product['product_id']);

                    $not_avaialble_product[] = [
                        'product_name' => $product_info['name'],
                        'product_id' => $product_info['product_id'],
                        'available_in_etcm' => 0
                    ];
                }
            }

            $decoded_for_product['no_product'] = $not_avaialble_product;

            $product_cart_added_encode = json_encode($decoded_for_product);

            $this->model_android_brewing_product->updateProductCartToHerbalRequest($product_cart_added_encode, $data['herbal_request_id']);

            if ($updated_delete_image_data == 0) {
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'succes'
                );
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'Insert error',
                );
            }
        }
        return $json;
    }

}
