<?php

class ControllerAndroidBrewingCustomer extends Controller {

    private $app_hash;
    private $call_back;
    private $call_function;
    private $currency;
    private $currency_code;
    private $hash;
    private $is_ver20;
    private $push_currency_code;
    private $store_id;
    private $s;
    private $opencart_version;
    private $post_data;
    private $selected_store;
    private $selected_shipping_method;
    private $output;

    const MODULE_CODE = 16;
    const MODULE_VERSION = '1.1.11';
    const DEBUG_MODE = false;
    const MOB_ASSIST_API_KEY = 'AIzaSyDIq4agB70Zv7AkB9pVuF2KxcU4WQ94CVI';

    public function index() {
        @date_default_timezone_get('UTC');
        $this->check_version();

        $this->load->model('android/setting');
        $this->load->model('android/connector');
        $this->load->model('android/brewing_quotation_api');
        $this->load->model('android/customer');

        $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');
        $this->config->set('config_language_id', $this->model_android_brewing_quotation_api->getlangugeId());

        if (!isset($this->s['andassist_status'])) {
            $data['error_code'] = [
                'error' => -1,
                'msj' => 'API disabled',
                'app_hash' => $this->app_hash
            ];
            $this->generate_output($data);
        }

        $post = $this->request->post;
        $request = $this->request->request;

        if (isset($request['call_back']) && strlen($request['call_back']) > 0) {
            $this->call_back = $request['call_back'];
        }

        if (isset($request['call_function']) && strlen($request['call_function']) > 0) {
            $this->call_function = $request['call_function'];
        }

        if (isset($request['hash']) && strlen($request['hash']) > 0) {
            $this->hash = $request['hash'];
        }

        if (isset($request['app_hash']) && strlen($request['app_hash']) > 0) {
            $this->app_hash = $request['app_hash'];
        }

        if (empty($this->call_function)) {
            $this->run_self_test();
        }

        if (!$this->check_confing()) {
            $data['error_code'] = [
                'error' => -1,
                'msj' => 'API disable',
                'app_hash' => $this->app_hash
            ];
            $this->generate_output($data);
        }

        if (!$this->check_auth()) {
            $data['error_code'] = [
                'error' => -2,
                'msj' => 'Password Not Match',
            ];
            $this->generate_output($data);
        }

        if ($this->call_function == 'test_config') {
            $this->generate_output(array('test' => 1));
        }

        $params = $this->_validate_types($request, array(
        ));

        foreach ($params as $k => $value) {
            $this->{$k} = $value;
        }

        $this->post_data = $post;

        foreach ($this->post_data as $k => $value) {
            $this->{$k} = $value;
        }

        if (empty($this->currency_code) || $this->currency_code == 'not_set') {
            $this->currency = '';
        } else if ($this->currency_code == 'base_currency') {
            $this->currency = $this->config->get('config_currency');
        } else {
            $this->currency = $this->currency_code;
        }

        print_r($this->currency_code);

        if (empty($this->push_currency_code) || $this->push_currency_code == 'not_set') {
            $this->push_currency_code = '';
        }

        if ($this->store_id == '') {
            $this->store_id = -1;
        }

        $this->store_id = intval($this->store_id);

        if (!method_exists($this, $this->call_function)) {
            $this->generate_output('old_module');
        }

        $result = call_user_func(array($this, $this->call_function));
        $this->generate_output($result);
    }

    private function check_version() {
        if (class_exists('MijoShop')) {
            $base = MijoShop::get('base');

            $installed_ms_version = (array) $base->getMijoshopVersion();
            $mijo_version = $installed_ms_version[0];
            if (version_compare($mijo_version, '3.0.0', '>=') && version_compare(VERSION, '2.0.0.0', '<')) {
                $this->opencart_version = '2.0.1.0';
            } else {
                $this->opencart_version = VERSION;
            }
        } else {
            $this->opencart_version = VERSION;
        }
        $this->is_ver20 = version_compare($this->opencart_version, '2.0.0', '>=');
    }

    private function check_confing() {
        $this->load->model('android/brewing_quotation_api');
        $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');

        if (isset($this->request->request['app_hash'])) {
            if (md5($this->s['andassist_login'] . $this->s['andassist_pass']) == $this->request->request['app_hash'] && $this->s['andassist_status'] == 1) {
                return true;
            }
        }
        return false; //return true or false only can be one, either one return, the other one will stop.
    }

    private function check_auth() {
        $userColData = $this->revers_base64($this->hash);
        $user_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE username = '" . $this->db->escape($userColData['user_name']) . "' AND (password = SHA1(CONCAT(salt, SHA1(CONCAT(salt, SHA1('" . $this->db->escape($userColData['password']) . "'))))) OR password = '" . $this->db->escape(md5($userColData['password'])) . "') AND status = 1 AND position = '2'");
        if ($user_query->num_rows) {
            $store_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_to_store s LEFT JOIN " . DB_PREFIX . "setting l ON (s.store_id = l.store_id) WHERE s.user_id = '" . (int) $user_query->row['user_id'] . "' AND s.store_id = '" . $userColData['store_id'] . "' AND l.key = 'config_language'");
            if ($store_query->num_rows) {
                if (strtotime($user_query->row['periodto']) > strtotime(date("Y-m-d"))) {
                    return true;
                } else {
                    return false;
                }
            }
        }
        return false;
    }

    private function revers_base64($data) {
        $user_info = base64_decode($data);
        $userColData = json_decode($user_info, true);
        return $userColData;
    }

    private function _validate_types($array, $names) {
        foreach ($names as $name => $type) {
            if (isset($array["$name"])) {
                switch ($type) {
                    case 'INT':
                        $array["$name"] = intval($array["$name"]);
                        break;
                    case 'FLOAT':
                        $array["$name"] = floatval($array["$name"]);
                        break;
                    case 'STR':
                        $array["$name"] = str_replace(array("\r", "\n"), ' ', addslashes(htmlspecialchars(trim(url_encode($array["$name"])))));
                        break;
                    default:
                        $array["$name"] = '';
                }
            } else {
                $array["$name"] = '';
            }
        }
        return $array;
    }

    private function generate_output($data) {
        $add_bridge_version = false;

        if (in_array($this->call_function, array("test_config", "get_store_title", "get_store_stats", "get_data_graphs"))) {
            if (is_array($data) && $data != 'auth_error' && $data != 'connection_error' && $data != 'old_bridge') {
                $add_bridge_version = true;
            }
        }

        if (!is_array($data)) {
            $data = array($data);
        }

        if ($add_bridge_version) {
            $data['module_version'] = self::MODULE_CODE;
        }

        if (is_array($data)) {
            array_walk_recursive($data, array($this, 'reset_null'));
        }

        $data = json_encode($data);

        if ($this->callback) {
            header('Content-Type: text/javascript;charset=utf-8');
            die($this->callback . '(' . $data . ');');
        } else {
            $this->response->addHeader('Content-Type: application/json');
            $this->response->setOutput($data);
        }
    }

    public function setOutput($output) {
        $this->output = $output;
    }

    public function setHeader($header) {
        $this->headers = array();
        if (is_array($header)) {
            foreach ($header as $h)
                $this->headers[] = $h;
        } else {
            $this->headers[] = $header;
        }
    }

    private function reset_null(&$item) {
        if (empty($item) && $item != 0) {
            $item = '';
        }

        // $item = trim($item);

        $item = $item;
    }

    /**
     * options[getCustomerList][get][']=get the customer list of the store.
     * options[getCustomerList][get][security]=public
     * options[getCustomerList][get][url parameter][]=limit : int
     * options[getCustomerList][get][url parameter][]=page : int
     * options[getCustomerList][get][response]=[{
     * 
      customer_id : int,
      customer_name : string,
      telephone : string,
      address_1 : string,
      address_2 : string,
      city : string,
      postcode : string,
      zone_name : string,
      country_name : string,
      }]
     */
    public function getCustomerList() {
        $this->load->model('android/brewing/customer');
        $this->load->model('android/brewing/address');

        $data['page'] = isset($this->request->get['page']) ? $this->request->get['page'] : false;
        $data['show'] = isset($this->request->get['show']) ? $this->request->get['show'] : false;
        $data['search'] = isset($this->request->get['search']) ? $this->request->get['search'] : false;

        $json = array();

        $json['customers'] = array();

        if ($data['page'] !== null && !empty($data['page']) && $data['show'] !== null && !empty($data['show'])) {
            $data['page'] = ($data['page'] - 1) * $data['show'];
            $data['show'] = $data['show'];
        }

        $customer_lists = $this->model_android_brewing_customer->getCustomerList($data);

        if (!empty($customer_lists)) {

            $json['customers'] = [];

            $json['customers'] = $customer_lists;

            $customer_name = array_column($customer_lists, 'customer_name');

            array_multisort($customer_name, SORT_ASC, $json['customers']);

            $start = $data['page'];
            $limit = !empty($data['show']) ? $data['show'] : $this->config->get('config_limit_admin');

            $json['customers'] = array_slice($json['customers'], $start, $limit);
        }

        if (!empty($json['customers'])) {

            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'succes',
            );
        } else {

            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'No Result Found',
            );
        }

        return $json;
    }

    /**
     * options[setCustomer][post][']=add customer to herbal request.
     * options[setCustomer][post][security]=public
     * options[setCustomer][post][parameter][]=customer_id : int
     */
    public function setCustomer() {

        $user_data = $this->revers_base64($this->hash);

        $this->load->model('android/brewing/customer');
        $this->load->model('android/brewing/address');
        $this->load->model('android/brewing/brewing');

        $data['error_code'] = array(
            'error' => 1,
            'msj' => 'failure',
        );

        $this->load->library('herbal_request_brewing_cart');
        $this->cart = new Herbal_request_brewing_cart($this->registry);

        $this->cart->clear();

        $customer_id = isset($this->request->post['customer_id']) ? $this->request->post['customer_id'] : false;

        if (!($customer_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($customer_id) {

            $customer_data = $this->model_android_brewing_customer->getCustomerbyID($customer_id);

            $customer_address_data = $this->model_android_brewing_customer->getCustomerbyAddressID($customer_id);

            if (!empty($customer_address_data)) {
                $customer_address = [
                    'firstname' => $customer_address_data['firstname'],
                    'lastname' => $customer_address_data['lastname'],
                    'company' => $customer_address_data['company'],
                    'telephone' => $customer_address_data['telephone'],
                    'address_id' => $customer_address_data['address_id'],
                    'address_1' => $customer_address_data['address_1'],
                    'address_2' => $customer_address_data['address_2'],
                    'address_3' => $customer_address_data['address_3'],
                    'city' => $customer_address_data['city'],
                    'postcode' => $customer_address_data['postcode'],
                    'zone_name' => $customer_address_data['zone_name'],
                    'zone_id' => $customer_address_data['zone_id'],
                    'country_id' => $customer_address_data['country_id'],
                    'country_name' => $customer_address_data['country_name']
                ];
            } else {
                $customer_address = NULL;
            }

            $customer_details = [
                'customer_id' => !empty($customer_data['customer_id']) ? $customer_data['customer_id'] : '',
                'customer_ic' => !empty($customer_data['customer_ic']) ? $customer_data['customer_ic'] : '',
                'customer_name' => !empty($customer_data['customer_name']) ? $customer_data['customer_name'] : '',
                'telephone' => !empty($customer_data['telephone']) ? $customer_data['telephone'] : '',
                'email' => !empty($customer_data['email']) ? $customer_data['email'] : ''
            ];

            $prescription = [
                'dosage' => 3,
                'daily_take' => 2,
                'volume' => 180,
                'weight_class' => 'ml'
            ];

            $brewing_date = [
                'customer' => $customer_details,
                'address' => $customer_address,
                'remark' => '',
                'brewingtype' => 1,
                'product' => array(),
                'product_exist' => 1,
                'prescription' => $prescription,
                'image' => array(),
                'selected_store' => null,
                'total' => array(),
                'shipping_method' => null,
                'payment_method' => null
            ];

            $data = array(
                'customer_data' => json_encode($brewing_date),
                'customer_id' => $customer_id,
                'user_id' => $user_data['user_id'],
                'store_id' => $user_data['store_id']
            );

            $add_customer_to_herbal_request = $this->model_android_brewing_brewing->addHerbalRequestFromCustomer($data);

            $this->model_android_brewing_brewing->insertHerbalRequestRemark($add_customer_to_herbal_request, 1, '');

            if ($add_customer_to_herbal_request) {
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'succes'
                );
                $json['herbal_request_id'] = $add_customer_to_herbal_request;

                $user_info = $this->revers_base64($this->hash);

                $invoice_prefix = $this->model_android_brewing_brewing->getHerbalRequestInvoice($add_customer_to_herbal_request);

                $notification_template = $this->config->get('config_gcm_herbal_request');

                if ($notification_template['status'] == '1') {
                    $template_title = $notification_template['title'];
                    $template_message = $notification_template['message'];

                    $find_title = array(
                        '{customer_name}'
                    );

                    $replace_title = array(
                        'customer_name' => $customer_data['customer_name']
                    );

                    $find_message = array(
                        '{invoice_prefix}'
                    );

                    $replace_message = array(
                        'invoice_prefix' => $invoice_prefix
                    );

                    $notification_title = str_replace($find_title, $replace_title, $template_title);
                    $notification_message = str_replace($find_message, $replace_message, $template_message);

                    $notification_data = array(
                        'body' => $notification_title,
                        'badge' => 1,
                        'sound' => 'ping.aiff'
                    );

                    $data_gcm = array(
                        'title' => $notification_title,
                        'message' => $notification_message,
                        'user_id' => $user_info['user_id'],
                        'type' => 2
                    );

                    $doctor_device = $this->model_android_brewing_brewing->getDoctorDevice($user_info['user_id']);

                    if (!empty($doctor_device)) {
                        $gcm = new GCM($this->registry);
                        $gcm->sendTo($gcm->get_user_token($user_info['user_id']))
                                ->setData($data_gcm)
                                ->setIosNotification($notification_data)
                                ->setContentAvailable(true)
                                ->send();
                    }
                }


                $notification = new Notification($this->registry);

                $notification_data = [
                    'herbal_request_id' => $add_customer_to_herbal_request,
                    'invoice_prefix' => $invoice_prefix,
                    'customer_name' => $customer_data['customer_name']
                ];

                if (($notification->new_clinical_sale_notification_status == '1') && ($notification->notification_status == '1')) {
                    $notification->add_notification('new_clinical_sale_notification', $notification_data);
                }
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'Insert error',
                );
            }
        }

        return $json;
    }

    public function addNewCustomer() {
        $this->load->model('android/brewing/customer');

        $customer_name = isset($this->request->post['customer_name']) ? $this->request->post['customer_name'] : false;
        $customer_ic = isset($this->request->post['customer_ic']) ? $this->request->post['customer_ic'] : false;
        $telephone = isset($this->request->post['telephone']) ? $this->request->post['telephone'] : false;
        $email = isset($this->request->post['email']) ? $this->request->post['email'] : false;
        $gender = isset($this->request->post['gender']) ? $this->request->post['gender'] : false;
        $address_1 = isset($this->request->post['address_1']) ? $this->request->post['address_1'] : false;
        $address_2 = isset($this->request->post['address_2']) ? $this->request->post['address_2'] : false;
        $city = isset($this->request->post['city']) ? $this->request->post['city'] : false;
        $postcode = isset($this->request->post['postcode']) ? $this->request->post['postcode'] : false;
        $zone_id = isset($this->request->post['zone_id']) ? $this->request->post['zone_id'] : false;
        $country_id = 129;

        if (!($customer_name && $telephone && $address_1 && $city && $postcode && $zone_id && $country_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($customer_name && $telephone && $address_1 && $city && $postcode && $zone_id && $country_id) {

            $post_data = [
                'customer_name' => $customer_name,
                'customer_ic' => $customer_ic,
                'telephone' => $telephone,
                'email' => !empty($email) ? $email : '',
                'gender' => !empty($gender) ? $gender : '',
                'address_1' => $address_1,
                'address_2' => !empty($address_2) ? $address_2 : '',
                'city' => $city,
                'postcode' => $postcode,
                'zone_id' => $zone_id,
                'country_id' => $country_id
            ];

            $customer_id = $this->model_android_brewing_customer->addNewCustomer($post_data);

            if ($customer_id) {
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'succes'
                );
                $json['customer_id'] = $customer_id;
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'Insert error',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'Failed to post data',
            );
        }

        return $json;
    }

}
