<?php

class ControllerAndroidBrewingBrewingOrder extends Controller {

    private $app_hash;
    private $call_back;
    private $call_function;
    private $currency;
    private $currency_code;
    private $hash;
    private $is_ver20;
    private $push_currency_code;
    private $store_id;
    private $s;
    private $opencart_version;
    private $post_data;
    private $selected_store;
    private $selected_shipping_method;
    private $output;

    const MODULE_CODE = 16;
    const MODULE_VERSION = '1.1.11';
    const DEBUG_MODE = false;
    const MOB_ASSIST_API_KEY = 'AIzaSyDIq4agB70Zv7AkB9pVuF2KxcU4WQ94CVI';

    public function index() {
        @date_default_timezone_get('UTC');
        $this->check_version();

        $this->load->model('android/setting');
        $this->load->model('android/connector');
        $this->load->model('android/brewing_quotation_api');
        $this->load->model('android/customer');

        $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');
        $this->config->set('config_language_id', $this->model_android_brewing_quotation_api->getlangugeId());

        if (!isset($this->s['andassist_status'])) {
            $data['error_code'] = [
                'error' => -1,
                'msj' => 'API disabled',
                'app_hash' => $this->app_hash
            ];
            $this->generate_output($data);
        }

        $post = $this->request->post;
        $request = $this->request->request;

        if (isset($request['call_back']) && strlen($request['call_back']) > 0) {
            $this->call_back = $request['call_back'];
        }

        if (isset($request['call_function']) && strlen($request['call_function']) > 0) {
            $this->call_function = $request['call_function'];
        }

        if (isset($request['hash']) && strlen($request['hash']) > 0) {
            $this->hash = $request['hash'];
        }

        if (isset($request['app_hash']) && strlen($request['app_hash']) > 0) {
            $this->app_hash = $request['app_hash'];
        }

        if (empty($this->call_function)) {
            $this->run_self_test();
        }

        if (!$this->check_confing()) {
            $data['error_code'] = [
                'error' => -1,
                'msj' => 'API disable',
                'app_hash' => $this->app_hash
            ];
            $this->generate_output($data);
        }

        if (!$this->check_auth()) {
            $data['error_code'] = [
                'error' => -2,
                'msj' => 'Password Not Match',
            ];
            $this->generate_output($data);
        }

        if ($this->call_function == 'test_config') {
            $this->generate_output(array('test' => 1));
        }

        $params = $this->_validate_types($request, array(
        ));

        foreach ($params as $k => $value) {
            $this->{$k} = $value;
        }

        $this->post_data = $post;

        foreach ($this->post_data as $k => $value) {
            $this->{$k} = $value;
        }

        if (empty($this->currency_code) || $this->currency_code == 'not_set') {
            $this->currency = '';
        } else if ($this->currency_code == 'base_currency') {
            $this->currency = $this->config->get('config_currency');
        } else {
            $this->currency = $this->currency_code;
        }

        print_r($this->currency_code);

        if (empty($this->push_currency_code) || $this->push_currency_code == 'not_set') {
            $this->push_currency_code = '';
        }

        if ($this->store_id == '') {
            $this->store_id = -1;
        }

        $this->store_id = intval($this->store_id);

        if (!method_exists($this, $this->call_function)) {
            $this->generate_output('old_module');
        }

        $result = call_user_func(array($this, $this->call_function));
        $this->generate_output($result);
    }

    private function check_version() {
        if (class_exists('MijoShop')) {
            $base = MijoShop::get('base');

            $installed_ms_version = (array) $base->getMijoshopVersion();
            $mijo_version = $installed_ms_version[0];
            if (version_compare($mijo_version, '3.0.0', '>=') && version_compare(VERSION, '2.0.0.0', '<')) {
                $this->opencart_version = '2.0.1.0';
            } else {
                $this->opencart_version = VERSION;
            }
        } else {
            $this->opencart_version = VERSION;
        }
        $this->is_ver20 = version_compare($this->opencart_version, '2.0.0', '>=');
    }

    private function check_confing() {
        $this->load->model('android/brewing_quotation_api');
        $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');

        if (isset($this->request->request['app_hash'])) {
            if (md5($this->s['andassist_login'] . $this->s['andassist_pass']) == $this->request->request['app_hash'] && $this->s['andassist_status'] == 1) {
                return true;
            }
        }
        return false; //return true or false only can be one, either one return, the other one will stop.
    }

    private function check_auth() {
        $userColData = $this->revers_base64($this->hash);
        $user_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE username = '" . $this->db->escape($userColData['user_name']) . "' AND (password = SHA1(CONCAT(salt, SHA1(CONCAT(salt, SHA1('" . $this->db->escape($userColData['password']) . "'))))) OR password = '" . $this->db->escape(md5($userColData['password'])) . "') AND status = 1 AND position = '2'");
        if ($user_query->num_rows) {
            $store_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_to_store s LEFT JOIN " . DB_PREFIX . "setting l ON (s.store_id = l.store_id) WHERE s.user_id = '" . (int) $user_query->row['user_id'] . "' AND s.store_id = '" . $userColData['store_id'] . "' AND l.key = 'config_language'");
            if ($store_query->num_rows) {
                if (strtotime($user_query->row['periodto']) > strtotime(date("Y-m-d"))) {
                    return true;
                } else {
                    return false;
                }
            }
        }
        return false;
    }

    private function revers_base64($data) {
        $user_info = base64_decode($data);
        $userColData = json_decode($user_info, true);
        return $userColData;
    }

    private function _validate_types($array, $names) {
        foreach ($names as $name => $type) {
            if (isset($array["$name"])) {
                switch ($type) {
                    case 'INT':
                        $array["$name"] = intval($array["$name"]);
                        break;
                    case 'FLOAT':
                        $array["$name"] = floatval($array["$name"]);
                        break;
                    case 'STR':
                        $array["$name"] = str_replace(array("\r", "\n"), ' ', addslashes(htmlspecialchars(trim(url_encode($array["$name"])))));
                        break;
                    default:
                        $array["$name"] = '';
                }
            } else {
                $array["$name"] = '';
            }
        }
        return $array;
    }

    private function generate_output($data) {
        $add_bridge_version = false;

        if (in_array($this->call_function, array("test_config", "get_store_title", "get_store_stats", "get_data_graphs"))) {
            if (is_array($data) && $data != 'auth_error' && $data != 'connection_error' && $data != 'old_bridge') {
                $add_bridge_version = true;
            }
        }

        if (!is_array($data)) {
            $data = array($data);
        }

        if ($add_bridge_version) {
            $data['module_version'] = self::MODULE_CODE;
        }

        if (is_array($data)) {
            array_walk_recursive($data, array($this, 'reset_null'));
        }

        $data = json_encode($data);

        if ($this->callback) {
            header('Content-Type: text/javascript;charset=utf-8');
            die($this->callback . '(' . $data . ');');
        } else {
            $this->response->addHeader('Content-Type: application/json');
            $this->response->setOutput($data);
        }
    }

    public function setOutput($output) {
        $this->output = $output;
    }

    public function setHeader($header) {
        $this->headers = array();
        if (is_array($header)) {
            foreach ($header as $h)
                $this->headers[] = $h;
        } else {
            $this->headers[] = $header;
        }
    }

    private function reset_null(&$item) {
        if (empty($item) && $item != 0) {
            $item = '';
        }

        // $item = trim($item);

        $item = $item;
    }

    public function addBrewingOrder() {
        $this->load->model('android/brewing/brewing_order');

        $this->load->model('android/brewing/brewing');

        $this->load->model('android/brewing/seller_order');

        if (!empty($this->request->post)) {
            $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
            $customer_data = isset($this->request->post['customer_data']) ? $this->request->post['customer_data'] : false;
            $product = isset($this->request->post['products']) ? $this->request->post['products'] : false;
            $prescription = isset($this->request->post['prescription']) ? $this->request->post['prescription'] : false;
            $buyer_store = isset($this->request->post['buyer_store']) ? $this->request->post['buyer_store'] : false;
            $payment_address = isset($this->request->post['payment_address']) ? $this->request->post['payment_address'] : false;
            $buyer_payment_address = isset($this->request->post['buyer_store_address']) ? $this->request->post['buyer_store_address'] : false;
            $payment_method = isset($this->request->post['payment_method']) ? $this->request->post['payment_method'] : false;
            $total = isset($this->request->post['total']) ? $this->request->post['total'] : false;
            $shipping_method = isset($this->request->post['shipping_method']) ? $this->request->post['shipping_method'] : false;
            $shipping_address = isset($this->request->post['shipping_address']) ? $this->request->post['shipping_address'] : false;
            $remark = isset($this->request->post['remark']) ? $this->request->post['remark'] : false;
            $buyer_store_address = isset($this->request->post['buyer_store_address']) ? $this->request->post['buyer_store_address'] : false;
            $brewing_type = isset($this->request->post['brewing_type']) ? $this->request->post['brewing_type'] : false;
        }

        $data_post = [
            'herbal_request_id' => $herbal_request_id,
            'customer_data' => $customer_data,
            'product' => $product,
            'prescription' => $prescription,
            'buyer_store' => $buyer_store,
            'payment_address' => $payment_address,
            'buyer_payment_address' => $buyer_payment_address,
            'payment_method' => $payment_method,
            'total' => $total,
            'shipping_method' => $shipping_method,
            'shipping_address' => $shipping_address,
            'remark' => $remark,
            'buyer_store_address' => $buyer_store_address,
            'brewing_type' => $brewing_type
        ];

        if (!empty($data_post)) {
            $herbal_order_id = $this->model_android_brewing_brewing_order->addBrewingOrderToSeller($data_post);

            $herbal_order_info = $this->model_android_brewing_brewing_order->getHerbalOrderInfo($herbal_order_id);

            $this->model_android_brewing_seller_order->saveRemarkIntoSeller($herbal_order_id, '', $herbal_order_info['order_status_id']);

            $users_info = $this->model_android_brewing_brewing_order->getAllDoctors();

            $user_info = $this->revers_base64($this->hash);

            $notification_template = $this->config->get('config_gcm_herbal_order');

            if ($notification_template['status'] == '1') {
                $template_title = $notification_template['title'];
                $template_message = $notification_template['message'];

                $find_title = array(
                    '{customer_name}'
                );

                $replace_title = array(
                    'customer_name' => $herbal_order_info['shipping_firstname']
                );

                $find_message = array(
                    '{invoice_prefix}'
                );

                $replace_message = array(
                    'invoice_prefix' => $herbal_order_info['invoice_prefix']
                );

                $notification_title = str_replace($find_title, $replace_title, $template_title);
                $notification_message = str_replace($find_message, $replace_message, $template_message);

                $notification_data = array(
                    'body' => $notification_title,
                    'badge' => 1,
                    'sound' => 'ping.aiff'
                );

                foreach ($users_info as $user_info) {
                    $data_gcm = array(
                        'title' => $notification_title,
                        'message' => $notification_message,
                        'user_id' => $user_info['user_id'],
                        'type' => 2
                    );

                    $doctor_device = $this->model_android_brewing_brewing->getDoctorDevice($user_info['user_id']);

                    if (!empty($doctor_device)) {
                        $gcm = new GCM($this->registry);
                        $gcm->sendTo($gcm->get_user_token($user_info['user_id']))
                                ->setData($data_gcm)
                                ->setIosNotification($notification_data)
                                ->setContentAvailable(true)
                                ->send();
                    }
                }

                $notification = new Notification($this->registry);

                $notification_data = [
                    'herbal_order_id' => $herbal_order_info,
                    'invoice_prefix' => $herbal_order_info['invoice_prefix'],
                    'customer_name' => $customer_data['customer_name']
                ];

                if (($notification->new_clinical_sale_notification_status == '1') && ($notification->notification_status == '1')) {
                    $notification->add_notification('new_herbal_order_notification', $notification_data);
                }
            }
        }

        return $herbal_order_id;
    }

    public function cancelOrderToSeller() {
        $this->load->model('android/brewing/brewing_order');
        $this->load->model('android/brewing/seller_order');
        $this->load->model('android/brewing/brewing');

        if (!empty($this->request->post)) {
            $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
            $buyer_store_id = isset($this->request->post['buyer_store_id']) ? $this->request->post['buyer_store_id'] : false;
            $remark = isset($this->request->post['remark']) ? $this->request->post['remark'] : false;
            $order_status_id = isset($this->request->post['order_status_id']) ? $this->request->post['order_status_id'] : false;

            $this->model_android_brewing_brewing_order->updateOrderStatusForSeller($herbal_request_id, $buyer_store_id);

            $herbal_order_info = $this->model_android_brewing_brewing_order->getHerbalOrderInfoByRequest($herbal_request_id, $buyer_store_id);

            $this->model_android_brewing_seller_order->saveRemarkIntoSeller($herbal_order_info['herbal_order_id'], $remark, $order_status_id);

            $order_status = $this->model_android_brewing_brewing->getOrderStatus($order_status_id);

            $users_info = $this->model_android_brewing_brewing_order->getAllDoctors();

            $notification_template = $this->config->get('config_gcm_herbal_order_status');

            if ($notification_template['status'] == '1') {
                $template_title = $notification_template['title'];
                $template_message = $notification_template['message'];

                $find_title = array(
                    '{customer_name}'
                );

                $replace_title = array(
                    'customer_name' => $herbal_order_info['shipping_firstname']
                );

                $find_message = array(
                    '{invoice_prefix}',
                    '{order_status}'
                );

                $replace_message = array(
                    'invoice_prefix' => $herbal_order_info['invoice_prefix'],
                    'order_status' => $order_status
                );

                $notification_title = str_replace($find_title, $replace_title, $template_title);
                $notification_message = str_replace($find_message, $replace_message, $template_message);

                $notification_data = array(
                    'body' => $notification_title,
                    'badge' => 1,
                    'sound' => 'ping.aiff'
                );

                foreach ($users_info as $user_info) {
                    $data_gcm = array(
                        'title' => $notification_title,
                        'message' => $notification_message,
                        'user_id' => $user_info['user_id'],
                        'type' => 2
                    );

                    $doctor_device = $this->model_android_brewing_brewing->getDoctorDevice($user_info['user_id']);

                    if (!empty($doctor_device)) {
                        $gcm = new GCM($this->registry);
                        $gcm->sendTo($gcm->get_user_token($user_info['user_id']))
                                ->setData($data_gcm)
                                ->setIosNotification($notification_data)
                                ->setContentAvailable(true)
                                ->send();
                    }
                }

                $notification = new Notification($this->registry);

                $notification_data = [
                    'herbal_order_id' => $herbal_order_info,
                    'invoice_prefix' => $herbal_order_info['invoice_prefix'],
                    'customer_name' => $herbal_order_info['shipping_firstname'],
                    'order_status' => $order_status
                ];

                if (($notification->new_clinical_sale_notification_status == '1') && ($notification->notification_status == '1')) {
                    $notification->add_notification('new_herbal_order_notification', $notification_data);
                }
            }
        }
    }

}
