<?php

class ControllerAndroidBrewingBrewing extends Controller {

    private $app_hash;
    private $call_back;
    private $call_function;
    private $currency;
    private $currency_code;
    private $hash;
    private $is_ver20;
    private $push_currency_code;
    private $store_id;
    private $s;
    private $opencart_version;
    private $post_data;
    private $selected_store;
    private $selected_shipping_method;
    private $output;

    const MODULE_CODE = 16;
    const MODULE_VERSION = '1.1.11';
    const DEBUG_MODE = false;
    const MOB_ASSIST_API_KEY = 'AIzaSyDIq4agB70Zv7AkB9pVuF2KxcU4WQ94CVI';

    public function index() {
        @date_default_timezone_get('UTC');
        $this->check_version();

        $this->load->model('android/setting');
        $this->load->model('android/connector');
        $this->load->model('android/brewing_quotation_api');

        $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');
        $this->config->set('config_language_id', $this->model_android_brewing_quotation_api->getlangugeId());

        if (!isset($this->s['andassist_status'])) {
            $data['error_code'] = [
                'error' => -1,
                'msj' => 'API disabled',
                'app_hash' => $this->app_hash
            ];
            $this->generate_output($data);
        }

        $post = $this->request->post;
        $request = $this->request->request;

        if (isset($request['call_back']) && strlen($request['call_back']) > 0) {
            $this->call_back = $request['call_back'];
        }

        if (isset($request['call_function']) && strlen($request['call_function']) > 0) {
            $this->call_function = $request['call_function'];
        }

        if (isset($request['hash']) && strlen($request['hash']) > 0) {
            $this->hash = $request['hash'];
        }

        if (isset($request['app_hash']) && strlen($request['app_hash']) > 0) {
            $this->app_hash = $request['app_hash'];
        }

        if (empty($this->call_function)) {
            $this->run_self_test();
        }

        if (!$this->check_confing()) {
            $data['error_code'] = [
                'error' => -1,
                'msj' => 'API disable',
                'app_hash' => $this->app_hash
            ];
            $this->generate_output($data);
        }

        if (!$this->check_auth()) {
            $data['error_code'] = [
                'error' => -2,
                'msj' => 'Password Not Match',
            ];
            $this->generate_output($data);
        }

        if ($this->call_function == 'test_config') {
            $this->generate_output(array('test' => 1));
        }

        $params = $this->_validate_types($request, array(
        ));

        foreach ($params as $k => $value) {
            $this->{$k} = $value;
        }

        $this->post_data = $post;

        foreach ($this->post_data as $k => $value) {
            $this->{$k} = $value;
        }

        if (empty($this->currency_code) || $this->currency_code == 'not_set') {
            $this->currency = '';
        } else if ($this->currency_code == 'base_currency') {
            $this->currency = $this->config->get('config_currency');
        } else {
            $this->currency = $this->currency_code;
        }

        print_r($this->currency_code);

        if (empty($this->push_currency_code) || $this->push_currency_code == 'not_set') {
            $this->push_currency_code = '';
        }

        if ($this->store_id == '') {
            $this->store_id = -1;
        }

        $this->store_id = intval($this->store_id);

        if (!method_exists($this, $this->call_function)) {
            $this->generate_output('old_module');
        }

        $result = call_user_func(array($this, $this->call_function));
        $this->generate_output($result);
    }

    private function check_version() {
        if (class_exists('MijoShop')) {
            $base = MijoShop::get('base');

            $installed_ms_version = (array) $base->getMijoshopVersion();
            $mijo_version = $installed_ms_version[0];
            if (version_compare($mijo_version, '3.0.0', '>=') && version_compare(VERSION, '2.0.0.0', '<')) {
                $this->opencart_version = '2.0.1.0';
            } else {
                $this->opencart_version = VERSION;
            }
        } else {
            $this->opencart_version = VERSION;
        }
        $this->is_ver20 = version_compare($this->opencart_version, '2.0.0', '>=');
    }

    private function check_confing() {
        $this->load->model('android/brewing_quotation_api');
        $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');

        if (isset($this->request->request['app_hash'])) {
            if (md5($this->s['andassist_login'] . $this->s['andassist_pass']) == $this->request->request['app_hash'] && $this->s['andassist_status'] == 1) {
                return true;
            }
        }
        return false; //return true or false only can be one, either one return, the other one will stop.
    }

    private function check_auth() {
        $userColData = $this->revers_base64($this->hash);
        $user_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE username = '" . $this->db->escape($userColData['user_name']) . "' AND (password = SHA1(CONCAT(salt, SHA1(CONCAT(salt, SHA1('" . $this->db->escape($userColData['password']) . "'))))) OR password = '" . $this->db->escape(md5($userColData['password'])) . "') AND status = 1 AND position = '2'");
        if ($user_query->num_rows) {
            $store_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_to_store s LEFT JOIN " . DB_PREFIX . "setting l ON (s.store_id = l.store_id) WHERE s.user_id = '" . (int) $user_query->row['user_id'] . "' AND s.store_id = '" . $userColData['store_id'] . "' AND l.key = 'config_language'");
            if ($store_query->num_rows) {
                if (strtotime($user_query->row['periodto']) > strtotime(date("Y-m-d"))) {
                    return true;
                } else {
                    return false;
                }
            }
        }
        return false;
    }

    private function revers_base64($data) {
        $user_info = base64_decode($data);
        $userColData = json_decode($user_info, true);
        return $userColData;
    }

    private function _validate_types($array, $names) {
        foreach ($names as $name => $type) {
            if (isset($array["$name"])) {
                switch ($type) {
                    case 'INT':
                        $array["$name"] = intval($array["$name"]);
                        break;
                    case 'FLOAT':
                        $array["$name"] = floatval($array["$name"]);
                        break;
                    case 'STR':
                        $array["$name"] = str_replace(array("\r", "\n"), ' ', addslashes(htmlspecialchars(trim(url_encode($array["$name"])))));
                        break;
                    default:
                        $array["$name"] = '';
                }
            } else {
                $array["$name"] = '';
            }
        }
        return $array;
    }

    private function generate_output($data) {
        $add_bridge_version = false;

        if (in_array($this->call_function, array("test_config", "get_store_title", "get_store_stats", "get_data_graphs"))) {
            if (is_array($data) && $data != 'auth_error' && $data != 'connection_error' && $data != 'old_bridge') {
                $add_bridge_version = true;
            }
        }

        if (!is_array($data)) {
            $data = array($data);
        }

        if ($add_bridge_version) {
            $data['module_version'] = self::MODULE_CODE;
        }

        if (is_array($data)) {
            array_walk_recursive($data, array($this, 'reset_null'));
        }

        $data = json_encode($data);

        if ($this->callback) {
            header('Content-Type: text/javascript;charset=utf-8');
            die($this->callback . '(' . $data . ');');
        } else {
            $this->response->addHeader('Content-Type: application/json');
            $this->response->setOutput($data);
        }
    }

    public function setOutput($output) {
        $this->output = $output;
    }

    public function setHeader($header) {
        $this->headers = array();
        if (is_array($header)) {
            foreach ($header as $h)
                $this->headers[] = $h;
        } else {
            $this->headers[] = $header;
        }
    }

    private function reset_null(&$item) {
        if (empty($item) && $item != 0) {
            $item = '';
        }

        // $item = trim($item);

        $item = $item;
    }

    /**
     * options[getBrewingList][get][']=get the brewing request list of the store.
     * options[getBrewingList][get][security]=public
     * options[getBrewingList][get][url parameter][]=limit : int
     * options[getBrewingList][get][url parameter][]=page : int
     * options[getBrewingList][get][response]=[{
     * 
      customer_id : int,
      customer_name : string,
      telephone : string,
      invoice_prefix : string,
      total : decimal,
      order_status : string
      }]
     */
    public function getBrewingList() {
        $this->load->model('android/brewing/brewing');

        $data['page'] = isset($this->request->get['page']) ? $this->request->get['page'] : false;
        $data['show'] = isset($this->request->get['show']) ? $this->request->get['show'] : false;
        $data['search'] = isset($this->request->get['search']) ? $this->request->get['search'] : false;

        $json = [];

        $json['brewing_request_list'] = [];

        if ($data['page'] !== null && !empty($data['page']) && $data['show'] !== null && !empty($data['show'])) {
            $data['page'] = ($data['page'] - 1) * $data['show'];
            $data['show'] = $data['show'];
        }

        $data['search'] = !empty($data['search']) ? $data['search'] : '';

        $data['sort_by'] = !empty($data['sort_by']) ? $data['sort_by'] : 'herbal_request_id';

        $brewing_lists = $this->model_android_brewing_brewing->getBrewingRequestHerbalList($data);

        if (!empty($brewing_lists)) {
            foreach ($brewing_lists as $brewing_list) {

                $customer_data = json_decode($brewing_list['data'], true);

                $customer = $customer_data['customer'];

                $order_status = $this->model_android_brewing_brewing->getOrderStatus($brewing_list['order_status_id']);

                $json['brewing_request_list'][] = [
                    'herbal_request_id' => $brewing_list['herbal_request_id'],
                    'customer_id' => $brewing_list['customer_id'],
                    'customer_ic' => !empty($customer['customer_ic']) ? $customer['customer_ic'] : '',
                    'customer_name' => !empty($customer['customer_name']) ? $customer['customer_name'] : '',
                    'telephone' => !empty($customer['telephone']) ? $customer['telephone'] : '',
                    'invoice_prefix' => $brewing_list['invoice_prefix'],
                    'total' => $brewing_list['total'],
                    'order_status' => $order_status,
                    'order_status_id' => $brewing_list['order_status_id'],
                    'placed_order_time' => $brewing_list['date_added'],
                    'paid_time' => !empty($brewing_list['paid_time']) ? $brewing_list['paid_time'] : null
                ];
            }
            if (!empty($json['brewing_request_list'])) {

                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'succes',
                );
            } else {

                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'No Result Found',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'failed to get herbal request list',
            );
        }

        return $json;
    }

    /**
     * options[getBrewingDetail][get][']=get detail information of selected herbal request.
     * options[getBrewingDetail][get][security]=public
     * options[getBrewingDetail][get][url parameter][]=limit : int
     * options[getBrewingDetail][get][url parameter][]=page : int
     * options[getBrewingDetail][get][response]=[{
     * 
      herbal_request_id = int,
      store_id = int,
      invoice_no = string,
      invoice_prefix = string,
      customer_id : int,
      customer_name : string,
      doc_date : string,
      total : decimal,
      order_status_id : int,
      data : array
      }]
     */
    public function getBrewingDetail() {
        $this->load->model('android/brewing/brewing');

        $this->load->library('herbal_request_brewing_cart');
        $this->cart = new Herbal_request_brewing_cart($this->registry);

        $this->cart->clear();

        $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;

        if (!($herbal_request_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        $json['brewing_detail'] = [];

        $data = [];

        if ($herbal_request_id) {
            $herbal_request_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            if (!empty($herbal_request_info['data'])) {
                $decoded_customer_data = json_decode($herbal_request_info['data'], true);

                $order_status = $this->model_android_brewing_brewing->getOrderStatus($herbal_request_info['order_status_id']);

                $product = $decoded_customer_data['product'];

                if (!empty($product)) {
                    foreach ($product as $products) {

                        $product_id = $products['product_id'];

                        $quantity = $products['quantity'];

                        $this->cart->addProduct($product_id, $quantity);
                    }
                }

                $getbrewingtype = $this->getBrewingType();

                if (!empty($decoded_customer_data['brewingtype'])) {
                    foreach ($getbrewingtype['brewing_type'] as $brewing) {
                        if ($brewing['brewing_type_id'] == $decoded_customer_data['brewingtype']) {
                            $brewing_type_name = $brewing['code'];
                            $brewing_type = $brewing['name'];
                        }
                    }
                }

                if (!empty($decoded_customer_data['image'])) {
                    foreach ($decoded_customer_data['image'] as $images) {
                        $image[] = HTTPS_SERVER . 'image/' . $images;
                    }
                }

                if (!empty($decoded_customer_data['no_product'])) {
                    foreach ($decoded_customer_data['no_product'] as $no_product_exist) {
                        $product_name[] = $no_product_exist['product_name'];

                        $no_product_name = implode(", ", $product_name);
                    }
                }

                $post_data = [
                    'hosting' => HTTPS_SERVER
                ];

                $store_list = HTTP_API . 'index.php?route=etcm/brewing/brewing/getCreditLimit';

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_HEADER, false);
                curl_setopt($ch, CURLINFO_HEADER_OUT, true);
                curl_setopt($ch, CURLOPT_URL, $store_list);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                $result = curl_exec($ch);

                curl_close($ch);

                $final_result = json_decode($result, true);

                $decoded_customer_data['credit_balance'] = !empty($final_result['credit_limit']) ? $final_result['credit_limit'] : '';

                $credit_balance_2 = 0;

                if ($decoded_customer_data['credit_balance'] != 0) {
                    $credit_balance_format = number_format($decoded_customer_data['credit_balance'], 2, '.', '');

                    $credit_balance_2 = $credit_balance_format;
                } else {
                    $credit_balance_2 = 0;
                }

                $customer_arr = $decoded_customer_data['customer'];

                $customer_info = [
                    'customer_id' => !empty($customer_arr['customer_id']) ? $customer_arr['customer_id'] : '',
                    'customer_ic' => !empty($customer_arr['customer_ic']) ? $customer_arr['customer_ic'] : '',
                    'customer_name' => !empty($customer_arr['customer_name']) ? $customer_arr['customer_name'] : '',
                    'telephone' => !empty($customer_arr['telephone']) ? $customer_arr['telephone'] : '',
                    'email' => !empty($customer_arr['email']) ? $customer_arr['email'] : '',
                ];

                $address_array = $decoded_customer_data['address'];

                if ($address_array) {
                    $customer_address = [
                        'firstname' => !empty($address_array['firstname']) ? $address_array['firstname'] : '',
                        'lastname' => !empty($address_array['lastname']) ? $address_array['lastname'] : '',
                        'company' => !empty($address_array['company']) ? $address_array['company'] : '',
                        'telephone' => !empty($address_array['telephone']) ? $address_array['telephone'] : '',
                        'address_id' => !empty($address_array['address_id']) ? $address_array['address_id'] : '',
                        'address_1' => !empty($address_array['address_1']) ? $address_array['address_1'] : '',
                        'address_2' => !empty($address_array['address_2']) ? $address_array['address_2'] : '',
                        'address_3' => !empty($address_array['address_3']) ? $address_array['address_3'] : '',
                        'city' => !empty($address_array['city']) ? $address_array['city'] : '',
                        'postcode' => !empty($address_array['postcode']) ? $address_array['postcode'] : '',
                        'zone_name' => !empty($address_array['zone_name']) ? $address_array['zone_name'] : '',
                        'zone_id' => !empty($address_array['zone_id']) ? $address_array['zone_id'] : '',
                        'country_id' => !empty($address_array['country_id']) ? $address_array['country_id'] : '',
                        'country_name' => !empty($address_array['country_name']) ? $address_array['country_name'] : '',
                    ];
                } else {
                    $customer_address = NULL;
                }

                $json['brewing_detail'] = [
                    'herbal_request_id' => $herbal_request_info['herbal_request_id'],
                    'store_id' => $herbal_request_info['store_id'],
                    'customer_id' => $herbal_request_info['customer_id'],
                    'invoice_no' => $herbal_request_info['invoice_no'],
                    'invoice_prefix' => $herbal_request_info['invoice_prefix'],
                    'doc_date' => $herbal_request_info['doc_date'],
                    'total' => $herbal_request_info['total'],
                    'order_status' => $order_status,
                    'customer' => $customer_info,
                    'address' => $customer_address,
                    'brewingtype' => !empty($brewing_type_name) ? $brewing_type_name : '',
                    'brewingtype_name' => !empty($brewing_type) ? $brewing_type : '',
                    'remark' => $decoded_customer_data['remark'],
                    'total_product_weight' => !empty($decoded_customer_data['total_product_weight']) ? $decoded_customer_data['total_product_weight'] : null,
                    'product' => !empty($product) ? $product : [],
                    'no_product' => !empty($no_product_name) ? $no_product_name : '',
                    'product_exist' => !empty($decoded_customer_data['product_exist']) ? $decoded_customer_data['product_exist'] : 0,
                    'prescription' => $decoded_customer_data['prescription'],
                    'image' => !empty($image) ? $image : [],
                    'selected_store' => $decoded_customer_data['selected_store'],
                    'total_value' => $decoded_customer_data['total'],
                    'shipping_method' => !empty($decoded_customer_data['shipping_method']) ? $decoded_customer_data['shipping_method'] : null,
                    'payment_method' => !empty($decoded_customer_data['payment_method']) ? $decoded_customer_data['payment_method'] : null,
                    'credit_balance' => $credit_balance_2,
                    'enable_credit' => !empty($decoded_customer_data['enable_credit']) ? $decoded_customer_data['enable_credit'] : 0
                ];

                if (!empty($json['brewing_detail'])) {

                    $json['error_code'] = array(
                        'error' => 0,
                        'msj' => 'succes',
                    );
                } else {

                    $json['error_code'] = array(
                        'error' => 1,
                        'msj' => 'No Result Found',
                    );
                }
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'No Herbal Request Data Found',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'No Herbal Request ID found',
            );
        }

        return $json;
    }

    /**
     * options[setRemark][post][']=add/edit remark to herbal request.
     * options[setRemark][post][security]=public
     * options[setRemark][post][parameter][]=herbal_request_id : int
     * options[setRemark][post][parameter][]=remark : string
     */
    public function setRemark() {

        $user_data = $this->revers_base64($this->hash);

        $this->load->model('android/brewing/brewing');

        $data['error_code'] = array(
            'error' => 1,
            'msj' => 'failure',
        );

        $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
        $remark = isset($this->request->post['remark']) ? $this->request->post['remark'] : false;

        if (!($herbal_request_id && $remark)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_request_id && $remark) {

            $herbal_data = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $herbal_data_decoded = json_decode($herbal_data['data'], true);

            $herbal_data_decoded['remark'] = $remark;

            $data = [
                'customer_data' => json_encode($herbal_data_decoded),
                'user_id' => $user_data['user_id']
            ];

            $insert_remark = $this->model_android_brewing_brewing->InsertRemarkIntoHerbalRequest($herbal_request_id, $data);

            if ($insert_remark == 0) {
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'succes'
                );
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'Insert error',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'failed to post data',
            );
        }
        return $json;
    }

    public function getBrewingType() {
        $product_list = HTTP_API . 'index.php?route=etcm/brewing/product/getBrewingTypeList';

        $data['store_url'] = HTTPS_SERVER;
        $data['user_agent'] = $this->request->server['HTTP_USER_AGENT'];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $product_list);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        $final_result = json_decode($result, true);

        return $final_result;
    }

    public function setBrewingType() {
        $this->load->model('android/brewing/brewing');

        $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
        $brewing_type_id = isset($this->request->post['brewing_type_id']) ? $this->request->post['brewing_type_id'] : false;

        if (!($herbal_request_id && $brewing_type_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_request_id && $brewing_type_id) {
            $herbal_request_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $customer_data = json_decode($herbal_request_info['data'], true);

            $customer_data['brewingtype'] = $brewing_type_id;

            if ($brewing_type_id == 1) {
                $json['prescription'] = [
                    'dosage' => 3,
                    'daily_take' => 2,
                    'volume' => 180,
                    'weight_class' => 'ml'
                ];
            } elseif ($brewing_type_id == 2) {
                $json['prescription'] = [
                    'dosage' => 3,
                    'daily_take' => 2,
                    'weight_class' => 'g'
                ];
            } elseif ($brewing_type_id == 3) {
                $json['prescription'] = [
                    'dosage' => 2,
                    'daily_take' => 2,
                    'weight_class' => 'g'
                ];
            } else {
                $json['prescription'] = [
                    'dosage' => 3,
                    'daily_take' => 2,
                    'volume' => 180,
                    'weight_class' => 'ml'
                ];
            }

            $customer_data['prescription'] = $json['prescription'];

            $encoded_customer_data = json_encode($customer_data);

            $update_brewing_type = $this->model_android_brewing_brewing->updateBrewingType($encoded_customer_data, $herbal_request_id);

            if ($update_brewing_type == 0) {
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'succes'
                );
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'Insert error',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'failed to post data',
            );
        }

        return $json;
    }

    public function showTimesPerDay() {
        $this->load->model('android/brewing/brewing');

        $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;

        if (!($herbal_request_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_request_id) {
            $herbal_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $customer_data = json_decode($herbal_info['data'], true);

            $prescription = $customer_data['prescription'];

            $ori_dosage = !empty($prescription['dosage']) ? $prescription['dosage'] : '';

            $time_per_day = [];

            switch ($customer_data['brewingtype']) {
                case '1':
                    $time_per_day = [1, 2, 3, 4, 5];
                    break;
                case '2':
                    $time_per_day = [2, 3];
                    break;
                case '3':
                    $time_per_day = [1, 2, 3, 4, 5];
                    break;
                default:
                    $time_per_day = [1, 2, 3, 4, 5];
            }

            if ($update_customer_address == 0) {
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'succes',
                );
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'No results!',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'failed to post data',
            );
        }

        echo '<pre>';
        print_r($time_per_day);
        echo '</pre>';
    }

    public function setExtraPrescription() {

        $this->load->model('android/brewing/brewing');

        $json = [];

        $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
        $dosage = isset($this->request->post['dosage']) ? $this->request->post['dosage'] : false;
        $daily_take = isset($this->request->post['daily_take']) ? $this->request->post['daily_take'] : false;
        $volume = isset($this->request->post['volume']) ? $this->request->post['volume'] : false;

        if (!($herbal_request_id && $dosage && $daily_take)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_request_id && $dosage && $daily_take) {
            $herbal_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $customer_data = json_decode($herbal_info['data'], true);

            $prescription = $customer_data['prescription'];

            $prescription['dosage'] = $dosage;
            $prescription['daily_take'] = $daily_take;
            $prescription['volume'] = !empty($volume) ? $volume : '';

            $customer_data['prescription'] = $prescription;

            $encoded_data = json_encode($customer_data);

            if (!empty($encoded_data && $herbal_request_id)) {
                $this->model_android_brewing_brewing->updateBrewingType($encoded_data, $herbal_request_id);

                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'succes',
                );
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'No results!',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'failed to post data',
            );
        }

        return $json;
    }

    public function setAddress() {
        $this->load->model('android/brewing/brewing');
        $this->load->model('android/brewing/address');

        $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
        $address_id = isset($this->request->post['address_id']) ? $this->request->post['address_id'] : false;

        if (!($herbal_request_id && $address_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_request_id && $address_id) {
            $herbal_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $customer_data = json_decode($herbal_info['data'], true);

            $customer_address = $customer_data['address'];

            $customer_info = $customer_data['customer'];

            $customer_id = $customer_info['customer_id'];

            $address_table = $this->model_android_brewing_address->getAddressByCustomerIDAddressID($customer_id, $address_id);

            $zone_name = $this->model_android_brewing_address->getZonefromID($address_table['zone_id']);

            $country_name = $this->model_android_brewing_address->getCountryfromID($address_table['country_id']);

            $customer_address = [
                'firstname' => !empty($address_table['firstname']) ? $address_table['firstname'] : '',
                'lastname' => !empty($address_table['lastname']) ? $address_table['lastname'] : '',
                'company' => !empty($address_table['company']) ? $address_table['company'] : '',
                'address_1' => !empty($address_table['address_1']) ? $address_table['address_1'] : '',
                'address_2' => !empty($address_table['address_2']) ? $address_table['address_2'] : '',
                'address_3' => !empty($address_table['address_3']) ? $address_table['address_3'] : '',
                'city' => !empty($address_table['city']) ? $address_table['city'] : '',
                'postcode' => !empty($address_table['postcode']) ? $address_table['postcode'] : '',
                'zone_name' => !empty($zone_name) ? $zone_name : '',
                'zone_id' => !empty($address_table['zone_id']) ? $address_table['zone_id'] : '',
                'country_name' => !empty($country_name) ? $country_name : '',
                'country_id' => !empty($address_table['country_id']) ? $address_table['country_id'] : ''
            ];

            $customer_data['address'] = $customer_address;

            $update_customer_address = $this->model_android_brewing_brewing->updateAddressHerbalRequest($herbal_request_id, json_encode($customer_data));

            if ($update_customer_address == 0) {
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'succes',
                );
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'No results!',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'failed to post data',
            );
        }

        return $json;
    }

    public function setAddressByStore() {
        $this->load->model('android/brewing/brewing');
        $this->load->model('android/brewing/address');

        $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
        $address_id = isset($this->request->post['address_id']) ? $this->request->post['address_id'] : false;

        if (!($herbal_request_id && $address_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_request_id && $address_id) {
            $herbal_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $customer_data = json_decode($herbal_info['data'], true);

            $store_address = $this->load->controller('android/brewing/address/getStoreAddressFromETCM');

            $address = $store_address['store_address'];

            foreach ($store_address['store_address'] as $address) {
                if ($address['address_id'] == $address_id) {
                    $customer_data['address'] = $address;
                }
            }

            $update_customer_address = $this->model_android_brewing_brewing->updateAddressHerbalRequest($herbal_request_id, json_encode($customer_data));

            if ($update_customer_address == 0) {
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'succes',
                );
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'No results!',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'failed to post data',
            );
        }

        return $json;
    }

    public function getAddressList() {
        $this->load->model('android/brewing/brewing');
        $this->load->model('android/brewing/address');

        $customer_id = isset($this->request->post['customer_id']) ? $this->request->post['customer_id'] : false;

        if ($customer_id == null) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($customer_id) {
            $customer_address = $this->model_android_brewing_address->getAddressByCustomerID($customer_id);

            if (!empty($customer_address)) {
                $json['customer_address'] = $customer_address;
            } else {
                $json['customer_address'] = [];
            }

            if (!empty($json['customer_address'])) {
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'Get Address List Successful'
                );
            } elseif (empty($json['customer_address'])) {
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'No Address found'
                );
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'Fail to Get Address List',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'Failed to get address list',
            );
        }

        return $json;
    }

    public function setCustomerByHerbalRemedies() {

        $this->load->model('android/brewing/customer');
        $this->load->model('android/brewing/address');
        $this->load->model('android/brewing/brewing');

        $user_data = $this->revers_base64($this->hash);

        $this->load->library('herbal_request_brewing_cart');
        $this->cart = new Herbal_request_brewing_cart($this->registry);

        $this->cart->clear();

        $clinical_sale_id = isset($this->request->post['clinical_sale_id']) ? $this->request->post['clinical_sale_id'] : false;

        if (!($clinical_sale_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($clinical_sale_id) {
            $clinical_sale_info = $this->model_android_brewing_brewing->getClinicalSale($clinical_sale_id);

            $clinical_sale_products = $this->model_android_brewing_brewing->getClinicalSaleProduct($clinical_sale_id);

            $customer_data = $this->model_android_brewing_customer->getCustomerbyID($clinical_sale_info['customer_id']);

            $customer_address_data = $this->model_android_brewing_customer->getCustomerbyAddressID($customer_data['customer_id']);

            $clinical_sale_images = $this->model_android_brewing_brewing->getClinicalSaleImage($clinical_sale_id);

            $images = array_column($clinical_sale_images, 'image');

            foreach ($images as $img) {
                $image[] = 'herbal/' . $img;
            }

            if ($customer_address_data) {
                $customer_address = [
                    'firstname' => $customer_address_data['firstname'],
                    'lastname' => $customer_address_data['lastname'],
                    'company' => $customer_address_data['company'],
                    'address_id' => $customer_address_data['address_id'],
                    'address_1' => $customer_address_data['address_1'],
                    'address_2' => $customer_address_data['address_2'],
                    'address_3' => $customer_address_data['address_3'],
                    'city' => $customer_address_data['city'],
                    'postcode' => $customer_address_data['postcode'],
                    'zone_name' => $customer_address_data['zone_name'],
                    'zone_id' => $customer_address_data['zone_id'],
                    'country_id' => $customer_address_data['country_id'],
                    'country_name' => $customer_address_data['country_name']
                ];
            } else {
                $customer_address = NULL;
            }

            $customer_details = [
                'customer_id' => !empty($customer_data['customer_id']) ? $customer_data['customer_id'] : '',
                'customer_ic' => !empty($customer_data['customer_ic']) ? $customer_data['customer_ic'] : '',
                'customer_name' => !empty($customer_data['customer_name']) ? $customer_data['customer_name'] : '',
                'telephone' => !empty($customer_data['telephone']) ? $customer_data['telephone'] : '',
                'email' => !empty($customer_data['email']) ? $customer_data['email'] : ''
            ];

            if (!empty($clinical_sale_products)) {
                foreach ($clinical_sale_products as $clinical_sale_product) {
                    $dosage = $clinical_sale_product['times'];
                    $daily_take = $clinical_sale_product['day'];

                    $product_name = $this->model_android_brewing_brewing->getProductName($clinical_sale_product['product_id']);

                    $product[] = [
                        'product_id' => $clinical_sale_product['product_id'],
                        'quantity' => $clinical_sale_product['quantity'],
                        'product_name' => $product_name,
                        'weight' => $clinical_sale_product['weight'],
                        'weight_class' => 'g'
                    ];
                }
            }

            $prescription = [
                'dosage' => !empty($dosage) ? $dosage : 1,
                'daily_take' => !empty($daily_take) ? $daily_take : 2,
                'weight_class' => 'g'
            ];

            $post_data = [
                'product' => !empty($product) ? $product : [],
                'dosage' => $prescription['dosage'],
                'daily_take' => !empty($prescription['daily_take']) ? $prescription['daily_take'] : [],
                'brewing_type_id' => 3
            ];

            $product_list = HTTP_API . 'index.php?route=etcm/brewing/product/MatchCSProductWithETCM';

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_URL, $product_list);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            curl_close($ch);

            $final_result = json_decode($result, true);

            $products_not_exist = [];

            $product_exist = [];

            if (!empty($final_result['product_available'])) {
                foreach ($final_result['product_available'] as $products) {
                    foreach ($products as $product) {
                        $weight_class_id = !empty($product['weight_class_id']) ? $product['weight_class_id'] : '';

                        $weight_class = $this->model_android_brewing_brewing->getWeightClass($weight_class_id);

                        $product_exist[] = [
                            'product_id' => !empty($product['product_id']) ? $product['product_id'] : '',
                            'quantity' => !empty($product['quantity']) ? $product['quantity'] : '',
                            'product_name' => !empty($product['product_name']) ? $product['product_name'] : '',
                            'weight' => !empty($product['weight']) ? $product['weight'] : '',
                            'weight_class' => $weight_class,
                            'available_in_etcm' => 1
                        ];

                        $this->cart->addProduct($product['product_id'], $product['quantity']);

                        $product_in_etcm = 1;
                    }
                }
            }

            if (!empty($final_result['product_not_available'])) {
                foreach ($final_result['product_not_available'] as $product_not_available) {
                    $products_not_exist[] = [
                        'product_name' => $product_not_available['products'],
                        'product_id' => $product_not_available['product_id'],
                        'available_in_etcm' => 0
                    ];

                    $product_in_etcm = 0;
                }
            } else {
                $product_in_etcm = 1;
            }

            $brewing_data = [
                'customer' => $customer_details,
                'address' => $customer_address,
                'remark' => '',
                'brewingtype' => 3,
                'product' => $product_exist,
                'no_product' => $products_not_exist,
                'product_exist' => !empty($product_in_etcm) ? $product_in_etcm : 0,
                'prescription' => $prescription,
                'image' => !empty($image) ? $image : [],
                'selected_store' => null,
                'total' => array(),
                'shipping_method' => null,
                'payment_method' => null
            ];

            $data = array(
                'customer_data' => json_encode($brewing_data),
                'customer_id' => $clinical_sale_info['customer_id'],
                'user_id' => $user_data['user_id'],
                'store_id' => $user_data['store_id'],
                'clinical_sale_id' => $clinical_sale_id
            );

            if ($data) {
                $add_customer_to_herbal_request = $this->model_android_brewing_brewing->addHerbalRequestFromClinicalSale($data);

                $this->model_android_brewing_brewing->updateRequestStatusToCS($clinical_sale_id);

                $this->model_android_brewing_brewing->insertHerbalRequestRemark($add_customer_to_herbal_request, 1, '');

                $data_post_to_notification = [
                    'herbal_request_id' => $add_customer_to_herbal_request,
                    'customer_name' => $customer_data['customer_name']
                ];

                $this->send_notification($data_post_to_notification);

                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'succes'
                );
                $json['herbal_request_id'] = $add_customer_to_herbal_request;
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'failed to get post data',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'failed to get post data',
            );
        }

        return $json;
    }

    public function getClinicalSaleStatus() {
        $this->load->model('android/brewing/brewing');

        $clinical_sale_id = isset($this->request->get['clinical_sale_id']) ? $this->request->get['clinical_sale_id'] : false;

        if (!($clinical_sale_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($clinical_sale_id) {
            $herbal_request_status = $this->model_android_brewing_brewing->getClinicalSaleData($clinical_sale_id);

            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'succes'
            );
            $json['herbal_request_status'] = $herbal_request_status;
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'failed to get post data',
            );
        }

        return $json;
    }

    public function getBrewingDetailHistory() {
        $this->load->model('android/brewing/brewing');

        $this->load->library('herbal_request_brewing_cart');
        $this->cart = new Herbal_request_brewing_cart($this->registry);

        $herbal_request_id = isset($this->request->get['herbal_request_id']) ? $this->request->get['herbal_request_id'] : false;

        if (!($herbal_request_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        $json['brewing_detail'] = [];

        $data = [];

        if ($herbal_request_id) {

            $api_url = HTTP_API . 'index.php?route=etcm/brewing/brewing/getBrewingDetailHistory';

            $post_data = [
                'herbal_request_id' => $herbal_request_id
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            curl_close($ch);

            $result_arr = json_decode($result, true);

            $herbal_order_info = $result_arr['herbal_order_info'];

            $herbal_request_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            if (!empty($herbal_request_info['data'])) {
                $decoded_customer_data = json_decode($herbal_request_info['data'], true);

                $product = $decoded_customer_data['product'];

                $getbrewingtype = $this->getBrewingType();

                if (!empty($decoded_customer_data['brewingtype'])) {
                    foreach ($getbrewingtype['brewing_type'] as $brewing) {
                        if ($brewing['brewing_type_id'] == $decoded_customer_data['brewingtype']) {
                            $brewing_type_name = $brewing['code'];
                            $brewing_type = $brewing['name'];
                        }
                    }
                }

                if (!empty($decoded_customer_data['image'])) {
                    if (!empty($herbal_request_info['clinical_sale_id'])) {
                        foreach ($decoded_customer_data['image'] as $images) {
                            $image[] = HTTPS_SERVER . 'image/' . $images;
                        }
                    } else {
                        foreach ($decoded_customer_data['image'] as $images) {
                            $image[] = HTTPS_SERVER . 'image/' . $images;
                        }
                    }
                }

                $json['brewing_detail'] = [
                    'herbal_request_id' => $herbal_request_info['herbal_request_id'],
                    'customer_id' => $herbal_request_info['customer_id'],
                    'invoice_no' => $herbal_request_info['invoice_no'],
                    'order_date' => !empty($herbal_order_info['date_added']) ? $herbal_order_info['date_added'] : '',
                    'seller_store_name' => !empty($herbal_order_info['seller_store_name']) ? $herbal_order_info['seller_store_name'] : '',
                    'invoice_prefix' => !empty($herbal_order_info['buyer_invoice_prefix']) ? $herbal_order_info['buyer_invoice_prefix'] : '',
                    'customer' => $decoded_customer_data['customer'],
                    'address' => $decoded_customer_data['address'],
                    'brewingtype' => !empty($brewing_type_name) ? $brewing_type_name : '',
                    'brewingtype_name' => !empty($brewing_type) ? $brewing_type : '',
                    'remark' => $decoded_customer_data['remark'],
                    'product' => !empty($product) ? $product : [],
                    'prescription' => $decoded_customer_data['prescription'],
                    'image' => !empty($image) ? $image : [],
                    'total_value' => !empty($decoded_customer_data['total']) ? $decoded_customer_data['total'] : '',
                    'order_status' => !empty($result_arr['order_status']) ? $result_arr['order_status'] : '',
                    'shipping_method_name' => !empty($herbal_order_info['shipping_method']) ? $herbal_order_info['shipping_method'] : null,
                    'payment_method_name' => !empty($herbal_order_info['payment_method']) ? $herbal_order_info['payment_method'] : null,
                    'accepted_status' => $herbal_request_info['accepted_status']
                ];

                if (!empty($json['brewing_detail'])) {

                    $json['error_code'] = array(
                        'error' => 0,
                        'msj' => 'succes',
                    );
                } else {

                    $json['error_code'] = array(
                        'error' => 1,
                        'msj' => 'No Result Found',
                    );
                }
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'No Herbal Request History Data Found',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'No Herbal Request ID found',
            );
        }

        return $json;
    }

    public function editCustomer() {
        $this->load->model('android/brewing/brewing');
        $this->load->model('android/brewing/customer');

        $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
        $customer_id = isset($this->request->post['customer_id']) ? $this->request->post['customer_id'] : false;

        if (!($herbal_request_id && $customer_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_request_id && $customer_id) {
            $customer_info = $this->model_android_brewing_customer->getCustomerbyID($customer_id);

            $customer_address_data = $this->model_android_brewing_customer->getCustomerbyAddressID($customer_id);

            $herbal_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $decoded_customer_data = json_decode($herbal_info['data'], true);

            if (!empty($customer_address_data)) {
                $decoded_customer_data['address'] = [
                    'firstname' => $customer_address_data['firstname'],
                    'lastname' => $customer_address_data['lastname'],
                    'company' => $customer_address_data['company'],
                    'address_id' => $customer_address_data['address_id'],
                    'address_1' => $customer_address_data['address_1'],
                    'address_2' => $customer_address_data['address_2'],
                    'address_3' => $customer_address_data['address_3'],
                    'city' => $customer_address_data['city'],
                    'postcode' => $customer_address_data['postcode'],
                    'zone_name' => $customer_address_data['zone_name'],
                    'zone_id' => $customer_address_data['zone_id'],
                    'country_id' => $customer_address_data['country_id'],
                    'country_name' => $customer_address_data['country_name']
                ];
            } else {
                $decoded_customer_data['address'] = NULL;
            }

            $decoded_customer_data['customer'] = [
                'customer_id' => !empty($customer_info['customer_id']) ? $customer_info['customer_id'] : '',
                'customer_ic' => !empty($customer_info['customer_ic']) ? $customer_info['customer_ic'] : '',
                'customer_name' => !empty($customer_info['customer_name']) ? $customer_info['customer_name'] : '',
                'telephone' => !empty($customer_info['telephone']) ? $customer_info['telephone'] : '',
                'email' => !empty($customer_info['email']) ? $customer_info['email'] : ''
            ];

            $customer_data = json_encode($decoded_customer_data);

            if (!empty($customer_data && $herbal_request_id)) {
                $this->model_android_brewing_brewing->editCustomerDetail($customer_data, $herbal_request_id, $customer_id);

                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'Successful updated herbal request id'
                );
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'fail to update data',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'no herbal request id or customer id found',
            );
        }

        return $json;
    }

    public function cancelHerbalRequest() {
        $this->load->model('android/brewing/brewing');

        $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
        $order_status_id = isset($this->request->post['order_status_id']) ? $this->request->post['order_status_id'] : false;
        $remark = isset($this->request->post['remark']) ? $this->request->post['remark'] : false;

        if (!($herbal_request_id && $order_status_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_request_id && $order_status_id) {
            $this->model_android_brewing_brewing->updateHerbalRequestOrderStatus($herbal_request_id, $order_status_id);

            $this->model_android_brewing_brewing->insertHerbalRequestRemark($herbal_request_id, $order_status_id, $remark);

            $api_url = HTTP_API . 'index.php?route=etcm/brewing/brewing/cancelHerbalRequest';

            $post_data = [
                'herbal_request_id' => $herbal_request_id,
                'order_status_id' => $order_status_id,
                'hosting' => HTTP_SERVER,
                'remark' => $remark
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            curl_close($ch);

            $result_arr = json_decode($result, true);

            $herbal_request_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $decoded_customer_data = json_decode($herbal_request_info['data'], true);

            $customer_info = $decoded_customer_data['customer'];

            $order_status = $this->model_android_brewing_brewing->getOrderStatus($order_status_id);

            $user_id = $herbal_request_info['added_by'];

            $notification_template = $this->config->get('config_gcm_herbal_request_order_status');

            if ($notification_template['status'] == '1') {
                $template_title = $notification_template['title'];
                $template_message = $notification_template['message'];

                $find_title = array(
                    '{customer_name}'
                );

                $replace_title = array(
                    'customer_name' => $customer_info['customer_name']
                );

                $find_message = array(
                    '{invoice_prefix}',
                    '{order_status}'
                );

                $replace_message = array(
                    'invoice_prefix' => $herbal_request_info['invoice_prefix'],
                    'order_status' => $order_status
                );

                $notification_title = str_replace($find_title, $replace_title, $template_title);
                $notification_message = str_replace($find_message, $replace_message, $template_message);

                $notification_data = array(
                    'body' => $notification_title,
                    'badge' => 1,
                    'sound' => 'ping.aiff'
                );

                $data_gcm = array(
                    'title' => $notification_title,
                    'message' => $notification_message,
                    'user_id' => $user_id,
                    'type' => 2
                );

                $doctor_device = $this->model_android_brewing_brewing->getDoctorDevice($user_id);

                if (!empty($doctor_device)) {
                    $gcm = new GCM($this->registry);
                    $gcm->sendTo($gcm->get_user_token($user_id))
                            ->setData($data_gcm)
                            ->setIosNotification($notification_data)
                            ->setContentAvailable(true)
                            ->send();
                }
            }

            $notification = new Notification($this->registry);

            $notification_data = [
                'herbal_request_id' => $herbal_request_id,
                'invoice_prefix' => $herbal_request_info['invoice_prefix'],
                'customer_name' => $customer_info['customer_name'],
                'order_status' => $order_status_id
            ];

            if (($notification->new_clinical_sale_notification_status == '1') && ($notification->notification_status == '1')) {
                $notification->add_notification('herbal_request_order_status_notification', $notification_data);
            }

            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'Successful cancelled herbal request'
            );
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'no herbal request id found',
            );
        }

        return $json;
    }

    public function updateReceivedOrderStatus() {
        $this->load->model('android/brewing/brewing');

        $herbal_request_id = isset($this->request->get['herbal_request_id']) ? $this->request->get['herbal_request_id'] : false;
        $order_status_id = isset($this->request->get['order_status_id']) ? $this->request->get['order_status_id'] : false;
        $remark = isset($this->request->get['remark']) ? $this->request->get['remark'] : false;

        if (!empty($herbal_request_id && $order_status_id)) {
            $this->model_android_brewing_brewing->updateReceivedRequestOrderStatus($herbal_request_id, $order_status_id);

            $this->model_android_brewing_brewing->insertHerbalRequestRemark($herbal_request_id, $order_status_id, $remark);

            $api_url = HTTP_API . 'index.php?route=etcm/brewing/brewing/updateReceivedOrderStatus';

            $post_data = [
                'herbal_request_id' => $herbal_request_id,
                'hosting' => HTTP_SERVER,
                'order_status_id' => $order_status_id,
                'remark' => $remark
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            curl_close($ch);

            $result_arr = json_decode($result, true);

            $herbal_request_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $decoded_customer_data = json_decode($herbal_request_info['data'], true);

            $customer_info = $decoded_customer_data['customer'];

            $order_status = $this->model_android_brewing_brewing->getOrderStatus($order_status_id);

            $user_id = $herbal_request_info['added_by'];

            $notification_template = $this->config->get('config_gcm_herbal_request_order_status');

            if ($notification_template['status'] == '1') {
                $template_title = $notification_template['title'];
                $template_message = $notification_template['message'];

                $find_title = array(
                    '{customer_name}'
                );

                $replace_title = array(
                    'customer_name' => $customer_info['customer_name']
                );

                $find_message = array(
                    '{invoice_prefix}',
                    '{order_status}'
                );

                $replace_message = array(
                    'invoice_prefix' => $herbal_request_info['invoice_prefix'],
                    'order_status' => $order_status
                );

                $notification_title = str_replace($find_title, $replace_title, $template_title);
                $notification_message = str_replace($find_message, $replace_message, $template_message);

                $notification_data = array(
                    'body' => $notification_title,
                    'badge' => 1,
                    'sound' => 'ping.aiff'
                );

                $data_gcm = array(
                    'title' => $notification_title,
                    'message' => $notification_message,
                    'user_id' => $user_id,
                    'type' => 2
                );

                $doctor_device = $this->model_android_brewing_brewing->getDoctorDevice($user_id);

                if (!empty($doctor_device)) {
                    $gcm = new GCM($this->registry);
                    $gcm->sendTo($gcm->get_user_token($user_id))
                            ->setData($data_gcm)
                            ->setIosNotification($notification_data)
                            ->setContentAvailable(true)
                            ->send();
                }
            }

            $notification = new Notification($this->registry);

            $notification_data = [
                'herbal_request_id' => $herbal_request_id,
                'invoice_prefix' => $herbal_request_info['invoice_prefix'],
                'customer_name' => $customer_info['customer_name'],
                'order_status' => $order_status_id
            ];

            if (($notification->new_clinical_sale_notification_status == '1') && ($notification->notification_status == '1')) {
                $notification->add_notification('herbal_request_order_status_notification', $notification_data);
            }

            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'Update herbal request order status to complete successful',
            );
        } else {

            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'No Result Found',
            );
        }

        return $json;
    }

    public function send_notification($data) {
        $this->load->model('android/brewing/brewing');

        $data_post = [
            'herbal_request_id' => $data['herbal_request_id'],
            'customer_name' => $data['customer_name']
        ];

        $user_info = $this->revers_base64($this->hash);

        $invoice_prefix = $this->model_android_brewing_brewing->getHerbalRequestInvoice($data_post['herbal_request_id']);

        $notification_template = $this->config->get('config_gcm_herbal_request');

        if ($notification_template['status'] == '1') {
            $template_title = $notification_template['title'];
            $template_message = $notification_template['message'];

            $find_title = array(
                '{customer_name}'
            );

            $replace_title = array(
                'customer_name' => $data_post['customer_name']
            );

            $find_message = array(
                '{invoice_prefix}'
            );

            $replace_message = array(
                'invoice_prefix' => $invoice_prefix
            );

            $notification_title = str_replace($find_title, $replace_title, $template_title);
            $notification_message = str_replace($find_message, $replace_message, $template_message);

            $notification_data = array(
                'body' => $notification_title,
                'badge' => 1,
                'sound' => 'ping.aiff'
            );

            $data_gcm = array(
                'title' => $notification_title,
                'message' => $notification_message,
                'user_id' => $user_info['user_id'],
                'type' => 2
            );

            $doctor_device = $this->model_android_brewing_brewing->getDoctorDevice($user_info['user_id']);

            if (!empty($doctor_device)) {
                $gcm = new GCM($this->registry);
                $gcm->sendTo($gcm->get_user_token($user_info['user_id']))
                        ->setData($data_gcm)
                        ->setIosNotification($notification_data)
                        ->setContentAvailable(true)
                        ->send();
            }
        }


        $notification = new Notification($this->registry);

        $notification_data = [
            'herbal_request_id' => $data_post['herbal_request_id'],
            'invoice_prefix' => $invoice_prefix,
            'customer_name' => $data_post['customer_name']
        ];

        if (($notification->new_clinical_sale_notification_status == '1') && ($notification->notification_status == '1')) {
            $notification->add_notification('new_clinical_sale_notification', $notification_data);
        }
    }

    public function getOrderStatus() {
        $this->load->model('android/brewing/brewing');

        if (!empty($this->request->post)) {
            $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
            $order_status = isset($this->request->post['order_status']) ? $this->request->post['order_status'] : false;

            if (!empty($herbal_request_id)) {
                $this->model_android_brewing_brewing->updateRequestOrderStatus($herbal_request_id, $order_status);

                $herbal_request_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

                $decoded_customer_data = json_decode($herbal_request_info['data'], true);

                $customer_info = $decoded_customer_data['customer'];

                $order_status = $this->model_android_brewing_brewing->getOrderStatus($order_status);

                $user_info = $this->revers_base64($this->hash);

                $notification_template = $this->config->get('config_gcm_herbal_request_order_status');

                if ($notification_template['status'] == '1') {
                    $template_title = $notification_template['title'];
                    $template_message = $notification_template['message'];

                    $find_title = array(
                        '{customer_name}'
                    );

                    $replace_title = array(
                        'customer_name' => $customer_info['customer_name']
                    );

                    $find_message = array(
                        '{invoice_prefix}',
                        '{order_status}'
                    );

                    $replace_message = array(
                        'invoice_prefix' => $herbal_request_info['invoice_prefix'],
                        'order_status' => $order_status
                    );

                    $notification_title = str_replace($find_title, $replace_title, $template_title);
                    $notification_message = str_replace($find_message, $replace_message, $template_message);

                    $notification_data = array(
                        'body' => $notification_title,
                        'badge' => 1,
                        'sound' => 'ping.aiff'
                    );

                    $data_gcm = array(
                        'title' => $notification_title,
                        'message' => $notification_message,
                        'user_id' => $user_info['user_id'],
                        'type' => 2
                    );

                    $doctor_device = $this->model_android_brewing_brewing->getDoctorDevice($user_info['user_id']);

                    if (!empty($doctor_device)) {
                        $gcm = new GCM($this->registry);
                        $gcm->sendTo($gcm->get_user_token($user_info['user_id']))
                                ->setData($data_gcm)
                                ->setIosNotification($notification_data)
                                ->setContentAvailable(true)
                                ->send();
                    }
                }

                $notification = new Notification($this->registry);

                $notification_data = [
                    'herbal_request_id' => $herbal_request_id,
                    'invoice_prefix' => $herbal_request_info['invoice_prefix'],
                    'customer_name' => $customer_info['customer_name'],
                    'order_status' => $order_status
                ];

                if (($notification->new_clinical_sale_notification_status == '1') && ($notification->notification_status == '1')) {
                    $notification->add_notification('herbal_request_order_status_notification', $notification_data);
                }

                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'Update order successful',
                );
            } else {

                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'No Result Found',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'Cannot get post data',
            );
        }
        return $json;
    }

    public function getOrderStatusWithRemark() {
        $this->load->model('android/brewing/brewing');

        if ($this->request->post) {
            $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
            $order_status = isset($this->request->post['order_status_id']) ? $this->request->post['order_status_id'] : false;
            $remark = isset($this->request->post['remark']) ? $this->request->post['remark'] : false;
//            $shipped_status = isset($this->request->post['shipped_status']) ? $this->request->post['shipped_status'] : false;

            if (!empty($herbal_request_id)) {
                $this->model_android_brewing_brewing->updateRequestOrderStatus($herbal_request_id, $order_status);

                $this->model_android_brewing_brewing->insertHerbalRequestRemark($herbal_request_id, $order_status, $remark);

                $herbal_request_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

                $decoded_customer_data = json_decode($herbal_request_info['data'], true);

                $customer_info = $decoded_customer_data['customer'];

                $order_status = $this->model_android_brewing_brewing->getOrderStatus($order_status);

                $user_id = $herbal_request_info['added_by'];

                $notification_template = $this->config->get('config_gcm_herbal_request_order_status');

                if ($notification_template['status'] == '1') {
                    $template_title = $notification_template['title'];
                    $template_message = $notification_template['message'];

                    $find_title = array(
                        '{customer_name}'
                    );

                    $replace_title = array(
                        'customer_name' => $customer_info['customer_name']
                    );

                    $find_message = array(
                        '{invoice_prefix}',
                        '{order_status}'
                    );

                    $replace_message = array(
                        'invoice_prefix' => $herbal_request_info['invoice_prefix'],
                        'order_status' => $order_status
                    );

                    $notification_title = str_replace($find_title, $replace_title, $template_title);
                    $notification_message = str_replace($find_message, $replace_message, $template_message);

                    $notification_data = array(
                        'body' => $notification_title,
                        'badge' => 1,
                        'sound' => 'ping.aiff'
                    );

                    $data_gcm = array(
                        'title' => $notification_title,
                        'message' => $notification_message,
                        'user_id' => $user_id,
                        'type' => 2
                    );

                    $doctor_device = $this->model_android_brewing_brewing->getDoctorDevice($user_id);

                    if (!empty($doctor_device)) {
                        $gcm = new GCM($this->registry);
                        $gcm->sendTo($gcm->get_user_token($user_id))
                                ->setData($data_gcm)
                                ->setIosNotification($notification_data)
                                ->setContentAvailable(true)
                                ->send();
                    }
                }

                $notification = new Notification($this->registry);

                $notification_data = [
                    'herbal_request_id' => $herbal_request_id,
                    'invoice_prefix' => $herbal_request_info['invoice_prefix'],
                    'customer_name' => $customer_info['customer_name'],
                    'order_status' => $order_status
                ];

                if (($notification->new_clinical_sale_notification_status == '1') && ($notification->notification_status == '1')) {
                    $notification->add_notification('herbal_request_order_status_notification', $notification_data);
                }

                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'Update order successful',
                );
            } else {

                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'No Result Found',
                );
            }
        } $json['error_code'] = array(
            'error' => 1,
            'msj' => 'Cannot get post data',
        );

        return $json;
    }

    public function updateStatusToShipped() {
        $this->load->model('android/brewing/brewing');

        if ($this->request->post) {
            $herbal_request_id = isset($this->request->post['herbal_request_id']) ? $this->request->post['herbal_request_id'] : false;
            $order_status = isset($this->request->post['order_status_id']) ? $this->request->post['order_status_id'] : false;
            $remark = isset($this->request->post['remark']) ? $this->request->post['remark'] : false;

            if (!empty($herbal_request_id)) {
                $this->model_android_brewing_brewing->updateRequestToShipped($herbal_request_id, $order_status);

                $this->model_android_brewing_brewing->insertHerbalRequestRemark($herbal_request_id, $order_status, $remark);

                $herbal_request_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

                $decoded_customer_data = json_decode($herbal_request_info['data'], true);

                $customer_info = $decoded_customer_data['customer'];

                $order_status = $this->model_android_brewing_brewing->getOrderStatus($order_status);

                $user_id = $herbal_request_info['added_by'];

                $notification_template = $this->config->get('config_gcm_herbal_request_order_status');

                if ($notification_template['status'] == '1') {
                    $template_title = $notification_template['title'];
                    $template_message = $notification_template['message'];

                    $find_title = array(
                        '{customer_name}'
                    );

                    $replace_title = array(
                        'customer_name' => $customer_info['customer_name']
                    );

                    $find_message = array(
                        '{invoice_prefix}',
                        '{order_status}'
                    );

                    $replace_message = array(
                        'invoice_prefix' => $herbal_request_info['invoice_prefix'],
                        'order_status' => $order_status
                    );

                    $notification_title = str_replace($find_title, $replace_title, $template_title);
                    $notification_message = str_replace($find_message, $replace_message, $template_message);

                    $notification_data = array(
                        'body' => $notification_title,
                        'badge' => 1,
                        'sound' => 'ping.aiff'
                    );

                    $data_gcm = array(
                        'title' => $notification_title,
                        'message' => $notification_message,
                        'user_id' => $user_id,
                        'type' => 2
                    );

                    $doctor_device = $this->model_android_brewing_brewing->getDoctorDevice($user_id);

                    if (!empty($doctor_device)) {
                        $gcm = new GCM($this->registry);
                        $gcm->sendTo($gcm->get_user_token($user_id))
                                ->setData($data_gcm)
                                ->setIosNotification($notification_data)
                                ->setContentAvailable(true)
                                ->send();
                    }
                }

                $notification = new Notification($this->registry);

                $notification_data = [
                    'herbal_request_id' => $herbal_request_id,
                    'invoice_prefix' => $herbal_request_info['invoice_prefix'],
                    'customer_name' => $customer_info['customer_name'],
                    'order_status' => $order_status
                ];

                if (($notification->new_clinical_sale_notification_status == '1') && ($notification->notification_status == '1')) {
                    $notification->add_notification('herbal_request_order_status_notification', $notification_data);
                }

                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'Update order successful',
                );
            } else {

                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'No Result Found',
                );
            }
        } $json['error_code'] = array(
            'error' => 1,
            'msj' => 'Cannot get post data',
        );

        return $json;
    }

    public function getHerbalRequestRemark() {
        $this->load->model('android/brewing/brewing');

        $herbal_request_id = isset($this->request->get['herbal_request_id']) ? $this->request->get['herbal_request_id'] : false;

        if (!($herbal_request_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_request_id) {
            $herbal_request_remarks = $this->model_android_brewing_brewing->getHerbalRequestRemark($herbal_request_id);

            $single_herbal_request_remark = $this->model_android_brewing_brewing->getSingleHerbalRequestRemark($herbal_request_id);

            $json['herbal_request_remarks'] = [];

            foreach ($herbal_request_remarks as $herbal_request_remark) {

                $order_status_name = $this->model_android_brewing_brewing->getOrderStatus($herbal_request_remark['order_status_id']);

                if ($single_herbal_request_remark['herbal_request_remark_id'] == $herbal_request_remark['herbal_request_remark_id']) {
                    $json['herbal_request_remarks'][] = [
                        'herbal_request_remark_id' => $herbal_request_remark['herbal_request_remark_id'],
                        'remark' => !empty($herbal_request_remark['remark']) ? $herbal_request_remark['remark'] : '',
                        'order_status_name' => !empty($order_status_name) ? $order_status_name : '',
                        'date' => date('d M', strtotime($herbal_request_remark['date_added'])),
                        'time' => date('H:iA', (strtotime($herbal_request_remark['date_added']))),
                        'color' => 1,
                        'dot' => 1
                    ];
                } else {
                    $json['herbal_request_remarks'][] = [
                        'herbal_request_remark_id' => $herbal_request_remark['herbal_request_remark_id'],
                        'remark' => !empty($herbal_request_remark['remark']) ? $herbal_request_remark['remark'] : '',
                        'order_status_name' => !empty($order_status_name) ? $order_status_name : '',
                        'date' => date('d M', strtotime($herbal_request_remark['date_added'])),
                        'time' => date('H:iA', (strtotime($herbal_request_remark['date_added']))),
                        'color' => 0,
                        'dot' => 0
                    ];
                }

                $sort_order = [];

                foreach ($json['herbal_request_remarks'] as $key => $value) {
                    $sort_order[$key] = $value['herbal_request_remark_id'];
                }

                array_multisort($sort_order, SORT_DESC, $json['herbal_request_remarks']);
            }

            if (!empty($json['herbal_request_remark'])) {
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'Successful get herbal request remarks'
                );
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'fail to get herbal request remarks',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'No Result Found',
            );
        }

        return $json;
    }

    public function getSingleHerbalRequestRemark() {
        $this->load->model('android/brewing/brewing');

        $herbal_request_id = isset($this->request->get['herbal_request_id']) ? $this->request->get['herbal_request_id'] : false;

        if (!($herbal_request_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($herbal_request_id) {
            $herbal_request_remark = $this->model_android_brewing_brewing->getSingleHerbalRequestRemark($herbal_request_id);

            if ($herbal_request_remark) {
                $order_status_id = !empty($herbal_request_remark['order_status_id']) ? $herbal_request_remark['order_status_id'] : '';

                $json['herbal_request_remark'] = [];

                $order_status_name = $this->model_android_brewing_brewing->getOrderStatus($order_status_id);

                $json['herbal_request_remark'] = [
                    'herbal_request_remark_id' => $herbal_request_remark['herbal_request_remark_id'],
                    'remark' => !empty($herbal_request_remark['remark']) ? $herbal_request_remark['remark'] : '',
                    'order_status_name' => !empty($order_status_name) ? $order_status_name : '',
                    'date' => !empty($herbal_request_remark['date_added']) ? date($this->language->get('date_format_short'), strtotime($herbal_request_remark['date_added'])) : '',
                    'time' => !empty($herbal_request_remark['date_added']) ? date('h:i:sA', (strtotime($herbal_request_remark['date_added']))) : ''
                ];

                if (!empty($json['herbal_request_remark'])) {
                    $json['error_code'] = array(
                        'error' => 0,
                        'msj' => 'Successful get single herbal request remark'
                    );
                } else {
                    $json['error_code'] = array(
                        'error' => 1,
                        'msj' => 'fail to get single herbal request remark',
                    );
                }
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'No Result Found',
                );
            }
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'Fail to get herbal request remark id',
            );
        }

        return $json;
    }

    public function getBuyerImage() {
        $this->load->model('android/brewing/brewing');

        if (!empty($this->request->post)) {
            $herbal_request_id = isset($this->request->post['buyer_request_id']) ? $this->request->post['buyer_request_id'] : false;

            $herbal_request_info = $this->model_android_brewing_brewing->getHerbalListById($herbal_request_id);

            $decoded_customer_data = json_decode($herbal_request_info['data'], true);

            $json['customer_image'] = [];
            
            foreach ($decoded_customer_data['image'] as $images) {
                $image_url[] = HTTPS_IMAGE . $images;
            }

            $json['customer_image'] = !empty($image_url) ? $image_url : [];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

}
