<?php

class ControllerAndroidBrewingAddress extends Controller {

    private $opencart_version;
    private $call_function;
    private $hash;
    private $app_hash;
    private $s;
    private $post_data;
    private $push_currency_code;
    private $store_id;
    private $currency_code;

    const MODULE_CODE = 16;
    const MODULE_VERSION = '1.1.11';
    const PUSH_TYPE_NEW_ORDER = "new_order";
    const PUSH_TYPE_CHANGE_ORDER_STATUS = "order_changed";
    const PUSH_TYPE_NEW_CUSTOMER = "new_customer";
    const DEBUG_MODE = false;
    const MOB_ASSIST_API_KEY = "AIzaSyDIq4agB70Zv7AkB9pVuF2KxcU4WQ94CVI";

    public function index() {
        @date_default_timezone_set('UTC');
        $this->check_version();

        $this->load->model('android/setting');
        $this->load->model('android/connector');

        $this->s = $this->model_android_setting->getSetting('andassist');
        $this->config->set('config_language_id', $this->model_android_setting->getlangugeId());

        if (!isset($this->s['andassist_status'])) {
            $data['error_code'] = array(
                'error' => -1,
                'msj' => 'API disable',
                'app_hash' => $this->app_hash,
                'test' => 'index_isset_andassist_status',
            );

            $this->generate_output($data);
        }

        $request = $this->request->request;

        $post = $this->request->post;

        if (isset($request['callback']) && strlen($request['callback']) > 0) {
            $this->callback = $request['callback'];
        }

        if (isset($request['call_function']) && strlen($request['call_function']) > 0) {
            $this->call_function = $request['call_function'];
        }

        if (isset($request['hash']) && strlen($request['hash']) > 0) {
            $this->hash = $request['hash'];
        }

        if (isset($request['app_hash']) && strlen($request['app_hash']) > 0) {
            $this->app_hash = $request['app_hash'];
        }

        if (empty($this->call_function)) {
            $this->run_self_test();
        }

        if (!$this->check_confing()) {
            $data['error_code'] = array(
                'error' => -1,
                'msj' => 'API disable',
                'app_hash' => $this->app_hash,
                'test' => 'index_check_confing'
            );

            $this->generate_output($data);
        }

        if (!$this->check_auth()) {
            $data['error_code'] = array(
                'error' => -2,
                'msj' => 'Password Not Match',
            );

            $this->generate_output($data);
        }

        if ($this->call_function == 'test_config') {
            $this->generate_output(array('test' => 1));
        }

        $params = $this->_validate_types($request, array(
            'show' => 'INT',
            'page' => 'INT',
            'search_order_id' => 'STR',
            'orders_from' => 'STR',
            'orders_to' => 'STR',
            'customers_from' => 'STR',
            'customers_to' => 'STR',
            'date_from' => 'STR',
            'date_to' => 'STR',
            'graph_from' => 'STR',
            'graph_to' => 'STR',
            'stats_from' => 'STR',
            'stats_to' => 'STR',
            'products_to' => 'STR',
            'products_from' => 'STR',
            'order_id' => 'INT',
            'user_id' => 'INT',
            'params' => 'STR',
            'val' => 'STR',
            'search_val' => 'STR',
            'statuses' => 'STR',
            'sort_by' => 'STR',
            'last_order_id' => 'STR',
            'product_id' => 'INT',
            'get_statuses' => 'INT',
            'cust_with_orders' => 'INT',
            'data_for_widget' => 'INT',
            'registration_id' => 'STR',
            'registration_id_old' => 'STR',
            'api_key' => 'STR',
            'push_new_order' => 'INT',
            'push_order_statuses' => 'STR',
            'push_new_customer' => 'INT',
            'app_connection_id' => 'STR',
            'push_currency_code' => 'STR',
            'action' => 'STR',
            'carrier_code' => 'STR',
            'custom_period' => 'INT',
            'store_id' => 'STR',
            'new_status' => 'INT',
            'notify_customer' => 'INT',
            'currency_code' => 'STR',
            'fc' => 'STR',
            'module' => 'STR',
            'controller' => 'STR',
            'change_order_status_comment' => 'STR',
            'param' => 'STR',
            'new_value' => 'STR',
        ));

        foreach ($params as $k => $value) {
            $this->{$k} = $value;
        }

        $this->post_data = $post;

        foreach ($this->post_data as $k => $value) {
            $this->{$k} = $value;
        }

        if (empty($this->currency_code) || $this->currency_code == 'not_set') {
            $this->currency = '';
        } else if ($this->currency_code == 'base_currency') {
            $this->currency = $this->config->get('config_currency');
        } else {
            $this->currency = $this->currency_code;
        }


        print_r($this->currency_code);

        if (empty($this->push_currency_code) || $this->push_currency_code == 'not_set') {
            $this->push_currency_code = '';
        }

        if ($this->store_id == '') {
            $this->store_id = -1;
        }

        $this->store_id = intval($this->store_id);

        if (!method_exists($this, $this->call_function)) {
            $this->generate_output('old_module');
        }

        $result = call_user_func(array($this, $this->call_function));
        $this->generate_output($result);
    }

    private function check_version() {
        if (class_exists('MijoShop')) {
            $base = MijoShop::get('base');

            $installed_ms_version = (array) $base->getMijoshopVersion();
            $mijo_version = $installed_ms_version[0];
            if (version_compare($mijo_version, '3.0.0', '>=') && version_compare(VERSION, '2.0.0.0', '<')) {
                $this->opencart_version = '2.0.1.0';
            } else {
                $this->opencart_version = VERSION;
            }
        } else {
            $this->opencart_version = VERSION;
        }
        $this->is_ver20 = version_compare($this->opencart_version, '2.0.0', '>=');
    }

    private function generate_output($data) {
        $add_bridge_version = false;

        if (in_array($this->call_function, array("test_config", "get_store_title", "get_store_stats", "get_data_graphs"))) {
            if (is_array($data) && $data != 'auth_error' && $data != 'connection_error' && $data != 'old_bridge') {
                $add_bridge_version = true;
            }
        }

        if (!is_array($data)) {
            $data = array($data);
        }

        if ($add_bridge_version) {
            $data['module_version'] = self::MODULE_CODE;
        }

        if (is_array($data)) {
            array_walk_recursive($data, array($this, 'reset_null'));
        }

        $data = json_encode($data);

        if ($this->callback) {
            header('Content-Type: text/javascript;charset=utf-8');
            die($this->callback . '(' . $data . ');');
        } else {
            $this->response->addHeader('Content-Type: application/json');
            $this->response->setOutput($data);
        }
    }

    private function run_self_test() {
        $html = '<h2>Mobile Assistant Connector Self Test Tool</h2>'
                . '<div style="padding: 5px; margin: 10px 0;">This tool checks your website to make sure there are no issues in your hosting configuration.<br />Your hosting support can solve all issues found here.</div><br/>'
                . '<table cellpadding=4><tr><th>Test Title</th><th>Result</th></tr>'
                . '<tr><td>Module Version</td><td>' . self::MODULE_VERSION . '</td><td></td></tr>'
                . '<tr><td>Cart Version</td><td>' . $this->opencart_version . '</td><td></td></tr>';

        if (class_exists('MijoShop')) {
            $base = MijoShop::get('base');

            $installed_ms_version = (array) $base->getMijoshopVersion();
            $mijo_version = $installed_ms_version[0];

            $html .= '<tr><td>MijoShop Version</td><td>' . $mijo_version . '</td><td></td></tr>';
            $html .= '<tr><td>MijoShop Opencart Version</td><td>' . VERSION . '</td><td></td></tr>';
        }

        $html .= '<tr><td>Default Login and Password Changed</td><td>'
                . (( $res = $this->test_default_password_is_changed() ) ? '<span style="color: #008000;">Yes</span>' : '<span style="color: #ff0000;">Fail</span>') . '</td>';

        if (!$res) {
            $html .= '<td>Change your login credentials in Mobile Assistant Connector to make your connection secure</td>';
        }

        $html .= '</table><br/>'
                . '<div style="margin-top: 15px; font-size: 13px;">Mobile Assistant Connector by <a href="http://emagicone.com" target="_blank" style="color: #15428B">eMagicOne</a></div>';

        die($html);
    }

    private function check_confing() {
        $this->load->model('android/brewing_quotation_api');
        $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');

        if (isset($this->request->request['app_hash'])) {
            if (md5($this->s['andassist_login'] . $this->s['andassist_pass']) == $this->request->request['app_hash'] && $this->s['andassist_status'] == 1) {
                return true;
            }
        }
        return false; //return true or false only can be one, either one return, the other one will stop.
    }

    private function revers_base64($data) {
        $user_info = base64_decode($data);
        $userColData = json_decode($user_info, true);
        return $userColData;
    }

    private function check_auth() {
        $userColData = $this->revers_base64($this->hash);
        $user_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE username = '" . $this->db->escape($userColData['user_name']) . "' AND (password = SHA1(CONCAT(salt, SHA1(CONCAT(salt, SHA1('" . $this->db->escape($userColData['password']) . "'))))) OR password = '" . $this->db->escape(md5($userColData['password'])) . "') AND status = 1 AND position = '2'");
        if ($user_query->num_rows) {
            $store_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_to_store s LEFT JOIN " . DB_PREFIX . "setting l ON (s.store_id = l.store_id) WHERE s.user_id = '" . (int) $user_query->row['user_id'] . "' AND s.store_id = '" . $userColData['store_id'] . "' AND l.key = 'config_language'");
            if ($store_query->num_rows) {
                if (strtotime($user_query->row['periodto']) > strtotime(date("Y-m-d"))) {
                    return true;
                } else {
                    return false;
                }
            }
        }
        return false;
    }

    private function _validate_types($array, $names) {
        foreach ($names as $name => $type) {
            if (isset($array["$name"])) {
                switch ($type) {
                    case 'INT':
                        $array["$name"] = intval($array["$name"]);
                        break;
                    case 'FLOAT':
                        $array["$name"] = floatval($array["$name"]);
                        break;
                    case 'STR':
                        $array["$name"] = str_replace(array("\r", "\n"), ' ', addslashes(htmlspecialchars(trim(url_encode($array["$name"])))));
                        break;
                    default:
                        $array["$name"] = '';
                }
            } else {
                $array["$name"] = '';
            }
        }
        return $array;
    }

    protected function hashed($data) {
        return base64_encode(json_encode($data));
    }

    protected function unhashed($data) {
        return json_decode(base64_decode($data));
    }

    private function reset_null(&$item) {
        if (empty($item) && $item != 0) {
            $item = '';
        }

        // $item = trim($item);

        $item = $item;
    }

    private function getCustomerAddresList() {
        $this->load->model('android/brewing/address');
        $json = [];
        $data = [];
        if (!empty($this->request->get)) {
            foreach ($this->request->get as $g => $get) {
                $data[$g] = $get;
            }
        }

        $json['address'] = [];

        $results = $this->model_android_brewing_address->get_address_by_id($data);


        $json['error_code'] = [
            'error' => 1,
            'msj' => 'Empty Data',
        ];

        if (!empty($results)) {
            foreach ($results as $result) {
                $json['address'][] = [
                    'customer_id' => $result['customer_id'],
                    'address_id' => $result['address_id'],
                    'telephone' => $result['telephone'],
                    'address' => $result['address'],
                ];
            }

            if ($json['address']) {
                $json['error_code'] = [
                    'error' => 0,
                    'msj' => 'succes',
                ];
            }
        }
        return $json;
    }

    public function get_store_address() {
        $this->load->model('android/brewing/address');

        $all_stores['stores'] = [];

        if ($this->check_confing()) {
            $this->load->model('setting/store');

            $stores = $this->model_setting_store->getStores();

            foreach ($stores as $store) {
                $store_info = $this->model_android_setting->getSetting('config', $store['store_id']);

                if (!empty($store_info['config_address'])) {
                    $all_stores['stores'][] = [
                        'store_id' => $store['store_id'],
                        'name' => $store['name'],
                        'address' => !empty($store_info['config_address']) ? $store_info['config_address'] : ''
                    ];
                }
            }
        }

        return $all_stores;
    }

    public function editAddress() {
        $this->load->model('android/brewing/address');

        $customer_id = isset($this->request->post['customer_id']) ? $this->request->post['customer_id'] : false;
        $address_id = isset($this->request->post['address_id']) ? $this->request->post['address_id'] : false;
        $name = isset($this->request->post['name']) ? $this->request->post['name'] : false;
        $telephone = isset($this->request->post['telephone']) ? $this->request->post['telephone'] : false;
        $customer_ic = isset($this->request->post['customer_ic']) ? $this->request->post['customer_ic'] : false;
        $company = isset($this->request->post['company']) ? $this->request->post['company'] : false;
        $address_1 = isset($this->request->post['address_1']) ? $this->request->post['address_1'] : false;
        $address_2 = isset($this->request->post['address_2']) ? $this->request->post['address_2'] : false;
        $address_3 = isset($this->request->post['address_3']) ? $this->request->post['address_3'] : false;
        $city = isset($this->request->post['city']) ? $this->request->post['city'] : false;
        $postcode = isset($this->request->post['postcode']) ? $this->request->post['postcode'] : false;
        $zone = isset($this->request->post['zone']) ? $this->request->post['zone'] : false;
        $country = isset($this->request->post['country']) ? $this->request->post['country'] : false;

        if (!($customer_id && $address_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($customer_id && $address_id) {
            $zone_id = $this->model_android_brewing_address->getZoneByName($zone);

            $country_id = $this->model_android_brewing_address->getCountryByName($country);

            $data = [
                'customer_id' => !empty($customer_id) ? $customer_id : '',
                'address_id' => !empty($address_id) ? $address_id : '',
                'name' => !empty($name) ? $name : '',
                'telephone' => !empty($telephone) ? $telephone : '',
                'customer_ic' => !empty($customer_ic) ? $customer_ic : '',
                'company' => !empty($company) ? $company : '',
                'address_1' => !empty($address_1) ? $address_1 : '',
                'address_2' => !empty($address_2) ? $address_2 : '',
                'address_3' => !empty($address_3) ? $address_3 : '',
                'city' => !empty($city) ? $city : '',
                'postcode' => !empty($postcode) ? $postcode : '',
                'zone_id' => !empty($zone_id) ? $zone_id : 1980,
                'country_id' => !empty($country_id) ? $country_id : 129
            ];

            $update_customer_address = $this->model_android_brewing_address->updateCustomerAddress($data);

            if ($update_customer_address == 0) {
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'succes'
                );
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'Insert error',
                );
            }
        }

        return $json;
    }

    public function addAddress() {
        $this->load->model('android/brewing/address');

        $customer_id = isset($this->request->post['customer_id']) ? $this->request->post['customer_id'] : false;
        $name = isset($this->request->post['name']) ? $this->request->post['name'] : false;
        $telephone = isset($this->request->post['telephone']) ? $this->request->post['telephone'] : false;
        $customer_ic = isset($this->request->post['customer_ic']) ? $this->request->post['customer_ic'] : false;
        $company = isset($this->request->post['company']) ? $this->request->post['company'] : false;
        $address_1 = isset($this->request->post['address_1']) ? $this->request->post['address_1'] : false;
        $address_2 = isset($this->request->post['address_2']) ? $this->request->post['address_2'] : false;
        $address_3 = isset($this->request->post['address_3']) ? $this->request->post['address_3'] : false;
        $city = isset($this->request->post['city']) ? $this->request->post['city'] : false;
        $postcode = isset($this->request->post['postcode']) ? $this->request->post['postcode'] : false;
        $zone = isset($this->request->post['zone']) ? $this->request->post['zone'] : false;
        $country = isset($this->request->post['country']) ? $this->request->post['country'] : false;

        if (!($customer_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($customer_id) {
            $zone_id = $this->model_android_brewing_address->getZoneByName($zone);

            $country_id = $this->model_android_brewing_address->getCountryByName($country);

            $data = [
                'customer_id' => !empty($customer_id) ? $customer_id : '',
                'name' => !empty($name) ? $name : '',
                'telephone' => !empty($telephone) ? $telephone : '',
                'customer_ic' => !empty($customer_ic) ? $customer_ic : '',
                'company' => !empty($company) ? $company : '',
                'address_1' => !empty($address_1) ? $address_1 : '',
                'address_2' => !empty($address_2) ? $address_2 : '',
                'address_3' => !empty($address_3) ? $address_3 : '',
                'city' => !empty($city) ? $city : '',
                'postcode' => !empty($postcode) ? $postcode : '',
                'zone_id' => !empty($zone_id) ? $zone_id : '',
                'country_id' => !empty($country_id) ? $country_id : ''
            ];

            $add_new_customer_address = $this->model_android_brewing_address->addCustomerAddress($data);

            if ($add_new_customer_address) {
                $json['address_id'] = $add_new_customer_address;
                $json['error_code'] = array(
                    'error' => 0,
                    'msj' => 'succes'
                );
            } else {
                $json['error_code'] = array(
                    'error' => 1,
                    'msj' => 'Insert error',
                );
            }
        }

        return $json;
    }

    public function deleteAddress() {
        $this->load->model('android/brewing/address');

        $customer_id = isset($this->request->post['customer_id']) ? $this->request->post['customer_id'] : false;
        $address_id = isset($this->request->post['address_id']) ? $this->request->post['address_id'] : false;

        if (!($customer_id && $address_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($customer_id && $address_id) {

            $data = [
                'customer_id' => $customer_id,
                'address_id' => $address_id
            ];

            $delete_address = $this->model_android_brewing_address->DeleteAddress($data);
        }

        if ($delete_address == 1) {
            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'Delete success'
            );
        }

        return $json;
    }

    public function getSingleAddressbyAddressID() {
        $this->load->model('android/brewing/address');

        $address_id = isset($this->request->post['address_id']) ? $this->request->post['address_id'] : false;

        if (!($address_id)) {
            $json['error_code'] = array(
                'error' => 1,
                'code' => 1001,
                'msj' => 'Missing Parameter'
            );

            return $json;
        }

        if ($address_id) {
            $address_detail = $this->model_android_brewing_address->getAddressByAddressID($address_id);

            $json['address'] = [
                'address_id' => $address_detail['address_id'],
                'customer_id' => $address_detail['customer_id'],
                'name' => !empty($address_detail['firstname']) ? $address_detail['firstname'] : '',
                'telephone' => !empty($address_detail['telephone']) ? $address_detail['telephone'] : '',
                'customer_ic' => !empty($address_detail['customer_ic']) ? $address_detail['customer_ic'] : '',
                'company' => !empty($address_detail['company']) ? $address_detail['company'] : '',
                'address_1' => !empty($address_detail['address_1']) ? $address_detail['address_1'] : '',
                'address_2' => !empty($address_detail['address_2']) ? $address_detail['address_2'] : '',
                'address_3' => !empty($address_detail['address_3']) ? $address_detail['address_3'] : '',
                'city' => !empty($address_detail['city']) ? $address_detail['city'] : '',
                'postcode' => !empty($address_detail['postcode']) ? $address_detail['postcode'] : '',
                'country_id' => !empty($address_detail['country_id']) ? $address_detail['country_id'] : '',
                'zone_id' => !empty($address_detail['zone_id']) ? $address_detail['zone_id'] : '',
                'zone_name' => !empty($address_detail['zone_name']) ? $address_detail['zone_name'] : '',
                'country_name' => !empty($address_detail['country_name']) ? $address_detail['country_name'] : ''
            ];
        }

        if ($json['address']) {
            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'get address success'
            );
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'get address error',
            );
        }

        return $json;
    }

    public function getStoreAddressFromETCM() {
        $store_list = HTTP_API . 'index.php?route=etcm/brewing/brewing/getStoreAddressFromETCM';

        $post_data = [
            'hosting' => HTTPS_SERVER
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_URL, $store_list);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        $json = json_decode($result, true);

        if (!empty($json)) {
            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'succes',
            );
        } else {

            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'No Result Found',
            );
        }

        return $json;
    }

    
    public function getclinicalsale() {
        $sql = "SELECT COUNT(*) AS total FROM oc_clinical_sale WHERE 1";
        
        $query = $this->db->query($sql);
        
        $json['total_clinical_sale'] = $query->row['total'];
        
        return $json;
    }
}
