<?php

class ControllerAndroidAppointmentSetting extends Controller
{
    private $editable = [
        "appointment_status",
        "min_day_advance",
        "allow_duplicate",
        "allow_attend_before_date",
        "grace_period",
        "additional_notification"
    ];

    public function index()
    {
        //load required model
        $this->load->model('android/appointment/setting');

        $this->model_name = $this->model_android_appointment_setting;

        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_form()
    {
        $result = [
            "form_fields" => [
                "services" => $this->getServices(),
                "users" => $this->getUsers(),
            ],
            "data" => $this->getSettings()
        ];
        $output = $this->response->setResponse2(200, $result, 'success', 'appointment');
        $this->api->trackResponse($output);
        return;
    }

    protected function update()
    {
        $json = $this->json;
        if (empty($json)) {
            $output = $this->response->setResponse2(400, new stdClass(), 'missing json body', 'appointment');
            $this->api->trackResponse($output);
            return;
        }

        $this->model_name->save_settings($json);
        $result = [
            "form_fields" => [
                "services" => $this->getServices(),
                "users" => $this->getUsers(),
            ],
            "data" => $this->getSettings()
        ];
        $output = $this->response->setResponse2(200, $result, 'success', 'appointment');
        $this->api->trackResponse($output);
        return;
    }

    private function getSettings()
    {
        $setting_results = [];
        foreach ($this->editable as $key) {
            $setting_results[$key] = null;
            if($key == 'additional_notification'){
                $setting_results[$key] = [];
            }
        }
        $settings = $this->model_name->getSettings();
        if (!empty($settings)) {
            foreach ($settings as $setting) {
                if (!in_array($setting['setting_key'], $this->editable)) {
                    continue;
                }
                if ($setting['serialized'] == '1') {
                    $setting_results[$setting['setting_key']] = unserialize($setting['value']);
                } else {
                    $setting_results[$setting['setting_key']] = $setting['value'];
                }
            }
        }
        return $setting_results;
    }

    private function getServices()
    {
        $result = [];
        $services = $this->model_name->getServices();
        foreach ($services as $service) {
            $result[] = array(
                'id'    => $service['id'],
                'name'  => $service['name']
            );
        }
        return $result;
    }

    private function getUsers()
    {
        $result = [];
        $users = $this->model_name->getUsers();
        foreach ($users as $user) {
            $result[] = array(
                "id"    => $user['user_id'],
                "name"    => trim($user['firstname'] . " " . $user['lastname']),
            );
        }
        return $result;
    }
}
