<?php

class ControllerAndroidAppointmentAppointment extends Controller
{
    private $json;
    private $user_info;
    private $model_name;
    private $error;
    private $selected_facility = 0;

    //status text
    private $arr_statuses_en = [
        0 => 'Pending',
        1 => 'Confirm',
        2 => 'Cancelled',
        3 => 'Attended',
        4 => 'Draft',
    ];

    private $arr_statuses_cn = [
        0 => '待确认',
        1 => '已确认',
        2 => '已取消',
        3 => '已出席',
        4 => '草稿',
    ];

    //status color
    private $arr_status_colors = [
        0 => '#000000',
        1 => '#000000',
        2 => '#000000',
        3 => '#000000',
        4 => '#000000',
    ];

    private $appointment_setting = [];

    private $appointment_fee = 5;

    private $credit_balance = null;

    public function index()
    {
        //load required model
        $this->load->model('android/appointment/appointment');

        $this->model_name = $this->model_android_appointment_appointment;

        //get appointment setting
        $this->appointment_setting = $this->get_settings();

        //get appointment color
        if (!empty($this->appointment_setting['appointment_status'])) {
            $this->arr_status_colors[0] = $this->appointment_setting['appointment_status']['pending_color'];
            $this->arr_status_colors[1] = $this->appointment_setting['appointment_status']['confirm_color'];
            $this->arr_status_colors[2] = $this->appointment_setting['appointment_status']['canceled_color'];
            $this->arr_status_colors[3] = $this->appointment_setting['appointment_status']['attended_color'];
            $this->arr_status_colors[4] = $this->appointment_setting['appointment_status']['draft_color'];
        }
        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_list()
    {
        $doctor_id = !empty($this->request->get['doctor']) ? $this->request->get['doctor'] : null;
        $customer_id = !empty($this->request->get['customer']) ? $this->request->get['customer'] : null;
        $customer_name = !empty($this->request->get['customer_name']) ? trim($this->request->get['customer_name']) : null;
        if (!(is_numeric($customer_id) && floor($customer_id) == $customer_id)) {
            $customer_name = $customer_id;
            $customer_id = null;
        }
        $service_id = !empty($this->request->get['service']) ? $this->request->get['service'] : null;

        $keyword = !empty($this->request->get['keyword']) ? trim($this->request->get['keyword']) : null;

        $status_id = isset($this->request->get['status']) ? ($this->request->get['status'] != '' ? $this->request->get['status'] : false) : false;

        $date_type = !empty($this->request->get['date_type']) ? $this->request->get['date_type'] : 'custom';
        if ($date_type == 'custom') {
            $appointment_date_start = !empty($this->request->get['aDate1']) ? $this->request->get['aDate1'] : false;
            $appointment_date_end = !empty($this->request->get['aDate2']) ? $this->request->get['aDate2'] : false;
            if (!$appointment_date_start && !$appointment_date_end) {
                $appointment_date_start = date("Y-m-d");
            }
        } else {
            $app_date = $this->getAppointmentDate($date_type);
            $appointment_date_start = $app_date['start'];
            $appointment_date_end = $app_date['end'];
        }



        $created_date_start = !empty($this->request->get['cDate1']) ? $this->request->get['cDate1'] : false;
        $created_date_end = !empty($this->request->get['cDate2']) ? $this->request->get['cDate2'] : false;

        $from_etcm = !empty($this->request->get['from_etcm']) ? $this->request->get['from_etcm'] : false;

        $sort = !empty($this->request->get['s']) ? $this->request->get['s'] : null;

        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 1;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 10;

        $filters = array(
            "status_id"                 => $status_id,
            "doctor_id"                 => $doctor_id,
            "customer_id"               => $customer_id,
            "customer_name"             => $customer_name,
            "service_id"                => $service_id,
            "keyword"                   => $keyword,
            "appointment_date_start"    => $appointment_date_start,
            "appointment_date_end"      => $appointment_date_end,
            "created_date_start"        => $created_date_start,
            "created_date_end"          => $created_date_end,
            "from_etcm"                 => $from_etcm,
            "sort"                      => $sort,
            "start"                     => ($page - 1) * $show,
            "limit"                     => $show
        );
        $appointments = $this->model_name->getList($filters);


        if (!empty($appointments)) {
            $results = array();
            $arr_status_text = $this->session->data['language_id'] == 1 ? $this->arr_statuses_en : $this->arr_statuses_cn;
            foreach ($appointments as $appt) {
                $results[] = array(
                    "appointment_id" => $appt['appointment_id'],
                    "appointment_date" => $appt['appointment_date'],
                    "appointment_time" => $appt['appointment_time'],
                    "status" => $arr_status_text[$appt['status']],
                    "status_color" => $this->arr_status_colors[$appt['status']],
                    "customer_name" => ucwords(strtolower($appt['customer_name'])),
                    "doctor_name" => ucwords(strtolower($appt['doctor_name'])),
                    "service_name" => $appt['service_name'],
                    "from_etcm" => (bool)$appt['from_etcm']
                );
            }


            $total_appointments = $this->model_name->getListTotal($filters);
            $return_result = array(
                "appointments" => $results,
                "total" => (int)$total_appointments
            );

            $output = $this->response->setCachedResponse(200, $return_result, "Get list success", "appointment");
            $this->api->trackResponse($output);
            return;
        } else {
            $return_result = array(
                "appointments" => array(),
                "total" => 0
            );
            $output = $this->response->setCachedResponse(204, $return_result, "No result", "appointment");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_filters()
    {
        $en_date_type = [
            [
                "type" => "today",
                "text" => "Today"
            ],
            [
                "type" => "tomorrow",
                "text" => "Tomorrow"
            ],
            [
                "type" => "yesterday",
                "text" => "Yesterday"
            ],
            [
                "type" => "this_week",
                "text" => "This Week"
            ],
            [
                "type" => "this_month",
                "text" => "This Month"
            ],
            [
                "type" => "this_year",
                "text" => "This Year"
            ],
            [
                "type" => "last7days",
                "text" => "Last 7 days"
            ],
            [
                "type" => "last30days",
                "text" => "Last 30 days"
            ],
            [
                "type" => "last90days",
                "text" => "Last 90 days"
            ],
            [
                "type" => "upcoming",
                "text" => "Upcoming"
            ],
            [
                "type" => "past",
                "text" => "Past"
            ],
            [
                "type" => "all",
                "text" => "All Time"
            ],
            [
                "type" => "custom",
                "text" => "Custom"
            ],
        ];

        $cn_date_type = [
            [
                "type" => "today",
                "text" => "今天"
            ],
            [
                "type" => "tomorrow",
                "text" => "明天"
            ],
            [
                "type" => "yesterday",
                "text" => "昨天"
            ],
            [
                "type" => "this_week",
                "text" => "本周"
            ],
            [
                "type" => "this_month",
                "text" => "本月"
            ],
            [
                "type" => "this_year",
                "text" => "今年"
            ],
            [
                "type" => "last7days",
                "text" => "过去7天"
            ],
            [
                "type" => "last30days",
                "text" => "过去30天"
            ],
            [
                "type" => "last90days",
                "text" => "过去90天"
            ],
            [
                "type" => "upcoming",
                "text" => "即将发生"
            ],
            [
                "type" => "past",
                "text" => "已经发生"
            ],
            [
                "type" => "all",
                "text" => "所有时间"
            ],
            [
                "type" => "custom",
                "text" => "自定义"
            ],
        ];

        $appointment_status = [];
        $arr_status_text = $this->session->data['language_id'] == 1 ? $this->arr_statuses_en : $this->arr_statuses_cn;
        foreach ($arr_status_text as $key => $apt_stat) {
            $appointment_status[$key] = [
                'id'    => (string)$key,
                'text'  => (string)$apt_stat,
                'color' => (string)$this->arr_status_colors[$key]
            ];
        }

        if (!empty($this->session->data['user_info']['viewalldata'])) {
            $filter_doctor = true;
        } else {
            $filter_doctor = true;
            if ($this->session->data['user_info']['position'] == '2') {
                $filter_doctor = false;
            }
        }

        $result = [
            "date_type" => $this->session->data['language_id'] == '1' ? $en_date_type : $cn_date_type,
            "filter_doctor" => $filter_doctor,
            'statuses'          => $appointment_status,
        ];

        $output = $this->response->setResponse2(200, $result, 'success', 'appointment');
        $this->api->trackResponse($output);
        return;
    }

    protected function get_total_summary()
    {
        $today = date('Y-m-d');
        $all = $this->model_name->getListTotal(array(
            "status_id"                 => false,
            "appointment_date_start"    => $today
        ));

        $pending = $this->model_name->getListTotal(array(
            "status_id"                 => 0,
            "appointment_date_start"    => $today
        ));

        $confirmed = $this->model_name->getListTotal(array(
            "status_id"                 => 1,
            "appointment_date_start"    => $today
        ));
        $cancelled = $this->model_name->getListTotal(array(
            "status_id"                 => 2,
            "appointment_date_start"    => $today
        ));
        $attended = $this->model_name->getListTotal(array(
            "status_id"                 => 3,
            "appointment_date_start"    => $today
        ));

        $return_result = array(
            "all"       => (int)$all,
            "confirmed" => (int)$confirmed,
            "pending"   => (int)$pending,
            "cancelled" => (int)$cancelled,
            "attended"  => (int)$attended
        );
        $output = $this->response->setCachedResponse(200, $return_result, "Get list success", "appointment");
        $this->api->trackResponse($output);
        return;
    }

    protected function get_calendar_list()
    {
        $doctor_id = !empty($this->request->get['doctor_id']) ? explode(",", $this->request->get['doctor_id']) : [];
        $doctor_name = !empty($this->request->get['doctor_name']) ? trim($this->request->get['doctor_name']) : null;
        $period = !empty($this->request->get['period']) ? strtolower($this->request->get['period']) : 'monthly';
        $reference_date = !empty($this->request->get['reference_date']) ? strtolower($this->request->get['reference_date']) : date('Y-m-d');

        $keyword = !empty($this->request->get['keyword']) ? $this->request->get['keyword'] : null;
        $from_etcm = !empty($this->request->get['from_etcm']) ? $this->request->get['from_etcm'] : null;
        $status_id = isset($this->request->get['status']) ? ($this->request->get['status'] != '' ? explode(",", $this->request->get['status']) : []) : [];


        list($start_date, $end_date) = $this->getDateRangeByPeriod($period, $reference_date);
        // if ($doctor_id) {
        $filters = array(
            "keyword"   => $keyword,
            "from_etcm" => $from_etcm,
            "status_id" => $status_id,
            "doctor_id" => $doctor_id,
            "doctor_name" => $doctor_name,
            "start_date" => $start_date,
            "end_date"  => $end_date,
        );
        $appointments = $this->model_name->getCalendarList($filters);

        $total_daily = 0;
        if ($period != 'monthly') {
            list($start_date, $end_date) = $this->getDateRangeByPeriod('monthly', $reference_date);
            $filters = array(
                "keyword"   => $keyword,
                "from_etcm" => $from_etcm,
                "status_id" => $status_id,
                "doctor_id" => $doctor_id,
                "doctor_name" => $doctor_name,
                "start_date" => $start_date,
                "end_date"  => $end_date,
            );
            $total_monthly = $this->model_name->getCalendarListTotal($filters);
        } else {
            $total_monthly = count($appointments);
        }

        if ($this->credit_balance === null) {
            $this->credit_balance = $this->getTotalBalance();
        }

        //appointment status for calendar legend
        // $appointment_status = [];
        // foreach ($this->arr_statuses as $key => $apt_stat) {
        //     $appointment_status[$key] = [
        //         'id'    => (string)$key,
        //         'text'  => (string)$apt_stat,
        //         'color' => (string)$this->arr_status_colors[$key]
        //     ];
        // }



        if (!empty($appointments)) {
            $results = array();
            $arr_status_text = $this->session->data['language_id'] == 1 ? $this->arr_statuses_en : $this->arr_statuses_cn;
            foreach ($appointments as $apt) {
                $customer_name = !empty($apt['customer_name']) ? $apt['customer_name'] : $apt['customer_name2'];
                $credit_deducted = 0;
                if ((bool)$apt['from_etcm'] && $apt['status'] == '1') {
                    $credit_deducted = $this->appointment_fee;
                }
                $results[] = array(
                    "appointment_id" => $apt['appointment_id'],
                    "appointment_date" => $apt['appointment_date'],
                    "appointment_time" => $apt['appointment_time'],
                    "customer_name" => $customer_name,
                    "service_name" => $apt['servicename'],
                    "doctor_name" => $apt['doctor_name'],
                    "from_etcm" => (bool)$apt['from_etcm'],
                    "credit_deducted" => (float)$credit_deducted,
                    "status_id" => $apt['status'],
                    "status" => $arr_status_text[$apt['status']],
                    "status_color" => $this->arr_status_colors[$apt['status']]
                );

                if ($apt['appointment_date'] == $reference_date) {
                    $total_daily++;
                }
            }
            $return_result = [
                'total_daily'       => (int)$total_daily,
                'total_monthly'     => (int)$total_monthly,
                // 'statuses'          => $appointment_status,
                "credit_balance"    => (float)$this->credit_balance,
                'appointments'      => $results,
            ];
            $output = $this->response->setCachedResponse(200, $return_result, "success", "appointment");
            $this->api->trackResponse($output);
            return;
        } else {
            $result = [
                'total_daily'       => (int)$total_daily,
                'total_monthly'     => (int)$total_monthly,
                // 'statuses'          => $appointment_status,
                "credit_balance"    => (float)$this->credit_balance,
                'appointments'      => [],
            ];
            $output = $this->response->setCachedResponse(204, $result, "No results", "appointment");
            $this->api->trackResponse($output);
            return;
        }
        // } else {
        //     $output = $this->response->setCachedResponse(400, array(), "doctor_id is required", "appointment");
        //     $this->api->trackResponse($output);
        //     return;
        // }
    }

    protected function get_services_available()
    {
        $doctor_id = !empty($this->request->get['doctor_id']) ? trim($this->request->get['doctor_id']) : null;
        $filters = array(
            "doctor_id" => $doctor_id,
        );
        $services = $this->model_name->getServicesAvailable($filters);

        if (!empty($services)) {
            $output = $this->response->setCachedResponse(200, $services, "Get list success", "appointment");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(204, $services, "No result", "appointment");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_doctors_available()
    {
        $service_id = !empty($this->request->get['service_id']) ? $this->request->get['service_id'] : null;
        if (empty($service_id)) {
            $output = $this->response->setCachedResponse(204, array(), "No result", "appointment");
            $this->api->trackResponse($output);
            return;
        }
        $doctors = $this->model_name->getDoctorsAvailable($service_id);

        $results = array();
        foreach ($doctors as $doctor) {
            $available = $this->model_name->getDoctorAvailabilityStatus($doctor['id'], $service_id);
            if ($available > 0) {
                $results[] = array(
                    "id" => $doctor["id"],
                    "name" => $doctor["name"],
                );
            }
        }

        if (!empty($results)) {
            $output = $this->response->setCachedResponse(200, $results, "Get list success", "appointment");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(204, $results, "No result", "appointment");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_times()
    {
        if (isset($this->request->get['date'])) {
            $date = date('l', strtotime($this->request->get['date']));
        } else {
            $date = '';
        }
        $service_id = !empty($this->request->get['service_id']) ? $this->request->get['service_id'] : 0;

        $service_info = $this->model_name->getServiceDetail($service_id);

        $request_date = $this->request->get['date'];
        $today = date('Y-m-d');

        if (isset($this->request->get['doctor_id'])) {
            $doctor_id = $this->request->get['doctor_id'];
        } else {
            $doctor_id = 0;
        }

        if ($date && $doctor_id && $service_id) {

            //doctor appointments
            $doctor_apps = $this->db->query("SELECT a.*, CASE WHEN s.cs_minute IS NULL THEN '30' ELSE s.cs_minute END AS service_minute FROM " . DB_PREFIX . "appointment a LEFT JOIN " . DB_PREFIX . "clinical_service s ON(a.clinicalservice_id = s.clinicalservice_id) 
            WHERE 1 
            AND a.status <> '2'
            AND a.hide = '0'
            AND a.store_id = '" . (int)$this->session->data['store_id'] . "'
            AND a.doctor_id = '" . (int)$doctor_id . "'
            AND a.appointment_date = '" . $this->db->escape($request_date) . "'")->rows;

            //facilities
            $facilities = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_to_facility WHERE service_id = '" . (int)$service_id . "'
            AND facility_id IN (SELECT facility_id FROM " . DB_PREFIX . "facility WHERE status = '1')")->rows;


            $times = $this->model_name->getTimes($this->session->data['store_id'], $date, $doctor_id);
            $json = array();

            if (!empty($times)) {
                foreach ($times as $time) {
                    if (!empty($time['start_time']) && !empty($time['end_time'])) {
                        $temp = strtotime($time['start_time']);
                        if ($today == $request_date) {
                            if (strtotime('now') < $temp) {
                                if ($this->checkTime($temp, $temp + ($service_info['cs_minute'] * 60), $doctor_apps, $facilities, $request_date)) {
                                    array_push($json, date('h:i A', $temp));
                                }
                            }
                        } else {
                            if ($this->checkTime($temp, $temp + ($service_info['cs_minute'] * 60), $doctor_apps, $facilities, $request_date)) {
                                array_push($json, date('h:i A', $temp));
                            }
                        }

                        while (strtotime($time['end_time']) > $temp) {
                            $temp = $temp + ($service_info['cs_minute'] * 60);
                            $temp2 = $temp + ($service_info['cs_minute'] * 60);
                            if ($temp2 <= strtotime($time['end_time'])) {

                                if ($today == $request_date) {
                                    if (strtotime('now') < $temp) {
                                        if ($this->checkTime($temp, $temp2, $doctor_apps, $facilities, $request_date)) {
                                            array_push($json, date('h:i A', $temp));
                                        }
                                    }
                                } else {
                                    if ($this->checkTime($temp, $temp2, $doctor_apps, $facilities, $request_date)) {
                                        array_push($json, date('h:i A', $temp));
                                    }
                                }
                            }
                        }
                    }
                }
            }

            $output = $this->response->setCachedResponse(200, $json, "Get list success", "appointment");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(400, array(), "Date, service_id and Doctor id is required", "appointment");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_unavailable_date()
    {
        $service_id = !empty($this->request->get['service_id']) ? $this->request->get['service_id'] : null;
        $doctor_id = !empty($this->request->get['doctor_id']) ? $this->request->get['doctor_id'] : '0';
        $month = !empty($this->request->get['month']) ? $this->request->get['month'] : false;

        $json = array();
        $today_date = date('Y-m-d');
        $today_timestamp = strtotime($today_date);

        if ($doctor_id) {
            $doctor_holidays = $this->model_name->checkUserHoliday($doctor_id);
        } else {
            $doctor_holidays = [];
        }

        $store_holiday = $this->model_name->checkStoreHoliday($this->session->data['store_id']);

        if (!empty($month)) {
            $date_range = $this->createDateRangeByMonthYearArray(date('n', strtotime($month)), date('Y', strtotime($month)));
        } else {
            $date_range = $this->createDateRangeArray(date('Y-m-d'), date('Y-m-d', strtotime('+1 year', $today_timestamp)));
        }

        if (!empty($date_range)) {
            $one_month_later_timestamp = strtotime('+1 month', $today_timestamp);

            if (!empty($month)) {
                foreach ($date_range as $date) {
                    $date_timestamp = strtotime($date);

                    if ($today_timestamp > $date_timestamp) {
                        $compare_date_range[] = date('Y-m-d', $date_timestamp);
                    }

                    if ($date_timestamp > $one_month_later_timestamp) {
                        $compare_date_range[] = date('Y-m-d', $date_timestamp);
                    }
                }
            }

            //check doctor holiday
            if (!empty($doctor_holidays)) {
                foreach ($doctor_holidays as $holiday) {
                    $holiday_date_range = $this->createDateRangeArray($holiday['start'], $holiday['end']);

                    if (!empty($holiday_date_range)) {
                        foreach ($holiday_date_range as $date) {
                            if (in_array($date, $date_range)) {
                                $compare_date_range[] = $date;
                            }
                        }
                    }
                }
            }

            //check store holiday
            if (!empty($store_holiday)) {
                foreach ($store_holiday as $holiday) {
                    $holiday_date_range = $this->createDateRangeArray($holiday['start'], $holiday['end']);

                    if (!empty($holiday_date_range)) {
                        foreach ($holiday_date_range as $date) {
                            if (in_array($date, $date_range)) {
                                $compare_date_range[] = $date;
                            }
                        }
                    }
                }
            }

            //check doctor time table
            foreach ($date_range as $date) {
                $date_range_day = date('l', strtotime($date));

                if ($doctor_id) {
                    $appointment_availability_time = $this->model_name->getDoctorAvailabilityTime($doctor_id, $service_id, $date_range_day);

                    if (empty($appointment_availability_time)) {
                        $compare_date_range[] = $date;
                    } elseif ($date == $today_date) {
                        if (!$this->todaySlotExist($doctor_id)) {
                            $compare_date_range[] = $date;
                        }
                    }
                }
            }

            ///check appointment setting earliest date allow
            if ($this->appointment_setting['min_day_advance'] > 0) {
                $min_day_date = Date('Y-m-d', strtotime('+' . ($this->appointment_setting['min_day_advance'] - 1) . ' days'));
                $day_advance_range = $this->createDateRangeArray($today_date, $min_day_date);
                if (!empty($day_advance_range)) {
                    foreach ($day_advance_range as $date) {
                        if (in_array($date, $date_range)) {
                            $compare_date_range[] = $date;
                        }
                    }
                }
            }

            $compare_date_range = array_unique($compare_date_range);

            if (!empty($compare_date_range)) {
                foreach ($compare_date_range as $date) {
                    $day = date('l', strtotime($date));

                    $final_date[] = [
                        'date' => $date,
                        'day' => $day
                    ];
                }

                $date_column = array_column($final_date, 'date');
                $date_column = array_map('strtotime', $date_column);

                array_multisort($final_date, SORT_NUMERIC, $date_column, SORT_ASC);
            }
        }

        if (!empty($final_date)) {
            $json = $final_date;
        }
        $output = $this->response->setCachedResponse(200, $json, "Get list success", "appointment");
        $this->api->trackResponse($output);
        return;
    }

    protected function get_info()
    {
        $appointment_id = !empty($this->request->get['appointment_id']) ? $this->request->get['appointment_id'] : null;
        if ($appointment_id) {
            $result = $this->getInfo($appointment_id);
            $output = $this->response->setCachedResponse(200, $result, "success", "appointment");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(400, $this->response->noResponse(), "appointment_id is required", "appointment");
            $this->api->trackResponse($output);
            return;
        }
    }

    private function get_appointment_availability_list()
    {
        $doctor_id = !empty($this->request->get['doctor_id']) ? $this->request->get['doctor_id'] : '0';
        if ($doctor_id) {
            $slots = $this->model_name->getAppointmentAvailabilityList($doctor_id);
            if (!empty($slots)) {
                $results = array();
                foreach ($slots as $slot) {
                    $times = $this->model_name->getAppointmentAvailabilityTimes($slot['availability_id']);
                    $results[] = array(
                        "availability_id" => $slot['availability_id'],
                        "day" => $slot['day'],
                        "minutes" => $slot['minutes'],
                        "times" => $times
                    );
                }
                $output = $this->response->setCachedResponse(200, $results, "Success", "appointment");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(204, array(), "No results", "appointment");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, array(), "doctor_id is required", "appointment");
            $this->api->trackResponse($output);
            return;
        }
    }

    private function add_appointment_availability()
    {
        $json = $this->json;
        if (empty($json)) {
            $output = $this->response->setResponse2(400, $this->response->noResponse(), "missing json body", "appointment");
            $this->api->trackResponse($output);
            return;
        } else {
            if (!empty($json['day'])) {
                $availability_id = $this->model_name->updateAppointmentAvailability($json);
                $output = $this->response->setResponse2(200, array("availability_id" => $availability_id), "success", "customer");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setResponse2(400, $this->response->noResponse(), "day is required", "appointment");
                $this->api->trackResponse($output);
                return;
            }
        }
    }

    protected function reschedule()
    {
        $json = $this->json;
        $appointment_id = !empty($json['appointment_id']) ? $json['appointment_id'] : 0;
        $appointment_date = !empty($json['appointment_date']) ? $json['appointment_date'] : '';
        $appointment_time = !empty($json['appointment_time']) ? $json['appointment_time'] : '';
        if ($appointment_id && $appointment_date && $appointment_time) {
            $row_affect = $this->model_name->cancelAppointment($appointment_id);
            if ($row_affect) {
                $appointment_info = $this->model_name->getAppointment($appointment_id);
                $data = array(
                    "customer_id" => $appointment_info['customer_id'],
                    "email" => $appointment_info['email'],
                    "telephone" => $appointment_info['telephone'],
                    "clinicalservice_id" => $appointment_info['clinicalservice_id'],
                    "appointment_date" => $appointment_date,
                    "appointment_time" => $appointment_time,
                    "doctor_id" => $appointment_info['doctor_id'],
                    "new" => $appointment_info['new_customer'],
                );
                $appointment_id = $this->model_name->addAppointment($data);
                if ($appointment_id) {
                    $success = true;
                } else {
                    $success = false;
                }
            } else {
                $success = false;
            }
            if ($success) {
                $output = $this->response->setResponse2(200, array('appointment_id' => $appointment_id), "success", "appointment");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setResponse2(400, $this->response->noResponse(), "failed to rescheduled", "appointment");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setResponse2(400, $this->response->noResponse(), "appointment_id, appointment_date, appointment_time is required", "appointment");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function delete_appointment()
    {
        $appointment_id = !empty($this->request->post['appointment_id']) ? $this->request->post['appointment_id'] : 0;
        if ($appointment_id) {
            $this->model_name->deleteAppointment($appointment_id);
            $output = $this->response->setResponse2(200, $this->response->noResponse(), "success", "appointment");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setResponse2(400, $this->response->noResponse(), " appointment_id is required", "appointment");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function save()
    {
        $json = $this->json;
        if (empty($json)) {
            $output = $this->response->setResponse2(400, $this->response->noResponse(), "missing json body", "appointment");
            $this->api->trackResponse($output);
            return;
        } else {
            $clinicalservice_id = !empty($json['service_id']) ? $json['service_id'] : '';
            $slot_booked = $this->slotBooked($json);

            $proceed = true;
            if ($slot_booked) {
                // if (in_array($clinicalservice_id, $this->appointment_setting['allow_duplicate'])) {
                //     $proceed = true;
                // } else {
                // $proceed = false;
                // }
                $proceed = false;
            }

            if ($proceed) {
                $new_customer = false;

                $customer_id = !empty($json['customer']['customer_id']) ? $json['customer']['customer_id'] : false;

                //load customer model
                $this->load->model('android/customer/customer');

                //add customer if customer_id is empty
                if (empty($customer_id)) {
                    $new_customer = true;
                    $customer = !empty($json['customer']) ? $json['customer'] : false;
                    if ($this->validateCustomerInfo($customer)) {
                        $customer_group_id = !empty($customer['customer_group_id']) ? trim($customer['customer_group_id']) : '';
                        $customer_card = !empty($customer['registration_card_no']) ? trim($customer['registration_card_no']) : '';
                        $customer_ic = !empty($customer['customer_ic']) ? trim($customer['customer_ic']) : '';
                        $firstname = !empty($customer['name']) ? trim($customer['name']) : '';
                        $lastname = !empty($customer['chinese_name']) ? trim($customer['chinese_name']) : '';
                        $gender_id = !empty($customer['gender_id']) ? trim($customer['gender_id']) : '';
                        $dob = !empty($customer['dob']) ? trim($customer['dob']) : '';
                        $email = !empty($customer['email']) ? trim($customer['email']) : '';
                        $telephone1 = !empty($customer['telephone1']) ? trim($customer['telephone1']) : '';
                        $telephone2 = !empty($customer['telephone2']) ? trim($customer['telephone2']) : '';
                        $home = !empty($customer['home']) ? trim($customer['home']) : '';
                        $occupation = !empty($customer['occupation']) ? trim($customer['occupation']) : '';
                        $nationality = !empty($customer['nationality']) ? trim($customer['nationality']) : '';
                        $marital_status_id = !empty($customer['marital_status_id']) ? trim($customer['marital_status_id']) : '';
                        $religion_id = !empty($customer['religion_id']) ? trim($customer['religion_id']) : '';
                        $race_id = !empty($customer['race_id']) ? trim($customer['race_id']) : '';
                        $allergic = !empty($customer['allergic']) ? trim($customer['allergic']) : '';
                        $diagnostic_history = !empty($customer['diagnostic_history']) ? trim($customer['diagnostic_history']) : '';

                        $data = array(
                            "customer_id" => null,
                            "customer_group_id" => $customer_group_id,
                            "customer_card" => $customer_card,
                            "customer_ic" => $customer_ic,
                            "firstname" => $firstname,
                            "lastname" => $lastname,
                            "gender_id" => $gender_id,
                            "dob" => $dob,
                            "email" => $email,
                            "telephone1" => $telephone1,
                            "telephone2" => $telephone2,
                            "home" => $home,
                            "occupation" => $occupation,
                            "nationality" => $nationality,
                            "marital_status_id" => $marital_status_id,
                            "religion_id" => $religion_id,
                            "race_id" => $race_id,
                            "allergic" => $allergic,
                            "diagnostic_history" => $diagnostic_history,
                        );
                        $customer_id = $this->model_android_customer_customer->updateCustomer($data);
                        //check address data and update
                        $addresses = !empty($customer['address']) ? $customer['address'] : array();
                        foreach ($addresses as $address) {
                            if ($this->validateAddressInfo($address)) {
                                $address_1 = !empty($address['address_1']) ? $address['address_1'] : '';
                                $address_2 = !empty($address['address_2']) ? $address['address_2'] : '';
                                $address_3 = !empty($address['address_3']) ? $address['address_3'] : '';
                                $city = !empty($address['city']) ? $address['city'] : '';
                                $postcode = !empty($address['post_code']) ? $address['post_code'] : '';
                                $country_id = !empty($address['country_id']) ? $address['country_id'] : '129';
                                $zone_id = !empty($address['zone_id']) ? $address['zone_id'] : '0';
                                $default = !empty($address['default']) ? $address['default'] : false;

                                $data = array(
                                    "address_id" => null,
                                    "customer_id" => $customer_id,
                                    "firstname" => $firstname,
                                    "lastname" => $lastname,
                                    "company" => '',
                                    "address_1" => $address_1,
                                    "address_2" => $address_2,
                                    "address_3" => $address_3,
                                    "city" => $city,
                                    "postcode" => $postcode,
                                    "country_id" => $country_id,
                                    "zone_id" => $zone_id,
                                    "default" => $default,
                                );
                                $this->model_android_customer_customer->updateAddress($data);
                            }
                        }
                    } else {
                        $output = $this->response->setResponse2(400, $this->response->noResponse(), "customer info not completed", "appointment");
                        $this->api->trackResponse($output);
                        return;
                    }
                }

                $appointment_id = !empty($json['appointment_id']) ? $json['appointment_id'] : '';
                $appointment_date = !empty($json['appointment_date']) ? $json['appointment_date'] : '';
                $appointment_time = !empty($json['appointment_time']) ? $json['appointment_time'] : '';
                $email = !empty($json['email']) ? $json['email'] : '';
                $telephone = !empty($json['telephone']) ? $json['telephone'] : '';

                $doctor_id = !empty($json['doctor_id']) ? $json['doctor_id'] : '';
                $remark = !empty($json['remark']) ? $json['remark'] : '';
                $new = $new_customer ? 1 : 0;
                if ($customer_id) {
                    $data = array(
                        "customer_id" => $customer_id,
                        "email" => $email,
                        "telephone" => $telephone,
                        "clinicalservice_id" => $clinicalservice_id,
                        "appointment_date" => $appointment_date,
                        "appointment_time" => $appointment_time,
                        "facility_id"   => $this->selected_facility,
                        "doctor_id" => $doctor_id,
                        "remark" => $remark,
                        "new" => $new,
                    );

                    if (empty($appointment_id)) {
                        $appointment_id = $this->model_name->addAppointment($data);
                    } else {
                        $this->model_name->editAppointment($appointment_id, $data);
                    }
                    if ($appointment_id) {
                        $msg = $slot_booked ? "Warning : This time slot have been multiple booked" : '';
                        $result = $this->getInfo($appointment_id, $msg);
                        $this->sendNotificationToDoctor($result);
                        $output = $this->response->setResponse2(200, $result, "success", "appointment");
                        $this->api->trackResponse($output);
                        return;
                    } else {
                        $output = $this->response->setResponse2(400, $this->response->noResponse(), "failed to save", "appointment");
                        $this->api->trackResponse($output);
                        return;
                    }
                } else {
                    $output = $this->response->setResponse2(400, $this->response->noResponse(), "customer_id is required", "appointment");
                    $this->api->trackResponse($output);
                    return;
                }
            } else {
                $output = $this->response->setResponse2(400, $this->response->noResponse(), $this->error ? $this->error : "Appointment slot already taken", "appointment");
                $this->api->trackResponse($output);
                return;
            }
        }
    }

    protected function confirm_appointment()
    {
        $appointment_id = !empty($this->request->post['appointment_id']) ? explode(",", $this->request->post['appointment_id']) : [];
        $results = [];
        if (!empty($appointment_id)) {
            foreach ($appointment_id as $id) {
                $app_info = $this->model_name->getAppointment($id);
                $from_etcm = $app_info['from_etcm'];
                $updated = true;
                if ($from_etcm) {
                    // $got_credit = $this->checkCreditBalance();
                    // if ($got_credit) {
                    $updated = $this->confirmEtcmAppointment($from_etcm);
                    // } else {
                    //     $updated = false;
                    //     $output = $this->response->setResponse2(406, [], "insufficient balance", "appointment");
                    //     $this->api->trackResponse($output);
                    //     return;
                    // }
                }
                if ($updated) {
                    $this->model_name->confirmAppointment($id);
                }
                $result = $this->getInfo($id);
                if ($updated) {
                    $this->sendNotificationToDoctor($result);
                    if (!$from_etcm) {
                        $this->sendNotificationToPatient($result);
                    }
                }
                $results[] = $result;
            }
            $output = $this->response->setResponse2(200, $results, "success", "appointment");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setResponse2(400, $results, "appointment_id is required", "appointment");
            $this->api->trackResponse($output);
            return;
        }
    }

    private function getTotalBalance()
    {
        $hosting = HTTPS_SERVER;
        $path = 'etcm/credit/credit/get_balance';
        $phone_no = $this->session->data['user_info']['contactno'];
        $data = [
            "hosting" => $hosting,
            "phone_no" => $phone_no
        ];
        $result = $this->connectCurl($path, $data, 'live');
        if (!empty($result)) {
            if (!empty($result['response']['balance'])) {
                $balance = str_replace('RM', '', $result['response']['balance']);
                $balance = (float)str_replace(',', '', $balance);
            }
        }
        return $balance;
    }

    private function checkCreditBalance()
    {

        $balance = $this->getTotalBalance();
        if ($balance >= $this->appointment_fee) {
            return true;
        }
        return false;
    }

    protected function confirm_appointment_backup()
    {
        $appointment_id = !empty($this->request->post['appointment_id']) ? $this->request->post['appointment_id'] : 0;
        if ($appointment_id) {
            $this->model_name->confirmAppointment($appointment_id);
            $result = $this->getInfo($appointment_id);
            $this->sendNotificationToDoctor($result);
            $this->sendNotificationToPatient($result);
            $output = $this->response->setResponse2(200, $result, "success", "appointment");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setResponse2(400, $this->response->noResponse(), "appointment_id is required", "appointment");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function cancel_appointment()
    {
        $appointment_id = !empty($this->request->post['appointment_id']) ? $this->request->post['appointment_id'] : 0;
        $reason_id = !empty($this->request->post['reason_id']) ? $this->request->post['reason_id'] : 0;
        $reason = !empty($this->request->post['reason']) ? $this->request->post['reason'] : '';
        if ($appointment_id && ($reason_id || !empty($reason))) {
            $app_info = $this->model_name->getAppointment($appointment_id);
            $from_etcm = $app_info['from_etcm'];
            $updated = true;
            if ($from_etcm) {
                $reason = !empty($reason) ? trim($reason) : $this->model_name->getCancelReasonText($reason_id);
                $updated = $this->cancelEtcmAppointment($from_etcm, $reason);
            }
            if ($updated) {
                $this->model_name->cancelAppointment($appointment_id, $reason_id, $reason);
            }
            $result = $this->getInfo($appointment_id);
            if ($updated) {
                $this->sendNotificationToDoctor($result);
            }
            $output = $this->response->setResponse2(200, $result, "success", "appointment");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setResponse2(400, $this->response->noResponse(), "appointment_id and reason id is required", "appointment");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function bulk_cancel_appointment()
    {
        $json = $this->json;
        if (empty($json)) {
            $this->error = "Missing JSON body";
        }
        if ($this->validateCancel($json)) {
            foreach ($json as $appt) {
                $appointment_id = $appt['appointment_id'];
                $reason_id = !empty($appt['reason_id']) ? $appt['reason_id'] : 0;
                $reason = !empty($appt['reason']) ? $appt['reason'] : '';
                $app_info = $this->model_name->getAppointment($appointment_id);
                $from_etcm = $app_info['from_etcm'];
                $updated = true;
                if ($from_etcm) {
                    $reason = !empty($reason) ? trim($reason) : $this->model_name->getCancelReasonText($reason_id);
                    $updated = $this->cancelEtcmAppointment($from_etcm, $reason);
                }
                if ($updated) {
                    $this->model_name->cancelAppointment($appointment_id, $reason_id, $reason);
                }
                $result = $this->getInfo($appointment_id);
                if ($updated) {
                    $this->sendNotificationToDoctor($result);
                }
                $results[] = $result;
            }
            $output = $this->response->setResponse2(200, $results, "success", "appointment");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setResponse2(400, [], $this->error ? $this->error : 'input error', "appointment");
            $this->api->trackResponse($output);
        }
    }

    protected function get_cancel_reason()
    {
        $reasons = $this->model_name->getCancelReasons();
        $output = $this->response->setResponse2(200, $reasons, "success", "appointment");
        $this->api->trackResponse($output);
        return;
    }

    protected function attend_appointment()
    {
        $appointment_id = !empty($this->request->post['appointment_id']) ? $this->request->post['appointment_id'] : 0;
        if ($this->validateAttend($appointment_id)) {
            $app_info = $this->model_name->getAppointment($appointment_id);
            $from_etcm = $app_info['from_etcm'];
            $updated = true;
            if ($from_etcm) {
                $got_credit = $this->checkCreditBalance();
                if ($got_credit) {
                    $updated = $this->attendEtcmAppointment($from_etcm);
                } else {
                    $updated = false;
                    $output = $this->response->setResponse2(406, new stdClass(), "insufficient balance", "appointment");
                    $this->api->trackResponse($output);
                    return;
                }
            }
            if ($updated) {
                $this->session->data['attend_result'] = $this->model_name->attendAppointment($appointment_id);
            }
            $result = $this->getInfo($appointment_id);
            if ($updated) {
                $this->sendNotificationToDoctor($result);
            }
            $output = $this->response->setResponse2(200, $result, "success", "appointment");
            $this->api->trackResponse($output);
            return;
        }
    }

    //cronjob function
    public function send_reminder()
    {
        $result = [];
        $sms_appointment_info = $this->config->get('config_sms_appointment');
        if ($sms_appointment_info['status'] == '1') {
            $all_stores = [];
            $all_stores[0] = htmlspecialchars_decode($this->config->get('config_name')) . " (HQ)";
            $this->load->model('setting/store');
            $stores = $this->model_setting_store->getStores();
            foreach ($stores as $store) {
                $all_stores[$store['store_id']] = $store['name'];
            }



            $tomorrow = date('Y-m-d', strtotime('tomorrow'));
            //get tomorrow appointment that have been confirmed
            $sql = "SELECT * FROM " . DB_PREFIX . "appointment WHERE appointment_date = '" . $this->db->escape($tomorrow) . "' AND status = '1' AND from_etcm = '0'";
            $query = $this->db->query($sql);
            $appointments = $query->rows;
            if (!empty($appointments)) {
                foreach ($appointments as $row) {
                    $store_name = $all_stores[$row['store_id']];
                    $app_date = date("j M Y", strtotime($row['appointment_date']));
                    $app_time = date("g:i A", strtotime($row['appointment_time']));
                    $sms_message = "Reminder: You have appointment tomorrow, $app_date $app_time at $store_name . Thank you";
                    $telephone = $row['telephone'];
                    $formattedNumber = $this->formatTelephone($telephone);

                    $result[] = [
                        "appointment_id" => $row['appointment_id'],
                        "telephone" => $formattedNumber,
                        "sms" => $sms_message
                    ];

                    $sms = new SMS($this->config->get('config_sms'));
                    $sms->sendTo($this->getMobileCode(), $formattedNumber)
                        ->setMessage($sms_message)
                        ->send();
                }
            }
        }


        $this->response->setResponse2(200, $result, "success", "appointment");
        return;
    }


    //     _____      _            _         ______                _   _             
    //    |  __ \    (_)          | |       |  ____|              | | (_)            
    //    | |__) | __ ___   ____ _| |_ ___  | |__ _   _ _ __   ___| |_ _  ___  _ __  
    //    |  ___/ '__| \ \ / / _` | __/ _ \ |  __| | | | '_ \ / __| __| |/ _ \| '_ \ 
    //    | |   | |  | |\ V / (_| | ||  __/ | |  | |_| | | | | (__| |_| | (_) | | | |
    //    |_|   |_|  |_| \_/ \__,_|\__\___| |_|   \__,_|_| |_|\___|\__|_|\___/|_| |_|
    //                                                                               

    private function checkTime($start_time, $end_time, $doctor_apps, $facilities, $date)
    {
        // $available = true;
        $app_day = date('l', strtotime($date));
        //check doctor
        foreach ($doctor_apps as $row) {
            $app_start_time = strtotime($row['appointment_time']);
            $app_end_time = $app_start_time + ($row['service_minute'] * 60);



            if ($start_time >= $app_start_time && $start_time < $app_end_time) {
                return false;
            }

            if ($end_time > $app_start_time && $end_time <= $app_end_time) {
                return false;
            }
            if ($app_start_time >= $start_time && $app_end_time <= $end_time) {
                return false;
            }
        }

        //check facilities
        if (!empty($facilities)) {
            $facility_booked = [];
            foreach ($facilities as $facility) {
                $facility_booked[$facility['facility_id']] = false;
                $sql = "SELECT a.*, CASE WHEN s.cs_minute IS NULL THEN '30' ELSE s.cs_minute END AS service_minute FROM " . DB_PREFIX . "appointment a LEFT JOIN " . DB_PREFIX . "clinical_service s ON(a.clinicalservice_id = s.clinicalservice_id) 
                WHERE 1
                AND a.status <> '2'
                AND a.hide = '0'
                AND a.store_id = '" . (int)$this->session->data['store_id'] . "'
                AND a.facility_id = '" . (int)$facility['facility_id'] . "'
                AND a.appointment_date = '" . $this->db->escape($date) . "'";

                $query = $this->db->query($sql);
                foreach ($query->rows as $row) {
                    $app_start_time = strtotime($row['appointment_time']);
                    $app_end_time = $app_start_time + ($row['service_minute'] * 60);

                    if ($start_time >= $app_start_time && $start_time < $app_end_time) {
                        $facility_booked[$facility['facility_id']] = false;
                    }

                    if ($end_time > $app_start_time && $end_time <= $app_end_time) {
                        $facility_booked[$facility['facility_id']] = false;
                    }
                    if ($app_start_time >= $start_time && $app_end_time <= $end_time) {
                        $facility_booked[$facility['facility_id']] = false;
                    }
                }
            }

            if (!empty($facility_booked)) {
                foreach ($facility_booked as $id => $booked) {
                    if (!$booked) {
                        $facility_info = $this->model_name->getFacilitiesDetail($id);

                        if (!empty($facility_info)) {
                            if ($facility_info['available'] == '1') {
                                return true;
                            } else {
                                foreach ($facility_info['availabilities'] as $availability) {
                                    if ($availability['day'] == $app_day) {
                                        $a_start_time = strtotime($availability['start_time']);
                                        $a_end_time = strtotime($availability['end_time']);
                                        if ($a_start_time <= $start_time && $a_end_time >= $end_time) {
                                            return true;
                                        }
                                    }
                                }
                                return false;
                            }
                        }
                    }
                }
            }
        }


        return true;
    }

    private function validateCancel($data)
    {
        if (is_array($data)) {
            if (empty(array_filter($data, 'is_array'))) {
                $this->error = "Invalid JSON parameters";
                return false;
            }
        } else {
            $this->error = "Invalid JSON parameters";
        }
        foreach ($data as $appt) {
            if (empty($appt['appointment_id'])) {
                $this->error = "appointment_id required";
                return false;
            }
            if (empty($appt['reason_id']) && empty($appt['reason'])) {
                $this->error = "reason or reason_id required";
                return false;
            }
        }
        return true;
    }

    private function confirmEtcmAppointment($etcm_app_id)
    {
        $post_data = [
            'store_url' => HTTPS_SERVER,
            'etcm_appointment_id' => $etcm_app_id
        ];

        $path = 'etcm/syncing/appointment/confirm_appointment';
        $result = $this->connectCurl($path, $post_data);
        if ($result['error']) {
            return false;
        } else {
            return true;
        }
    }

    private function attendEtcmAppointment($etcm_app_id)
    {
        $post_data = [
            'store_url' => HTTPS_SERVER,
            'etcm_appointment_id' => $etcm_app_id
        ];

        $path = 'etcm/syncing/appointment/attend_appointment';
        $result = $this->connectCurl($path, $post_data);
        if ($result['error']) {
            return false;
        } else {
            return true;
        }
    }

    private function cancelEtcmAppointment($etcm_app_id, $reason)
    {
        $post_data = [
            'store_url' => HTTPS_SERVER,
            'etcm_appointment_id' => $etcm_app_id,
            'reason' => $reason
        ];

        $path = 'etcm/syncing/appointment/cancel_appointment';
        $result = $this->connectCurl($path, $post_data);
        if ($result['error']) {
            return false;
        } else {
            return true;
        }
    }

    private function validateAttend($appointment_id)
    {
        if (empty($appointment_id)) {
            $output = $this->response->setResponse2(400, $this->response->noResponse(), "appointment_id is required", "appointment");
            $this->api->trackResponse($output);
            return;
        }

        $apt_info = $this->model_name->getAppointment($appointment_id);

        if ($this->appointment_setting['allow_attend_before_date'] && ($apt_info['appointment_date'] >= date('Y-m-d'))) {
            if (date('Y-m-d') == $apt_info['appointment_date']) {
                $diff = strtotime($apt_info['appointment_time']) - strtotime(date('H:i'));
                if ($diff < 0) {
                    $diff_in_minutes = abs($diff) / 60;
                    $grace_period = $this->appointment_setting['grace_period'];
                    if ($diff_in_minutes > $grace_period) {
                        $output = $this->response->setResponse2(400, $this->response->noResponse(), "Appointment time is invalid", "appointment");
                        $this->api->trackResponse($output);
                        return;
                    }
                }
                return true;
            }
            return true;
        } elseif ($apt_info['appointment_date'] != date('Y-m-d')) {
            $output = $this->response->setResponse2(400, $this->response->noResponse(), "Appointment date is not same with today date", "appointment");
            $this->api->trackResponse($output);
            return;
        } else {
            $diff = abs(strtotime($apt_info['appointment_time']) - strtotime(date('H:i')));
            $diff_in_minutes = $diff / 60;
            $grace_period = $this->appointment_setting['grace_period'];
            if ($diff_in_minutes > $grace_period) {
                $output = $this->response->setResponse2(400, $this->response->noResponse(), "Appointment time is invalid", "appointment");
                $this->api->trackResponse($output);
                return;
            }
        }

        return true;
    }
    private function createDateRangeByMonthYearArray($month, $year)
    {
        $aryRange = [];

        for ($day = 1; $day <= 31; $day++) {
            $time = mktime(12, 0, 0, $month, $day, $year);

            if (date('m', $time) == $month) {
                $aryRange[] = date('Y-m-d', $time);
            }
        }

        $num_of_days = count($aryRange);
        $last_day_element = $num_of_days - 1;

        $first_day = $aryRange[0];
        $first_day_timestamp = strtotime($first_day);

        $last_day = $aryRange[$last_day_element];
        $last_day_timestamp = strtotime($last_day);

        $one_day_later = date('Y-m-d', strtotime('+1 day', $last_day_timestamp));
        $two_weeks_later = date('Y-m-d', strtotime('+2 weeks', $last_day_timestamp));

        $one_day_before = date('Y-m-d', strtotime('-1 day', $first_day_timestamp));
        $two_weeks_before = date('Y-m-d', strtotime('-2 weeks', $first_day_timestamp));

        $days_later = $this->createDateRangeArray($one_day_later, $two_weeks_later);
        $days_before = $this->createDateRangeArray($two_weeks_before, $one_day_before);

        $aryRange = array_merge($aryRange, $days_before, $days_later);

        $date_column = array_map('strtotime', $aryRange);
        array_multisort($aryRange, SORT_NUMERIC, $date_column, SORT_ASC);

        return $aryRange;
    }

    private function createDateRangeArray($strDateFrom, $strDateTo)
    {
        $aryRange = array();

        $iDateFrom = mktime(1, 0, 0, substr($strDateFrom, 5, 2), substr($strDateFrom, 8, 2), substr($strDateFrom, 0, 4));
        $iDateTo = mktime(1, 0, 0, substr($strDateTo, 5, 2), substr($strDateTo, 8, 2), substr($strDateTo, 0, 4));

        if ($iDateTo >= $iDateFrom) {
            array_push($aryRange, date('Y-m-d', $iDateFrom)); // first entry
            while ($iDateFrom < $iDateTo) {
                $iDateFrom += 86400; // add 24 hours
                array_push($aryRange, date('Y-m-d', $iDateFrom));
            }
        }

        return $aryRange;
    }

    private function getDateRangeByPeriod($period, $reference_date = '')
    {
        if (empty($reference_date)) {
            $reference_date = date('Y-m-d');
        }

        switch ($period) {
            case "daily":
                $reference_date = new DateTime($reference_date);
                $start_date = $reference_date->format('Y-m-d');
                $end_date = $reference_date->format('Y-m-d');
                break;
            case "weekly":
                $reference_date = new DateTime($reference_date);
                $week = $reference_date->format("W");
                $year = $reference_date->format("Y");
                $start_date = (new DateTime())->setISODate($year, $week, "1")->format('Y-m-d');
                $end_date = (new DateTime())->setISODate($year, $week, "7")->format('Y-m-d');
                break;
            case "monthly":
                $reference_date = new DateTime($reference_date);
                $start_date = $reference_date->format("Y-m-01");
                $end_date = $reference_date->format("Y-m-t");
                break;
            default:
                //do nothing
                break;
        }
        return [$start_date, $end_date];
    }

    private function getStatusColor()
    {
        $results = array();
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment_setting WHERE setting_key='appointment_status'");
        $result = $query->row;
        if (!empty($result)) {
            if ($result['serialized'] == '1') {
                $status_colors = unserialize($result['value']);
            }
            if (!empty($status_colors)) {
                $results[0] = $status_colors['pending_color'];
                $results[1] = $status_colors['confirm_color'];
                $results[2] = $status_colors['canceled_color'];
                $results[3] = $status_colors['attended_color'];
                $results[4] = $status_colors['draft_color'];
            }
        }
        return $results;
    }

    private function get_settings()
    {
        $setting_results = [];
        $settings = $this->model_name->get_settings();

        if (!empty($settings)) {
            foreach ($settings as $setting) {
                if ($setting['serialized'] == '1') {
                    $setting_results[$setting['setting_key']] = unserialize($setting['value']);
                } else {
                    $setting_results[$setting['setting_key']] = $setting['value'];
                }
            }
        }

        return $setting_results;
    }

    private function validateCustomerInfo($customer)
    {
        $required_info = ['name', 'customer_ic', 'telephone1'];
        if (!empty($customer['customer_id'])) {
            return true;
        } else {
            $result = true;
            foreach ($required_info as $info) {
                if (empty($customer[$info])) {
                    $result = false;
                    break;
                }
            }
            return $result;
        }
    }


    private function validateAddressInfo($address)
    {
        $required_info = [
            'address_1',
            'city',
            'post_code',
            'zone_id'
        ];

        $result = true;
        foreach ($required_info as $info) {
            if (empty($address[$info])) {
                $result = false;
                break;
            }
        }
        return $result;
    }

    private function slotBooked_backup($data)
    {
        $appointment_id = !empty($data['appointment_id']) ? $data['appointment_id'] : null;
        $appointment_booked = $this->model_name->checkBooked($data['doctor_id'], $data['appointment_date'], $data['appointment_time'], $appointment_id);

        if (!empty($appointment_booked)) {
            return true;
        } else {
            return false;
        }
    }

    private function slotBooked($data)
    {
        $service_id = !empty($data['service_id']) ? $data['service_id'] : null;
        $store_id = $this->session->data['store_id'];
        $doctor_id = !empty($data['doctor_id']) ? $data['doctor_id'] : null;
        $date = !empty($data['appointment_date']) ? $data['appointment_date'] : null;
        $time = !empty($data['appointment_time']) ? $data['appointment_time'] : null;
        $app_start_time = strtotime($time);

        $app_day = date('l', strtotime($date));

        //check doctor slot
        $sql = "SELECT a.*, CASE WHEN s.cs_minute IS NULL THEN '30' ELSE s.cs_minute END AS service_minute FROM " . DB_PREFIX . "appointment a 
            LEFT JOIN " . DB_PREFIX . "clinical_service s ON(a.clinicalservice_id = s.clinicalservice_id)
            WHERE 1 
            AND a.status <> '2'
            AND a.hide = '0'
            AND a.store_id = '" . (int)$store_id . "'
            AND a.doctor_id = '" . (int)$doctor_id . "'
            AND a.appointment_date = '" . $this->db->escape($date) . "'";
        if (!empty($data['appointment_id'])) {
            $sql .= " AND a.appointment_id <> '" . (int)$data['appointment_id'] . "'";
        }
        $query = $this->db->query($sql);
        foreach ($query->rows as $row) {
            $start_time = strtotime($row['appointment_time']);
            $end_time = $start_time + ($row['service_minute'] * 60);
            $app_end_time = $app_start_time + ($row['service_minute'] * 60);

            if ($app_start_time >= $start_time && $app_start_time < $end_time) {
                $this->error = "The doctor already booked by others for the selected date & time";
                return true;
            }

            if ($app_end_time > $start_time && $app_end_time <= $end_time) {
                $this->error = "The doctor already booked by others for the selected date & time";
                return true;
            }

            if ($start_time >= $app_start_time && $end_time <= $app_end_time) {
                $this->error = "The doctor already booked by others for the selected date & time";
                return true;
            }
        }


        //check if service required facilities
        $facilities = $this->model_name->getServiceFacilities($service_id);
        if (!empty($facilities)) {
            $facility_booked = [];
            foreach ($facilities as $facility) {
                $facility_booked[$facility['facility_id']] = false;
                $sql = "SELECT a.*, CASE WHEN s.cs_minute IS NULL THEN '30' ELSE s.cs_minute END AS service_minute FROM " . DB_PREFIX . "appointment a 
                LEFT JOIN " . DB_PREFIX . "clinical_service s ON(a.clinicalservice_id = s.clinicalservice_id)
                WHERE 1 
                AND a.status <> '2'
                AND a.hide = '0'
                AND a.store_id = '" . (int)$store_id . "'
                AND a.facility_id = '" . (int)$facility['facility_id'] . "'
                AND a.appointment_date = '" . $this->db->escape($date) . "'";
                if (!empty($data['appointment_id'])) {
                    $sql .= " AND a.appointment_id <> '" . (int)$data['appointment_id'] . "'";
                }
                $query = $this->db->query($sql);
                foreach ($query->rows as $row) {
                    $start_time = strtotime($row['appointment_time']);
                    $end_time = $start_time + ($row['service_minute'] * 60);
                    $app_end_time = $app_start_time + ($row['service_minute'] * 60);

                    if ($app_start_time >= $start_time && $app_start_time < $end_time) {
                        //record facility not available
                        $facility_booked[$facility['facility_id']] = true;
                        break;
                    }

                    if ($app_end_time > $start_time && $app_end_time <= $end_time) {
                        //record facility not available
                        $facility_booked[$facility['facility_id']] = true;
                        break;
                    }

                    if ($start_time >= $app_start_time && $end_time <= $app_end_time) {
                        //record facility not available
                        $facility_booked[$facility['facility_id']] = true;
                        break;
                    }
                }
            }

            if (!empty($facility_booked)) {
                foreach ($facility_booked as $id => $booked) {
                    if (!$booked) {
                        //check facility availability
                        $facility_info = $this->model_name->getFacilitiesDetail($id);

                        if (!empty($facility_info)) {
                            //available 24/7
                            if ($facility_info['available'] == '1') {
                                $this->selected_facility = $id;
                                return false;
                            } else {
                                foreach ($facility_info['availabilities'] as $availability) {
                                    if ($availability['day'] == $app_day) {
                                        $start_time = strtotime($availability['start_time']);
                                        $end_time = strtotime($availability['end_time']);
                                        if ($start_time <= $app_start_time && $end_time >= $app_end_time) {
                                            $this->selected_facility = $id;
                                            return false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                //return true if not facility left to assigned
                $this->error = "No facility available to conduct the service for the selected date & time";
                return true;
            }
        }
        return false;
    }
    private function getInfo($appointment_id, $msg = '')
    {
        if ($this->credit_balance === null) {
            $this->credit_balance = $this->getTotalBalance();
        }
        $appointment = $this->model_name->getAppointment($appointment_id);
        $arr_status_text = $this->session->data['language_id'] == 1 ? $this->arr_statuses_en : $this->arr_statuses_cn;

        if (!empty($appointment['customer_id'])) {
            $customer_info = $this->model_name->getCustomer($appointment['customer_id']);
            $customer_name =  trim($customer_info['firstname'] . " " . $customer_info['lastname']);
            $customer = [
                "customer_id" => $appointment['customer_id'],
                "name" => $customer_name,
                "email" => $customer_info['email'],
                "telephone1" => str_replace('-', '', $customer_info['telephone']),
                "customer_ic" => $customer_info['customer_ic'],
            ];
        } else {
            $customer = [
                "customer_id" => $appointment['customer_id'],
                "name" => $appointment['customer_name'],
                "email" => $appointment['email'],
                "telephone1" => str_replace('-', '', $appointment['telephone']),
                "customer_ic" => !empty($appointment['customer_ic']) ? $appointment['customer_ic'] : null,
            ];
        }

        $credit_deducted = 0;
        if ((bool)$appointment['from_etcm'] && $appointment['status'] == '1') {
            $credit_deducted = $this->appointment_fee;
        }
        $result = array(
            "appointment_id" => $appointment['appointment_id'],
            "appointment_date" => $appointment['appointment_date'],
            "appointment_time" => $appointment['appointment_time'],
            "created_date" => date_format(date_create($appointment['created_date']), "j M Y"),
            "from_etcm" => (bool)$appointment['from_etcm'],
            "credit_deducted" => (float)$credit_deducted,
            "credit_balance" => (float)$this->credit_balance,
            "status_id" => $appointment['status'],
            "status_text" => $arr_status_text[$appointment['status']],
            "status_color" => $this->arr_status_colors[$appointment['status']],
            "email" => $appointment['email'],
            "telephone" => $appointment['telephone'],
            "service" => array(
                "id" => $appointment['clinicalservice_id'],
                "label" => $appointment['service_name'],
                "name" => $appointment['service_name'],
                "service_minute" => $appointment['service_minute'],
                "price" => $appointment['service_price']
            ),
            "doctor" => array(
                "id" => $appointment['doctor_id'],
                "name" => $appointment['doctor_name']
            ),
            "customer" => $customer,
            "remark" => $appointment['remark'],
            "cancel_time" => $appointment['status'] == '2' ? date_format(date_create($appointment['lastmodified_date']), "j M Y     g:i:A") : null,
            "cancel_reason" => $appointment['cancel_reason'],
            "message" => (string)$msg
        );

        return $result;
    }

    private function getAppointmentDate($date_type)
    {
        date_default_timezone_set("Asia/Kuala_Lumpur");
        switch (trim($date_type)) {
            case 'today':
                $start = date("Y-m-d");
                $end = $start;
                break;
            case 'tomorrow':
                $start = date("Y-m-d", strtotime('tomorrow'));
                $end = $start;
                break;
            case 'yesterday':
                $start = date("Y-m-d", strtotime('yesterday'));
                $end = $start;
                break;
            case 'this_week':
                $start = date("Y-m-d", strtotime('monday this week'));
                $end = date("Y-m-d", strtotime('sunday this week'));
                break;
            case 'this_month':
                $start = date("Y-m-01");
                $end = date("Y-m-d", strtotime('last day of this month'));
                break;
            case 'this_year':
                $start = date("Y-01-01");
                $end = date("Y-12-31");
                break;
            case 'last7days':
                $start = date("Y-m-d", strtotime('- 7 days'));
                $end = date("Y-m-d");
                break;
            case 'last30days':
                $start = date("Y-m-d", strtotime('- 30 days'));
                $end = date("Y-m-d");
                break;
            case 'last90days':
                $start = date("Y-m-d", strtotime('- 90 days'));
                $end = date("Y-m-d");
                break;
            case 'upcoming':
                $start = date('Y-m-d');
                $end = null;
                break;
            case 'past':
                $end = date('Y-m-d', strtotime('yesterday'));
                $start = null;
                break;
            case 'all':
                $end = $start = null;
                break;
            default:
                $end = $start = date('Y-m-d');
                break;
        }
        return [
            "start" => $start,
            "end" => $end
        ];
    }

    private function todaySlotExist($doctor_id)
    {
        $today = date('l');
        $times = $this->model_name->getTimes($this->session->data['store_id'], $today, $doctor_id);
        $result = false;
        if (!empty($times)) {
            foreach ($times as $time) {
                if (!empty($time['start_time']) && !empty($time['end_time'])) {
                    $temp = strtotime($time['start_time']);
                    if (strtotime('now') < $temp) {
                        $result = true;
                    }

                    while (strtotime($time['end_time']) > $temp) {
                        $temp = $temp + ($time['minutes'] * 60);
                        $temp2 = $temp + ($time['minutes'] * 60);
                        if ($temp2 <= strtotime($time['end_time'])) {

                            if (strtotime('now') < $temp) {
                                $result = true;
                            }
                        }
                    }
                }
            }
        }
        return $result;
    }

    private function sendNotificationToPatient($data)
    {
        $sms_appointment_info = $this->config->get('config_sms_appointment');
        if ($sms_appointment_info['status'] == '1' && $data['status_id'] == '1') {

            //store name
            $store_id = $this->session->data['store_id'];
            if ($store_id == '0') {
                $store_name = htmlspecialchars_decode($this->config->get('config_name')) . " (HQ)";
            } else {
                $this->load->model('setting/store');
                $stores = $this->model_setting_store->getStores();
                foreach ($stores as $store) {
                    if ($store['store_id'] == $store_id) {
                        $store_name = $store['name'];
                    }
                }
            }

            $appointment_template = $sms_appointment_info['template'];

            $find = array(
                '{action}',
                '{date}',
                '{time}',
                '{storename}'
            );

            $replace = array(
                'action' => 'confirmed on',
                'date' => $data['appointment_date'],
                'time' => $data['appointment_time'],
                'storename' => $store_name
            );

            $sms_message = str_replace($find, $replace, $appointment_template);
            $telephone = $data['telephone'];
            $formattedNumber = $this->formatTelephone($telephone);
            $sms = new SMS($this->config->get('config_sms'));
            $sms->sendTo($this->getMobileCode(), $formattedNumber)
                ->setMessage($sms_message)
                ->send();
        }
    }

    // Get Malaysia Mobile Code
    private function getMobileCode()
    {
        return '+60';
    }

    // Format the telephone number with mobile code
    private function formatTelephone($telephone)
    {
        $telephone_formatted = '';
        $mobile_code = $this->getMobileCode();
        if (substr($telephone, 0, 3) == $mobile_code) {
            $telephone_formatted = ltrim($telephone, $mobile_code);
        } else {
            if (substr($telephone, 0, 1) == '0') {
                $telephone_formatted = ltrim($telephone, '0');
            } elseif (substr($telephone, 0, 2) == '60') {
                $telephone_formatted = ltrim($telephone, '60');
            }
        }
        return $telephone_formatted;
    }

    private function sendNotificationToDoctor($info)
    {
        $this->load->model('android/common/notification');
        $doctor_id = $info['doctor']['id'];
        if ($doctor_id != $this->session->data['user_id'] && in_array($info['status_id'], ['1', '2', '3'])) {
            $language_id = $this->model_android_common_notification->getUserLanguageId($doctor_id);

            $notification = $this->generateNotification($info, $language_id);

            $app_url = $this->model_android_common_notification->getNotificationDataUrl('doctorapp', 'appointment');
            $data = array("url" => str_replace(':id', $info['appointment_id'], $app_url));

            $module = 'appointment';
            $action = '';

            if($info['status_id']=='1'){
                $action = 'confirm';
            }

            if($info['status_id']=='2'){
                $action = 'cancel';
            }
            
            if ($info['status_id'] == '3') {
                $action = 'attend';
                //if attend, overwite data to related medical record/ service form document
                $session_result = $this->session->data['attend_result'];
                if (!empty($session_result['service_type'])) {
                    if ($session_result['service_type'] == 1) {
                        if (!empty($session_result["service_form_id"])) {
                            //get app_url for service_form
                            $app_url = $this->model_android_common_notification->getNotificationDataUrl('doctorapp', 'service_form');
                            $app_url = str_replace(':id', $session_result["service_form_id"], $app_url);
                            $app_url = str_replace(':customer-id', $info['customer']['customer_id'], $app_url);
                            $data = array("url" => $app_url);

                            $title_en = 'Appointment : Patient has checked in';
                            $title_cn = 'Appointment : Patient has checked in';

                            $body_en = 'Click Here to see service form';
                            $body_cn = 'Click Here to see service form';
                            $notification = array(
                                'title' => $this->session->data['language_id'] == '1' ? $title_en : $title_cn,
                                'body' => $this->session->data['language_id'] == '1' ? $body_en : $body_cn,
                            );

                            $module = 'service';
                            $action = 'new';
                        }
                    }
                    if ($session_result['service_type'] == 2) {
                        if (!empty($session_result["medical_record_id"])) {
                            //get app_url for medical_record
                            $app_url = $this->model_android_common_notification->getNotificationDataUrl('doctorapp', 'medical_record');
                            $app_url = str_replace(':id', $session_result["medical_record_id"], $app_url);
                            $app_url = str_replace(':customer-id', $info['customer']['customer_id'], $app_url);
                            $data = array("url" => $app_url);

                            $title_en = 'Appointment : Patient has checked in';
                            $title_cn = 'Appointment : Patient has checked in';

                            $body_en = 'Click Here to see medical record';
                            $body_cn = 'Click Here to see medical record';
                            $notification = array(
                                'title' => $this->session->data['language_id'] == '1' ? $title_en : $title_cn,
                                'body' => $this->session->data['language_id'] == '1' ? $body_en : $body_cn,
                            );
                            $module = 'medical_record';
                            $action = 'new';
                        }
                    }
                }
            }

            $params = array(
                "user_id" => $doctor_id,
                "notification" => $notification,
                "notification_type" => 'appointment',
                "data" => $data,
                "module" => $module,
                "action" => $action
            );
            $this->load->controller('android/common/notification/push', $params);

            //send to additional user if got
            $add_user_ids = [];
            $app_setting = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment_setting WHERE setting_key = 'additional_notification'")->row;
            if (!empty($app_setting)) {
                if ($app_setting['serialized'] == '1') {
                    $add_user_ids = unserialize($app_setting['value']);
                } else {
                    $add_user_ids = $app_setting['value'];
                }
            }

            foreach($add_user_ids as $user_id){
                $language_id = $this->model_android_common_notification->getUserLanguageId($user_id);
                $notification = $this->generateNotification($info, $language_id);
                $app_url = $this->model_android_common_notification->getNotificationDataUrl('doctorapp', 'appointment');
                $data = array("url" => str_replace(':id', $info['appointment_id'], $app_url));

                $params = array(
                    "user_id" => $user_id,
                    "notification" => $notification,
                    "notification_type" => 'appointment',
                    "data" => $data
                );
                $this->load->controller('android/common/notification/push', $params);
            }

        }
    }

    private function generateNotification($info, $language_id)
    {
        switch ($info['status_id']) {
            case "1":
                $title_en = 'Appointment Confirmed!';
                $title_cn = '预约已确认!';

                $body_en = 'Booking Slot : ' . $info['appointment_time'] . ' on ' . date("j M y", strtotime($info['appointment_date']));
                $body_cn = 'Booking Slot : ' . $info['appointment_time'] . ' on ' . date("j M y", strtotime($info['appointment_date']));
                break;
            case "2":
                $title_en = 'Appointment Cancelled!';
                $title_cn = '预约已取消！';

                $body_en = 'Booking Slot : ' . $info['appointment_time'] . ' on ' . date("j M y", strtotime($info['appointment_date']));
                $body_cn = 'Booking Slot : ' . $info['appointment_time'] . ' on ' . date("j M y", strtotime($info['appointment_date']));
                break;
            case "3":
                $title_en = 'Appointment : Patient has checked in';
                $title_cn = '预约：患者已登记';

                $body_en = 'Booking Slot : ' . $info['appointment_time'] . ' on ' . date("j M y", strtotime($info['appointment_date']));
                $body_cn = 'Booking Slot : ' . $info['appointment_time'] . ' on ' . date("j M y", strtotime($info['appointment_date']));
                break;
            case "4":
            default:
                $title_en = 'Your Appointment have been updated !';
                $title_cn = '您的预约已更新！';

                $body_en = 'Click to see detail';
                $body_cn = '点击查看详情';
        }

        return array(
            'title' => $language_id == '1' ? $title_en : $title_cn,
            'body' => $language_id == '1' ? $body_en : $body_cn,
        );
    }

    private function connectCurl($path, $data, $server = 'live')
    {
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        if ($language == 'zh') {
            $language = 'cn';
        }

        $device_id = !empty($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : '';

        if ($server == 'live') {
            $url = 'https://www.etcm.me/index.php?route=' . $path;
        } else {
            $url = HTTP_API . 'doctorapp/v2/index.php?route=' . $path;
        }
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, htmlspecialchars_decode(json_encode($data)));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Accept-Language: ' . $language, 'Device-Id: ' . $device_id, 'Content-Type: application/json'));
        curl_setopt($curl, CURLOPT_TIMEOUT, 15);

        $response = curl_exec($curl);

        $result = json_decode(htmlspecialchars_decode($response), true);

        curl_close($curl);

        return $result;
    }
}
