$(window).load(function () {
    $(".page-loader").fadeOut("slow");
});

$(document).ready(function (e) {
    if ($('nav#column-left').hasClass('active')) {
        $('nav#column-left').removeClass('active');
    }

    $("#form-customer").submit(function (e) {
        //stop submitting the form to see the disabled button effect
        //e.preventDefault();

        //disable the submit button
        $("#button_save_customer").attr("disabled", true);

        return true;
    });
});

$('select[name=\'customer_group_id\']').on('change', function () {
    $.ajax({
        url: 'index.php?route=herbal/new_herbal/customfield&user_token=' + encodeURIComponent(user_token) + '&customer_group_id=' + this.value,
        dataType: 'json',
        success: function (json) {
            $('.custom-field').hide();
            $('.custom-field').removeClass('required');

            for (i = 0; i < json.length; i++) {
                custom_field = json[i];

                $('.custom-field' + custom_field['custom_field_id']).show();

                if (custom_field['required']) {
                    $('.custom-field' + custom_field['custom_field_id']).addClass('required');
                }
            }
        },
        error: function (xhr, ajaxOptions, thrownError) {
            alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
        }
    });
});

$('select[name=\'customer_group_id\']').trigger('change');

$('.date').datetimepicker({
    pickTime: false
});

$('.datetime').datetimepicker({
    pickDate: true,
    pickTime: true
});

$('.time').datetimepicker({
    pickDate: false
});

$("input").keypress(function (event) {
    if (event.which === 13) {
        event.preventDefault();
    }
});

$('#input-customer-ic').on('change', function () {
    var customer_ic = $(this).val();

    if ($('#input-dob').prop('readonly') && $('#input-gender').prop('readonly')) {
        return;
    } else {
        if ((customer_ic.length === 12) && (!customer_ic.match(/^[A-Za-z]+$/))) {
            var year = customer_ic.substring(0, 2);
            var month = customer_ic.substring(2, 4);
            var day = customer_ic.substring(4, 6);
            var last_digit = customer_ic.substring(11, 12);

            var int_year = parseInt(year);
            var int_month = parseInt(month);
            var int_day = parseInt(day);
            var int_last_digit = parseInt(last_digit);
            var str_year = '';
            var str_dob = '';

            if (int_year <= 30) {
                str_year = '20' + year;
            } else if (int_year > 30) {
                str_year = '19' + year;
            }

            if ((int_month < 1) || (int_month > 12)) {
                $('#input-dob').val('');
                return;
            }

            if ((int_month == 1) || (int_month == 3) || (int_month == 5) || (int_month == 7) || (int_month == 8) || (int_month == 10) || (int_month == 12)) {
                if ((int_day < 1) || (int_day > 31)) {
                    $('#input-dob').val('');
                    return;
                }
            } else if (int_month == 2) {
                var cal_year = parseInt(str_year);

                if ((cal_year % 400 == 0 || cal_year % 100 != 0) && (cal_year % 4 == 0)) {
                    if ((int_day < 1) || (int_day > 29)) {
                        $('#input-dob').val('');
                        return;
                    }
                } else {
                    if ((int_day < 1) || (int_day > 28)) {
                        $('#input-dob').val('');
                        return;
                    }
                }
            } else if ((int_month == 4) || (int_month == 6) || (int_month == 9) || (int_month == 11)) {
                if ((int_day < 1) || (int_day > 30)) {
                    $('#input-dob').val('');
                    return;
                }
            }

            str_dob = str_year + '-' + month + '-' + day;

            $('#input-dob').val(str_dob);

            if (int_last_digit % 2 == 0) {
                $('#input-gender').val(2);
            } else {
                $('#input-gender').val(1);
            }
        } else {
            $('#input-dob').val('');
        }
    }
});

$('#input-customer-search').autocomplete({
    'source': function (request, response) {
        $.ajax({
            url: 'index.php?route=herbal/new_herbal/customerAutocomplete&user_token=' + encodeURIComponent(user_token) + '&filter_search=' + encodeURIComponent(request),
            dataType: 'json',
            success: function (json) {
                response($.map(json, function (item) {
                    return {
                        label: item['customer_name'] + ' , ' + item['customer_ic'] + ' , ' + item['telephone'],
                        value: item['customer_id'],
                        customer_ic: item['customer_ic'],
                        customer_card: item['customer_card'],
                        customer_name: item['customer_name'],
                        customer_firstname: item['customer_firstname'],
                        customer_lastname: item['customer_lastname'],
                        customer_group_id: item['customer_group_id'],
                        gender: item['gender'],
                        email: item['email'],
                        telephone: item['telephone']
                    }
                }));
            }
        });
    },
    'select': function (item) {
        console.log(item);
        $('#text-danger').hide();
        $('#warning').empty();
        $('#form-group').removeClass('has-error');
        $('.enter-key').attr("readonly", true);
        $('#input-customer-id').val(item['value']);
        $('#input-customer-ic').val(item['customer_ic']);
        $('#input-firstname').val(item['customer_firstname']);
        $('#input-lastname').val(item['customer_lastname']);
        $('#input-customer-name').val(item['customer_name']);
        $('#input-email').val(item['email']);
        $('#input-telephone').val(item['telephone']);

    }
});

function country(element, index, zone_id) {
    if (element.value !== '') {
        $.ajax({
            url: 'index.php?route=herbal/new_herbal/country&user_token=' + encodeURIComponent(user_token) + '&country_id=' + element.value,
            dataType: 'json',
            beforeSend: function () {
                $('select[name=\'address[' + index + '][country_id]\']').after(' <i class="fa fa-circle-o-notch fa-spin"></i>');
            },
            complete: function () {
                $('.fa-spin').remove();
            },
            success: function (json) {
                /*if (json['postcode_required'] == '1') {
                 $('input[name=\'address[' + index + '][postcode]\']').parent().addClass('required');
                 } else {
                 $('input[name=\'address[' + index + '][postcode]\']').parent().parent().removeClass('required');
                 }*/

                html = '<option value=""><?php echo $text_select; ?></option>';

                if (json['zone'] !== '') {
                    for (i = 0; i < json['zone'].length; i++) {
                        html += '<option value="' + json['zone'][i]['zone_id'] + '"';

                        if (json['zone'][i]['zone_id'] === zone_id) {
                            html += ' selected="selected"';
                        }

                        html += '>' + json['zone'][i]['name'] + '</option>';
                    }
                } else {
                    html += '<option value="0"><?php echo $text_none; ?></option>';
                }

                $('select[name=\'address[' + index + '][zone_id]\']').html(html);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    }
}

$('select[name$=\'[country_id]\']').trigger('change');

