<?php
class ModelWholesaleWholesaleCatalog extends Model{
    public function get_tax_format($tax_class_id, $tax_code){
        $sql = "SELECT * FROM " . DB_PREFIX . "tax_class tc LEFT JOIN " . DB_PREFIX . "tax_rule tr ON tr.tax_class_id = tc.tax_class_id LEFT JOIN " . DB_PREFIX . "tax_rate tra ON tra.tax_rate_id = tr.tax_rate_id WHERE tc.tax_class_id = '" . (int)$tax_class_id . "' AND tra.code = '" . $this->db->escape($tax_code) . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function add_wholesale_order($data, $etcm_wholesale_order_id){
        $merchant_ids = [];

		foreach($data['products'] as $store_id => $products){
			$merchant_ids[] = $store_id;
		}

		$merchant_id_str = serialize($merchant_ids);

		$sql = "INSERT INTO " . DB_PREFIX . "wholesale_order
				SET	etcm_wholesale_order_id = '" . (int)$etcm_wholesale_order_id . "',
                    merchant_id = '" . $this->db->escape($merchant_id_str) . "',
					customer_name = '" . $this->db->escape($data['customer_info']['customer_name']) . "',
					customer_telephone = '" . $this->db->escape($data['customer_info']['customer_telephone']) . "',
					customer_email = '" . $this->db->escape($data['customer_info']['customer_email']) . "',
					payment_name = '" . $this->db->escape($data['payment_address']['name']) . "',
					payment_company = '" . $this->db->escape($data['payment_address']['company']) . "',
					payment_address_1 = '" . $this->db->escape($data['payment_address']['address_1']) . "',
					payment_address_2 = '" . $this->db->escape($data['payment_address']['address_2']) . "',
					payment_city = '" . $this->db->escape($data['payment_address']['city']) . "',
					payment_postcode = '" . $this->db->escape($data['payment_address']['postcode']) . "',
					payment_country = '" . $this->db->escape($data['payment_address']['country_name']) . "',
					payment_country_id = '" . (int)$data['payment_address']['country_id'] . "',
					payment_zone = '" . $this->db->escape($data['payment_address']['zone_name']) . "',
					payment_zone_id = '" . (int)$data['payment_address']['zone_id'] . "',
					payment_method = '" . $this->db->escape($data['payment_method']['method_name']) . "',
					payment_code = '" . $this->db->escape($data['payment_method']['method_code']) . "',
					shipping_name = '" . $this->db->escape($data['shipping_address']['name']) . "',
					shipping_company = '" . $this->db->escape($data['shipping_address']['company']) . "',
					shipping_address_1 = '" . $this->db->escape($data['shipping_address']['address_1']) . "',
					shipping_address_2 = '" . $this->db->escape($data['shipping_address']['address_2']) . "',
					shipping_city = '" . $this->db->escape($data['shipping_address']['city']) . "',
					shipping_postcode = '" . $this->db->escape($data['shipping_address']['postcode']) . "',
					shipping_country = '" . $this->db->escape($data['shipping_address']['country_name']) . "',
					shipping_country_id = '" . (int)$data['shipping_address']['country_id'] . "',
					shipping_zone = '" . $this->db->escape($data['shipping_address']['zone_name']) . "',
					shipping_zone_id = '" . (int)$data['shipping_address']['zone_id'] . "',
					shipping_method = '" . $this->db->escape(serialize($data['shipping_method'])) . "',
					order_status_id = '1',
					language_id = '" . (int)$data['currency_data']['language_id'] . "',
					currency_id = '" . (int)$data['currency_data']['currency_id'] . "',
					currency_code = '" . $this->db->escape($data['currency_data']['currency_code']) . "',
					currency_value = '" . $data['currency_data']['currency_value'] . "',
					date_added = NOW(),
					date_modified = NOW()";

		$this->db->query($sql);

		$wholesale_order_id = $this->db->getLastId();

		foreach($data['products'] as $store_id => $products){
            foreach($products as $product){
                $tax_value = $product['calculated_price'] - $product['total_price_without_tax'];

    			$this->db->query("INSERT INTO " . DB_PREFIX . "wholesale_order_product
    							  SET wholesale_order_id = '" . (int)$wholesale_order_id . "',
                                                          wholesale_product_id = '" . (int)$product['wholesale_product_id'] . "',
                                                          merchant_id = '" . (int)$store_id . "',
                                                          etcm_product_id = '" . (int)$product['etcm_product_id'] . "',
                                                          merchant_product_id = '" . (int)$product['product_id'] . "',
                                                          product_name = '" . $this->db->escape($product['product_name']) . "',
                                                          product_code = '" . $this->db->escape($product['product_code']) . "',
                                                          weight_quantity = '" . $product['weight_quantity'] . "',
                                                          weight_class_unit = '" . $this->db->escape($product['weight_class_unit']) . "',
                                                          unit_price_without_tax = '" . $product['unit_price_without_tax'] . "',
                                                          unit_price = '" . $product['unit_price'] . "',
                                                          subtotal = '" . $product['unit_price'] . "',
    							  tax = '" . $tax_value . "',
                                                          total = '" . $product['calculated_price'] . "'");
            }
		}

		foreach($data['total'] as $total){
			$this->db->query("INSERT INTO " . DB_PREFIX . "wholesale_order_total
							  SET wholesale_order_id = '" . (int)$wholesale_order_id . "',
							  code = '" . $this->db->escape($total['code']) . "',
                                                          title = '" . $this->db->escape($total['title']) . "',
                                                          value = '" . $total['value'] . "',
                                                          sort_order = '" . (int)$total['sort_order'] . "'");

			if($total['code'] == 'total'){
				$this->db->query("UPDATE " . DB_PREFIX . "wholesale_order SET total = '" . $total['value'] . "' WHERE wholesale_order_id = '" . (int)$wholesale_order_id . "'");
			}
		}

		$this->db->query("INSERT INTO " . DB_PREFIX . "wholesale_order_history
						  SET wholesale_order_id = '" . (int)$wholesale_order_id . "',
							  order_status_id = '1',
							  notify = '1',
							  comment = '" . $this->db->escape($data['payment_method']['comment']) . "',
							  date_added = NOW()");

		return $wholesale_order_id;
    }
}
?>