<?php
class ModelUserUserDescription extends Model{
    public function getDoctorDescription($user_id){
		$sql = "SELECT * FROM " . DB_PREFIX . "user_description WHERE user_id = '" . (int)$user_id . "'";

		$query = $this->db->query($sql);

		return $query->row;
	}

    public function addDoctorDescription($user_id, $data){
        $this->db->query("DELETE FROM " . DB_PREFIX . "user_description WHERE user_id = '" . (int)$user_id . "'");

        $doctor_profession = isset($data['doctor_profession']) ? $data['doctor_profession'] : [];
        $doctor_position = isset($data['doctor_position']) ? $data['doctor_position'] : '';
        $other_professions = isset($data['other_professions']) ? $data['other_professions'] : '';
        $doctor_description = isset($data['doctor_description']) ? $data['doctor_description'] : '';

        $this->db->query("INSERT INTO " . DB_PREFIX . "user_description
                          SET user_id = '" . (int)$user_id . "',
                              position = '" . $this->db->escape($doctor_position) . "',
                              professions = '" . $this->db->escape(serialize($doctor_profession)) . "',
                              other_professions = '" . $this->db->escape($other_professions) . "',
                              description = '" . $this->db->escape($doctor_description) . "'");
    }

    public function deleteDoctorDescription($user_id){
        $this->db->query("DELETE FROM " . DB_PREFIX . "user_description WHERE user_id = '" . (int)$user_id . "'");
    }

    public function getDoctorTreatments($user_id){
        $sql = "SELECT * FROM " . DB_PREFIX . "user_treatment WHERE user_id = '" . (int)$user_id . "' ORDER BY sort_order ASC";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function addDoctorTreatments($user_id, $data){
        $this->db->query("DELETE FROM " . DB_PREFIX . "user_treatment WHERE user_id = '" . (int)$user_id . "'");

        if(isset($data['treatment'])){
            foreach($data['treatment'] as $treatment){
                $this->db->query("INSERT INTO " . DB_PREFIX . "user_treatment
                                  SET user_id = '" . (int)$user_id . "',
                                      treatment = '" . $this->db->escape($treatment['treatment']) . "',
                                      treatment_desc = '" . $this->db->escape($treatment['treatment_desc']) . "',
                                      sort_order = '" . (int)$treatment['sort_order'] . "'");
            }
        }
    }

    public function deleteDoctorTreatments($user_id){
        $this->db->query("DELETE FROM " . DB_PREFIX . "user_treatment WHERE user_id = '" . (int)$user_id . "'");
    }

    public function addUser($data) {
        $this->db->query("INSERT INTO `" . DB_PREFIX . "user` SET username = '" . $this->db->escape($data['username']) . "', user_group_id = '" . (int)$data['user_group_id'] . "', salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "', password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($data['password'])))) . "', firstname = '" . $this->db->escape($data['firstname']) . "', lastname = '" . $this->db->escape($data['lastname']) . "', email = '" . $this->db->escape($data['email']) . "', image = '" . $this->db->escape($data['image']) ."', chinesename ='".$this->db->escape($data['chinesename'])."', gender ='".$this->db->escape($data['gender'])."', dob ='".$this->db->escape($data['dob'])."', maritalstatus ='".$this->db->escape($data['maritalstatus'])."', race ='".$this->db->escape($data['race'])."', address ='".$this->db->escape($data['address'])."', ic ='".$this->db->escape($data['ic'])."', contactno ='".$this->db->escape($data['contactno'])."', salary ='".$this->db->escape($data['salary'])."', enable_appointment = '" . (int)$data['enable_appointment'] . "', doctor_sort_order = '" . (int)$data['doctor_sort_order'] . "', enable_consultation_price = '" . (int)$data['enable_consultation_price'] . "', consultationprice ='".$this->db->escape($data['consultationprice'])."', tax_class_id ='".(int)$data['tax_class_id']."', qualification ='".$this->db->escape($data['qualification'])."', periodfrom ='".$this->db->escape($data['periodfrom'])."', periodto ='".$this->db->escape($data['periodto'])."', remark ='".$this->db->escape($data['remark'])."', viewalldata ='".(int)$data['viewalldata']."', position ='".(int)$data['position']."', status = '" . (int)$data['status']."', add_by = '".(int)$this->session->data['user_id']."', modify_by = '".(int)$this->session->data['user_id']."', date_added = NOW(), date_modify = NOW()");

        $user_id = $this->db->getLastId();

        if (isset($data['user_store'])) {
			foreach ($data['user_store'] as $store_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "user_to_store SET user_id = '" . (int)$user_id . "', store_id = '" . (int)$store_id . "'");
			}
   	    }

        $this->db->query("INSERT INTO " . DB_PREFIX . "user_permission SET user_id = '" . (int)$user_id. "', permission = '" . (isset    ($data['permission']) ? $this->db->escape(serialize($data['permission'])) :'') . "'");

        return $user_id;
    }

    public function getServiceDoctor($data){
        $doctor_rows = [];

        $clinicalservice_id = $data['clinicalservice_id'];

        $service_sql = "SELECT * FROM " . DB_PREFIX . "clinical_service WHERE clinicalservice_id = '" . (int)$clinicalservice_id . "'";

        $service_query = $this->db->query($service_sql);
        $service_row = $service_query->row;

        if(!empty($service_row)){
            $doctor_sql = "SELECT * FROM " . DB_PREFIX . "user WHERE 1";

            $doctor_arr = unserialize($service_row['doctor_id']);

            if(!empty($doctor_arr)){
                $doctor_str = implode(',', $doctor_arr);

                $doctor_sql .= " AND user_id IN(" . $this->db->escape($doctor_str) . ")";
            } else{
                $doctor_rows = [];
                return;
            }

            $sort_data = array(
                'username',
                'status',
                'date_added'
            );

            if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
                $doctor_sql .= " ORDER BY " . $data['sort'];
            } else {
                $doctor_sql .= " ORDER BY username";
            }

            if (isset($data['order']) && ($data['order'] == 'DESC')) {
                $doctor_sql .= " DESC";
            } else {
                $doctor_sql .= " ASC";
            }

            if (isset($data['start']) || isset($data['limit'])) {
                if ($data['start'] < 0) {
                    $data['start'] = 0;
                }

                if ($data['limit'] < 1) {
                    $data['limit'] = 20;
                }

                $doctor_sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
            }

            $doctor_query = $this->db->query($doctor_sql);

            $doctor_rows = $doctor_query->rows;
        }

        return $doctor_rows;
    }

    public function getTotalServiceDoctor($data){
        $doctor_rows = [];
        $num_of_doctors = 0;

        $clinicalservice_id = $data['clinicalservice_id'];

        $service_sql = "SELECT * FROM " . DB_PREFIX . "clinical_service WHERE clinicalservice_id = '" . (int)$clinicalservice_id . "'";

        $service_query = $this->db->query($service_sql);
        $service_row = $service_query->row;

        if(!empty($service_row)){
            $doctor_sql = "SELECT * FROM " . DB_PREFIX . "user WHERE 1";

            $doctor_arr = unserialize($service_row['doctor_id']);

            if(!empty($doctor_arr)){
                $doctor_str = implode(',', $doctor_arr);

                $doctor_sql .= " AND user_id IN(" . $this->db->escape($doctor_str) . ")";
                $doctor_query = $this->db->query($doctor_sql);

                $doctor_rows = $doctor_query->rows;
                $num_of_doctors = count($doctor_rows);
            } else{
                $num_of_doctors = 0;
            }
        }

        return $num_of_doctors;
    }
}
?>
