<?php
class ModelTrackingshipmentproTrackingshipmentpro extends Model {
 
	public function addCarrier($data) {
	 
		$this->db->query("INSERT INTO " . DB_PREFIX . "carriers SET 
		                  name   = '" . $this->db->escape($data['name']) . "',
		                  url    = '" . $this->db->escape($data['url']) . "', 
		                  displaystatus = '" . (int)$data['displaystatus'] . "'");

		$carrier_id = $this->db->getLastId(); 

		foreach ($data['shipmentinfo'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "carriers_shipmentinfo SET 
			                  carrier_id = '" . (int)$carrier_id . "', 
							  language_id = '" . (int)$language_id . "', 
							  shipmentinfo = '" . $this->db->escape($value['shipmentinfo']) . "'");
		}
		
		if (isset($data['image'])) {
			$this->db->query("UPDATE " . DB_PREFIX . "carriers SET 
			                  image = '" . $this->db->escape(html_entity_decode($data['image'], ENT_QUOTES, 'UTF-8')) . "' 
							  WHERE carrier_id  = '" . (int)$carrier_id . "'");
		}

		$this->cache->delete('carriers');
	}
	
	
	
	
	

	public function editCarrier($carrier_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "carriers SET 
		                  name   = '" . $this->db->escape($data['name']) . "',
		                  url    = '" . $this->db->escape($data['url']) . "', 
		                  displaystatus = '" . (int)$data['displaystatus'] . "'
						  WHERE carrier_id = '" . (int)$carrier_id . "'
						  ");

		$this->db->query("DELETE FROM " . DB_PREFIX . "carriers_shipmentinfo WHERE carrier_id = '" . (int)$carrier_id . "'");

		foreach ($data['shipmentinfo'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "carriers_shipmentinfo SET 
			                  carrier_id = '" . (int)$carrier_id . "', 
							  language_id = '" . (int)$language_id . "',  
							  shipmentinfo = '" . $this->db->escape($value['shipmentinfo']) . "'
							  ");
		}
		
		if (isset($data['image'])) {
			$this->db->query("UPDATE " . DB_PREFIX . "carriers SET 
			                  image = '" . $this->db->escape(html_entity_decode($data['image'], ENT_QUOTES, 'UTF-8')) . "' 
							  WHERE carrier_id = '" . (int)$carrier_id . "'");
		}

		$this->cache->delete('carriers');
	}
	
	
	
	

	public function deleteCarrier($carrier_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "carriers WHERE carrier_id = '" . (int)$carrier_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "carriers_shipmentinfo WHERE carrier_id = '" . (int)$carrier_id . "'");
		$this->cache->delete('carriers');
	}	
	
	
	
	

	public function getCarrier($carrier_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "carriers WHERE carrier_id = '" . (int)$carrier_id . "'");
		return $query->row;
	}
	
	
	
	

	public function getCarriers($data = array()) {
		if ($data) {
			$sql = "SELECT * FROM " . DB_PREFIX . "carriers 
			        i LEFT JOIN " . DB_PREFIX . "carriers_shipmentinfo 
					id ON (i.carrier_id = id.carrier_id) 
					WHERE id.language_id = '" . (int)$this->config->get('config_language_id') . "' 
					ORDER BY displaystatus DESC, name ASC";

			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {$data['start'] = 0;}		
				if ($data['limit'] < 1) {$data['limit'] = 15;}	
				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}	

			$query = $this->db->query($sql);
			return $query->rows;
			
		} else {
		 
			$carrier_data = $this->cache->get('carriers.' . (int)$this->config->get('config_language_id'));

			if (!$carrier_data) {
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "carriers 
				i LEFT JOIN " . DB_PREFIX . "carriers_shipmentinfo 
				id ON (i.carrier_id = id.carrier_id) 
				WHERE id.language_id = '" . (int)$this->config->get('config_language_id') . "' 
				ORDER BY displaystatus DESC, name ASC");

				$carrier_data = $query->rows;

				$this->cache->set('carriers.' . (int)$this->config->get('config_language_id'), $carrier_data);
			}	

			return $carrier_data;			
		}
	}
	
	
	

	public function getShipmentinfo($carrier_id) {
		$shipmentinfo_data = array();

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "carriers_shipmentinfo WHERE carrier_id = '" . (int)$carrier_id . "'");
		
		foreach ($query->rows as $result) {
			$shipmentinfo_data[$result['language_id']] = array(
				'shipmentinfo' => $result['shipmentinfo']
			);
		}

		return $shipmentinfo_data;
	}
	
	

	public function getTotalCarriers() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "carriers");
		return $query->row['total'];
	}
	
	
	
	public function getUrl($carrier_id){
		$query = $this->db->query("SELECT url FROM `" . DB_PREFIX . "carriers` WHERE carrier_id = '" . (int)$carrier_id . "'");
		if($query->num_rows){
			return $query->row['url'];
		} else {
			return false;
		}	
	}
	
	public function getCarriername($carrier_id){
		$query = $this->db->query("SELECT name FROM `" . DB_PREFIX . "carriers` WHERE carrier_id = '" . (int)$carrier_id . "'");
		if($query->num_rows){
			return $query->row['name'];
		} else {
			return false;
		}	
	}
	

	public function getIcon($carrier_id){
		$query = $this->db->query("SELECT image FROM `" . DB_PREFIX . "carriers` WHERE carrier_id = '" . (int)$carrier_id . "'");
		if($query->num_rows){
			return $this->model_tool_image->resize($query->row['image'], 110, 30);
		} else {
			return false;
		}	
	}			




	public function getCustOrderLangId($order_id) {
		$query = $this->db->query("SELECT language_id FROM `" . DB_PREFIX . "order` WHERE order_id = '" . (int)$order_id . "'");
		return $query->row['language_id'];
	}
	
	
	
	public function getShopDefaultLangId() {
		$query = $this->db->query("SELECT language_id FROM `" . DB_PREFIX . "language` WHERE code = '" . $this->config->get('config_language') . "'");
		return $query->row['language_id'];
	}
	
	
	public function deleteOrderHistoryComment($history_id) {
	  	$this->db->query("DELETE FROM " . DB_PREFIX . "order_history WHERE order_history_id = '" . (int)$history_id . "'");
	  	}	
	
}