<?php

class ModelSettingTransactionNo extends Model {

    public function addTransaction($data) {

        $this->db->query("INSERT INTO " . DB_PREFIX . "transaction_no SET module = '" . $this->db->escape($data['module']) . "', store_id = '" . (int) $data['store_id'] . "', prefix = '" . $this->db->escape($data['prefix']) . "', lastrunningno = '" . (int) $data['lastrunningno'] . "', length = '" . (int) $data['length'] . "', add_by = '" . (int) $this->session->data['user_id'] . "', modify_by = '" . (int) $this->session->data['user_id'] . "', date_added = NOW() , date_modify = NOW()");

        $transaction_no_id = $this->db->getLastId();

        $this->cache->delete('transaction');

        return $transaction_no_id;
    }

    public function editTransaction($transaction_id, $data) {

        $this->db->query("UPDATE " . DB_PREFIX . "transaction_no SET module = '" . $this->db->escape($data['module']) . "', store_id = '" . (int) $data['store_id'] . "', prefix = '" . $this->db->escape($data['prefix']) . "', lastrunningno = '" . (int) $data['lastrunningno'] . "', length = '" . (int) $data['length'] . "', modify_by = '" . (int) $this->session->data['user_id'] . "', date_modify = NOW() WHERE transaction_no_id='" . (int) $transaction_id . "'");

        $this->cache->delete('transaction');

    }

    public function getTransactionNo($transaction_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "transaction_no WHERE transaction_no_id = '" . (int) $transaction_id . "'");
        return $query->row;
    }

    public function getTransactionNos($data = array()) {
        $sql = "SELECT * FROM " . DB_PREFIX . "transaction_no ";

        if (isset($data['store_id'])) {
            $sql .= " WHERE store_id = '" . (int) $data['store_id'] . "'";
        } else {
            $sql .= " WHERE store_id = '" . (int) $this->session->data['store_id'] . "'";
        }

        if (!empty($data['module'])) {
            $sql .= " AND module = '" . $this->db->escape($data['module']) . "'";
        }

        if (!empty($data['prefix'])) {
            $sql .= " AND prefix LIKE '" . $this->db->escape($data['prefix']) . "%'";
        }



        $sql .= " GROUP BY transaction_no_id";

        $sort_data = array(
            'module',
            'prefix'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY module";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalTransactionNo($data = array()) {
        $sql = "SELECT COUNT(DISTINCT transaction_no_id) AS total FROM " . DB_PREFIX . "transaction_no ";

        if (isset($data['store_id'])) {
            $sql .= " WHERE store_id = '" . (int) $data['store_id'] . "'";
        } else {
            $sql .= " WHERE store_id = '" . (int) $this->session->data['store_id'] . "'";
        }

        if (!empty($data['module'])) {
            $sql .= " AND module = '" . $this->db->escape($data['module']) . "'";
        }

        if (!empty($data['prefix'])) {
            $sql .= " AND prefix LIKE '" . $this->db->escape($data['prefix']) . "%'";
        }



        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getTransactionByModel($model, $store) {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "transaction_no` WHERE module = '" . $this->db->escape($model) . "' AND module != '' AND store_id = '" . (int) $store . "'");

        return $query->row;
    }

    public function setTransaction($data) {
        $this->db->query("UPDATE " . DB_PREFIX . "transaction_no SET lastrunningno = lastrunningno + 1 WHERE module='" . $this->db->escape($data['module']) . "' AND store_id = '" . (int) $data['store_id'] . "'");
    }

}
