<?php

class ModelSettingStoreHoliday extends Model {

    public function getStoreHoliday($store_holiday_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "store_holiday WHERE id = '" . (int) $store_holiday_id . "'");

        return $query->row;
    }

    public function getHolidays($data) {
        
        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }
        
        $sql = "SELECT * FROM " . DB_PREFIX . "store_holiday WHERE store_id = '" . $store_id . "'";

        $sort_data = array(
            'id',
            'title',
            'start',
            'end'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalHolidays($data) {
        
        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }
        
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "store_holiday WHERE store_id = '" . $store_id . "'";

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function addHoliday($data) {
        $sql = "INSERT INTO " . DB_PREFIX . "store_holiday
				SET store_id = '" . (int) $this->session->data['store_id'] . "',
					title = '" . $this->db->escape($data['store_holiday_title']) . "',
					start = '" . $this->db->escape($data['start_date']) . "',
					end = '" . $this->db->escape($data['end_date']) . "'";

        $query = $this->db->query($sql);

        return $this->db->getLastId();
    }

    public function editHoliday($data, $store_holiday_id) {
        $sql = "UPDATE " . DB_PREFIX . "store_holiday
				SET store_id = '" . (int) $this->session->data['store_id'] . "',
					title = '" . $this->db->escape($data['store_holiday_title']) . "',
					start = '" . $this->db->escape($data['start_date']) . "',
					end = '" . $this->db->escape($data['end_date']) . "'
				WHERE id = '" . (int) $store_holiday_id . "'";

        $query = $this->db->query($sql);

        return $this->db->countAffected();
    }

    public function deleteHoliday($store_holiday_id) {
        $sql = "DELETE FROM " . DB_PREFIX . "store_holiday WHERE id = '" . (int) $store_holiday_id . "'";

        $this->db->query($sql);
    }

}
