<?php

class ModelSettingAdminMenu extends Model {

    public function addmenu($data) {
        if ($data['link'] == true) {
            $data['path'] = $data['internal'];
        } else {
            $data['path'] = $data['external'];
        }

        $this->db->query("INSERT INTO " . DB_PREFIX . "admin_menu SET parent_id = '" . (int) $data['parent_id'] . "', `path` = '" . $this->db->escape($data['path']) . "', `icon` = '" . $this->db->escape($data['icon']) . "', `link` = '" . (int) $data['link'] . "', index_name= '" . $this->db->escape($data['index_name']) . "', `new_tab` = '" . (int) $data['newtab'] . "', sort_order = '" . (int) $data['sort_order'] . "', status = '" . (int) $data['status'] . "', add_by = '" . (int) $this->session->data['user_id'] . "', modifi_by='" . (int) $this->session->data['user_id'] . "', date_modified = NOW(), date_added = NOW()");

        $menu_id = $this->db->getLastId();

        foreach ($data['menu_description'] as $language_id => $value) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "admin_menu_description SET menu_id = '" . (int) $menu_id . "', language_id = '" . (int) $language_id . "', name = '" . $this->db->escape($value['name']) . "'");
        }

        // MySQL Hierarchical Data Closure Table Pattern
        $level = 0;

        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "admin_menu_path` WHERE menu_id = '" . (int) $data['parent_id'] . "' ORDER BY `level` ASC");

        foreach ($query->rows as $result) {
            $this->db->query("INSERT INTO `" . DB_PREFIX . "admin_menu_path` SET `menu_id` = '" . (int) $menu_id . "', `path_id` = '" . (int) $result['path_id'] . "', `level` = '" . (int) $level . "'");

            $level++;
        }

        $this->db->query("INSERT INTO `" . DB_PREFIX . "admin_menu_path` SET `menu_id` = '" . (int) $menu_id . "', `path_id` = '" . (int) $menu_id . "', `level` = '" . (int) $level . "'");

        return $menu_id;
    }

    public function editMenu($menu_id, $data) {
        if ($data['link'] == true) {
            $data['path'] = $data['internal'];
        } else {
            $data['path'] = $data['external'];
        }

        $this->db->query("UPDATE " . DB_PREFIX . "admin_menu SET  parent_id = '" . (int) $data['parent_id'] . "', `path` = '" . $this->db->escape($data['path']) . "',  `icon` = '" . $this->db->escape($data['icon']) . "', `link` = '" . (int) $data['link'] . "', index_name= '" . $this->db->escape($data['index_name']) . "', `new_tab` = '" . (int) $data['newtab'] . "', sort_order = '" . (int) $data['sort_order'] . "', status = '" . (int) $data['status'] . "', modifi_by = '" . (int) $this->session->data['user_id'] . "', date_modified = NOW()  WHERE menu_id = '" . (int) $menu_id . "'");

        $this->db->query("DELETE FROM " . DB_PREFIX . "admin_menu_description WHERE menu_id = '" . (int) $menu_id . "'");
        foreach ($data['menu_description'] as $language_id => $value) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "admin_menu_description SET menu_id = '" . (int) $menu_id . "', language_id = '" . (int) $language_id . "', name = '" . $this->db->escape($value['name']) . "'");
        }

        // MySQL Hierarchical Data Closure Table Pattern
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "admin_menu_path` WHERE path_id = '" . (int) $menu_id . "' ORDER BY level ASC");

        if ($query->rows) {
            foreach ($query->rows as $admin_menu_path) {
                // Delete the path below the current one
                $this->db->query("DELETE FROM `" . DB_PREFIX . "admin_menu_path` WHERE menu_id = '" . (int) $admin_menu_path['menu_id'] . "' AND level < '" . (int) $admin_menu_path['level'] . "'");

                $path = array();

                // Get the nodes new parents
                $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "admin_menu_path` WHERE menu_id = '" . (int) $data['parent_id'] . "' ORDER BY level ASC");

                foreach ($query->rows as $result) {
                    $path[] = $result['path_id'];
                }

                // Get whats left of the nodes current path
                $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "admin_menu_path` WHERE menu_id = '" . (int) $admin_menu_path['menu_id'] . "' ORDER BY level ASC");

                foreach ($query->rows as $result) {
                    $path[] = $result['path_id'];
                }

                // Combine the paths with a new level
                $level = 0;

                foreach ($path as $path_id) {
                    $this->db->query("REPLACE INTO `" . DB_PREFIX . "admin_menu_path` SET menu_id = '" . (int) $admin_menu_path['menu_id'] . "', `path_id` = '" . (int) $path_id . "', level = '" . (int) $level . "'");

                    $level++;
                }
            }
        } else {
            // Delete the path below the current one
            $this->db->query("DELETE FROM `" . DB_PREFIX . "admin_menu_path` WHERE menu_id = '" . (int) $menu_id . "'");

            // Fix for records with no paths
            $level = 0;

            $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "admin_menu_path` WHERE menu_id = '" . (int) $data['parent_id'] . "' ORDER BY level ASC");

            foreach ($query->rows as $result) {
                $this->db->query("INSERT INTO `" . DB_PREFIX . "admin_menu_path` SET menu_id = '" . (int) $menu_id . "', `path_id` = '" . (int) $result['path_id'] . "', level = '" . (int) $level . "'");

                $level++;
            }

            $this->db->query("REPLACE INTO `" . DB_PREFIX . "admin_menu_path` SET menu_id = '" . (int) $menu_id . "', `path_id` = '" . (int) $menu_id . "', level = '" . (int) $level . "'");
        }
    }

    public function deleteMenu($menu_id) {
        $this->db->query("DELETE FROM " . DB_PREFIX . "admin_menu_path WHERE menu_id = '" . (int) $menu_id . "'");

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "admin_menu_path WHERE path_id = '" . (int) $menu_id . "'");

        foreach ($query->rows as $result) {
            $this->deleteMenu($result['menu_id']);
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "admin_menu WHERE menu_id = '" . (int) $menu_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "admin_menu_description WHERE menu_id = '" . (int) $menu_id . "'");
    }

    public function repairMenus($parent_id = 0) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "admin_menu WHERE parent_id = '" . (int) $parent_id . "'");

        foreach ($query->rows as $menu) {
            // Delete the path below the current one
            $this->db->query("DELETE FROM `" . DB_PREFIX . "admin_menu_path` WHERE menu_id = '" . (int) $menu['menu_id'] . "'");

            // Fix for records with no paths
            $level = 0;

            $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "admin_menu_path` WHERE menu_id = '" . (int) $parent_id . "' ORDER BY level ASC");

            foreach ($query->rows as $result) {
                $this->db->query("INSERT INTO `" . DB_PREFIX . "admin_menu_path` SET menu_id = '" . (int) $menu['menu_id'] . "', `path_id` = '" . (int) $result['path_id'] . "', level = '" . (int) $level . "'");

                $level++;
            }

            $this->db->query("REPLACE INTO `" . DB_PREFIX . "admin_menu_path` SET menu_id = '" . (int) $menu['menu_id'] . "', `path_id` = '" . (int) $menu['menu_id'] . "', level = '" . (int) $level . "'");

            $this->repairMenus($menu['menu_id']);
        }
    }

    public function getMenu($menu_id) {
        $query = $this->db->query("SELECT DISTINCT *, (SELECT GROUP_CONCAT(cd1.name ORDER BY level SEPARATOR '&nbsp;&nbsp;&gt;&nbsp;&nbsp;') FROM " . DB_PREFIX . "admin_menu_path cp LEFT JOIN " . DB_PREFIX . "admin_menu_description cd1 ON (cp.path_id = cd1.menu_id AND cp.menu_id != cp.path_id) WHERE cp.menu_id = c.menu_id AND cd1.language_id = '" . (int) $this->config->get('config_language_id') . "' GROUP BY cp.menu_id) AS path_name FROM " . DB_PREFIX . "admin_menu c LEFT JOIN " . DB_PREFIX . "admin_menu_description cd2 ON (c.menu_id = cd2.menu_id) WHERE c.menu_id = '" . (int) $menu_id . "' AND cd2.language_id = '" . (int) $this->config->get('config_language_id') . "'");

        return $query->row;
    }

    public function getMenus($data = array()) {
        $sql = "SELECT cp.menu_id AS menu_id, GROUP_CONCAT(cd1.name ORDER BY cp.level SEPARATOR '&nbsp;&nbsp;&gt;&nbsp;&nbsp;') AS name, c1.parent_id, c1.sort_order FROM " . DB_PREFIX . "admin_menu_path cp LEFT JOIN " . DB_PREFIX . "admin_menu c1 ON (cp.menu_id = c1.menu_id) LEFT JOIN " . DB_PREFIX . "admin_menu c2 ON (cp.path_id = c2.menu_id) LEFT JOIN " . DB_PREFIX . "admin_menu_description cd1 ON (cp.path_id = cd1.menu_id) LEFT JOIN " . DB_PREFIX . "admin_menu_description cd2 ON (cp.menu_id = cd2.menu_id) WHERE cd1.language_id = '" . (int) $this->config->get('config_language_id') . "' AND cd2.language_id = '" . (int) $this->config->get('config_language_id') . "'";

        if (!empty($data['filter_name'])) {
            $sql .= " AND cd2.name LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        }

        $sql .= " GROUP BY cp.menu_id";

        $sort_data = array(
            'name',
            'sort_order'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY sort_order";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getMenuDescriptions($menu_id) {
        $category_description_data = array();

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "admin_menu_description WHERE menu_id = '" . (int) $menu_id . "'");

        foreach ($query->rows as $result) {
            $category_description_data[$result['language_id']] = array(
                'name' => $result['name'],
            );
        }

        return $category_description_data;
    }

    public function getTotalMenu() {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "admin_menu");

        return $query->row['total'];
    }

    public function getTotalCategoriesByLayoutId($layout_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "category_to_layout WHERE layout_id = '" . (int) $layout_id . "'");

        return $query->row['total'];
    }

    public function getAdminMenu($parent_id = 0) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "admin_menu c LEFT JOIN " . DB_PREFIX . "admin_menu_description cd ON (c.menu_id = cd.menu_id)  WHERE c.parent_id = '" . (int) $parent_id . "' AND cd.language_id = '" . (int) $this->config->get('config_language_id') . "'  AND c.status = '1' ORDER BY c.sort_order, LCASE(cd.name)");

        return $query->rows;
    }

}

?>