<?php
class ModelServiceServiceForm extends Model {

	public function getCustomerbyid($customer_id) {
		$sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE 1 AND customer_id = '" . (int)$customer_id . "' ";
		$query = $this->db->query($sql);
		return $query->row;
	}


	public function getServiceForm($serviceform_id) {
		$service_form = array();

		$info_sql = "SELECT sf.invoice_prefix, sf.remark, sf.date_added, sf.date_modified, sf.service_date, sf.order_invoice_prefix, sf.serviceform_action, sf.customer_id, c.customer_ic, c.customer_card, CONCAT(c.firstname, ' ', c.lastname) AS 'name', c.gender, c.dob, c.address_id, c.telephone, c.telephone2, c.home, c.fax FROM " . DB_PREFIX . "service_form sf LEFT JOIN " . DB_PREFIX . "customer c ON c.customer_id = sf.customer_id WHERE sf.service_form_id = '" . (int)$serviceform_id . "'";

		$info_query = $this->db->query($info_sql);
		$info = $info_query->row;

		$default_address = $info['address_id'];

		$address_sql = "SELECT a.address_1, a.address_2, a.address_3, a.city, a.postcode, c.name AS 'country', z.name AS 'state' FROM " . DB_PREFIX . "address a LEFT JOIN " . DB_PREFIX . "country c ON c.country_id = a.country_id LEFT JOIN " . DB_PREFIX . "zone z ON z.zone_id = a.zone_id WHERE a.address_id = '" . (int)$default_address . "'";

		$address_query = $this->db->query($address_sql);
		$address = $address_query->row;

		$service_form['info'] = array(
			'invoice_prefix' 		=> $info['invoice_prefix'],
			'remark' 				=> $info['remark'],
			'date_added'	 		=> $info['date_added'],
			'order_invoice_prefix' 	=> $info['order_invoice_prefix'],
			'serviceform_action' 	=> $info['serviceform_action'],
			'customer_id' 			=> $info['customer_id'],
			'customer_ic' 			=> $info['customer_ic'],
			'customer_card' 		=> $info['customer_card'],
			'name' 					=> $info['name'],
			'gender' 				=> $info['gender'],
			'dob' 					=> $info['dob'],
			'address_1' 			=> ($address) ? $address['address_1'] : '',
			'address_2' 			=> ($address) ? $address['address_2'] : '',
			'address_3' 			=> ($address) ? $address['address_3'] : '',
			'city' 					=> ($address) ? $address['city'] : '',
			'postcode' 				=> ($address) ? $address['postcode'] : '',
			'country' 				=> ($address) ? $address['country'] : '',
			'state' 				=> ($address) ? $address['state'] : '',
			'telephone' 			=> $info['telephone'],
			'telephone2' 			=> $info['telephone2'],
			'home' 					=> $info['home'],
			'fax' 					=> $info['fax']
		);

		$service_form['service_item_array'] = $this->getServiceItemSesionFormat($serviceform_id);

		return $service_form;
	}

	public function totalServiceForm($data) {
		$sort 	= isset($data['sort']) ? $data['sort'] : "name";
		$order 	= isset($data['order']) ? $data['order'] : "ASC";

		$filter_date_statement = '';

		if (!empty($data['filter_start_date']) && !empty($data['filter_end_date'])) {
			$filter_date_statement = " AND sf.`service_date`  BETWEEN '" . $this->db->escape($data['filter_start_date']) . "' AND  '" . $this->db->escape($data['filter_end_date']) . "'";
		} else if (!empty($data['filter_start_date']) && empty($data['filter_end_date'])) {
			$filter_date_statement = " AND sf.`service_date`  >= '" . $this->db->escape($data['filter_start_date']) . "'";
		} else if (empty($data['filter_start_date']) && !empty($data['filter_end_date'])) {
			$filter_date_statement = " AND sf.`service_date`  <= '" . $this->db->escape($data['filter_end_date']) . "'";
		}

		$filter_status_id_statement = !empty($data['filter_status_id']) ? " AND sf.`serviceform_action` IN (" . $this->db->escape($data['filter_status_id']) . ") " : "";

		$filter_payment_status_statement = !empty($data['filter_payment_status']) ? " AND sf.`order_action` IN (" . $this->db->escape($data['filter_payment_status']) . ") " : "";

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
			"AND c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
			"";

		$filter_customer_ic_statement = (!empty($data['filter_customer_ic'])) ?
			"AND c.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" :
			"";

		$filter_customer_name_statement = (!empty($data['filter_name'])) ?
			"AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'" :
			"";

		$filter_doctor_statement = !empty($data['filter_doctor_name']) ? " AND si.`user_id` IN (" . $this->db->escape($data['filter_doctor_name']) . ") " : "";


		if (!empty($data['filter_service_name']) && $data['filter_service_name'] == '*') {
			$filter_service_name = "AND (si.servicename = '' OR si.clinicalservice_id = '')";
		} else {
			if (!empty($data['filter_service_name']) && in_array('*', explode(',', $data['filter_service_name']), true)) {
				$service = substr($data['filter_service_name'], 0, -2);
				$filter_service_name = "AND (si.clinicalservice_id IN (" . $this->db->escape($service) . ") OR (si.servicename = '' OR si.clinicalservice_id = ''))";
			} else {
				$filter_service_name = (!empty($data['filter_service_name'])) ?
					"AND si.clinicalservice_id IN (" . $this->db->escape($data['filter_service_name']) . ")" :
					"";
			}
		}
		$filter_store_id_statement = !empty($data['filter_store_id']) ? " AND sf.`store_id` IN (" . $this->db->escape($data['filter_store_id']) . ") " : "";

		$sql = "
		SELECT COUNT(*) AS total
		FROM(
			SELECT
				sf.service_form_id,
				sf.invoice_prefix,
				sf.remark,
				sf.customer_id,
				CONCAT(c.firstname, ' ', c.lastname) AS name,
				c.customer_ic,
				c.customer_card,
				sf.service_date,
				COUNT(si.service_Item_id) as total_item,
				sf.total_price,
				sf.order_invoice_prefix,
				sf.order_id,
				sf.add_by,
				sf.date_added,
				sf.modifi_by,
				sf.date_modified,
				(
					SELECT name
					FROM " . DB_PREFIX . "order_status
					WHERE order_status_id = sf.serviceform_action
					AND language_id = " . (int)$this->config->get('config_language_id') . "
				) AS 'status',
				(
					SELECT name
					FROM " . DB_PREFIX . "order_status
					WHERE order_status_id = sf.order_action
					AND language_id = " . (int)$this->config->get('config_language_id') . "
				) AS 'payment_status',
				sf.serviceform_action,
				sf.order_action
			FROM
				" . DB_PREFIX . "service_form sf
				LEFT JOIN " . DB_PREFIX . "customer c
				ON sf.customer_id = c.customer_id
				LEFT JOIN " . DB_PREFIX . "service_item si
				ON sf.service_form_id = si.service_form_id
			WHERE 1 AND sf.hide = 0
				
		$filter_date_statement
		$filter_status_id_statement
		$filter_payment_status_statement
		$filter_customer_card_statement
		$filter_customer_ic_statement
		$filter_customer_name_statement
		$filter_doctor_statement
		$filter_service_name
		$filter_store_id_statement
		GROUP BY sf.service_form_id
		)b
		WHERE 1
		";

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function getServiceFormColumn($serviceform_id, $column_name) {

		$columns = array();

		$language_id = (int)$this->config->get('config_language_id');

		//service form info
		$info_sql = "
		SELECT * FROM(
			SELECT

				" . DB_PREFIX . "service_form.invoice_prefix,
				" . DB_PREFIX . "service_form.date_added,
				" . DB_PREFIX . "service_form.customer_id,
				" . DB_PREFIX . "customer.customer_ic,
				" . DB_PREFIX . "customer.customer_card,
				" . DB_PREFIX . "customer.firstname,
				" . DB_PREFIX . "customer.lastname,
				" . DB_PREFIX . "customer.gender,
				" . DB_PREFIX . "customer.dob,
				" . DB_PREFIX . "customer.telephone,
				" . DB_PREFIX . "customer.telephone2,
				" . DB_PREFIX . "customer.home,
				" . DB_PREFIX . "customer.fax,
				" . DB_PREFIX . "customer.address_id,
				" . DB_PREFIX . "service_form.serviceform_action, 
				" . DB_PREFIX . "service_form.remark 
			FROM
				" . DB_PREFIX . "service_form,
				" . DB_PREFIX . "customer
			WHERE " . DB_PREFIX . "service_form.customer_id =  " . DB_PREFIX . "customer.customer_id
			AND " . DB_PREFIX . "service_form.service_form_id = " . $serviceform_id . "
		)a";

		$info_query = $this->db->query($info_sql);
		$info = $info_query->row;

		$default_address = $info['address_id'];

		//if($default_address)
		//address
		$address_sql = "
		SELECT
			" . DB_PREFIX . "address.address_1,
			" . DB_PREFIX . "address.address_2,
			" . DB_PREFIX . "address.address_3,
			" . DB_PREFIX . "address.city,
			" . DB_PREFIX . "address.country_id,
			" . DB_PREFIX . "zone.name AS zone,
			" . DB_PREFIX . "address.postcode
		FROM
			" . DB_PREFIX . "address,
			" . DB_PREFIX . "zone
		WHERE " . DB_PREFIX . "address.zone_id = " . DB_PREFIX . "zone.zone_id
		AND " . DB_PREFIX . "address.address_id = $default_address
		";

		$address_query = $this->db->query($address_sql);
		$address = $address_query->row;


		$columns = array(
			'invoice_prefix' => $info['invoice_prefix'],
			'date_added' => $info['date_added'],
			'customer_id' => $info['customer_id'],
			'customer_ic' => $info['customer_ic'],
			'customer_card' => $info['customer_card'],
			'firstname' => $info['firstname'],
			'lastname' => $info['lastname'],
			'gender' => $info['gender'],
			'dob' => $info['dob'],
			'telephone' => $info['telephone'],
			'telephone2' => $info['telephone2'],
			'home' => $info['home'],
			'fax' => $info['fax'],
			'serviceform_action' => $info['serviceform_action'],
			'remark' => $info['remark'],
			'address_1' => ($address) ? $address['address_1'] : '',
			'address_2' => ($address) ? $address['address_2'] : '',
			'address_3' => ($address) ? $address['address_3'] : '',
			'city' => ($address) ? $address['city'] : '',
			'country_id' => ($address) ? $address['country_id'] : '',
			'zone' => ($address) ? $address['zone'] : '',
			'postcode' => ($address) ? $address['postcode'] : ''
		);

		return $columns[$column_name];
	}

	public function getServiceFormList($data) {

		// $sort 	= isset($data['sort']) ? $data['sort'] : "name";
		// $order 	= isset($data['order']) ? $data['order'] : "ASC";

		$filter_date_statement = '';

		if (!empty($data['filter_start_date']) && !empty($data['filter_end_date'])) {
			$filter_date_statement = " AND sf.`service_date`  BETWEEN '" . $this->db->escape($data['filter_start_date']) . "' AND  '" . $this->db->escape($data['filter_end_date']) . "'";
		} else if (!empty($data['filter_start_date']) && empty($data['filter_end_date'])) {
			$filter_date_statement = " AND sf.`service_date`  >= '" . $this->db->escape($data['filter_start_date']) . "'";
		} else if (empty($data['filter_start_date']) && !empty($data['filter_end_date'])) {
			$filter_date_statement = " AND sf.`service_date`  <= '" . $this->db->escape($data['filter_end_date']) . "'";
		}

		$filter_status_id_statement = !empty($data['filter_status_id']) ? " AND sf.`serviceform_action` IN (" . $this->db->escape($data['filter_status_id']) . ") " : "";

		$filter_payment_status_statement = !empty($data['filter_payment_status']) ? " AND sf.`order_action` IN (" . $this->db->escape($data['filter_payment_status']) . ") " : "";

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
			"AND c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
			"";

		$filter_customer_ic_statement = (!empty($data['filter_customer_ic'])) ?
			"AND c.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" :
			"";

		$filter_customer_name_statement = (!empty($data['filter_name'])) ?
			"AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'" :
			"";

		$filter_doctor_statement = !empty($data['filter_doctor_name']) ? " AND si.`user_id` IN (" . $this->db->escape($data['filter_doctor_name']) . ") " : "";


		if (!empty($data['filter_service_name']) && $data['filter_service_name'] == '*') {
			$filter_service_name = "AND (si.servicename = '' OR si.clinicalservice_id = '')";
		} else {
			if (!empty($data['filter_service_name']) && in_array('*', explode(',', $data['filter_service_name']), true)) {
				$service = substr($data['filter_service_name'], 0, -2);
				$filter_service_name = "AND (si.clinicalservice_id IN (" . $this->db->escape($service) . ") OR (si.servicename = '' OR si.clinicalservice_id = ''))";
			} else {
				$filter_service_name = (!empty($data['filter_service_name'])) ?
					"AND si.clinicalservice_id IN (" . $this->db->escape($data['filter_service_name']) . ")" :
					"";
			}
		}
		$filter_store_id_statement = !empty($data['filter_store_id']) ? " AND sf.`store_id` IN (" . $this->db->escape($data['filter_store_id']) . ") " : "";


		$limit_statement = "";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		// $filter_invoice_prefix = isset($data['filter_invoice_prefix']) ? $data['filter_invoice_prefix'] : false;
		// $filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
		// $filter_customer_ic = isset($data['filter_customer_ic']) ? $data['filter_customer_ic'] : false;
		// $filter_customer_card = isset($data['filter_customer_card']) ? $data['filter_customer_card'] : false;


		// $filter_start_date = isset($data['filter_start_date']) ? $data['filter_start_date'] : false;
		// $filter_start_date_str = trim($filter_start_date);
		// $filter_start_date = (!empty($filter_start_date_str)) ? date("Y-m-d", strtotime($filter_start_date)) : false;

		// $filter_start_date_statement = $filter_start_date ? "AND a.service_date >= '" . $this->db->escape($filter_start_date) . "'" : "";

		// $filter_end_date = isset($data['filter_end_date']) ? $data['filter_end_date'] : false;
		// $filter_end_date_str = trim($filter_end_date);
		// $filter_end_date = (!empty($filter_end_date_str)) ? date("Y-m-d", strtotime($filter_end_date)) : false;

		// $filter_end_date_statement = $filter_end_date ? "AND a.service_date <= '" . $this->db->escape($filter_end_date) . "'" : "";

		// $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;

		// $start 	= isset($data['start']) ? $data['start'] : 0;
		// $limit 	= isset($data['limit']) ? $data['limit'] : 20;

		// $filter_invoice_prefix_statement = $filter_invoice_prefix ? "AND a.invoice_prefix LIKE '%" . $this->db->escape($filter_invoice_prefix) . "%'" : "";
		// $filter_name_statement = $filter_name ? "AND a.name LIKE '%" . $this->db->escape($filter_name) . "%'" : "";
		// $filter_customer_ic_statement = $filter_customer_ic ? "AND a.customer_ic LIKE '%" . $this->db->escape($filter_customer_ic) . "%'" : "";
		// $filter_customer_card_statement = $filter_customer_card ? "AND a.customer_card LIKE '%" . $this->db->escape($filter_customer_card) . "%'" : "";

		// $filter_status_statement = $filter_status ? "AND a.serviceform_action = " . (int)$filter_status : "";

		// // history
		// $customer_id_statement = (!empty($data['customer_id'])) ? "AND a.customer_id = '" . (int)$data['customer_id'] . "'" : '';
		// $history_serviceform_id_statement = (!empty($data['history_serviceform_id'])) ? "AND a.service_form_id < '" . (int)$data['history_serviceform_id'] . "'" : '';

		$sql = "
			SELECT
				sf.service_form_id,
				sf.invoice_prefix,
				sf.remark,
				sf.customer_id,
				CONCAT(c.firstname, ' ', c.lastname) AS name,
				c.customer_ic,
				c.customer_card,
				sf.service_date,
				COUNT(si.service_Item_id) as total_item,
				sf.total_price,
				sf.order_invoice_prefix,
				sf.order_id,
				(SELECT CONCAT(u.firstname,' ',u.lastname) FROM oc_user u WHERE u.user_id = sf.add_by) as add_by,
				sf.date_added,
				(SELECT CONCAT(u.firstname,' ',u.lastname) FROM oc_user u WHERE u.user_id = sf.modifi_by) as modifi_by,
				sf.date_modified,
				(
					SELECT name
					FROM " . DB_PREFIX . "order_status
					WHERE order_status_id = sf.serviceform_action
					AND language_id = " . (int)$this->config->get('config_language_id') . "
				) AS 'status',
				(
					SELECT name
					FROM " . DB_PREFIX . "order_status
					WHERE order_status_id = sf.order_action
					AND language_id = " . (int)$this->config->get('config_language_id') . "
				) AS 'payment_status',
				sf.serviceform_action,
				sf.order_action
			FROM
				" . DB_PREFIX . "service_form sf
				LEFT JOIN " . DB_PREFIX . "customer c
				ON sf.customer_id = c.customer_id
				LEFT JOIN " . DB_PREFIX . "service_item si
				ON sf.service_form_id = si.service_form_id
			WHERE 1 AND sf.hide = 0
				
		$filter_date_statement
		$filter_status_id_statement
		$filter_payment_status_statement
		$filter_customer_card_statement
		$filter_customer_ic_statement
		$filter_customer_name_statement
		$filter_doctor_statement
		$filter_service_name
		$filter_store_id_statement
		GROUP BY sf.service_form_id
		ORDER BY sf.service_form_id DESC
		$limit_statement";

		//tracing sql code

		// echo"<pre>";
		// print_r($sql);
		// echo"</pre>";

		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function addServiceForm($data) {
		$this->load->model('setting/setting');

		// post data
		$serviceno = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'service/service_form', 'store' => $this->session->data['store_id']));
		$customer_id = isset($data['customer_id']) ? $data['customer_id'] : false;
		//$action;
		//$p_action;
		$store_id = isset($data['store_id']) ? $data['store_id'] : false;
		$createby = $this->session->data['user_id'];

		// insert ServiceForm
		$sql = "
		INSERT INTO " . DB_PREFIX . "service_form SET
			invoice_prefix 		= '" . $this->db->escape($serviceno) . "',
			customer_id 		= " . (int)$customer_id . ",
			store_id 			= " . (int)$store_id . ",
			serviceform_action 	= 1,
			order_action 		= 17,
			user_id				= " . (int)$createby . ",
			add_by 				= " . (int)$createby . ",
			service_date		= NOW(),
			date_added 			= NOW()
		";

		$query = $this->db->query($sql);

		// get last insert id
		$lastid =  $this->db->getLastId();

		if ($lastid != 0) {
			$this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'service/service_form', 'store' => $this->session->data['store_id']));
		}

		return $lastid;
	}

	public function editServiceForm($id, $data, $services, $taxes = array()) {

		$survive_service_id = array();

		// post data
		$action		= $data['action'];

		$service_subtotal = 0;
		$service_total = 0;
		$service_gst  = 0;

		foreach ($services as $service_id => $service) {

			$survive_service_id[] = $service_id;

			$starttime_mil 		= $service['starttime'];
			$starttime_seconds 	= $starttime_mil / 1000;
			$starttime_datetime = date("Y-m-d H:i:s", $starttime_seconds);

			$endtime_mil 		= $service['endtime'];
			$endtime_seconds 	= $endtime_mil / 1000;
			$endtime_datetime 	= date("Y-m-d H:i:s", $endtime_seconds);



			if ($this->serviceItemExists($id, $service_id)) {
				$sql = "
				UPDATE " . DB_PREFIX . "service_item SET
				service_form_id = '" . (int) $id . "',
				clinicalservice_id = '" . (int)$service_id . "',
				servicename ='" . $this->db->escape($service['service_name']) . "',
				serviceminutes = '" . $this->db->escape($service['service_minute']) . "',
				user_id = '" . (int)$service['staff_id'] . "',
				start_time				= '" . $starttime_datetime . "',
				end_time				= '" .  $endtime_datetime . "',
				price = '" . (float)$service['price'] . "',
				tax_class_id = '" . (int)$service['tax_class_id'] . "',
				tax_code = '" . $this->db->escape($service['tax_code']) . "',
				tax_format = '" . $this->db->escape($service['tax_format']) . "',
				gst = '" . (float)$service['tax'] . "',
				net_amount = '" . (float)$service['net_amount'] . "',
				total = '" . (float)$service['total'] . "',
				modifi_by = '" . (int)$this->session->data['user_id'] . "',
				date_modified = NOW()
				WHERE service_form_id 	= '$id'
				AND clinicalservice_id 	= $service_id";

				$service_subtotal += $service['net_amount'];
				$service_total += $service['total'];
				$service_gst   += $service['tax'];

				$query = $this->db->query($sql);

				// get the service item
				$item_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_item WHERE service_form_id = '" . (int)$id . "' AND clinicalservice_id = '" . (int)$service_id . "'");
				$item_row = $item_query->row;

				$service_Item_id = $item_row['service_Item_id'];

				$this->db->query("DELETE FROM " . DB_PREFIX . "service_item_acupuncture_point WHERE service_Item_id = '" . (int)$service_Item_id . "'");

				if (!empty($data['acupuncture'][$service_id])) {
					foreach ($data['acupuncture'][$service_id] as $acupuncture_point) {
						$this->db->query("INSERT INTO " . DB_PREFIX . "service_item_acupuncture_point
										  SET service_Item_id = '" . (int)$service_Item_id . "',
										  	  acupuncture_id = '" . (int)$acupuncture_point['acupuncture_point_id'] . "',
											  num_of_acupuncture = '" . (int)$acupuncture_point['num_of_acupuncture'] . "'");
					}
				}
			} else {
				$sql = "
				INSERT INTO " . DB_PREFIX . "service_item SET
				service_form_id = '" . (int) $id . "',
				clinicalservice_id = '" . (int)$service_id . "',
				servicename ='" . $this->db->escape($service['service_name']) . "',
				serviceminutes = '" . $this->db->escape($service['service_minute']) . "',
				user_id = '" . (int)$service['staff_id'] . "',
				start_time				= '" . $starttime_datetime . "',
				end_time				= '" .  $endtime_datetime . "',
				price = '" . (float)$service['price'] . "',
				tax_class_id = '" . (int)$service['tax_class_id'] . "',
				tax_code = '" . $this->db->escape($service['tax_code']) . "',
				tax_format = '" . $this->db->escape($service['tax_format']) . "',
				gst = '" . (float)$service['tax'] . "',
				net_amount = '" . (float)$service['net_amount'] . "',
				total = '" . (float)$service['total'] . "',
				modifi_by = '" . (int)$this->session->data['user_id'] . "',
				date_modified = NOW()";

				$service_subtotal += $service['net_amount'];
				$service_total += $service['total'];
				$service_gst   += $service['tax'];

				$query = $this->db->query($sql);

				$service_item_id = $this->db->getLastId();

				if (!empty($data['acupuncture'][$service_id])) {
					foreach ($data['acupuncture'][$service_id] as $acupuncture_point) {
						$this->db->query("INSERT INTO " . DB_PREFIX . "service_item_acupuncture_point
										  SET service_Item_id = '" . (int)$service_item_id . "',
										  	  acupuncture_id = '" . (int)$acupuncture_point['acupuncture_point_id'] . "',
											  num_of_acupuncture = '" . (int)$acupuncture_point['num_of_acupuncture'] . "'");
					}
				}
			}
		}

		if (!empty($survive_service_id)) {
			$service_item_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_item WHERE service_form_id = $id AND clinicalservice_id NOT IN(" . implode(',', $survive_service_id) . ")");

			$service_item_rows = $service_item_query->rows;

			foreach ($service_item_rows as $row) {
				$service_Item_id = $row['service_Item_id'];

				$this->db->query("DELETE FROM " . DB_PREFIX . "service_item WHERE service_Item_id = '" . (int)$service_Item_id . "'");
				$this->db->query("DELETE FROM " . DB_PREFIX . "service_item_acupuncture_point WHERE service_Item_id = '" . (int)$service_Item_id . "'");
			}
		}

		//general update
		$sql = "
		UPDATE " . DB_PREFIX . "service_form SET
		serviceform_action 	= $action, 
		remark = '" . $this->db->escape($data['remark']) . "', 
		total_price = '" . (float)$service_total . "',
		net_amount = '" . (float)$service_subtotal . "',
		t_gst = '" . (float)$service_gst . "',
		modifi_by 			= '" . $this->session->data['user_id'] . "',
		date_modified 			= NOW()
		WHERE service_form_id 	= '$id'
		";
		$query = $this->db->query($sql);

		// Get the total
		$this->db->query("DELETE FROM " . DB_PREFIX . "service_total WHERE service_form_id = '" . (int) $id . "' AND id ='1' ");

		if (isset($taxes)) {
			foreach ($taxes as $order_total) {
				$this->db->query("
				INSERT INTO " . DB_PREFIX . "service_total
				SET
				service_form_id = '" . (int) $id . "',
				id ='1',
				code = '" . $this->db->escape($order_total['code']) . "',
				tax_code = '" . $this->db->escape($order_total['tax_code']) . "',
				tax_key = '" . (int)$order_total['key'] . "',
				title = '" . $this->db->escape($order_total['title']) . "',
				`value` = '" . (float) $order_total['value'] . "',
				sort_order = '" . (int) $order_total['sort_order'] . "'
				");
			}
		}
	}

	public function serviceItemExists($serviceform_id, $clinicalservice_id) {
		$sql = "
		SELECT COUNT(*) AS num
		FROM " . DB_PREFIX . "service_item
		WHERE service_form_id = $serviceform_id
		AND clinicalservice_id = $clinicalservice_id
		";
		$query = $this->db->query($sql);

		return $query->row["num"] > 0;
	}

	public function getServiceItemSesionFormat($serviceform_id) {
		$items = array();

		$sql = "SELECT * FROM " . DB_PREFIX . "service_item WHERE service_form_id = $serviceform_id";
		$query = $this->db->query($sql);
		$services = $query->rows;

		foreach ($services as $service) {
			$items[$service['clinicalservice_id']] = array(
				'service_id' => $service['clinicalservice_id'],
				'staff_id' => $service['user_id'],
				'price' => $service['price'],
				'starttime' => strtotime($service['start_time']) * 1000,
				'endtime' => strtotime($service['end_time']) * 1000,
				'service_item_id' => $service['service_Item_id']
			);
		}

		return $items;
	}

	public function deleteServiceForm($serviceform_id) {
		$sql = "
		UPDATE " . DB_PREFIX . "service_form
		SET
			serviceform_action = 7,
			order_action = 7,
			hide = 1,
			modifi_by 			= '" . $this->session->data['user_id'] . "',
			date_modified 			= NOW()
		WHERE service_form_id = $serviceform_id";

		$query = $this->db->query($sql);
	}

	public function serviceFormStatusList() {
		$options_id = array(1, 5, 7);
		$options_statement = implode(',', $options_id);

		$sql = "SELECT order_status_id, name
		FROM " . DB_PREFIX . "order_status
		WHERE order_status_id IN (" . $options_statement . ")
		AND language_id = " . (int)$this->config->get('config_language_id');

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function validServiceFormId($serviceform_id) {
		$sql = "SELECT COUNT(*) as num FROM " . DB_PREFIX . "service_form WHERE service_form_id = $serviceform_id";
		$query = $this->db->query($sql);
		$result = $query->row;

		return $result['num'] > 0 ? true : false;
	}

	public function getServiceTotals($serviceform_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_total WHERE service_form_id = '" . (int)$serviceform_id . "' ORDER BY sort_order");

		return $query->rows;
	}

	public function updateCustomer($serviceform_id, $customer_id) {
		$sql = "UPDATE " . DB_PREFIX . "service_form
				SET customer_id = '" . (int)$customer_id . "'
				WHERE service_form_id = '" . (int)$serviceform_id . "'";

		$query = $this->db->query($sql);
	}

	public function getAcupuncturePointByServiceItemId($service_item_id) {
		$sql = "SELECT an.name AS acupuncture_point,
					   siap.acupuncture_id,
					   siap.num_of_acupuncture
				FROM " . DB_PREFIX . "service_item_acupuncture_point siap
				LEFT JOIN " . DB_PREFIX . "acupuncture_name an
				ON an.acupuncture_id = siap.acupuncture_id
				AND an.language_id = '" . $this->config->get('config_language_id') . "'
				WHERE siap.service_Item_id = '" . (int)$service_item_id . "'";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getServiceItems($serviceform_id) {
		$sql = "SELECT * FROM " . DB_PREFIX . "service_item WHERE service_form_id = '" . (int)$serviceform_id . "'";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getAcupunctures() {
		$sql = "SELECT a.acupuncture_id, an.name, a.image 
				FROM " . DB_PREFIX . "acupuncture a
				LEFT JOIN " . DB_PREFIX . "acupuncture_name an
				ON an.acupuncture_id = a.acupuncture_id
				AND an.language_id = '" . $this->config->get('config_language_id') . "'
				WHERE a.parent_id = 0";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getBodyParts() {
		$sql = "SELECT ap.acupuncture_part_id, apd.name
				FROM " . DB_PREFIX . "acupuncture_part ap
				LEFT JOIN " . DB_PREFIX . "acupuncture_part_description apd
				ON apd.acupuncture_part_id = ap.acupuncture_part_id
				AND apd.language_id = '" . $this->config->get('config_language_id') . "'";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getAcupunctureJson($acupuncture_id) {
		$sql = "SELECT * FROM " . DB_PREFIX . "acupuncture a LEFT JOIN " . DB_PREFIX . "acupuncture_name an ON an.acupuncture_id = a.acupuncture_id AND an.language_id = '" . (int)$this->config->get('config_language_id') . "' WHERE a.acupuncture_id = '" . (int)$acupuncture_id . "'";

		$query = $this->db->query($sql);

		return $query->row;
	}

	public function getServiceItem($service_form_id, $clinicalservice_id) {
		$sql = "SELECT *
				FROM " . DB_PREFIX . "service_item
				WHERE service_form_id = '" . (int)$service_form_id . "'
				AND clinicalservice_id = '" . (int)$clinicalservice_id . "'";

		$query = $this->db->query($sql);

		return $query->row;
	}

	public function getAcupuncturePoints($data) {
		$sort 	= isset($data['sort']) ? $data['sort'] : "a.acupuncture_id";
		$order 	= isset($data['order']) ? $data['order'] : "ASC";

		$limit_statement = "";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$filter_acupuncture_statement = !empty($data['filter_acupuncture']) ? "AND a.parent_id = '" . (int)$data['filter_acupuncture'] . "'" : "";

		$filter_acupuncture_point_statement = !empty($data['filter_acupuncture_point']) ? "AND an.name LIKE '%" . $this->db->escape($data['filter_acupuncture_point']) . "%'" : "";

		$filter_acupuncture_point_code_statement = !empty($data['filter_acupuncture_point_code']) ? "AND a.code LIKE '%" . $this->db->escape($data['filter_acupuncture_point_code']) . "%'" : "";

		if (isset($data['clinicalservice_id'])) {
			$sql = "SELECT acupuncture_parts FROM " . DB_PREFIX . "clinical_service WHERE clinicalservice_id = '" . $data['clinicalservice_id'] . "'";
			$query = $this->db->query($sql);
			$service_row = $query->row;

			$acupuncture_parts = unserialize($service_row['acupuncture_parts']);

			$acupuncture_id_arr = array();

			if (!empty($acupuncture_parts)) {
				// find acupuncture points for each acupuncture body part
				foreach ($acupuncture_parts as $acupuncture_part_id) {
					$acupuncture_point_sql = "SELECT a.acupuncture_id, a.acupuncture_parts
											  FROM " . DB_PREFIX . "acupuncture a
											  LEFT JOIN " . DB_PREFIX . "acupuncture_name an
											  ON an.acupuncture_id = a.acupuncture_id
											  AND an.language_id = '" . $this->config->get('config_language_id') . "'
											  WHERE a.parent_id > 0";

					$acupuncture_point_query = $this->db->query($acupuncture_point_sql);
					$acupuncture_points = $acupuncture_point_query->rows;

					foreach ($acupuncture_points as $point) {
						$acupuncture_point_parts = unserialize($point['acupuncture_parts']);

						if (in_array($acupuncture_part_id, $acupuncture_point_parts)) {
							$acupuncture_id_arr[] = $point['acupuncture_id'];
						}
					}
				}

				// make the acupuncture points be unique and set into a string
				$new_acupuncture_id_arr = array_values(array_unique($acupuncture_id_arr));
				$acupuncture_id_str = implode(',', $new_acupuncture_id_arr);

				$acupuncture_result = array();

				// output the acupuncture points
				$acupuncture_query = $this->db->query("SELECT *
									FROM " . DB_PREFIX . "acupuncture a
									LEFT JOIN " . DB_PREFIX . "acupuncture_name an
									ON an.acupuncture_id = a.acupuncture_id
									AND an.language_id = '" . $this->config->get('config_language_id') . "'
									WHERE a.acupuncture_id IN (" . $acupuncture_id_str . ")
									$filter_acupuncture_statement
									$filter_acupuncture_point_statement
									$filter_acupuncture_point_code_statement
									ORDER BY $sort $order
									$limit_statement");

				$acupuncture_rows = $acupuncture_query->rows;

				foreach ($acupuncture_rows as $row) {
					$parent_query = $this->db->query("SELECT name FROM " . DB_PREFIX . "acupuncture_name WHERE language_id = '" . $this->config->get('config_language_id') . "' AND acupuncture_id = '" . $row['parent_id'] . "'");

					$parent_name = $parent_query->row['name'];

					$acupuncture_result[] = array(
						'acupuncture_id'		=> $row['acupuncture_id'],
						'name'					=> $row['name'],
						'code'					=> $row['code'],
						'jingluo'				=> $parent_name,
						'location'				=> $row['location'],
						'ways'					=> $row['ways'],
						'symptoms'				=> $row['symptoms']
					);
				}
			} else {
				// no set body parts for the service, show all the acupuncture points
				$acupuncture_query = $this->db->query("SELECT *
										FROM " . DB_PREFIX . "acupuncture a
										LEFT JOIN " . DB_PREFIX . "acupuncture_name an
										ON an.acupuncture_id = a.acupuncture_id
										AND an.language_id = '" . $this->config->get('config_language_id') . "'
										WHERE a.parent_id > 0
										$filter_acupuncture_statement
										$filter_acupuncture_point_statement
										$filter_acupuncture_point_code_statement
										ORDER BY $sort $order
										$limit_statement");

				$acupuncture_rows = $acupuncture_query->rows;

				foreach ($acupuncture_rows as $row) {
					$parent_query = $this->db->query("SELECT name FROM " . DB_PREFIX . "acupuncture_name WHERE language_id = '" . $this->config->get('config_language_id') . "' AND acupuncture_id = '" . $row['parent_id'] . "'");

					$parent_name = $parent_query->row['name'];

					$acupuncture_result[] = array(
						'acupuncture_id'		=> $row['acupuncture_id'],
						'name'					=> $row['name'],
						'code'					=> $row['code'],
						'jingluo'				=> $parent_name,
						'location'				=> $row['location'],
						'ways'					=> $row['ways'],
						'symptoms'				=> $row['symptoms']
					);
				}
			}
		}

		return $acupuncture_result;
	}

	public function getTotalAcupuncturePoints($data) {
		$filter_acupuncture_statement = !empty($data['filter_acupuncture']) ? "AND a.parent_id = '" . (int)$data['filter_acupuncture'] . "'" : "";

		$filter_acupuncture_point_statement = !empty($data['filter_acupuncture_point']) ? "AND an.name LIKE '%" . $this->db->escape($data['filter_acupuncture_point']) . "%'" : "";

		$filter_acupuncture_point_code_statement = !empty($data['filter_acupuncture_point_code']) ? "AND a.code LIKE '%" . $this->db->escape($data['filter_acupuncture_point_code']) . "%'" : "";

		if (isset($data['clinicalservice_id'])) {
			$sql = "SELECT acupuncture_parts FROM " . DB_PREFIX . "clinical_service WHERE clinicalservice_id = '" . $data['clinicalservice_id'] . "'";
			$query = $this->db->query($sql);
			$service_row = $query->row;

			$acupuncture_parts = unserialize($service_row['acupuncture_parts']);

			$acupuncture_id_arr = array();

			if (!empty($acupuncture_parts)) {
				// find acupuncture points for each acupuncture body part
				foreach ($acupuncture_parts as $acupuncture_part_id) {
					$acupuncture_point_sql = "SELECT a.acupuncture_id, a.acupuncture_parts
											  FROM " . DB_PREFIX . "acupuncture a
											  LEFT JOIN " . DB_PREFIX . "acupuncture_name an
											  ON an.acupuncture_id = a.acupuncture_id
											  AND an.language_id = '" . $this->config->get('config_language_id') . "'
											  WHERE a.parent_id > 0";

					$acupuncture_point_query = $this->db->query($acupuncture_point_sql);
					$acupuncture_points = $acupuncture_point_query->rows;

					foreach ($acupuncture_points as $point) {
						$acupuncture_point_parts = unserialize($point['acupuncture_parts']);

						if (in_array($acupuncture_part_id, $acupuncture_point_parts)) {
							$acupuncture_id_arr[] = $point['acupuncture_id'];
						}
					}
				}

				// make the acupuncture points be unique and set into a string
				$new_acupuncture_id_arr = array_values(array_unique($acupuncture_id_arr));
				$acupuncture_id_str = implode(',', $new_acupuncture_id_arr);

				$acupuncture_result = array();

				// output the total acupuncture points
				$acupuncture_query = $this->db->query("SELECT COUNT(*) AS total
									FROM " . DB_PREFIX . "acupuncture a
									LEFT JOIN " . DB_PREFIX . "acupuncture_name an
									ON an.acupuncture_id = a.acupuncture_id
									AND an.language_id = '" . $this->config->get('config_language_id') . "'
									WHERE a.acupuncture_id IN (" . $acupuncture_id_str . ")
									$filter_acupuncture_statement
									$filter_acupuncture_point_statement
									$filter_acupuncture_point_code_statement");

				$acupuncture_total = $acupuncture_query->row['total'];
			} else {
				// no set body parts for the service, show all the acupuncture points
				$acupuncture_query = $this->db->query("SELECT COUNT(*) AS total
										FROM " . DB_PREFIX . "acupuncture a
										LEFT JOIN " . DB_PREFIX . "acupuncture_name an
										ON an.acupuncture_id = a.acupuncture_id
										AND an.language_id = '" . $this->config->get('config_language_id') . "'
										WHERE a.parent_id > 0
										$filter_acupuncture_statement
										$filter_acupuncture_point_statement
										$filter_acupuncture_point_code_statement");

				$acupuncture_total = $acupuncture_query->row['total'];
			}
		}

		return $acupuncture_total;
	}

	public function getAcupuncturePointsByMeridian($data) {
		$acupuncture_result = array();

		$sort 	= isset($data['sort']) ? $data['sort'] : "a.acupuncture_id";
		$order 	= isset($data['order']) ? $data['order'] : "ASC";

		$limit_statement = "";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$filter_acupuncture_statement = !empty($data['filter_acupuncture']) ? "AND a.parent_id = '" . (int)$data['filter_acupuncture'] . "'" : "";

		$filter_acupuncture_point_statement = !empty($data['filter_acupuncture_point']) ? "AND an.name LIKE '%" . $this->db->escape($data['filter_acupuncture_point']) . "%'" : "";

		$filter_acupuncture_point_code_statement = !empty($data['filter_acupuncture_point_code']) ? "AND a.code LIKE '%" . $this->db->escape($data['filter_acupuncture_point_code']) . "%'" : "";

		if (!empty($data['filter_body_part'])) {
			$ac_point_arr = array();

			// select all acupuncture points
			$ac_point_query = $this->db->query("SELECT *
												FROM " . DB_PREFIX . "acupuncture
												WHERE parent_id > 0");

			$ac_point_rows = $ac_point_query->rows;

			// loop the acupuncture points and find out all the acupuncture point of the body part
			foreach ($ac_point_rows as $row) {
				$ac_point_acupuncture_parts = unserialize($row['acupuncture_parts']);

				if (in_array($data['filter_body_part'], $ac_point_acupuncture_parts)) {
					$ac_point_arr[] = $row['acupuncture_id'];
				}
			}

			$ac_point_str = implode(',', $ac_point_arr);

			$acupuncture_query = $this->db->query("SELECT *
									FROM " . DB_PREFIX . "acupuncture a
									LEFT JOIN " . DB_PREFIX . "acupuncture_name an
									ON an.acupuncture_id = a.acupuncture_id
									AND an.language_id = '" . $this->config->get('config_language_id') . "' WHERE a.parent_id > 0
									AND a.acupuncture_id IN(" . $ac_point_str . ")
									$filter_acupuncture_statement
									$filter_acupuncture_point_statement
									$filter_acupuncture_point_code_statement
									ORDER BY $sort $order
									$limit_statement");

			$acupuncture_rows = $acupuncture_query->rows;

			foreach ($acupuncture_rows as $row) {
				$parent_query = $this->db->query("SELECT name FROM " . DB_PREFIX . "acupuncture_name WHERE language_id = '" . $this->config->get('config_language_id') . "' AND acupuncture_id = '" . $row['parent_id'] . "'");

				$parent_name = $parent_query->row['name'];

				$acupuncture_result[] = array(
					'acupuncture_id'		=> $row['acupuncture_id'],
					'name'					=> $row['name'],
					'code'					=> $row['code'],
					'jingluo'				=> $parent_name,
					'location'				=> $row['location'],
					'ways'					=> $row['ways'],
					'symptoms'				=> $row['symptoms']
				);
			}
		} else {
			$acupuncture_query = $this->db->query("SELECT *
									FROM " . DB_PREFIX . "acupuncture a
									LEFT JOIN " . DB_PREFIX . "acupuncture_name an
									ON an.acupuncture_id = a.acupuncture_id
									AND an.language_id = '" . $this->config->get('config_language_id') . "'
									WHERE a.parent_id > 0
									$filter_acupuncture_statement
									$filter_acupuncture_point_statement
									$filter_acupuncture_point_code_statement
									ORDER BY $sort $order
									$limit_statement");

			$acupuncture_rows = $acupuncture_query->rows;

			foreach ($acupuncture_rows as $row) {
				$parent_query = $this->db->query("SELECT name FROM " . DB_PREFIX . "acupuncture_name WHERE language_id = '" . $this->config->get('config_language_id') . "' AND acupuncture_id = '" . $row['parent_id'] . "'");

				$parent_name = $parent_query->row['name'];

				$acupuncture_result[] = array(
					'acupuncture_id'		=> $row['acupuncture_id'],
					'name'					=> $row['name'],
					'code'					=> $row['code'],
					'jingluo'				=> $parent_name,
					'location'				=> $row['location'],
					'ways'					=> $row['ways'],
					'symptoms'				=> $row['symptoms']
				);
			}
		}

		return $acupuncture_result;
	}

	public function getTotalAcupuncturePointsByMeridian($data) {
		$filter_acupuncture_statement = !empty($data['filter_acupuncture']) ? "AND a.parent_id = '" . (int)$data['filter_acupuncture'] . "'" : "";

		$filter_acupuncture_point_statement = !empty($data['filter_acupuncture_point']) ? "AND an.name LIKE '%" . $this->db->escape($data['filter_acupuncture_point']) . "%'" : "";

		$filter_acupuncture_point_code_statement = !empty($data['filter_acupuncture_point_code']) ? "AND a.code LIKE '%" . $this->db->escape($data['filter_acupuncture_point_code']) . "%'" : "";

		if (!empty($data['filter_body_part'])) {
			$ac_point_arr = array();

			// select all acupuncture points
			$ac_point_query = $this->db->query("SELECT *
												FROM " . DB_PREFIX . "acupuncture
												WHERE parent_id > 0");

			$ac_point_rows = $ac_point_query->rows;

			// loop the acupuncture points and find out all the acupuncture point of the body part
			foreach ($ac_point_rows as $row) {
				$ac_point_acupuncture_parts = unserialize($row['acupuncture_parts']);

				if (in_array($data['filter_body_part'], $ac_point_acupuncture_parts)) {
					$ac_point_arr[] = $row['acupuncture_id'];
				}
			}

			$ac_point_str = implode(',', $ac_point_arr);

			$acupuncture_query = $this->db->query("SELECT COUNT(*) AS total
									FROM " . DB_PREFIX . "acupuncture a
									LEFT JOIN " . DB_PREFIX . "acupuncture_name an
									ON an.acupuncture_id = a.acupuncture_id
									AND an.language_id = '" . $this->config->get('config_language_id') . "' WHERE a.parent_id > 0
									AND a.acupuncture_id IN(" . $ac_point_str . ")
									$filter_acupuncture_statement
									$filter_acupuncture_point_statement
									$filter_acupuncture_point_code_statement");

			$acupuncture_total = $acupuncture_query->row['total'];
		} else {
			$acupuncture_query = $this->db->query("SELECT COUNT(*) AS total
									FROM " . DB_PREFIX . "acupuncture a
									LEFT JOIN " . DB_PREFIX . "acupuncture_name an
									ON an.acupuncture_id = a.acupuncture_id
									AND an.language_id = '" . $this->config->get('config_language_id') . "'
									WHERE a.parent_id > 0
									$filter_acupuncture_statement
									$filter_acupuncture_point_statement
									$filter_acupuncture_point_code_statement");

			$acupuncture_total = $acupuncture_query->row['total'];
		}

		return $acupuncture_total;
	}

	public function getAcupuncturePointsDiagram($filter_acupuncture) {
		$sql = "SELECT * FROM " . DB_PREFIX . "acupuncture a LEFT JOIN " . DB_PREFIX . "acupuncture_name an ON an.acupuncture_id = a.acupuncture_id AND an.language_id = '" . (int)$this->config->get('config_language_id') . "' WHERE a.parent_id = '" . (int)$filter_acupuncture . "'";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getAutoCompleteAcupunctures($data) {
		$sql = "SELECT a.acupuncture_id, an.name
				FROM " . DB_PREFIX . "acupuncture a
				LEFT JOIN " . DB_PREFIX . "acupuncture_name an
				ON an.acupuncture_id = a.acupuncture_id
				AND an.language_id = '" . $this->config->get('config_language_id') . "'
				WHERE a.parent_id > 0";

		if (!empty($data['filter_acupuncture'])) {
			$sql .= " AND an.name LIKE '%" . $this->db->escape($data['filter_acupuncture']) . "%'";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getAutocompleteFormCustomers($data) {
		$sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE status = '1' AND approved = '1'";

		if (!empty($data['filter_firstname'])) {
			$sql .= " AND firstname LIKE '%" . $this->db->escape($data['filter_firstname']) . "%'";
		}

		if (!empty($data['filter_lastname'])) {
			$sql .= " AND lastname LIKE '%" . $this->db->escape($data['filter_lastname']) . "%'";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalCustomers($data = array()) {
		$sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer WHERE customer_group_id = '1' AND status = '1'";

		if (!empty($data['customer_name'])) {
			$sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['customer_name']) . "%'";
		}

		if (!empty($data['customer_ic'])) {
			$sql .= " AND customer_ic LIKE '%" . $this->db->escape($data['customer_ic']) . "%'";
		}

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function getCustomers($data = array()) {
		$sql = "SELECT customer_id,
					   CONCAT(firstname, ' ', lastname) AS customer_name,
					   customer_ic,
					   customer_card
				FROM " . DB_PREFIX . "customer
				WHERE status = '1'";

		if (!empty($data['customer_name'])) {
			$sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['customer_name']) . "%'";
		}

		if (!empty($data['customer_ic'])) {
			$sql .= " AND customer_ic LIKE '%" . $this->db->escape($data['customer_ic']) . "%'";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		// echo"<pre>";
		// print_r($sql);
		// echo"</pre>";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	//update on 9/6/2022 -transfer customer model to service form because of doctor access cannot access customer module//
	public function customerExistsByIc($ic) {
		$sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE customer_ic = '$ic'";
		$query = $this->db->query($sql);
		return $query->row;
	}

	public function addCustomer($data) {
		do {
			$insert_customer = false;
			$unique_id = md5(rand() . $data['customer_ic'] . time());
			$customer_row = $this->check_unique_id($unique_id);

			if (empty($customer_row)) {
				$insert_customer = true;
				$this->db->query("
					INSERT INTO " . DB_PREFIX . "customer SET
						unique_customer_id = '" . $this->db->escape($unique_id) . "',
						customer_group_id = '" . (int) $data['customer_group_id'] . "',
						firstname = '" . $this->db->escape($data['firstname']) . "',
						lastname = '" . $this->db->escape($data['lastname']) . "',
						gender = '" . $this->db->escape($data['gender']) . "',
						customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
						customer_card = '" . $this->db->escape(isset($data['customer_card']) ? $data['customer_card'] : '') . "',
						dob = '" . $this->db->escape($data['dob']) . "',
                        age = '" . $this->db->escape($data['age']) . "',
                        nationality = '" . $this->db->escape($data['nationality']) . "',
                        marital_status = '" . (int) $data['marital_status'] . "',
                        religion = '" . $this->db->escape($data['religion']) . "',
                        race = '" . $this->db->escape($data['race']) . "',
                        allergic = '" . $this->db->escape($data['allergic']) . "',
                        diagnostic_history = '" . $this->db->escape($data['diagnostic_history']) . "',
                        occupation = '" . $this->db->escape($data['occupation']) . "',
						email = '" . $this->db->escape($data['email']) . "',
						telephone = '" . $this->db->escape($data['telephone']) . "',
						telephone2 = '" . $this->db->escape($data['telephone2']) . "',
						home = '" . $this->db->escape($data['home']) . "',
						fax = '" . $this->db->escape($data['fax']) . "',
						custom_field = '" . $this->db->escape(isset($data['custom_field']) ? serialize($data['custom_field']) : '') . "',
						newsletter = '" . (int) $data['newsletter'] . "',
						salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "',
						password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($data['password'])))) . "',
						status = '" . (int) $data['status'] . "',
						approved = '" . (int) $data['approved'] . "',
						safe = '" . (int) $data['safe'] . "',
						date_added = NOW(),
                        date_modified = NOW()
				");
			}
		} while ($insert_customer == false);

		$customer_id = $this->db->getLastId();

		if (isset($data['address'])) {
			foreach ($data['address'] as $address) {
				$this->db->query("
				INSERT INTO " . DB_PREFIX . "address SET
				customer_id = '" . (int) $customer_id . "',
				firstname = '" . $this->db->escape($address['firstname']) . "',
				lastname = '" . $this->db->escape($address['lastname']) . "',
				company = '" . $this->db->escape($address['company']) . "',
				address_1 = '" . $this->db->escape($address['address_1']) . "',
				address_2 = '" . $this->db->escape($address['address_2']) . "',
				address_3 = '" . $this->db->escape($address['address_3']) . "',
				city = '" . $this->db->escape($address['city']) . "',
				postcode = '" . $this->db->escape($address['postcode']) . "',
				country_id = '" . (int) $address['country_id'] . "',
				zone_id = '" . (int) $address['zone_id'] . "',
				custom_field = '" . $this->db->escape(isset($address['custom_field']) ? serialize($address['custom_field']) : '') . "'");

				if (isset($address['default'])) {
					$address_id = $this->db->getLastId();

					$this->db->query("UPDATE " . DB_PREFIX . "customer SET address_id = '" . (int) $address_id . "' WHERE customer_id = '" . (int) $customer_id . "'");
				}
			}
		}

		if ($data['affiliate']) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "customer_affiliate SET customer_id = '" . (int) $customer_id . "', company = '" . $this->db->escape($data['company']) . "', website = '" . $this->db->escape($data['website']) . "', tracking = '" . $this->db->escape($data['tracking']) . "', commission = '" . (float) $data['commission'] . "', tax = '" . $this->db->escape($data['tax']) . "', payment = '" . $this->db->escape($data['payment']) . "', cheque = '" . $this->db->escape($data['cheque']) . "', paypal = '" . $this->db->escape($data['paypal']) . "', bank_name = '" . $this->db->escape($data['bank_name']) . "', bank_branch_number = '" . $this->db->escape($data['bank_branch_number']) . "', bank_swift_code = '" . $this->db->escape($data['bank_swift_code']) . "', bank_account_name = '" . $this->db->escape($data['bank_account_name']) . "', bank_account_number = '" . $this->db->escape($data['bank_account_number']) . "', custom_field = '" . $this->db->escape(isset($data['custom_field']) ? json_encode($data['custom_field']) : json_encode(array())) . "', status = '" . (int) $data['affiliate'] . "', date_added = NOW()");
		}

		return $customer_id;
	}

	public function getCustomer($customer_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int) $customer_id . "'");

		return $query->row;
	}

	public function selectCustomers($data = array()) {
		$sql = "SELECT * from " . DB_PREFIX . "customer c WHERE c.status = '1' AND c.approved = '1'";

		//print_r($sql);

		if (isset($data['customer_ic']) && !is_null($data['customer_ic'])) {
			$sql .= " AND c.customer_ic = '" . $this->db->escape($data['customer_ic']) . "'";
		}

		if (isset($data['customer_card']) && !is_null($data['customer_card'])) {
			$sql .= " AND c.customer_card = '" . $this->db->escape($data['customer_card']) . "'";
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getCustomerByEmail($email) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "customer WHERE LCASE(email) = '" . $this->db->escape(utf8_strtolower($email)) . "'");

		return $query->row;
	}

	public function check_unique_id($unique_id) {
		$sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE unique_customer_id = '" . $this->db->escape($unique_id) . "'";

		$query = $this->db->query($sql);

		return $query->row;
	}

	public function getServiceStatuses() {
		$sql = "SELECT DISTINCT os.order_status_id , os.name  FROM oc_service_form sf LEFT JOIN oc_order_status os ON sf.serviceform_action = os.order_status_id AND language_id = '" . (int)$this->config->get('config_language_id') . "' WHERE 1 ORDER BY os.name ASC";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getPaymentStatuses() {
		$sql = "SELECT DISTINCT os.order_status_id , os.name  FROM oc_service_form sf LEFT JOIN oc_order_status os ON sf.order_action = os.order_status_id AND language_id = '" . (int)$this->config->get('config_language_id') . "' WHERE 1 ORDER BY os.name ASC";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getdoctorlist() {
		$sql = "SELECT DISTINCT u.user_id AS doctor_id, CONCAT(u.firstname,' ',u.lastname,' ',u.chinesename) AS doctor_name FROM oc_service_item si INNER JOIN " . DB_PREFIX . "user u ON si.user_id = u.user_id WHERE 1 ORDER BY doctor_name ASC 
		";
		$query = $this->db->query($sql);

		return $query->rows;
	}
	public function getservicename() {
		$sql = "SELECT DISTINCT si.clinicalservice_id AS item_id, si.name AS item_name FROM  oc_clinical_service_description si WHERE 1 AND si.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY si.name ASC ";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getCustomersAutocomplete($data) {
		$sql = "SELECT 

				c.customer_id,
				CONCAT(c.firstname,' ',c.lastname) as customer_name,
				c.customer_ic,
				c.telephone
				FROM oc_customer c
				WHERE 1";

		if (!empty($data['filter_name'])) {
			$sql .= " AND CONCAT(c.firstname,' ',c.lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function addNewServiceForm($customer_id) {
		$this->load->model('setting/setting');

		// post data
		$serviceno = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'service/service_form', 'store' => $this->session->data['store_id']));
		//$action;
		//$p_action;
		$store_id = $this->session->data['store_id'];
		$createby = $this->session->data['user_id'];

		// insert ServiceForm
		$sql = "
		INSERT INTO " . DB_PREFIX . "service_form SET
			invoice_prefix 		= '" . $this->db->escape($serviceno) . "',
			customer_id 		= " . (int)$customer_id . ",
			store_id 			= " . (int)$store_id . ",
			serviceform_action 	= 1,
			order_action 		= 17,
			user_id				= " . (int)$createby . ",
			add_by 				= " . (int)$createby . ",
			service_date		= NOW(),
			date_added 			= NOW()
		";

		$query = $this->db->query($sql);

		// get last insert id
		$lastid =  $this->db->getLastId();

		if ($lastid != 0) {
			$this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'service/service_form', 'store' => $this->session->data['store_id']));
		}

		return $lastid;
	}
}
