<?php

class ModelServiceClinicalService extends Model {

    public function get_clinical_services($data) {
        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_service cs LEFT JOIN " . DB_PREFIX . "clinical_service_description csd ON csd.clinicalservice_id = cs.clinicalservice_id AND csd.language_id = '" . (int) $this->config->get('config_language_id') . "' WHERE 1";

        if (!empty($data['filter_name'])) {
            $sql .= " AND csd.name LIKE '%" . $data['filter_name'] . "%'";
        }

        $sort_data = array(
            'name',
            'cs_minute',
            'price',
            'type'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY csd.name";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function total_clinical_services($data) {
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "clinical_service cs LEFT JOIN " . DB_PREFIX . "clinical_service_description csd ON csd.clinicalservice_id = cs.clinicalservice_id AND csd.language_id = '" . (int) $this->config->get('config_language_id') . "' WHERE 1";

        if (!empty($data['filter_name'])) {
            $sql .= " AND csd.name LIKE '%" . $data['filter_name'] . "%'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function get_clinical_service($clinicalservice_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_service cs LEFT JOIN " . DB_PREFIX . "clinical_service_description csd ON csd.clinicalservice_id = cs.clinicalservice_id AND csd.language_id = '" . (int) $this->config->get('config_language_id') . "' WHERE cs.clinicalservice_id = '" . $clinicalservice_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function get_clinical_service_facilities($clinicalservice_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "service_to_facility WHERE service_id = '" . (int)$clinicalservice_id . "'";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function get_clinical_service_descriptions($clinicalservice_id)
    {
        $return_desc = [];

        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_service_description WHERE clinicalservice_id = '" . $clinicalservice_id . "'";

        $query = $this->db->query($sql);

        $clinical_service_description = $query->rows;

        if (!empty($clinical_service_description)) {
            foreach ($clinical_service_description as $desc) {
                $return_desc[$desc['language_id']] = $desc;
            }
        }

        return $return_desc;
    }

    public function get_clinical_services_report() {
        $sql = "
		SELECT *
		FROM " . DB_PREFIX . "clinical_service cs 
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd 
		ON cs.clinicalservice_id = csd.clinicalservice_id
		AND csd.language_id = '" . $this->config->get('config_language_id') . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function addClinicalService($data) {
        $descriptions = $data['clinical_service_description'];

        $store_id = isset($data['store_id']) ? $data['store_id'] : array();
        $doctor_id = isset($data['doctor_id']) ? $data['doctor_id'] : array();
        $acupuncture_parts = isset($data['acupuncture_part_id']) ? $data['acupuncture_part_id'] : array();
        $facility = isset($data['facility_id']) ? $data['facility_id'] : array();
        $type = $data['type'];
        $staff_id = ($type == 1) ? $data['staff_id'] : 0;
        $doctor = isset($data['doctor']) ? $data['doctor'] : 0;
        $doctor = ($type == 2) ? $doctor : 0;
        $cs_minute = $data['cs_minute'];
        $status = isset($data['status']) ? $data['status'] : array();
        $enable_appointment = isset($data['appointment']) ? $data['appointment'] : array();
        $enable_etcm = isset($data['etcm']) ? $data['etcm'] : array();
        $cs_session = $data['cs_session'];
        $price = $data['price'];
        $tax_class_id = $data['tax_class_id'];

        $sql = "
		INSERT INTO " . DB_PREFIX . "clinical_service SET
			store_id	 = '" . $this->db->escape(serialize($store_id)) . "',
			doctor_id	 = '" . $this->db->escape(serialize($doctor_id)) . "',
			acupuncture_parts = '" . $this->db->escape(serialize($acupuncture_parts)) . "',
			type		 = $type,
			staff_id	 = $staff_id,
			doctor		 = $doctor,
			cs_minute	 = '$cs_minute',
            status       = $status,
            enable_appointment = $enable_appointment,
            enable_etcm  = $enable_etcm,
			cs_session	 = '$cs_session',
			price		 = '$price',
			tax_class_id = $tax_class_id,
			createby	 = '" . $this->session->data['user_id'] . "',
			createdate	 = NOW()
		";
        $query = $this->db->query($sql);

        $lastid = $this->db->getLastId();

        foreach ($descriptions as $language_id => $clinical_service_description) {
            $name = $clinical_service_description['name'];

            $sql = "
			INSERT INTO " . DB_PREFIX . "clinical_service_description SET
				clinicalservice_id = '$lastid',
				language_id = '$language_id',
				name = '$name'
			";

            $query = $this->db->query($sql);
        }

        foreach($data['store_id'] as $storeid){
            $this->db->query("INSERT INTO oc_service_to_store SET
            service_id = '".(int)$lastid."',
            store_id = '" . (int)$storeid . "'
            
            ");
        }

       foreach($data['facility_id'] as $facilityid){
        $this->db->query("INSERT INTO oc_service_to_facility SET
        service_id = '".(int)$lastid."',
        facility_id = '" . (int)$facilityid . "'
        
        ");
       }

        foreach($data['doctor_id'] as $doctorid ){
            $this->db->query("INSERT INTO oc_service_to_doctor SET
            service_id = '".(int)$lastid."',
            doctor_id = '" . (int)$doctorid . "'
            
            ");
        }

        

        return $lastid;
    }

    public function editClinicalService($id, $data) {
        $descriptions = $data['clinical_service_description'];

        $store_id = isset($data['store_id']) ? $data['store_id'] : [];
        $doctor_id = isset($data['doctor_id']) ? $data['doctor_id'] : [];
        $acupuncture_parts = isset($data['acupuncture_part_id']) ? $data['acupuncture_part_id'] : [];
        $facility = isset($data['facility_id']) ? $data['facility_id'] : array();
        $type = $data['type'];
        $staff_id = ($type == 1) ? $data['staff_id'] : 0;
        $doctor = isset($data['doctor']) ? $data['doctor'] : 0;
        $doctor = ($type == 2) ? $doctor : 0;
        $cs_minute = $data['cs_minute'];
        $status = isset($data['status']) ? $data['status'] : array();
        $enable_appointment = isset($data['appointment']) ? $data['appointment'] : array();
        $enable_etcm = isset($data['etcm']) ? $data['etcm'] : array();
        $cs_session = $data['cs_session'];
        $price = $data['price'];
        $tax_class_id = $data['tax_class_id'];

        $sql = "
		UPDATE " . DB_PREFIX . "clinical_service SET
			store_id 		= '" . $this->db->escape(serialize($store_id)) . "',
			doctor_id		= '" . $this->db->escape(serialize($doctor_id)) . "',
			acupuncture_parts = '" . $this->db->escape(serialize($acupuncture_parts)) . "',
			type 			= $type,
			staff_id 		= $staff_id,
			doctor			= $doctor,
			cs_minute	 	= '$cs_minute',
            status       = $status,
            enable_appointment = $enable_appointment,
            enable_etcm  = $enable_etcm,
			cs_session	 	= '$cs_session',
			price 			= '$price',
			tax_class_id 	= $tax_class_id,
			modifyby 		= '" . $this->session->data['user_id'] . "',
			modifydate 		= NOW()
		WHERE clinicalservice_id = '$id'
		";

        $query = $this->db->query($sql);

        foreach ($descriptions as $language_id => $value) {
            $newname = $value['name'];
            $sql = "
			UPDATE " . DB_PREFIX . "clinical_service_description SET
			name = '$newname'
			WHERE clinicalservice_id = '$id'
			AND language_id = $language_id
			";
            $query = $this->db->query($sql);
        }

        $this->db->query("DELETE FROM oc_service_to_store WHERE service_id = '$id'");
        $this->db->query("DELETE FROM oc_service_to_facility WHERE service_id = '$id'");
        $this->db->query("DELETE FROM oc_service_to_doctor WHERE service_id = '$id'");

        foreach($data['store_id'] as $storeid){
            $this->db->query("INSERT INTO oc_service_to_store SET
            service_id = '".(int)$id."',
            store_id = '" . (int)$storeid . "'
            
            ");
        }

       foreach($data['facility_id'] as $facilityid){
        $this->db->query("INSERT INTO oc_service_to_facility SET
        service_id = '".(int)$id."',
        facility_id = '" . (int)$facilityid . "'
        
        ");
       }

        foreach($data['doctor_id'] as $doctorid ){
            $this->db->query("INSERT INTO oc_service_to_doctor SET
            service_id = '".(int)$id."',
            doctor_id = '" . (int)$doctorid . "'
            
            ");
        }
    }

    public function delete_clinical_service($clinicalservice_id) {
        $this->db->query("DELETE FROM oc_service_to_store WHERE service_id = '".(int)$clinicalservice_id."'");
        $this->db->query("DELETE FROM oc_service_to_facility WHERE service_id = '".(int)$clinicalservice_id."'");
        $this->db->query("DELETE FROM oc_service_to_doctor WHERE service_id = '".(int)$clinicalservice_id."'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "clinical_service WHERE clinicalservice_id = '" . (int) $clinicalservice_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "clinical_service_description WHERE clinicalservice_id = '" . (int) $clinicalservice_id . "'");
    }

    public function get_available_stores() {
        $sql = "SELECT * FROM " . DB_PREFIX . "store WHERE store_id != 0";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function get_administrator_staff() {
        $sql = "SELECT * FROM " . DB_PREFIX . "user WHERE user_group_id = 1";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function get_acupuncture_parts() {
        $sql = "SELECT ap.acupuncture_part_id, apd.name FROM " . DB_PREFIX . "acupuncture_part ap LEFT JOIN " . DB_PREFIX . "acupuncture_part_description apd ON apd.acupuncture_part_id = ap.acupuncture_part_id AND apd.language_id = '" . $this->config->get('config_language_id') . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function get_facility(){
        $sql="SELECT f.facility_id as facility_id , f.name as facility_name FROM oc_facility f WHERE f.status = 1";

        $query = $this->db->query($sql);

        return $query->rows;

    }

}

?>