<?php
class ModelSaleSupplierPayment extends Model {
    public function getPaymentMethods() {
        $sql = "SELECT * FROM " . DB_PREFIX . "supplier_payment_method WHERE status = '1' ORDER BY sort_order ASC";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getSupplierPayment($supplier_payment_id) {
        $sql = "SELECT sp.*, m.name AS supplier_name, m.code AS supplier_code, spm.payment_method_name FROM " . DB_PREFIX . "supplier_payment sp LEFT JOIN " . DB_PREFIX . "manufacturer m ON m.manufacturer_id = sp.manufacturer_id LEFT JOIN " . DB_PREFIX . "supplier_payment_method spm ON spm.supplier_payment_method_id = sp.supplier_payment_method_id WHERE sp.supplier_payment_id = '" . (int)$supplier_payment_id . "'";

        $query = $this->db->query($sql);

        $supplier_payment_row = $query->row;

        $supplier_payment_row['transactions'] = [];
        $total_amount = 0;
        $total_outstanding_amount = 0;
        $total_pay_amount = 0;

        $transaction_query = $this->db->query("SELECT spt.*, pi.date_added, pi.invoice_prefix, pi.supplier_invoice FROM " . DB_PREFIX . "supplier_payment_transaction spt LEFT JOIN " . DB_PREFIX . "purchase_invoice pi ON pi.purchase_invoice_id = spt.purchase_invoice_id WHERE spt.supplier_payment_id = '"  . (int)$supplier_payment_id . "' ORDER BY spt.spt_id ASC");

        $transaction_rows = $transaction_query->rows;

        if (!empty($transaction_rows)) {
            foreach ($transaction_rows as $transaction) {
                $supplier_payment_row['transactions'][] = [
                    'purchase_invoice_id'   => $transaction['purchase_invoice_id'],
                    'invoice_prefix'        => $transaction['invoice_prefix'],
                    'supplier_invoice'      => $transaction['supplier_invoice'],
                    'date'                  => date($this->language->get('date_format_short'), strtotime($transaction['date_added'])),
                    'amount'                => $transaction['amount'],
                    'outstanding_amount'    => $transaction['outstanding_amount'],
                    'pay_amount'            => $transaction['pay_amount'],
                    'paid'                  => $transaction['paid']
                ];

                $total_amount += $transaction['amount'];
                $total_outstanding_amount += $transaction['outstanding_amount'];
                $total_pay_amount += $transaction['pay_amount'];
            }
        }

        $supplier_payment_row['total_amount'] = sprintf('%0.2f', $total_amount);
        $supplier_payment_row['total_outstanding_amount'] = sprintf('%0.2f', $total_outstanding_amount);
        $supplier_payment_row['total_pay_amount'] = sprintf('%0.2f', $total_pay_amount);

        return $supplier_payment_row;
    }

    public function getSupplierTransactions($supplier_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "purchase_invoice WHERE manufacturer_id = '"  . (int)$supplier_id . "' AND order_status_id = '5' ORDER BY purchase_invoice_id DESC";
    
        $query = $this->db->query($sql);

        return $query->rows;    
    }

    public function getSupplierPaymentTransactions($purchase_invoice_id, $supplier_payment_id = false) {
        $sql = "SELECT * FROM " . DB_PREFIX . "supplier_payment_transaction spt WHERE spt.purchase_invoice_id = '"  . (int)$purchase_invoice_id . "'";

        if ($supplier_payment_id) {
            $sql .= " AND spt.supplier_payment_id = '" . (int)$supplier_payment_id . "'";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getSupplierPaymentTransaction($purchase_invoice_id, $supplier_payment_id = false) {
        $sql = "SELECT * FROM " . DB_PREFIX . "supplier_payment_transaction spt WHERE spt.purchase_invoice_id = '"  . (int)$purchase_invoice_id . "'";

        if ($supplier_payment_id) {
            $sql .= " AND spt.supplier_payment_id = '" . (int)$supplier_payment_id . "'";
        }

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getTotalSupplierPaymentTransactionHistory($purchase_invoice_id, $supplier_payment_id) {
        $sql = "SELECT pi.total AS total_amount, SUM(spt.outstanding_amount) AS total_outstanding_amount, SUM(spt.pay_amount) AS total_pay_amount FROM " . DB_PREFIX . "supplier_payment sp LEFT JOIN " . DB_PREFIX . "supplier_payment_transaction spt ON spt.supplier_payment_id = sp.supplier_payment_id LEFT JOIN " . DB_PREFIX . "purchase_invoice pi ON pi.purchase_invoice_id = spt.purchase_invoice_id WHERE spt.purchase_invoice_id = '"  . (int)$purchase_invoice_id . "'";

        if ($supplier_payment_id) {
            $sql .= " AND sp.supplier_payment_id != '" . (int)$supplier_payment_id . "'";
        }

        $sql .= " GROUP BY spt.purchase_invoice_id";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getSuppliers($data) {
        $sql = "SELECT * FROM " . DB_PREFIX . "manufacturer m WHERE m.status = '1'";

        if (!empty($data['filter_name'])) {
            $sql .= " AND m.name LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        }
        
        if (!empty($data['filter_code'])) {
            $sql .= " AND m.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getSupplierPayments($data) {
        $sql = "SELECT sp.supplier_payment_id, sp.invoice_prefix, sp.payment_date, m.name AS supplier_name, sp.date_added, spm.payment_method_name, sp.paid_amount, sp.unapplied_amount FROM " . DB_PREFIX . "supplier_payment sp LEFT JOIN " . DB_PREFIX . "manufacturer m ON m.manufacturer_id = sp.manufacturer_id LEFT JOIN " . DB_PREFIX . "supplier_payment_method spm ON spm.supplier_payment_method_id = sp.supplier_payment_method_id WHERE 1";

        if (!empty($data['filter_payment_date_from'])) {
            $sql .= " AND DATE(sp.payment_date) >= DATE('" . $this->db->escape($data['filter_payment_date_from']) .  "')";
        }

        if (!empty($data['filter_payment_date_to'])) {
            $sql .= " AND DATE(sp.payment_date) <= DATE('" . $this->db->escape($data['filter_payment_date_to']) .  "')";
        }

        if (!empty($data['filter_invoice_prefix'])) {
            $sql .= " AND sp.invoice_prefix LIKE '%" . $this->db->escape($data['filter_invoice_prefix']) .  "%'";
        }

        if (!empty($data['filter_supplier_name'])) {
            $sql .= " AND m.name LIKE '%" . $this->db->escape($data['filter_supplier_name']) .  "%'";
        }

        if (!empty($data['filter_supplier_payment_method'])) {
            $sql .= " AND sp.supplier_payment_method_id = '" . $this->db->escape($data['filter_supplier_payment_method']) .  "'";
        }

        $sort_data = array(
			'sp.supplier_payment_id',
			'sp.invoice_prefix',
			'sp.payment_date',
            'm.name',
            'sp.supplier_payment_method_id',
            'sp.date_added',
            'sp.paid_amount',
            'sp.unapplied_amount'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY sp.invoice_prefix";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function addSupplierPayment($data) {
        $sql = "INSERT INTO " . DB_PREFIX . "supplier_payment SET invoice_prefix = '" . $this->db->escape($data['invoice_prefix']) . "', payment_date = '" . $this->db->escape($data['payment_date']) . "', manufacturer_id = '" . (int)$data['manufacturer_id'] . "', description = '" . $this->db->escape($data['description']) . "', supplier_payment_method_id = '" . (int)$data['supplier_payment_method_id'] . "', cheque_num = '" . $this->db->escape($data['cheque_num']) . "', bank_charge = '" . $data['bank_charge'] . "', paid_amount = '" . $data['paid_amount'] . "', unapplied_amount = '" . $data['unapplied_amount'] . "', date_added = NOW(), add_by = '" . (int)$this->session->data['user_id'] . "', date_modified = NOW(), modify_by = '" . (int)$this->session->data['user_id'] . "'";

        $query = $this->db->query($sql);

        $supplier_payment_id = $this->db->getLastId();

        if ($supplier_payment_id > 0) {
            if (!empty($data['transactions'])) {
                foreach ($data['transactions'] as $transaction) {
                    if (isset($transaction['paid'])) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "supplier_payment_transaction SET supplier_payment_id = '" . (int)$supplier_payment_id . "', purchase_invoice_id = '" . (int)$transaction['purchase_invoice_id'] . "', amount = '" . $transaction['amount'] . "', outstanding_amount = '" . $transaction['outstanding_amount'] . "', pay_amount = '" . $transaction['pay_amount'] . "', paid = '" . (int)$transaction['paid'] . "'");
                    }
                }
            }

            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'sale/supplier_payment', 'store' => $this->session->data['store_id']));
        }        

        return $supplier_payment_id;
    }

    public function editSupplierPayment($data, $supplier_payment_id) {
        $sql = "UPDATE " . DB_PREFIX . "supplier_payment SET invoice_prefix = '" . $this->db->escape($data['invoice_prefix']) . "', payment_date = '" . $this->db->escape($data['payment_date']) . "', manufacturer_id = '" . (int)$data['manufacturer_id'] . "', description = '" . $this->db->escape($data['description']) . "', supplier_payment_method_id = '" . (int)$data['supplier_payment_method_id'] . "', cheque_num = '" . $this->db->escape($data['cheque_num']) . "', bank_charge = '" . $data['bank_charge'] . "', paid_amount = '" . $data['paid_amount'] . "', unapplied_amount = '" . $data['unapplied_amount'] . "', date_modified = NOW(), modify_by = '" . (int)$this->session->data['user_id'] . "' WHERE supplier_payment_id = '" . (int)$supplier_payment_id . "'";

        $query = $this->db->query($sql);

        $this->db->query("DELETE FROM " . DB_PREFIX . "supplier_payment_transaction WHERE supplier_payment_id = '" . (int)$supplier_payment_id . "'");

        if (!empty($data['transactions'])) {
            foreach ($data['transactions'] as $transaction) {
                if (isset($transaction['paid'])) {
                    $this->db->query("INSERT INTO " . DB_PREFIX . "supplier_payment_transaction SET supplier_payment_id = '" . (int)$supplier_payment_id . "', purchase_invoice_id = '" . (int)$transaction['purchase_invoice_id'] . "', amount = '" . $transaction['amount'] . "', outstanding_amount = '" . $transaction['outstanding_amount'] . "', pay_amount = '" . $transaction['pay_amount'] . "', paid = '" . (int)$transaction['paid'] . "'");
                }
            }
        }
    }
}
?>