<?php

class ModelSaleShippingModule extends Model {

    public function getOrder($order_id) {
        $store_id = $this->session->data['store_id'];
        $order_query = $this->db->query("SELECT *, (SELECT CONCAT(c.firstname, ' ', c.lastname) FROM " . DB_PREFIX . "customer c WHERE c.customer_id = o.customer_id) AS customer FROM `" . DB_PREFIX . "order` o WHERE o.order_id = '" . (int) $order_id . "' AND o.store_id = '" . (int) $store_id . "'");

        if ($order_query->num_rows) {
            $reward = 0;

            $order_product_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_product WHERE order_id = '" . (int) $order_id . "'");

            foreach ($order_product_query->rows as $product) {
                $reward += $product['reward'];
            }

            $country_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "country` WHERE country_id = '" . (int) $order_query->row['payment_country_id'] . "'");

            if ($country_query->num_rows) {
                $payment_iso_code_2 = $country_query->row['iso_code_2'];
                $payment_iso_code_3 = $country_query->row['iso_code_3'];
            } else {
                $payment_iso_code_2 = '';
                $payment_iso_code_3 = '';
            }

            $zone_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "zone` WHERE zone_id = '" . (int) $order_query->row['payment_zone_id'] . "'");

            if ($zone_query->num_rows) {
                $payment_zone_code = $zone_query->row['code'];
            } else {
                $payment_zone_code = '';
            }

            $country_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "country` WHERE country_id = '" . (int) $order_query->row['shipping_country_id'] . "'");

            if ($country_query->num_rows) {
                $shipping_iso_code_2 = $country_query->row['iso_code_2'];
                $shipping_iso_code_3 = $country_query->row['iso_code_3'];
            } else {
                $shipping_iso_code_2 = '';
                $shipping_iso_code_3 = '';
            }

            $zone_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "zone` WHERE zone_id = '" . (int) $order_query->row['shipping_zone_id'] . "'");

            if ($zone_query->num_rows) {
                $shipping_zone_code = $zone_query->row['code'];
            } else {
                $shipping_zone_code = '';
            }

            if ($order_query->row['affiliate_id']) {
                $affiliate_id = $order_query->row['affiliate_id'];
            } else {
                $affiliate_id = 0;
            }

            $this->load->model('marketing/affiliate');

            $affiliate_info = $this->model_marketing_affiliate->getAffiliate($affiliate_id);

            if ($affiliate_info) {
                $affiliate_firstname = $affiliate_info['firstname'];
                $affiliate_lastname = $affiliate_info['lastname'];
            } else {
                $affiliate_firstname = '';
                $affiliate_lastname = '';
            }

            $this->load->model('localisation/language');

            $language_info = $this->model_localisation_language->getLanguage($order_query->row['language_id']);


            if ($language_info) {
                $language_code = $language_info['code'];
                //$language_filename = $language_info['filename'];
                $language_filename = '';
                $language_directory = $language_info['directory'];
            } else {
                $language_code = '';
                $language_filename = '';
                $language_directory = '';
            }


            $staff_query = $this->db->query("SELECT firstname FROM `" . DB_PREFIX . "user` WHERE user_id = '" . (int) $order_query->row['user_id'] . "'");

            if ($staff_query->num_rows) {
                $staff_name = $staff_query->row['firstname'];
            } else {
                $staff_name = '';
            }

            return array(
                'order_id' => $order_query->row['order_id'],
                'invoice_no' => $order_query->row['invoice_no'],
                'invoice_prefix' => $order_query->row['invoice_prefix'],
                'store_id' => $order_query->row['store_id'],
                'store_name' => $order_query->row['store_name'],
                'staff_name' => $staff_name,
                'store_url' => $order_query->row['store_url'],
                'customer_id' => $order_query->row['customer_id'],
                'customer' => $order_query->row['customer'],
                'customer_group_id' => $order_query->row['customer_group_id'],
                'firstname' => $order_query->row['firstname'],
                'lastname' => $order_query->row['lastname'],
                'email' => $order_query->row['email'],
                'telephone' => $order_query->row['telephone'],
                'fax' => $order_query->row['fax'],
                'card_no' => $order_query->row['card_no'],
                'custom_field' => json_decode($order_query->row['custom_field']),
                'payment_firstname' => $order_query->row['payment_firstname'],
                'payment_lastname' => $order_query->row['payment_lastname'],
                'payment_company' => $order_query->row['payment_company'],
                'payment_address_1' => $order_query->row['payment_address_1'],
                'payment_address_2' => $order_query->row['payment_address_2'],
                'payment_postcode' => $order_query->row['payment_postcode'],
                'payment_city' => $order_query->row['payment_city'],
                'payment_zone_id' => $order_query->row['payment_zone_id'],
                'payment_zone' => $order_query->row['payment_zone'],
                'payment_zone_code' => $payment_zone_code,
                'payment_country_id' => $order_query->row['payment_country_id'],
                'payment_country' => $order_query->row['payment_country'],
                'payment_iso_code_2' => $payment_iso_code_2,
                'payment_iso_code_3' => $payment_iso_code_3,
                'payment_address_format' => $order_query->row['payment_address_format'],
                'payment_custom_field' => json_decode($order_query->row['payment_custom_field']),
                'payment_method' => $order_query->row['payment_method'],
                'payment_code' => $order_query->row['payment_code'],
                'shipping_firstname' => $order_query->row['shipping_firstname'],
                'shipping_lastname' => $order_query->row['shipping_lastname'],
                'shipping_company' => $order_query->row['shipping_company'],
                'shipping_address_1' => $order_query->row['shipping_address_1'],
                'shipping_address_2' => $order_query->row['shipping_address_2'],
                'shipping_postcode' => $order_query->row['shipping_postcode'],
                'shipping_city' => $order_query->row['shipping_city'],
                'shipping_zone_id' => $order_query->row['shipping_zone_id'],
                'shipping_zone' => $order_query->row['shipping_zone'],
                'shipping_zone_code' => $shipping_zone_code,
                'shipping_country_id' => $order_query->row['shipping_country_id'],
                'shipping_country' => $order_query->row['shipping_country'],
                'shipping_iso_code_2' => $shipping_iso_code_2,
                'shipping_iso_code_3' => $shipping_iso_code_3,
                'shipping_address_format' => $order_query->row['shipping_address_format'],
                'shipping_custom_field' => json_decode($order_query->row['shipping_custom_field']),
                'shipping_method' => $order_query->row['shipping_method'],
                'shipping_code' => $order_query->row['shipping_code'],
                'comment' => $order_query->row['comment'],
                'total' => $order_query->row['total'],
                'total_weight' => $order_query->row['total_weight'],
                'reward' => $reward,
                'order_status_id' => $order_query->row['order_status_id'],
                'affiliate_id' => $order_query->row['affiliate_id'],
                'affiliate_firstname' => $affiliate_firstname,
                'affiliate_lastname' => $affiliate_lastname,
                'commission' => $order_query->row['commission'],
                'language_id' => $order_query->row['language_id'],
                'language_code' => $language_code,
                'language_filename' => $language_filename,
                'language_directory' => $language_directory,
                'currency_id' => $order_query->row['currency_id'],
                'currency_code' => $order_query->row['currency_code'],
                'currency_value' => $order_query->row['currency_value'],
                'ip' => $order_query->row['ip'],
                'forwarded_ip' => $order_query->row['forwarded_ip'],
                'user_agent' => $order_query->row['user_agent'],
                'accept_language' => $order_query->row['accept_language'],
                'date_added' => $order_query->row['date_added'],
                'date_modified' => $order_query->row['date_modified'],
                'tracking_number' => $order_query->row['tracking_number'],
                'carrier_id' => $order_query->row['carrier_id']
            );
        } else {
            return;
        }
    }

    public function getOrders($data = array()) {
        $store_id = $this->session->data['store_id'];
        $sql = "SELECT o.order_id, o.total_weight, CONCAT(o.firstname, ' ', o.lastname) AS customer, (SELECT os.name FROM " . DB_PREFIX . "order_status os WHERE os.order_status_id = o.order_status_id AND os.language_id = '" . (int) $this->config->get('config_language_id') . "') AS status, o.shipping_code, o.total, o.currency_code, o.currency_value, o.date_added, o.date_modified,o.invoice_prefix,o.order_status_id, o.customer_group_id, o.carrier_id, o.tracking_number, o.telephone, o.email FROM `" . DB_PREFIX . "order` o";

        if (isset($data['filter_order_status'])) {
            $implode = array();

            $order_statuses = explode(',', $data['filter_order_status']);

            foreach ($order_statuses as $order_status_id) {
                $implode[] = "o.order_status_id = '" . (int) $order_status_id . "'";
            }

            if ($implode) {
                $sql .= " WHERE (" . implode(" OR ", $implode) . ") AND o.store_id = '" . (int) $store_id . "'";
            } else {
                
            }
        } else {
            $sql .= " WHERE o.order_status_id > '0'";
        }

        if (!empty($data['filter_date_added_from'])) {
            $sql .= " AND DATE(o.date_added) >= DATE('" . $this->db->escape($data['filter_date_added_from']) . "')";
        }

        if (!empty($data['filter_date_added_to'])) {
            $sql .= " AND DATE(o.date_added) <= DATE('" . $this->db->escape($data['filter_date_added_to']) . "')";
        }

        if (!empty($data['filter_invoice'])) {
            $sql .= " AND o.invoice_prefix = '" . $this->db->escape($data['filter_invoice']) . "'";
        }

        if (!empty($data['filter_order_id'])) {
            $sql .= " AND o.order_id = '" . (int) $data['filter_order_id'] . "'";
        }

        if (isset($data['filter_store_id'])) {
            $sql .= " AND store_id = '" . (int) $data['filter_store_id'] . "'";
        }

        if (!empty($data['filter_customer'])) {
            $sql .= " AND CONCAT(o.firstname, ' ', o.lastname) LIKE '%" . $this->db->escape($data['filter_customer']) . "%'";
        }

        if (!empty($data['filter_customer_group'])) {
            $sql .= " AND o.customer_group_id = '" . (int) $data['filter_customer_group'] . "'";
        }

        if (!empty($data['filter_date_modified'])) {
            $sql .= " AND DATE(o.date_modified) = DATE('" . $this->db->escape($data['filter_date_modified']) . "')";
        }

        if (!empty($data['filter_carrier'])) {
            if ($data['filter_carrier'] == 'no-carrier') {
                $sql .= " AND o.carrier_id = ''";
            } else if ($data['filter_carrier'] == 'all-carrier') {
                $sql .= " AND o.carrier_id != ''";
            } else {
                $sql .= " AND o.carrier_id = '" . (int) $data['filter_carrier'] . "'";
            }
        }

        if (!empty($data['filter_got_tracking'])) {
            if ($data['filter_got_tracking'] == '2') {
                $sql .= " AND o.tracking_number != ''";
            } else if ($data['filter_got_tracking'] == '1') {
                $sql .= " AND o.tracking_number = ''";
            }
        }

        if (!empty($data['filter_tracking_num'])) {
            $sql .= " AND o.tracking_number LIKE '%" . $this->db->escape($data['filter_tracking_num']) . "%'";
        }

        if (!empty($data['filter_total'])) {
            $sql .= " AND o.total = '" . (float) $data['filter_total'] . "'";
        }

        if (!empty($data['filter_user_id'])) {
            $sql .= " AND user_id = '" . (float) $data['filter_user_id'] . "'";
        }

        $sort_data = array(
            'o.order_id',
            'customer',
            'status',
            'o.date_added',
            'o.total_weight',
            'o.date_modified',
            'o.total'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY o.order_id";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getPosOrders($data = array()) {

        $sql = "SELECT o.order_id,o.customer_id, CONCAT(o.firstname, ' ', o.lastname) AS customer, (SELECT os.name FROM " . DB_PREFIX . "order_status os WHERE os.order_status_id = o.order_status_id AND os.language_id = '" . (int) $this->config->get('config_language_id') . "') AS status, o.shipping_code, o.total, o.currency_code, o.currency_value, o.date_added, o.date_modified,o.invoice_prefix FROM `" . DB_PREFIX . "order` o";


        if (isset($data['filter_order_status'])) {
            $sql .= " WHERE o.order_status_id = '" . (int) $data['filter_order_status'] . "'";
        } else {
            $sql .= " WHERE o.order_status_id > '0'";
        }

        if (isset($data['filter_store_id'])) {
            $sql .= " AND o.store_id = '" . (int) $data['filter_store_id'] . "'";
        }


        if (isset($data['filter_order_id'])) {
            $sql .= " AND o.order_id = '" . (int) $data['filter_order_id'] . "'";
        }

        if (isset($data['filter_invoice_id'])) {
            $sql .= " AND o.invoice_prefix = '" . $this->db->escape($data['filter_invoice_id']) . "'";
        }


        if (!empty($data['filter_customer'])) {
            $sql .= " AND CONCAT(o.firstname, ' ', o.lastname) LIKE '%" . $this->db->escape($data['filter_customer']) . "%'";
        }

        if (!empty($data['filter_date_added'])) {
            $sql .= " AND DATE(o.date_added) = DATE('" . $this->db->escape($data['filter_date_added']) . "')";
        }

        if (!empty($data['filter_date_modified'])) {
            $sql .= " AND DATE(o.date_modified) = DATE('" . $this->db->escape($data['filter_date_modified']) . "')";
        }

        if (!empty($data['filter_total'])) {
            $sql .= " AND o.total = '" . (float) $data['filter_total'] . "'";
        }

        if (!empty($data['filter_user_id'])) {
            $sql .= " AND user_id = '" . (float) $data['filter_user_id'] . "'";
        }

        $sort_data = array(
            'o.order_id',
            'customer',
            'status',
            'o.date_added',
            'o.date_modified',
            'o.total_weight',
            'o.total'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY o.order_id";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }
        $sql;

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getOrderProducts($order_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_product WHERE order_id = '" . (int) $order_id . "' AND price !=0");

        return $query->rows;
    }

    public function getOrderProducts2($order_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_product WHERE order_id = '" . (int) $order_id . "'");

        return $query->rows;
    }

    public function getOrderCartProducts($order_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_product WHERE order_id = '" . (int) $order_id . "' AND total!=0.00 ");

        return $query->rows;
    }

    public function getOrderOption($order_id, $order_option_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_option WHERE order_id = '" . (int) $order_id . "' AND order_option_id = '" . (int) $order_option_id . "'");

        return $query->row;
    }

    public function getOrderOptions($order_id, $order_product_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_option WHERE order_id = '" . (int) $order_id . "' AND order_product_id = '" . (int) $order_product_id . "'");

        return $query->rows;
    }

    public function getOrderVouchers($order_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_voucher WHERE order_id = '" . (int) $order_id . "'");

        return $query->rows;
    }

    public function getOrderVoucherByVoucherId($voucher_id) {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "order_voucher` WHERE voucher_id = '" . (int) $voucher_id . "'");

        return $query->row;
    }

    public function getOrderTotals($order_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_total WHERE order_id = '" . (int) $order_id . "' ORDER BY sort_order");

        return $query->rows;
    }

    public function getTotalOrders($data = array()) {
        $sql = "SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "order`";

        if (!empty($data['filter_order_status'])) {
            $implode = array();

            $order_statuses = explode(',', $data['filter_order_status']);

            foreach ($order_statuses as $order_status_id) {
                $implode[] = "order_status_id = '" . (int) $order_status_id . "'";
            }

            if ($implode) {
                $sql .= " WHERE (" . implode(" OR ", $implode) . ")";
            }
        } else {
            $sql .= " WHERE order_status_id > '0'";
        }

        if (!empty($data['filter_date_added_from'])) {
            $sql .= " AND DATE(date_added) >= DATE('" . $this->db->escape($data['filter_date_added_from']) . "')";
        }

        if (!empty($data['filter_date_added_to'])) {
            $sql .= " AND DATE(date_added) <= DATE('" . $this->db->escape($data['filter_date_added_to']) . "')";
        }

        if (!empty($data['filter_order_id'])) {
            $sql .= " AND order_id = '" . (int) $data['filter_order_id'] . "'";
        }

        if (isset($data['filter_store_id'])) {
            $sql .= " AND store_id = '" . (int) $data['filter_store_id'] . "'";
        }

        if (!empty($data['filter_invoice'])) {
            $sql .= " AND invoice_prefix = '" . $this->db->escape($data['filter_invoice']) . "'";
        }

        if (!empty($data['filter_customer'])) {
            $sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['filter_customer']) . "%'";
        }

        if (!empty($data['filter_customer_group'])) {
            $sql .= " AND customer_group_id = '" . (int) $data['filter_customer_group'] . "'";
        }

        if (!empty($data['filter_date_modified'])) {
            $sql .= " AND DATE(date_modified) = DATE('" . $this->db->escape($data['filter_date_modified']) . "')";
        }

        if (!empty($data['filter_carrier'])) {
            $sql .= " AND carrier_id = '" . (int) $data['filter_carrier'] . "'";
        }

        if (!empty($data['filter_tracking_num'])) {
            $sql .= " AND tracking_number LIKE '%" . $this->db->escape($data['filter_tracking_num']) . "%'";
        }

        if (!empty($data['filter_total'])) {
            $sql .= " AND total = '" . (float) $data['filter_total'] . "'";
        }

        if (!empty($data['filter_user_id'])) {
            $sql .= " AND user_id = '" . (float) $data['filter_user_id'] . "'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getPosTotalOrders($data = array()) {
        $sql = "SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "order`";

        if (!empty($data['filter_order_status'])) {
            $sql .= " WHERE order_status_id = '" . (int) $data['filter_order_status'] . "'";
        } else {
            $sql .= " WHERE order_status_id > '0'";
        }

        if (!empty($data['filter_order_id'])) {
            $sql .= " AND order_id = '" . (int) $data['filter_order_id'] . "'";
        }

        if (isset($data['filter_store_id'])) {
            $sql .= " AND store_id = '" . (int) $data['filter_store_id'] . "'";
        }

        if (isset($data['filter_invoice_id'])) {
            $sql .= " AND invoice_prefix = '" . (int) $data['filter_invoice_id'] . "'";
        }

        if (!empty($data['filter_customer'])) {
            $sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['filter_customer']) . "%'";
        }

        if (!empty($data['filter_date_added'])) {
            $sql .= " AND DATE(date_added) = DATE('" . $this->db->escape($data['filter_date_added']) . "')";
        }

        if (!empty($data['filter_date_modified'])) {
            $sql .= " AND DATE(date_modified) = DATE('" . $this->db->escape($data['filter_date_modified']) . "')";
        }

        if (!empty($data['filter_total'])) {
            $sql .= " AND total = '" . (float) $data['filter_total'] . "'";
        }

        if (!empty($data['filter_user_id'])) {
            $sql .= " AND user_id = '" . (float) $data['filter_user_id'] . "'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getTotalOrdersByStoreId($store_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "order` WHERE store_id = '" . (int) $store_id . "'");

        return $query->row['total'];
    }

    public function getTotalOrdersByOrderStatusId($order_status_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "order` WHERE order_status_id = '" . (int) $order_status_id . "' AND order_status_id > '0'");

        return $query->row['total'];
    }

    public function getTotalOrdersByProcessingStatus() {
        $implode = array();

        $order_statuses = $this->config->get('config_processing_status');

        foreach ($order_statuses as $order_status_id) {
            $implode[] = "order_status_id = '" . (int) $order_status_id . "'";
        }

        if ($implode) {
            $query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "order` WHERE " . implode(" OR ", $implode) . "");

            return $query->row['total'];
        } else {
            return 0;
        }
    }

    public function getTotalOrdersByCompleteStatus() {
        $implode = array();

        $order_statuses = $this->config->get('config_complete_status');

        foreach ($order_statuses as $order_status_id) {
            $implode[] = "order_status_id = '" . (int) $order_status_id . "'";
        }

        if ($implode) {
            $query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "order` WHERE " . implode(" OR ", $implode) . "");

            return $query->row['total'];
        } else {
            return 0;
        }
    }

    public function getTotalOrdersByLanguageId($language_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "order` WHERE language_id = '" . (int) $language_id . "' AND order_status_id > '0'");

        return $query->row['total'];
    }

    public function getTotalOrdersByCurrencyId($currency_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "order` WHERE currency_id = '" . (int) $currency_id . "' AND order_status_id > '0'");

        return $query->row['total'];
    }

    public function createInvoiceNo($order_id) {
        $order_info = $this->getOrder($order_id);

        if ($order_info && empty($order_info['invoice_prefix'])) {

            $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'pos/pos', 'store' => $this->session->data['store_id']));

            $order_status_id = $this->getOrderStatus($order_id);

            $this->db->query("UPDATE " . DB_PREFIX . "order SET invoice_prefix = '" . $invoice_prefix . "' WHERE order_id = '" . $order_id . "'");

            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'pos/pos', 'store' => $this->session->data['store_id']));

            $this->db->query("INSERT INTO " . DB_PREFIX . "order_history SET order_id = '" . (int) $order_id . "', order_status_id = '" . (int) $order_status_id . "', notify = '0', comment = '" . $invoice_prefix . "', date_added = NOW() ");

            return $invoice_prefix;

            // if ($order_info && !$order_info['invoice_no']) {
            //     $query = $this->db->query("SELECT MAX(invoice_no) AS invoice_no FROM `" . DB_PREFIX . "order` WHERE invoice_prefix = '" . $this->db->escape($order_info['invoice_prefix']) . "'");
            //     if ($query->row['invoice_no']) {
            //         $invoice_no = $query->row['invoice_no'] + 1;
            //     } else {
            //         $invoice_no = 1;
            //     }
            //     $this->db->query("UPDATE `" . DB_PREFIX . "order` SET invoice_no = '" . (int) $invoice_no . "', invoice_prefix = '" . $this->db->escape($order_info['invoice_prefix']) . "' WHERE order_id = '" . (int) $order_id . "'");
            //     $this->db->query("INSERT INTO " . DB_PREFIX . "order_history SET order_id = '" . (int) $order_id . "', order_status_id = '', notify = '0', comment = ''" . $this->db->escape($order_info['invoice_prefix']) . "'', date_added = NOW() ");
            //     return $order_info['invoice_prefix'] . $invoice_no;
        }
    }

    public function getOrderHistories($order_id, $start = 0, $limit = 10) {
        if ($start < 0) {
            $start = 0;
        }

        if ($limit < 1) {
            $limit = 10;
        }

        $query = $this->db->query("SELECT oh.date_added, os.name AS status, oh.comment, oh.notify FROM " . DB_PREFIX . "order_history oh LEFT JOIN " . DB_PREFIX . "order_status os ON oh.order_status_id = os.order_status_id WHERE oh.order_id = '" . (int) $order_id . "' AND os.language_id = '" . (int) $this->config->get('config_language_id') . "' ORDER BY oh.date_added ASC LIMIT " . (int) $start . "," . (int) $limit);

        return $query->rows;
    }

    public function getTotalOrderHistories($order_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "order_history WHERE order_id = '" . (int) $order_id . "'");

        return $query->row['total'];
    }

    public function getTotalOrderHistoriesByOrderStatusId($order_status_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "order_history WHERE order_status_id = '" . (int) $order_status_id . "'");

        return $query->row['total'];
    }

    public function getEmailsByProductsOrdered($products, $start, $end) {
        $implode = array();

        foreach ($products as $product_id) {
            $implode[] = "op.product_id = '" . (int) $product_id . "'";
        }

        $query = $this->db->query("SELECT DISTINCT email FROM `" . DB_PREFIX . "order` o LEFT JOIN " . DB_PREFIX . "order_product op ON (o.order_id = op.order_id) WHERE (" . implode(" OR ", $implode) . ") AND o.order_status_id <> '0' LIMIT " . (int) $start . "," . (int) $end);

        return $query->rows;
    }

    public function getTotalEmailsByProductsOrdered($products) {
        $implode = array();

        foreach ($products as $product_id) {
            $implode[] = "op.product_id = '" . (int) $product_id . "'";
        }

        $query = $this->db->query("SELECT DISTINCT email FROM `" . DB_PREFIX . "order` o LEFT JOIN " . DB_PREFIX . "order_product op ON (o.order_id = op.order_id) WHERE (" . implode(" OR ", $implode) . ") AND o.order_status_id <> '0'");

        return $query->row['total'];
    }

    public function getPaidProducts($order_id) {
        $order_query = $this->db->query("SELECT op.quantity, op.product_id FROM " . DB_PREFIX . "order_product op LEFT JOIN " . DB_PREFIX . "order o ON o.order_id = op.order_id WHERE op.order_id ='" . (int) $order_id . "' AND o.order_status_id = '5'");

        return $order_query->rows;
    }

    public function getPaidHerbals($order_id) {

        $order_query = $this->db->query("SELECT *  FROM " . DB_PREFIX . "clinical_sale cs WHERE cs.order_id ='" . (int) $order_id . "' AND cs.order_action= '5'");

        return $order_query->rows;
    }

    public function getUnPaidHerbals($order_id) {

        $order_query = $this->db->query("SELECT *  FROM " . DB_PREFIX . "clinical_sale cs WHERE cs.order_id ='" . (int) $order_id . "'");

        return $order_query->rows;
    }

    public function getPaidServies($order_id) {

        $order_query = $this->db->query("
		SELECT *,si.net_amount As service_price
		FROM " . DB_PREFIX . "service_item si
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON (si.service_form_id = sf.service_form_id)
		WHERE sf.order_id ='" . (int) $order_id . "'
		AND sf.order_action= '5'");
        return $order_query->rows;
    }

    public function getUnPaidServies($order_id) {

        $order_query = $this->db->query("
		SELECT *,si.net_amount As service_price
		FROM " . DB_PREFIX . "service_item si
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON (si.service_form_id = sf.service_form_id)
		WHERE sf.order_id ='" . (int) $order_id . "'");
        return $order_query->rows;
    }

    public function getPaidBrewings($order_id) {
        $order_query = $this->db->query("SELECT *
										 FROM " . DB_PREFIX . "herbal_transfer
										 WHERE order_id = '" . (int) $order_id . "'
										 AND payment_status = '5'
										 AND from_store_customer_id = 0");

        return $order_query->rows;
    }

    public function getPaidBrewingOrders($order_id) {
        $order_query = $this->db->query("SELECT *
										 FROM " . DB_PREFIX . "herbal_transfer
										 WHERE order_id = '" . (int) $order_id . "'
										 AND payment_status = '5'
										 AND from_store_customer_id > 0");

        return $order_query->rows;
    }

    public function getHoaldHerbals($order_id) {

        $order_query = $this->db->query("SELECT *  FROM " . DB_PREFIX . "clinical_sale cs WHERE cs.order_id ='" . (int) $order_id . "' AND cs.order_action= '1'");

        return $order_query->rows;
    }

    public function getHoaldServies($order_id) {

        $order_query = $this->db->query("SELECT * ,si.net_amount As service_price   FROM " . DB_PREFIX . "service_item si  LEFT JOIN " . DB_PREFIX . "service_form sf ON (si.service_form_id = sf.service_form_id) WHERE sf.order_id ='" . (int) $order_id . "' AND sf.order_action= '1'");

        return $order_query->rows;
    }

    public function getHerbals($order_id) {

        $order_query = $this->db->query("SELECT *  FROM " . DB_PREFIX . "clinical_sale cs WHERE cs.order_id ='" . (int) $order_id . "'");

        return $order_query->rows;
    }

    public function getServies($order_id) {

        $order_query = $this->db->query("SELECT * ,si.net_amount As service_price   FROM " . DB_PREFIX . "service_item si  LEFT JOIN " . DB_PREFIX . "service_form sf ON (si.service_form_id = sf.service_form_id) WHERE sf.order_id ='" . (int) $order_id . "'");

        return $order_query->rows;
    }

    public function getBrewings($order_id) {
        $order_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "herbal_transfer WHERE order_id = '" . (int) $order_id . "' AND from_store_customer_id = 0");

        return $order_query->rows;
    }

    public function getBrewingOrders($order_id) {
        $order_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "herbal_transfer WHERE order_id = '" . (int) $order_id . "' AND from_store_customer_id > 0");

        return $order_query->rows;
    }

    public function listPendingOrder($from_order_status) {
        $sql = "SELECT order_id, order_reminder, invoice_prefix, date_added, store_id, email, store_name, CONCAT(firstname, ' ', lastname) AS customer_name FROM " . DB_PREFIX . "order WHERE order_status_id IN(" . $from_order_status . ")";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function updateCancel($order_status, $order_id) {
        $sql = "UPDATE " . DB_PREFIX . "order SET order_status_id = '" . $order_status . "', date_modified = NOW() WHERE order_id = '" . $order_id . "'";

        $query = $this->db->query($sql);

        return $order_id;
    }

    public function selectProduct($order_id) {
        $sql = "SELECT order_id, name, quantity, product_id FROM " . DB_PREFIX . "order_product WHERE order_id = '" . $order_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function reverse_quantity($quantity, $store_id, $product_id) {
        $sql = "UPDATE " . DB_PREFIX . "product_to_store SET onhand_quantity = onhand_quantity + " . $quantity . " WHERE product_id = '" . $product_id . "' AND store_id = '" . $store_id . "'";

        $query = $this->db->query($sql);
    }

    public function updateOrderReminder($order_id) {
        $sql = "UPDATE " . DB_PREFIX . "order SET order_reminder = '1' WHERE order_id = '" . (int) $order_id . "'";

        $query = $this->db->query($sql);
    }

    public function getCustomerPhoneNumberByOrderID($order_id) {
        $sql = "SELECT c.telephone, c.telephone2, a.country_id FROM " . DB_PREFIX . "order o
				LEFT JOIN " . DB_PREFIX . "customer c
				ON c.customer_id = o.customer_id
				LEFT JOIN " . DB_PREFIX . "address a
				ON a.customer_id = c.customer_id
				WHERE o.order_id = '" . (int) $order_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getWeightClassUnit($weight_class_id) {
        $sql = "SELECT wcd.unit FROM `" . DB_PREFIX . "weight_class_description` wcd WHERE weight_class_id = '" . $weight_class_id . "' ";
        $query = $this->db->query($sql);
        return $query->row['unit'];
    }

    public function getHerbalTotal($clinical_sale_id) {
        $sql = "SELECT *
				FROM " . DB_PREFIX . "clinical_sale_total
				WHERE code IN ('total','rounding')
				AND clinical_sale_id = '" . (int) $clinical_sale_id . "'";

        $query = $this->db->query($sql);

        $total_rows = $query->rows;

        $grandtotal = 0;
        $small_total = 0;
        $rounding = 0;

        foreach ($total_rows as $total) {
            if (($total['id'] == '2') && ($total['code'] == 'total')) {
                $grandtotal = $total['value'];
            }

            if (($total['id'] == '1') && ($total['code'] == 'total')) {
                $small_total = $total['value'];
            }

            if (($total['code'] == 'rounding') && ($total['id'] == '1')) {
                $rounding = $total['value'];
            }
        }

        $herbal_total = $grandtotal - $small_total + $rounding;

        return $herbal_total;
    }

    public function getHerbalTax($clinical_sale_id) {
        $sql = "SELECT *
				FROM " . DB_PREFIX . "clinical_sale_total
				WHERE code IN('tax', 'rounding')
				AND clinical_sale_id = '" . (int) $clinical_sale_id . "'";

        $query = $this->db->query($sql);

        $tax_rows = $query->rows;
        $grand_tax = 0;
        $small_tax = 0;
        $rounding_value = 0;

        foreach ($tax_rows as $tax) {
            if (($tax['id'] == '2') && ($tax['code'] == 'tax')) {
                $grand_tax = $tax['value'];
            }

            if (($tax['id'] == '1') && ($tax['code'] == 'tax')) {
                $small_tax += $tax['value'];
            }

            /* if(($tax['code'] == 'rounding') && ($tax['id'] == '1')){
              $rounding_value = $tax['value'];
              } */
        }

        $tax_total = $grand_tax - $small_tax /* - $rounding_value */;

        return $tax_total;
    }

    public function getHerbalTax2($clinical_sale_id) {
        $sql = "SELECT *
				FROM " . DB_PREFIX . "clinical_sale_total
				WHERE id = '1'
				AND clinical_sale_id = '" . (int) $clinical_sale_id . "'";

        $query = $this->db->query($sql);

        $tax_rows = $query->rows;
        $tax_gst = 0;
        $tax_2 = 0;

        foreach ($tax_rows as $tax) {
            if ($tax['code'] == 'tax') {
                $tax_gst += $tax['value'];
            }

            /* if($tax['code'] == 'rounding'){
              $rounding = $tax['value'];
              } */
        }

        $tax_2 = /* $rounding + */ $tax_gst;

        return $tax_2;
    }

    public function complete_order($order_id, $invoice_prefix, $module, $store_id) {
        $sql = "UPDATE " . DB_PREFIX . "order SET invoice_prefix = '" . $this->db->escape($invoice_prefix) . "', order_status_id = '5', date_added = NOW() WHERE order_id = '" . (int) $order_id . "'";

        $query = $this->db->query($sql);

        $this->db->query("INSERT INTO " . DB_PREFIX . "order_history SET order_id = '" . (int) $order_id . "', order_status_id = '5', notify = '0', comment = '', date_added = NOW()");

        $this->db->query("UPDATE " . DB_PREFIX . "transaction_no SET lastrunningno = lastrunningno + 1 WHERE module='" . $this->db->escape($module) . "' AND store_id = '" . (int) $store_id . "'");
    }

    public function getCarriers() {
        $sql = "SELECT * FROM " . DB_PREFIX . "order_tracking_carriers";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getCarrier($carrier_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "order_tracking_carriers WHERE carrier_id = '" . (int) $carrier_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function update_carrier($order_id, $carrier_id, $tracking_number, $order_status_id) {
        $sql = "UPDATE " . DB_PREFIX . "order SET carrier_id = '" . (int) $carrier_id . "', tracking_number = '" . $this->db->escape($tracking_number) . "' WHERE order_id = '" . (int) $order_id . "'";

        $order_info = $this->getOrder($order_id);

        $status_id = $order_status_id;

        if ($order_info && empty($order_info['invoice_prefix']) && (in_array($status_id, $this->config->get('config_complete_status')))) {

            $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'pos/pos', 'store' => $this->session->data['store_id']));

            $this->db->query("UPDATE " . DB_PREFIX . "order SET invoice_prefix = '" . $invoice_prefix . "' WHERE order_id = '" . $order_id . "'");

            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'pos/pos', 'store' => $this->session->data['store_id']));
        }

        $query = $this->db->query($sql);
    }

    public function add_order_history($order_id, $order_status_id, $comment, $notify, $tracking_number, $carrier_id) {
        $sql = "INSERT INTO " . DB_PREFIX . "order_history SET order_id = '" . (int) $order_id . "', order_status_id = '" . (int) $order_status_id . "', tracking_number = '" . (int) $tracking_number . "', carrier_id = '" . (int) $carrier_id . "', notify = '" . (int) $notify . "', comment = '" . $this->db->escape($comment) . "', date_added = NOW()";

        $query = $this->db->query($sql);

        return $this->db->getLastId();
    }

    public function get_order_by_order_id($order_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "order WHERE order_id = '" . $this->db->escape($order_id) . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getCourierService($name) {
        $sql = "SELECT * FROM " . DB_PREFIX . "order_tracking_carriers WHERE name = '" . $this->db->escape($name) . "' ";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function updateOrderTracking($data) {
        $store_id = $this->session->data['store_id'];

        if (!empty($data)) {
            foreach ($data as $item) {
                $this->db->query("UPDATE " . DB_PREFIX . "order SET
                        carrier_id = '" . (int) $this->db->escape($item['carrier_id']) . "',
                        tracking_number = '" . $this->db->escape($item['tracking_number']) . "'
                        WHERE order_id = '" . (int) $item['order_id'] . "'    
                        AND store_id = '" . (int) $store_id . "'");
            }
        }
    }

    public function orderInvoiceDate($order_id, $order_status_id) {

        $sql = "SELECT MIN(date_added) AS date_added FROM " . DB_PREFIX . "order_history WHERE order_id = '" . (int) $order_id . "' AND order_status_id = '" . (int) $order_status_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getOrderStatus($order_id) {
        $sql = "SELECT order_status_id FROM " . DB_PREFIX . "order WHERE 1 AND order_id = '" . (int) $order_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }
    
    public function getTrackingURL($courier_name) {
        $sql = "SELECT url FROM " . DB_PREFIX . "carriers WHERE name = '" . $this->db->escape($courier_name) . "'";
        
        $query = $this->db->query($sql);

        return !empty($query->row) ? $query->row['url'] : '';
    }
    
    public function getCustomerInfo($customer_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int) $customer_id . "'";
        
        $query = $this->db->query($sql);

        return $query->row;
    }

}
