<?php
class ModelSaleSendSms extends Model{
    public function get_autocomplete_customers($data){
        $sql = "SELECT *, CONCAT(firstname, ' ', lastname) AS customer_name FROM " . DB_PREFIX . "customer";

		$implode = array();

		if (!empty($data['filter_name'])) {
			$implode[] = "CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
		}

		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}

		$sort_data = array(
			'customer_name',
			'telephone'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY customer_name";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}
	
	public function get_customers($data){
		$sql = "SELECT c.customer_id, c.telephone, CONCAT(c.firstname, ' ', c.lastname) AS customer_name FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "address a ON a.customer_id = c.customer_id AND a.address_id = c.address_id WHERE 1";

		if(isset($data['customer_group_id']) && ($data['customer_group_id'] > 0)){
			$sql .= " AND c.customer_group_id = '" . (int)$data['customer_group_id'] . "'";
		}

		if(isset($data['country_id']) && ($data['country_id'] > 0)){
			$sql .= " AND a.country_id = '" . (int)$data['country_id'] . "'";
		}

		if(isset($data['zone_id']) && ($data['zone_id'] > 0)){
			$sql .= " AND a.zone_id = '" . (int)$data['zone_id'] . "'";
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function get_customer_by_id($customer_id){
		$sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int)$customer_id . "'";

		$query = $this->db->query($sql);

		return $query->row;
	}

	public function add_sms_history($data, $recipient_data){
		$recipient_data = serialize($recipient_data);
		
		$sql = "INSERT INTO " . DB_PREFIX . "sms_history SET send_method = '" . $this->db->escape($data['send_by']) . "', recipient_data = '" . $this->db->escape($recipient_data) . "', message = '" . $this->db->escape($data['message']) . "', send_by = '" . (int)$this->session->data['user_id'] . "', date_added = NOW()";

		$query = $this->db->query($sql);

		return $this->db->getLastId();
	}

	public function get_sms_histories($data){
        $sql = "SELECT * FROM " . DB_PREFIX . "sms_history WHERE 1";

        $implode = [];

        if (!empty($data['filter_date_added_from'])) {
			$implode[] = "DATE(date_added) >= DATE('" . $this->db->escape($data['filter_date_added_from']) . "')";
        }
        
        if (!empty($data['filter_date_added_to'])) {
			$implode[] = "DATE(date_added) <= DATE('" . $this->db->escape($data['filter_date_added_to']) . "')";
        }
        
        if (!empty($data['filter_send_by'])) {
			$implode[] = "send_method = '" . $this->db->escape($data['filter_send_by']) . "'";
        }
        
        if (!empty($data['filter_message'])) {
			$implode[] = "message LIKE '%" . $this->db->escape($data['filter_message']) . "%'";
		}

		if ($implode) {
			$sql .= " AND " . implode(" AND ", $implode);
        }
        
        $sort_data = array(
			'send_method',
			'date_added',
			'message'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY date_added";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }
        
        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function get_total_sms_histories($data){
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "sms_history WHERE 1";

        $implode = [];

        if (!empty($data['filter_date_added_from'])) {
			$implode[] = "DATE(date_added) >= DATE('" . $this->db->escape($data['filter_date_added_from']) . "')";
        }
        
        if (!empty($data['filter_date_added_to'])) {
			$implode[] = "DATE(date_added) <= DATE('" . $this->db->escape($data['filter_date_added_to']) . "')";
        }
        
        if (!empty($data['filter_send_by'])) {
			$implode[] = "send_method = '" . $this->db->escape($data['filter_send_by']) . "'";
        }
        
        if (!empty($data['filter_message'])) {
			$implode[] = "message LIKE '%" . $this->db->escape($data['filter_message']) . "%'";
		}

		if ($implode) {
			$sql .= " AND " . implode(" AND ", $implode);
        }
        
        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function get_sms_history($sms_history_id){
        $sql = "SELECT * FROM " . DB_PREFIX . "sms_history WHERE sms_history_id = '" . (int)$sms_history_id . "'";
        
        $query = $this->db->query($sql);

        return $query->row;
	}
	
	public function delete_sms_history($sms_history_id){
		$sql = "DELETE FROM " . DB_PREFIX . "sms_history WHERE sms_history_id = '" . (int)$sms_history_id . "'";
        
        $query = $this->db->query($sql);
	}
}
?>