<?php
class ModelSalePurchaseRequest extends Model {
    public function addPurchaseRequest($data, $cart = array()) {
        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'sale/purchase_request', 'store' => $this->session->data['store_id']));

        $store_id = $this->session->data['store_id'];

        $this->load->model('localisation/currency');
        $currency_info = $this->model_localisation_currency->getCurrencyByCode($this->config->get('config_currency'));

        $sql = "
		INSERT INTO " . DB_PREFIX . "purchase_request SET
			invoice_prefix = '" . $this->db->escape($invoice_prefix) . "',
			store_id = '" . (int)$store_id . "',
			comment = '" . $this->db->escape($data['comment']) . "',
			order_status_id = '" . (int)$data['order_status_id'] . "',
			currency_id = '" . (int)$currency_info['currency_id'] . "',
			currency_code = '" . $currency_info['code'] . "',
			currency_value = '" . (int)$currency_info['value'] . "',
			date_added = NOW(),
			add_by = '" . (int)$this->session->data['user_id'] . "',
			date_modified = NOW(),
			modify_by = '" . (int)$this->session->data['user_id'] . "'
		";

        $query = $this->db->query($sql);

        $purchase_request_id = $this->db->getLastId();

        if ($purchase_request_id != 0) {
            foreach ($cart->getProducts() as $product_id => $product) {
                $sql = "
				INSERT INTO " . DB_PREFIX . "purchase_request_product SET
				purchase_request_id 	= '" . (int)$purchase_request_id . "',
				product_id				= '" . (int)$product_id . "',
				name					= '" . $this->db->escape($product['name']) . "',
				code					= '" . $this->db->escape($product['code']) . "',
				model					= '" . $this->db->escape($product['model']) . "',
				quantity				= '" . (float)$product['quantity'] . "',
				tax_class_id			= '" . (int)$product['tax_class_id'] . "',
				tax_code				= '" . $this->db->escape($product['tax_code']) . "',
				tax_format				= '" . $this->db->escape($product['tax_format']) . "',
				price					= '" . (float)$product['costprice'] . "',
				net_amount				= '" . (float)$this->db->escape($product['costprice']) . "',
				total_net_amount		= '" . (float)$product['net_amount'] . "',
				total					= '" . (float)$product['total'] . "',
				total_tax				= '" . (float)$product['tax'] . "'
				";
                $this->db->query($sql);
            }

            //insert supplier
            foreach ($data['supplies'] as $counter => $supplier) {
                $sql = "
				INSERT INTO " . DB_PREFIX . "purchase_request_manufacturer SET
				purchase_request_id = '" . (int)$purchase_request_id . "',
				manufacturer_id = '" . (int)$supplier['manufacturer_id'] . "',
				status = '1',
				date_added = NOW(),
				add_by = '" . (int)$this->session->data['user_id'] . "',
				date_modified = NOW(),
				modify_by = '" . (int)$this->session->data['user_id'] . "'";

                $this->db->query($sql);

                foreach ($cart->getProducts() as $product_id => $product) {
                    $sql = "
					INSERT INTO " . DB_PREFIX . "purchase_request_manufacturer_price SET
					purchase_request_id 	= '" . (int)$purchase_request_id . "',
					product_id				= '" . (int)$product_id . "',
					manufacturer_id = '" . (int)$supplier['manufacturer_id'] . "',
					tax_class_id			= '" . (int)$product['tax_class_id'] . "',
					tax_code				= '" . $this->db->escape($product['tax_code']) . "',
					tax_format				= '" . $this->db->escape($product['tax_format']) . "',
					price					= '" . (float)$product['custom_price'] . "',
					revise					= '" . (float)$product['custom_price'] . "',
					net_amount				= '" . (float)$this->db->escape($product['custom_price']) . "',
					total_net_amount		= '" . (float)$product['net_amount'] . "',
					total					= '" . (float)$product['total'] . "',
					total_tax				= '" . (float)$product['tax'] . "'
					";
                    $this->db->query($sql);
                }
            }

            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'sale/purchase_request', 'store' => $this->session->data['store_id']));
        }

		return $purchase_request_id;
    }

    public function editPurchaseRequest($purchase_request_id, $data = array(), $cart = array()) {

        $sql = "
		UPDATE " . DB_PREFIX . "purchase_request SET
			comment = '" . $this->db->escape($data['comment']) . "',
			order_status_id = '" . (int)$data['order_status_id'] . "',
			date_modified = NOW(),
			modify_by = '" . (int)$this->session->data['user_id'] . "'
		WHERE purchase_request_id = '" . (int)$purchase_request_id . "'
		";
        $this->db->query($sql);


        $sql = "
		DELETE FROM " . DB_PREFIX . "purchase_request_manufacturer 
		WHERE purchase_request_id = '" . (int)$purchase_request_id . "'
		";
        $this->db->query($sql);

        $sql = "
		DELETE FROM " . DB_PREFIX . "purchase_request_manufacturer_price
		WHERE purchase_request_id = '" . (int)$purchase_request_id . "'
		";
        $this->db->query($sql);

        $sql = "
		DELETE FROM " . DB_PREFIX . "purchase_request_product 
		WHERE purchase_request_id = '" . (int)$purchase_request_id . "'
		";
        $this->db->query($sql);

        foreach ($data['supplies'] as $counter => $supplier) {
            $sql = "
			INSERT INTO " . DB_PREFIX . "purchase_request_manufacturer SET
			purchase_request_id = '" . (int)$purchase_request_id . "',
			manufacturer_id = '" . (int)$supplier['manufacturer_id'] . "',
			status = '1',
			date_added = NOW(),
			add_by = '" . (int)$this->session->data['user_id'] . "'";

            $this->db->query($sql);

            foreach ($cart->getProducts() as $product_id => $product) {
                $sql = "
				INSERT INTO " . DB_PREFIX . "purchase_request_manufacturer_price SET
				purchase_request_id 	= '" . (int)$purchase_request_id . "',
				product_id				= '" . (int)$product_id . "',
				manufacturer_id 		= '" . (int)$supplier['manufacturer_id'] . "',
				tax_class_id			= '" . (int)$product['tax_class_id'] . "',
				tax_code				= '" . $this->db->escape($product['tax_code']) . "',
				tax_format				= '" . $this->db->escape($product['tax_format']) . "',
				price					= '" . (float)$product['custom_price'] . "',
				net_amount				= '" . (float)$this->db->escape($product['custom_price']) . "',
				total_net_amount		= '" . (float)$product['net_amount'] . "',
				total					= '" . (float)$product['total'] . "',
				total_tax				= '" . (float)$product['tax'] . "'
				";
                $this->db->query($sql);
            }
        }

        foreach ($cart->getProducts() as $product_id => $product) {
            $sql = "
			INSERT INTO " . DB_PREFIX . "purchase_request_product SET
			purchase_request_id 	= '" . (int)$purchase_request_id . "',
			product_id			= '" . (int)$product_id . "',
			name				= '" . $this->db->escape($product['name']) . "',
			code				= '" . $this->db->escape($product['code']) . "',
			model				= '" . $this->db->escape($product['model']) . "',
			quantity			= '" . (float)$product['quantity'] . "',
			tax_class_id		= '" . (int)$product['tax_class_id'] . "',
			tax_code			= '" . $this->db->escape($product['tax_code']) . "',
			tax_format			= '" . $this->db->escape($product['tax_format']) . "',
			weight				= '" . (float)$product['weight'] . "',
			weight_class_id		= '" . (int)$product['weight_class_id'] . "',
			price				= '" . (float)$product['costprice'] . "',
			net_amount			= '" . (float)$this->db->escape($product['costprice']) . "',
			total_net_amount	= '" . (float)$product['net_amount'] . "',
			total				= '" . (float)$product['total'] . "',
			total_tax			= '" . (float)$product['tax'] . "'
			";

            $this->db->query($sql);
        }
    }

    public function editPurchaseRequestStatus($pruchase_request_id, $data = array()) {
        $order_status_id = isset($data['order_status_id']) ? $data['order_status_id'] : false;

        if ($order_status_id) {
            $sql = "
			UPDATE " . DB_PREFIX . "purchase_request SET
				order_status_id = '" . (int)$data['order_status_id'] . "',
				date_modified = NOW(),
				modify_by = '" . (int)$this->session->data['user_id'] . "'
			WHERE purchase_request_id = '" . (int)$pruchase_request_id . "'
			";
            $this->db->query($sql);

            if ($order_status_id == 5) {
                $sql = "
				UPDATE " . DB_PREFIX . "purchase_request_manufacturer SET
					status = '7',
					date_modified = NOW(),
					modify_by = '" . (int)$this->session->data['user_id'] . "'
				WHERE 1
				AND status = '1' 
				AND purchase_request_id = '" . (int)$pruchase_request_id . "'
				";
                $this->db->query($sql);

                $sql = "
				UPDATE " . DB_PREFIX . "purchase_request_manufacturer SET
					status = '5',
					date_modified = NOW(),
					modify_by = '" . (int)$this->session->data['user_id'] . "'
				WHERE 1
				AND status = '19' 
				AND purchase_request_id = '" . (int)$pruchase_request_id . "'
				";
                $this->db->query($sql);
            }
        }
    }

    public function purchaseRequestSupplierRevise($purchase_request_id, $data = array()) {

        $manufacturer_id = isset($data['manufacturer_id']) ? $data['manufacturer_id'] : 0;
        $revises = isset($data['revise']) ? $data['revise'] : array();

        if ($revises) {
            $sql = "
			UPDATE " . DB_PREFIX . "purchase_request_manufacturer SET
				status = '19',
				num_revise = num_revise + 1
			WHERE 1
			AND purchase_request_id = '" . (int)$purchase_request_id . "'
			AND manufacturer_id = '" . (int)$manufacturer_id . "'
			";

            $this->db->query($sql);

            foreach ($revises as $product_id => $revise) {
                $sql = "
				UPDATE " . DB_PREFIX . "purchase_request_manufacturer_price SET
					revise = '" . (float)$revise . "' 
				WHERE 1
				AND purchase_request_id = '" . (int)$purchase_request_id . "'
				AND manufacturer_id = '" . (int)$manufacturer_id . "'
				AND product_id = '" . (int)$product_id . "'
				";

                $this->db->query($sql);
            }
        }
    }

    public function getPurchaseRequest($purchase_request_id) {
        $language_id = $this->config->get('config_language_id');

        $result = array();

        $sql = "
		SELECT 
			pr.*,
			os.name AS order_status
		FROM " . DB_PREFIX . "purchase_request pr
		LEFT JOIN " . DB_PREFIX . "order_status os
		ON pr.order_status_id = os.order_status_id
		AND os.language_id = '" . (int)$language_id . "'
		WHERE purchase_request_id = '" . (int)$purchase_request_id . "'
		";
        $query = $this->db->query($sql);
        $result = $query->row;

        $sql = "
		SELECT
			prm.*,
			m.name AS manufacturer_name,
			m.code AS manufacturer_code,
			os.name AS status_name
		FROM " . DB_PREFIX . "purchase_request_manufacturer prm
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON prm.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "order_status os
		ON prm.status = os.order_status_id
		AND os.language_id = '" . (int)$language_id . "'
		WHERE prm.purchase_request_id = '" . (int)$purchase_request_id . "'";
        $query = $this->db->query($sql);
        $result['supplies'] = $query->rows;

        $sql = "
		SELECT *
		FROM " . DB_PREFIX . "purchase_request_product
		WHERE purchase_request_id = '" . (int)$purchase_request_id . "'";
        $query = $this->db->query($sql);
        $result['products'] = $query->rows;

        return $result;
    }

    public function getRespondPurchaseRequestSuppliesInfo($purchase_request_id) {
        $language_id = $this->config->get('config_language_id');

        $result = array();

        $sql = "
		SELECT 
			prm.*,
			m.name,
			m.code,
			prm.num_revise,
			CONCAT(u.firstname, ' ', u.lastname) AS personincharge,
			os.name AS status_name
		FROM " . DB_PREFIX . "purchase_request_manufacturer prm
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON prm.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "order_status os
		ON prm.status = os.order_status_id
		AND os.language_id = '" . (int)$language_id . "'
		LEFT JOIN " . DB_PREFIX . "user u
		ON m.user_id = u.user_id
		WHERE 1
		AND prm.purchase_request_id = '" . (int)$purchase_request_id . "'
		";
        $query = $this->db->query($sql);

        foreach ($query->rows as $supplier) {

            $sql = "
			SELECT 
				prp.name,
				prp.code,
				prp.quantity,
				prmp.* 
			FROM " . DB_PREFIX . "purchase_request_manufacturer_price prmp
			LEFT JOIN " . DB_PREFIX . "purchase_request_product prp
			ON prmp.product_id = prp.product_id
			AND prmp.purchase_request_id = prp.purchase_request_id
			WHERE 1
			AND prmp.purchase_request_id = '" . (int)$purchase_request_id . "'
			AND prmp.manufacturer_id = '" . (int)$supplier['manufacturer_id'] . "'
			";
            $supplier_query = $this->db->query($sql);

            $sql = "
			SELECT *
			FROM " . DB_PREFIX . "purchase_request_total
			WHERE 1
			AND purchase_request_id = '" . (int)$purchase_request_id . "'
			AND manufacturer_id = '" . (int)$supplier['manufacturer_id'] . "'
			";
            $total_query = $this->db->query($sql);

            $result[$supplier['manufacturer_id']] = array(
                'manufacturer_id' => $supplier['manufacturer_id'],
                'name' => $supplier['name'],
                'code' => $supplier['code'],
                'personincharge' => $supplier['personincharge'],
                'status' => $supplier['status'],
                'status_name' => $supplier['status_name'],
                'num_revise' => $supplier['num_revise'],
                'products' => $supplier_query->rows,
                'total' => $total_query->rows
            );
        }

        return $result;
    }

    public function getPurchaseRequests($data = array()) {
        $language_id = $this->config->get('config_language_id');

        $sort = isset($data['sort']) ? $data['sort'] : "purchase_request_id";
        $order = isset($data['order']) ? $data['order'] : "DESC";

        $filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
                "AND pr.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
                "";

        $filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
                "AND pr.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
                "";
        
        $filter_manufacturer_prefix = (!empty($data['filter_transaction'])) ?
                "AND pr.invoice_prefix LIKE '%" . $this->db->escape($data['filter_transaction']) . "%'" :
                "";

        $filter_order_status_id_statement = (!empty($data['filter_order_status'])) ?
                "AND pr.order_status_id = '" . (int)$data['filter_order_status'] . "'" :
                "";

        $filter_manufactuerer_id = (!empty($data['filter_manufacturer_id'])) ?
                " AND manufacturer_id = '" . (int)$data['filter_manufacturer_id'] . "'" :
                "";

        $filter_manufacturer_status = (!empty($data['filter_manufacturer_status'])) ?
                "AND status = '" . (int)$data['filter_manufacturer_status'] . "'" :
                "";

        $filter_manufacturer_statement = ($filter_manufactuerer_id || $filter_manufacturer_status) ?
                "
		AND pr.purchase_request_id IN (
			SELECT DISTINCT purchase_request_id 
			FROM " . DB_PREFIX . "purchase_request_manufacturer 
			WHERE 1
			$filter_manufactuerer_id
			$filter_manufacturer_status
		)
		" : "";

        $limit_statement = "";

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $sql = "
		SELECT 
			pr.*, prm.manufacturer_id, po.order_status_id AS exist_status,
			os.name AS order_status,
			(
				SELECT COUNT(*) 
				FROM " . DB_PREFIX . "purchase_request_manufacturer
				WHERE purchase_request_id = pr.purchase_request_id
			) AS total_supplier,
			os.name AS order_status,
			(
				SELECT COUNT(*) 
				FROM " . DB_PREFIX . "purchase_request_manufacturer
				WHERE purchase_request_id = pr.purchase_request_id
			) AS total_supplier,
			(
				SELECT COUNT(*) 
				FROM " . DB_PREFIX . "purchase_request_manufacturer
				WHERE purchase_request_id = pr.purchase_request_id
				AND status IN (5, 19)
			) AS total_supplier_respond
		FROM " . DB_PREFIX . "purchase_request pr
		LEFT JOIN " . DB_PREFIX . "order_status os 
		ON pr.order_status_id = os.order_status_id
                LEFT JOIN " . DB_PREFIX . "purchase_request_manufacturer prm
                ON pr.purchase_request_id = prm.purchase_request_id
                LEFT JOIN " . DB_PREFIX . "purchase_order po
                ON pr.purchase_request_id = po.purchase_request_id    
		WHERE 1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_order_status_id_statement
		$filter_manufacturer_statement
                $filter_manufacturer_prefix 
		AND os.language_id = '" . (int)$language_id . "'
		ORDER BY $sort $order
		$limit_statement
		";
        
        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalPurchaseRequest($data = array()) {
        $language_id = $this->config->get('config_language_id');

        $filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
                "AND invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
                "";

        $filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
                "AND invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
                "";

        $filter_order_status_id_statement = (!empty($data['filter_order_status'])) ?
                "AND order_status_id = '" . (int)$data['filter_order_status'] . "'" :
                "";

        $filter_manufactuerer_id = (!empty($data['filter_manufacturer_id'])) ?
                "AND manufacturer_id = '" . (int)$data['filter_manufacturer_id'] . "'" :
                "";

        $filter_manufacturer_status = (!empty($data['filter_manufacturer_status'])) ?
                "AND status = '" . (int)$data['filter_manufacturer_status'] . "'" :
                "";

        $filter_manufacturer_statement = ($filter_manufactuerer_id || $filter_manufacturer_status) ?
                "
		AND purchase_request_id IN (
			SELECT DISTINCT purchase_request_id 
			FROM " . DB_PREFIX . "purchase_request_manufacturer 
			WHERE 1
			$filter_manufactuerer_id
			$filter_manufacturer_status
		)
		" : "";

        $sql = "
		SELECT COUNT(*) AS total
		FROM " . DB_PREFIX . "purchase_request
		WHERE 1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_order_status_id_statement
		$filter_manufacturer_statement
		";

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getPurchaseRequestItemsArray($purchase_request_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "purchase_request_product WHERE purchase_request_id = '" . (int)$purchase_request_id . "'";

        $query = $this->db->query($sql);

        $result = array();

        foreach ($query->rows as $item)
            $result[$item['product_id']] = $item['quantity'];

        return $result;
    }

    public function getPurchaseRequestItems($purchase_request_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "purchase_request_product WHERE purchase_request_id = '" . (int)$purchase_request_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getPurchaseRequestTotals($purchase_request_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "purchase_request_total WHERE purchase_request_id = '" . (int)$purchase_request_id . "' ORDER BY sort_order");

        return $query->rows;
    }

    public function purchaseRequestExistsById($purchase_request_id) {
        $sql = "
		SELECT COUNT(*) AS num 
		FROM " . DB_PREFIX . "purchase_request 
		WHERE purchase_request_id = '" . (int)$purchase_request_id . "'";

        $query = $this->db->query($sql);
        return $query->row['num'] > 0;
    }
}
?>