<?php

class ModelSalePurchaseQuotation extends Model {

    public function editPurchaseQuotation($purchase_request_id, $data, $cart = array(), $taxes = array()) {
        $manufacturer_id = $this->getManufacturerId($this->session->data['user_id']);
        $first_process = false;

        $sql = "
		SELECT status 
		FROM " . DB_PREFIX . "purchase_request_manufacturer 
		WHERE 1
		AND purchase_request_id = '" . (int) $purchase_request_id . "'
		AND manufacturer_id = '" . (int) $manufacturer_id . "'
		";
        $query = $this->db->query($sql);
        $first_process = $query->row['status'] == 1 ? true : false;

        $sql = "
		UPDATE " . DB_PREFIX . "purchase_request_manufacturer SET
			status = '" . (int) $data['status'] . "',
			date_modified = NOW(),
			modify_by = '" . (int) $this->session->data['user_id'] . "'
		WHERE 1
		AND purchase_request_id = '" . (int) $purchase_request_id . "'
		AND manufacturer_id = '" . (int) $manufacturer_id . "'
		";
        $this->db->query($sql);

        foreach ($cart->getProducts() as $product_id => $product) {
            $sql = "
			UPDATE " . DB_PREFIX . "purchase_request_manufacturer_price SET
				tax_class_id			= '" . (int) $product['tax_class_id'] . "',
				tax_code				= '" . $this->db->escape($product['tax_code']) . "',
				tax_format				= '" . $this->db->escape($product['tax_format']) . "',
				price					= '" . (float) $product['custom_price'] . "',
				net_amount				= '" . (float) $this->db->escape($product['custom_price']) . "',
				total_net_amount		= '" . (float) $product['net_amount'] . "',
				total					= '" . (float) $product['total'] . "',
				total_tax				= '" . (float) $product['tax'] . "'
			WHERE 1
			AND purchase_request_id = '" . (int) $purchase_request_id . "'
			AND manufacturer_id = '" . (int) $manufacturer_id . "'
			AND product_id = '" . (int) $product_id . "'
			";
            $this->db->query($sql);

            if ($first_process) {
                $sql = "
				UPDATE " . DB_PREFIX . "purchase_request_manufacturer_price SET
					revise = '" . (float) $product['custom_price'] . "'
				WHERE 1
				AND purchase_request_id = '" . (int) $purchase_request_id . "'
				AND manufacturer_id = '" . (int) $manufacturer_id . "'
				AND product_id = '" . (int) $product_id . "'
				";
                $this->db->query($sql);
            }
        }


        $this->db->query("DELETE FROM " . DB_PREFIX . "purchase_request_total WHERE purchase_request_id = '" . (int) $purchase_request_id . "' AND manufacturer_id = '" . (int) $manufacturer_id . "' AND id ='1' ");

        if (isset($taxes)) {
            foreach ($taxes as $order_total) {
                $this->db->query("
				INSERT INTO " . DB_PREFIX . "purchase_request_total 
				SET 
				purchase_request_id = '" . (int) $purchase_request_id . "',
				manufacturer_id = '" . (int) $manufacturer_id . "',
				id ='1', 
				code = '" . $this->db->escape($order_total['code']) . "',
				tax_code = '" . $this->db->escape($order_total['tax_code']) . "', 
				tax_key = '" . (int) $order_total['key'] . "',
				title = '" . $this->db->escape($order_total['title']) . "',  
				`value` = '" . (float) $order_total['value'] . "', 
				sort_order = '" . (int) $order_total['sort_order'] . "'
				");
            }
        }
    }

    public function getPurchaseQuotations($data = array()) {
        $language_id = $this->config->get('config_language_id');
        $manufacturer_id = $this->getManufacturerId($this->session->data['user_id']);

        $sort = isset($data['sort']) ? $data['sort'] : "purchase_request_id";
        $order = isset($data['order']) ? $data['order'] : "DESC";

        $filter_transaction_start_statement = isset($data['filter_transaction_start']) ? "AND pr.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : "";

        $filter_transaction_end_statement = isset($data['filter_transaction_end']) ? "AND pr.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : "";

        $filter_manufacturer_status_statement = isset($data['filter_manufacturer_status']) ? "AND prm.status = '" . (int) $data['filter_manufacturer_status'] . "'" : "";

        $limit_statement = "";

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $limit_statement = "LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $sql = "
		SELECT 
			pr.*,
			pr_os.name AS order_status,
			prm.status AS manufacturer_status_id,
			prm_os.name AS manufacturer_status
		FROM " . DB_PREFIX . "purchase_request pr
		LEFT JOIN " . DB_PREFIX . "purchase_request_manufacturer prm
		ON pr.purchase_request_id = prm.purchase_request_id
		LEFT JOIN " . DB_PREFIX . "order_status pr_os
		ON pr.order_status_id = pr_os.order_status_id
		AND pr_os.language_id = '" . (int) $language_id . "'
		LEFT JOIN " . DB_PREFIX . "order_status prm_os
		ON prm.status = prm_os.order_status_id
		AND prm_os.language_id = '" . (int) $language_id . "'
		WHERE 1
		AND pr.order_status_id NOT IN('1', '7') 
		AND prm.manufacturer_id = '" . (int) $manufacturer_id . "'
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_manufacturer_status_statement
		ORDER BY " . $this->db->escape($sort) . " " . $this->db->escape($order) . "
		$limit_statement
		";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getTotalPurchaseQuotation($data = array()) {
        $manufacturer_id = $this->getManufacturerId($this->session->data['user_id']);

        $filter_transaction_start_statement = isset($data['filter_transaction_start']) ? "AND pr.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : "";

        $filter_transaction_end_statement = isset($data['filter_transaction_end']) ? "AND pr.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : "";

        $filter_manufacturer_status_statement = isset($data['filter_manufacturer_status']) ? "AND prm.status = '" . (int) $data['filter_manufacturer_status'] . "'" : "";

        $sql = "
		SELECT 
			COUNT(*) AS num
		FROM " . DB_PREFIX . "purchase_request pr
		LEFT JOIN " . DB_PREFIX . "purchase_request_manufacturer prm
		ON pr.purchase_request_id = prm.purchase_request_id
		WHERE 1
		AND pr.order_status_id NOT IN('1', '7') 
		AND prm.manufacturer_id = '" . (int) $manufacturer_id . "'
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_manufacturer_status_statement";

        $query = $this->db->query($sql);
        return $query->row['num'];
    }

    public function getPurchaseQuotation($purchase_quotation_id) {
        $language_id = $this->config->get('config_language_id');
        $manufacturer_id = $this->getManufacturerId($this->session->data['user_id']);

        $sql = "
		SELECT 
			pr.*,
			pr_os.name AS order_status,
			prm.status AS manufacturer_status_id,
			prm_os.name AS manufacturer_status
		FROM " . DB_PREFIX . "purchase_request pr
		LEFT JOIN " . DB_PREFIX . "purchase_request_manufacturer prm
		ON pr.purchase_request_id = prm.purchase_request_id
		LEFT JOIN " . DB_PREFIX . "order_status pr_os
		ON pr.order_status_id = pr_os.order_status_id
		AND pr_os.language_id = '" . (int) $language_id . "'
		LEFT JOIN " . DB_PREFIX . "order_status prm_os
		ON prm.status = prm_os.order_status_id
		AND prm_os.language_id = '" . (int) $language_id . "'
		WHERE 1
		AND pr.purchase_request_id = '" . $purchase_quotation_id . "'
		AND prm.manufacturer_id = '" . (int) $manufacturer_id . "'
		";

        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getManufacturerId($user_id) {
        $sql = "
		SELECT manufacturer_id
		FROM " . DB_PREFIX . "manufacturer
		WHERE user_id = '" . (int) $user_id . "'
		";

        $query = $this->db->query($sql);
        return isset($query->row['manufacturer_id']) ? $query->row['manufacturer_id'] : 0;
    }

    public function getPurchaseRequestItemsArray($purchase_request_id) {
        $manufacturer_id = $this->getManufacturerId($this->session->data['user_id']);

        $sql = "
		SELECT
			prmp.product_id,
			prp.quantity,
			prmp.price
		FROM " . DB_PREFIX . "purchase_request_manufacturer_price prmp
		LEFT JOIN " . DB_PREFIX . "purchase_request_product prp
		ON prmp.product_id = prp.product_id
		WHERE 1
		AND prmp.purchase_request_id = '" . (int) $purchase_request_id . "'
		AND prmp.manufacturer_id = '" . (int) $manufacturer_id . "'";

        $query = $this->db->query($sql);

        $result = array();

        foreach ($query->rows as $item)
            $result[$item['product_id']] = array(
                'quantity' => $item['quantity'],
                'price' => $item['price']
            );

        return $result;
    }

    public function getPurchaseRequestRevice($purchase_request_id, $product_id, $manufacturer_id) {
        $sql = "
		SELECT revise
		FROM " . DB_PREFIX . "purchase_request_manufacturer_price
		WHERE 1
		AND purchase_request_id = '" . (int) $purchase_request_id . "'
		AND product_id = '" . (int) $product_id . "'
		AND manufacturer_id = '" . (int) $manufacturer_id . "'
		";

        $query = $this->db->query($sql);
        return $query->row['revise'];
    }
}
?>