<?php

class ModelSaleOrderWholesaler extends Model
{
    private $custom_payment_methods = [
        'pay_by_cash' => [
            'extension_id' => 0,
            'type' => 'payment',
            'code' => 'pay_by_cash',
            'sort_order' => 0,
            'title' => 'Cash'
        ],
        'pay_by_card' => [
            'extension_id' => 0,
            'type' => 'payment',
            'code' => 'pay_by_card',
            'sort_order' => 0,
            'title' => 'Card'
        ],
    ];

    public function getOrderByInvoicePrefix($invoice_prefix)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order WHERE invoice_prefix = '" . $this->db->escape($invoice_prefix) . "'");
        return $query->row;
    }


    public function __construct($registry)
    {
        parent::__construct($registry);

        $this->load->model('extension/extension');
    }

    public function getPaymentMethods($custom_payments = true)
    {
        $this->load->language('sale/order_wholesaler');

        $payment_methods = [];

        $sql = "
            SELECT * FROM `" . DB_PREFIX . "customer_payment_method` WHERE 1 AND language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY `sort_order` ASC, `payment_method_name` ASC
        ";
        $query = $this->db->query($sql);
        $payment_method_data = $query->rows;
        foreach ($payment_method_data as $pmd) {
            $payment_methods[$pmd['code']] = [
                'code' => $pmd['code'],
                'title' => $pmd['payment_method_name']
            ];
        }

        /*$results = $this->model_extension_extension->getExtensions('payment');

        foreach ($results as $result) {
            if ($this->config->get($result['code'] . '_status')) {
                $payment_methods[$result['code']] = $result;
                $payment_methods[$result['code']]['sort_order'] = $this->config->get($result['code'] . '_sort_order');

                $language = new Language();
                $language->load('extension/payment/' . $result['code']);
                $payment_methods[$result['code']]['title'] = $language->get('heading_title');
            }
        }

        if ($custom_payments) {
            foreach ($this->custom_payment_methods as &$custom_payment_method) {
                $custom_payment_method['title'] = $this->language->get($custom_payment_method['title']);
            }

            $payment_methods = array_merge($payment_methods, $this->custom_payment_methods);
        }*/

        return $payment_methods;
    }

    public function getPaymentMethodName($payment_method = '')
    {
        $payment_name = '';
        if (!empty($payment_method)) {
            $sql = "SELECT payment_method_name AS payment_name FROM `" . DB_PREFIX . "customer_payment_method` WHERE 1 AND `code` = '" . $this->db->escape($payment_method) . "' AND `language_id` = 1 ";
            $query = $this->db->query($sql);
            if ($query->num_rows) {
                $payment_name = $query->row['payment_name'];
            }
        }

        return $payment_name;

        /*if (empty($payment_method)) {
            return NULL;
        }

        $payment_name = '';

        $payment_methods = $this->getPaymentMethods();

        switch ($payment_method) {
            case 'pay_by_cash':
            case 'pay_by_card':
                $payment_name = !empty($payment_methods[$payment_method]) ? $payment_methods[$payment_method]['title'] : '';
                break;
            default:
                $language = new Language();
                $language->load('extension/payment/' . $payment_method);
                $payment_name = $language->get('heading_title');
                break;
        }

        return $payment_name;*/
    }

    public function getOrder($order_id)
    {
        $order_query = $this->db->query("SELECT *, (SELECT CONCAT(c.firstname, ' ', c.lastname) FROM " . DB_PREFIX . "customer c WHERE c.customer_id = o.customer_id) AS customer FROM `" . DB_PREFIX . "order` o WHERE o.order_id = '" . (int) $order_id . "'");

        if ($order_query->num_rows) {
            $reward = 0;

            $order_product_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_product WHERE order_id = '" . (int) $order_id . "'");

            foreach ($order_product_query->rows as $product) {
                $reward += $product['reward'];
            }

            $country_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "country` WHERE country_id = '" . (int) $order_query->row['payment_country_id'] . "'");

            if ($country_query->num_rows) {
                $payment_iso_code_2 = $country_query->row['iso_code_2'];
                $payment_iso_code_3 = $country_query->row['iso_code_3'];
            } else {
                $payment_iso_code_2 = '';
                $payment_iso_code_3 = '';
            }

            $zone_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "zone` WHERE zone_id = '" . (int) $order_query->row['payment_zone_id'] . "'");

            if ($zone_query->num_rows) {
                $payment_zone_code = $zone_query->row['code'];
            } else {
                $payment_zone_code = '';
            }

            $country_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "country` WHERE country_id = '" . (int) $order_query->row['shipping_country_id'] . "'");

            if ($country_query->num_rows) {
                $shipping_iso_code_2 = $country_query->row['iso_code_2'];
                $shipping_iso_code_3 = $country_query->row['iso_code_3'];
            } else {
                $shipping_iso_code_2 = '';
                $shipping_iso_code_3 = '';
            }

            $zone_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "zone` WHERE zone_id = '" . (int) $order_query->row['shipping_zone_id'] . "'");

            if ($zone_query->num_rows) {
                $shipping_zone_code = $zone_query->row['code'];
            } else {
                $shipping_zone_code = '';
            }

            if ($order_query->row['affiliate_id']) {
                $affiliate_id = $order_query->row['affiliate_id'];
            } else {
                $affiliate_id = 0;
            }

            $this->load->model('marketing/affiliate');

            $affiliate_info = $this->model_marketing_affiliate->getAffiliate($affiliate_id);

            if ($affiliate_info) {
                $affiliate_firstname = $affiliate_info['firstname'];
                $affiliate_lastname = $affiliate_info['lastname'];
            } else {
                $affiliate_firstname = '';
                $affiliate_lastname = '';
            }

            $this->load->model('localisation/language');

            $language_info = $this->model_localisation_language->getLanguage($order_query->row['language_id']);


            if ($language_info) {
                $language_code = $language_info['code'];
                //$language_filename = $language_info['filename'];
                $language_filename = '';
                $language_directory = $language_info['directory'];
            } else {
                $language_code = '';
                $language_filename = '';
                $language_directory = '';
            }


            $staff_query = $this->db->query("SELECT firstname FROM `" . DB_PREFIX . "user` WHERE user_id = '" . (int) $order_query->row['user_id'] . "'");

            if ($staff_query->num_rows) {
                $staff_name = $staff_query->row['firstname'];
            } else {
                $staff_name = '';
            }

            return array(
                'order_id'                => $order_query->row['order_id'],
                'invoice_no'              => $order_query->row['invoice_no'],
                'invoice_prefix'          => $order_query->row['invoice_prefix'],
                'store_id'                => $order_query->row['store_id'],
                'store_name'              => $order_query->row['store_name'],
                'staff_name'              => $staff_name,
                'store_url'               => $order_query->row['store_url'],
                'customer_id'             => $order_query->row['customer_id'],
                'customer'                => $order_query->row['customer'],
                'customer_group_id'       => $order_query->row['customer_group_id'],
                'firstname'               => $order_query->row['firstname'],
                'lastname'                => $order_query->row['lastname'],
                'email'                   => $order_query->row['email'],
                'telephone'               => $order_query->row['telephone'],
                'fax'                     => $order_query->row['fax'],
                'card_no'                 => $order_query->row['card_no'],
                'custom_field'            => json_decode($order_query->row['custom_field']),
                'payment_firstname'       => $order_query->row['payment_firstname'],
                'payment_lastname'        => $order_query->row['payment_lastname'],
                'payment_company'         => $order_query->row['payment_company'],
                'payment_address_1'       => $order_query->row['payment_address_1'],
                'payment_address_2'       => $order_query->row['payment_address_2'],
                'payment_postcode'        => $order_query->row['payment_postcode'],
                'payment_city'            => $order_query->row['payment_city'],
                'payment_zone_id'         => $order_query->row['payment_zone_id'],
                'payment_zone'            => $order_query->row['payment_zone'],
                'payment_zone_code'       => $payment_zone_code,
                'payment_country_id'      => $order_query->row['payment_country_id'],
                'payment_country'         => $order_query->row['payment_country'],
                'payment_iso_code_2'      => $payment_iso_code_2,
                'payment_iso_code_3'      => $payment_iso_code_3,
                'payment_address_format'  => $order_query->row['payment_address_format'],
                'payment_custom_field'    => json_decode($order_query->row['payment_custom_field']),
                'payment_method'          => $order_query->row['payment_method'],
                'payment_code'            => $order_query->row['payment_code'],
                'shipping_firstname'      => $order_query->row['shipping_firstname'],
                'shipping_lastname'       => $order_query->row['shipping_lastname'],
                'shipping_company'        => $order_query->row['shipping_company'],
                'shipping_address_1'      => $order_query->row['shipping_address_1'],
                'shipping_address_2'      => $order_query->row['shipping_address_2'],
                'shipping_postcode'       => $order_query->row['shipping_postcode'],
                'shipping_city'           => $order_query->row['shipping_city'],
                'shipping_zone_id'        => $order_query->row['shipping_zone_id'],
                'shipping_zone'           => $order_query->row['shipping_zone'],
                'shipping_zone_code'      => $shipping_zone_code,
                'shipping_country_id'     => $order_query->row['shipping_country_id'],
                'shipping_country'        => $order_query->row['shipping_country'],
                'shipping_iso_code_2'     => $shipping_iso_code_2,
                'shipping_iso_code_3'     => $shipping_iso_code_3,
                'shipping_address_format' => $order_query->row['shipping_address_format'],
                'shipping_custom_field'   => json_decode($order_query->row['shipping_custom_field']),
                'shipping_method'         => $order_query->row['shipping_method'],
                'shipping_code'           => $order_query->row['shipping_code'],
                'comment'                 => $order_query->row['comment'],
                'total'                   => $order_query->row['total'],
                'reward'                  => $reward,
                'order_status_id'         => $order_query->row['order_status_id'],
                'affiliate_id'            => $order_query->row['affiliate_id'],
                'affiliate_firstname'     => $affiliate_firstname,
                'affiliate_lastname'      => $affiliate_lastname,
                'commission'              => $order_query->row['commission'],
                'language_id'             => $order_query->row['language_id'],
                'language_code'           => $language_code,
                'language_filename'       => $language_filename,
                'language_directory'      => $language_directory,
                'currency_id'             => $order_query->row['currency_id'],
                'currency_code'           => $order_query->row['currency_code'],
                'currency_value'          => $order_query->row['currency_value'],
                'ip'                      => $order_query->row['ip'],
                'forwarded_ip'            => $order_query->row['forwarded_ip'],
                'user_agent'              => $order_query->row['user_agent'],
                'accept_language'         => $order_query->row['accept_language'],
                'date_added'              => $order_query->row['date_added'],
                'date_modified'           => $order_query->row['date_modified']
            );
        } else {
            return;
        }
    }

    public function getWholesaler_Order($order_id)
    {
        $order_query = $this->db->query("SELECT *, (SELECT CONCAT(c.firstname, ' ', c.lastname) FROM " . DB_PREFIX . "customer c WHERE c.customer_id = o.customer_id) AS customer FROM `" . DB_PREFIX . "order` o WHERE o.order_id = '" . (int) $order_id . "' AND o.invoice_wholesaler = '1'");

        if ($order_query->num_rows) {
            $reward = 0;

            $order_product_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_product WHERE order_id = '" . (int) $order_id . "'");

            foreach ($order_product_query->rows as $product) {
                $reward += $product['reward'];
            }

            $country_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "country` WHERE country_id = '" . (int) $order_query->row['payment_country_id'] . "'");

            if ($country_query->num_rows) {
                $payment_iso_code_2 = $country_query->row['iso_code_2'];
                $payment_iso_code_3 = $country_query->row['iso_code_3'];
            } else {
                $payment_iso_code_2 = '';
                $payment_iso_code_3 = '';
            }

            $zone_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "zone` WHERE zone_id = '" . (int) $order_query->row['payment_zone_id'] . "'");

            if ($zone_query->num_rows) {
                $payment_zone_code = $zone_query->row['code'];
            } else {
                $payment_zone_code = '';
            }

            $country_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "country` WHERE country_id = '" . (int) $order_query->row['shipping_country_id'] . "'");

            if ($country_query->num_rows) {
                $shipping_iso_code_2 = $country_query->row['iso_code_2'];
                $shipping_iso_code_3 = $country_query->row['iso_code_3'];
            } else {
                $shipping_iso_code_2 = '';
                $shipping_iso_code_3 = '';
            }

            $zone_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "zone` WHERE zone_id = '" . (int) $order_query->row['shipping_zone_id'] . "'");

            if ($zone_query->num_rows) {
                $shipping_zone_code = $zone_query->row['code'];
            } else {
                $shipping_zone_code = '';
            }

            if ($order_query->row['affiliate_id']) {
                $affiliate_id = $order_query->row['affiliate_id'];
            } else {
                $affiliate_id = 0;
            }

            $this->load->model('marketing/affiliate');

            $affiliate_info = $this->model_marketing_affiliate->getAffiliate($affiliate_id);

            if ($affiliate_info) {
                $affiliate_firstname = $affiliate_info['firstname'];
                $affiliate_lastname = $affiliate_info['lastname'];
            } else {
                $affiliate_firstname = '';
                $affiliate_lastname = '';
            }

            $this->load->model('localisation/language');

            $language_info = $this->model_localisation_language->getLanguage($order_query->row['language_id']);


            if ($language_info) {
                $language_code = $language_info['code'];
                //$language_filename = $language_info['filename'];
                $language_filename = '';
                $language_directory = $language_info['directory'];
            } else {
                $language_code = '';
                $language_filename = '';
                $language_directory = '';
            }


            $staff_query = $this->db->query("SELECT firstname FROM `" . DB_PREFIX . "user` WHERE user_id = '" . (int) $order_query->row['user_id'] . "'");

            if ($staff_query->num_rows) {
                $staff_name = $staff_query->row['firstname'];
            } else {
                $staff_name = '';
            }

            return array(
                'order_id' => $order_query->row['order_id'],
                'invoice_no' => $order_query->row['invoice_no'],
                'invoice_prefix' => $order_query->row['invoice_prefix'],
                'store_id' => $order_query->row['store_id'],
                'store_name' => $order_query->row['store_name'],
                'staff_name' => $staff_name,
                'store_url' => $order_query->row['store_url'],
                'customer_id' => $order_query->row['customer_id'],
                'customer' => $order_query->row['customer'],
                'customer_group_id' => $order_query->row['customer_group_id'],
                'firstname' => $order_query->row['firstname'],
                'lastname' => $order_query->row['lastname'],
                'email' => $order_query->row['email'],
                'telephone' => $order_query->row['telephone'],
                'fax' => $order_query->row['fax'],
                'card_no' => $order_query->row['card_no'],
                'custom_field' => unserialize($order_query->row['custom_field']),
                'payment_firstname' => $order_query->row['payment_firstname'],
                'payment_lastname' => $order_query->row['payment_lastname'],
                'payment_company' => $order_query->row['payment_company'],
                'payment_address_1' => $order_query->row['payment_address_1'],
                'payment_address_2' => $order_query->row['payment_address_2'],
                'payment_postcode' => $order_query->row['payment_postcode'],
                'payment_city' => $order_query->row['payment_city'],
                'payment_zone_id' => $order_query->row['payment_zone_id'],
                'payment_zone' => $order_query->row['payment_zone'],
                'payment_zone_code' => $payment_zone_code,
                'payment_country_id' => $order_query->row['payment_country_id'],
                'payment_country' => $order_query->row['payment_country'],
                'payment_iso_code_2' => $payment_iso_code_2,
                'payment_iso_code_3' => $payment_iso_code_3,
                'payment_address_format' => $order_query->row['payment_address_format'],
                'payment_custom_field' => unserialize($order_query->row['payment_custom_field']),
                'payment_method' => $order_query->row['payment_method'],
                'payment_code' => $order_query->row['payment_code'],
                'shipping_firstname' => $order_query->row['shipping_firstname'],
                'shipping_lastname' => $order_query->row['shipping_lastname'],
                'shipping_company' => $order_query->row['shipping_company'],
                'shipping_address_1' => $order_query->row['shipping_address_1'],
                'shipping_address_2' => $order_query->row['shipping_address_2'],
                'shipping_postcode' => $order_query->row['shipping_postcode'],
                'shipping_city' => $order_query->row['shipping_city'],
                'shipping_zone_id' => $order_query->row['shipping_zone_id'],
                'shipping_zone' => $order_query->row['shipping_zone'],
                'shipping_zone_code' => $shipping_zone_code,
                'shipping_country_id' => $order_query->row['shipping_country_id'],
                'shipping_country' => $order_query->row['shipping_country'],
                'shipping_iso_code_2' => $shipping_iso_code_2,
                'shipping_iso_code_3' => $shipping_iso_code_3,
                'shipping_address_format' => $order_query->row['shipping_address_format'],
                'shipping_custom_field' => unserialize($order_query->row['shipping_custom_field']),
                'shipping_method' => $order_query->row['shipping_method'],
                'shipping_code' => $order_query->row['shipping_code'],
                'comment' => $order_query->row['comment'],
                'total' => $order_query->row['total'],
                'reward' => $reward,
                'order_status_id' => $order_query->row['order_status_id'],
                'affiliate_id' => $order_query->row['affiliate_id'],
                'affiliate_firstname' => $affiliate_firstname,
                'affiliate_lastname' => $affiliate_lastname,
                'commission' => $order_query->row['commission'],
                'language_id' => $order_query->row['language_id'],
                'language_code' => $language_code,
                'language_filename' => $language_filename,
                'language_directory' => $language_directory,
                'currency_id' => $order_query->row['currency_id'],
                'currency_code' => $order_query->row['currency_code'],
                'currency_value' => $order_query->row['currency_value'],
                'ip' => $order_query->row['ip'],
                'forwarded_ip' => $order_query->row['forwarded_ip'],
                'user_agent' => $order_query->row['user_agent'],
                'accept_language' => $order_query->row['accept_language'],
                'date_added' => $order_query->row['date_added'],
                'date_modified' => $order_query->row['date_modified']
            );
        } else {
            return;
        }
    }

    public function getWholesalerOrders($data = array())
    {
        $sql = "
			SELECT 
					o.order_id,
					CONCAT(o.firstname, ' ', o.lastname) AS customer, 
					(SELECT 
							os.name 
						FROM oc_order_status os 
						WHERE os.order_status_id = o.order_status_id 
						AND os.language_id = '" . (int) $this->config->get('config_language_id') . "') AS status, 
					o.shipping_code, 
					o.total, 
					o.currency_code, 
					o.currency_value, 
					o.date_added, 
					o.date_modified,
					o.invoice_prefix,
                    o.order_status_id,
                    o.customer_group_id,
                    o.invoice_date,
					oh_order.date_completed,
                    o.comment
				FROM `oc_order` o 
					LEFT JOIN ( 
						SELECT 
								oh.order_id,
								oh.date_added AS date_completed
							FROM `oc_order_history` oh
							WHERE 1
								AND oh.order_status_id = 5
							GROUP BY oh.order_id
							ORDER BY oh.order_history_id DESC
						) oh_order
						ON o.order_id = oh_order.order_id
				WHERE o.invoice_wholesaler = '1'
			";

        if (isset($data['filter_order_status'])) {
            $implode = array();

            $order_statuses = explode(',', $data['filter_order_status']);

            foreach ($order_statuses as $order_status_id) {
                $implode[] = "o.order_status_id = '" . (int) $order_status_id . "'";
            }

            if ($implode) {
                $sql .= " AND (" . implode(" OR ", $implode) . ")";
            } else {
            }
        } else {
            $sql .= " AND o.order_status_id > '0'";
        }

        if (!empty($data['filter_customer_group'])) {
            $sql .= " AND o.customer_group_id = '" . (int) $data['filter_customer_group'] . "'";
        }

        if (!empty($data['filter_date_added_from'])) {
            $sql .= " AND DATE(o.date_added) >= DATE('" . $this->db->escape($data['filter_date_added_from']) . "')";
        }

        if (!empty($data['filter_date_added_to'])) {
            $sql .= " AND DATE(o.date_added) <= DATE('" . $this->db->escape($data['filter_date_added_to']) . "')";
        }

        if (!empty($data['filter_invoice'])) {
            $sql .= " AND o.invoice_prefix = '" . $this->db->escape($data['filter_invoice']) . "'";
        }

        if (!empty($data['filter_order_id'])) {
            $sql .= " AND o.order_id = '" . (int) $data['filter_order_id'] . "'";
        }

        if (isset($data['filter_store_id']) && $data['filter_store_id'] != '*') {
            $sql .= " AND o.store_id = '" . (int) $data['filter_store_id'] . "'";
        }

        if (!empty($data['filter_customer'])) {
            $sql .= " AND CONCAT(o.firstname, ' ', o.lastname) LIKE '%" . $this->db->escape($data['filter_customer']) . "%'";
        }

        /*if (!empty($data['filter_date_added'])) {
            $sql .= " AND DATE(o.date_added) = DATE('" . $this->db->escape($data['filter_date_added']) . "')";
        }*/

        if (!empty($data['filter_date_modified'])) {
            $sql .= " AND DATE(o.date_modified) = DATE('" . $this->db->escape($data['filter_date_modified']) . "')";
        }

        if (!empty($data['filter_total'])) {
            $sql .= " AND o.total = '" . (float) $data['filter_total'] . "'";
        }

        if (!empty($data['filter_user_id'])) {
            $sql .= " AND user_id = '" . (float) $data['filter_user_id'] . "'";
        }

        $sort_data = array(
            'o.order_id',
            'customer',
            'status',
            'o.date_added',
            'o.date_modified',
            'o.total',
            'o.customer_group',
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY o.order_id";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getPosOrders($data = array())
    {

        $sql = "SELECT o.order_id,o.customer_id, CONCAT(o.firstname, ' ', o.lastname) AS customer, (SELECT os.name FROM " . DB_PREFIX . "order_status os WHERE os.order_status_id = o.order_status_id AND os.language_id = '" . (int) $this->config->get('config_language_id') . "') AS status, o.shipping_code, o.total, o.currency_code, o.currency_value, o.date_added, o.date_modified,o.invoice_prefix FROM `" . DB_PREFIX . "order` o WHERE o.invoice_wholesaler = '1'";


        if (isset($data['filter_order_status'])) {
            $sql .= " WHERE o.order_status_id = '" . (int) $data['filter_order_status'] . "'";
        } else {
            $sql .= " WHERE o.order_status_id > '0'";
        }

        if (isset($data['filter_store_id'])) {
            $sql .= " AND o.store_id = '" . (int) $data['filter_store_id'] . "'";
        }


        if (isset($data['filter_order_id'])) {
            $sql .= " AND o.order_id = '" . (int) $data['filter_order_id'] . "'";
        }

        if (isset($data['filter_invoice_id'])) {
            $sql .= " AND o.invoice_prefix = '" . $this->db->escape($data['filter_invoice_id']) . "'";
        }


        if (!empty($data['filter_customer'])) {
            $sql .= " AND CONCAT(o.firstname, ' ', o.lastname) LIKE '%" . $this->db->escape($data['filter_customer']) . "%'";
        }

        if (!empty($data['filter_date_added'])) {
            $sql .= " AND DATE(o.date_added) = DATE('" . $this->db->escape($data['filter_date_added']) . "')";
        }

        if (!empty($data['filter_date_modified'])) {
            $sql .= " AND DATE(o.date_modified) = DATE('" . $this->db->escape($data['filter_date_modified']) . "')";
        }

        if (!empty($data['filter_total'])) {
            $sql .= " AND o.total = '" . (float) $data['filter_total'] . "'";
        }

        if (!empty($data['filter_user_id'])) {
            $sql .= " AND user_id = '" . (float) $data['filter_user_id'] . "'";
        }

        $sort_data = array(
            'o.order_id',
            'customer',
            'status',
            'o.date_added',
            'o.date_modified',
            'o.total'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY o.order_id";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }
        $sql;

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getOrderProducts($order_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_product WHERE order_id = '" . (int) $order_id . "' AND price !=0");

        return $query->rows;
    }

    public function getOrderCartProducts($order_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_product WHERE order_id = '" . (int) $order_id . "' AND total!=0.00 ");

        return $query->rows;
    }

    public function getOrderOption($order_id, $order_option_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_option WHERE order_id = '" . (int) $order_id . "' AND order_option_id = '" . (int) $order_option_id . "'");

        return $query->row;
    }

    public function getOrderOptions($order_id, $order_product_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_option WHERE order_id = '" . (int) $order_id . "' AND order_product_id = '" . (int) $order_product_id . "'");

        return $query->rows;
    }

    public function getOrderVouchers($order_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_voucher WHERE order_id = '" . (int) $order_id . "'");

        return $query->rows;
    }

    public function getOrderVoucherByVoucherId($voucher_id)
    {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "order_voucher` WHERE voucher_id = '" . (int) $voucher_id . "'");

        return $query->row;
    }

    public function getOrderTotals($order_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_total WHERE order_id = '" . (int) $order_id . "' ORDER BY sort_order");

        return $query->rows;
    }

    public function getTotalWholesalerOrders($data = array())
    {
        $sql = "SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "order` WHERE invoice_wholesaler = '1'";

        if (!empty($data['filter_order_status'])) {
            $implode = array();

            $order_statuses = explode(',', $data['filter_order_status']);

            foreach ($order_statuses as $order_status_id) {
                $implode[] = "order_status_id = '" . (int) $order_status_id . "'";
            }

            if ($implode) {
                $sql .= " AND (" . implode(" OR ", $implode) . ")";
            }
        } else {
            $sql .= " AND order_status_id > '0'";
        }

        if (!empty($data['filter_customer_group'])) {
            $sql .= " AND customer_group_id = '" . (int) $data['filter_customer_group'] . "'";
        }

        if (!empty($data['filter_date_added_from'])) {
            $sql .= " AND DATE(date_added) >= DATE('" . $this->db->escape($data['filter_date_added_from']) . "')";
        }

        if (!empty($data['filter_date_added_to'])) {
            $sql .= " AND DATE(date_added) <= DATE('" . $this->db->escape($data['filter_date_added_to']) . "')";
        }

        if (!empty($data['filter_order_id'])) {
            $sql .= " AND order_id = '" . (int) $data['filter_order_id'] . "'";
        }

        if (isset($data['filter_store_id']) && $data['filter_store_id'] != '*') {
            $sql .= " AND store_id = '" . (int) $data['filter_store_id'] . "'";
        }

        if (!empty($data['filter_invoice'])) {
            $sql .= " AND invoice_prefix = '" . $this->db->escape($data['filter_invoice']) . "'";
        }

        if (!empty($data['filter_customer'])) {
            $sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['filter_customer']) . "%'";
        }

        /*if (!empty($data['filter_date_added'])) {
            $sql .= " AND DATE(date_added) = DATE('" . $this->db->escape($data['filter_date_added']) . "')";
        }*/

        if (!empty($data['filter_date_modified'])) {
            $sql .= " AND DATE(date_modified) = DATE('" . $this->db->escape($data['filter_date_modified']) . "')";
        }

        if (!empty($data['filter_total'])) {
            $sql .= " AND total = '" . (float) $data['filter_total'] . "'";
        }

        if (!empty($data['filter_user_id'])) {
            $sql .= " AND user_id = '" . (float) $data['filter_user_id'] . "'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getPosTotalOrders($data = array())
    {
        $sql = "SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "order` WHERE invoice_wholesaler = '1'";

        if (!empty($data['filter_order_status'])) {
            $sql .= " AND order_status_id = '" . (int) $data['filter_order_status'] . "'";
        } else {
            $sql .= " AND order_status_id > '0'";
        }

        if (!empty($data['filter_order_id'])) {
            $sql .= " AND order_id = '" . (int) $data['filter_order_id'] . "'";
        }

        if (isset($data['filter_store_id'])) {
            $sql .= " AND store_id = '" . (int) $data['filter_store_id'] . "'";
        }

        if (isset($data['filter_invoice_id'])) {
            $sql .= " AND invoice_prefix = '" . (int) $data['filter_invoice_id'] . "'";
        }

        if (!empty($data['filter_customer'])) {
            $sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['filter_customer']) . "%'";
        }

        if (!empty($data['filter_date_added'])) {
            $sql .= " AND DATE(date_added) = DATE('" . $this->db->escape($data['filter_date_added']) . "')";
        }

        if (!empty($data['filter_date_modified'])) {
            $sql .= " AND DATE(date_modified) = DATE('" . $this->db->escape($data['filter_date_modified']) . "')";
        }

        if (!empty($data['filter_total'])) {
            $sql .= " AND total = '" . (float) $data['filter_total'] . "'";
        }

        if (!empty($data['filter_user_id'])) {
            $sql .= " AND user_id = '" . (float) $data['filter_user_id'] . "'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getTotalOrdersByStoreId($store_id)
    {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "order` WHERE store_id = '" . (int) $store_id . "' AND invoice_wholesaler = '1'");

        return $query->row['total'];
    }

    public function getTotalOrdersByOrderStatusId($order_status_id)
    {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "order` WHERE order_status_id = '" . (int) $order_status_id . "' AND order_status_id > '0' AND invoice_wholesaler = '1'");

        return $query->row['total'];
    }

    public function getTotalOrdersByProcessingStatus()
    {
        $implode = array();

        $order_statuses = $this->config->get('config_processing_status');

        foreach ($order_statuses as $order_status_id) {
            $implode[] = "order_status_id = '" . (int) $order_status_id . "'";
        }

        if ($implode) {
            $query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "order` WHERE " . implode(" OR ", $implode) . " AND invoice_wholesaler = '1'");

            return $query->row['total'];
        } else {
            return 0;
        }
    }

    public function getTotalOrdersByCompleteStatus()
    {
        $implode = array();

        $order_statuses = $this->config->get('config_complete_status');

        foreach ($order_statuses as $order_status_id) {
            $implode[] = "order_status_id = '" . (int) $order_status_id . "'";
        }

        if ($implode) {
            $query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "order` WHERE " . implode(" OR ", $implode) . " AND invoice_wholesaler = '1'");

            return $query->row['total'];
        } else {
            return 0;
        }
    }

    public function getTotalOrdersByLanguageId($language_id)
    {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "order` WHERE language_id = '" . (int) $language_id . "' AND order_status_id > '0' AND invoice_wholesaler = '1'");

        return $query->row['total'];
    }

    public function getTotalOrdersByCurrencyId($currency_id)
    {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "order` WHERE currency_id = '" . (int) $currency_id . "' AND order_status_id > '0' AND invoice_wholesaler = '1'");

        return $query->row['total'];
    }

    public function createInvoiceNo2($order_id)
    {
        $order_info = $this->getOrder($order_id);

        if ($order_info && empty($order_info['invoice_prefix'])) {

            $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'pos/pos', 'store' => $this->session->data['store_id']));

            $this->db->query("UPDATE " . DB_PREFIX . "order 
											  SET invoice_prefix = '" . $invoice_prefix . "' 
											  WHERE order_id = '" . $order_id . "'");

            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'pos/pos', 'store' => $this->session->data['store_id']));

            return $invoice_prefix;
        }
    }

    public function createInvoiceNo($order_id)
    {
        $order_info = $this->getOrder($order_id);

        if ($order_info && !$order_info['invoice_no']) {
            $query = $this->db->query("SELECT MAX(invoice_no) AS invoice_no FROM `" . DB_PREFIX . "order` WHERE invoice_prefix = '" . $this->db->escape($order_info['invoice_prefix']) . "' AND invoice_wholesaler = '1'");

            if ($query->row['invoice_no']) {
                $invoice_no = $query->row['invoice_no'] + 1;
            } else {
                $invoice_no = 1;
            }

            $this->db->query("UPDATE `" . DB_PREFIX . "order` SET invoice_no = '" . (int) $invoice_no . "', invoice_prefix = '" . $this->db->escape($order_info['invoice_prefix']) . "' WHERE order_id = '" . (int) $order_id . "' AND invoice_wholesaler = '1'");

            return $order_info['invoice_prefix'] . $invoice_no;
        }
    }

    public function getOrderHistories($order_id, $start = 0, $limit = 10)
    {
        if ($start < 0) {
            $start = 0;
        }

        if ($limit < 1) {
            $limit = 10;
        }

        $query = $this->db->query("SELECT oh.date_added, os.name AS status, oh.comment, oh.notify FROM " . DB_PREFIX . "order_history oh LEFT JOIN " . DB_PREFIX . "order_status os ON oh.order_status_id = os.order_status_id WHERE oh.order_id = '" . (int) $order_id . "' AND os.language_id = '" . (int) $this->config->get('config_language_id') . "' ORDER BY oh.date_added ASC LIMIT " . (int) $start . "," . (int) $limit);

        return $query->rows;
    }

    public function getTotalOrderHistories($order_id)
    {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "order_history WHERE order_id = '" . (int) $order_id . "'");

        return $query->row['total'];
    }

    public function getTotalOrderHistoriesByOrderStatusId($order_status_id)
    {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "order_history WHERE order_status_id = '" . (int) $order_status_id . "'");

        return $query->row['total'];
    }

    public function getEmailsByProductsOrdered($products, $start, $end)
    {
        $implode = array();

        foreach ($products as $product_id) {
            $implode[] = "op.product_id = '" . (int) $product_id . "'";
        }

        $query = $this->db->query("SELECT DISTINCT email FROM `" . DB_PREFIX . "order` o LEFT JOIN " . DB_PREFIX . "order_product op ON (o.order_id = op.order_id) WHERE (" . implode(" OR ", $implode) . ") AND o.order_status_id <> '0' LIMIT " . (int) $start . "," . (int) $end);

        return $query->rows;
    }

    public function getTotalEmailsByProductsOrdered($products)
    {
        $implode = array();

        foreach ($products as $product_id) {
            $implode[] = "op.product_id = '" . (int) $product_id . "'";
        }

        $query = $this->db->query("SELECT DISTINCT email FROM `" . DB_PREFIX . "order` o LEFT JOIN " . DB_PREFIX . "order_product op ON (o.order_id = op.order_id) WHERE (" . implode(" OR ", $implode) . ") AND o.order_status_id <> '0'");

        return $query->row['total'];
    }

    public function getPaidHerbals($order_id)
    {

        $order_query = $this->db->query("SELECT *  FROM " . DB_PREFIX . "clinical_sale cs WHERE cs.order_id ='" . (int) $order_id . "' AND cs.order_action= '5'");

        return $order_query->rows;
    }

    public function getPaidServies($order_id)
    {

        $order_query = $this->db->query("
		SELECT *,si.net_amount As service_price  
		FROM " . DB_PREFIX . "service_item si  
		LEFT JOIN " . DB_PREFIX . "service_form sf 
		ON (si.service_form_id = sf.service_form_id) 
		WHERE sf.order_id ='" . (int) $order_id . "' 
		AND sf.order_action= '5'");
        return $order_query->rows;
    }

    public function getHoaldHerbals($order_id)
    {

        $order_query = $this->db->query("SELECT *  FROM " . DB_PREFIX . "clinical_sale cs WHERE cs.order_id ='" . (int) $order_id . "' AND cs.order_action= '1'");

        return $order_query->rows;
    }

    public function getHoaldServies($order_id)
    {

        $order_query = $this->db->query("SELECT * ,si.net_amount As service_price   FROM " . DB_PREFIX . "service_item si  LEFT JOIN " . DB_PREFIX . "service_form sf ON (si.service_form_id = sf.service_form_id) WHERE sf.order_id ='" . (int) $order_id . "' AND sf.order_action= '1'");

        return $order_query->rows;
    }

    public function getHerbals($order_id)
    {

        $order_query = $this->db->query("SELECT *  FROM " . DB_PREFIX . "clinical_sale cs WHERE cs.order_id ='" . (int) $order_id . "'");

        return $order_query->rows;
    }

    public function getServies($order_id)
    {

        $order_query = $this->db->query("SELECT * ,si.net_amount As service_price   FROM " . DB_PREFIX . "service_item si  LEFT JOIN " . DB_PREFIX . "service_form sf ON (si.service_form_id = sf.service_form_id) WHERE sf.order_id ='" . (int) $order_id . "'");

        return $order_query->rows;
    }

    public function listPendingOrder($from_order_status)
    {
        $sql = "SELECT order_id, order_reminder, invoice_prefix, date_added, store_id, email, store_name, CONCAT(firstname, ' ', lastname) AS customer_name FROM " . DB_PREFIX . "order WHERE order_status_id IN(" . $from_order_status . ") AND invoice_wholesaler = '1'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function updateCancel($order_status, $order_id)
    {
        $sql = "UPDATE " . DB_PREFIX . "order SET order_status_id = '" . $order_status . "' WHERE order_id = '" . $order_id . "' invoice_wholesaler = '1'";

        $query = $this->db->query($sql);

        return $order_id;
    }

    public function selectProduct($order_id)
    {
        $sql = "SELECT order_id, name, quantity, product_id FROM " . DB_PREFIX . "order_product WHERE order_id = '" . $order_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function reverse_quantity($quantity, $store_id, $product_id)
    {
        $sql = "UPDATE " . DB_PREFIX . "product_to_store SET onhand_quantity = onhand_quantity + " . $quantity . " WHERE product_id = '" . $product_id . "' AND store_id = '" . $store_id . "'";

        $query = $this->db->query($sql);
    }

    public function updateOrderReminder($order_id)
    {
        $sql = "UPDATE " . DB_PREFIX . "order SET order_reminder = '1' WHERE order_id = '" . (int) $order_id . "' AND invoice_wholesaler = '1'";

        $query = $this->db->query($sql);
    }

    public function getCustomerPhoneNumberByOrderID($order_id)
    {
        $sql = "SELECT c.telephone, c.telephone2, a.country_id FROM " . DB_PREFIX . "order o 
				LEFT JOIN " . DB_PREFIX . "customer c 
				ON c.customer_id = o.customer_id 
				LEFT JOIN " . DB_PREFIX . "address a 
				ON a.customer_id = c.customer_id 
				WHERE o.order_id = '" . (int) $order_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getWholesalerOrder($order_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "order o 
        LEFT JOIN " . DB_PREFIX . "address a 
        ON a.customer_id = o.customer_id WHERE o.order_id = '" . (int) $order_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function TotalWholesalers($data = array())
    {
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer WHERE status = '1'";

        if (!empty($data['name'])) {
            $sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['name']) . "%'";
        }

        if (!empty($data['ic_num'])) {
            $sql .= " AND customer_ic LIKE '%" . $this->db->escape($data['ic_num']) . "%'";
        }

        if (!empty($data['email'])) {
            $sql .= " AND email LIKE '%" . $this->db->escape($data['email']) . "%'";
        }

        if (!empty($data['filter_customer_group'])) {
            $sql .= " AND customer_group_id = '" . (int) $data['filter_customer_group'] . "'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getWholesalers($data = array())
    {
        $sql = "SELECT customer_id, 
					   CONCAT(firstname, ' ', lastname) AS customer_name, 
					   customer_ic, 
					   email, 
					   customer_group_id  
				FROM " . DB_PREFIX . "customer 
				WHERE status = '1'";

        if (!empty($data['name'])) {
            $sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['name']) . "%'";
        }

        if (!empty($data['ic_num'])) {
            $sql .= " AND customer_ic LIKE '%" . $this->db->escape($data['ic_num']) . "%'";
        }

        if (!empty($data['email'])) {
            $sql .= " AND email LIKE '%" . $this->db->escape($data['email']) . "%'";
        }

        if (!empty($data['filter_customer_group'])) {
            $sql .= " AND customer_group_id = '" . (int) $data['filter_customer_group'] . "'";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] =  $this->config->get('config_limit_admin');
            }
            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getWholesalerProducts($data = array())
    {
        $sql = "SELECT p.product_id, 
                       p.weight_class_id,
					   pd.name AS product_name,
					   wcd.title AS product_weight_class,
					   p.price AS product_price,
					   p.code AS product_code  
				FROM " . DB_PREFIX . "product p 
				LEFT JOIN " . DB_PREFIX . "product_description pd 
				ON pd.product_id = p.product_id 
				AND pd.language_id = '" . $this->config->get('config_language_id') . "' 
				LEFT JOIN " . DB_PREFIX . "weight_class_description wcd 
				ON wcd.weight_class_id = p.weight_class_id 
				AND wcd.language_id = '" . $this->config->get('config_language_id') . "' 
				WHERE p.internal_status = '1'";

        if (!empty($data['name'])) {
            $sql .= " AND pd.name LIKE '%" . $this->db->escape($data['name']) . "%'";
        }

        if (!empty($data['code'])) {
            $sql .= " AND p.code LIKE '%" . $this->db->escape($data['code']) . "%'";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] =  $this->config->get('config_limit_admin');
            }
            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        $products = $query->rows;

        $final_products = array();

        foreach ($products as $product) {
            $product_id = $product['product_id'];

            $special_sql = "SELECT price AS product_special_price 
							FROM " . DB_PREFIX . "product_special 
							WHERE product_id = '" . (int) $product_id . "' 
							AND customer_group_id = '" . (int) $data['customer_group_id'] . "'";

            if (!empty($data['date'])) {
                $special_sql .= " AND DATE(" . $this->db->escape($data['date']) . ") BETWEEN DATE(date_start) AND DATE(date_end) ";
            }

            $special_query = $this->db->query($special_sql);

            $special_products = $special_query->row;

            if (!empty($special_products['product_special_price'])) {
                $final_price = $special_products['product_special_price'];
            } else {
                $final_price = $product['product_price'];
            }

            $final_products[] = array(
                'product_id' => $product_id,
                'product_name' => $product['product_name'],
                'product_code' => $product['product_code'],
                'product_weight_class_id' => $product['weight_class_id'],
                'product_weight_class' => $product['product_weight_class'],
                'product_price' => $final_price
            );
        }

        return $final_products;
    }

    public function getTotalWholesalerProducts($data = array())
    {
        $sql = "SELECT COUNT(*) AS total 
				FROM " . DB_PREFIX . "product p 
				LEFT JOIN " . DB_PREFIX . "product_description pd 
				ON pd.product_id = p.product_id 
				AND pd.language_id = '" . $this->config->get('config_language_id') . "' 
				WHERE p.internal_status = '1'";

        if (!empty($data['name'])) {
            $sql .= " AND pd.name LIKE '%" . $this->db->escape($data['name']) . "%'";
        }

        if (!empty($data['code'])) {
            $sql .= " AND p.code LIKE '%" . $this->db->escape($data['code']) . "%'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function addOrderWholesaler($data = array())
    {
        $this->load->model('setting/store');
        $this->load->model('sale/customer');
        $this->load->model('localisation/currency');
        $this->load->model('catalog/product');
        $this->load->model('pos/extension');

        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'pos/pos', 'store' => $this->session->data['store_id']));
        if (!empty($this->request->post['invoice_prefix']) && $invoice_prefix == $this->request->post['invoice_prefix']) {
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'pos/pos', 'store' => $this->session->data['store_id']));
        } elseif(!empty($data['invoice_prefix'])) {
            $invoice_prefix = $data['invoice_prefix'];
        } else{
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'pos/pos', 'store' => $this->session->data['store_id']));
        }





        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $store_info = $this->model_setting_store->getStore($this->session->data['store_id']);
        $customer_info = $this->model_sale_customer->getCustomer($data['wholesaler_id']);
        $currency_info = $this->model_localisation_currency->getCurrencyByCode($this->config->get('config_currency'));

        if (!empty($data['payment_address'])) {
            $address_info = $this->model_sale_order_wholesaler->getAddress($data['payment_address']);
            if (!empty($address_info['zone_id']) && $address_info['zone_id'] > 0) {
                $payment_zone = $this->model_sale_order_wholesaler->getZone($address_info['zone_id']);
            } else {
                $payment_zone = '';
            }
            if (!empty($address_info['country_id']) && $address_info['country_id']) {
                $payment_country =  $this->model_sale_order_wholesaler->getCountry($address_info['country_id']);
            } else {
                $payment_country = '';
            }
            $payment_firstname = $address_info['firstname'];
            $payment_lastname = $address_info['lastname'];
            $payment_company = $address_info['company'];
            $payment_address_1 = $address_info['address_1'];
            $payment_address_2 = $address_info['address_2'];
            $payment_address_3 = $address_info['address_3'];
            $payment_postcode = $address_info['postcode'];
            $payment_city = $address_info['city'];
            $payment_zone_id = $address_info['zone_id'];
            $payment_zone       = $payment_zone;
            $payment_country_id = $address_info['country_id'];
            $payment_country    = $payment_country;
        } else {
            $payment_firstname = '';
            $payment_lastname = '';
            $payment_company = '';
            $payment_address_1 = '';
            $payment_address_2 = '';
            $payment_address_3 = '';
            $payment_postcode = '';
            $payment_city = '';
            $payment_zone_id = '';
            $payment_zone = '';
            $payment_country_id = '';
            $payment_country = '';
        }
        if (!empty($data['shipping_address'])) {
            $ship_address = $this->model_sale_order_wholesaler->getAddress($data['shipping_address']);
            if (!empty($ship_address['zone_id']) && $ship_address['zone_id'] > 0) {
                $ship_zone = $this->model_sale_order_wholesaler->getZone($ship_address['zone_id']);
            } else {
                $ship_zone = '';
            }
            if (!empty($ship_address['country_id']) && $ship_address['country_id']) {
                $ship_country = $this->model_sale_order_wholesaler->getCountry($ship_address['country_id']);
            } else {
                $ship_country = '';
            }
            $shipping_address_id = $data['shipping_address'];
            $shipping_firstname = $ship_address['firstname'];
            $shipping_lastname = $ship_address['lastname'];
            $shipping_company = $ship_address['company'];
            $shipping_address_1 = $ship_address['address_1'];
            $shipping_address_2 = $ship_address['address_2'];
            $shipping_address_3 = $ship_address['address_3'];
            $shipping_postcode = $ship_address['postcode'];
            $shipping_city = $ship_address['city'];
            $shipping_zone_id = $ship_address['zone_id'];
            $shipping_zone = $ship_zone;
            $shipping_country_id = $ship_address['country_id'];
            $shipping_country = $ship_country;
        } else {
            $shipping_address_id = '';
            $shipping_firstname = '';
            $shipping_lastname = '';
            $shipping_company = '';
            $shipping_address_1 = '';
            $shipping_address_2 = '';
            $shipping_address_3 = '';
            $shipping_postcode = '';
            $shipping_city = '';
            $shipping_zone_id = '';
            $shipping_zone = '';
            $shipping_country_id = '';
            $shipping_country = '';
        }
        if ($store_info) {
            $store_name = $store_info['name'];
            $store_url = $store_info['url'];
        } else {
            $store_name = $this->config->get('config_name');
            $store_url = HTTP_CATALOG;
        }

        if ($currency_info) {
            $currency_id = $currency_info['currency_id'];
            $currency_code = $currency_info['code'];
            $currency_value = $currency_info['value'];
        } else {
            $currency_id = 0;
            $currency_code = $this->config->get('config_currency');
            $currency_value = 1.00000;
        }

        $payment_code = !empty($data['payment_method']) ? $data['payment_method'] : 'pay_by_cash';
        $payment_name = $this->getPaymentMethodName($payment_code);
        $invoice_date = !empty($data['date_added']) ? $data['date_added'] : date('Y-m-d');

        $customer_group_id = !empty($this->config->get('config_order_wholesaler_customer_group')) ? $this->config->get('config_order_wholesaler_customer_group') : $customer_info['customer_group_id'];

        $sql = "INSERT INTO " . DB_PREFIX . "order SET store_id = '" . (int)$this->session->data['store_id'] . "', store_name = '" . $this->db->escape($store_name) . "', store_url = '" . $this->db->escape($store_url) . "', customer_id = '" . (int)$data['wholesaler_id'] . "', user_id = '" . (int)$this->session->data['user_id'] . "', card_no = '" . $this->db->escape($customer_info['customer_card']) . "', customer_group_id =  '" . (int)$customer_group_id . "', firstname = '" . $this->db->escape($customer_info['firstname']) . "', lastname = '" . $this->db->escape($customer_info['lastname']) . "', email = '" . $this->db->escape($customer_info['email']) . "',  telephone = '" . $this->db->escape($customer_info['telephone']) . "', fax = '" . $this->db->escape($customer_info['fax']) . "', payment_firstname = '" . $this->db->escape($payment_firstname) . "', payment_lastname = '" . $this->db->escape($payment_lastname) . "', payment_company = '" . $this->db->escape($payment_company) . "', payment_address_1 = '" . $this->db->escape($payment_address_1) . "', payment_address_2 = '" . $this->db->escape($payment_address_2) . "', payment_address_3 = '" . $this->db->escape($payment_address_3) . "', payment_city = '" . $this->db->escape($payment_city) . "', payment_postcode = '" . $this->db->escape($payment_postcode) . "', payment_country = '" . $this->db->escape($payment_country) . "', payment_country_id = '" . (int)$payment_country_id . "', payment_zone = '" . $this->db->escape($payment_zone) . "', payment_zone_id = '" . (int)$payment_zone_id . "', payment_method = '" . $this->db->escape($payment_name) . "', payment_code = '" . $this->db->escape($payment_code) . "', shipping_address_id = '" . (int)$shipping_address_id . "', shipping_firstname = '" . $this->db->escape($shipping_firstname) . "', shipping_lastname  = '" . $this->db->escape($shipping_lastname) . "', shipping_company = '" . $this->db->escape($shipping_company) . "', shipping_address_1 = '" . $this->db->escape($shipping_address_1) . "', shipping_address_2 = '" . $this->db->escape($shipping_address_2) . "', shipping_address_3 = '" . $this->db->escape($shipping_address_3) . "', shipping_city = '" . $this->db->escape($shipping_city) . "', shipping_postcode = '" . $this->db->escape($shipping_postcode) . "', shipping_zone = '" . $this->db->escape($shipping_zone) . "', shipping_zone_id = '" . (int)$shipping_zone_id . "', shipping_country = '" . $this->db->escape($shipping_country) . "', shipping_country_id = '" . (int)$shipping_country_id . "', shipping_method = 'Free Shipping', order_status_id = '" . (int)$data['status'] . "', language_id = '" . (int)$this->config->get('config_language_id') . "', currency_id = '" . (int)$currency_id . "', currency_code = '" . $this->db->escape($currency_code) . "', currency_value = '" . (float)$currency_value . "', invoice_wholesaler = '1', invoice_prefix = '" . $this->db->escape($invoice_prefix) . "', invoice_date = '" . $this->db->escape($invoice_date) . "', date_completed = '" . $this->db->escape($invoice_date) . "', comment = '" . $this->db->escape($data['comment']) . "', stock_affect = '" . (int)(isset($data['stock_affect']) ? 1 : 0) . "', date_ordered = NOW(), date_added = NOW(), date_modified = NOW(), add_by = '" . (int)$this->session->data['user_id'] . "', modifi_by = '" . (int)$this->session->data['user_id'] . "'";

        $this->db->query($sql);

        $order_id = $this->db->getLastId();

        if (!empty($order_id) && empty($invoice_date) && !empty($invoice_prefix)) {
            $this->db->query("UPDATE `oc_order` SET invoice_date = NOW() WHERE order_id = '" . (int)$order_id . "'");
        }

        if (!empty($data['status']) && $data['status'] == 5) {
            $this->db->query("UPDATE `oc_order` SET date_completed = NOW(), completed_by = '" . (int)$this->session->data['user_id'] . "' WHERE order_id = '" . (int)$order_id . "'");
        }

        if (!empty($order_id) && !empty($data['status'])) {
            $this->db->query("INSERT `oc_order_history` SET order_id = '" . (int)$order_id . "', order_status_id = '" . (int)$data['status'] . "', notify = '0', comment = '', date_added = NOW() ");
        }

        $order_products = $data['product_item'];

        $total_order = 0;
        $total_weight_value = 0;
        $total_tax = 0;
        $total_subtotal = 0;

        foreach ($order_products as $product) {
            $product_total = $product['hidden-total'];
            $product_subtotal = $product['hidden-subtotal'];
            $product_weight = $product['total_weight'];
            $product_tax = $product['hidden-taxes'];

            $total_order += $product_total;
            $total_tax += $product_tax;
            $total_weight_value += $product_weight;
            $total_subtotal += $product_subtotal;

            $product_info = $this->model_catalog_product->getProduct($product['product_id']);

            if (!empty($product_info['tax_class_id'])) {
                $tax_class_id = $product_info['tax_class_id'];
            } else {
                $tax_class_id = 11;
            }

            // INSERT Product List
            $this->db->query("INSERT INTO " . DB_PREFIX . "order_product SET order_id = '" . (int) $order_id . "', product_id = '" . (int) $product['product_id'] . "', name = '" . $this->db->escape($product_info['name']) . "', model = '" . $this->db->escape($product_info['model']) . "', quantity = '" . (float)$product['quantity'] . "', tax_class_id = '" . (int)$tax_class_id . "',  tax_format = '" . $this->db->escape($product['format']) . "', tax_code = '" . $this->db->escape($this->tax->getClassCode($product_info['tax_class_id'])) . "', weight = '" . (float)$product_info['weight'] . "', weight_class_id = '" . (int)$product['product_weight_class'] . "', total_weight = '" . (float)$product['total_weight'] . "', default_conversion = '" . (int)$product['default_product_weight_class'] . "', usedqty = '1', price = '" . (float)$product['product_price'] . "', net_amount = '" . (float) $product['product_price'] . "', total_net_amount = '" . (float)$product['hidden-subtotal'] . "', total = '" . (float) $product['hidden-total'] . "', tax = '" . (float)$product['hidden-tax'] . "', total_tax = '" . (float)$product['hidden-taxes'] . "'");

            if ($data['status'] == '5' && isset($data['stock_affect'])) {
                //$this->db->query("UPDATE oc_product_to_store SET onhand_quantity = (onhand_quantity - " . (float)$product['total_weight'] . ") WHERE product_id = '" . (int)$product['product_id'] . "' AND store_id =" . (int)$this->session->data['store_id']);
            }
        }

        $total_subtotal = $total_subtotal;
        $total_order = $total_order;
        $final_tax = $total_tax;
        $final_total = round($total_order, 2);
        $round1 = round($final_total / 0.05, 0);
        $round2 = $round1 * 0.05;
        $round3 = $round2 - $final_total;
        $final_rounding = round($round3, 2);

        $final_totals = (float) $final_total + (float) $final_rounding;
        $final_weight = $total_weight_value;

        //Insert order total
        $this->db->query("INSERT INTO " . DB_PREFIX . "order_total SET order_id = '" . (int) $order_id . "', code = 'sub_total',tax_key ='0', tax_code = 'SR', title = 'Total Sales (Excl GST)',  `value` = '" . (float) $total_subtotal . "', sort_order = '1'");

        $this->db->query("INSERT INTO " . DB_PREFIX . "order_total SET order_id = '" . (int) $order_id . "', code = 'shipping',tax_key ='', tax_code = 'SR', title = 'Free Shipping',  `value` = '0.00', sort_order = '2'");

        $this->db->query("INSERT INTO " . DB_PREFIX . "order_total SET order_id = '" . (int) $order_id . "', code = 'tax',tax_key ='88', tax_code = 'SR', title = 'GST (6%)',  `value` = '" . (float) $final_tax . "', sort_order = '2'");

        $this->db->query("INSERT INTO " . DB_PREFIX . "order_total SET order_id = '" . (int) $order_id . "', code = 'rounding',tax_key ='0', tax_code = '', title = 'Rounding',  `value` = '" . (float) $final_rounding . "', sort_order = '3'");

        $this->db->query("INSERT INTO " . DB_PREFIX . "order_total SET order_id = '" . (int) $order_id . "', code = 'total',tax_key ='0', tax_code = '', title = 'Total Sales (Incl GST)',  `value` = '" . (float) $final_totals . "', sort_order = '4'");

        // Update order table
        $this->db->query("UPDATE " . DB_PREFIX . "order SET total = '" . (float)$final_totals . "' , total_weight = '" . (float)$final_weight . "' WHERE order_id = '" . (int)$order_id . "'");

        return (int)$order_id;
    }

    public function getPreviousProduct($order_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_product WHERE order_id = '" . (int) $order_id . "'");
        return  $query->rows;
    }

    public function getCurrentOrderStatus($order_id)
    {
        $order_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order WHERE 1 AND order_id = '" . (int) $order_id . "'");
        return !empty($order_query->row['order_status_id']) ? $order_query->row['order_status_id'] : 0;
    }

    public function updateStock($order_id, $order_status_id, $current_status_id)
    {
        $order_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order WHERE 1 AND order_id = '" . (int) $order_id . "'");
        $previous_order_status_id = $current_status_id; //$order_query->row['order_status_id'];

        $invoice_prefix = !empty($order_query->row['invoice_prefix']) ? $order_query->row['invoice_prefix'] : '';

        if ((int) $order_status_id != 5 && (int) $previous_order_status_id == 5) {
            $product_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_product WHERE order_id = '" . (int) $order_id . "'");

            foreach ($product_query->rows as $product) {

                $product_weight = $product['total_weight'];

                $this->db->query("UPDATE " . DB_PREFIX . "product_to_store SET onhand_quantity = (onhand_quantity + " . (float) $product_weight . ") WHERE product_id = '" . (int) $product['product_id'] . "' AND store_id =" . (int) $this->session->data['store_id']);

                $option_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_option WHERE order_id = '" . (int) $order_id . "' AND order_product_id = '" . (int) $product['order_product_id'] . "'");

                foreach ($option_query->rows as $option) {
                    $this->db->query("UPDATE " . DB_PREFIX . "product_option_value SET quantity = (quantity + " . (int) $product['quantity'] . ") WHERE product_option_value_id = '" . (int) $option['product_option_value_id'] . "' AND subtract = '1'");
                }
            }
        }

        if ((int) $order_status_id == 5 && (int) $previous_order_status_id != 5) {
            if (empty($invoice_prefix)) {
                $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'pos/pos', 'store' => $this->session->data['store_id']));

                $this->db->query("UPDATE " . DB_PREFIX . "order 
                                                SET invoice_prefix = '" . $invoice_prefix . "' 
                                                WHERE order_id = '" . $order_id . "'");

                $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'pos/pos', 'store' => $this->session->data['store_id']));
            }

            $product_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_product WHERE order_id = '" . (int) $order_id . "'");

            foreach ($product_query->rows as $product) {

                $product_weight = $product['total_weight'];

                $this->db->query("UPDATE " . DB_PREFIX . "product_to_store SET onhand_quantity = (onhand_quantity - " . (float) $product_weight . ") WHERE product_id = '" . (int) $product['product_id'] . "' AND store_id =" . (int) $this->session->data['store_id']);

                //$option_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_option WHERE order_id = '" . (int) $order_id . "' AND order_product_id = '" . (int) $product['order_product_id'] . "'");

                /*foreach ($option_query->rows as $option) {
                    $this->db->query("UPDATE " . DB_PREFIX . "product_option_value SET quantity = (quantity - " . (int) $product['quantity'] . ") WHERE product_option_value_id = '" . (int) $option['product_option_value_id'] . "' AND subtract = '1'");
                }*/
            }
        }
    }

    public function editOrderWholesaler($data = array())
    {
        $this->load->model('setting/store');
        $this->load->model('sale/customer');
        $this->load->model('localisation/currency');
        $this->load->model('catalog/product');
        $this->load->model('pos/extension');

        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'pos/pos', 'store' => $this->session->data['store_id']));
        if (!empty($this->request->post['invoice_prefix']) && $invoice_prefix == $this->request->post['invoice_prefix']) {
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'pos/pos', 'store' => $this->session->data['store_id']));
        } elseif(!empty($data['invoice_prefix'])) {
            $invoice_prefix = $data['invoice_prefix'];
        } else{
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'pos/pos', 'store' => $this->session->data['store_id']));
        }

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $store_info = $this->model_setting_store->getStore($this->session->data['store_id']);
        $customer_info = $this->model_sale_customer->getCustomer($data['wholesaler_id']);
        $currency_info = $this->model_localisation_currency->getCurrencyByCode($this->config->get('config_currency'));

        if (!empty($data['payment_address'])) {
            $address_info = $this->model_sale_order_wholesaler->getAddress($data['payment_address']);
            if (!empty($address_info['zone_id']) && $address_info['zone_id'] > 0) {
                $payment_zone = $this->model_sale_order_wholesaler->getZone($address_info['zone_id']);
            } else {
                $payment_zone = '';
            }
            if (!empty($address_info['country_id']) && $address_info['country_id']) {
                $payment_country =  $this->model_sale_order_wholesaler->getCountry($address_info['country_id']);
            } else {
                $payment_country = '';
            }
            $payment_firstname = $address_info['firstname'];
            $payment_lastname = $address_info['lastname'];
            $payment_company = $address_info['company'];
            $payment_address_1 = $address_info['address_1'];
            $payment_address_2 = $address_info['address_2'];
            $payment_address_3 = $address_info['address_3'];
            $payment_postcode = $address_info['postcode'];
            $payment_city = $address_info['city'];
            $payment_zone_id = $address_info['zone_id'];
            $payment_zone       = $payment_zone;
            $payment_country_id = $address_info['country_id'];
            $payment_country    = $payment_country;
        } else {
            $payment_firstname = '';
            $payment_lastname = '';
            $payment_company = '';
            $payment_address_1 = '';
            $payment_address_2 = '';
            $payment_address_3 = '';
            $payment_postcode = '';
            $payment_city = '';
            $payment_zone_id = '';
            $payment_zone = '';
            $payment_country_id = '';
            $payment_country = '';
        }
        if (!empty($data['shipping_address'])) {
            $ship_address = $this->model_sale_order_wholesaler->getAddress($data['shipping_address']);
            if (!empty($ship_address['zone_id']) && $ship_address['zone_id'] > 0) {
                $ship_zone = $this->model_sale_order_wholesaler->getZone($ship_address['zone_id']);
            } else {
                $ship_zone = '';
            }
            if (!empty($ship_address['country_id']) && $ship_address['country_id']) {
                $ship_country = $this->model_sale_order_wholesaler->getCountry($ship_address['country_id']);
            } else {
                $ship_country = '';
            }
            $shipping_address_id = $data['shipping_address'];
            $shipping_firstname = $ship_address['firstname'];
            $shipping_lastname = $ship_address['lastname'];
            $shipping_company = $ship_address['company'];
            $shipping_address_1 = $ship_address['address_1'];
            $shipping_address_2 = $ship_address['address_2'];
            $shipping_address_3 = $ship_address['address_3'];
            $shipping_postcode = $ship_address['postcode'];
            $shipping_city = $ship_address['city'];
            $shipping_zone_id = $ship_address['zone_id'];
            $shipping_zone = $ship_zone;
            $shipping_country_id = $ship_address['country_id'];
            $shipping_country = $ship_country;
        } else {
            $shipping_address_id = '';
            $shipping_firstname = '';
            $shipping_lastname = '';
            $shipping_company = '';
            $shipping_address_1 = '';
            $shipping_address_2 = '';
            $shipping_address_3 = '';
            $shipping_postcode = '';
            $shipping_city = '';
            $shipping_zone_id = '';
            $shipping_zone = '';
            $shipping_country_id = '';
            $shipping_country = '';
        }
        if ($store_info) {
            $store_name = $store_info['name'];
            $store_url = $store_info['url'];
        } else {
            $store_name = $this->config->get('config_name');
            $store_url = HTTP_CATALOG;
        }
        if ($currency_info) {
            $currency_id = $currency_info['currency_id'];
            $currency_code = $currency_info['code'];
            $currency_value = $currency_info['value'];
        } else {
            $currency_id = 0;
            $currency_code = $this->config->get('config_currency');
            $currency_value = 1.00000;
        }

        $payment_code = !empty($data['payment_method']) ? $data['payment_method'] : 'pay_by_cash';
        $payment_name = $this->getPaymentMethodName($payment_code);
        $invoice_date = !empty($data['date_added']) ? $data['date_added'] : date('Y-m-d');

        $customer_group_id = !empty($this->config->get('config_order_wholesaler_customer_group')) ? $this->config->get('config_order_wholesaler_customer_group') : $customer_info['customer_group_id'];

        $order_id = $data['order_id'];

        $order_query = $this->db->query("SELECT order_status_id FROM `" . DB_PREFIX . "order` WHERE 1 AND order_id = '" . (int) $order_id . "'");
        $previous_order_status_id = $order_query->row['order_status_id'];
        if ($data['status'] == 1 && $previous_order_status_id == 5) {
            $product_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_product WHERE order_id = '" . (int) $order_id . "'");

            foreach ($product_query->rows as $product) {

                $product_weight = $product['total_weight'];

                $this->db->query("UPDATE " . DB_PREFIX . "product_to_store SET onhand_quantity = (onhand_quantity + " . (float) $product_weight . ") WHERE product_id = '" . (int)$product['product_id'] . "' AND store_id =" . (int)$this->session->data['store_id']);

                $option_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_option WHERE order_id = '" . (int)$order_id . "' AND order_product_id = '" . (int)$product['order_product_id'] . "'");

                foreach ($option_query->rows as $option) {
                    $this->db->query("UPDATE " . DB_PREFIX . "product_option_value SET quantity = (quantity + " . (int)$product['quantity'] . ") WHERE product_option_value_id = '" . (int)$option['product_option_value_id'] . "' AND subtract = '1'");
                }
            }
        }

        $this->db->query("UPDATE " . DB_PREFIX . "order SET store_id = '" . (int)$this->session->data['store_id'] . "', store_name = '" . $this->db->escape($store_name) . "', store_url = '" . $this->db->escape($store_url) . "', customer_id = '" . (int)$data['wholesaler_id'] . "', user_id = '" . (int)$this->session->data['user_id'] . "', card_no = '" . $this->db->escape($customer_info['customer_card']) . "', customer_group_id = '" . (int)$customer_group_id . "', firstname = '" . $this->db->escape($customer_info['firstname']) . "', lastname = '" . $this->db->escape($customer_info['lastname']) . "', email = '" . $this->db->escape($customer_info['email']) . "', telephone = '" . $this->db->escape($customer_info['telephone']) . "', fax = '" . $this->db->escape($customer_info['fax']) . "', payment_firstname = '" . $this->db->escape($payment_firstname) . "', payment_lastname = '" . $this->db->escape($payment_lastname) . "', payment_company = '" . $this->db->escape($payment_company) . "', payment_address_1 = '" . $this->db->escape($payment_address_1) . "', payment_address_2 = '" . $this->db->escape($payment_address_2) . "', payment_address_3 = '" . $this->db->escape($payment_address_3) . "', payment_city = '" . $this->db->escape($payment_city) . "', payment_postcode = '" . $this->db->escape($payment_postcode) . "', payment_country = '" . $this->db->escape($payment_country) . "', payment_country_id = '" . (int)$payment_country_id . "', payment_zone = '" . $this->db->escape($payment_zone) . "', payment_zone_id = '" . (int)$payment_zone_id . "', payment_method = '" . $this->db->escape($payment_name) . "', payment_code = '" . $this->db->escape($payment_code) . "',  shipping_firstname = '" . $this->db->escape($shipping_firstname) . "', shipping_lastname  = '" . $this->db->escape($shipping_lastname) . "', shipping_company = '" . $this->db->escape($shipping_company) . "', shipping_address_id = '" . (int)$shipping_address_id . "', shipping_address_1 = '" . $this->db->escape($shipping_address_1) . "', shipping_address_2 = '" . $this->db->escape($shipping_address_2) . "', shipping_address_3 = '" . $this->db->escape($shipping_address_3) . "', shipping_city = '" . $this->db->escape($shipping_city) . "', shipping_postcode = '" . $this->db->escape($shipping_postcode) . "', shipping_zone = '" . $this->db->escape($shipping_zone) . "', shipping_zone_id = '" . (int)$shipping_zone_id . "', shipping_country = '" . $this->db->escape($shipping_country) . "', shipping_country_id = '" . (int)$shipping_country_id . "', shipping_method = 'Free Shipping', order_status_id = '" . (int) $data['status'] . "', language_id = '" . (int) $this->config->get('config_language_id') . "', 
		currency_id = '" . (int) $currency_id . "', currency_code = '" . $this->db->escape($currency_code) . "', currency_value = '" . (float) $currency_value . "', invoice_wholesaler = '1', invoice_prefix = '" . $data['invoice_prefix'] . "', invoice_date = '" . $this->db->escape($invoice_date) . "', comment = '" . $this->db->escape($data['comment']) . "', stock_affect = '" . (isset($data['stock_affect']) ? 1 : 0) . "', date_modified = NOW(), 
		modifi_by = '" . $this->session->data['user_id'] . "' WHERE order_id = '" . (int) $data['order_id'] . "'");

        if (!empty($order_id) && empty($invoice_date) && !empty($invoice_prefix)) {
            $this->db->query("UPDATE `oc_order` SET invoice_date = NOW() WHERE order_id = '" . (int)$order_id . "'");
        }

        if (!empty($data['status']) && $data['status'] == 5) {
            $this->db->query("UPDATE `oc_order` SET date_completed = NOW(), completed_by = '" . (int)$this->session->data['user_id'] . "' WHERE order_id = '" . (int)$order_id . "'");
        }

        if (!empty($order_id) && !empty($data['status'])) {
            $this->db->query("INSERT `oc_order_history` SET order_id = '" . (int)$order_id . "', order_status_id = '" . (int)$data['status'] . "', notify = '0', comment = '', date_added = NOW() ");
        }

        $order_products = $data['product_item'];

        $total_order = 0;
        $total_weight_value = 0;
        $total_tax = 0;
        $total_subtotal = 0;

        $this->db->query("DELETE FROM " . DB_PREFIX . "order_product WHERE order_id = '" . (int) $order_id . "'");

        foreach ($order_products as $product) {
            $product_total = $product['hidden-total'];
            $product_subtotal = $product['hidden-subtotal'];
            $product_weight = $product['total_weight'];
            $product_tax = $product['hidden-taxes'];

            $total_order += $product_total;
            $total_tax += $product_tax;
            $total_weight_value += $product_weight;
            $total_subtotal += $product_subtotal;

            $product_info = $this->model_catalog_product->getProduct($product['product_id']);

            if (!empty($product_info['tax_class_id'])) {
                $tax_class_id = $product_info['tax_class_id'];
            } else {
                $tax_class_id = 11;
            }

            // Insert OC_PRODUCT LIST
            $this->db->query("INSERT INTO " . DB_PREFIX . "order_product SET order_id = '" . (int)$order_id . "', product_id = '" . (int)$product['product_id'] . "', name = '" . $this->db->escape($product_info['name']) . "', model = '" . $this->db->escape($product_info['model']) . "', quantity = '" . (float)$product['quantity'] . "', tax_class_id = '" . (int)$tax_class_id . "', tax_format = '" . $this->db->escape($product['format']) . "', tax_code = '" . $this->db->escape($this->tax->getClassCode($product_info['tax_class_id'])) . "', weight = '" . (float)$product_info['weight'] . "', weight_class_id = '" . (int)$product['product_weight_class'] . "', total_weight = '" . (float)$product['total_weight'] . "', default_conversion = '" . (int)$product['default_product_weight_class'] . "', usedqty = '1', price = '" . (float)$product['product_price'] . "',net_amount = '" . (float)$product['product_price'] . "', total_net_amount = '" . (float)$product['hidden-subtotal'] . "', total = '" . (float)$product['hidden-total'] . "', tax = '" . (float)$product['hidden-tax'] . "', total_tax = '" . (float)$product['hidden-taxes'] . "'");

            if ($data['status'] == '5' && isset($data['stock_affect'])) {
                //$this->db->query("UPDATE oc_product_to_store SET onhand_quantity = (onhand_quantity - " . (float)$product['total_weight'] . ") WHERE product_id = '" . (int)$product['product_id'] . "' AND store_id =" . (int)$this->session->data['store_id']);
            }
        }

        $total_subtotal = $total_subtotal;
        $total_order = $total_order;
        $final_tax = $total_tax;
        $final_total = round($total_order, 2);
        $round1 = round($final_total / 0.05, 0);
        $round2 = $round1 * 0.05;
        $round3 = $round2 - $final_total;
        $final_rounding = round($round3, 2);

        $final_totals = (float) $final_total + (float) $final_rounding;
        $final_weight = $total_weight_value;

        $this->db->query("UPDATE " . DB_PREFIX . "order_total SET  `value` = '" . (float)$total_subtotal . "' WHERE order_id = '" . (int)$order_id . "' AND code='sub_total' ");

        $this->db->query("UPDATE " . DB_PREFIX . "order_total SET `value` = '0.00' WHERE order_id = '" . (int) $order_id . "' AND code = 'shipping' ");

        $this->db->query("UPDATE " . DB_PREFIX . "order_total SET  `value` = '" . (float)$final_tax . "' WHERE order_id = '" . (int)$order_id . "' AND code='tax'");

        $this->db->query("UPDATE " . DB_PREFIX . "order_total SET  `value` = '" . (float)$final_rounding . "' WHERE order_id = '" . (int)$order_id . "' AND code='rounding' ");

        $this->db->query("UPDATE " . DB_PREFIX . "order_total SET  `value` = '" . (float)$final_totals . "' WHERE order_id = '" . (int)$order_id . "' AND code='total' ");

        // Update order table
        $this->db->query("UPDATE " . DB_PREFIX . "order SET total = '" . (float)$final_totals . "' , total_weight = '" . (float)$final_weight . "' WHERE order_id = '" . (int)$order_id . "'");

        return (int)$order_id;
    }

    public function getAddress($address_id)
    {
        $get_address_query = "SELECT * FROM `" . DB_PREFIX . "address` WHERE address_id = '" . (int) $address_id . "'";

        $query = $this->db->query($get_address_query);

        return $query->row;
    }

    public function getZone($zone_id)
    {
        $get_zone_query = "SELECT name FROM `" . DB_PREFIX . "zone` WHERE zone_id = '" . (int) $zone_id . "'";

        $query = $this->db->query($get_zone_query);

        return $query->row['name'];
    }

    public function getCountry($country_id)
    {
        $get_country_query = "SELECT name FROM `" . DB_PREFIX . "country` WHERE country_id = '" . (int) $country_id . "'";

        $query = $this->db->query($get_country_query);

        return $query->row['name'];
    }

    public function getTaxes($order_id)
    {
        $get_products_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_product WHERE order_id = '" . (int) $order_id . "'");

        $products = $get_products_query->rows;
        $tax_data = [];
        foreach ($products as $product) {
            if ($product['tax_class_id']) {
                $tax_rates = $this->tax->getRates($product['price'], $product['tax_class_id']);
                foreach ($tax_rates as $tax_rate) {
                    if (!isset($tax_data[$tax_rate['tax_rate_id']])) {
                        $tax_data[$tax_rate['tax_rate_id']] = ($tax_rate['amount'] * $product['quantity']);
                    } else {
                        $tax_data[$tax_rate['tax_rate_id']] += ($tax_rate['amount'] * $product['quantity']);
                    }
                }
            }
        }

        return $tax_data;
    }

    //New added by Yi Xuan on 8/9/2016
    public function getWeightClass()
    {
        $sql = "SELECT DISTINCT wc.weight_class_id, wc.value, wcd.title, wcd.unit FROM " . DB_PREFIX . "weight_class wc 
		LEFT JOIN oc_weight_class_description wcd ON wc.weight_class_id = wcd.weight_class_id";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    //New added by Yi Xuan on 8/9/2016
    public function checkDiscount($data = array())
    {
        $sql = "SELECT price FROM `" . DB_PREFIX . "product_discount`";

        if (!empty($data['product_id'])) {
            $sql .= " WHERE product_id = '" . (int) $this->db->escape($data['product_id']) . "'";

            if (!empty($data['customer_group_id'])) {
                $sql .= " AND customer_group_id = '" . (int) $this->db->escape($data['customer_group_id']) . "'";
            }

            if (!empty($data['product_quantity'])) {
                $sql .= " AND '" . (int) $this->db->escape($data['product_quantity']) . "' >= quantity ";
            }

            if (!empty($data['date'])) {
                $sql .= " AND DATE(" . $this->db->escape($data['date']) . ") BETWEEN DATE(date_start) AND DATE(date_end) ";
            }
            $sql .= " GROUP BY priority ASC LIMIT 1 ";
        } else {
        }

        $query = $this->db->query($sql);
        if ($query->num_rows) {
            return $query->rows;
        } else {
            return;
        }
    }

    public function checkSpecial($data = array())
    {
        $sql = "SELECT price FROM `" . DB_PREFIX . "product_special`";

        if (!empty($data['product_id'])) {
            $sql .= " WHERE product_id = '" . (int) $this->db->escape($data['product_id']) . "'";

            if (!empty($data['customer_group_id'])) {
                $sql .= " AND customer_group_id = '" . (int) $this->db->escape($data['customer_group_id']) . "'";
            }

            if (!empty($data['date'])) {
                $sql .= " AND DATE(" . $this->db->escape($data['date']) . ") BETWEEN DATE(date_start) AND DATE(date_end) ";
            }
            $sql .= " GROUP BY priority ASC LIMIT 1 ";
        } else {
        }

        $query = $this->db->query($sql);
        if ($query->num_rows) {
            return $query->rows;
        } else {
            return;
        }
    }

    public function getProductCode($product_id)
    {
        $sql = "SELECT code FROM `" . DB_PREFIX . "product` WHERE product_id = " . (int) $product_id;

        $query = $this->db->query($sql);

        return $query->row['code'];
    }

    public function getWeightValue($weight_class_id)
    {
        $sql = "SELECT value FROM `" . DB_PREFIX . "weight_class` WHERE weight_class_id = '" . (int) $weight_class_id . "'";

        $query = $this->db->query($sql);

        return !empty($query->row['value']) ? $query->row['value'] : 1;
    }

    public function getShippingAddress($customer_id)
    {
        $sql = "SELECT * FROM `" . DB_PREFIX . "address` WHERE customer_id = '" . (int) $customer_id . "'";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getShippingAddress2($address_id)
    {
        $sql = "SELECT * FROM `" . DB_PREFIX . "address` WHERE address_id ='" . (int) $address_id . "'";
        $query = $this->db->query($sql);
        $data = array();
        $addresses = $query->rows;
        if (!empty($addresses)) {
            foreach ($addresses as $aid => $address) {
                $name = $address['firstname'] . $address['lastname'];
                if (!empty($address['zone_id'])) {
                    $zone = $this->model_sale_order_wholesaler->getZoneById($address['zone_id']);
                } else {
                    $zone = '';
                }
                if (!empty($address['country_id'])) {
                    $country = $this->model_sale_order_wholesaler->getCountryById($address['country_id']);
                } else {
                    $country = '';
                }
                $address_name = $address['address_1'] . ' ' . $address['address_2'] . ' ' . $address['address_3'] . ' ' . $address['postcode'] . ' ' . $address['city'] . ' ' . $zone . ' ' . $country;
                $final_address = $name . ' , ' . $address_name;
                $data[$address['address_id']]['address'] = $final_address;
            }
        } else {
            $data = array();
        }
        return $data;
    }

    public function getZoneById($zone_id)
    {
        $sql = "SELECT name FROM `" . DB_PREFIX . "zone` WHERE zone_id ='" . (int) $zone_id . "'";
        $query = $this->db->query($sql);
        return $query->row['name'];
    }

    public function getCountryById($country_id)
    {
        $sql = "SELECT name FROM `" . DB_PREFIX . "country` WHERE country_id ='" . (int) $country_id . "'";
        $query = $this->db->query($sql);
        return $query->row['name'];
    }

    public function getCustomerAddress($customer_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "address WHERE customer_id = '" . (int)$customer_id . "'";
        $query = $this->db->query($sql);
        $data = array();
        $addresses = $query->rows;
        if (!empty($addresses)) {
            foreach ($addresses as $aid => $address) {
                $name = $address['firstname'] . $address['lastname'];
                if (!empty($address['zone_id'])) {
                    $zone = $this->getZoneById($address['zone_id']);
                } else {
                    $zone = '';
                }
                if (!empty($address['country_id'])) {
                    $country = $this->getCountryById($address['country_id']);
                } else {
                    $country = '';
                }
                $address_name = $address['address_1'] . ' ' . $address['address_2'] . ' ' . $address['address_3'] . ' ' . $address['postcode'] . ' ' . $address['city'] . ' ' . $zone . ' ' . $country;
                $final_address = $name . ' , ' . $address_name;
                $address_id = $address['address_id'];
                $data[$address['address_id']]['address'] = $final_address;
                $data[$address['address_id']]['address_id'] = $address_id;
            }
        } else {
            $data = array();
        }
        return $data;
    }

    //add by alia
    public function get_settings()
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "setting WHERE code='config_order_wholesaler'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function get_setting_by_key($key)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "setting WHERE `key` ='config_order_wholesaler_customer_group'";

        $query = $this->db->query($sql);

        return $query->row;
    }
    public function save_settings($data)
    {
        foreach ($data as $key => $data_row) {
            $check_sql = "SELECT * FROM " . DB_PREFIX . "setting WHERE `key` ='config_order_wholesaler_customer_group'";

            $check_query = $this->db->query($check_sql);

            $check_row = $check_query->row;

            if (!empty($check_row)) {
                $this->db->query("DELETE FROM " . DB_PREFIX . "setting WHERE `key` ='config_order_wholesaler_customer_group'");
            }

            if (is_array($data_row)) {
                $serialized = 1;
                $serialized_data = serialize($data_row);
            } else {
                $serialized = 0;
                $serialized_data = $data_row;
            }

            $sql = "INSERT INTO " . DB_PREFIX . "setting SET `key` = 'config_order_wholesaler_customer_group', code='config_order_wholesaler', value = '" . $this->db->escape($serialized_data) . "', serialized = '" . (int) $serialized . "'";

            $query = $this->db->query($sql);
        }
    }
}
