<?php

class ModelSaleCustomerPayment extends Model {

    public function getPaymentMethods() {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer_payment_method WHERE status = '1' ORDER BY sort_order ASC";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getCustomerPayment($customer_payment_id) {
        $sql = "SELECT cp.*, CONCAT(c.firstname,' ',c.lastname) AS customer_name,
                c.customer_ic AS customer_ic, cpm.payment_method_name FROM " . DB_PREFIX . "customer_payment cp
                LEFT JOIN " . DB_PREFIX . "customer c
                ON c.customer_id = cp.customer_id 
                LEFT JOIN " . DB_PREFIX . "customer_payment_method cpm
                ON cpm.customer_payment_method_id = cp.customer_payment_method_id 
                WHERE cp.customer_payment_id = '" . (int) $customer_payment_id . "'";

        $query = $this->db->query($sql);

        $customer_payment_row = $query->row;

        $customer_payment_row['transactions'] = [];
        $total_amount = 0;
        $total_outstanding_amount = 0;
        $total_pay_amount = 0;

        $transaction_query = $this->db->query("SELECT cpt.*, o.date_added,
                                              o.invoice_prefix FROM " . DB_PREFIX . "customer_payment_transaction cpt
                                              LEFT JOIN " . DB_PREFIX . "order o
                                              ON cpt.order_id = o.order_id 
                                              WHERE cpt.customer_payment_id = '" . (int) $customer_payment_id . "' ORDER BY cpt.cpt_id ASC");

        $transaction_rows = $transaction_query->rows;

        if (!empty($transaction_rows)) {
            foreach ($transaction_rows as $transaction) {
                $customer_payment_row['transactions'][] = [
                    'order_id' => $transaction['order_id'],
                    'invoice_prefix' => $transaction['invoice_prefix'],
                    'date' => date($this->language->get('date_format_short'), strtotime($transaction['date_added'])),
                    'amount' => $transaction['amount'],
                    'outstanding_amount' => $transaction['outstanding_amount'],
                    'pay_amount' => $transaction['pay_amount'],
                    'paid' => $transaction['paid']
                ];

                $total_amount += $transaction['amount'];
                $total_outstanding_amount += $transaction['outstanding_amount'];
                $total_pay_amount += $transaction['pay_amount'];
            }
        }

        $customer_payment_row['total_amount'] = sprintf('%0.2f', $total_amount);
        $customer_payment_row['total_outstanding_amount'] = sprintf('%0.2f', $total_outstanding_amount);
        $customer_payment_row['total_pay_amount'] = sprintf('%0.2f', $total_pay_amount);

        return $customer_payment_row;
    }

    public function getCustomerTransactions($customer_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "order WHERE customer_id = '" . (int) $customer_id . "' AND order_status_id = '5' ORDER BY order_id DESC";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getCustomerPaymentTransactions($order_id, $customer_payment_id = false) {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer_payment_transaction cpt WHERE cpt.order_id = '" . (int) $order_id . "'";

        if ($customer_payment_id) {
            $sql .= " AND cpt.customer_payment_id = '" . (int) $customer_payment_id . "'";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getCustomerPaymentTransaction($order_id, $customer_payment_id = false) {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer_payment_transaction cpt WHERE cpt.order_id = '" . (int) $order_id . "'";

        if ($customer_payment_id) {
            $sql .= " AND cpt.customer_payment_id = '" . (int) $customer_payment_id . "'";
        }

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getTotalCustomerPaymentTransactionHistory($order_id, $customer_payment_id) {
        $sql = "SELECT o.total AS total_amount, SUM(cpt.outstanding_amount) AS total_outstanding_amount, SUM(cpt.pay_amount) AS total_pay_amount FROM " . DB_PREFIX . "customer_payment cp LEFT JOIN " . DB_PREFIX . "customer_payment_transaction cpt ON cpt.customer_payment_id = cp.customer_payment_id LEFT JOIN " . DB_PREFIX . "order o ON o.order_id = cpt.order_id WHERE cpt.order_id = '" . (int) $order_id . "'";

        if ($customer_payment_id) {
            $sql .= " AND cp.customer_payment_id != '" . (int) $customer_payment_id . "'";
        }

        $sql .= " GROUP BY cpt.order_id";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getCustomers($data) {
        $sql = "SELECT *, CONCAT(c.firstname, ' ', c.lastname) AS name FROM " . DB_PREFIX . "customer c WHERE c.status = '1'";

        if (!empty($data['filter_name'])) {
            $sql .= " AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        }

        if (!empty($data['filter_ic'])) {
            $sql .= " AND c.customer_ic LIKE '%" . $this->db->escape($data['filter_ic']) . "%'";
        }

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY name";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getCustomerPayments($data) {
        $sql = "SELECT cp.customer_payment_id, cp.invoice_prefix, cp.payment_date,
                CONCAT(c.firstname, ' ', c.lastname) AS customer_name, 
                cp.date_added, cpm.payment_method_name, cp.paid_amount, 
                cp.unapplied_amount FROM " . DB_PREFIX . "customer_payment cp
                LEFT JOIN " . DB_PREFIX . "customer c
                ON c.customer_id = cp.customer_id 
                LEFT JOIN " . DB_PREFIX . "customer_payment_method cpm
                ON cpm.customer_payment_method_id = cp.customer_payment_method_id WHERE 1";

        if (!empty($data['filter_payment_date_from'])) {
            $sql .= " AND DATE(cp.payment_date) >= DATE('" . $this->db->escape($data['filter_payment_date_from']) . "')";
        }

        if (!empty($data['filter_payment_date_to'])) {
            $sql .= " AND DATE(cp.payment_date) <= DATE('" . $this->db->escape($data['filter_payment_date_to']) . "')";
        }

        if (!empty($data['filter_invoice_prefix'])) {
            $sql .= " AND cp.invoice_prefix LIKE '%" . $this->db->escape($data['filter_invoice_prefix']) . "%'";
        }

        if (!empty($data['filter_customer_name'])) {
            $sql .= " AND CONCAT(c.firstname, ' ', o.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'";
        }

        if (!empty($data['filter_customer_payment_method'])) {
            $sql .= " AND cp.customer_payment_method_id = '" . $this->db->escape($data['filter_customer_payment_method']) . "'";
        }

        $sort_data = array(
            'cp.customer_payment_id',
            'cp.invoice_prefix',
            'cp.payment_date',
            'customer',
            'cp.customer_payment_method_id',
            'cp.date_added',
            'cp.paid_amount',
            'cp.unapplied_amount'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY cp.invoice_prefix";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function addCustomerPayment($data) {
        $sql = "INSERT INTO " . DB_PREFIX . "customer_payment SET invoice_prefix = '" . $this->db->escape($data['invoice_prefix']) . "', payment_date = '" . $this->db->escape($data['payment_date']) . "', customer_id = '" . (int) $data['customer_id'] . "', description = '" . $this->db->escape($data['description']) . "', customer_payment_method_id = '" . (int) $data['customer_payment_method_id'] . "', cheque_num = '" . $this->db->escape($data['cheque_num']) . "', bank_charge = '" . $data['bank_charge'] . "', paid_amount = '" . $data['paid_amount'] . "', unapplied_amount = '" . $data['unapplied_amount'] . "', date_added = NOW(), add_by = '" . (int) $this->session->data['user_id'] . "', date_modified = NOW(), modify_by = '" . (int) $this->session->data['user_id'] . "'";

        $query = $this->db->query($sql);

        $customer_payment_id = $this->db->getLastId();

        if ($customer_payment_id > 0) {
            if (!empty($data['transactions'])) {
                foreach ($data['transactions'] as $transaction) {
                    if (isset($transaction['paid'])) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "customer_payment_transaction SET customer_payment_id = '" . (int) $customer_payment_id . "', order_id = '" . (int) $transaction['order_id'] . "', amount = '" . $transaction['amount'] . "', outstanding_amount = '" . $transaction['outstanding_amount'] . "', pay_amount = '" . $transaction['pay_amount'] . "', paid = '" . (int) $transaction['paid'] . "'");
                    }
                }
            }

            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'sale/customer_payment', 'store' => $this->session->data['store_id']));
        }

        return $customer_payment_id;
    }

    public function editCustomerPayment($data, $customer_payment_id) {
        $sql = "UPDATE " . DB_PREFIX . "customer_payment SET invoice_prefix = '" . $this->db->escape($data['invoice_prefix']) . "', payment_date = '" . $this->db->escape($data['payment_date']) . "', customer_id = '" . (int) $data['customer_id'] . "', description = '" . $this->db->escape($data['description']) . "', customer_payment_method_id = '" . (int) $data['customer_payment_method_id'] . "', cheque_num = '" . $this->db->escape($data['cheque_num']) . "', bank_charge = '" . $data['bank_charge'] . "', paid_amount = '" . $data['paid_amount'] . "', unapplied_amount = '" . $data['unapplied_amount'] . "', date_modified = NOW(), modify_by = '" . (int) $this->session->data['user_id'] . "' WHERE customer_payment_id = '" . (int) $customer_payment_id . "'";

        $query = $this->db->query($sql);

        $this->db->query("DELETE FROM " . DB_PREFIX . "customer_payment_transaction WHERE customer_payment_id = '" . (int) $customer_payment_id . "'");

        if (!empty($data['transactions'])) {
            foreach ($data['transactions'] as $transaction) {
                if (isset($transaction['paid'])) {
                    $this->db->query("INSERT INTO " . DB_PREFIX . "customer_payment_transaction SET customer_payment_id = '" . (int) $customer_payment_id . "', order_id = '" . (int) $transaction['order_id'] . "', amount = '" . $transaction['amount'] . "', outstanding_amount = '" . $transaction['outstanding_amount'] . "', pay_amount = '" . $transaction['pay_amount'] . "', paid = '" . (int) $transaction['paid'] . "'");
                }
            }
        }
    }

    public function getTotalCustomers($data = array()) {
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer WHERE customer_group_id = '1' AND status = '1'";

        if (!empty($data['customer_name'])) {
            $sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['customer_name']) . "%'";
        }

        if (!empty($data['customer_ic'])) {
            $sql .= " AND customer_ic LIKE '%" . $this->db->escape($data['customer_ic']) . "%'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getCustomersforopenwindow($data = array()) {
        $sql = "SELECT customer_id,
					   CONCAT(firstname, ' ', lastname) AS customer_name,
					   customer_ic,
					   customer_card
				FROM " . DB_PREFIX . "customer
				WHERE status = '1'";

        if (!empty($data['customer_name'])) {
            $sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['customer_name']) . "%'";
        }

        if (!empty($data['customer_ic'])) {
            $sql .= " AND customer_ic LIKE '%" . $this->db->escape($data['customer_ic']) . "%'";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }
            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

}

?>