<?php

class ModelSaleCarrier extends Model {

    public function addCarrier($data) {
        $this->db->query("INSERT INTO " . DB_PREFIX . "order_tracking_carriers SET 
		                  name   = '" . $this->db->escape($data['name']) . "',
		                  tracking_url    = '" . $this->db->escape($data['url']) . "'");

        $carrier_id = $this->db->getLastId();

        if (isset($data['image'])) {
            $this->db->query("UPDATE " . DB_PREFIX . "order_tracking_carriers SET 
			                  image = '" . $this->db->escape(html_entity_decode($data['image'], ENT_QUOTES, 'UTF-8')) . "' 
							  WHERE carrier_id  = '" . (int) $carrier_id . "'");
        }
    }

    public function editCarrier($carrier_id, $data) {
        $this->db->query("UPDATE " . DB_PREFIX . "order_tracking_carriers SET 
		                  name   = '" . $this->db->escape($data['name']) . "',
		                  tracking_url    = '" . $this->db->escape($data['url']) . "'
                                WHERE carrier_id = '" . (int) $carrier_id . "'");

        if (isset($data['image'])) {
            $this->db->query("UPDATE " . DB_PREFIX . "order_tracking_carriers SET 
			                  image = '" . $this->db->escape(html_entity_decode($data['image'], ENT_QUOTES, 'UTF-8')) . "' 
							  WHERE carrier_id = '" . (int) $carrier_id . "'");
        }
    }

    public function deleteCarrier($carrier_id) {
        $this->db->query("DELETE FROM " . DB_PREFIX . "order_tracking_carriers WHERE carrier_id = '" . (int) $carrier_id . "'");
        $this->cache->delete('carriers');
    }

    public function getTotalCarriers() {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "order_tracking_carriers");
        return $query->row['total'];
    }

    public function getCarriers($data = array()) {
        $sql = "SELECT * FROM " . DB_PREFIX . "order_tracking_carriers ORDER BY name";

        $query = $this->db->query($sql);

        return $query->rows;
    }
    
    public function getCarrier($carrier_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_tracking_carriers WHERE carrier_id = '" . (int)$carrier_id . "'");
		return $query->row;
	}

}
