<?php
class ModelReportTopup extends Model {
	//summary
	public function getTopupSummary($data){
	 
	    $sql = "SELECT *,ct.date_added AS date FROM " . DB_PREFIX . "customer_transaction ct" ." LEFT JOIN ".DB_PREFIX."customer cc ON  (ct.customer_id = cc.customer_id)";

		$implode = array();
		
		if (isset($data['filter_store_id'])) {
			$implode[] = "cc.store_id= '" . (int)$data['filter_store_id']. "'";
		}
		
		if (!empty($data['filter_action'])) {
			if($data['filter_action'] == 1){
			$implode[] = " ct.amount >='0'";
			}
			if($data['filter_action'] == 2){
			$implode[] = "ct.amount  <'0'";
			}
		}

		if (!empty($data['filter_date_start'])) {
			$implode[] = "DATE(ct.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}
    
		if (!empty($data['filter_date_end'])) {
			$implode[] = "DATE(ct.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		}
		
		if (!empty($data['filter_customername'])) {
			$implode[] = "cc.firstname LIKE '%" . $this->db->escape($data['filter_customername']) . "%'";
		}
		
		if (!empty($data['filter_customeric'])) {
			$implode[] = "cc.customer_ic = '" . $this->db->escape($data['filter_customeric']) . "'";
		}

		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}
        
		
		$sort_data = array(
		    'ct.date_added',
			'cc.firstname',
			'cc.customer_ic',
			'ct.amount',
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY ct.date_added";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		
		$query = $this->db->query($sql);

		return $query->rows;
	
	}
	
	public function getTopupSummaryTotal($data){
	   
	   $sql = "SELECT COUNT(ct.customer_transaction_id) AS total, SUM(ct.amount) AS amount FROM " . DB_PREFIX . "customer_transaction ct" ." LEFT JOIN ".DB_PREFIX."customer cc ON  (ct.customer_id = cc.customer_id)";

		$implode = array();
		
		if (isset($data['filter_store_id'])) {
			$implode[] = "cc.store_id= '" . (int)$data['filter_store_id']. "'";
		}
		
		if (!empty($data['filter_action'])) {
			if($data['filter_action'] == 1){
			$implode[] = " ct.amount >='0'";
			}
			if($data['filter_action'] == 2){
			$implode[] = "ct.amount  <'0'";
			}
		}

		if (!empty($data['filter_date_start'])) {
			$implode[] = "DATE(ct.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}
    
		if (!empty($data['filter_date_end'])) {
			$implode[] = "DATE(ct.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		}
		
		if (!empty($data['filter_customername'])) {
			$implode[] = "cc.firstname LIKE '%" . $this->db->escape($data['filter_customername']) . "%'";
		}
		
		if (!empty($data['filter_customeric'])) {
			$implode[] = "cc.customer_ic = '" . $this->db->escape($data['filter_customeric']) . "'";
		}

		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}
        
		
		$query = $this->db->query($sql);

		return $query->row;
	}
	
	
}