<?php
class ModelReportServiceformSummarybyTransaction extends Model {
	public function getServiceformSummaryByTransaction($data){
		$filter_statements = $this->getFiltersData($data);

		
		$limit_statement = "";
		if (!empty($data)) {
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}

				$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}
		}
		
		$sql = "
		SELECT
			sf.service_date AS service_date,
			sf.invoice_prefix AS invoice_prefix,
			sf.order_action AS payment_status,
			sf.serviceform_action AS service_status,
			c.customer_card AS card,
			c.customer_ic AS customer_ic,
			u.user_id AS doctor_id,
			DATE(IFNULL(o.invoice_date,o.date_added)) AS invoice_date,
			o.invoice_prefix AS invoice,
			CONCAT(c.firstname, ' ', c.lastname) AS name,
			SUM(si.total) AS total_price,
			sf.net_amount AS subtotal,
			sf.t_gst AS tax,
			sf.total_price AS total
			#SUM(CASE WHEN st.code = 'sub_total' THEN st.value ELSE 0 END) AS subtotal,
			#SUM(CASE WHEN st.code = 'tax' THEN st.value ELSE 0 END) AS tax,
			#SUM(CASE WHEN st.code = 'total' THEN st.value ELSE 0 END) AS total
		FROM " . DB_PREFIX . "service_form sf
		
		#INNER JOIN " . DB_PREFIX . "service_total st
		#ON sf.service_form_id = st.service_form_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		LEFT JOIN " . DB_PREFIX . "service_item si
		ON sf.service_form_id = si.service_form_id
		LEFT JOIN " . DB_PREFIX . "user u
		ON sf.user_id = u.user_id
		LEFT JOIN " . DB_PREFIX . "order o
		ON sf.order_id = o.order_id
		WHERE 1
		$filter_statements
		";
		$sql .= " GROUP BY sf.service_form_id ";
		$sql .= " ORDER BY IFNULL(IFNULL(o.invoice_date,o.date_added),sf.service_date) DESC ";
        $sql .= $limit_statement;
		// echo"<pre>";
		// print_r($sql);
		// echo"</pre>";
		
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
	
	public function getServiceformSummaryByTransactionTotal($data){
		$filter_statements = $this->getFiltersData($data);

		
		
		$sql = "
		SELECT COUNT(*) AS total FROM(
			SELECT
			sf.service_date AS service_date,
			sf.invoice_prefix AS invoice_prefix,
			c.customer_card AS card,
			c.customer_ic AS customer_ic,
			u.user_id AS doctor_id,
			DATE(IFNULL(o.invoice_date,o.date_added)) AS invoice_date,
			o.invoice_prefix AS invoice,
			CONCAT(c.firstname, ' ', c.lastname) AS name,
			sf.net_amount AS subtotal,
			sf.t_gst AS tax,
			sf.total_price AS total
			#SUM(CASE WHEN st.code = 'sub_total' THEN st.value ELSE 0 END) AS subtotal,
			#SUM(CASE WHEN st.code = 'tax' THEN st.value ELSE 0 END) AS tax,
			#SUM(CASE WHEN st.code = 'total' THEN st.value ELSE 0 END) AS total
			FROM " . DB_PREFIX . "service_form sf
		
			#INNER JOIN " . DB_PREFIX . "service_total st
			#ON sf.service_form_id = st.service_form_id
			LEFT JOIN " . DB_PREFIX . "customer c
			ON sf.customer_id = c.customer_id
			LEFT JOIN " . DB_PREFIX . "service_item si
			ON sf.service_form_id = si.service_form_id
			LEFT JOIN " . DB_PREFIX . "user u
			ON sf.user_id = u.user_id
			LEFT JOIN " . DB_PREFIX . "order o
			ON sf.order_id = o.order_id
		WHERE 1
		$filter_statements
		GROUP BY sf.service_form_id

		)a
		";
		// echo"<pre>";
		// print_r($sql);
		// echo"</pre>";
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}

	public function getServiceformSummaryByTransactionTotalAmount($data){
		$filter_statements = $this->getFiltersData($data);
		
		$sql = "
		SELECT
			sf.service_date AS service_date,
			sf.invoice_prefix AS invoice_prefix,
			sf.order_action AS payment_status,
			sf.serviceform_action AS service_status,
			c.customer_card AS card,
			c.customer_ic AS customer_ic,
			u.user_id AS doctor_id,
			DATE(IFNULL(o.invoice_date,o.date_added)) AS invoice_date,
			o.invoice_prefix AS invoice,
			CONCAT(c.firstname, ' ', c.lastname) AS name,
			SUM(si.total) AS total_price,
			sf.net_amount AS subtotal,
			sf.t_gst AS tax,
			sf.total_price AS total
			#SUM(CASE WHEN st.code = 'sub_total' THEN st.value ELSE 0 END) AS subtotal,
			#SUM(CASE WHEN st.code = 'tax' THEN st.value ELSE 0 END) AS tax,
			#SUM(CASE WHEN st.code = 'total' THEN st.value ELSE 0 END) AS total
			FROM " . DB_PREFIX . "service_form sf
		
		#INNER JOIN " . DB_PREFIX . "service_total st
		#ON sf.service_form_id = st.service_form_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		LEFT JOIN " . DB_PREFIX . "service_item si
		ON sf.service_form_id = si.service_form_id
		LEFT JOIN " . DB_PREFIX . "user u
		ON sf.user_id = u.user_id
		LEFT JOIN " . DB_PREFIX . "order o
		ON sf.order_id = o.order_id
		WHERE 1
		$filter_statements
		
		";
	
		$sql .= " GROUP BY sf.service_form_id ";
		$sql .= " ORDER BY service_date DESC ";
		// echo"<pre>";
		// print_r($sql);
		// echo"</pre>";
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
	
	public function getServiceformSummaryByTransactionTotalSubtotal($data){
		$filter_statements = $this->getFiltersData($data);

		
		$sql = "
		SELECT SUM(value) AS subtotal
		FROM " . DB_PREFIX . "service_total st
		INNER JOIN " . DB_PREFIX . "service_form sf
		ON st.service_form_id = sf.service_form_id
		INNER JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE st.code = 'sub_total'
		$filter_statements
		GROUP BY sf.service_form_id

		";
		
		$query = $this->db->query($sql);
		
		return $query->row['subtotal'];
	}
	
	public function getServiceformSummaryByTransactionTotalTax($data){
		$filter_statements = $this->getFiltersData($data);

		
		$sql = "
		SELECT SUM(value) AS tax
		FROM " . DB_PREFIX . "service_total st
		INNER JOIN " . DB_PREFIX . "service_form sf
		ON st.service_form_id = sf.service_form_id
		INNER JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE st.code = 'tax'
		$filter_statements
		GROUP BY sf.service_form_id

		";
		
		$query = $this->db->query($sql);
		
		return $query->row['tax'];
	}
	
	public function getServiceformSummaryByTransactionTotalSales($data){
		$filter_statements = $this->getFiltersData($data);

		
		$sql = "
		SELECT SUM(value) AS total
		FROM " . DB_PREFIX . "service_total st
		INNER JOIN " . DB_PREFIX . "service_form sf
		ON st.service_form_id = sf.service_form_id
		INNER JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE st.code = 'total'
		$filter_statements
		GROUP BY sf.service_form_id

		";
		
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	
	public function getServiceformSummaryByService($data){
		$language_id = (int)$this->config->get('config_language_id');
		
		$filter_statements = $this->getFiltersData($data);

		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT 
			cs.clinicalservice_id,
			csd.name,
			SUM(si.net_amount) AS subtotal,
			SUM(si.gst) AS tax,
			SUM(si.total) AS total
		FROM " . DB_PREFIX . "clinical_service cs
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON cs.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "service_item si
		ON cs.clinicalservice_id = si.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON si.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE 1
		AND csd.language_id = '" . (int)$language_id . "'
		$filter_statements
		";

		$sql .= " GROUP BY cs.clinicalservice_id ";
		$sql .= " ORDER BY name ASC ";
        $sql .= $limit_statement;
		
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
	
	public function getServiceformSummaryByServiceTotal($data){
		$language_id = (int)$this->config->get('config_language_id');
		
		$filter_statements = $this->getFiltersData($data);

		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT COUNT(*) AS total FROM(
		SELECT 
			cs.clinicalservice_id,
			csd.name,
			SUM(si.net_amount) AS subtotal,
			SUM(si.gst) AS tax,
			SUM(si.total) AS total
		FROM " . DB_PREFIX . "clinical_service cs
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON cs.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "service_item si
		ON cs.clinicalservice_id = si.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON si.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE 1
		AND csd.language_id = '" . (int)$language_id . "'
		$filter_statements
		GROUP BY cs.clinicalservice_id
		)a
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	
	public function getServiceformSummaryByServiceTotalSubtotal($data){
		$language_id = (int)$this->config->get('config_language_id');
		
		$filter_statements = $this->getFiltersData($data);

		
		$sql = "
		SELECT
			SUM(si.net_amount) AS subtotal
		FROM " . DB_PREFIX . "clinical_service cs
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON cs.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "service_item si
		ON cs.clinicalservice_id = si.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON si.service_form_id = sf.service_form_id
		WHERE 1
		AND csd.language_id = '" . (int)$language_id . "'
		$filter_statements
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['subtotal'];
	}
	
	public function getServiceformSummaryByServiceTotalTax($data){
		$language_id = (int)$this->config->get('config_language_id');
		
		$filter_statements = $this->getFiltersData($data);

		
		$sql = "
		SELECT
			SUM(si.gst) AS tax
		FROM " . DB_PREFIX . "clinical_service cs
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON cs.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "service_item si
		ON cs.clinicalservice_id = si.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON si.service_form_id = sf.service_form_id
		WHERE 1
		AND csd.language_id = '" . (int)$language_id . "'
		$filter_statements
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['tax'];
	}
	
	public function getServiceformSummaryByServiceTotalSales($data){
		$language_id = (int)$this->config->get('config_language_id');
		
		$filter_statements = $this->getFiltersData($data);

		$sql = "
		SELECT
			SUM(si.total) AS total
		FROM " . DB_PREFIX . "clinical_service cs
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON cs.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "service_item si
		ON cs.clinicalservice_id = si.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON si.service_form_id = sf.service_form_id
		WHERE 1
		AND csd.language_id = '" . (int)$language_id . "'
		$filter_statements
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	
	public function getServiceformSummaryByServiceInfo($clinicalservice_id, $data){
		$language_id = (int)$this->config->get('config_language_id');
		
		$filter_statements = $this->getFiltersData($data);

		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT
			sf.service_date AS service_date,
			sf.invoice_prefix AS invoice_prefix, 
			a.net_amount AS subtotal, 
			a.gst AS tax,
			a.total AS total
		FROM
		(
			SELECT *
			FROM " . DB_PREFIX . "service_item
			WHERE 1
			AND clinicalservice_id = '" . (int)$clinicalservice_id . "'
			GROUP BY service_form_id
		)a
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON a.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON a.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE 1
		AND csd.language_id = '" . (int)$language_id . "'
		$filter_statements
		$limit_statement
		";
		
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
	
	public function getServiceformSummaryByServiceInfoTotal($clinicalservice_id, $data){
		$language_id = (int)$this->config->get('config_language_id');
		
		$filter_statements = $this->getFiltersData($data);
		
		$sql = "
		SELECT COUNT(*) AS total FROM (
		SELECT
			sf.service_date AS service_date,
			sf.invoice_prefix AS invoice_prefix, 
			a.net_amount AS subtotal, 
			a.gst AS tax,
			a.total AS total
		FROM
		(
			SELECT *
			FROM " . DB_PREFIX . "service_item
			WHERE 1
			AND clinicalservice_id = '" . (int)$clinicalservice_id . "'
			GROUP BY service_form_id
		)a
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON a.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON a.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE 1
		AND csd.language_id = '" . (int)$language_id . "'
		$filter_statements
		)a
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	
	public function getServiceformSummaryByServiceInfoTotalSubtotal($clinicalservice_id, $data){
		$language_id = (int)$this->config->get('config_language_id');
		
		$filter_statements = $this->getFiltersData($data);

		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT
			SUM(a.net_amount) as subtotal
		FROM
		(
			SELECT *
			FROM " . DB_PREFIX . "service_item
			WHERE 1
			AND clinicalservice_id = '" . (int)$clinicalservice_id . "'
			GROUP BY service_form_id
		)a
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON a.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON a.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE 1
		AND csd.language_id = '" . (int)$language_id . "'
		$filter_statements
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['subtotal'];
	}
	
	public function getServiceformSummaryByServiceInfoTotalTax($clinicalservice_id, $data){
		$language_id = (int)$this->config->get('config_language_id');
		
		$filter_statements = $this->getFiltersData($data);
		
		$sql = "
		SELECT
			SUM(a.gst) as tax
		FROM
		(
			SELECT *
			FROM " . DB_PREFIX . "service_item
			WHERE 1
			AND clinicalservice_id = '" . (int)$clinicalservice_id . "'
			GROUP BY service_form_id
		)a
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON a.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON a.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE 1
		AND csd.language_id = '" . (int)$language_id . "'
		$filter_statements
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['tax'];
	}
	
	public function getServiceformSummaryByServiceInfoTotalSales($clinicalservice_id, $data){
		$language_id = (int)$this->config->get('config_language_id');
		
		$filter_statements = $this->getFiltersData($data);
		
		$sql = "
		SELECT
			SUM(a.total) as total
		FROM
		(
			SELECT *
			FROM " . DB_PREFIX . "service_item
			WHERE 1
			AND clinicalservice_id = '" . (int)$clinicalservice_id . "'
			GROUP BY service_form_id
		)a
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON a.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON a.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE 1
		AND csd.language_id = '" . (int)$language_id . "'
		$filter_statements
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}

	protected function getFiltersData($data) {
        // Filters
		$filter_statements = "";

        $filter_date_statement = '';
        if (!empty($data['filter_date_start']) && !empty($data['filter_date_end'])) {
            $filter_date_statement = " AND sf.`service_date`  BETWEEN '" . $this->db->escape($data['filter_date_start']) . "' AND  '" . $this->db->escape($data['filter_date_end']) . "'";
        } else if (!empty($data['filter_date_start']) && empty($data['filter_date_end'])) {
            $filter_date_statement = " AND sf.`service_date`  >= '" . $this->db->escape($data['filter_date_start']) . "'";
        } else if (empty($data['filter_date_start']) && !empty($data['filter_date_end'])) {
            $filter_date_statement = " AND sf.`service_date`  <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

		$filter_invoice_date_statement = '';
		if (!empty($data['filter_invoice_date_start']) && !empty($data['filter_invoice_date_end'])) {
            $filter_invoice_date_statement = " AND DATE(IFNULL(o.invoice_date,o.date_added))  BETWEEN '" . $this->db->escape($data['filter_invoice_date_start']) . "' AND  '" . $this->db->escape($data['filter_invoice_date_end']) . "'";
        } else if (!empty($data['filter_invoice_date_start']) && empty($data['filter_invoice_date_end'])) {
            $filter_invoice_date_statement = " AND DATE(IFNULL(o.invoice_date,o.date_added))  >= '" . $this->db->escape($data['filter_invoice_date_start']) . "'";
        } else if (empty($data['filter_invoice_date_start']) && !empty($data['filter_invoice_date_end'])) {
            $filter_invoice_date_statement = " AND DATE(IFNULL(o.invoice_date,o.date_added))  <= '" . $this->db->escape($data['filter_invoice_date_end']) . "'";
        }


		
		
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_ic_statement = (!empty($data['filter_customer_ic'])) ? 
		"AND sf.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";


		// if($data['filter_service_name'])
		// $filter_service_name = (!empty($data['filter_service_name'])) ?
		// 	"AND si.clinicalservice_id IN (" . (int)$data['filter_service_name'] . ")" :
		// 	"";
		// 	// var_dump(explode(',',$data['filter_service_name']));

		// $filter_service_name_deleted = ($data['filter_service_name'] == '*') ?
		// 	"AND si.servicename = ''" :
		// 	"";
		if($data['filter_service_name']=='*'){
			$filter_service_name = "AND (si.servicename = '' OR clinicalservice_id = '')";

		}else{
			if(in_array('*',explode(',',$data['filter_service_name']),true)){
				$service = substr($data['filter_service_name'],0,-2);
				$filter_service_name = "AND (si.clinicalservice_id IN (" . $this->db->escape($service) . ") OR (si.servicename = '' OR clinicalservice_id = ''))";
			}else{
				$filter_service_name = (!empty($data['filter_service_name'])) ?
				"AND si.clinicalservice_id IN (" . $this->db->escape($data['filter_service_name']) . ")" :
				"";
			}
		}
		
			$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND sf.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND sf.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";

        $filter_doctor_statement = !empty($data['filter_doctor_name']) ? " AND si.`user_id` IN (" . $this->db->escape($data['filter_doctor_name']) . ") " : "";

        $filter_status_id_statement = !empty($data['filter_status_id']) ? " AND sf.`serviceform_action` IN (" . $this->db->escape($data['filter_status_id']) . ") " : "";

        $filter_payment_status_statement = !empty($data['filter_payment_status']) ? " AND sf.`order_action` IN (" . $this->db->escape($data['filter_payment_status']) . ") " : "";

        $filter_store_id_statement = !empty($data['filter_store_id']) ? " AND sf.`store_id` IN (" . $this->db->escape($data['filter_store_id']) . ") " : "";

		// $filter_statements .= $filter_service_name_deleted;
		$filter_statements .= $filter_service_name;
		$filter_statements .= $filter_customer_name_statement;
		$filter_statements .= $filter_customer_ic_statement;
		$filter_statements .= $filter_customer_card_statement;
		$filter_statements .= $filter_transaction_start_statement;
		$filter_statements .= $filter_transaction_end_statement;
        $filter_statements .= $filter_date_statement;
		$filter_statements .= $filter_invoice_date_statement;
		$filter_statements .= $filter_doctor_statement;
		$filter_statements .= $filter_status_id_statement;
		$filter_statements .= $filter_payment_status_statement;
		$filter_statements .= $filter_store_id_statement;

        return $filter_statements;
    }

	public function orderstatus($data){

			$status = (!empty($data)) ? 
			"AND order_status_id IN (" . $data . ")" : 
			"";

		$sql = "SELECT name FROM " . DB_PREFIX . "order_status WHERE language_id = '" . (int)$this->config->get('config_language_id') . "' $status";
		
		$query = $this->db->query($sql);
		
		return $query->rows;

	}

	public function getServiceStatuses(){
		$sql="SELECT DISTINCT os.order_status_id , os.name  FROM oc_service_form sf LEFT JOIN oc_order_status os ON sf.serviceform_action = os.order_status_id AND language_id = '" . (int)$this->config->get('config_language_id') . "' WHERE 1 ORDER BY os.name ASC";
	
		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getPaymentStatuses(){
		$sql="SELECT DISTINCT os.order_status_id , os.name  FROM oc_service_form sf LEFT JOIN oc_order_status os ON sf.order_action = os.order_status_id AND language_id = '" . (int)$this->config->get('config_language_id') . "' WHERE 1 ORDER BY os.name ASC";
	
		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function status($status_id){
		$sql="SELECT GROUP_CONCAT(os.name SEPARATOR ', ') as status_name FROM " . DB_PREFIX . "order_status os WHERE os.order_status_id IN (".$this->db->escape($status_id).") AND language_id = '" . (int)$this->config->get('config_language_id') . "'";
	
		$query = $this->db->query($sql);

		return $query->row['status_name'];
	}
	public function getdoctorlist(){
		$sql="SELECT DISTINCT u.user_id AS doctor_id, CONCAT(u.firstname,' ',u.lastname,' ',u.chinesename) AS doctor_name FROM oc_service_item si INNER JOIN " . DB_PREFIX . "user u ON si.user_id = u.user_id WHERE 1 ORDER BY doctor_name ASC 
		";
		$query = $this->db->query($sql);

		return $query->rows;
	}
	public function getservicename(){
		$sql = "SELECT DISTINCT si.clinicalservice_id AS item_id, si.name AS item_name FROM  oc_clinical_service_description si WHERE 1 AND si.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY si.name ASC ";

		$query = $this->db->query($sql);

		return $query->rows;
	}

}
?>