<?php
class ModelReportServiceform extends Model {
	public function getServiceformSummaryByTransaction($data){
		$sort 	= isset($data['sort']) ? $data['sort'] : "service_date";

		$order 	= isset($data['order']) ? $data['order'] : "DESC";
		
		$filter_status_id_statement = (!empty($data['filter_status_id'])) ?
		"AND sf.serviceform_action = '" . (int)$data['filter_status_id'] . "'" :
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(sf.service_date) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(sf.service_date) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";

		$filter_invoice_date_start = (!empty($data['filter_invoice_date_start'])) ? 
		"AND DATE(CASE WHEN o.invoice_date IS NULL THEN o.date_added END) >= '" . $this->db->escape($data['filter_invoice_date_start']) . "'" : 
		"";
		
		$filter_invoice_date_end = (!empty($data['filter_invoice_date_end'])) ? 
		"AND DATE(CASE WHEN o.invoice_date IS NULL THEN o.date_added END) <= '" . $this->db->escape($data['filter_invoice_date_end']) . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND sf.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND sf.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND sf.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_ic_statement = (!empty($data['filter_customer_ic'])) ? 
		"AND sf.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND sf.firstname LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND sf.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ? 
		"AND sf.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT
			sf.service_date AS service_date,
			sf.invoice_prefix AS invoice_prefix,
			sf.order_action AS payment_status,
			sf.serviceform_action AS service_status,
			c.customer_card AS card,
			c.customer_ic AS customer_ic,
			u.user_id AS doctor_id,
			Date(CASE WHEN o.invoice_date IS NULL THEN o.date_added END) AS invoice_date,
			o.invoice_prefix AS invoice,
			CONCAT(c.firstname, ' ', c.lastname) AS name,
			sf.net_amount AS subtotal,
			sf.t_gst AS tax,
			sf.total_price AS total
			#SUM(CASE WHEN st.code = 'sub_total' THEN st.value ELSE 0 END) AS subtotal,
			#SUM(CASE WHEN st.code = 'tax' THEN st.value ELSE 0 END) AS tax,
			#SUM(CASE WHEN st.code = 'total' THEN st.value ELSE 0 END) AS total
		FROM " . DB_PREFIX . "service_form sf
		#INNER JOIN " . DB_PREFIX . "service_total st
		#ON sf.service_form_id = st.service_form_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		LEFT JOIN " . DB_PREFIX . "user u
		ON sf.user_id = u.user_id
		LEFT JOIN " . DB_PREFIX . "order o
		ON sf.order_id = o.order_id
		WHERE 1
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_invoice_date_start
		$filter_invoice_date_end
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_customer_card_statement
		$filter_customer_ic_statement
		$filter_customer_name_statement
		$filter_status_id_statement
		$filter_store_id_statement
		$filter_payment_status_statement
		ORDER BY $sort $order
		$limit_statement
		";
		
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
	
	public function getServiceformSummaryByTransactionTotal($data){
		$filter_status_id_statement = (!empty($data['filter_status_id'])) ?
		"AND sf.serviceform_action = '" . (int)$data['filter_status_id'] . "'" :
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(sf.service_date) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(sf.service_date) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";

		$filter_invoice_date_start = (!empty($data['filter_invoice_date_start'])) ? 
		"AND DATE(CASE WHEN o.invoice_date IS NULL THEN o.date_added END) >= '" . $this->db->escape($data['filter_invoice_date_start']) . "'" : 
		"";
		
		$filter_invoice_date_end = (!empty($data['filter_invoice_date_end'])) ? 
		"AND DATE(CASE WHEN o.invoice_date IS NULL THEN o.date_added END) <= '" . $this->db->escape($data['filter_invoice_date_end']) . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND sf.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND sf.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND sf.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_ic_statement = (!empty($data['filter_customer_ic'])) ? 
		"AND sf.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND sf.firstname LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND sf.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ? 
		"AND sf.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		
		$sql = "
		SELECT COUNT(*) AS total FROM(
			SELECT
			sf.service_date AS service_date,
			sf.invoice_prefix AS invoice_prefix,
			c.customer_card AS card,
			c.customer_ic AS customer_ic,
			u.user_id AS doctor_id,
			Date(CASE WHEN o.invoice_date IS NULL THEN o.date_added END) AS invoice_date,
			o.invoice_prefix AS invoice,
			CONCAT(c.firstname, ' ', c.lastname) AS name,
			sf.net_amount AS subtotal,
			sf.t_gst AS tax,
			sf.total_price AS total
			#SUM(CASE WHEN st.code = 'sub_total' THEN st.value ELSE 0 END) AS subtotal,
			#SUM(CASE WHEN st.code = 'tax' THEN st.value ELSE 0 END) AS tax,
			#SUM(CASE WHEN st.code = 'total' THEN st.value ELSE 0 END) AS total
		FROM " . DB_PREFIX . "service_form sf
		#INNER JOIN " . DB_PREFIX . "service_total st
		#ON sf.service_form_id = st.service_form_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		LEFT JOIN " . DB_PREFIX . "user u
		ON sf.user_id = u.user_id
		LEFT JOIN " . DB_PREFIX . "order o
		ON sf.order_id = o.order_id
		WHERE 1
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_invoice_date_start
		$filter_invoice_date_end
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_customer_card_statement
		$filter_customer_ic_statement
		$filter_customer_name_statement
		$filter_status_id_statement
		$filter_store_id_statement
		$filter_payment_status_statement
		)a
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	
	public function getServiceformSummaryByTransactionTotalSubtotal($data){
		$filter_status_id_statement = (!empty($data['filter_status_id'])) ?
		"AND sf.serviceform_action = '" . (int)$data['filter_status_id'] . "'" :
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(sf.service_date) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(sf.service_date) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND sf.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND sf.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND sf.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_ic_statement = (!empty($data['filter_customer_ic'])) ? 
		"AND sf.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND sf.firstname LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND sf.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ? 
		"AND sf.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$sql = "
		SELECT SUM(value) AS subtotal
		FROM " . DB_PREFIX . "service_total st
		INNER JOIN " . DB_PREFIX . "service_form sf
		ON st.service_form_id = sf.service_form_id
		INNER JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE st.code = 'sub_total'
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_customer_card_statement
		$filter_customer_ic_statement
		$filter_customer_name_statement
		$filter_status_id_statement
		$filter_store_id_statement
		$filter_payment_status_statement
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['subtotal'];
	}
	
	public function getServiceformSummaryByTransactionTotalTax($data){
		$filter_status_id_statement = (!empty($data['filter_status_id'])) ?
		"AND sf.serviceform_action = '" . (int)$data['filter_status_id'] . "'" :
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(sf.service_date) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(sf.service_date) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND sf.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND sf.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND sf.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_ic_statement = (!empty($data['filter_customer_ic'])) ? 
		"AND sf.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND sf.firstname LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND sf.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ? 
		"AND sf.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$sql = "
		SELECT SUM(value) AS tax
		FROM " . DB_PREFIX . "service_total st
		INNER JOIN " . DB_PREFIX . "service_form sf
		ON st.service_form_id = sf.service_form_id
		INNER JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE st.code = 'tax'
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_customer_card_statement
		$filter_customer_ic_statement
		$filter_customer_name_statement
		$filter_status_id_statement
		$filter_store_id_statement
		$filter_payment_status_statement
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['tax'];
	}
	
	public function getServiceformSummaryByTransactionTotalSales($data){
		$filter_status_id_statement = (!empty($data['filter_status_id'])) ?
		"AND sf.serviceform_action = '" . (int)$data['filter_status_id'] . "'" :
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(sf.service_date) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(sf.service_date) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND sf.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND sf.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND sf.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_ic_statement = (!empty($data['filter_customer_ic'])) ? 
		"AND sf.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND sf.firstname LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND sf.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ? 
		"AND sf.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$sql = "
		SELECT SUM(value) AS total
		FROM " . DB_PREFIX . "service_total st
		INNER JOIN " . DB_PREFIX . "service_form sf
		ON st.service_form_id = sf.service_form_id
		INNER JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE st.code = 'total'
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_customer_card_statement
		$filter_customer_ic_statement
		$filter_customer_name_statement
		$filter_status_id_statement
		$filter_store_id_statement
		$filter_payment_status_statement
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	
	public function getServiceformSummaryByService($data){
		$language_id = (int)$this->config->get('config_language_id');
		
		$sort 	= isset($data['sort']) ? $data['sort'] : "name";

		$order 	= isset($data['order']) ? $data['order'] : "ASC";
		
		$filter_status_id_statement = (!empty($data['filter_status_id'])) ?
		"AND sf.serviceform_action = '" . (int)$data['filter_status_id'] . "'" :
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(sf.service_date) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(sf.service_date) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND sf.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND sf.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND sf.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_ic_statement = (!empty($data['filter_customer_ic'])) ? 
		"AND sf.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND sf.firstname LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND sf.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ? 
		"AND sf.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$filter_service_name_statement = (!empty($data['filter_service_name'])) ? 
		"AND csd.name LIKE '%" . $this->db->escape($data['filter_service_name']) . "%'" : 
		"";
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT 
			cs.clinicalservice_id,
			csd.name,
			SUM(si.net_amount) AS subtotal,
			SUM(si.gst) AS tax,
			SUM(si.total) AS total
		FROM " . DB_PREFIX . "clinical_service cs
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON cs.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "service_item si
		ON cs.clinicalservice_id = si.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON si.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE 1
		AND csd.language_id = '" . (int)$language_id . "'
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_customer_card_statement
		$filter_customer_ic_statement
		$filter_customer_name_statement
		$filter_payment_status_statement
		$filter_status_id_statement
		$filter_store_id_statement
		$filter_service_name_statement
		GROUP BY cs.clinicalservice_id
		ORDER BY $sort $order
		$limit_statement
		";
		
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
	
	public function getServiceformSummaryByServiceTotal($data){
		$language_id = (int)$this->config->get('config_language_id');
		
		$sort 	= isset($data['sort']) ? $data['sort'] : "name";

		$order 	= isset($data['order']) ? $data['order'] : "ASC";
		
		$filter_status_id_statement = (!empty($data['filter_status_id'])) ?
		"AND sf.serviceform_action = '" . (int)$data['filter_status_id'] . "'" :
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(sf.service_date) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(sf.service_date) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND sf.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND sf.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND sf.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_ic_statement = (!empty($data['filter_customer_ic'])) ? 
		"AND sf.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND sf.firstname LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND sf.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ? 
		"AND sf.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$filter_service_name_statement = (!empty($data['filter_service_name'])) ? 
		"AND csd.name LIKE '%" . $this->db->escape($data['filter_service_name']) . "%'" : 
		"";
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT COUNT(*) AS total FROM(
		SELECT 
			cs.clinicalservice_id,
			csd.name,
			SUM(si.net_amount) AS subtotal,
			SUM(si.gst) AS tax,
			SUM(si.total) AS total
		FROM " . DB_PREFIX . "clinical_service cs
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON cs.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "service_item si
		ON cs.clinicalservice_id = si.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON si.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE 1
		AND csd.language_id = '" . (int)$language_id . "'
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_customer_card_statement
		$filter_customer_ic_statement
		$filter_customer_name_statement
		$filter_payment_status_statement
		$filter_status_id_statement
		$filter_store_id_statement
		$filter_service_name_statement
		GROUP BY cs.clinicalservice_id
		)a
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	
	public function getServiceformSummaryByServiceTotalSubtotal($data){
		$language_id = (int)$this->config->get('config_language_id');
		
		$filter_status_id_statement = (!empty($data['filter_status_id'])) ?
		"AND sf.serviceform_action = '" . (int)$data['filter_status_id'] . "'" :
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(sf.service_date) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(sf.service_date) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND sf.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND sf.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND sf.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_ic_statement = (!empty($data['filter_customer_ic'])) ? 
		"AND sf.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND sf.firstname LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND sf.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ? 
		"AND sf.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$filter_service_name_statement = (!empty($data['filter_service_name'])) ? 
		"AND csd.name LIKE '%" . $this->db->escape($data['filter_service_name']) . "%'" : 
		"";
		
		$sql = "
		SELECT
			SUM(si.net_amount) AS subtotal
		FROM " . DB_PREFIX . "clinical_service cs
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON cs.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "service_item si
		ON cs.clinicalservice_id = si.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON si.service_form_id = sf.service_form_id
		WHERE 1
		AND csd.language_id = '" . (int)$language_id . "'
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_customer_card_statement
		$filter_customer_ic_statement
		$filter_customer_name_statement
		$filter_payment_status_statement
		$filter_status_id_statement
		$filter_store_id_statement
		$filter_service_name_statement
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['subtotal'];
	}
	
	public function getServiceformSummaryByServiceTotalTax($data){
		$language_id = (int)$this->config->get('config_language_id');
		
		$filter_status_id_statement = (!empty($data['filter_status_id'])) ?
		"AND sf.serviceform_action = '" . (int)$data['filter_status_id'] . "'" :
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(sf.service_date) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(sf.service_date) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND sf.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND sf.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND sf.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_ic_statement = (!empty($data['filter_customer_ic'])) ? 
		"AND sf.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND sf.firstname LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND sf.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ? 
		"AND sf.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$filter_service_name_statement = (!empty($data['filter_service_name'])) ? 
		"AND csd.name LIKE '%" . $this->db->escape($data['filter_service_name']) . "%'" : 
		"";
		
		$sql = "
		SELECT
			SUM(si.gst) AS tax
		FROM " . DB_PREFIX . "clinical_service cs
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON cs.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "service_item si
		ON cs.clinicalservice_id = si.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON si.service_form_id = sf.service_form_id
		WHERE 1
		AND csd.language_id = '" . (int)$language_id . "'
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_customer_card_statement
		$filter_customer_ic_statement
		$filter_customer_name_statement
		$filter_payment_status_statement
		$filter_status_id_statement
		$filter_store_id_statement
		$filter_service_name_statement
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['tax'];
	}
	
	public function getServiceformSummaryByServiceTotalSales($data){
		$language_id = (int)$this->config->get('config_language_id');
		
		$filter_status_id_statement = (!empty($data['filter_status_id'])) ?
		"AND sf.serviceform_action = '" . (int)$data['filter_status_id'] . "'" :
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(sf.service_date) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(sf.service_date) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND sf.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND sf.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND sf.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_ic_statement = (!empty($data['filter_customer_ic'])) ? 
		"AND sf.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND sf.firstname LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND sf.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ? 
		"AND sf.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$filter_service_name_statement = (!empty($data['filter_service_name'])) ? 
		"AND csd.name LIKE '%" . $this->db->escape($data['filter_service_name']) . "%'" : 
		"";
		
		$sql = "
		SELECT
			SUM(si.total) AS total
		FROM " . DB_PREFIX . "clinical_service cs
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON cs.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "service_item si
		ON cs.clinicalservice_id = si.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON si.service_form_id = sf.service_form_id
		WHERE 1
		AND csd.language_id = '" . (int)$language_id . "'
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_customer_card_statement
		$filter_customer_ic_statement
		$filter_customer_name_statement
		$filter_payment_status_statement
		$filter_status_id_statement
		$filter_store_id_statement
		$filter_service_name_statement
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	
	public function getServiceformSummaryByServiceInfo($clinicalservice_id, $data){
		$language_id = (int)$this->config->get('config_language_id');
		
		$sort 	= isset($data['sort']) ? $data['sort'] : "name";

		$order 	= isset($data['order']) ? $data['order'] : "ASC";
		
		$filter_status_id_statement = (!empty($data['filter_status_id'])) ?
		"AND sf.serviceform_action = '" . (int)$data['filter_status_id'] . "'" :
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(sf.service_date) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(sf.service_date) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND sf.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_ic_statement = (!empty($data['filter_customer_ic'])) ? 
		"AND sf.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND sf.firstname LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND sf.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ? 
		"AND sf.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT
			sf.service_date AS service_date,
			sf.invoice_prefix AS invoice_prefix, 
			a.net_amount AS subtotal, 
			a.gst AS tax,
			a.total AS total
		FROM
		(
			SELECT *
			FROM " . DB_PREFIX . "service_item
			WHERE 1
			AND clinicalservice_id = '" . (int)$clinicalservice_id . "'
			GROUP BY service_form_id
		)a
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON a.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON a.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE 1
		AND csd.language_id = '" . (int)$language_id . "'
		$filter_customer_card_statement
		$filter_customer_ic_statement
		$filter_customer_name_statement
		$filter_date_end_statement
		$filter_date_start_statement
		$filter_payment_status_statement
		$filter_status_id_statement
		$filter_store_id_statement
		$limit_statement
		";
		
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
	
	public function getServiceformSummaryByServiceInfoTotal($clinicalservice_id, $data){
		$language_id = (int)$this->config->get('config_language_id');
		
		$sort 	= isset($data['sort']) ? $data['sort'] : "name";

		$order 	= isset($data['order']) ? $data['order'] : "ASC";
		
		$filter_status_id_statement = (!empty($data['filter_status_id'])) ?
		"AND sf.serviceform_action = '" . (int)$data['filter_status_id'] . "'" :
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(sf.service_date) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(sf.service_date) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND sf.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND sf.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND sf.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_ic_statement = (!empty($data['filter_customer_ic'])) ? 
		"AND sf.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND sf.firstname LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND sf.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ? 
		"AND sf.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$filter_service_name_statement = (!empty($data['filter_service_name'])) ? 
		"AND csd.name = '" . $this->db->escape($data['filter_service_name']) . "'" : 
		"";
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT COUNT(*) AS total FROM (
		SELECT
			sf.service_date AS service_date,
			sf.invoice_prefix AS invoice_prefix, 
			a.net_amount AS subtotal, 
			a.gst AS tax,
			a.total AS total
		FROM
		(
			SELECT *
			FROM " . DB_PREFIX . "service_item
			WHERE 1
			AND clinicalservice_id = '" . (int)$clinicalservice_id . "'
			GROUP BY service_form_id
		)a
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON a.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON a.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE 1
		AND csd.language_id = '" . (int)$language_id . "'
		$filter_customer_card_statement
		$filter_customer_ic_statement
		$filter_customer_name_statement
		$filter_date_end_statement
		$filter_date_start_statement
		$filter_payment_status_statement
		$filter_status_id_statement
		$filter_store_id_statement
		)a
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	
	public function getServiceformSummaryByServiceInfoTotalSubtotal($clinicalservice_id, $data){
		$language_id = (int)$this->config->get('config_language_id');
		
		$sort 	= isset($data['sort']) ? $data['sort'] : "name";

		$order 	= isset($data['order']) ? $data['order'] : "ASC";
		
		$filter_status_id_statement = (!empty($data['filter_status_id'])) ?
		"AND sf.serviceform_action = '" . (int)$data['filter_status_id'] . "'" :
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(sf.service_date) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(sf.service_date) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND sf.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND sf.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND sf.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_ic_statement = (!empty($data['filter_customer_ic'])) ? 
		"AND sf.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND sf.firstname LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND sf.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ? 
		"AND sf.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$filter_service_name_statement = (!empty($data['filter_service_name'])) ? 
		"AND csd.name = '" . $this->db->escape($data['filter_service_name']) . "'" : 
		"";
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT
			SUM(a.net_amount) as subtotal
		FROM
		(
			SELECT *
			FROM " . DB_PREFIX . "service_item
			WHERE 1
			AND clinicalservice_id = '" . (int)$clinicalservice_id . "'
			GROUP BY service_form_id
		)a
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON a.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON a.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE 1
		AND csd.language_id = '" . (int)$language_id . "'
		$filter_customer_card_statement
		$filter_customer_ic_statement
		$filter_customer_name_statement
		$filter_date_end_statement
		$filter_date_start_statement
		$filter_payment_status_statement
		$filter_status_id_statement
		$filter_store_id_statement
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['subtotal'];
	}
	
	public function getServiceformSummaryByServiceInfoTotalTax($clinicalservice_id, $data){
		$language_id = (int)$this->config->get('config_language_id');
		
		$sort 	= isset($data['sort']) ? $data['sort'] : "name";

		$order 	= isset($data['order']) ? $data['order'] : "ASC";
		
		$filter_status_id_statement = (!empty($data['filter_status_id'])) ?
		"AND sf.serviceform_action = '" . (int)$data['filter_status_id'] . "'" :
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(sf.service_date) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(sf.service_date) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND sf.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND sf.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND sf.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_ic_statement = (!empty($data['filter_customer_ic'])) ? 
		"AND sf.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND sf.firstname LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND sf.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ? 
		"AND sf.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$filter_service_name_statement = (!empty($data['filter_service_name'])) ? 
		"AND csd.name = '" . $this->db->escape($data['filter_service_name']) . "'" : 
		"";
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT
			SUM(a.gst) as tax
		FROM
		(
			SELECT *
			FROM " . DB_PREFIX . "service_item
			WHERE 1
			AND clinicalservice_id = '" . (int)$clinicalservice_id . "'
			GROUP BY service_form_id
		)a
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON a.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON a.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE 1
		AND csd.language_id = '" . (int)$language_id . "'
		$filter_customer_card_statement
		$filter_customer_ic_statement
		$filter_customer_name_statement
		$filter_date_end_statement
		$filter_date_start_statement
		$filter_payment_status_statement
		$filter_status_id_statement
		$filter_store_id_statement
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['tax'];
	}
	
	public function getServiceformSummaryByServiceInfoTotalSales($clinicalservice_id, $data){
		$language_id = (int)$this->config->get('config_language_id');
		
		$sort 	= isset($data['sort']) ? $data['sort'] : "name";

		$order 	= isset($data['order']) ? $data['order'] : "ASC";
		
		$filter_status_id_statement = (!empty($data['filter_status_id'])) ?
		"AND sf.serviceform_action = '" . (int)$data['filter_status_id'] . "'" :
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(sf.service_date) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(sf.service_date) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND sf.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND sf.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND sf.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_ic_statement = (!empty($data['filter_customer_ic'])) ? 
		"AND sf.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND sf.firstname LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND sf.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ? 
		"AND sf.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$filter_service_name_statement = (!empty($data['filter_service_name'])) ? 
		"AND csd.name = '" . $this->db->escape($data['filter_service_name']) . "'" : 
		"";
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT
			SUM(a.total) as total
		FROM
		(
			SELECT *
			FROM " . DB_PREFIX . "service_item
			WHERE 1
			AND clinicalservice_id = '" . (int)$clinicalservice_id . "'
			GROUP BY service_form_id
		)a
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON a.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON a.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE 1
		AND csd.language_id = '" . (int)$language_id . "'
		$filter_customer_card_statement
		$filter_customer_ic_statement
		$filter_customer_name_statement
		$filter_date_end_statement
		$filter_date_start_statement
		$filter_payment_status_statement
		$filter_status_id_statement
		$filter_store_id_statement
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	
}
?>