<?php
class ModelReportServiceSummaryByCustomer extends Model {
    public function getPaymentMethod(){
		$payment_methods = array();
		
		$sql = "SELECT DISTINCT payment_method FROM " . DB_PREFIX . "order";
		$query = $this->db->query($sql);
		
		foreach($query->rows as $payment_method) {
			$p_m = trim($payment_method['payment_method']);
			
			if(!empty($p_m)) $payment_methods[] = $payment_method['payment_method'];
		}
		
		return $payment_methods;
	}
    

    public function getcustomerservicelist($data){

        $filter_statements = $this->getFiltersData($data);

		
		$limit_statement = "";
		if (!empty($data)) {
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}

				$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}
		}

		$sql="SELECT c.customer_id as customer_id,
		CONCAT(c.firstname,' ',c.lastname) as name ,
        c.telephone as telephone ,
		DATE_FORMAT(FROM_DAYS(DATEDIFF(NOW(),c.dob)), '%Y') + 0 as age ,
        c.gender as gender ,
        cgd.name as customer_group,
        c.date_added as date_added ,
        c.store_id as store_id,
		COUNT(DISTINCT(sf.service_form_id)) as service_form,
		COUNT(DISTINCT(si.service_item_id)) as service_item 
        FROM oc_service_form sf
		LEFT JOIN oc_service_item si
		ON sf.service_form_id = si.service_form_id
		LEFT JOIN oc_customer c
		ON sf.customer_id = c.customer_id
        LEFT JOIN oc_customer_group_description cgd 
        ON c.customer_group_id = cgd.customer_group_id AND cgd.language_id = '".$this->config->get('config_language_id')."'
        WHERE 1 
     	$filter_statements
        ";

			
        $sql .= " AND sf.serviceform_action = '5'";
        $sql .= " AND sf.order_action = '5'";
        $sql .= " GROUP BY c.customer_id";
        $sql .= " ORDER BY service_date DESC ";
        $sql .= $limit_statement;
		// echo"<pre>";
		// print_r($sql);
		// echo"</pre>";
		
        
        $query = $this->db->query($sql);
		return $query->rows;
    }

    public function getcustomerservicelistnumber($data) {

        $filter_statements = $this->getFiltersData($data);

		
		$limit_statement = "";
		if (!empty($data)) {
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}

				$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}
		}
        $sql= "SELECT COUNT(DISTINCT(c.customer_id)) as total
		
        FROM oc_service_form sf
		LEFT JOIN oc_service_item si
		ON sf.service_form_id = si.service_form_id
		LEFT JOIN oc_customer c
		ON sf.customer_id = c.customer_id
        LEFT JOIN oc_customer_group_description cgd 
        ON c.customer_group_id = cgd.customer_group_id AND cgd.language_id = '".$this->config->get('config_language_id')."'
        WHERE 1 
       	$filter_statements
		AND sf.serviceform_action = '5'
		AND sf.order_action = '5'

		";
		// echo"<pre>";
		// print_r($sql);
		// echo"</pre>";
        $query = $this->db->query($sql);
		return $query->row['total'];
    }

    public function getCustomerGroup(){
        $sql="SELECT customer_group_id as id, name FROM oc_customer_group_description WHERE language_id = '".$this->config->get('config_language_id')."' ";

        $query = $this->db->query($sql);
		return $query->rows;
    }

	public function getservicename(){
		$sql = "SELECT DISTINCT si.clinicalservice_id AS item_id, si.name AS item_name FROM  oc_clinical_service_description si WHERE 1 AND si.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY si.name ASC ";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	protected function getFiltersData($data) {

        // Filters
		$filter_statements = "";

        $filter_date_statement = '';
        if (!empty($data['filter_date_start']) && !empty($data['filter_date_end'])) {
            $filter_date_statement = " AND sf.`service_date`  BETWEEN '" . $this->db->escape($data['filter_date_start']) . "' AND  '" . $this->db->escape($data['filter_date_end']) . "'";
        } else if (!empty($data['filter_date_start']) && empty($data['filter_date_end'])) {
            $filter_date_statement = " AND sf.`service_date`  >= '" . $this->db->escape($data['filter_date_start']) . "'";
        } else if (empty($data['filter_date_start']) && !empty($data['filter_date_end'])) {
            $filter_date_statement = " AND sf.`service_date`  <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

		
		$filter_customer_name_statement = (!empty($data['filter_name'])) ? 
		"AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'" : 
		"";

		$filter_customer_group = (!empty($data['filter_customer_group']))?
		" AND cgd.customer_group_id in (" .$data['filter_customer_group'] . ")" : 
		"";

		// if($data['filter_service_name'])
		// $filter_service_name = (!empty($data['filter_service_name'])) ?
		// 	"AND si.clinicalservice_id IN (" . (int)$data['filter_service_name'] . ")" :
		// 	"";
		// 	// var_dump(explode(',',$data['filter_service_name']));

		// $filter_service_name_deleted = ($data['filter_service_name'] == '*') ?
		// 	"AND si.servicename = ''" :
		// 	"";
		if($data['filter_service_name']=='*'){
			$filter_service_name = "AND (si.servicename = '' OR clinicalservice_id = '')";

		}else{
			if(in_array('*',explode(',',$data['filter_service_name']),true)){
				$service = substr($data['filter_service_name'],0,-2);
				$filter_service_name = "AND (si.clinicalservice_id IN (" . $this->db->escape($service) . ") OR (si.servicename = '' OR clinicalservice_id = ''))";
			}else{
				$filter_service_name = (!empty($data['filter_service_name'])) ?
				"AND si.clinicalservice_id IN (" . $this->db->escape($data['filter_service_name']) . ")" :
				"";
			}
		}
		


		$filter_telephone = (!empty($data['filter_telephone']))?
		"AND c.telephone LIKE '%" . $this->db->escape($data['filter_telephone']) . "%'" :
		"";

        $filter_gender = (!empty($data['filter_gender']))?
		" AND c.gender in (" .$data['filter_gender'] . ")" : 
		"";

    

        $filter_store_id_statement = !empty($data['filter_store_id']) ? " AND sf.`store_id` IN (" . $this->db->escape($data['filter_store_id']) . ") " : "";

		// $filter_statements .= $filter_service_name_deleted;
		$filter_statements .= $filter_service_name;
		$filter_statements .= $filter_customer_group;
		$filter_statements .= $filter_customer_name_statement;
		$filter_statements .= $filter_telephone;
		$filter_statements .= $filter_gender;

        $filter_statements .= $filter_date_statement;

		$filter_statements .= $filter_store_id_statement;

        return $filter_statements;
    }

	public function status($status_id){
		$sql="SELECT GROUP_CONCAT(os.name SEPARATOR ', ') as status_name FROM " . DB_PREFIX . "order_status os WHERE os.order_status_id IN (".$this->db->escape($status_id).") AND language_id = '" . (int)$this->config->get('config_language_id') . "'";
	
		$query = $this->db->query($sql);

		return $query->row['status_name'];
	}


}
?>