<?php
class ModelReportSaleTransaction extends Model {
	public function getTotalTransaction($data) {
		$filter_statements = $this->getSalesTransactionFilters($data);

		$sql = "
		
		SELECT
			COUNT(DISTINCT o.`order_id`) AS total_orders,
			COUNT(DISTINCT o.`customer_id`) AS total_customers,
			SUM(CASE WHEN o.`customer_id` = 0 THEN 1 ELSE 0 END) AS walkin_customers,
			COUNT(DISTINCT(CASE WHEN o.`customer_id` != 0 THEN o.`customer_id` ELSE NULL END)) AS members,
			(SELECT COUNT(DISTINCT op.`product_id`) FROM `" . DB_PREFIX . "order_product` op WHERE op.`order_id` = o.`order_id`) AS total_products,
			SUM((SELECT SUM(cst.`value`) FROM `" . DB_PREFIX . "clinical_sale_total` cst LEFT JOIN `" . DB_PREFIX . "clinical_sale` cs ON (cst.`clinical_sale_id` = cs.`clinical_sale_id`) WHERE cst.`id` = 1 AND cst.`code` = 'sub_total' AND cst.`clinical_sale_id` = cs.`clinical_sale_id` AND cs.`collect_consultation_price` = 1 AND cs.`order_id` = o.`order_id`)) AS medicine_total1,
			SUM((SELECT SUM(cst.`value`)  FROM `" . DB_PREFIX . "clinical_sale_total` cst LEFT JOIN `" . DB_PREFIX . "clinical_sale` cs ON (cst.`clinical_sale_id` = cs.`clinical_sale_id`) WHERE cst.`id` = 2 AND cst.`code` = 'sub_total' AND cst.`clinical_sale_id` = cs.`clinical_sale_id` AND cs.`collect_consultation_price` = 0 AND cs.`order_id` = o.`order_id`)) AS medicine_total2,
			SUM((SELECT SUM(CASE WHEN cs.`collect_consultation_price` = 1 THEN cs.`clinicalsale_concultation` ELSE 0 END) FROM `" . DB_PREFIX . "clinical_sale` cs WHERE 1 AND cs.`order_id` = o.`order_id`)) AS consultation_total,
			SUM((SELECT SUM(cst.`value`) FROM `" . DB_PREFIX . "clinical_sale_total` cst LEFT JOIN `" . DB_PREFIX . "clinical_sale` cs ON (cst.`clinical_sale_id` = cs.`clinical_sale_id`) WHERE cst.`id` = 2 AND cst.`code` = 'sub_total' AND cst.`clinical_sale_id` = cs.`clinical_sale_id` AND cs.`order_id` = o.`order_id`)) AS medical_total,
			SUM((SELECT SUM(sf.`total_price`) FROM oc_service_form sf WHERE 1 AND sf.order_id = o.order_id)) AS service_total,
			SUM((SELECT SUM(op.`total`) FROM `" . DB_PREFIX . "order_product` op WHERE 1 AND op.`order_id` = o.`order_id`)) AS pos_total,
			SUM((SELECT SUM(ot.`value`) FROM `" . DB_PREFIX . "order_total` ot WHERE 1 AND ot.`order_id` = o.`order_id` AND ot.`code` = 'service_charge')) AS service_charge,
			SUM((SELECT SUM(ot.`value`) FROM `" . DB_PREFIX . "order_total` ot WHERE 1 AND ot.`order_id` = o.`order_id` AND ot.`code` = 'sub_total')) AS subtotal,
			SUM((SELECT SUM(ot.`value`) FROM `" . DB_PREFIX . "order_total` ot WHERE 1 AND ot.`order_id` = o.`order_id` AND ot.`code` = 'shipping')) AS shipping,
			SUM((SELECT SUM(ot.`value`) FROM `" . DB_PREFIX . "order_total` ot WHERE 1 AND ot.`order_id` = o.`order_id` AND ot.`code` = 'tax')) AS tax,
			SUM((SELECT SUM(ot.`value`) FROM `" . DB_PREFIX . "order_total` ot WHERE 1 AND ot.`order_id` = o.`order_id` AND ot.`code` = 'rounding')) AS rounding,
			SUM((SELECT SUM(ot.`value`) FROM `" . DB_PREFIX . "order_total` ot WHERE 1 AND ot.`order_id` = o.`order_id` AND ot.`code` = 'total')) AS total,
			SUM((SELECT SUM(ot.`value`) FROM `" . DB_PREFIX . "order_total` ot WHERE 1 AND ot.`order_id` = o.`order_id` AND ot.`code` = 'total' AND o.`customer_id` <>'')) AS total_member_amount,
			SUM((SELECT SUM(ot.`value`) FROM `" . DB_PREFIX . "order_total` ot WHERE 1 AND ot.`order_id` = o.`order_id` AND ot.`code` = 'total' AND o.`customer_id` = 0)) AS total_walkin_amount
		FROM `" . DB_PREFIX . "order` o
		WHERE 1
			$filter_statements
		";

		$query = $this->db->query($sql);
		return $query->row;
	}

	protected function getSalesTransactionFilters($data) {
		// Filters
		$filter_statements = "";
		// Payment Method
		$filter_payment_method = !empty($data['filter_payment_method']) ? explode(',', $data['filter_payment_method']) : [];
		$filter_payment_method_statement = "";
		foreach ($filter_payment_method as $filter_payment_methods) {
			$filter_payment_method_statement .= empty($filter_payment_method_statement) ? " o.`payment_method` LIKE '%" . $this->db->escape($filter_payment_methods) . "%'" : " OR o.`payment_method` LIKE '%" . $this->db->escape($filter_payment_methods) . "%'";
		}
		$filter_payment_method_statement = !empty($filter_payment_method_statement) ? " AND ($filter_payment_method_statement)" : "";

		// Comment
		$filter_comment = !empty($data['filter_comment']) ? explode(',', $data['filter_comment']) : [];
		$filter_comment_statement = "";
		foreach ($filter_comment as $filter_comments) {
			$filter_comment_statement .= empty($filter_comment_statement) ? " o.`comment` LIKE '%" . $this->db->escape($filter_comments) . "%'" : " OR o.`comment` LIKE '%" . $this->db->escape($filter_comments) . "%'";
		}
		$filter_comment_statement = !empty($filter_comment_statement) ? "AND ($filter_comment_statement)" : "";

		// Order Status
		$filter_order_status_id_statement = !empty($data['filter_order_status_id']) ?
			" AND o.`order_status_id` IN (" . $this->db->escape($data['filter_order_status_id']) . ")" :
			"";

		// Invoice Date Range
		$filter_date_statement = '';
		if (!empty($data['filter_date_start']) && !empty($data['filter_date_end'])) {
			$filter_date_statement = " AND DATE(IFNULL(o.`invoice_date`,o.`date_added`)) BETWEEN '" . $this->db->escape($data['filter_date_start']) . "' AND '"  . $this->db->escape($data['filter_date_end']) . "'" ;
		} else if (!empty($data['filter_date_start']) && empty($data['filter_date_end'])) {
			$filter_date_statement = " AND DATE(IFNULL(o.`invoice_date`,o.`date_added`)) >= '" . $this->db->escape($data['filter_date_start']) . "'" ;
			"";
		} else if (empty($data['filter_date_start']) && !empty($data['filter_date_end'])) {
			$filter_date_statement = " AND DATE(IFNULL(o.`invoice_date`,o.`date_added`)) <= '" . $this->db->escape($data['filter_date_end']) . "'" ;
			"";
		}

		// Customer Type
		$filter_customer_types = !empty($data['filter_customer_type']) ? explode(',', $data['filter_customer_type']) : [];
		$filter_customer_type_statement = "";
		foreach ($filter_customer_types as $customer_type) {
			if (!empty($filter_customer_type_statement)) {
				$filter_customer_type_statement .= " OR ";
			} 

			if ($customer_type == 1) {
				$filter_customer_type_statement .= " o.`customer_id` = 0 ";
			}

			if ($customer_type == 2) {
				$filter_customer_type_statement .= " o.`customer_id` != 0 ";
			}
		}
		$filter_customer_type_statement = !empty($filter_customer_type_statement) ? " AND ($filter_customer_type_statement)" : "";
		
		// Invoice Number Start
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
			" AND o.`invoice_prefix` >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
			"";

		// Invoice Number End
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
			" AND o.`invoice_prefix` <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
			"";

		// Customer Group
		$filter_customer_group_statement = !empty($data['filter_customer_group_id']) ?
			" AND o.`customer_group_id` IN (" . $this->db->escape($data['filter_customer_group_id']) . ")" :
			"";

		// Store ID
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
			" AND o.`store_id` = " . (int)$data['filter_store_id'] :
			"";

		// Customer Name
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
			" AND CONCAT(o.`firstname`,' ',o.`lastname`) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
			"";

		// Invoice Checked 
		$filter_invoice_prefix_statement = "  AND o.`invoice_prefix` <>'' AND o.`invoice_prefix` <> '0' ";

		$filter_statements .= $filter_order_status_id_statement;
		$filter_statements .= $filter_date_statement;
		$filter_statements .= $filter_transaction_start_statement;
		$filter_statements .= $filter_transaction_end_statement;
		$filter_statements .= $filter_store_id_statement;
		$filter_statements .= $filter_customer_type_statement;
		$filter_statements .= $filter_payment_method_statement;
		$filter_statements .= $filter_invoice_prefix_statement;
		$filter_statements .= $filter_comment_statement;
		$filter_statements .= $filter_customer_name_statement;
		$filter_statements .= $filter_customer_group_statement;

		return $filter_statements;
	}

	public function getTransaction($data = []) {
		$language_id = $this->config->get('config_language_id');

		$filter_statements = $this->getSalesTransactionFilters($data);

		$limit_statement = "";
		if (!empty($data)) {
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}

				$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}
		}

		$sql = "
		SELECT
			o.`order_id`,
			o.`invoice_prefix`,
			IFNULL(o.`invoice_date`,o.`date_added`) AS invoice_date,
			o.`customer_id`,
			(CASE WHEN o.`customer_id` = 0 THEN 1 ELSE 2 END) AS customer_type,
			CONCAT(o.`firstname`, ' ', o.`lastname`) AS customer_name,
			o.`customer_group_id`,
			(SELECT cgd.`name` FROM `" . DB_PREFIX . "customer_group_description` cgd WHERE cgd.`customer_group_id` = o.`customer_group_id` AND cgd.`language_id` = '" . (int)$language_id . "') AS customer_group,
			(SELECT c.`customer_card` FROM `" . DB_PREFIX . "customer` c WHERE c.`customer_id` = o.`customer_id`) AS customer_card,
			o.`email`,
			o.`telephone`,
			o.`order_status_id`,
			(SELECT os.`name` FROM `" . DB_PREFIX . "order_status` os WHERE os.`order_status_id` = o.`order_status_id` AND os.language_id = '" . (int)$language_id  . "') AS order_status_name,
			(SELECT SUM(cst.`value`) FROM `" . DB_PREFIX . "clinical_sale_total` cst LEFT JOIN `" . DB_PREFIX . "clinical_sale` cs ON (cst.`clinical_sale_id` = cs.`clinical_sale_id`) WHERE cst.`id` = 1 AND cst.`code` = 'sub_total' AND cst.`clinical_sale_id` = cs.`clinical_sale_id` AND cs.`collect_consultation_price` = 1 AND cs.`order_id` = o.`order_id`) AS medicine_total1,
			(SELECT SUM(cst.`value`)  FROM `" . DB_PREFIX . "clinical_sale_total` cst LEFT JOIN `" . DB_PREFIX . "clinical_sale` cs ON (cst.`clinical_sale_id` = cs.`clinical_sale_id`) WHERE cst.`id` = 2 AND cst.`code` = 'sub_total' AND cst.`clinical_sale_id` = cs.`clinical_sale_id` AND cs.`collect_consultation_price` = 0 AND cs.`order_id` = o.`order_id`) AS medicine_total2,
			(SELECT SUM(CASE WHEN cs.`collect_consultation_price` = 1 THEN cs.`clinicalsale_concultation` ELSE 0 END) FROM `" . DB_PREFIX . "clinical_sale` cs WHERE 1 AND cs.`order_id` = o.`order_id`) AS consultation_total,
			(SELECT SUM(cst.value) FROM `" . DB_PREFIX . "clinical_sale_total` cst LEFT JOIN `" . DB_PREFIX . "clinical_sale` cs ON (cst.clinical_sale_id = cs.clinical_sale_id) WHERE cst.id = 2 AND cst.code = 'sub_total' AND cst.clinical_sale_id = cs.clinical_sale_id AND cs.order_id = o.order_id) AS medical_record_total,
			(SELECT GROUP_CONCAT(cs.invoice_prefix) FROM `" . DB_PREFIX . "clinical_sale` cs WHERE 1 AND cs.`order_id` = o.`order_id`) AS herbals_prefix,
			(SELECT SUM(sf.`total_price`) FROM `" . DB_PREFIX . "service_form` sf WHERE 1 AND sf.`order_id` = o.`order_id`) AS service_total,
			(SELECT GROUP_CONCAT(sf.invoice_prefix) FROM `" . DB_PREFIX . "service_form` sf WHERE 1 AND sf.`order_id` = o.`order_id`) AS services_prefix,
			(SELECT SUM(op.`total`) FROM `" . DB_PREFIX . "order_product` op WHERE 1 AND op.`order_id` = o.`order_id`) AS pos_selling,
			(SELECT GROUP_CONCAT(op.name) FROM `" . DB_PREFIX . "order_product` op WHERE 1 AND op.`order_id` = o.`order_id`) AS products_prefix,
			(SELECT SUM(ot.`value`) FROM `" . DB_PREFIX . "order_total` ot WHERE 1 AND ot.`order_id` = o.`order_id` AND ot.code = 'service_charge') AS service_charge,
			(SELECT SUM(ot.`value`) FROM `" . DB_PREFIX . "order_total` ot WHERE 1 AND ot.`order_id` = o.`order_id` AND ot.code = 'sub_total') AS subtotal,
			(SELECT SUM(ot.`value`) FROM `" . DB_PREFIX . "order_total` ot WHERE 1 AND ot.`order_id` = o.`order_id` AND ot.code = 'shipping') AS shipping,
			(SELECT SUM(ot.`value`) FROM `" . DB_PREFIX . "order_total` ot WHERE 1 AND ot.`order_id` = o.`order_id` AND ot.code = 'tax') AS tax,
			(SELECT SUM(ot.`value`) FROM `" . DB_PREFIX . "order_total` ot WHERE 1 AND ot.`order_id` = o.`order_id` AND ot.code = 'rounding') AS rounding,
			(SELECT SUM(ot.value) FROM `" . DB_PREFIX . "order_total` ot WHERE 1 AND ot.order_id = o.order_id AND ot.code = 'total') AS total,
			o.`comment`,
			o.`payment_method`
		FROM `" . DB_PREFIX . "order` o 
		WHERE 1	
			$filter_statements
		GROUP BY o.`order_id`
		ORDER BY invoice_date ASC, o.`invoice_prefix` ASC
		$limit_statement
		";
		
		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getSalesTotalServiceForm($order_id) {
		$filter_invoice_prefix_statement = "  AND o.invoice_prefix <>'' AND o.invoice_prefix <> '0'";

		$sql = "
		SELECT ROUND(SUM(st.value), 2) as total
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON o.order_id = sf.order_id
		LEFT JOIN " . DB_PREFIX . "service_total st
		ON sf.service_form_id = st.service_form_id
		WHERE o.order_id = '" . (int)$order_id . "'
		AND st.code = 'sub_total'
		$filter_invoice_prefix_statement
		GROUP BY o.order_id";

		$query = $this->db->query($sql);
		return $query->row;
	}

	public function getPaymentMethod() {
		$payment_methods = array();

		$sql = "SELECT DISTINCT payment_method FROM " . DB_PREFIX . "order";
		$query = $this->db->query($sql);

		foreach ($query->rows as $payment_method) {
			$p_m = trim($payment_method['payment_method']);

			if (!empty($p_m)) $payment_methods[] = $payment_method['payment_method'];
		}

		return $payment_methods;
	}

	public function checkduplicate(){
		$sql="SELECT COUNT(o.invoice_prefix) AS duplicates FROM `oc_order` o WHERE o.invoice_prefix IN (SELECT invoice_prefix 
		FROM `oc_order` WHERE invoice_prefix <> '' GROUP BY invoice_prefix HAVING COUNT(*) > 1) ORDER BY o.invoice_prefix, o.order_id

		";

		$query = $this->db->query($sql);
		return $query->row['duplicates'];

	}

	public function duplicatelist($data){

		$limit_statement = "";


		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
	
		$sql="SELECT o.order_id, o.invoice_prefix, CONCAT(o.firstname,o.lastname) AS customer, o.total, o.payment_method, DATE(o.date_added) AS date_added, DATE(IFNULL(o.invoice_date,o.date_added)) AS invoice_date, o.comment 
		FROM `oc_order` o WHERE o.invoice_prefix IN (SELECT invoice_prefix FROM `oc_order` WHERE invoice_prefix <> '' GROUP BY invoice_prefix HAVING COUNT(*) > 1) ORDER BY o.invoice_prefix, o.order_id
		$limit_statement
		
		";

		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function duplicatelist_total(){

		$sql="SELECT COUNT(*) as total FROM
		(SELECT o.order_id, o.invoice_prefix, CONCAT(o.firstname,o.lastname) AS customer, o.total, o.payment_method, DATE(o.date_added) AS date_added, DATE(IFNULL(o.invoice_date,o.date_added)) AS invoice_date, o.comment 
		FROM `oc_order` o WHERE o.invoice_prefix IN (SELECT invoice_prefix FROM `oc_order` WHERE invoice_prefix <> '' GROUP BY invoice_prefix HAVING COUNT(*) > 1) ORDER BY o.invoice_prefix, o.order_id
		)a WHERE 1 ";

		$query = $this->db->query($sql);
		return $query->row['total'];
	}

	public function getInvoiceNotSequence($data){

		$limit_statement = "";


		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$sql="SELECT o.order_id AS id, DATE(IFNULL(o.invoice_date,o.date_added)) AS date, o.invoice_prefix AS number 
		FROM `oc_order` o WHERE 1 AND o.invoice_prefix <>'' AND DATE(IFNULL(o.invoice_date,o.date_added)) BETWEEN '".$this->db->escape($data['year_start'])."' AND '".$this->db->escape($data['year_end'])."' ORDER BY date, number
		";



		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getInvoiceNotSequenceTotal($data){
		
		$sql="SELECT COUNT(*) as total FROM (
		SELECT o.order_id AS id, DATE(IFNULL(o.invoice_date,o.date_added)) AS date, o.invoice_prefix AS number 
		FROM `oc_order` o WHERE 1 AND o.invoice_prefix <>'' AND DATE(IFNULL(o.invoice_date,o.date_added)) BETWEEN '".$this->db->escape($data['year_start'])."' AND '".$this->db->escape($data['year_end'])."' ORDER BY date, number
		)a WHERE 1
		";

		$query = $this->db->query($sql);
		return $query->row['total'];
	}

}
