<?php
class ModelReportSale extends Model {
	public function getPaymentMethod(){
		$payment_methods = array();

		$sql = "SELECT DISTINCT payment_method FROM " . DB_PREFIX . "order";
		$query = $this->db->query($sql);

		foreach($query->rows as $payment_method) {
			$p_m = trim($payment_method['payment_method']);

			if(!empty($p_m)) $payment_methods[] = $payment_method['payment_method'];
		}

		return $payment_methods;
	}

	//transction
	public function getTransaction($data = array()){

		$language_id = $this->config->get('config_language_id');

		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"AND o.order_status_id > '0'";

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" :
		"";

		$filter_customer_type_statement = "";

		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND o.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND o.customer_id != 0";
			}
		}

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
		"AND customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
		"AND customer_name LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$limit_statement = "";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$sql = "
		SELECT
			o.order_id,
			o.invoice_prefix,
			o.date_added,
			o.customer_id,
			CASE WHEN o.customer_id = 0 THEN 1
			ELSE 2 END AS customer_type,
			CONCAT(o.firstname, ' ', o.lastname) AS customer_name,
			c.customer_card,
			o.payment_method,
			o.order_status_id,
			os.name AS status,
			CASE WHEN o.payment_method != 'points' THEN cr.points
			ELSE 0 END AS points,
			CASE WHEN o.payment_method = 'points' THEN cr.points
			ELSE 0 END AS expoints,
			subtotal.value AS subtotal,
			shipping.value AS shipping,
			SUM(ROUND(tax.value, 2)) AS tax,
			rounding.value AS rounding,
			total.value AS total
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "customer c
		ON o.customer_id = c.customer_id
		LEFT JOIN " . DB_PREFIX . "order_status os
		ON o.order_status_id = os.order_status_id
		AND os.language_id = '" . (int)$language_id . "'
		LEFT JOIN " . DB_PREFIX . "customer_reward cr
		ON o.order_id = cr.order_id
		LEFT JOIN " . DB_PREFIX . "order_total subtotal
		ON o.order_id = subtotal.order_id
		AND subtotal.code = 'sub_total'
		LEFT JOIN " . DB_PREFIX . "order_total shipping
		ON o.order_id = shipping.order_id
		AND shipping.code = 'shipping'
		LEFT JOIN " . DB_PREFIX . "order_total  tax
		ON o.order_id = tax.order_id
		AND tax.code = 'tax'
		LEFT JOIN " . DB_PREFIX . "order_total rounding
		ON o.order_id = rounding.order_id
		AND rounding.code = 'rounding'
		LEFT JOIN " . DB_PREFIX . "order_total total
		ON o.order_id = total.order_id
		AND total.code = 'total'
		WHERE 1
		$filter_order_status_id_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_store_id_statement
		$filter_customer_type_statement
		$filter_payment_method_statement
		GROUP BY o.order_id
		HAVING 1
		$filter_customer_name_statement
		$filter_customer_card_statement
		$limit_statement
		";

		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getTotalTransaction($data) {
		$language_id = $this->config->get('config_language_id');

		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"AND o.order_status_id > '0'";

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" :
		"";

		$filter_customer_type_statement = "";

		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND o.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND o.customer_id != 0";
			}
		}

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
		"AND customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
		"AND customer_name LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$sql = "
		SELECT COUNT(*) AS total FROM(
		SELECT
			o.order_id,
			o.invoice_prefix,
			o.date_added,
			o.customer_id,
			CASE WHEN o.customer_id = 0 THEN 1
			ELSE 2 END AS customer_type,
			CONCAT(o.firstname, ' ', o.lastname) AS customer_name,
			CASE WHEN c.customer_card != NULL THEN c.customer_card
			ELSE CONCAT(o.firstname, ' ', o.lastname) END AS customer_card,
			o.payment_method,
			o.order_status_id,
			os.name AS status
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "customer c
		ON o.customer_id = c.customer_id
		LEFT JOIN " . DB_PREFIX . "order_status os
		ON o.order_status_id = os.order_status_id
		AND os.language_id = '" . (int)$language_id . "'
		WHERE 1
		$filter_order_status_id_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_store_id_statement
		$filter_customer_type_statement
		$filter_payment_method_statement
		GROUP BY o.order_id
		HAVING 1
		$filter_customer_name_statement
		$filter_customer_card_statement
		)a
		";

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function getTransactionTotalCash($data){
		$language_id = $this->config->get('config_language_id');

		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"AND o.order_status_id > '0'";

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" :
		"";

		$filter_customer_type_statement = "";

		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND o.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND o.customer_id != 0";
			}
		}

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
		"AND c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
		"AND CONCAT(o.firstname, ' ' , o.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$sql = "
		SELECT
			SUM(ROUND(ot.value, 2)) AS total_cash
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "order_total ot
		ON o.order_id = ot.order_id AND ot.code = 'total'
		LEFT JOIN " . DB_PREFIX . "customer c
		ON o.customer_id = c.customer_id
		WHERE 1
		AND o.payment_method != 'points'
		$filter_customer_card_statement
		$filter_customer_name_statement
		$filter_customer_type_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_order_status_id_statement
		$filter_payment_method_statement
		$filter_store_id_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_cash'];
	}

	public function getTransactionTotalRewardPoint($data){

		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"AND o.order_status_id > '0'";

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" :
		"";

		$filter_customer_type_statement = "";

		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND o.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND o.customer_id != 0";
			}
		}

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
		"AND c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
		"AND CONCAT(o.firstname, ' ', o.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$sql = "
		SELECT
			SUM(cr.points) AS total_points
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "customer_reward cr
		ON o.order_id = cr.order_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON o.customer_id = c.customer_id
		WHERE 1
		AND o.payment_method = 'points'
		$filter_customer_card_statement
		$filter_customer_name_statement
		$filter_customer_type_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_order_status_id_statement
		$filter_payment_method_statement
		$filter_store_id_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		";

		$query = $this->db->query($sql);

		return $query->row['total_points'];
	}

	public function getTransactionTotalRewardPointAmount($data){
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"AND o.order_status_id > '0'";

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" :
		"";

		$filter_customer_type_statement = "";

		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND o.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND o.customer_id != 0";
			}
		}

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
		"AND c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
		"AND CONCAT(o.firstname, ' ', o.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$sql = "
		SELECT
			SUM(ROUND(ot.value, 2)) AS total_points_amount
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "order_total ot
		ON o.order_id = ot.order_id AND code = 'total'
		LEFT JOIN " . DB_PREFIX . "customer c
		ON o.customer_id = c.customer_id
		WHERE 1
		AND o.payment_method = 'points'
		$filter_customer_card_statement
		$filter_customer_name_statement
		$filter_customer_type_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_order_status_id_statement
		$filter_payment_method_statement
		$filter_store_id_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		";

		$query = $this->db->query($sql);

		return $query->row['total_points_amount'];
	}

	public function getTransactionTotalMemberAmount($data){
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"AND o.order_status_id > '0'";

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" :
		"";

		$filter_customer_type_statement = "";

		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND o.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND o.customer_id != 0";
			}
		}

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
		"AND c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
		"AND CONCAT(o.firstname, ' ', o.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$sql = "
		SELECT
			SUM(ROUND(ot.value, 2)) AS total_points_amount
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "order_total ot
		ON o.order_id = ot.order_id AND code = 'total'
		LEFT JOIN " . DB_PREFIX . "customer c
		ON o.customer_id = c.customer_id
		WHERE 1
		AND o.customer_id != 0
		$filter_customer_card_statement
		$filter_customer_name_statement
		$filter_customer_type_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_order_status_id_statement
		$filter_payment_method_statement
		$filter_store_id_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		";

		$query = $this->db->query($sql);

		return $query->row['total_points_amount'];
	}

	public function getTransactionTotalWallInAmount($data){
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"AND o.order_status_id > '0'";

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" :
		"";

		$filter_customer_type_statement = "";

		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND o.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND o.customer_id != 0";
			}
		}

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
		"AND c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
		"AND CONCAT(o.firstname, ' ', o.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$sql = "
		SELECT
			SUM(ROUND(ot.value, 2)) AS total_points_amount
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "order_total ot
		ON o.order_id = ot.order_id AND code = 'total'
		LEFT JOIN " . DB_PREFIX . "customer c
		ON o.customer_id = c.customer_id
		WHERE 1
		AND o.customer_id = 0
		$filter_customer_card_statement
		$filter_customer_name_statement
		$filter_customer_type_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_order_status_id_statement
		$filter_payment_method_statement
		$filter_store_id_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		";

		$query = $this->db->query($sql);

		return $query->row['total_points_amount'];
	}

	public function getTransactionTotalTax($data){
		$language_id = $this->config->get('config_language_id');

		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND a.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"AND a.order_status_id > '0'";

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(a.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(a.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" :
		"";

		$filter_customer_type_statement = "";

		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND a.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND a.customer_id != 0";
			}
		}

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND a.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND a.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
		"AND a.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
		"AND a.customer_name LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND a.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND a.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$sql = "
		SELECT
			b.code,
			SUM(ROUND(b.value, 2)) as total_tax
		FROM(
			SELECT * FROM(
				SELECT
					o.customer_id,
					date_added,
					o.invoice_prefix,
					ot.code,
					ot.value,
					o.payment_method,
					CONCAT(o.firstname, ' ', o.lastname) AS customer_name,
					CASE WHEN o.customer_id = 0 THEN 'Walk In Customer'
					ELSE
						(SELECT customer_card FROM " . DB_PREFIX . "customer WHERE customer_id = o.customer_id)
					END AS customer_card,
					o.order_status_id,
					o.store_id
				FROM " . DB_PREFIX . "order_total ot
				INNER JOIN " . DB_PREFIX . "order o
				ON ot.order_id = o.order_id
			)a
			WHERE 1
			$filter_order_status_id_statement
			$filter_date_start_statement
			$filter_date_end_statement
			$filter_transaction_start_statement
			$filter_transaction_end_statement
			$filter_store_id_statement
			$filter_customer_type_statement
			$filter_customer_card_statement
			$filter_customer_name_statement
			$filter_payment_method_statement
		)b
		WHERE b.code = 'tax'
		";

		//tracing sql
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/

		$query = $this->db->query($sql);
		return $query->row['total_tax'];}
	
		public function getTransactionTotalSubtotal($data){
		$language_id = $this->config->get('config_language_id');

		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND a.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"AND a.order_status_id > '0'";

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(a.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(a.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" :
		"";

		$filter_customer_type_statement = "";

		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND a.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND a.customer_id != 0";
			}
		}

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND a.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND a.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
		"AND a.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
		"AND a.customer_name LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND a.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND a.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$sql = "
		SELECT
			b.code,
			SUM(ROUND(b.value, 2)) as total_subtotal
		FROM(
			SELECT * FROM(
				SELECT
					o.customer_id,
					date_added,
					o.invoice_prefix,
					ot.code,
					ot.value,
					o.payment_method,
					CONCAT(o.firstname, ' ', o.lastname) AS customer_name,
					CASE WHEN o.customer_id = 0 THEN 'Walk In Customer'
					ELSE
						(SELECT customer_card FROM " . DB_PREFIX . "customer WHERE customer_id = o.customer_id)
					END AS customer_card,
					o.order_status_id,
					o.store_id
				FROM " . DB_PREFIX . "order_total ot
				INNER JOIN " . DB_PREFIX . "order o
				ON ot.order_id = o.order_id
			)a
			WHERE 1
			$filter_order_status_id_statement
			$filter_date_start_statement
			$filter_date_end_statement
			$filter_transaction_start_statement
			$filter_transaction_end_statement
			$filter_store_id_statement
			$filter_customer_type_statement
			$filter_customer_card_statement
			$filter_customer_name_statement
			$filter_payment_method_statement
		)b
		WHERE b.code = 'sub_total'
		";

		//tracing sql
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/

		$query = $this->db->query($sql);
		return $query->row['total_subtotal'];
	}

	public function getTransactionTotalShipping($data){
		$language_id = $this->config->get('config_language_id');

		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND a.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"AND a.order_status_id > '0'";

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(a.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(a.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" :
		"";

		$filter_customer_type_statement = "";

		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND a.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND a.customer_id != 0";
			}
		}

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND a.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND a.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
		"AND a.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
		"AND a.customer_name LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND a.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND a.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$sql = "
		SELECT
			b.code,
			SUM(ROUND(b.value, 2)) as total_shipping
		FROM(
			SELECT * FROM(
				SELECT
					o.customer_id,
					date_added,
					o.invoice_prefix,
					ot.code,
					ot.value,
					o.payment_method,
					CONCAT(o.firstname, ' ', o.lastname) AS customer_name,
					CASE WHEN o.customer_id = 0 THEN 'Walk In Customer'
					ELSE
						(SELECT customer_card FROM " . DB_PREFIX . "customer WHERE customer_id = o.customer_id)
					END AS customer_card,
					o.order_status_id,
					o.store_id
				FROM " . DB_PREFIX . "order_total ot
				INNER JOIN " . DB_PREFIX . "order o
				ON ot.order_id = o.order_id
			)a
			WHERE 1
			$filter_order_status_id_statement
			$filter_date_start_statement
			$filter_date_end_statement
			$filter_transaction_start_statement
			$filter_transaction_end_statement
			$filter_store_id_statement
			$filter_customer_type_statement
			$filter_customer_card_statement
			$filter_customer_name_statement
			$filter_payment_method_statement
		)b
		WHERE b.code = 'shipping'
		";

		//tracing sql
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/

		$query = $this->db->query($sql);
		return $query->row['total_shipping'];
	}

	public function getTransactionTotalRounding($data){
		$language_id = $this->config->get('config_language_id');

		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND a.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"AND a.order_status_id > '0'";

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(a.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(a.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" :
		"";

		$filter_customer_type_statement = "";

		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND a.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND a.customer_id != 0";
			}
		}

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND a.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND a.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
		"AND a.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
		"AND a.customer_name LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND a.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND a.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$sql = "
		SELECT
			b.code,
			SUM(ROUND(b.value, 2)) as total_rounding
		FROM(
			SELECT * FROM(
				SELECT
					o.customer_id,
					date_added,
					o.invoice_prefix,
					ot.code,
					ot.value,
					o.payment_method,
					CONCAT(o.firstname, ' ', o.lastname) AS customer_name,
					CASE WHEN o.customer_id = 0 THEN 'Walk In Customer'
					ELSE
						(SELECT customer_card FROM " . DB_PREFIX . "customer WHERE customer_id = o.customer_id)
					END AS customer_card,
					o.order_status_id,
					o.store_id
				FROM " . DB_PREFIX . "order_total ot
				INNER JOIN " . DB_PREFIX . "order o
				ON ot.order_id = o.order_id
			)a
			WHERE 1
			$filter_order_status_id_statement
			$filter_date_start_statement
			$filter_date_end_statement
			$filter_transaction_start_statement
			$filter_transaction_end_statement
			$filter_store_id_statement
			$filter_customer_type_statement
			$filter_customer_card_statement
			$filter_customer_name_statement
			$filter_payment_method_statement
		)b
		WHERE b.code = 'rounding'
		";

		$query = $this->db->query($sql);
		return $query->row['total_rounding'];
	}

	public function getTransactionTotalSales($data){
		$language_id = $this->config->get('config_language_id');

		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND a.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"AND a.order_status_id > '0'";

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(a.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(a.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" :
		"";

		$filter_customer_type_statement = "";

		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND a.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND a.customer_id != 0";
			}
		}

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND a.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND a.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
		"AND a.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
		"AND a.customer_name LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND a.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND a.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$sql = "
		SELECT
			b.code,
			SUM(ROUND(b.value, 2)) AS total_sales
		FROM(
			SELECT * FROM(
				SELECT
					o.customer_id,
					date_added,
					o.invoice_prefix,
					ot.code,
					ot.value,
					o.payment_method,
					CONCAT(o.firstname, ' ', o.lastname) AS customer_name,
					CASE WHEN o.customer_id = 0 THEN 'Walk In Customer'
					ELSE
						(SELECT customer_card FROM " . DB_PREFIX . "customer WHERE customer_id = o.customer_id)
					END AS customer_card,
					o.order_status_id,
					o.store_id
				FROM " . DB_PREFIX . "order_total ot
				INNER JOIN " . DB_PREFIX . "order o
				ON ot.order_id = o.order_id
			)a
			WHERE 1
			$filter_order_status_id_statement
			$filter_date_start_statement
			$filter_date_end_statement
			$filter_transaction_start_statement
			$filter_transaction_end_statement
			$filter_store_id_statement
			$filter_customer_type_statement
			$filter_customer_card_statement
			$filter_customer_name_statement
			$filter_payment_method_statement
		)b
		WHERE b.code = 'total'
		";

		//tracing sql
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/

		$query = $this->db->query($sql);
		return $query->row['total_sales'];
	}

	public function getTransactionInfo($order_id){
		$sql = "
		SELECT
			p.code AS code,
			op.name AS name,
			op.quantity AS quantity,
			op.price AS price,
			op.total_net_amount AS subtotal,
			op.total_tax AS tax,
			op.total
		FROM " . DB_PREFIX . "order_product op
		LEFT JOIN " . DB_PREFIX . "product p
		ON op.product_id = p.product_id
		WHERE order_id = '" . (int)$order_id . "'
		AND op.price > 0

		UNION ALL

		SELECT
			sf.invoice_prefix AS code,
			csd.name AS name,
			1 AS quantity,
			si.price AS price,
			si.net_amount AS subtotal,
			si.gst AS tax,
			si.total AS total
		FROM " . DB_PREFIX . "service_form sf
		LEFT JOIN " . DB_PREFIX . "service_item si
		ON sf.service_form_id = si.service_form_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON si.clinicalservice_id = csd.clinicalservice_id
		WHERE 1
		AND language_id = 1
		AND sf.order_id = '" . (int)$order_id . "'

		UNION ALL

		SELECT
			invoice_prefix AS code,
			'Herbal Remedies' AS name,
			1 AS quantity,
			d_net_amount AS price,
			d_net_amount AS subtotal,
			d_gst AS tax,
			total_d_gst AS total
		FROM " . DB_PREFIX . "clinical_sale
		WHERE 1
		AND order_id = '" . (int)$order_id . "'";

		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getTransactionInfoTotalTax($order_id){
		$sql = "
		SELECT
			SUM(ROUND(op.tax, 2)) AS total_tax
		FROM " . DB_PREFIX . "order_product op
		LEFT JOIN " . DB_PREFIX . "product p
		ON (op.product_id = p.product_id)
		WHERE order_id = " . (int)$order_id;

		$query = $this->db->query($sql);
		return $query->row['total_tax'];
	}

	public function getTransactionInfoTotalSubtotal($order_id){
		$sql = "
		SELECT
			SUM(ROUND(op.price, 2)) AS subtotal
		FROM " . DB_PREFIX . "order_product op
		LEFT JOIN " . DB_PREFIX . "product p
		ON (op.product_id = p.product_id)
		WHERE order_id = " . (int)$order_id;

		$query = $this->db->query($sql);
		return $query->row['subtotal'];
	}

	public function getTransactionInfoTotalSales($order_id){
		$sql = "
		SELECT
			SUM(ROUND(op.total, 2)) AS total_sales
		FROM " . DB_PREFIX . "order_product op
		LEFT JOIN " . DB_PREFIX . "product p
		ON (op.product_id = p.product_id)
		WHERE order_id = " . (int)$order_id;

		$query = $this->db->query($sql);
		return $query->row['total_sales'];
	}

	public function getTransactionWalkInPercentage($data){
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"AND o.order_status_id > '0'";

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" :
		"";

		$filter_customer_type_statement = "";

		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND o.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND o.customer_id != 0";
			}
		}

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
		"AND c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
		"AND CONCAT(o.firstname, ' ' , o.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$sql = "
		SELECT
			(SUM(CASE WHEN o.customer_id = 0 THEN 1 ELSE 0 END) * 100 / COUNT(*)) AS walkin_percentage
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "customer c
		ON o.customer_id = c.customer_id
		WHERE 1
		$filter_customer_card_statement
		$filter_customer_name_statement
		$filter_customer_type_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_order_status_id_statement
		$filter_payment_method_statement
		$filter_store_id_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		";

		$query = $this->db->query($sql);

		return $query->row['walkin_percentage'];
	}
	
	public function getTransactionMembersPercentage($data){
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"AND o.order_status_id > '0'";

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" :
		"";

		$filter_customer_type_statement = "";

		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND o.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND o.customer_id != 0";
			}
		}

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
		"AND c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
		"AND CONCAT(o.firstname, ' ' , o.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$sql = "
		SELECT
			(SUM(CASE WHEN o.customer_id != 0 THEN 1 ELSE 0 END) * 100 / COUNT(*)) AS walkin_percentage
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "customer c
		ON o.customer_id = c.customer_id
		WHERE 1
		$filter_customer_card_statement
		$filter_customer_name_statement
		$filter_customer_type_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_order_status_id_statement
		$filter_payment_method_statement
		$filter_store_id_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		";

		$query = $this->db->query($sql);

		return $query->row['walkin_percentage'];
	}

	// Sales
	public function getTotalSales($data = array()) {
		$sql = "SELECT SUM(total) AS total FROM `" . DB_PREFIX . "order` WHERE order_status_id > '0'";

		if (!empty($data['filter_date_added'])) {
			$sql .= " AND DATE(date_added) = DATE('" . $this->db->escape($data['filter_date_added']) . "')";
		}

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	// Map
	public function getTotalOrdersByCountry() {
		$query = $this->db->query("SELECT COUNT(*) AS total, SUM(o.total) AS amount, c.iso_code_2 FROM `" . DB_PREFIX . "order` o LEFT JOIN `" . DB_PREFIX . "country` c ON (o.payment_country_id = c.country_id) WHERE o.order_status_id > '0' GROUP BY o.payment_country_id");

		return $query->rows;
	}

	// Orders
	public function getTotalOrdersByDay() {
		$implode = array();

		foreach ($this->config->get('config_complete_status') as $order_status_id) {
			$implode[] = "'" . (int)$order_status_id . "'";
		}

		$order_data = array();

		for ($i = 0; $i < 24; $i++) {
			$order_data[$i] = array(
				'hour'  => $i,
				'total' => 0
			);
		}

		$query = $this->db->query("SELECT COUNT(*) AS total, HOUR(date_added) AS hour FROM `" . DB_PREFIX . "order` WHERE order_status_id IN(" . implode(",", $implode) . ") AND DATE(date_added) = DATE(NOW()) GROUP BY HOUR(date_added) ORDER BY date_added ASC");

		foreach ($query->rows as $result) {
			$order_data[$result['hour']] = array(
				'hour'  => $result['hour'],
				'total' => $result['total']
			);
		}

		return $order_data;
	}

	public function getTotalOrdersByWeek() {
		$implode = array();

		foreach ($this->config->get('config_complete_status') as $order_status_id) {
			$implode[] = "'" . (int)$order_status_id . "'";
		}

		$order_data = array();

		$date_start = strtotime('-' . date('w') . ' days');

		for ($i = 0; $i < 7; $i++) {
			$date = date('Y-m-d', $date_start + ($i * 86400));

			$order_data[date('w', strtotime($date))] = array(
				'day'   => date('D', strtotime($date)),
				'total' => 0
			);
		}

		$query = $this->db->query("SELECT COUNT(*) AS total, date_added FROM `" . DB_PREFIX . "order` WHERE order_status_id IN(" . implode(",", $implode) . ") AND DATE(date_added) >= DATE('" . $this->db->escape(date('Y-m-d', $date_start)) . "') GROUP BY DAYNAME(date_added)");

		foreach ($query->rows as $result) {
			$order_data[date('w', strtotime($result['date_added']))] = array(
				'day'   => date('D', strtotime($result['date_added'])),
				'total' => $result['total']
			);
		}

		return $order_data;
	}

	public function getTotalOrdersByMonth() {
		$implode = array();

		foreach ($this->config->get('config_complete_status') as $order_status_id) {
			$implode[] = "'" . (int)$order_status_id . "'";
		}

		$order_data = array();

		for ($i = 1; $i <= date('t'); $i++) {
			$date = date('Y') . '-' . date('m') . '-' . $i;

			$order_data[date('j', strtotime($date))] = array(
				'day'   => date('d', strtotime($date)),
				'total' => 0
			);
		}

		$query = $this->db->query("SELECT COUNT(*) AS total, date_added FROM `" . DB_PREFIX . "order` WHERE order_status_id IN(" . implode(",", $implode) . ") AND DATE(date_added) >= '" . $this->db->escape(date('Y') . '-' . date('m') . '-1') . "' GROUP BY DATE(date_added)");

		foreach ($query->rows as $result) {
			$order_data[date('j', strtotime($result['date_added']))] = array(
				'day'   => date('d', strtotime($result['date_added'])),
				'total' => $result['total']
			);
		}

		return $order_data;
	}

	public function getTotalOrdersByYear() {
		$implode = array();

		foreach ($this->config->get('config_complete_status') as $order_status_id) {
			$implode[] = "'" . (int)$order_status_id . "'";
		}

		$order_data = array();

		for ($i = 1; $i <= 12; $i++) {
			$order_data[$i] = array(
				'month' => date('M', mktime(0, 0, 0, $i)),
				'total' => 0
			);
		}

		$query = $this->db->query("SELECT COUNT(*) AS total, date_added FROM `" . DB_PREFIX . "order` WHERE order_status_id IN(" . implode(",", $implode) . ") AND YEAR(date_added) = YEAR(NOW()) GROUP BY MONTH(date_added)");

		foreach ($query->rows as $result) {
			$order_data[date('n', strtotime($result['date_added']))] = array(
				'month' => date('M', strtotime($result['date_added'])),
				'total' => $result['total']
			);
		}

		return $order_data;
	}

	public function getOrders($data = array()) {
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"AND o.order_status_id > '0'";

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" :
		"";

		$filter_group = (!empty($data['filter_group'])) ?
		$data['filter_group'] :
		"week";

		$filter_group_statement = "";
		switch($filter_group){
			case "day":
				$filter_group_statement = "GROUP BY YEAR(o.date_added), MONTH(o.date_added), DAY(o.date_added)";
				break;
			case "week":
				$filter_group_statement = "GROUP BY YEAR(o.date_added), WEEK(o.date_added)";;
				break;
			case "month":
				$filter_group_statement = "GROUP BY YEAR(o.date_added), MONTH(o.date_added)";;
				break;
			case "year":
				$filter_group_statement = "GROUP BY YEAR(o.date_added)";;
				break;
			default:
				$filter_group_statement = "";
		}

		$limit_statement = "";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$sql = "
		SELECT
			MIN(o.date_added) AS date_start,
			MAX(o.date_added) AS date_end,
			COUNT(*) AS `orders`,
			(
				SELECT
					SUM(op.quantity)
				FROM `" . DB_PREFIX . "order_product` op
				WHERE op.order_id = o.order_id
				GROUP BY op.order_id
			) AS products,
			(
				SELECT SUM(ot.value)
				FROM `" . DB_PREFIX . "order_total` ot
				WHERE ot.order_id = o.order_id
				AND ot.code = 'tax'
				GROUP BY ot.order_id
			) AS tax, SUM(o.total) AS `total`
			FROM `" . DB_PREFIX . "order` o
			WHERE 1
			$filter_order_status_id_statement
			$filter_date_start_statement
			$filter_date_end_statement
			$filter_group_statement
			ORDER BY o.date_added DESC
			$limit_statement
			";



		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalOrders($data = array()) {
		if (!empty($data['filter_group'])) {
			$group = $data['filter_group'];
		} else {
			$group = 'week';
		}

		switch($group) {
			case 'day';
				$sql = "SELECT COUNT(DISTINCT YEAR(date_added), MONTH(date_added), DAY(date_added)) AS total FROM `" . DB_PREFIX . "order`";
				break;
			default:
			case 'week':
				$sql = "SELECT COUNT(DISTINCT YEAR(date_added), WEEK(date_added)) AS total FROM `" . DB_PREFIX . "order`";
				break;
			case 'month':
				$sql = "SELECT COUNT(DISTINCT YEAR(date_added), MONTH(date_added)) AS total FROM `" . DB_PREFIX . "order`";
				break;
			case 'year':
				$sql = "SELECT COUNT(DISTINCT YEAR(date_added)) AS total FROM `" . DB_PREFIX . "order`";
				break;
		}

		if (!empty($data['filter_order_status_id'])) {
			$sql .= " WHERE order_status_id = '" . (int)$data['filter_order_status_id'] . "'";
		} else {
			$sql .= " WHERE order_status_id > '0'";
		}

		if (!empty($data['filter_date_start'])) {
			$sql .= " AND DATE(date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}

		if (!empty($data['filter_date_end'])) {
			$sql .= " AND DATE(date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		}

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function getTaxes($data = array()) {
		$sql = "SELECT MIN(o.date_added) AS date_start, MAX(o.date_added) AS date_end, ot.title, SUM(ot.value) AS total, COUNT(o.order_id) AS `orders` FROM `" . DB_PREFIX . "order` o LEFT JOIN `" . DB_PREFIX . "order_total` ot ON (ot.order_id = o.order_id) WHERE ot.code = 'tax'";

		if (!empty($data['filter_order_status_id'])) {
			$sql .= " AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'";
		} else {
			$sql .= " AND o.order_status_id > '0'";
		}

		if (!empty($data['filter_date_start'])) {
			$sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}

		if (!empty($data['filter_date_end'])) {
			$sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		}

		if (!empty($data['filter_group'])) {
			$group = $data['filter_group'];
		} else {
			$group = 'week';
		}

		switch($group) {
			case 'day';
				$sql .= " GROUP BY YEAR(o.date_added), MONTH(o.date_added), DAY(o.date_added), ot.title";
				break;
			default:
			case 'week':
				$sql .= " GROUP BY YEAR(o.date_added), WEEK(o.date_added), ot.title";
				break;
			case 'month':
				$sql .= " GROUP BY YEAR(o.date_added), MONTH(o.date_added), ot.title";
				break;
			case 'year':
				$sql .= " GROUP BY YEAR(o.date_added), ot.title";
				break;
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalTaxes($data = array()) {
		if (!empty($data['filter_group'])) {
			$group = $data['filter_group'];
		} else {
			$group = 'week';
		}

		switch($group) {
			case 'day';
				$sql = "SELECT COUNT(DISTINCT YEAR(o.date_added), MONTH(o.date_added), DAY(o.date_added), ot.title) AS total FROM `" . DB_PREFIX . "order` o";
				break;
			default:
			case 'week':
				$sql = "SELECT COUNT(DISTINCT YEAR(o.date_added), WEEK(o.date_added), ot.title) AS total FROM `" . DB_PREFIX . "order` o";
				break;
			case 'month':
				$sql = "SELECT COUNT(DISTINCT YEAR(o.date_added), MONTH(o.date_added), ot.title) AS total FROM `" . DB_PREFIX . "order` o";
				break;
			case 'year':
				$sql = "SELECT COUNT(DISTINCT YEAR(o.date_added), ot.title) AS total FROM `" . DB_PREFIX . "order` o";
				break;
		}

		$sql .= " LEFT JOIN `" . DB_PREFIX . "order_total` ot ON (o.order_id = ot.order_id) WHERE ot.code = 'tax'";

		if (!empty($data['filter_order_status_id'])) {
			$sql .= " AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'";
		} else {
			$sql .= " AND o.order_status_id > '0'";
		}

		if (!empty($data['filter_date_start'])) {
			$sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}

		if (!empty($data['filter_date_end'])) {
			$sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		}

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function getShipping($data = array()) {
		$sql = "SELECT MIN(o.date_added) AS date_start, MAX(o.date_added) AS date_end, ot.title, SUM(ot.value) AS total, COUNT(o.order_id) AS `orders` FROM `" . DB_PREFIX . "order` o LEFT JOIN `" . DB_PREFIX . "order_total` ot ON (o.order_id = ot.order_id) WHERE ot.code = 'shipping'";

		if (!empty($data['filter_order_status_id'])) {
			$sql .= " AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'";
		} else {
			$sql .= " AND o.order_status_id > '0'";
		}

		if (!empty($data['filter_date_start'])) {
			$sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}

		if (!empty($data['filter_date_end'])) {
			$sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		}

		if (!empty($data['filter_group'])) {
			$group = $data['filter_group'];
		} else {
			$group = 'week';
		}

		switch($group) {
			case 'day';
				$sql .= " GROUP BY YEAR(o.date_added), MONTH(o.date_added), DAY(o.date_added), ot.title";
				break;
			default:
			case 'week':
				$sql .= " GROUP BY YEAR(o.date_added), WEEK(o.date_added), ot.title";
				break;
			case 'month':
				$sql .= " GROUP BY YEAR(o.date_added), MONTH(o.date_added), ot.title";
				break;
			case 'year':
				$sql .= " GROUP BY YEAR(o.date_added), ot.title";
				break;
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalShipping($data = array()) {
		if (!empty($data['filter_group'])) {
			$group = $data['filter_group'];
		} else {
			$group = 'week';
		}

		switch($group) {
			case 'day';
				$sql = "SELECT COUNT(DISTINCT YEAR(o.date_added), MONTH(o.date_added), DAY(o.date_added), ot.title) AS total FROM `" . DB_PREFIX . "order` o";
				break;
			default:
			case 'week':
				$sql = "SELECT COUNT(DISTINCT YEAR(o.date_added), WEEK(o.date_added), ot.title) AS total FROM `" . DB_PREFIX . "order` o";
				break;
			case 'month':
				$sql = "SELECT COUNT(DISTINCT YEAR(o.date_added), MONTH(o.date_added), ot.title) AS total FROM `" . DB_PREFIX . "order` o";
				break;
			case 'year':
				$sql = "SELECT COUNT(DISTINCT YEAR(o.date_added), ot.title) AS total FROM `" . DB_PREFIX . "order` o";
				break;
		}

		$sql .= " LEFT JOIN `" . DB_PREFIX . "order_total` ot ON (o.order_id = ot.order_id) WHERE ot.code = 'shipping'";

		if (!empty($data['filter_order_status_id'])) {
			$sql .= " AND order_status_id = '" . (int)$data['filter_order_status_id'] . "'";
		} else {
			$sql .= " AND order_status_id > '0'";
		}

		if (!empty($data['filter_date_start'])) {
			$sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}

		if (!empty($data['filter_date_end'])) {
			$sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		}

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	//summary
	public function getSalesSummary($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		if (isset($data['start']) && isset($data['limit'])) {
			$data['start'] = $data['start'] < 0 ? 0 : $data['start'];
			$data['limit'] = $data['limit'] < 1 ? $this->config->get('config_limit_admin') : $data['limit'];
		}

		$all_sales = array();

		// herbal remedies subtotal
		$herbal_sql = "
		SELECT DATE(o.date_added) AS date_report, SUM(ROUND(cst.value, 2)) as total
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "clinical_sale cs
		ON o.order_id = cs.order_id
		LEFT JOIN " . DB_PREFIX . "clinical_sale_total cst
		ON cs.clinical_sale_id = cst.clinical_sale_id
		WHERE 1
		AND cst.id = 1
		AND cst.code = 'sub_total'
		AND cs.collect_consultation_price = '1'
		AND DATE(o.date_added) >= DATE('" . $this->db->escape($date_start) . "')
		AND DATE(o.date_added) <= DATE('" . $this->db->escape($date_end) . "')
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		GROUP BY DATE(o.date_added)
		";

		$herbal_query = $this->db->query($herbal_sql);
		$herbal_rows = $herbal_query->rows;

		foreach($herbal_rows as $row){
			$all_sales[$row['date_report']]['herbal_1'] = $row['total'];
		}

		$herbal_sql2 = "
		SELECT DATE(o.date_added) AS date_report, SUM(ROUND(cst.value, 2)) as total
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "clinical_sale cs
		ON o.order_id = cs.order_id
		LEFT JOIN " . DB_PREFIX . "clinical_sale_total cst
		ON cs.clinical_sale_id = cst.clinical_sale_id
		WHERE 1
		AND cst.id = 2
		AND cst.code = 'sub_total'
		AND cs.collect_consultation_price = '0'
		AND DATE(o.date_added) >= DATE('" . $this->db->escape($date_start) . "')
		AND DATE(o.date_added) <= DATE('" . $this->db->escape($date_end) . "')
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		GROUP BY DATE(o.date_added)
		";

		$herbal_query2 = $this->db->query($herbal_sql2);

		$herbal_rows2 = $herbal_query2->rows;

		foreach($herbal_rows2 as $row){
			$all_sales[$row['date_report']]['herbal_2'] = $row['total'];
		}

		//doctor
		$doctor_sql = "
		SELECT DATE(o.date_added) AS date_report,
			   SUM(ROUND(cst.value, 2)) as total_large,
			   SUM(ROUND(cst2.value, 2)) as total_small
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "clinical_sale cs
		ON o.order_id = cs.order_id
		AND cs.collect_consultation_price = '1'
		LEFT JOIN " . DB_PREFIX . "clinical_sale_total cst
		ON cs.clinical_sale_id = cst.clinical_sale_id
		AND cst.id = '2'
		AND cst.code = 'sub_total'
		LEFT JOIN " . DB_PREFIX . "clinical_sale_total cst2
		ON cs.clinical_sale_id = cst2.clinical_sale_id
		AND cst2.id = '1'
		AND cst2.code = 'sub_total'
		WHERE 1
		AND DATE(o.date_added) >= DATE('" . $this->db->escape($date_start) . "')
		AND DATE(o.date_added) <= DATE('" . $this->db->escape($date_end) . "')
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		GROUP BY DATE(o.date_added)";

		$doctor_query = $this->db->query($doctor_sql);
		$doctor_rows = $doctor_query->rows;

		foreach($doctor_rows as $row){
			$all_sales[$row['date_report']]['doctor_large'] = $row['total_large'];
			$all_sales[$row['date_report']]['doctor_small'] = $row['total_small'];
		}

		//service form subtotal
		$service_sql = "
		SELECT DATE(o.date_added) AS date_report,
				SUM(ROUND(st.value, 2)) as total
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON o.order_id = sf.order_id
		LEFT JOIN " . DB_PREFIX . "service_total st
		ON sf.service_form_id = st.service_form_id
		WHERE 1
		AND st.code = 'sub_total'
		AND DATE(o.date_added) >= DATE('" . $this->db->escape($date_start) . "')
		AND DATE(o.date_added) <= DATE('" . $this->db->escape($date_end) . "')
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		GROUP BY DATE(o.date_added)";

		$service_query = $this->db->query($service_sql);
		$service_form_rows = $service_query->rows;

		foreach($service_form_rows as $row){
			$all_sales[$row['date_report']]['service_form_total'] = $row['total'];
		}

		//pos
		$pos_sql = "
		SELECT DATE(o.date_added) AS date_report,
			SUM(ROUND(op.total_net_amount, 2)) AS pos
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "order_product op
		ON o.order_id = op.order_id
		WHERE 1
		AND o.payment_method != 'points'
		AND DATE(o.date_added) >= DATE('" . $this->db->escape($date_start) . "')
		AND DATE(o.date_added) <= DATE('" . $this->db->escape($date_end) . "')
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		GROUP BY DATE(o.date_added)";

		$pos_query = $this->db->query($pos_sql);
		$pos_rows = $pos_query->rows;

		foreach($pos_rows as $row){
			$all_sales[$row['date_report']]['pos'] = $row['pos'];
		}


		$expoint_subtotal_sql = "
		SELECT DATE(o.date_added) AS date_report,
			SUM(ROUND(ot.value, 2)) AS expoint_subtotal
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "order_total ot
		ON o.order_id = ot.order_id AND code = 'sub_total'
		WHERE 1
		AND o.payment_method = 'points'
		AND DATE(o.date_added) >= DATE('" . $this->db->escape($date_start) . "')
		AND DATE(o.date_added) <= DATE('" . $this->db->escape($date_end) . "')
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		GROUP BY DATE(o.date_added)";

		$expoint_subtotal_query = $this->db->query($expoint_subtotal_sql);
		$expoint_subtotal_rows = $expoint_subtotal_query->rows;

		foreach($expoint_subtotal_rows as $row){
			$all_sales[$row['date_report']]['expoint_subtotal'] = $row['expoint_subtotal'];
		}

		$expoint_tax_sql = "
		SELECT DATE(o.date_added) AS date_report,
			SUM(ROUND(ot.value, 2)) AS expoint_tax
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "order_total ot
		ON o.order_id = ot.order_id AND code = 'tax'
		WHERE 1
		AND o.payment_method = 'points'
		AND DATE(o.date_added) >= DATE('" . $this->db->escape($date_start) . "')
		AND DATE(o.date_added) <= DATE('" . $this->db->escape($date_end) . "')
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		GROUP BY DATE(o.date_added)";

		$expoint_tax_query = $this->db->query($expoint_tax_sql);
		$expoint_tax_rows = $expoint_tax_query->rows;

		foreach($expoint_tax_rows as $row){
			$all_sales[$row['date_report']]['expoint_tax'] = $row['expoint_tax'];
		}

		// subtotal
		$subtotal_sql = "
		SELECT DATE(o.date_added) AS date_report,
			   SUM(ROUND(value, 2)) AS subtotal
		FROM " . DB_PREFIX . "order_total ot
		INNER JOIN " . DB_PREFIX . "order o
		ON ot.order_id = o.order_id
		WHERE 1
		AND ot.code = 'sub_total'
		AND DATE(o.date_added) >= DATE('" . $this->db->escape($date_start) . "')
		AND DATE(o.date_added) <= DATE('" . $this->db->escape($date_end) . "')
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		GROUP BY DATE(o.date_added)";

		$subtotal_query = $this->db->query($subtotal_sql);
		$subtotal_rows = $subtotal_query->rows;

		foreach($subtotal_rows as $row){
			$all_sales[$row['date_report']]['subtotal'] = $row['subtotal'];
		}

		//tax
		$tax_sql = "
		SELECT DATE(o.date_added) AS date_report,
			   SUM(ROUND(value, 2)) AS total_tax
		FROM " . DB_PREFIX . "order_total ot
		INNER JOIN " . DB_PREFIX . "order o
		ON ot.order_id = o.order_id
		WHERE 1
		AND ot.code = 'tax'
		AND DATE(o.date_added) >= DATE('" . $this->db->escape($date_start) . "')
		AND DATE(o.date_added) <= DATE('" . $this->db->escape($date_end) . "')
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		GROUP BY DATE(o.date_added)";

		$tax_query = $this->db->query($tax_sql);
		$tax_rows = $tax_query->rows;

		foreach($tax_rows as $row){
			$all_sales[$row['date_report']]['total_tax'] = $row['total_tax'];
		}

		//rounding
		$rounding_sql = "
		SELECT DATE(o.date_added) AS date_report,
			   SUM(ROUND(value, 2)) AS total_rounding
		FROM " . DB_PREFIX . "order_total ot
		INNER JOIN " . DB_PREFIX . "order o
		ON ot.order_id = o.order_id
		WHERE 1
		AND ot.code = 'rounding'
		AND DATE(o.date_added) >= DATE('" . $this->db->escape($date_start) . "')
		AND DATE(o.date_added) <= DATE('" . $this->db->escape($date_end) . "')
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		GROUP BY DATE(o.date_added)";

		$rounding_query = $this->db->query($rounding_sql);
		$rounding_rows = $rounding_query->rows;

		foreach($rounding_rows as $row){
			$all_sales[$row['date_report']]['total_rounding'] = $row['total_rounding'];
		}

		//shipping
		$shipping_sql = "
		SELECT DATE(o.date_added) AS date_report,
			   SUM(ROUND(value, 2)) AS total_shipping
		FROM " . DB_PREFIX . "order_total ot
		INNER JOIN " . DB_PREFIX . "order o
		ON ot.order_id = o.order_id
		WHERE 1
		AND ot.code = 'shipping'
		AND DATE(o.date_added) >= DATE('" . $this->db->escape($date_start) . "')
		AND DATE(o.date_added) <= DATE('" . $this->db->escape($date_end) . "')
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		GROUP BY DATE(o.date_added)";

		$shipping_query = $this->db->query($shipping_sql);
		$shipping_rows = $shipping_query->rows;

		foreach($shipping_rows as $row){
			$all_sales[$row['date_report']]['total_shipping'] = $row['total_shipping'];
		}

		//total
		$total_sql = "
		SELECT DATE(o.date_added) AS date_report,
			   SUM(ROUND(value, 2)) AS total_sales
		FROM " . DB_PREFIX . "order_total ot
		INNER JOIN " . DB_PREFIX . "order o
		ON ot.order_id = o.order_id
		WHERE 1
		AND ot.code = 'total'
		AND DATE(o.date_added) >= DATE('" . $this->db->escape($date_start) . "')
		AND DATE(o.date_added) <= DATE('" . $this->db->escape($date_end) . "')
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		GROUP BY DATE(o.date_added)";

		$total_query = $this->db->query($total_sql);
		$total_rows = $total_query->rows;

		foreach($total_rows as $row){
			$all_sales[$row['date_report']]['total_sales'] = $row['total_sales'];
		}

		return $all_sales;
	}

	public function getSalesSummaryTotal($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");

		$start = date_create($date_start);
		$end = date_create($date_end);

		$interval = date_diff($start,$end);

		return strtotime($date_start) <= strtotime($date_end) ? $interval->days + 1 : 0;
	}

	public function getSalesSummaryTotalHermedies($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"AND o.order_status_id > '0'";

		$filter_customer_type_statement = "";

		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND o.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND o.customer_id != 0";
			}
		}

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
		"AND c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
		"AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$sql = "
		SELECT SUM(ROUND(cst.value, 2)) as total
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "clinical_sale cs
		ON o.order_id = cs.order_id
		LEFT JOIN " . DB_PREFIX . "clinical_sale_total cst
		ON cs.clinical_sale_id = cst.clinical_sale_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON c.customer_id = o.customer_id
		WHERE 1
		AND cst.id = 1
		AND cst.code = 'sub_total'
		AND cs.collect_consultation_price = '1'
		AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
		AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		$filter_order_status_id_statement
		$filter_customer_type_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_customer_card_statement
		$filter_customer_name_statement
		";

		$sql2 = "
		SELECT SUM(ROUND(cst.value, 2)) as total
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "clinical_sale cs
		ON o.order_id = cs.order_id
		LEFT JOIN " . DB_PREFIX . "clinical_sale_total cst
		ON cs.clinical_sale_id = cst.clinical_sale_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON c.customer_id = o.customer_id
		WHERE 1
		AND cst.id = 2
		AND cst.code = 'sub_total'
		AND cs.collect_consultation_price = '0'
		AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
		AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		$filter_order_status_id_statement
		$filter_customer_type_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_customer_card_statement
		$filter_customer_name_statement
		";

		//tracing
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/

		$query = $this->db->query($sql);
		$query2 = $this->db->query($sql2);

		return $query->row['total'] + $query2->row['total'];
	}

	public function getSalesSummaryTotalDoctor($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"AND o.order_status_id > '0'";

		$filter_customer_type_statement = "";

		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND o.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND o.customer_id != 0";
			}
		}

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
		"AND c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
		"AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$sql = "
		SELECT SUM(ROUND(cst.value, 2)) as total_large,
			   SUM(ROUND(cst2.value, 2)) as total_small
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "clinical_sale cs
		ON o.order_id = cs.order_id
		LEFT JOIN " . DB_PREFIX . "clinical_sale_total cst
		ON cs.clinical_sale_id = cst.clinical_sale_id
		LEFT JOIN " . DB_PREFIX . "clinical_sale_total cst2
		ON cs.clinical_sale_id = cst2.clinical_sale_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON c.customer_id = o.customer_id
		WHERE 1
		AND cst.id = 2
		AND cst.code = 'sub_total'
		AND cst2.id = 1
		AND cst2.code = 'sub_total'
		AND cs.collect_consultation_price = '1'
		AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
		AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		$filter_order_status_id_statement
		$filter_customer_type_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_customer_card_statement
		$filter_customer_name_statement
		";

		$query = $this->db->query($sql);

		$total = $query->row['total_large'] - $query->row['total_small'];

		return $total;
	}

	public function getSalesSummaryTotalServiceForm($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"AND o.order_status_id > '0'";

		$filter_customer_type_statement = "";

		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND o.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND o.customer_id != 0";
			}
		}

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
		"AND c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
		"AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$sql = "
		SELECT SUM(ROUND(st.value, 2)) as total
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON o.order_id = sf.order_id
		LEFT JOIN " . DB_PREFIX . "service_total st
		ON sf.service_form_id = st.service_form_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON c.customer_id = sf.customer_id
		WHERE 1
		AND st.code = 'sub_total'
		AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
		AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		$filter_order_status_id_statement
		$filter_customer_type_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_customer_card_statement
		$filter_customer_name_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total'];
	}

	public function getSalesSummaryTotalExchangeSubtotal($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$sql = "
		SELECT
			SUM(ROUND(op.total_net_amount, 2)) AS total
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "order_product op
		ON o.order_id = op.order_id
		WHERE 1
		AND o.payment_method = 'points'
		AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
		AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		";

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function getSalesSummaryTotalExchangeTax($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$sql = "
		SELECT
			SUM(ROUND(op.total_tax, 2)) AS total
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "order_product op
		ON o.order_id = op.order_id
		WHERE 1
		AND o.payment_method = 'points'
		AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
		AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		";

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function getSalesSummaryTotalSubtotal($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$sql = "
		SELECT SUM(ROUND(value, 2)) AS total
		FROM " . DB_PREFIX . "order_total ot
		INNER JOIN " . DB_PREFIX . "order o
		ON ot.order_id = o.order_id
		WHERE 1
		AND ot.code = 'sub_total'
		AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
		AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		";
		$query = $this->db->query($sql);
		$total = $query->row['total'];
		return $total;
	}

	public function getSalesSummaryTotalPos($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"AND o.order_status_id > '0'";

		$filter_customer_type_statement = "";

		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND o.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND o.customer_id != 0";
			}
		}

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
		"AND c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
		"AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$sql = "
		SELECT SUM(ROUND(op.total_net_amount, 2)) AS total_pos
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "order_product op
		ON o.order_id = op.order_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON c.customer_id = o.customer_id
		WHERE 1
		AND o.payment_method != 'points'
		AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
		AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		$filter_order_status_id_statement
		$filter_customer_type_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_customer_card_statement
		$filter_customer_name_statement
		";

		$query = $this->db->query($sql);
		$pos = $query->row['total_pos'];

		return $pos;
	}

	public function getSalesSummaryTotalTax($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$sql = "
		SELECT SUM(ROUND(value, 2)) AS total_tax
		FROM " . DB_PREFIX . "order_total ot
		INNER JOIN " . DB_PREFIX . "order o
		ON ot.order_id = o.order_id
		WHERE 1
		AND ot.code = 'tax'
		AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
		AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		";
		$query = $this->db->query($sql);
		$tax = $query->row['total_tax'];

		return $tax;
	}

	public function getSalesSummaryTotalRounding($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$sql = "
		SELECT SUM(ROUND(ot.value, 2)) AS total_rounding
		FROM " . DB_PREFIX . "order_total ot
		INNER JOIN " . DB_PREFIX . "order o
		ON ot.order_id = o.order_id
		WHERE 1
		AND ot.code = 'rounding'
		AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
		AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_rounding'];
	}

	public function getSalesSummaryTotalShipping($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$sql = "
		SELECT SUM(ROUND(value, 2)) AS total_shipping
		FROM " . DB_PREFIX . "order_total ot
		INNER JOIN " . DB_PREFIX . "order o
		ON ot.order_id = o.order_id
		WHERE 1
		AND ot.code = 'shipping'
		AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
		AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_shipping'];
	}

	public function getSalesSummaryTotalSales($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$sql = "
		SELECT SUM(ROUND(value, 2)) AS total_sales
		FROM " . DB_PREFIX . "order_total ot
		INNER JOIN " . DB_PREFIX . "order o
		ON ot.order_id = o.order_id
		WHERE 1
		AND ot.code = 'total'
		AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
		AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_sales'];
	}

	//herber remedies
	public function getHerbalremediesSummaryByStock($data){
		$sort 	= isset($data['sort']) ? $data['sort'] : "product_id";
		$order 	= isset($data['order']) ? $data['order'] : "ASC";

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		$filter_date_statement = "";

		if((!empty($data['filter_date_start'])) || (!empty($data['filter_date_end']))){
			$filter_date_statement = "
			AND
			(
				(
					cs.order_id != '0'";
					$filter_date_statement .= (!empty($data['filter_date_start'])) ?
					"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
					"";
					$filter_date_statement .= (!empty($data['filter_date_end'])) ?
					"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
					"";

				$filter_date_statement .= "
				)
				OR
				(
					cs.order_id = '0'";
					$filter_date_statement .= (!empty($data['filter_date_start'])) ?
					"AND DATE(cs.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
					"";
					$filter_date_statement .= (!empty($data['filter_date_end'])) ?
					"AND DATE(cs.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
					"";

				$filter_date_statement .= "
				)
			)
			";
		}

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND cs.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_category = $data['filter_category'] != '' ?
		"AND cd.category_id = '" . (int)$data['filter_category'] . "'" :
		"";

		/*$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND cs.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";*/
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND cs.order_action IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";

		$filter_order_status_statement = (!empty($data['filter_order_status'])) ?
		"AND cs.clinicalsale_action = '" . (int)$data['filter_order_status'] . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";

		$filter_model_statement = (!empty($data['filter_model'])) ?
		"AND p.model LIKE '%" . $this->db->escape($data['filter_model']) . "%'" :
		"";


		$limit_statement = "";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$sql = "
		SELECT
				csp.product_id AS product_id,
				p.code AS code,
				CASE WHEN (pd_en.name is NULL OR pd_en.name='') THEN '-' ELSE pd_en.name END AS en_name,
				CASE WHEN (pd_cn.name is NULL OR pd_cn.name='') THEN '-' ELSE pd_cn.name END AS cn_name,
				p.model,
				p.costprice AS costprice,
				cd.category_id AS category_id,
				GROUP_CONCAT(cd.name) as category,
				p.price AS price,
				SUM(csp.t_weight) as weight,
				p.weight_class_id AS weight_class_id,
				SUM(csp.t_weight * wc.value) as total_weight,
				csp.tax_code
			FROM " . DB_PREFIX . "clinicalsale_product csp
				LEFT JOIN " . DB_PREFIX . "clinical_sale cs 
					ON csp.clinical_sale_id = cs.clinical_sale_id
				LEFT JOIN " . DB_PREFIX . "product p 
					ON csp.product_id = p.product_id
				LEFT JOIN " . DB_PREFIX . "product_description pd_en 
					ON p.product_id = pd_en.product_id AND pd_en.language_id = 1
				LEFT JOIN " . DB_PREFIX . "product_description pd_cn 
					ON p.product_id = pd_cn.product_id AND pd_cn.language_id = 2
				LEFT JOIN " . DB_PREFIX . "weight_class wc
					ON p.weight_class_id = wc.weight_class_id
				LEFT JOIN " . DB_PREFIX . "order o
					ON cs.order_id = o.order_id
				LEFT JOIN " . DB_PREFIX . "product_to_category ptc
					ON csp.product_id = ptc.product_id
				LEFT JOIN " . DB_PREFIX . "category_description cd
					ON ptc.category_id = cd.category_id AND cd.language_id = '" . (int)$this->config->get("config_language_id") . "'
			WHERE 
				1
				AND cs.order_id <>''
				$filter_store_id_statement
				$filter_category
				$filter_payment_status_statement
				$filter_order_status_statement
				$filter_payment_method_statement
				$filter_date_statement
				$filter_code_statement
				$filter_name_cn_statement
				$filter_name_en_statement
				$filter_model_statement
			GROUP BY
				csp.product_id,
				p.code,
				pd_en.name,
				pd_cn.name,
				p.costprice,
				p.price
			ORDER BY $sort $order
			$limit_statement
		";

		print_r($sql);

		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getHerbalremediesSummaryByStockTotal($data){
		$sort 	= isset($data['sort']) ? $data['sort'] : "date_added";
		$order 	= isset($data['order']) ? $data['order'] : "DESC";

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		$filter_date_statement = "";

		if((!empty($data['filter_date_start'])) || (!empty($data['filter_date_end']))){
			$filter_date_statement = "
			AND
			(
				(
					cs.order_id != '0'";
					$filter_date_statement .= (!empty($data['filter_date_start'])) ?
					"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
					"";
					$filter_date_statement .= (!empty($data['filter_date_end'])) ?
					"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
					"";

				$filter_date_statement .= "
				)
				OR
				(
					cs.order_id = '0'";
					$filter_date_statement .= (!empty($data['filter_date_start'])) ?
					"AND DATE(cs.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
					"";
					$filter_date_statement .= (!empty($data['filter_date_end'])) ?
					"AND DATE(cs.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
					"";

				$filter_date_statement .= "
				)
			)
			";
		}

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND cs.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		/*$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND cs.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";*/
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND cs.order_action IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";


		$filter_order_status_statement = (!empty($data['filter_order_status'])) ?
		"AND cs.clinicalsale_action = '" . (int)$data['filter_order_status'] . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";

		$filter_model_statement = (!empty($data['filter_model'])) ?
		"AND p.model LIKE '%" . $this->db->escape($data['filter_model']) . "%'" :
		"";

		$sql = "
		SELECT COUNT(*) AS total_row
		FROM(
			SELECT
				csp.product_id,
				p.code,
				CASE WHEN (pd_en.name is NULL OR pd_en.name='') THEN '-' ELSE pd_en.name END AS en_name,
				CASE WHEN (pd_cn.name is NULL OR pd_cn.name='') THEN '-' ELSE pd_cn.name END AS cn_name,
				p.costprice,
				p.price,
				SUM(csp.t_weight) as weight,
				p.weight_class_id
			FROM " . DB_PREFIX . "clinicalsale_product csp
			INNER JOIN " . DB_PREFIX . "clinical_sale cs
			ON csp.clinical_sale_id = cs.clinical_sale_id
			INNER JOIN " . DB_PREFIX . "product p
			ON csp.product_id = p.product_id
			INNER JOIN " . DB_PREFIX . "product_description pd_en
			ON p.product_id = pd_en.product_id AND pd_en.language_id = 1
			INNER JOIN " . DB_PREFIX . "product_description pd_cn
			ON p.product_id = pd_cn.product_id AND pd_cn.language_id = 2
			INNER JOIN " . DB_PREFIX . "weight_class wc
			ON p.weight_class_id = wc.weight_class_id
			LEFT JOIN " . DB_PREFIX . "order o
			ON cs.order_id = o.order_id
			LEFT JOIN " . DB_PREFIX . "product_to_category ptc
			ON csp.product_id = ptc.product_id
			WHERE 1
			#AND cs.order_id != '0'
			$filter_store_id_statement
			$filter_payment_status_statement
			$filter_order_status_statement
			$filter_payment_method_statement
			$filter_date_statement
			$filter_code_statement
			$filter_name_cn_statement
			$filter_name_en_statement
			$filter_model_statement
			GROUP BY
			csp.product_id,
			p.code,
			pd_en.name,
			pd_cn.name,
			p.costprice,
			p.price
		)a
		";

		$query = $this->db->query($sql);
		return $query->row['total_row'];
	}

	public function getHerbalremediesSummaryByStockTotalQuantity($data){
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		$filter_date_statement = "";

		if((!empty($data['filter_date_start'])) || (!empty($data['filter_date_end']))){
			$filter_date_statement = "
			AND
			(
				(
					cs.order_id != '0'";
					$filter_date_statement .= (!empty($data['filter_date_start'])) ?
					"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
					"";
					$filter_date_statement .= (!empty($data['filter_date_end'])) ?
					"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
					"";

				$filter_date_statement .= "
				)
				OR
				(
					cs.order_id = '0'";
					$filter_date_statement .= (!empty($data['filter_date_start'])) ?
					"AND DATE(cs.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
					"";
					$filter_date_statement .= (!empty($data['filter_date_end'])) ?
					"AND DATE(cs.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
					"";

				$filter_date_statement .= "
				)
			)
			";
		}

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND cs.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND cs.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND cs.order_action IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";

		$filter_order_status_statement = (!empty($data['filter_order_status'])) ?
		"AND cs.clinicalsale_action = '" . (int)$data['filter_order_status'] . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";

		$filter_model_statement = (!empty($data['filter_model'])) ?
		"AND p.model LIKE '%" . $this->db->escape($data['filter_model']) . "%'" :
		"";

		$limit_statement = "";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$sql = "
		SELECT
			SUM(csp.t_weight * wc.value) as total_weight
		FROM " . DB_PREFIX . "clinicalsale_product csp
		INNER JOIN " . DB_PREFIX . "clinical_sale cs
		ON csp.clinical_sale_id = cs.clinical_sale_id
		INNER JOIN " . DB_PREFIX . "product p
		ON csp.product_id = p.product_id
		INNER JOIN " . DB_PREFIX . "product_description pd_en
		ON p.product_id = pd_en.product_id AND pd_en.language_id = 1
		INNER JOIN " . DB_PREFIX . "product_description pd_cn
		ON p.product_id = pd_cn.product_id AND pd_cn.language_id = 2
		INNER JOIN " . DB_PREFIX . "weight_class wc
		ON p.weight_class_id = wc.weight_class_id
		LEFT JOIN " . DB_PREFIX . "order o
		ON cs.order_id = o.order_id
		WHERE 1
		#AND cs.order_id != '0'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_order_status_statement
		$filter_payment_method_statement
		$filter_date_statement
		$filter_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		$filter_model_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_weight'];
	}

	public function getHerbalremediesDetailByStock($data){
		$language_id = $this->config->get('config_language_id');

		// $sort 	= isset($data['sort']) ? $data['sort'] : "invoice_prefix";
		// $order 	= isset($data['order']) ? $data['order'] : "DESC";

        $filter_payment_method= isset($data['filter_payment_method']) ? explode(',', $data['filter_payment_method']) : array();


		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(cs.sales_date) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(cs.sales_date) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		// $filter_date_statement = "";


		// if((!empty($data['filter_date_start'])) || (!empty($data['filter_date_end']))){
		// 	$filter_date_statement = "
		// 	AND
		// 	(
		// 		(
		// 			cs.order_id != '0'";
		// 			$filter_date_statement .= (!empty($data['filter_date_start'])) ?
		// 			"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		// 			"";
		// 			$filter_date_statement .= (!empty($data['filter_date_end'])) ?
		// 			"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		// 			"";

		// 		$filter_date_statement .= "
		// 		)
		// 		OR
		// 		(
		// 			cs.order_id = '0'";
		// 			$filter_date_statement .= (!empty($data['filter_date_start'])) ?
		// 			"AND DATE(cs.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		// 			"";
		// 			$filter_date_statement .= (!empty($data['filter_date_end'])) ?
		// 			"AND DATE(cs.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		// 			"";

		// 		$filter_date_statement .= "
		// 		)
		// 	)
		// 	";
		// }

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND cs.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND cs.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND cs.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND cs.order_action IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";

		$filter_order_status_statement = (!empty($data['filter_order_status'])) ?
		"AND cs.clinicalsale_action IN (" . $this->db->escape($data['filter_order_status']) . ")" :
		"";

		// $filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		// "AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		// "";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";

		$filter_model_statement = (!empty($data['filter_model'])) ?
		"AND p.model LIKE '%" . $this->db->escape($data['filter_model']) . "%'" :
		"";

		$filter_payment_method_statement = "";

        foreach ($filter_payment_method as $filter_payment_methods) {
            $filter_payment_method_statement .= empty($filter_payment_method_statement) ? "o.payment_method LIKE '%" . $filter_payment_methods . "%'" : " OR o.payment_method LIKE '%" . $filter_payment_methods . "%'";
        }

        $filter_payment_method_statement = !empty($filter_payment_method_statement) ? "AND ($filter_payment_method_statement)" : "";


		$limit_statement = "";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$sql = "
		SELECT
			cs.invoice_prefix AS invoice_prefix,
			cs.sales_date AS sales_date,
			csp.product_id AS product_id,
			p.code AS code,
			CASE WHEN (pd_en.name is NULL OR pd_en.name='') THEN '-' ELSE pd_en.name END AS en_name,
			CASE WHEN (pd_cn.name is NULL OR pd_cn.name='') THEN '-' ELSE pd_cn.name END AS cn_name,
			p.model,
			cs.order_action AS payment_status_id,
			payment_os.name AS payment_status,
			p.costprice AS costprice,
			csp.price AS price,
			csp.t_weight AS weight,
			csp.rowtotal,
			p.weight_class_id,
			csp.t_weight * wc.value as total_weight,
			csp.tax_code
		FROM " . DB_PREFIX . "clinicalsale_product csp
		LEFT JOIN " . DB_PREFIX . "clinical_sale cs
		ON csp.clinical_sale_id = cs.clinical_sale_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON csp.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON p.product_id = pd_en.product_id AND pd_en.language_id = 1
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON p.product_id = pd_cn.product_id AND pd_cn.language_id = 2
		LEFT JOIN " . DB_PREFIX . "weight_class wc
		ON p.weight_class_id = wc.weight_class_id
		LEFT JOIN " . DB_PREFIX . "order o
		ON cs.order_id = o.order_id
		LEFT JOIN " . DB_PREFIX . "order_status payment_os
		ON cs.order_action = payment_os.order_status_id
		AND payment_os.language_id = '" . (int)$language_id . "'
		WHERE 1
		#AND cs.order_id != '0'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_order_status_statement
		$filter_payment_method_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		$filter_model_statement
		ORDER BY cs.date_added ASC , invoice_prefix ASC
		$limit_statement
		";

		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/

		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getHerbalremediesDetailByStockTotal($data){
		$sort 	= isset($data['sort']) ? $data['sort'] : "date_added";
		$order 	= isset($data['order']) ? $data['order'] : "DESC";

		$filter_payment_method= isset($data['filter_payment_method']) ? explode(',', $data['filter_payment_method']) : array();

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(cs.sales_date) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(cs.sales_date) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		// $filter_date_statement = "";

		// if((!empty($data['filter_date_start'])) || (!empty($data['filter_date_end']))){
		// 	$filter_date_statement = "
		// 	AND
		// 	(
		// 		(
		// 			cs.order_id != '0'";
		// 			$filter_date_statement .= (!empty($data['filter_date_start'])) ?
		// 			"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		// 			"";
		// 			$filter_date_statement .= (!empty($data['filter_date_end'])) ?
		// 			"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		// 			"";

		// 		$filter_date_statement .= "
		// 		)
		// 		OR
		// 		(
		// 			cs.order_id = '0'";
		// 			$filter_date_statement .= (!empty($data['filter_date_start'])) ?
		// 			"AND DATE(cs.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		// 			"";
		// 			$filter_date_statement .= (!empty($data['filter_date_end'])) ?
		// 			"AND DATE(cs.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		// 			"";

		// 		$filter_date_statement .= "
		// 		)
		// 	)
		// 	";
		// }

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND cs.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND cs.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND cs.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		/*$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND cs.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";*/
		$filter_order_status_statement = (!empty($data['filter_order_status'])) ?
		"AND cs.clinicalsale_action IN (" . $this->db->escape($data['filter_order_status']) . ")" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND cs.order_action IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";


		// $filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		// "AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		// "";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";

		$filter_model_statement = (!empty($data['filter_model'])) ?
		"AND p.model LIKE '%" . $this->db->escape($data['filter_model']) . "%'" :
		"";

		$filter_payment_method_statement = "";

        foreach ($filter_payment_method as $filter_payment_methods) {
            $filter_payment_method_statement .= empty($filter_payment_method_statement) ? "o.payment_method LIKE '%" . $filter_payment_methods . "%'" : " OR o.payment_method LIKE '%" . $filter_payment_methods . "%'";
        }

        $filter_payment_method_statement = !empty($filter_payment_method_statement) ? "AND ($filter_payment_method_statement)" : "";

		$sql = "
		SELECT COUNT(*) AS total FROM(
		SELECT
			cs.invoice_prefix,
			cs.sales_date,
			csp.product_id,
			p.code,
			CASE WHEN (pd_en.name is NULL OR pd_en.name='') THEN '-' ELSE pd_en.name END AS en_name,
			CASE WHEN (pd_cn.name is NULL OR pd_cn.name='') THEN '-' ELSE pd_cn.name END AS cn_name,
			p.costprice,
			p.price,
			csp.t_weight AS weight,
			p.weight_class_id
		FROM " . DB_PREFIX . "clinicalsale_product csp
		INNER JOIN " . DB_PREFIX . "clinical_sale cs
		ON csp.clinical_sale_id = cs.clinical_sale_id
		INNER JOIN " . DB_PREFIX . "product p
		ON csp.product_id = p.product_id
		INNER JOIN " . DB_PREFIX . "product_description pd_en
		ON p.product_id = pd_en.product_id AND pd_en.language_id = 1
		INNER JOIN " . DB_PREFIX . "product_description pd_cn
		ON p.product_id = pd_cn.product_id AND pd_cn.language_id = 2
		INNER JOIN " . DB_PREFIX . "weight_class wc
		ON p.weight_class_id = wc.weight_class_id
		LEFT JOIN " . DB_PREFIX . "order o
		ON cs.order_id = o.order_id
		WHERE 1
		#AND cs.order_id != '0'
		$filter_store_id_statement
		$filter_order_status_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		$filter_model_statement
		)a
		";

		$query = $this->db->query($sql);
		return $query->row['total'];
	}

	public function getHerbalremediesDetailByStockTotalQuantity($data){

		$sort 	= isset($data['sort']) ? $data['sort'] : "date_added";
		$order 	= isset($data['order']) ? $data['order'] : "DESC";

		$filter_payment_method= isset($data['filter_payment_method']) ? explode(',', $data['filter_payment_method']) : array();

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(cs.sales_date) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(cs.sales_date) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		// $filter_date_statement = "";

		// if((!empty($data['filter_date_start'])) || (!empty($data['filter_date_end']))){
		// 	$filter_date_statement = "
		// 	AND
		// 	(
		// 		(
		// 			cs.order_id != '0'";
		// 			$filter_date_statement .= (!empty($data['filter_date_start'])) ?
		// 			"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		// 			"";
		// 			$filter_date_statement .= (!empty($data['filter_date_end'])) ?
		// 			"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		// 			"";

		// 		$filter_date_statement .= "
		// 		)
		// 		OR
		// 		(
		// 			cs.order_id = '0'";
		// 			$filter_date_statement .= (!empty($data['filter_date_start'])) ?
		// 			"AND DATE(cs.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		// 			"";
		// 			$filter_date_statement .= (!empty($data['filter_date_end'])) ?
		// 			"AND DATE(cs.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		// 			"";

		// 		$filter_date_statement .= "
		// 		)
		// 	)
		// 	";
		// }

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND cs.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND cs.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND cs.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		/*$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND cs.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";*/
		$filter_order_status_statement = (!empty($data['filter_order_status'])) ?
		"AND cs.clinicalsale_action IN (" . $this->db->escape($data['filter_order_status']) . ")" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND cs.order_action IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";


		// $filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		// "AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		// "";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";

		$filter_model_statement = (!empty($data['filter_model'])) ?
		"AND p.model LIKE '%" . $this->db->escape($data['filter_model']) . "%'" :
		"";

		$filter_payment_method_statement = "";

        foreach ($filter_payment_method as $filter_payment_methods) {
            $filter_payment_method_statement .= empty($filter_payment_method_statement) ? "o.payment_method LIKE '%" . $filter_payment_methods . "%'" : " OR o.payment_method LIKE '%" . $filter_payment_methods . "%'";
        }

        $filter_payment_method_statement = !empty($filter_payment_method_statement) ? "AND ($filter_payment_method_statement)" : "";


		$sql = "
		SELECT
			SUM(csp.t_weight * wc.value) as total_weight
		FROM " . DB_PREFIX . "clinicalsale_product csp
		LEFT JOIN " . DB_PREFIX . "clinical_sale cs
		ON csp.clinical_sale_id = cs.clinical_sale_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON csp.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON p.product_id = pd_en.product_id AND pd_en.language_id = 1
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON p.product_id = pd_cn.product_id AND pd_cn.language_id = 2
		LEFT JOIN " . DB_PREFIX . "weight_class wc
		ON p.weight_class_id = wc.weight_class_id
		LEFT JOIN " . DB_PREFIX . "order o
		ON cs.order_id = o.order_id
		WHERE 1
		#AND cs.order_id != '0'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_order_status_statement
		$filter_payment_method_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		$filter_model_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_weight'];
	}

	public function getHerbalremediesDetailByStockTotalCost($data){

		$sort 	= isset($data['sort']) ? $data['sort'] : "date_added";
		$order 	= isset($data['order']) ? $data['order'] : "DESC";

		$filter_payment_method= isset($data['filter_payment_method']) ? explode(',', $data['filter_payment_method']) : array();

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(cs.sales_date) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(cs.sales_date) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		// $filter_date_statement = "";

		// if((!empty($data['filter_date_start'])) || (!empty($data['filter_date_end']))){
		// 	$filter_date_statement = "
		// 	AND
		// 	(
		// 		(
		// 			cs.order_id != '0'";
		// 			$filter_date_statement .= (!empty($data['filter_date_start'])) ?
		// 			"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		// 			"";
		// 			$filter_date_statement .= (!empty($data['filter_date_end'])) ?
		// 			"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		// 			"";

		// 		$filter_date_statement .= "
		// 		)
		// 		OR
		// 		(
		// 			cs.order_id = '0'";
		// 			$filter_date_statement .= (!empty($data['filter_date_start'])) ?
		// 			"AND DATE(cs.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		// 			"";
		// 			$filter_date_statement .= (!empty($data['filter_date_end'])) ?
		// 			"AND DATE(cs.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		// 			"";

		// 		$filter_date_statement .= "
		// 		)
		// 	)
		// 	";
		// }

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND cs.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND cs.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND cs.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		/*$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND cs.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";*/
		$filter_order_status_statement = (!empty($data['filter_order_status'])) ?
		"AND cs.clinicalsale_action IN (" . $this->db->escape($data['filter_order_status']) . ")" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND cs.order_action IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";


		// $filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		// "AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		// "";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";

		$filter_model_statement = (!empty($data['filter_model'])) ?
		"AND p.model LIKE '%" . $this->db->escape($data['filter_model']) . "%'" :
		"";

		$filter_payment_method_statement = "";

        foreach ($filter_payment_method as $filter_payment_methods) {
            $filter_payment_method_statement .= empty($filter_payment_method_statement) ? "o.payment_method LIKE '%" . $filter_payment_methods . "%'" : " OR o.payment_method LIKE '%" . $filter_payment_methods . "%'";
        }

        $filter_payment_method_statement = !empty($filter_payment_method_statement) ? "AND ($filter_payment_method_statement)" : "";


		$sql = "
		SELECT
			SUM((csp.t_weight * wc.value) * p.costprice) as total_cost
		FROM " . DB_PREFIX . "clinicalsale_product csp
		LEFT JOIN " . DB_PREFIX . "clinical_sale cs
		ON csp.clinical_sale_id = cs.clinical_sale_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON csp.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON p.product_id = pd_en.product_id AND pd_en.language_id = 1
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON p.product_id = pd_cn.product_id AND pd_cn.language_id = 2
		LEFT JOIN " . DB_PREFIX . "weight_class wc
		ON p.weight_class_id = wc.weight_class_id
		LEFT JOIN " . DB_PREFIX . "order o
		ON cs.order_id = o.order_id
		WHERE 1
		#AND cs.order_id != '0'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_order_status_statement
		$filter_payment_method_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		$filter_model_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_cost'];
	}

	public function getHerbalremediesDetailByStockTotalSale($data){

		$sort 	= isset($data['sort']) ? $data['sort'] : "date_added";
		$order 	= isset($data['order']) ? $data['order'] : "DESC";

		$filter_payment_method= isset($data['filter_payment_method']) ? explode(',', $data['filter_payment_method']) : array();

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(cs.sales_date) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(cs.sales_date) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		// $filter_date_statement = "";

		// if((!empty($data['filter_date_start'])) || (!empty($data['filter_date_end']))){
		// 	$filter_date_statement = "
		// 	AND
		// 	(
		// 		(
		// 			cs.order_id != '0'";
		// 			$filter_date_statement .= (!empty($data['filter_date_start'])) ?
		// 			"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		// 			"";
		// 			$filter_date_statement .= (!empty($data['filter_date_end'])) ?
		// 			"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		// 			"";

		// 		$filter_date_statement .= "
		// 		)
		// 		OR
		// 		(
		// 			cs.order_id = '0'";
		// 			$filter_date_statement .= (!empty($data['filter_date_start'])) ?
		// 			"AND DATE(cs.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		// 			"";
		// 			$filter_date_statement .= (!empty($data['filter_date_end'])) ?
		// 			"AND DATE(cs.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		// 			"";

		// 		$filter_date_statement .= "
		// 		)
		// 	)
		// 	";
		// }

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND cs.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND cs.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND cs.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		/*$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND cs.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";*/
		$filter_order_status_statement = (!empty($data['filter_order_status'])) ?
		"AND cs.clinicalsale_action IN (" . $this->db->escape($data['filter_order_status']) . ")" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND cs.order_action IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";


		// $filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		// "AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		// "";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";

		$filter_model_statement = (!empty($data['filter_model'])) ?
		"AND p.model LIKE '%" . $this->db->escape($data['filter_model']) . "%'" :
		"";

		$filter_payment_method_statement = "";

        foreach ($filter_payment_method as $filter_payment_methods) {
            $filter_payment_method_statement .= empty($filter_payment_method_statement) ? "o.payment_method LIKE '%" . $filter_payment_methods . "%'" : " OR o.payment_method LIKE '%" . $filter_payment_methods . "%'";
        }

        $filter_payment_method_statement = !empty($filter_payment_method_statement) ? "AND ($filter_payment_method_statement)" : "";


		$sql = "
		SELECT
			SUM(csp.rowtotal) as total_sale
		FROM " . DB_PREFIX . "clinicalsale_product csp
		LEFT JOIN " . DB_PREFIX . "clinical_sale cs
		ON csp.clinical_sale_id = cs.clinical_sale_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON csp.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON p.product_id = pd_en.product_id AND pd_en.language_id = 1
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON p.product_id = pd_cn.product_id AND pd_cn.language_id = 2
		LEFT JOIN " . DB_PREFIX . "weight_class wc
		ON p.weight_class_id = wc.weight_class_id
		LEFT JOIN " . DB_PREFIX . "order o
		ON cs.order_id = o.order_id
		WHERE 1
		#AND cs.order_id != '0'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_order_status_statement
		$filter_payment_method_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		$filter_model_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_sale'];
	}

	//pos
	public function getPosSummaryByStock($data){
		$language_id = $this->config->get('config_language_id');

		$sort 	= isset($data['sort']) ? $data['sort'] : "op.product_id";
		$order 	= isset($data['order']) ? $data['order'] : "ASC";

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id in (" . (int)$data['filter_store_id'] . ")" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND cn_pd.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND en_pd.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";


		$limit_statement = "";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$sql = "
		SELECT
			op.product_id,
			p.code,
			CASE WHEN (en_pd.name is NULL OR en_pd.name='') THEN '-' ELSE en_pd.name END AS en_name,
			CASE WHEN (cn_pd.name is NULL OR cn_pd.name='') THEN '-' ELSE cn_pd.name END AS cn_name,
			o.order_status_id AS order_status_id,
			os.name AS order_status,
			SUM(op.quantity) AS quantity,
			p.price AS price,
			0 AS discount,
			op.net_amount AS net_amount,
			SUM(ROUND(op.total_net_amount, 2)) AS total_net_amount,
			SUM(ROUND(op.total_tax, 2)) AS total_tax,
			SUM(ROUND(op.total, 2)) AS total,
			op.tax_code
		FROM " . DB_PREFIX . "order_product op
		INNER JOIN " . DB_PREFIX . "order o
		ON op.order_id = o.order_id
		INNER JOIN " . DB_PREFIX . "order_status os
		ON o.order_status_id = os.order_status_id
		INNER JOIN " . DB_PREFIX . "product p
		ON op.product_id = p.product_id
		INNER JOIN " . DB_PREFIX . "product_description en_pd
		ON p.product_id = en_pd.product_id AND en_pd.language_id = 1
		INNER JOIN " . DB_PREFIX . "product_description cn_pd
		ON p.product_id = cn_pd.product_id AND cn_pd.language_id = 2
		WHERE 1
		AND os.language_id = '" . (int)$language_id . "'
		AND op.price > 0
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_payment_status_statement
		$filter_store_id_statement
		$filter_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		GROUP BY
		op.product_id,
		o.order_status_id,
		p.code,
		p.price
		ORDER BY $sort $order
		$limit_statement
		";


		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getPosSummaryByStockTotal($data){
		$sort 	= isset($data['sort']) ? $data['sort'] : "date_added";
		$order 	= isset($data['order']) ? $data['order'] : "DESC";

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id in (" . (int)$data['filter_store_id'] . ")" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND cn_pd.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND en_pd.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";

		$sql = "
		SELECT COUNT(*) AS total FROM(
			SELECT
				op.product_id,
				p.code,
				CASE WHEN (en_pd.name is NULL OR en_pd.name='') THEN '-' ELSE en_pd.name END AS en_name,
				CASE WHEN (cn_pd.name is NULL OR cn_pd.name='') THEN '-' ELSE cn_pd.name END AS cn_name,
				SUM(op.quantity) AS quantity,
				SUM(p.price) AS price,
				0 AS discount,
				SUM(ROUND(op.net_amount, 2)) AS net_amount,
				SUM(ROUND(op.total_net_amount, 2)) AS total_net_amount,
				SUM(ROUND(op.total_tax, 2)) AS total_tax,
				SUM(ROUND(op.total, 2)) AS total
			FROM " . DB_PREFIX . "order_product op
			INNER JOIN " . DB_PREFIX . "order o
			ON op.order_id = o.order_id
			INNER JOIN " . DB_PREFIX . "product p
			ON op.product_id = p.product_id
			INNER JOIN " . DB_PREFIX . "product_description en_pd
			ON p.product_id = en_pd.product_id AND en_pd.language_id = 1
			INNER JOIN " . DB_PREFIX . "product_description cn_pd
			ON p.product_id = cn_pd.product_id AND cn_pd.language_id = 2
			$filter_date_start_statement
			$filter_date_end_statement
			$filter_payment_status_statement
			$filter_store_id_statement
			$filter_code_statement
			$filter_name_cn_statement
			$filter_name_en_statement
			GROUP BY
			op.product_id,
			p.code,
			p.price
		)a
		";

		$query = $this->db->query($sql);
		return $query->row['total'];
	}

	public function getPosSummaryByStockTotalQuantity($data){

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id in (" . (int)$data['filter_store_id'] . ")" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND cn_pd.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND en_pd.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";

		$sql = "
		SELECT
			SUM(op.quantity) AS total_quantity
		FROM " . DB_PREFIX . "order_product op
		INNER JOIN " . DB_PREFIX . "order o
		ON op.order_id = o.order_id
		INNER JOIN " . DB_PREFIX . "product p
		ON op.product_id = p.product_id
		INNER JOIN " . DB_PREFIX . "product_description en_pd
		ON p.product_id = en_pd.product_id AND en_pd.language_id = 1
		INNER JOIN " . DB_PREFIX . "product_description cn_pd
		ON p.product_id = cn_pd.product_id AND cn_pd.language_id = 2
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_payment_status_statement
		$filter_store_id_statement
		$filter_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_quantity'];
	}

	public function getPosSummaryByStockTotalUnitPrice($data){

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id in (" . (int)$data['filter_store_id'] . ")" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND cn_pd.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND en_pd.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";

		$sql = "
		SELECT
			SUM(p.price) AS total_price
		FROM " . DB_PREFIX . "order_product op
		INNER JOIN " . DB_PREFIX . "order o
		ON op.order_id = o.order_id
		INNER JOIN " . DB_PREFIX . "product p
		ON op.product_id = p.product_id
		INNER JOIN " . DB_PREFIX . "product_description en_pd
		ON p.product_id = en_pd.product_id AND en_pd.language_id = 1
		INNER JOIN " . DB_PREFIX . "product_description cn_pd
		ON p.product_id = cn_pd.product_id AND cn_pd.language_id = 2
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_payment_status_statement
		$filter_store_id_statement
		$filter_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_price'];
	}

	public function getPosSummaryByStockTotalDiscount($data){
		return 0;
	}

	public function getPosSummaryByStockTotalNetPrice($data){

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id in (" . (int)$data['filter_store_id'] . ")" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND cn_pd.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND en_pd.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";

		$sql = "
		SELECT
			SUM(op.net_amount) AS total_net_price
		FROM " . DB_PREFIX . "order_product op
		INNER JOIN " . DB_PREFIX . "order o
		ON op.order_id = o.order_id
		INNER JOIN " . DB_PREFIX . "product p
		ON op.product_id = p.product_id
		INNER JOIN " . DB_PREFIX . "product_description en_pd
		ON p.product_id = en_pd.product_id AND en_pd.language_id = 1
		INNER JOIN " . DB_PREFIX . "product_description cn_pd
		ON p.product_id = cn_pd.product_id AND cn_pd.language_id = 2
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_payment_status_statement
		$filter_store_id_statement
		$filter_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_net_price'];
	}

	public function getPosSummaryByStockTotalNetAmount($data){

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id in (" . (int)$data['filter_store_id'] . ")" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND cn_pd.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND en_pd.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";

		$sql = "
		SELECT

			SUM(op.total_net_amount) AS total_net_amount
		FROM " . DB_PREFIX . "order_product op
		INNER JOIN " . DB_PREFIX . "order o
		ON op.order_id = o.order_id
		INNER JOIN " . DB_PREFIX . "product p
		ON op.product_id = p.product_id
		INNER JOIN " . DB_PREFIX . "product_description en_pd
		ON p.product_id = en_pd.product_id AND en_pd.language_id = 1
		INNER JOIN " . DB_PREFIX . "product_description cn_pd
		ON p.product_id = cn_pd.product_id AND cn_pd.language_id = 2
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_payment_status_statement
		$filter_store_id_statement
		$filter_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_net_amount'];
	}

	public function getPosSummaryByStockTotalTax($data){
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id in (" . (int)$data['filter_store_id'] . ")" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND cn_pd.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND en_pd.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";

		$sql = "
		SELECT
			SUM(ROUND(op.total_tax, 2)) AS total_tax
		FROM " . DB_PREFIX . "order_product op
		INNER JOIN " . DB_PREFIX . "order o
		ON op.order_id = o.order_id
		INNER JOIN " . DB_PREFIX . "product p
		ON op.product_id = p.product_id
		INNER JOIN " . DB_PREFIX . "product_description en_pd
		ON p.product_id = en_pd.product_id AND en_pd.language_id = 1
		INNER JOIN " . DB_PREFIX . "product_description cn_pd
		ON p.product_id = cn_pd.product_id AND cn_pd.language_id = 2
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_payment_status_statement
		$filter_store_id_statement
		$filter_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_tax'];
	}

	public function getPosSummaryByStockTotalSales($data){

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id in (" . (int)$data['filter_store_id'] . ")" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND cn_pd.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND en_pd.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";


		$limit_statement = "";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$sql = "
		SELECT
			SUM(ROUND(op.total, 2)) AS total_sales
		FROM " . DB_PREFIX . "order_product op
		INNER JOIN " . DB_PREFIX . "order o
		ON op.order_id = o.order_id
		INNER JOIN " . DB_PREFIX . "product p
		ON op.product_id = p.product_id
		INNER JOIN " . DB_PREFIX . "product_description en_pd
		ON p.product_id = en_pd.product_id AND en_pd.language_id = 1
		INNER JOIN " . DB_PREFIX . "product_description cn_pd
		ON p.product_id = cn_pd.product_id AND cn_pd.language_id = 2
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_payment_status_statement
		$filter_store_id_statement
		$filter_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_sales'];
	}

	public function getPosDetailByStock($data){
		$language_id = $this->config->get('config_language_id');

		$sort 	= isset($data['sort']) ? $data['sort'] : "date_added";
		$order 	= isset($data['order']) ? $data['order'] : "DESC";

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id in (" . (int)$data['filter_store_id'] . ")" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_statement = (!empty($data['filter_name'])) ?
		"AND pd.name LIKE '%" . $this->db->escape($data['filter_name']) . "%'" :
		"";

		$filter_price_en_statement = " AND op.price !=0 " ;

		$filter_customer_type_statement = "";

		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND o.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND o.customer_id != 0";
			}
		}

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
		"AND c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
		"AND CONCAT(o.firstname, ' ', o.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$filter_customer_group_statement = (!empty($data['filter_customer_group'])) ?
		"AND c.customer_group_id = '" . (int)$data['filter_customer_group'] . "'" :
		"";

		$limit_statement = "";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$sql = "
		SELECT
			o.order_id, 
			o.invoice_prefix AS invoice_prefix,
			o.date_added AS date_added,
			o.customer_id,
			CASE WHEN o.customer_id = 0 THEN 1
			ELSE 2 END AS customer_type,
			o.firstname,
			o.lastname,
			c.customer_card,
			c.customer_group_id,
			cgd.name AS customer_group, 
			op.product_id AS product_id,
			p.code AS code,
			CASE WHEN (pd.name is NULL OR pd.name='') THEN '-' ELSE pd.name END AS name,
			o.order_status_id AS order_status_id,
			os.name AS order_status,
			op.quantity AS quantity,
			p.price AS price,
			0 AS discount,
			op.net_amount AS net_amount,
			op.total_net_amount AS total_net_amount,
			op.total_tax AS total_tax,
			op.total AS total,
			op.tax_code
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "customer c
		ON o.customer_id = c.customer_id 
		LEFT JOIN " . DB_PREFIX . "customer_group cg
		ON cg.customer_group_id = c.customer_group_id 
		LEFT JOIN " . DB_PREFIX . "customer_group_description cgd
		ON cgd.customer_group_id = cg.customer_group_id 
		AND cgd.language_id = '" . (int)$this->config->get('config_language_id') . "' 
		INNER JOIN " . DB_PREFIX . "order_product op
		ON op.order_id = o.order_id
		INNER JOIN " . DB_PREFIX . "order_status os
		ON o.order_status_id = os.order_status_id
		INNER JOIN " . DB_PREFIX . "product p
		ON op.product_id = p.product_id
		INNER JOIN " . DB_PREFIX . "product_description pd
		ON p.product_id = pd.product_id AND pd.language_id = '" . (int)$language_id . "'  
		WHERE 1
		AND os.language_id = '" . (int)$language_id . "'
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_payment_status_statement
		$filter_store_id_statement
		$filter_customer_type_statement
		$filter_customer_name_statement
		$filter_customer_card_statement
		$filter_customer_group_statement
		$filter_code_statement
		$filter_name_statement
		$filter_price_en_statement
		ORDER BY $sort $order
		$limit_statement
		";

		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/

		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getPosDetailByStockTotal($data){
		$language_id = $this->config->get('config_language_id');

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id in (" . (int)$data['filter_store_id'] . ")" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_statement = (!empty($data['filter_name'])) ?
		"AND pd.name LIKE '%" . $this->db->escape($data['filter_name']) . "%'" :
		"";

		$filter_price_en_statement = " AND op.price !=0 " ;

		$filter_customer_type_statement = "";

		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND o.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND o.customer_id != 0";
			}
		}

		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ?
		"AND c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ?
		"AND CONCAT(o.firstname, ' ', o.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$filter_customer_group_statement = (!empty($data['filter_customer_group'])) ?
		"AND c.customer_group_id = '" . (int)$data['filter_customer_group'] . "'" :
		"";

		$sql = "
		SELECT COUNT(*) AS total FROM(
			SELECT 
			o.invoice_prefix AS invoice_prefix,
			o.date_added AS date_added,
			o.customer_id,
			CASE WHEN o.customer_id = 0 THEN 1
			ELSE 2 END AS customer_type,
			CONCAT(o.firstname, ' ', o.lastname) AS customer_name,
			c.customer_card,
			c.customer_group_id,
			cgd.name AS customer_group, 
			op.product_id AS product_id,
			p.code AS code,
			CASE WHEN (pd.name is NULL OR pd.name='') THEN '-' ELSE pd.name END AS name,
			o.order_status_id AS order_status_id,
			os.name AS order_status,
			op.quantity AS quantity,
			p.price AS price,
			0 AS discount,
			op.net_amount AS net_amount,
			op.total_net_amount AS total_net_amount,
			op.total_tax AS total_tax,
			op.total AS total,
			op.tax_code
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "customer c
		ON o.customer_id = c.customer_id 
		LEFT JOIN " . DB_PREFIX . "customer_group cg
		ON cg.customer_group_id = c.customer_group_id 
		LEFT JOIN " . DB_PREFIX . "customer_group_description cgd
		ON cgd.customer_group_id = cg.customer_group_id 
		AND cgd.language_id = '" . (int)$this->config->get('config_language_id') . "' 
		INNER JOIN " . DB_PREFIX . "order_product op
		ON op.order_id = o.order_id
		INNER JOIN " . DB_PREFIX . "order_status os
		ON o.order_status_id = os.order_status_id
		INNER JOIN " . DB_PREFIX . "product p
		ON op.product_id = p.product_id
		INNER JOIN " . DB_PREFIX . "product_description pd
		ON p.product_id = pd.product_id AND pd.language_id = '" . (int)$language_id . "'  
		WHERE 1
		AND os.language_id = '" . (int)$language_id . "'
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_payment_status_statement
		$filter_store_id_statement
		$filter_customer_type_statement
		$filter_customer_name_statement
		$filter_customer_card_statement
		$filter_customer_group_statement
		$filter_code_statement
		$filter_name_statement
		$filter_price_en_statement
		)a";

		$query = $this->db->query($sql);
		return $query->row['total'];
	}

	public function getPosDetailByStockTotalQuantity($data){

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id in (" . (int)$data['filter_store_id'] . ")" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND cn_pd.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND en_pd.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";




		$sql = "
		SELECT
			SUM(op.quantity) AS total_quantity
		FROM " . DB_PREFIX . "order o
		INNER JOIN " . DB_PREFIX . "order_product op
		ON op.order_id = o.order_id
		INNER JOIN " . DB_PREFIX . "product p
		ON op.product_id = p.product_id
		INNER JOIN " . DB_PREFIX . "product_description en_pd
		ON p.product_id = en_pd.product_id AND en_pd.language_id = 1
		INNER JOIN " . DB_PREFIX . "product_description cn_pd
		ON p.product_id = cn_pd.product_id AND cn_pd.language_id = 2
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_payment_status_statement
		$filter_store_id_statement
		$filter_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_quantity'];
	}

	public function getPosDetailByStockTotalUnitPrice($data){

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id in (" . (int)$data['filter_store_id'] . ")" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND cn_pd.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND en_pd.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";


		$sql = "
		SELECT
			SUM(ROUND(p.price, 2)) AS total_price
		FROM " . DB_PREFIX . "order o
		INNER JOIN " . DB_PREFIX . "order_product op
		ON op.order_id = o.order_id
		INNER JOIN " . DB_PREFIX . "product p
		ON op.product_id = p.product_id
		INNER JOIN " . DB_PREFIX . "product_description en_pd
		ON p.product_id = en_pd.product_id AND en_pd.language_id = 1
		INNER JOIN " . DB_PREFIX . "product_description cn_pd
		ON p.product_id = cn_pd.product_id AND cn_pd.language_id = 2
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_payment_status_statement
		$filter_store_id_statement
		$filter_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_price'];
	}

	public function getPosDetailByStockTotalDiscount($data){return 0;}

	public function getPosDetailByStockTotalNetPrice($data){

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id in (" . (int)$data['filter_store_id'] . ")" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND cn_pd.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND en_pd.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";


		$sql = "
		SELECT
			SUM(ROUND(op.net_amount, 2)) AS total_net_amount
		FROM " . DB_PREFIX . "order o
		INNER JOIN " . DB_PREFIX . "order_product op
		ON op.order_id = o.order_id
		INNER JOIN " . DB_PREFIX . "product p
		ON op.product_id = p.product_id
		INNER JOIN " . DB_PREFIX . "product_description en_pd
		ON p.product_id = en_pd.product_id AND en_pd.language_id = 1
		INNER JOIN " . DB_PREFIX . "product_description cn_pd
		ON p.product_id = cn_pd.product_id AND cn_pd.language_id = 2
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_payment_status_statement
		$filter_store_id_statement
		$filter_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_net_amount'];
	}

	public function getPosDetailByStockTotalNetAmount($data){

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id in (" . (int)$data['filter_store_id'] . ")" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND cn_pd.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND en_pd.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";

		$sql = "
		SELECT
			SUM(ROUND(op.total_net_amount, 2)) AS total_net_amount
		FROM " . DB_PREFIX . "order o
		INNER JOIN " . DB_PREFIX . "order_product op
		ON op.order_id = o.order_id
		INNER JOIN " . DB_PREFIX . "product p
		ON op.product_id = p.product_id
		INNER JOIN " . DB_PREFIX . "product_description en_pd
		ON p.product_id = en_pd.product_id AND en_pd.language_id = 1
		INNER JOIN " . DB_PREFIX . "product_description cn_pd
		ON p.product_id = cn_pd.product_id AND cn_pd.language_id = 2
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_payment_status_statement
		$filter_store_id_statement
		$filter_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_net_amount'];
	}

	public function getPosDetailByStockTotalTax($data){

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id in (" . (int)$data['filter_store_id'] . ")" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND cn_pd.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND en_pd.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";

		$sql = "
		SELECT
			SUM(ROUND(op.total_tax, 2)) AS total_tax
		FROM " . DB_PREFIX . "order o
		INNER JOIN " . DB_PREFIX . "order_product op
		ON op.order_id = o.order_id
		INNER JOIN " . DB_PREFIX . "product p
		ON op.product_id = p.product_id
		INNER JOIN " . DB_PREFIX . "product_description en_pd
		ON p.product_id = en_pd.product_id AND en_pd.language_id = 1
		INNER JOIN " . DB_PREFIX . "product_description cn_pd
		ON p.product_id = cn_pd.product_id AND cn_pd.language_id = 2
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_payment_status_statement
		$filter_store_id_statement
		$filter_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_tax'];
	}
	
	public function getPosDetailByStockTotalSales($data){
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
		"";

		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id in (" . (int)$data['filter_store_id'] . ")" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND cn_pd.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND en_pd.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";

		$sql = "
		SELECT
			SUM(ROUND(op.total, 2)) AS total_sales
		FROM " . DB_PREFIX . "order o
		INNER JOIN " . DB_PREFIX . "order_product op
		ON op.order_id = o.order_id
		INNER JOIN " . DB_PREFIX . "product p
		ON op.product_id = p.product_id
		INNER JOIN " . DB_PREFIX . "product_description en_pd
		ON p.product_id = en_pd.product_id AND en_pd.language_id = 1
		INNER JOIN " . DB_PREFIX . "product_description cn_pd
		ON p.product_id = cn_pd.product_id AND cn_pd.language_id = 2
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_payment_status_statement
		$filter_store_id_statement
		$filter_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_sales'];
	}

	public function getSalesTotalServiceForm($order_id){
		$sql = "
		SELECT ROUND(SUM(st.value), 2) as total
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON o.order_id = sf.order_id
		LEFT JOIN " . DB_PREFIX . "service_total st
		ON sf.service_form_id = st.service_form_id
		WHERE o.order_id = '" . (int)$order_id . "'
		AND st.code = 'sub_total'
		GROUP BY o.order_id";

		$query = $this->db->query($sql);
		return $query->row;
	}

	public function getSalesTotalDoctor($order_id){
		$sql = "
		SELECT ROUND(SUM(cst.value), 2) AS total_large,
			   ROUND(SUM(cst2.value), 2) AS total_small
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "clinical_sale cs
		ON o.order_id = cs.order_id
		LEFT JOIN " . DB_PREFIX . "clinical_sale_total cst
		ON cs.clinical_sale_id = cst.clinical_sale_id
		LEFT JOIN " . DB_PREFIX . "clinical_sale_total cst2
		ON cs.clinical_sale_id = cst2.clinical_sale_id
		WHERE o.order_id = '" . (int)$order_id . "'
		AND cst.id = 2
		AND cst.code = 'sub_total'
		AND cst2.id = 1
		AND cst2.code = 'sub_total'
		AND cs.collect_consultation_price = '1'
		GROUP BY o.order_id ";

		$query = $this->db->query($sql);

		return $query->row;
	}

	public function getSalesTotalHerbal($order_id){
		$return_arr = [];

		$sql = "
		SELECT ROUND(SUM(cst.value), 2) as total
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "clinical_sale cs
		ON o.order_id = cs.order_id
		LEFT JOIN " . DB_PREFIX . "clinical_sale_total cst
		ON cs.clinical_sale_id = cst.clinical_sale_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON c.customer_id = o.customer_id
		WHERE o.order_id = '" . (int)$order_id . "'
		AND cst.id = 1
		AND cst.code = 'sub_total'
		AND cs.collect_consultation_price = '1'
		GROUP BY o.order_id";

		$sql2 = "
		SELECT ROUND(SUM(cst.value), 2) as total
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "clinical_sale cs
		ON o.order_id = cs.order_id
		LEFT JOIN " . DB_PREFIX . "clinical_sale_total cst
		ON cs.clinical_sale_id = cst.clinical_sale_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON c.customer_id = o.customer_id
		WHERE o.order_id = '" . (int)$order_id . "'
		AND cst.id = 2
		AND cst.code = 'sub_total'
		AND cs.collect_consultation_price = '0'
		GROUP BY o.order_id";

		$query = $this->db->query($sql);
		$query2 = $this->db->query($sql2);

		$query_row = !empty($query->row) ? $query->row : [];
		$query2_row = !empty($query2->row) ? $query2->row : [];

		$return_arr = [
			'row_1'		=> $query_row,
			'row_2'		=> $query2_row
		];

		return $return_arr;
	}

	public function getSalesTotalPOS($order_id){
		$sql = "
		SELECT ROUND(SUM(op.total_net_amount), 2) AS total_pos
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "order_product op
		ON o.order_id = op.order_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON c.customer_id = o.customer_id
		WHERE o.order_id = '" . (int)$order_id . "'
		AND o.payment_method != 'points'
		GROUP BY o.order_id";

		$query = $this->db->query($sql);

		return $query->row;
	}

	public function get_senangpay_transaction($order_id) {
		$sql = "SELECT * FROM " . DB_PREFIX . "senangpay_transaction WHERE order_id = '" . (int)$order_id . "'";

		$query = $this->db->query($sql);

		return $query->row;
	}

	public function getcategory(){
		$language_id = $this->config->get('config_language_id');

		$sql = " SELECT cd.category_id as category_id , cd.name AS category_name  FROM " . DB_PREFIX . "category_description cd  WHERE cd.language_id = '" . (int)$language_id . "' ";
		$query = $this->db->query($sql);

		return $query->rows;

	}
}
