<?php
class ModelReportPurchase extends Model{
	public function getPurchaseOutstandingSummaryByStock($data = array()){
		$sort 	= isset($data['sort']) ? $data['sort'] : "manufacturer_code";
		$order 	= isset($data['order']) ? $data['order'] : "ASC";
		
		$sort_fixer = '';
		
		switch($sort){
			case 'manufacturer_code':
				$sort_fixer = ', product_code ASC';
				break;
			case 'supplier':
				$sort_fixer = ', product_code ASC';
				break;
		}
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_receive_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pr.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_receive_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pr.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_supplier_statement = (!empty($data['filter_supplier'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_supplier']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT
			manufacturer_id,
			manufacturer_code,
			supplier,
			product_id,
			product_code,
			english_name,
			chinese_name,
			SUM(order_qty) AS order_qty,
			SUM(receive_qty) AS receive_qty,
			SUM(extra_qty) AS extra_qty,
			SUM(outstanding) AS outstanding,
			SUM(amount) AS amount,
			currency_code,
			currency_value
		FROM(
		SELECT
			po.manufacturer_id,
			m.code AS manufacturer_code,
			m.name AS supplier,
			pop.product_id,
			p.code AS product_code,
			pd_en.name AS english_name,
			pd_cn.name AS chinese_name,
			pop.quantity AS order_qty,
			(
				SELECT
					CASE WHEN COALESCE(SUM(prp.quantity), 0) <= pop.quantity
					THEN COALESCE(SUM(prp.quantity), 0) ELSE pop.quantity END
				FROM " . DB_PREFIX . "purchase_receive_product prp
				LEFT JOIN " . DB_PREFIX . "purchase_receive pr
				ON prp.purchase_receive_id = pr.purchase_receive_id
				WHERE 1
				AND prp.purchase_order_id = po.purchase_order_id
				AND prp.product_id = pop.product_id
				AND pr.order_status_id = '5'
				$filter_receive_date_start_statement
				$filter_receive_date_end_statement
			) AS receive_qty,
			(
				SELECT
					CASE WHEN COALESCE(SUM(prp.quantity), 0) > pop.quantity
					THEN COALESCE(SUM(prp.quantity), 0) - pop.quantity ELSE 0 END
				FROM " . DB_PREFIX . "purchase_receive_product prp
				LEFT JOIN " . DB_PREFIX . "purchase_receive pr
				ON prp.purchase_receive_id = pr.purchase_receive_id
				WHERE 1
				AND prp.purchase_order_id = po.purchase_order_id
				AND prp.product_id = pop.product_id
				AND pr.order_status_id = '5'
				$filter_receive_date_start_statement
				$filter_receive_date_end_statement
			) AS extra_qty,
			(
				pop.quantity - 
				(
					SELECT
						CASE WHEN COALESCE(SUM(prp.quantity), 0) <= pop.quantity
						THEN COALESCE(SUM(prp.quantity), 0) ELSE pop.quantity END
					FROM " . DB_PREFIX . "purchase_receive_product prp
					LEFT JOIN " . DB_PREFIX . "purchase_receive pr
					ON prp.purchase_receive_id = pr.purchase_receive_id
					WHERE 1
					AND prp.purchase_order_id = po.purchase_order_id
					AND prp.product_id = pop.product_id
					AND pr.order_status_id = '5'
					$filter_receive_date_start_statement
					$filter_receive_date_end_statement
				)
			) AS outstanding,
			pop.price AS unit_price,
			(
				(
					pop.quantity - 
					(
						SELECT
							CASE WHEN COALESCE(SUM(prp.quantity), 0) <= pop.quantity
							THEN COALESCE(SUM(prp.quantity), 0) ELSE pop.quantity END
						FROM " . DB_PREFIX . "purchase_receive_product prp
						LEFT JOIN " . DB_PREFIX . "purchase_receive pr
						ON prp.purchase_receive_id = pr.purchase_receive_id
						WHERE 1
						AND prp.purchase_order_id = po.purchase_order_id
						AND prp.product_id = pop.product_id
						AND pr.order_status_id = '5'
						$filter_receive_date_start_statement
						$filter_receive_date_end_statement
					)
				) * pop.price
			) AS amount,
			po.currency_code,
			po.currency_value
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_supplier_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		
		UNION ALL
		
		SELECT
			po.manufacturer_id,
			m.code AS manufacturer_code,
			m.name AS supplier,
			prp.product_id,
			p.code AS product_code,
			pd_en.name AS english_name,
			pd_cn.name AS chinese_name,
			0 AS order_qty,
			0 AS receive_qty,
			prp.quantity AS extra_qty,
			0 AS outstanding,
			0 AS unit_price,
			0 AS outstanding_amount,
			po.currency_code,
			po.currency_value
		FROM " . DB_PREFIX . "purchase_receive_product prp
		LEFT JOIN " . DB_PREFIX . "purchase_receive pr
		ON prp.purchase_receive_id = pr.purchase_receive_id
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pr.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON prp.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON prp.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON prp.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		WHERE 1
		AND prp.purchase_order_id = 0
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_supplier_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		)a
		GROUP BY manufacturer_id, product_id
		ORDER BY $sort $order $sort_fixer
		$limit_statement
		";
		
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/
		
		$query = $this->db->query($sql);
		return $query->rows;
	}
	public function getTotalPurchaseOutstandingSummaryByStock($data = array()){
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_supplier_statement = (!empty($data['filter_supplier_statement'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_supplier']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$sql = "
		SELECT COUNT(*) AS total_result FROM(
		SELECT 
			po.manufacturer_id, pop.product_id
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		WHERE 1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_supplier_statement
		$filter_manufacturer_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		GROUP BY po.manufacturer_id, pop.product_id
		)a
		";
		$query = $this->db->query($sql);
		return $query->row['total_result'];
	}
	public function getPurchaseOutstandingSummaryByStockTotalOrderQuantity($data = array()){
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_supplier_statement = (!empty($data['filter_supplier'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_supplier']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$sql = "
		SELECT
			SUM(pop.quantity) AS total_order_qty
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_supplier_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		";
		
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/
		
		$query = $this->db->query($sql);
		return $query->row['total_order_qty'];
	}
	public function getPurchaseOutstandingSummaryByStockTotalReceiveQuantity($data = array()){
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_receive_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pr.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_receive_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pr.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_supplier_statement = (!empty($data['filter_supplier'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_supplier']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$sql = "
		SELECT
			SUM(
				(
					SELECT
						CASE WHEN COALESCE(SUM(prp.quantity), 0) <= pop.quantity
						THEN COALESCE(SUM(prp.quantity), 0) ELSE pop.quantity END
					FROM " . DB_PREFIX . "purchase_receive_product prp
					LEFT JOIN " . DB_PREFIX . "purchase_receive pr
					ON prp.purchase_receive_id = pr.purchase_receive_id
					WHERE 1
					AND prp.purchase_order_id = po.purchase_order_id
					AND prp.product_id = pop.product_id
					AND pr.order_status_id = '5'
					$filter_receive_date_start_statement
					$filter_receive_date_end_statement
				)
			) AS total_receive_qty
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_supplier_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		";
		
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/
		
		$query = $this->db->query($sql);
		return $query->row['total_receive_qty'];
	}
	public function getPurchaseOutstandingSummaryByStockTotalExtraQuantity($data = array()){
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_receive_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pr.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_receive_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pr.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_supplier_statement = (!empty($data['filter_supplier'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_supplier']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		
		$sql = "
		SELECT
			SUM(extra_qty) AS total_extra_qty
		FROM(
		SELECT
			(
				SELECT
					CASE WHEN COALESCE(SUM(prp.quantity), 0) > pop.quantity
					THEN COALESCE(SUM(prp.quantity), 0) - pop.quantity ELSE 0 END
				FROM " . DB_PREFIX . "purchase_receive_product prp
				LEFT JOIN " . DB_PREFIX . "purchase_receive pr
				ON prp.purchase_receive_id = pr.purchase_receive_id
				WHERE 1
				AND prp.purchase_order_id = po.purchase_order_id
				AND prp.product_id = pop.product_id
				AND pr.order_status_id = '5'
				$filter_receive_date_start_statement
				$filter_receive_date_end_statement
			) AS extra_qty
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_supplier_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		
		UNION ALL
		
		SELECT
			prp.quantity AS extra_qty
		FROM " . DB_PREFIX . "purchase_receive_product prp
		LEFT JOIN " . DB_PREFIX . "purchase_receive pr
		ON prp.purchase_receive_id = pr.purchase_receive_id
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pr.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON prp.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON prp.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON prp.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		WHERE 1
		AND prp.purchase_order_id = 0
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_supplier_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		)a
		";
		
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/
		
		$query = $this->db->query($sql);
		return $query->row['total_extra_qty'];
	}
	public function getPurchaseOutstandingSummaryByStockTotalOutstanding($data = array()){
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_receive_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pr.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_receive_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pr.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_supplier_statement = (!empty($data['filter_supplier'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_supplier']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$sql = "
		SELECT
			SUM(
				pop.quantity - 
				(
					SELECT
						CASE WHEN COALESCE(SUM(prp.quantity), 0) <= pop.quantity
						THEN COALESCE(SUM(prp.quantity), 0) ELSE pop.quantity END
					FROM " . DB_PREFIX . "purchase_receive_product prp
					LEFT JOIN " . DB_PREFIX . "purchase_receive pr
					ON prp.purchase_receive_id = pr.purchase_receive_id
					WHERE 1
					AND prp.purchase_order_id = po.purchase_order_id
					AND prp.product_id = pop.product_id
					AND pr.order_status_id = '5'
					$filter_receive_date_start_statement
					$filter_receive_date_end_statement
				)
			) AS total_outstanding,
			pop.price AS unit_price,
			(
				(
					pop.quantity - 
					(
						SELECT
							CASE WHEN COALESCE(SUM(prp.quantity), 0) <= pop.quantity
							THEN COALESCE(SUM(prp.quantity), 0) ELSE pop.quantity END
						FROM " . DB_PREFIX . "purchase_receive_product prp
						LEFT JOIN " . DB_PREFIX . "purchase_receive pr
						ON prp.purchase_receive_id = pr.purchase_receive_id
						WHERE 1
						AND prp.purchase_order_id = po.purchase_order_id
						AND prp.product_id = pop.product_id
						AND pr.order_status_id = '5'
						$filter_receive_date_start_statement
						$filter_receive_date_end_statement
					)
				) * pop.price
			) AS amount,
			po.currency_code,
			po.currency_value
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_supplier_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		";
		
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/
		
		$query = $this->db->query($sql);
		return $query->row['total_outstanding'];
	}
	public function getTotalPurchaseOutstandingSummaryByStockTotalAmount($data = array()){
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_receive_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pr.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_receive_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pr.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_supplier_statement = (!empty($data['filter_supplier_statement'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_supplier']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$sql = "
		SELECT
			SUM(
				(
					pop.quantity - 
					(
						SELECT 
							CASE WHEN COALESCE(SUM(prp.quantity), 0) <= pop.quantity
							THEN COALESCE(SUM(prp.quantity), 0) ELSE pop.quantity END
						FROM " . DB_PREFIX . "purchase_receive_product prp
						LEFT JOIN " . DB_PREFIX . "purchase_receive pr
						ON prp.purchase_receive_id = pr.purchase_receive_id
						WHERE 1
						AND pr.order_status_id = '5'
						AND prp.purchase_order_id = po.purchase_order_id
						AND prp.product_id = pop.product_id
						$filter_receive_date_start_statement
						$filter_receive_date_end_statement
					)
				) * pop.price
			) AS total_amount
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		WHERE 1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_supplier_statement
		$filter_manufacturer_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		";
		$query = $this->db->query($sql);
		return $query->row['total_amount'];
	}
	public function getPurchaseOutstandingSummaryByStockInfo($data = array()){
		
		$sort 	= isset($data['sort']) ? $data['sort'] : "manufacturer_code";
		$order 	= isset($data['order']) ? $data['order'] : "ASC";
		
		$filter_product_id_statement = (!empty($data['filter_product_id'])) ? 
		"AND pop.product_id = '" . (int)$data['filter_product_id'] . "'" : 
		"";
		
		$filter_reveice_product_id_statement = (!empty($data['filter_product_id'])) ? 
		"AND prp.product_id = '" . (int)$data['filter_product_id'] . "'" : 
		"";
		
		$filter_manufacturer_id_statement = (!empty($data['filter_manufacturer_id'])) ? 
		"AND po.manufacturer_id = '" . (int)$data['filter_manufacturer_id'] . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_receive_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pr.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_receive_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pr.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_manufacturer_name_statement = (!empty($data['filter_manufacturer_name'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_manufacturer_name']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT * FROM(
		SELECT
			po.date_added,
			po.invoice_prefix,
			m.code AS manufacturer_code,
			m.name AS manufacturer_name,
			p.code AS product_code,
			pd_en.name AS english_name,
			pd_cn.name AS chinese_name,
			pop.quantity AS order_qty,
			(
				SELECT
					CASE WHEN COALESCE(SUM(prp.quantity), 0) <= pop.quantity
					THEN COALESCE(SUM(prp.quantity), 0) ELSE pop.quantity END
				FROM " . DB_PREFIX . "purchase_receive_product prp
				LEFT JOIN " . DB_PREFIX . "purchase_receive pr
				ON prp.purchase_receive_id = pr.purchase_receive_id
				WHERE 1
				AND prp.purchase_order_id = po.purchase_order_id
				AND prp.product_id = pop.product_id
				AND pr.order_status_id = '5'
				$filter_receive_date_start_statement
				$filter_receive_date_end_statement
			) AS receive_qty,
			(
				SELECT
					CASE WHEN COALESCE(SUM(prp.quantity), 0) > pop.quantity
					THEN COALESCE(SUM(prp.quantity), 0) - pop.quantity ELSE 0 END
				FROM " . DB_PREFIX . "purchase_receive_product prp
				LEFT JOIN " . DB_PREFIX . "purchase_receive pr
				ON prp.purchase_receive_id = pr.purchase_receive_id
				WHERE 1
				AND prp.purchase_order_id = po.purchase_order_id
				AND prp.product_id = pop.product_id
				AND pr.order_status_id = '5'
				$filter_receive_date_start_statement
				$filter_receive_date_end_statement
			) AS extra_qty,
			(
				pop.quantity - 
				(
					SELECT
						CASE WHEN COALESCE(SUM(prp.quantity), 0) <= pop.quantity
						THEN COALESCE(SUM(prp.quantity), 0) ELSE pop.quantity END
					FROM " . DB_PREFIX . "purchase_receive_product prp
					LEFT JOIN " . DB_PREFIX . "purchase_receive pr
					ON prp.purchase_receive_id = pr.purchase_receive_id
					WHERE 1
					AND prp.purchase_order_id = po.purchase_order_id
					AND prp.product_id = pop.product_id
					AND pr.order_status_id = '5'
					$filter_receive_date_start_statement
					$filter_receive_date_end_statement
				)
			) AS outstanding,
			pop.price AS unit_price,
			(
				(
					pop.quantity - 
					(
						SELECT
							CASE WHEN COALESCE(SUM(prp.quantity), 0) <= pop.quantity
							THEN COALESCE(SUM(prp.quantity), 0) ELSE pop.quantity END
						FROM " . DB_PREFIX . "purchase_receive_product prp
						LEFT JOIN " . DB_PREFIX . "purchase_receive pr
						ON prp.purchase_receive_id = pr.purchase_receive_id
						WHERE 1
						AND prp.purchase_order_id = po.purchase_order_id
						AND prp.product_id = pop.product_id
						AND pr.order_status_id = '5'
						$filter_receive_date_start_statement
						$filter_receive_date_end_statement
					)
				) * pop.price
			) AS outstanding_amount,
			po.currency_code,
			po.currency_value
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		$filter_manufacturer_id_statement
		$filter_product_id_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_manufacturer_name_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		
		UNION ALL
		
		SELECT
			po.date_added,
			po.invoice_prefix,
			m.code AS manufacturer_code,
			m.name AS manufacturer_name,
			p.code AS product_code,
			pd_en.name AS en_name,
			pd_cn.name AS cn_name,
			0 AS order_qty,
			0 AS receive_qty,
			prp.quantity AS extra_qty,
			0 AS outstanding,
			0 AS unit_price,
			0 AS outstanding_amount,
			po.currency_code,
			po.currency_value
		FROM " . DB_PREFIX . "purchase_receive_product prp
		LEFT JOIN " . DB_PREFIX . "purchase_receive pr
		ON prp.purchase_receive_id = pr.purchase_receive_id
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pr.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON prp.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON prp.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON prp.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		WHERE 1
		AND prp.purchase_order_id = 0
		$filter_manufacturer_id_statement
		$filter_reveice_product_id_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_manufacturer_name_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		)a
		ORDER BY $sort $order
		$limit_statement
		";
		
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/
		
		$query = $this->db->query($sql);
		return $query->rows;
	
	}
	public function getPurchaseOutstandingSummaryByStockInfoTotalOrderQuantity($data = array()){
		
		$filter_product_id_statement = (!empty($data['filter_product_id'])) ? 
		"AND pop.product_id = '" . (int)$data['filter_product_id'] . "'" : 
		"";
		
		$filter_reveice_product_id_statement = (!empty($data['filter_product_id'])) ? 
		"AND prp.product_id = '" . (int)$data['filter_product_id'] . "'" : 
		"";
		
		$filter_manufacturer_id_statement = (!empty($data['filter_manufacturer_id'])) ? 
		"AND po.manufacturer_id = '" . (int)$data['filter_manufacturer_id'] . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_receive_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pr.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_receive_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pr.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_manufacturer_name_statement = (!empty($data['filter_manufacturer_name'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_manufacturer_name']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$sql = "
		SELECT
			SUM(pop.quantity) AS total_order_qty
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		$filter_manufacturer_id_statement
		$filter_product_id_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_manufacturer_name_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		";
		
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/
		
		$query = $this->db->query($sql);
		return $query->row['total_order_qty'];
	
	}
	public function getPurchaseOutstandingSummaryByStockInfoTotalReceiveQuantity($data = array()){
		
		$filter_product_id_statement = (!empty($data['filter_product_id'])) ? 
		"AND pop.product_id = '" . (int)$data['filter_product_id'] . "'" : 
		"";
		
		$filter_reveice_product_id_statement = (!empty($data['filter_product_id'])) ? 
		"AND prp.product_id = '" . (int)$data['filter_product_id'] . "'" : 
		"";
		
		$filter_manufacturer_id_statement = (!empty($data['filter_manufacturer_id'])) ? 
		"AND po.manufacturer_id = '" . (int)$data['filter_manufacturer_id'] . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_receive_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pr.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_receive_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pr.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_manufacturer_name_statement = (!empty($data['filter_manufacturer_name'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_manufacturer_name']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$sql = "
		SELECT
			SUM(
				(
					SELECT
						CASE WHEN COALESCE(SUM(prp.quantity), 0) <= pop.quantity
						THEN COALESCE(SUM(prp.quantity), 0) ELSE pop.quantity END
					FROM " . DB_PREFIX . "purchase_receive_product prp
					LEFT JOIN " . DB_PREFIX . "purchase_receive pr
					ON prp.purchase_receive_id = pr.purchase_receive_id
					WHERE 1
					AND prp.purchase_order_id = po.purchase_order_id
					AND prp.product_id = pop.product_id
					AND pr.order_status_id = '5'
					$filter_receive_date_start_statement
					$filter_receive_date_end_statement
				)
			) AS total_receive_qty
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		$filter_manufacturer_id_statement
		$filter_product_id_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_manufacturer_name_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		";
		
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/
		
		$query = $this->db->query($sql);
		return $query->row['total_receive_qty'];
	
	}
	public function getPurchaseOutstandingSummaryByStockInfoTotalExtraQuantity($data = array()){
		
		$filter_product_id_statement = (!empty($data['filter_product_id'])) ? 
		"AND pop.product_id = '" . (int)$data['filter_product_id'] . "'" : 
		"";
		
		$filter_reveice_product_id_statement = (!empty($data['filter_product_id'])) ? 
		"AND prp.product_id = '" . (int)$data['filter_product_id'] . "'" : 
		"";
		
		$filter_manufacturer_id_statement = (!empty($data['filter_manufacturer_id'])) ? 
		"AND po.manufacturer_id = '" . (int)$data['filter_manufacturer_id'] . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_receive_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pr.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_receive_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pr.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_manufacturer_name_statement = (!empty($data['filter_manufacturer_name'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_manufacturer_name']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$sql = "
		SELECT 
			SUM(extra_qty) AS total_extra_qty 
		FROM(
		SELECT
			(
				SELECT
					CASE WHEN COALESCE(SUM(prp.quantity), 0) > pop.quantity
					THEN COALESCE(SUM(prp.quantity), 0) - pop.quantity ELSE 0 END
				FROM " . DB_PREFIX . "purchase_receive_product prp
				LEFT JOIN " . DB_PREFIX . "purchase_receive pr
				ON prp.purchase_receive_id = pr.purchase_receive_id
				WHERE 1
				AND prp.purchase_order_id = po.purchase_order_id
				AND prp.product_id = pop.product_id
				AND pr.order_status_id = '5'
				$filter_receive_date_start_statement
				$filter_receive_date_end_statement
			) AS extra_qty
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		$filter_manufacturer_id_statement
		$filter_product_id_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_manufacturer_name_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		
		UNION ALL
		
		SELECT
			prp.quantity AS extra_qty
		FROM " . DB_PREFIX . "purchase_receive_product prp
		LEFT JOIN " . DB_PREFIX . "purchase_receive pr
		ON prp.purchase_receive_id = pr.purchase_receive_id
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pr.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON prp.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON prp.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON prp.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		WHERE 1
		AND prp.purchase_order_id = 0
		$filter_manufacturer_id_statement
		$filter_reveice_product_id_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_manufacturer_name_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		)a
		";
		
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/
		
		$query = $this->db->query($sql);
		return $query->row['total_extra_qty'];
	
	}
	public function getPurchaseOutstandingSummaryByStockInfoTotalOutstanding($data = array()){
		
		$sort 	= isset($data['sort']) ? $data['sort'] : "manufacturer_code";
		$order 	= isset($data['order']) ? $data['order'] : "ASC";
		
		$filter_product_id_statement = (!empty($data['filter_product_id'])) ? 
		"AND pop.product_id = '" . (int)$data['filter_product_id'] . "'" : 
		"";
		
		$filter_reveice_product_id_statement = (!empty($data['filter_product_id'])) ? 
		"AND prp.product_id = '" . (int)$data['filter_product_id'] . "'" : 
		"";
		
		$filter_manufacturer_id_statement = (!empty($data['filter_manufacturer_id'])) ? 
		"AND po.manufacturer_id = '" . (int)$data['filter_manufacturer_id'] . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_receive_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pr.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_receive_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pr.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_manufacturer_name_statement = (!empty($data['filter_manufacturer_name'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_manufacturer_name']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT
			SUM(
				(
					pop.quantity - 
					(
						SELECT
							CASE WHEN COALESCE(SUM(prp.quantity), 0) <= pop.quantity
							THEN COALESCE(SUM(prp.quantity), 0) ELSE pop.quantity END
						FROM " . DB_PREFIX . "purchase_receive_product prp
						LEFT JOIN " . DB_PREFIX . "purchase_receive pr
						ON prp.purchase_receive_id = pr.purchase_receive_id
						WHERE 1
						AND prp.purchase_order_id = po.purchase_order_id
						AND prp.product_id = pop.product_id
						AND pr.order_status_id = '5'
						$filter_receive_date_start_statement
						$filter_receive_date_end_statement
					)
				)
			) AS total_outstanding
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		$filter_manufacturer_id_statement
		$filter_product_id_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_manufacturer_name_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		";
		
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/
		
		$query = $this->db->query($sql);
		return $query->row['total_outstanding'];
	
	}
	public function getTotalPurchaseOutstandingSummaryByStockInfo($data = array()){
		
		$filter_product_id_statement = (!empty($data['filter_product_id'])) ? 
		"AND pop.product_id = '" . (int)$data['filter_product_id'] . "'" : 
		"";
		
		$filter_manufacturer_id_statement = (!empty($data['filter_manufacturer_id'])) ? 
		"AND po.manufacturer_id = '" . (int)$data['filter_manufacturer_id'] . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_receive_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pr.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_receive_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pr.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_manufacturer_name_statement = (!empty($data['filter_manufacturer_name'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_manufacturer_name']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$sql = "
		SELECT
			COUNT(*) AS total_result
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		$filter_manufacturer_id_statement
		$filter_product_id_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_manufacturer_name_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		";
		
		$query = $this->db->query($sql);
		return $query->row['total_result'];
	}
	public function getPurchaseOutstandingSummaryByStockInfoTotalAmount($data = array()){
		
		$filter_product_id_statement = (!empty($data['filter_product_id'])) ? 
		"AND pop.product_id = '" . (int)$data['filter_product_id'] . "'" : 
		"";
		
		$filter_manufacturer_id_statement = (!empty($data['filter_manufacturer_id'])) ? 
		"AND po.manufacturer_id = '" . (int)$data['filter_manufacturer_id'] . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_receive_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pr.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_receive_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pr.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_manufacturer_name_statement = (!empty($data['filter_manufacturer_name'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_manufacturer_name']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$sql = "
		SELECT
			SUM(
				(
					pop.quantity - 
					(
						SELECT
							CASE WHEN COALESCE(SUM(prp.quantity), 0) <= pop.quantity
							THEN COALESCE(SUM(prp.quantity), 0) ELSE pop.quantity END
						FROM " . DB_PREFIX . "purchase_receive_product prp
						LEFT JOIN " . DB_PREFIX . "purchase_receive pr
						ON prp.purchase_receive_id = pr.purchase_receive_id
						WHERE 1
						AND prp.purchase_order_id = po.purchase_order_id
						AND prp.product_id = pop.product_id
						AND pr.order_status_id = '5'
						$filter_receive_date_start_statement
						$filter_receive_date_end_statement
					)
				) * pop.price
			) AS total_outstanding_amount
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		$filter_manufacturer_id_statement
		$filter_product_id_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_manufacturer_name_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		";
		
		$query = $this->db->query($sql);
		return $query->row['total_outstanding_amount'];
	}
	public function getPurchaseOutstandingSummaryByStockInfoManufacturerDetail($manufacturer_id){
		$sql = "SELECT * FROM " . DB_PREFIX . "manufacturer WHERE manufacturer_id = '" . (int)$manufacturer_id . "'";
		
		$query = $this->db->query($sql);
		return $query->row;
	}
	public function getPurchaseOutstandingSummaryByStockInfoManufacturerProductDetail($product_id){
		$sql = "
		SELECT 
			p.code,
			pd_en.name AS en_name,
			pd_cn.name AS cn_name
		FROM " . DB_PREFIX . "product p
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON p.product_id = pd_en.product_id 
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON p.product_id = pd_cn.product_id 
		AND pd_cn.language_id = '2'
		WHERE p.product_id = '" . (int)$product_id . "'";
		
		$query = $this->db->query($sql);
		return $query->row;
	}
	
	public function getPurchaseOutstandingDetailByStock($data = array()){
		$sort 	= isset($data['sort']) ? $data['sort'] : "manufacturer_code";
		$order 	= isset($data['order']) ? $data['order'] : "ASC";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_receive_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pr.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_receive_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pr.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_manufacturer_name_statement = (!empty($data['filter_manufacturer_name'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_manufacturer_name']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT * FROM(
		SELECT
			po.date_added,
			po.invoice_prefix,
			m.code AS manufacturer_code,
			m.name AS manufacturer_name,
			p.code AS product_code,
			pd_en.name AS english_name,
			pd_cn.name AS chinese_name,
			pop.quantity,
			(
				SELECT
					CASE WHEN COALESCE(SUM(prp.quantity), 0) <= pop.quantity
					THEN COALESCE(SUM(prp.quantity), 0) ELSE pop.quantity END
				FROM " . DB_PREFIX . "purchase_receive_product prp
				LEFT JOIN " . DB_PREFIX . "purchase_receive pr
				ON prp.purchase_receive_id = pr.purchase_receive_id
				WHERE 1
				AND prp.purchase_order_id = po.purchase_order_id
				AND prp.product_id = pop.product_id
				AND pr.order_status_id = '5'
				$filter_receive_date_start_statement
				$filter_receive_date_end_statement
			) AS receive_qty,
			(
				SELECT
					CASE WHEN COALESCE(SUM(prp.quantity), 0) > pop.quantity
					THEN COALESCE(SUM(prp.quantity), 0) - pop.quantity ELSE 0 END
				FROM " . DB_PREFIX . "purchase_receive_product prp
				LEFT JOIN " . DB_PREFIX . "purchase_receive pr
				ON prp.purchase_receive_id = pr.purchase_receive_id
				WHERE 1
				AND prp.purchase_order_id = po.purchase_order_id
				AND prp.product_id = pop.product_id
				AND pr.order_status_id = '5'
				$filter_receive_date_start_statement
				$filter_receive_date_end_statement
			) AS extra_qty,
			(
				pop.quantity - 
				(
					SELECT
						CASE WHEN COALESCE(SUM(prp.quantity), 0) <= pop.quantity
						THEN COALESCE(SUM(prp.quantity), 0) ELSE pop.quantity END
					FROM " . DB_PREFIX . "purchase_receive_product prp
					LEFT JOIN " . DB_PREFIX . "purchase_receive pr
					ON prp.purchase_receive_id = pr.purchase_receive_id
					WHERE 1
					AND prp.purchase_order_id = po.purchase_order_id
					AND prp.product_id = pop.product_id
					AND pr.order_status_id = '5'
					$filter_receive_date_start_statement
					$filter_receive_date_end_statement
				)
			) AS outstanding,
			pop.price AS unit_price,
			(
				(
					pop.quantity - 
					(
						SELECT
							CASE WHEN COALESCE(SUM(prp.quantity), 0) <= pop.quantity
							THEN COALESCE(SUM(prp.quantity), 0) ELSE pop.quantity END
						FROM " . DB_PREFIX . "purchase_receive_product prp
						LEFT JOIN " . DB_PREFIX . "purchase_receive pr
						ON prp.purchase_receive_id = pr.purchase_receive_id
						WHERE 1
						AND prp.purchase_order_id = po.purchase_order_id
						AND prp.product_id = pop.product_id
						AND pr.order_status_id = '5'
						$filter_receive_date_start_statement
						$filter_receive_date_end_statement
					)
				) * pop.price
			) AS outstanding_amount,
			po.currency_code,
			po.currency_value
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_manufacturer_name_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		
		UNION ALL
		
		SELECT
			po.date_added,
			po.invoice_prefix,
			m.code AS manufacturer_code,
			m.name AS manufacturer_name,
			p.code AS product_code,
			pd_en.name AS en_name,
			pd_cn.name AS cn_name,
			0 AS order_qty,
			0 AS receive_qty,
			prp.quantity AS extra_qty,
			0 AS outstanding,
			0 AS unit_price,
			0 AS outstanding_amount,
			po.currency_code,
			po.currency_value
		FROM " . DB_PREFIX . "purchase_receive_product prp
		LEFT JOIN " . DB_PREFIX . "purchase_receive pr
		ON prp.purchase_receive_id = pr.purchase_receive_id
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pr.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON prp.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON prp.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON prp.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		WHERE 1
		AND prp.purchase_order_id = 0
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_manufacturer_name_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		)a
		ORDER BY $sort $order
		$limit_statement
		";
		
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/
		
		$query = $this->db->query($sql);
		return $query->rows;
	}
	public function getTotalPurchaseOutstandingDetailByStock($data = array()){
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_receive_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pr.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_receive_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pr.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_manufacturer_name_statement = (!empty($data['filter_manufacturer_name'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_manufacturer_name']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$sql = "
		SELECT
			COUNT(*) AS total_result
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_manufacturer_name_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		";
		
		$query = $this->db->query($sql);
		return $query->row['total_result'];
	}
	public function getPurchaseOutStandingDetailByStockTotalOrderQuantity($data = array()){
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_supplier_statement = (!empty($data['filter_supplier'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_supplier']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$sql = "
		SELECT
			SUM(pop.quantity) AS total_order_qty
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_supplier_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		";
		
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/
		
		$query = $this->db->query($sql);
		return $query->row['total_order_qty'];
	}
	public function getPurchaseOutStandingDetailByStockTotalReceiveQuantity($data = array()){
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_receive_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pr.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_receive_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pr.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_supplier_statement = (!empty($data['filter_supplier'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_supplier']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$sql = "
		SELECT
			SUM(
				(
					SELECT
						CASE WHEN COALESCE(SUM(prp.quantity), 0) <= pop.quantity
						THEN COALESCE(SUM(prp.quantity), 0) ELSE pop.quantity END
					FROM " . DB_PREFIX . "purchase_receive_product prp
					LEFT JOIN " . DB_PREFIX . "purchase_receive pr
					ON prp.purchase_receive_id = pr.purchase_receive_id
					WHERE 1
					AND prp.purchase_order_id = po.purchase_order_id
					AND prp.product_id = pop.product_id
					AND pr.order_status_id = '5'
					$filter_receive_date_start_statement
					$filter_receive_date_end_statement
				)
			) AS total_receive_qty
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_supplier_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		";
		
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/
		
		$query = $this->db->query($sql);
		return $query->row['total_receive_qty'];
	}
	public function getPurchaseOutStandingDetailByStockTotalExtra($data = array()){
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_receive_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pr.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_receive_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pr.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_supplier_statement = (!empty($data['filter_supplier'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_supplier']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		
		$sql = "
		SELECT
			SUM(extra_qty) AS total_extra_qty
		FROM(
		SELECT
			(
				SELECT
					CASE WHEN COALESCE(SUM(prp.quantity), 0) > pop.quantity
					THEN COALESCE(SUM(prp.quantity), 0) - pop.quantity ELSE 0 END
				FROM " . DB_PREFIX . "purchase_receive_product prp
				LEFT JOIN " . DB_PREFIX . "purchase_receive pr
				ON prp.purchase_receive_id = pr.purchase_receive_id
				WHERE 1
				AND prp.purchase_order_id = po.purchase_order_id
				AND prp.product_id = pop.product_id
				AND pr.order_status_id = '5'
				$filter_receive_date_start_statement
				$filter_receive_date_end_statement
			) AS extra_qty
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_supplier_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		
		UNION ALL
		
		SELECT
			prp.quantity AS extra_qty
		FROM " . DB_PREFIX . "purchase_receive_product prp
		LEFT JOIN " . DB_PREFIX . "purchase_receive pr
		ON prp.purchase_receive_id = pr.purchase_receive_id
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pr.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON prp.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON prp.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON prp.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		WHERE 1
		AND prp.purchase_order_id = 0
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_supplier_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		)a
		";
		
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/
		
		$query = $this->db->query($sql);
		return $query->row['total_extra_qty'];
	}
	public function getPurchaseOutStandingDetailByStockTotalOutstanding($data = array()){
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_receive_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pr.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_receive_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pr.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_supplier_statement = (!empty($data['filter_supplier'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_supplier']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$sql = "
		SELECT
			SUM(
				pop.quantity - 
				(
					SELECT
						CASE WHEN COALESCE(SUM(prp.quantity), 0) <= pop.quantity
						THEN COALESCE(SUM(prp.quantity), 0) ELSE pop.quantity END
					FROM " . DB_PREFIX . "purchase_receive_product prp
					LEFT JOIN " . DB_PREFIX . "purchase_receive pr
					ON prp.purchase_receive_id = pr.purchase_receive_id
					WHERE 1
					AND prp.purchase_order_id = po.purchase_order_id
					AND prp.product_id = pop.product_id
					AND pr.order_status_id = '5'
					$filter_receive_date_start_statement
					$filter_receive_date_end_statement
				)
			) AS total_outstanding,
			pop.price AS unit_price,
			(
				(
					pop.quantity - 
					(
						SELECT
							CASE WHEN COALESCE(SUM(prp.quantity), 0) <= pop.quantity
							THEN COALESCE(SUM(prp.quantity), 0) ELSE pop.quantity END
						FROM " . DB_PREFIX . "purchase_receive_product prp
						LEFT JOIN " . DB_PREFIX . "purchase_receive pr
						ON prp.purchase_receive_id = pr.purchase_receive_id
						WHERE 1
						AND prp.purchase_order_id = po.purchase_order_id
						AND prp.product_id = pop.product_id
						AND pr.order_status_id = '5'
						$filter_receive_date_start_statement
						$filter_receive_date_end_statement
					)
				) * pop.price
			) AS amount,
			po.currency_code,
			po.currency_value
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_supplier_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		";
		
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/
		
		$query = $this->db->query($sql);
		return $query->row['total_outstanding'];
	}
	public function getPurchaseOutstandingDetailByStockTotalAmount($data = array()){
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(po.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(po.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_receive_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pr.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_receive_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pr.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_manufacturer_name_statement = (!empty($data['filter_manufacturer_name'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_manufacturer_name']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND po.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND po.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$sql = "
		SELECT
			SUM(
				(
					pop.quantity - 
					(
						SELECT
							CASE WHEN COALESCE(SUM(prp.quantity), 0) <= pop.quantity
							THEN COALESCE(SUM(prp.quantity), 0) ELSE pop.quantity END
						FROM " . DB_PREFIX . "purchase_receive_product prp
						LEFT JOIN " . DB_PREFIX . "purchase_receive pr
						ON prp.purchase_receive_id = pr.purchase_receive_id
						WHERE 1
						AND prp.purchase_order_id = po.purchase_order_id
						AND prp.product_id = pop.product_id
						AND pr.order_status_id = '5'
						$filter_receive_date_start_statement
						$filter_receive_date_end_statement
					)
				) * pop.price
			) AS total_outstanding_amount
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pop.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pop.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pop.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_manufacturer_name_statement
		$filter_name_en_statement
		$filter_name_cn_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		";
		
		$query = $this->db->query($sql);
		return $query->row['total_outstanding_amount'];
	}
	
	public function getPurchaseInvoiceDetailByStockReport($data = array()){
		$sort 	= isset($data['sort']) ? $data['sort'] : "pi.date_added";
		$order 	= isset($data['order']) ? $data['order'] : "DESC";
		
		$filter_supplier_invoice_start_statement = (!empty($data['filter_supplier_invoice_start'])) ? 
		"AND pi.supplier_invoice >= '" . $this->db->escape($data['filter_supplier_invoice_start']) . "'" : 
		"";
		
		$filter_supplier_invoice_end_statement = (!empty($data['filter_supplier_invoice_end'])) ? 
		"AND pi.supplier_invoice <= '" . $this->db->escape($data['filter_supplier_invoice_end']) . "'" : 
		"";
		
		$filter_from_statement = (!empty($data['filter_from'])) ?
		"AND pi.type = '" . (int)$data['filter_from'] . "'" :
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND pi.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND pi.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pi.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pi.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_manufacturer_name_statement = (!empty($data['filter_manufacturer_name'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_manufacturer_name']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND pi.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND pi.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT 
			pi.date_added,
			pi.invoice_prefix,
			pi.supplier_invoice,
			m.code AS manufacturer_code,
			m.name AS manufacturer_name,
			pi.type,
			CASE WHEN pip.transaction_no != NULL THEN 
			pip.transaction_no ELSE '-' END AS purchase_order,
			p.code AS product_code,
			pd_en.name AS english_name,
			pd_cn.name AS chinese_name,
			pip.quantity,
			pip.price AS unit_price,
			pip.total_net_amount,
			pip.total_tax,
			pip.total,
			pi.currency_code,
			pi.currency_value
		FROM " . DB_PREFIX . "purchase_invoice_product pip
		LEFT JOIN " . DB_PREFIX . "purchase_invoice pi
		ON pip.purchase_invoice_id = pi.purchase_invoice_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON pi.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pip.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pip.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pip.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		AND pip.product_id != '0'
		$filter_supplier_invoice_start_statement
		$filter_supplier_invoice_end_statement
		$filter_from_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_manufacturer_name_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		ORDER BY $sort $order
		$limit_statement
		";
		$query = $this->db->query($sql);
		return $query->rows;
	}
	public function getTotalPurchaseInvoiceDetailByStockReport($data = array()){
		
		$filter_supplier_invoice_start_statement = (!empty($data['filter_supplier_invoice_start'])) ? 
		"AND pi.supplier_invoice >= '" . $this->db->escape($data['filter_supplier_invoice_start']) . "'" : 
		"";
		
		$filter_supplier_invoice_end_statement = (!empty($data['filter_supplier_invoice_end'])) ? 
		"AND pi.supplier_invoice <= '" . $this->db->escape($data['filter_supplier_invoice_end']) . "'" : 
		"";
		
		$filter_from_statement = (!empty($data['filter_from'])) ?
		"AND pi.type = '" . (int)$data['filter_from'] . "'" :
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND pi.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND pi.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pi.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pi.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_manufacturer_name_statement = (!empty($data['filter_manufacturer_name'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_manufacturer_name']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND pi.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND pi.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		
		$sql = "
		SELECT 
			COUNT(*) AS total_result
		FROM " . DB_PREFIX . "purchase_invoice_product pip
		LEFT JOIN " . DB_PREFIX . "purchase_invoice pi
		ON pip.purchase_invoice_id = pi.purchase_invoice_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON pi.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pip.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pip.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pip.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		AND pip.product_id != '0'
		$filter_supplier_invoice_start_statement
		$filter_supplier_invoice_end_statement
		$filter_from_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_manufacturer_name_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		";
		$query = $this->db->query($sql);
		return $query->row['total_result'];
	}
	public function getPurchaseInvoiceDetailByStockReportTotalQuantity($data = array()){
		
		$filter_supplier_invoice_start_statement = (!empty($data['filter_supplier_invoice_start'])) ? 
		"AND pi.supplier_invoice >= '" . $this->db->escape($data['filter_supplier_invoice_start']) . "'" : 
		"";
		
		$filter_supplier_invoice_end_statement = (!empty($data['filter_supplier_invoice_end'])) ? 
		"AND pi.supplier_invoice <= '" . $this->db->escape($data['filter_supplier_invoice_end']) . "'" : 
		"";
		
		$filter_from_statement = (!empty($data['filter_from'])) ?
		"AND pi.type = '" . (int)$data['filter_from'] . "'" :
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND pi.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND pi.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pi.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pi.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_manufacturer_name_statement = (!empty($data['filter_manufacturer_name'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_manufacturer_name']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND pi.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND pi.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$sql = "
		SELECT 
			COALESCE(SUM(pip.quantity), 0.00) AS total_quantity
		FROM " . DB_PREFIX . "purchase_invoice_product pip
		LEFT JOIN " . DB_PREFIX . "purchase_invoice pi
		ON pip.purchase_invoice_id = pi.purchase_invoice_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON pi.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pip.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pip.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pip.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		AND pip.product_id != '0'
		$filter_supplier_invoice_start_statement
		$filter_supplier_invoice_end_statement
		$filter_from_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_manufacturer_name_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		";
		$query = $this->db->query($sql);
		return $query->row['total_quantity'];
	}
	public function getPurchaseInvoiceDetailByStockReportTotalNetAmount($data = array()){
		
		$filter_supplier_invoice_start_statement = (!empty($data['filter_supplier_invoice_start'])) ? 
		"AND pi.supplier_invoice >= '" . $this->db->escape($data['filter_supplier_invoice_start']) . "'" : 
		"";
		
		$filter_supplier_invoice_end_statement = (!empty($data['filter_supplier_invoice_end'])) ? 
		"AND pi.supplier_invoice <= '" . $this->db->escape($data['filter_supplier_invoice_end']) . "'" : 
		"";
		
		$filter_from_statement = (!empty($data['filter_from'])) ?
		"AND pi.type = '" . (int)$data['filter_from'] . "'" :
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND pi.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND pi.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pi.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pi.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_manufacturer_name_statement = (!empty($data['filter_manufacturer_name'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_manufacturer_name']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND pi.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND pi.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		
		
		$sql = "
		SELECT 
			SUM(pip.total_net_amount) AS total_net_amount
		FROM " . DB_PREFIX . "purchase_invoice_product pip
		LEFT JOIN " . DB_PREFIX . "purchase_invoice pi
		ON pip.purchase_invoice_id = pi.purchase_invoice_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON pi.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pip.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pip.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pip.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		AND pip.product_id != '0'
		$filter_supplier_invoice_start_statement
		$filter_supplier_invoice_end_statement
		$filter_from_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_manufacturer_name_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		";
		$query = $this->db->query($sql);
		return $query->row['total_net_amount'];
	}
	public function getPurchaseInvoiceDetailByStockReportTotalTotalTax($data = array()){
		
		$filter_supplier_invoice_start_statement = (!empty($data['filter_supplier_invoice_start'])) ? 
		"AND pi.supplier_invoice >= '" . $this->db->escape($data['filter_supplier_invoice_start']) . "'" : 
		"";
		
		$filter_supplier_invoice_end_statement = (!empty($data['filter_supplier_invoice_end'])) ? 
		"AND pi.supplier_invoice <= '" . $this->db->escape($data['filter_supplier_invoice_end']) . "'" : 
		"";
		
		$filter_from_statement = (!empty($data['filter_from'])) ?
		"AND pi.type = '" . (int)$data['filter_from'] . "'" :
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND pi.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND pi.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pi.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pi.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_manufacturer_name_statement = (!empty($data['filter_manufacturer_name'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_manufacturer_name']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND pi.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND pi.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		$sql = "
		SELECT 
			SUM(pip.total_tax) AS total_tax
		FROM " . DB_PREFIX . "purchase_invoice_product pip
		LEFT JOIN " . DB_PREFIX . "purchase_invoice pi
		ON pip.purchase_invoice_id = pi.purchase_invoice_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON pi.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pip.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pip.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pip.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		AND pip.product_id != '0'
		$filter_supplier_invoice_start_statement
		$filter_supplier_invoice_end_statement
		$filter_from_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_manufacturer_name_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		";
		$query = $this->db->query($sql);
		return $query->row['total_tax'];
	}
	public function getPurchaseInvoiceDetailByStockReportTotalSales($data = array()){
		
		$filter_supplier_invoice_start_statement = (!empty($data['filter_supplier_invoice_start'])) ? 
		"AND pi.supplier_invoice >= '" . $this->db->escape($data['filter_supplier_invoice_start']) . "'" : 
		"";
		
		$filter_supplier_invoice_end_statement = (!empty($data['filter_supplier_invoice_end'])) ? 
		"AND pi.supplier_invoice <= '" . $this->db->escape($data['filter_supplier_invoice_end']) . "'" : 
		"";
		
		$filter_from_statement = (!empty($data['filter_from'])) ?
		"AND pi.type = '" . (int)$data['filter_from'] . "'" :
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND pi.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND pi.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(pi.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(pi.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_manufacturer_code_statement = (!empty($data['filter_manufacturer_code'])) ?
		"AND m.code LIKE '%" . $this->db->escape($data['filter_manufacturer_code']) . "%'" : 
		"";
		
		$filter_manufacturer_name_statement = (!empty($data['filter_manufacturer_name'])) ?
		"AND m.name LIKE '%" . $this->db->escape($data['filter_manufacturer_name']) . "%'" : 
		"";
		
		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ? 
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" : 
		"";
		
		$filter_name_en_statement = (!empty($data['filter_name_en'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" : 
		"";
		
		$filter_product_code_statement = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND pi.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_order_status_id_statement = (!empty($data['filter_order_status_id'])) ?
		"AND pi.order_status_id = '" . (int)$data['filter_order_status_id'] . "'" :
		"";
		
		
		$sql = "
		SELECT 
			SUM(pip.total) AS total_sales
		FROM " . DB_PREFIX . "purchase_invoice_product pip
		LEFT JOIN " . DB_PREFIX . "purchase_invoice pi
		ON pip.purchase_invoice_id = pi.purchase_invoice_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON pi.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON pip.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON pip.product_id = pd_en.product_id
		AND pd_en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON pip.product_id = pd_cn.product_id
		AND pd_cn.language_id = '2'
		WHERE 1
		AND pip.product_id != '0'
		$filter_supplier_invoice_start_statement
		$filter_supplier_invoice_end_statement
		$filter_from_statement
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_manufacturer_code_statement
		$filter_manufacturer_name_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		$filter_product_code_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		";
		$query = $this->db->query($sql);
		return $query->row['total_sales'];
	}
}
?>