<?php
class ModelReportPromoteEtcmapp extends Model{
    public function getTotalPromotesUserApp($data){
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "etcm_favourite WHERE favourite_status = '1'";

        if(!empty($data['filter_date_added'])){
           $sql .= " AND date_added = '" . $this->db->escape($data['filter_date_added']) . "'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getGrandTotalPromoteUserApp(){
        $sql = "SELECT COUNT(*) AS total
                FROM " . DB_PREFIX . "etcm_favourite WHERE favourite_status = '1'";

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getAllCustomerPromoteUserApp(){
        $sql = "SELECT COUNT(*) AS total
                FROM " . DB_PREFIX . "etcm_favourite";

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getPromoteCustomers($data){
        $sql = "SELECT customer_name,
                       gender,
                       telephone,
                       email,
                       favourite_status,
                       date_added
                FROM " . DB_PREFIX . "etcm_favourite";

        $implode = [];

        if(!empty($data['filter_customer_name'])){
            $implode[] = "customer_name LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'";
        }

        if(!empty($data['filter_email'])){
            $implode[] = "email LIKE '%" . $this->db->escape($data['filter_email']) . "%'";
        }

        if(!empty($data['filter_telephone'])){
            $implode[] = "telephone LIKE '%" . $this->db->escape($data['filter_telephone']) . "%'";
        }

        if(isset($data['filter_gender'])){
            $implode[] = "gender = '" . (int)$data['filter_gender'] . "'";
        }

        if(isset($data['filter_favourite'])){
            $implode[] = "favourite_status = '" . (int)$data['filter_favourite'] . "'";
        }

        if (!empty($data['filter_date_added'])) {
			$implode[] = "DATE(date_added) = DATE('" . $this->db->escape($data['filter_date_added']) . "')";
		}

        if ($implode) {
            $sql .= " WHERE " . implode(" AND ", $implode);
        }

        $sort_data = [
            'etcm_favourite_id',
            'customer_name',
            'email',
            'gender',
            'favourite_status',
            'date_added'
        ];

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY customer_name";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalPromoteCustomers($data){
        $sql = "SELECT COUNT(*) AS total
                FROM " . DB_PREFIX . "etcm_favourite";

        $implode = [];

        if(!empty($data['filter_customer_name'])){
            $implode[] = "customer_name LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'";
        }

        if(!empty($data['filter_email'])){
            $implode[] = "email LIKE '%" . $this->db->escape($data['filter_email']) . "%'";
        }

        if(!empty($data['filter_telephone'])){
            $implode[] = "telephone LIKE '%" . $this->db->escape($data['filter_telephone']) . "%'";
        }

        if(isset($data['filter_gender'])){
            $implode[] = "gender = '" . (int)$data['filter_gender'] . "'";
        }

        if(isset($data['filter_favourite'])){
            $implode[] = "favourite_status = '" . (int)$data['filter_favourite'] . "'";
        }

        if (!empty($data['filter_date_added'])) {
			$implode[] = "DATE(date_added) = DATE('" . $this->db->escape($data['filter_date_added']) . "')";
		}

        if ($implode) {
            $sql .= " WHERE " . implode(" AND ", $implode);
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getAllPromoteCustomers($data){
        $sql = "SELECT customer_name,
                       gender,
                       telephone,
                       email,
                       favourite_status,
                       date_added
                FROM " . DB_PREFIX . "etcm_favourite";

        $implode = [];

        if(!empty($data['filter_customer_name'])){
            $implode[] = "customer_name LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'";
        }

        if(!empty($data['filter_email'])){
            $implode[] = "email LIKE '%" . $this->db->escape($data['filter_email']) . "%'";
        }

        if(!empty($data['filter_telephone'])){
            $implode[] = "telephone LIKE '%" . $this->db->escape($data['filter_telephone']) . "%'";
        }

        if(isset($data['filter_gender'])){
            $implode[] = "gender = '" . (int)$data['filter_gender'] . "'";
        }

        if(isset($data['filter_favourite'])){
            $implode[] = "favourite_status = '" . (int)$data['filter_favourite'] . "'";
        }

        if (!empty($data['filter_date_added'])) {
			$implode[] = "DATE(date_added) = DATE('" . $this->db->escape($data['filter_date_added']) . "')";
		}

        if ($implode) {
            $sql .= " WHERE " . implode(" AND ", $implode);
        }

        $sort_data = [
            'etcm_favourite_id',
            'customer_name',
            'email',
            'gender',
            'favourite_status',
            'date_added'
        ];

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY customer_name";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }
}
?>
