<?php
class ModelReportProductStockAlert extends Model {
	public function getProductsViewed($data = array()) {
		$sql = "SELECT pd.name, p.model, p.viewed FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND p.viewed > 0 ORDER BY p.viewed DESC";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalProductsViewed() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product WHERE viewed > 0");

		return $query->row['total'];
	}

	public function reset() {
		$this->db->query("UPDATE " . DB_PREFIX . "product SET viewed = '0'");
	}

	//purchased
	public function getPurchased($data = array()) {

		$today = date('Y-m-d');
		$language_id = $this->config->get('config_language_id');

		$sort 	= isset($data['sort']) ? $data['sort'] : "date_added";

		$order 	= isset($data['order']) ? $data['order'] : "DESC";

		$filter_order_status_id_statement = !empty($data['filter_order_status_id']) ?
		"AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'":
		"AND o.order_status_id > '0'";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		$filter_date_start_statement = !empty($data['filter_date_start']) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start'] . " 00:00:00") . "'":
		"AND DATE(o.date_added) >= '" . $this->db->escape($today . " 00:00:00") . "'";

		$filter_date_end_statement = !empty($data['filter_date_end']) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end'] . " 23:59:59") . "'":
		"AND DATE(o.date_added) <= '" . $this->db->escape($today . " 23:59:59") . "'";

		$filter_product_name_statement = !empty($data['filter_product_name']) ?
		"AND pd.name LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'":
		"";

		$filter_product_code_statement = !empty($data['filter_product_code']) ?
		"AND p.code = '" . $this->db->escape($data['filter_product_code']) . "'":
		"";

		$filter_category_statement = !empty($data['filter_category']) ?
		"HAVING category LIKE '%" . $this->db->escape($data['filter_category']) . "%'":
		"";

		$limit_statement = "";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$sql = "
		SELECT
			p.product_id, 
			p.code,
			pd.name,
			(
				SELECT
				GROUP_CONCAT(cd.name ORDER BY cd.name SEPARATOR ', ')
				FROM " . DB_PREFIX . "product_to_category ptc
				LEFT JOIN " . DB_PREFIX . "category_description cd
				ON ptc.category_id = cd.category_id
				AND cd.language_id = '" . (int)$language_id . "'
				WHERE p.product_id = ptc.product_id
			) AS category,
			p.model,
			p.product_type AS type,
			SUM(op.quantity) AS quantity,
			SUM(op.tax) AS tax,
			SUM((op.total + op.tax)) AS total
		FROM " . DB_PREFIX . "order_product op
		LEFT JOIN " . DB_PREFIX . "order o
		ON op.order_id = o.order_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON op.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd
		ON p.product_id = pd.product_id AND pd.language_id = '" . (int)$language_id . "'
		WHERE 1
		AND op.price > 0
		$filter_order_status_id_statement
		$filter_store_id_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_product_name_statement
		$filter_product_code_statement
		GROUP BY op.product_id
		$filter_category_statement
		ORDER BY $sort $order
		$limit_statement
		";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getPurchasedProduct($data = array(), $product_id) {
		$today = date('Y-m-d');
		$language_id = $this->config->get('config_language_id');

		$filter_order_status_id_statement = !empty($data['filter_order_status_id']) ?
		"AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'":
		"AND o.order_status_id > '0'";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		$filter_date_start_statement = !empty($data['filter_date_start']) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start'] . " 00:00:00") . "'":
		"AND DATE(o.date_added) >= '" . $this->db->escape($today . " 00:00:00") . "'";

		$filter_date_end_statement = !empty($data['filter_date_end']) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end'] . " 23:59:59") . "'":
		"AND DATE(o.date_added) <= '" . $this->db->escape($today . " 23:59:59") . "'";

		$sql = "
		SELECT
			o.order_id,
			o.invoice_prefix,
			o.date_added,  
			op.quantity, 
			o.customer_id  
		FROM " . DB_PREFIX . "order_product op
		LEFT JOIN " . DB_PREFIX . "order o
		ON op.order_id = o.order_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON op.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd
		ON p.product_id = pd.product_id AND pd.language_id = '" . (int)$language_id . "'
		WHERE 1
		AND op.price > 0 
		AND p.product_id = '" . (int)$product_id . "' 
		$filter_order_status_id_statement
		$filter_store_id_statement
		$filter_date_start_statement
		$filter_date_end_statement";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getPurchasedTotalTax($data = array()){
		$today = date('Y-m-d');

		$language_id = $this->config->get('config_language_id');

		$sql = "
		SELECT SUM(op.tax) AS total_tax
		FROM " . DB_PREFIX . "order_product op
		LEFT JOIN " . DB_PREFIX . "order o
		ON (op.order_id = o.order_id)
		LEFT JOIN " . DB_PREFIX . "product p
		ON (op.product_id = p.product_id)
		LEFT JOIN " . DB_PREFIX . "product_description pd
		ON (p.product_id = pd.product_id)
		LEFT JOIN " . DB_PREFIX . "product_to_category ptc
		ON (p.product_id = ptc.product_id)
		LEFT JOIN " . DB_PREFIX . "category c
		ON (ptc.category_id = c.category_id)
		LEFT JOIN " . DB_PREFIX . "category_description cd
		ON (c.category_id = cd.category_id)
		WHERE 1
		AND pd.language_id = " . (int)$language_id . "
		AND cd.language_id = " . (int)$language_id;


		if (!empty($data['filter_order_status_id'])) {
			$sql .= " AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'";
		} else {
			$sql .= " AND o.order_status_id > '0'";
		}

		if (!empty($data['filter_store_id'])) {
			$sql .= " AND o.store_id = '" . (int)$data['filter_store_id'] . "'";
		}

		if (!empty($data['filter_date_start'])) {
			$sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start'] . " 00:00:00") . "'";
		} else {
			$sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($today . " 00:00:00") . "'";
		}

		if (!empty($data['filter_date_end'])) {
			$sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end'] . " 23:59:59") . "'";
		} else {
			$sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($today . " 23:59:59") . "'";
		}

		$query = $this->db->query($sql);

		return $query->row['total_tax'];
	}

	public function getPurchasedTotalSales($data = array()){
		$today = date('Y-m-d');

		$language_id = $this->config->get('config_language_id');

		$sql = "
		SELECT SUM(op.total + op.tax) AS total_sales
		FROM " . DB_PREFIX . "order_product op
		LEFT JOIN " . DB_PREFIX . "order o
		ON (op.order_id = o.order_id)
		LEFT JOIN " . DB_PREFIX . "product p
		ON (op.product_id = p.product_id)
		LEFT JOIN " . DB_PREFIX . "product_description pd
		ON (p.product_id = pd.product_id)
		LEFT JOIN " . DB_PREFIX . "product_to_category ptc
		ON (p.product_id = ptc.product_id)
		LEFT JOIN " . DB_PREFIX . "category c
		ON (ptc.category_id = c.category_id)
		LEFT JOIN " . DB_PREFIX . "category_description cd
		ON (c.category_id = cd.category_id)
		WHERE 1
		AND pd.language_id = " . (int)$language_id . "
		AND cd.language_id = " . (int)$language_id;


		if (!empty($data['filter_order_status_id'])) {
			$sql .= " AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'";
		} else {
			$sql .= " AND o.order_status_id > '0'";
		}

		if (!empty($data['filter_store_id'])) {
			$sql .= " AND o.store_id = '" . (int)$data['filter_store_id'] . "'";
		}

		if (!empty($data['filter_date_start'])) {
			$sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start'] . " 00:00:00") . "'";
		} else {
			$sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($today . " 00:00:00") . "'";
		}

		if (!empty($data['filter_date_end'])) {
			$sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end'] . " 23:59:59") . "'";
		} else {
			$sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($today . " 23:59:59") . "'";
		}

		$query = $this->db->query($sql);

		return $query->row['total_sales'];
	}

	public function getTotalPurchased($data) {
		$today = date('Y-m-d');
		$language_id = $this->config->get('config_language_id');

		$filter_order_status_id_statement = !empty($data['filter_order_status_id']) ?
		"AND a.order_status_id = '" . (int)$data['filter_order_status_id'] . "'":
		"AND a.order_status_id > '0'";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND a.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_date_start_statement = !empty($data['filter_date_start']) ?
		"AND DATE(a.date_added) >= '" . $this->db->escape($data['filter_date_start'] . " 00:00:00") . "'":
		"AND DATE(a.date_added) >= '" . $this->db->escape($today . " 00:00:00") . "'";

		$filter_date_end_statement = !empty($data['filter_date_end']) ?
		"AND DATE(a.date_added) <= '" . $this->db->escape($data['filter_date_end'] . " 23:59:59") . "'":
		"AND DATE(a.date_added) <= '" . $this->db->escape($today . " 23:59:59") . "'";

		$filter_product_name_statement = !empty($data['filter_product_name']) ?
		"AND a.name LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'":
		"";

		$filter_product_code_statement = !empty($data['filter_product_code']) ?
		"AND a.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'":
		"";

		$filter_category_statement = !empty($data['filter_category']) ?
		"AND a.category LIKE '%" . $this->db->escape($data['filter_category']) . "%'":
		"";

		$sql = "
		SELECT COUNT(*) AS total FROM(
		SELECT
			*
		FROM
		(
			SELECT
				op.product_id,
				p.code,
				pd.name,
				cd.name AS category,
				p.model,
				p.product_type AS type,
				op.quantity,
				op.tax,
				op.total,
				op.price,
				o.date_added,
				o.store_id,
				o.order_status_id
			FROM " . DB_PREFIX . "order_product op
			LEFT JOIN " . DB_PREFIX . "order o
			ON (op.order_id = o.order_id)
			LEFT JOIN " . DB_PREFIX . "product p
			ON (op.product_id = p.product_id)
			LEFT JOIN " . DB_PREFIX . "product_description pd
			ON (p.product_id = pd.product_id)
			LEFT JOIN " . DB_PREFIX . "product_to_category ptc
			ON (p.product_id = ptc.product_id)
			LEFT JOIN " . DB_PREFIX . "category c
			ON (ptc.category_id = c.category_id)
			LEFT JOIN " . DB_PREFIX . "category_description cd
			ON (c.category_id = cd.category_id)
			WHERE 1
			AND pd.language_id = " . (int)$language_id . "
			AND cd.language_id = " . (int)$language_id . "
		)a
		WHERE 1
		AND a.price > 0
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_product_code_statement
		$filter_product_name_statement
		$filter_category_statement
		$filter_store_id_statement
		$filter_order_status_id_statement
		GROUP BY a.product_id
		)b";

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	//stock
	public function getProductStock($data){

		$language_id = $this->config->get('config_language_id');

		$sort 	= isset($data['sort']) ? $data['sort'] : "quantity";

		$order 	= isset($data['order']) ? $data['order'] : "DESC";

		$filter_status_id_statement = $data['filter_status_id'] !== NULL ?
		"AND a.status = '" . (int)$data['filter_status_id'] . "'":
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND pts.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_quantity_from_statement = !empty($data['filter_quantity_from']) ?
		"AND a.quantity >= '" . $this->db->escape($data['filter_quantity_from']) . "'":
		"";

		$filter_quantity_to_statement = !empty($data['filter_quantity_to']) ?
		"AND a.quantity <= '" . $this->db->escape($data['filter_quantity_to']) . "'":
		"";

		$filter_price_from_statement = !empty($data['filter_price_from']) ?
		"AND a.price >= '" . $this->db->escape($data['filter_price_from']) . "'":
		"";

		$filter_price_to_statement = !empty($data['filter_price_to']) ?
		"AND a.price <= '" . $this->db->escape($data['filter_price_to']) . "'":
		"";

		$filter_points_from_statement = !empty($data['filter_points_from']) ?
		"AND a.points >= '" . $this->db->escape($data['filter_points_from']) . "'":
		"";

		$filter_points_to_statement = !empty($data['filter_points_to']) ?
		"AND a.points <= '" . $this->db->escape($data['filter_points_to']) . "'":
		"";

		$filter_product_name_statement = !empty($data['filter_product_name']) ?
		"AND a.name LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'":
		"";

		$filter_product_code_statement = !empty($data['filter_product_code']) ?
		"AND a.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'":
		"";

		$filter_category_statement = !empty($data['filter_category']) ?
		"AND a.category LIKE '%" . $this->db->escape($data['filter_category']) . "%'":
		"";

		$filter_show_all_statement = !empty($data['filter_show_all']) ?
		"" :
		"AND a.quantity > 0";

		$limit_statement = "";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$sql = "
		SELECT
			a.product_id,
			a.code,
			a.name,
			(
				SELECT name
				FROM " . DB_PREFIX . "product_description
				WHERE 1
				AND product_id = a.product_id
				AND language_id = '2'
			) AS chinese_name,
			(
				SELECT name
				FROM " . DB_PREFIX . "product_description
				WHERE 1
				AND product_id = a.product_id
				AND language_id = '1'
			) AS english_name,
			a.category,
			a.type,
			a.quantity,
			a.price,
			a.points,
			a.status
		FROM(
			SELECT
				pts.product_id,
				p.code,
				pd.name,
				cd.name AS category,
				p.product_type AS type,
				SUM(pts.onhand_quantity) AS quantity,
				p.price,
				p.points,
				p.status
			FROM
				" . DB_PREFIX . "product_to_store pts,
				" . DB_PREFIX . "product p,
				" . DB_PREFIX . "product_description pd,
				" . DB_PREFIX . "product_to_category ptc,
				" . DB_PREFIX . "category_description cd
			WHERE 1
			AND pts.product_id = p.product_id
			AND pts.product_id = pd.product_id
			AND pts.product_id = ptc.product_id
			AND ptc.category_id = cd.category_id
			AND pd.language_id = " . (int)$language_id . "
			AND cd.language_id = " . (int)$language_id . "
			$filter_store_id_statement
			GROUP BY pts.product_id
		)a
		WHERE 1
		$filter_product_name_statement
		$filter_product_code_statement
		$filter_category_statement
		$filter_show_all_statement
		$filter_quantity_from_statement
		$filter_quantity_to_statement
		$filter_price_from_statement
		$filter_price_to_statement
		$filter_points_from_statement
		$filter_points_to_statement
		$filter_status_id_statement
		ORDER BY a.$sort $order
		$limit_statement
		";

		//tracing sql code
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getProductStockTotal($data){
		$language_id = $this->config->get('config_language_id');

		$filter_status_id_statement = !empty($data['filter_status_id']) ?
		"AND a.status = '" . (int)$data['filter_status_id'] . "'":
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND pts.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_quantity_from_statement = !empty($data['filter_quantity_from']) ?
		"AND a.quantity >= '" . $this->db->escape($data['filter_quantity_from']) . "'":
		"";

		$filter_quantity_to_statement = !empty($data['filter_quantity_to']) ?
		"AND a.quantity <= '" . $this->db->escape($data['filter_quantity_to']) . "'":
		"";

		$filter_price_from_statement = !empty($data['filter_price_from']) ?
		"AND a.price >= '" . $this->db->escape($data['filter_price_from']) . "'":
		"";

		$filter_price_to_statement = !empty($data['filter_price_to']) ?
		"AND a.price <= '" . $this->db->escape($data['filter_price_to']) . "'":
		"";

		$filter_points_from_statement = !empty($data['filter_points_from']) ?
		"AND a.points >= '" . $this->db->escape($data['filter_points_from']) . "'":
		"";

		$filter_points_to_statement = !empty($data['filter_points_to']) ?
		"AND a.points <= '" . $this->db->escape($data['filter_points_to']) . "'":
		"";

		$filter_product_name_statement = !empty($data['filter_product_name']) ?
		"AND a.name LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'":
		"";

		$filter_product_code_statement = !empty($data['filter_product_code']) ?
		"AND a.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'":
		"";

		$filter_category_statement = !empty($data['filter_category']) ?
		"AND a.category LIKE '%" . $this->db->escape($data['filter_category']) . "%'":
		"";

		$filter_show_all_statement = !empty($data['filter_show_all']) ?
		"" :
		"AND a.quantity > 0";

		$sql = "
		SELECT
			COUNT(*) AS total
		FROM(
			SELECT
				pts.product_id,
				p.code,
				pd.name,
				cd.name AS category,
				p.product_type AS type,
				SUM(pts.onhand_quantity) AS quantity,
				p.price,
				p.points,
				p.status
			FROM
				" . DB_PREFIX . "product_to_store pts,
				" . DB_PREFIX . "product p,
				" . DB_PREFIX . "product_description pd,
				" . DB_PREFIX . "product_to_category ptc,
				" . DB_PREFIX . "category_description cd
			WHERE 1
			AND pts.product_id = p.product_id
			AND pts.product_id = pd.product_id
			AND pts.product_id = ptc.product_id
			AND ptc.category_id = cd.category_id
			AND pd.language_id = " . (int)$language_id . "
			AND cd.language_id = " . (int)$language_id . "
			$filter_store_id_statement
			GROUP BY pts.product_id
		)a
		WHERE 1
		$filter_product_name_statement
		$filter_product_code_statement
		$filter_category_statement
		$filter_show_all_statement
		$filter_quantity_from_statement
		$filter_quantity_to_statement
		$filter_price_from_statement
		$filter_price_to_statement
		$filter_points_from_statement
		$filter_points_to_statement
		$filter_status_id_statement
		";

		//tracing sql code
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function getProductStockInfo($product_id, $data){
		$open_date = !empty($data['filter_open_date']) ?
		$data['filter_open_date'] :
		date('Y-m-d');
		$filter_open_date_statement = "AND a.date_added >= '" . $this->db->escape($open_date) . " 00:00:00'";

		$close_date = !empty($data['filter_close_date']) ?
		$data['filter_close_date'] :
		date('Y-m-d') . ' 23:59:59';
		$filter_close_date_statement = "AND a.date_added <= '" . $this->db->escape($close_date) . " 23:59:59'";

		$store_id = $data['filter_store_id'] != '' && $data['filter_store_id'] != '*' ? $data['filter_store_id'] : '';

		$filter_store_id_statement = $data['filter_store_id'] != '' && $data['filter_store_id'] != '*'?
		"AND a.store_id = " . $store_id :
		'';

		$limit_statement = "";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$sqlDateRange = "
		SELECT
			MIN(date_added) AS min_date,
			MAX(date_added) AS max_date
		FROM
		(
			SELECT
				*
			FROM
			(
				#stock adjustment
				SELECT
					sai.date_added,
					sai.product_id,
					sa.add_by AS id,
					CONCAT(u.firstname, ' ', u.lastname) AS name,
					1 AS person_type,
					sai.action,
					sai.qty AS quantity,
					sa.store_id,
					1 AS stock_type
				FROM
					" . DB_PREFIX . "stock_adjustment_item sai,
					" . DB_PREFIX . "stock_adjustment sa,
					" . DB_PREFIX . "user u
				WHERE sai.stock_adjustment_id = sa.stock_adjustment_id
				AND sa.add_by = u.user_id

				UNION ALL

				#stock issue
				SELECT
					sii.date_added,
					sii.product_id,
					si.add_by AS id,
					CONCAT(u.firstname, ' ', u.lastname) AS name,
					1 AS person_type,
					0 AS action,
					sii.quantity,
					si.store_id,
					1 AS stock_type
				FROM
					" . DB_PREFIX . "stock_issue_item sii,
					" . DB_PREFIX . "stock_issue si,
					" . DB_PREFIX . "user u
				WHERE sii.stock_issue_id = si.stock_issue_id
				AND si.add_by = u.user_id

				UNION ALL

				#received from store
				SELECT
					st.received_date as date_added,
					std.product_id,
					st.created_by AS id,
					CONCAT(u.firstname, ' ', u.lastname) AS name,
					1 AS person_type,
					CASE WHEN st.from_store = '" . (int)$store_id . "' THEN 1 ELSE 0 END AS action,
					std.received_quantity AS quantity,
					st.to_store AS store_id,
					2 AS stock_type
				FROM
					" . DB_PREFIX . "stock_transfer_detail std,
					" . DB_PREFIX . "stock_transfer st,
					" . DB_PREFIX . "user u
				WHERE std.stock_transfer_id = st.stock_transfer_id
				AND st.created_by = u.user_id
				AND std.received_quantity > 0

				UNION ALL

				#tranfer to store
				SELECT
					st.transfer_date as date_added,
					std.product_id,
					st.created_by AS id,
					CONCAT(u.firstname, ' ', u.lastname) AS name,
					1 AS person_type,
					CASE WHEN st.from_store = '" . (int)$store_id . "' THEN 1 ELSE 0 END AS action,
					std.transfer_quantity AS quantity,
					st.from_store AS store_id,
					2 AS stock_type
				FROM
					" . DB_PREFIX . "stock_transfer_detail std,
					" . DB_PREFIX . "stock_transfer st,
					" . DB_PREFIX . "user u
				WHERE std.stock_transfer_id = st.stock_transfer_id
				AND st.created_by = u.user_id
				AND std.transfer_quantity > 0

				UNION ALL

				#sold
				SELECT
					o.date_added,
					op.product_id,
					(
						SELECT customer_card FROM " . DB_PREFIX . "customer WHERE customer_id = o.customer_id
					)AS id,
					CONCAT(o.firstname, ' ', o.lastname) AS name,
					2 AS person_type,
					0 as action,
					(op.quantity * (op.weight * wc.value) * op.usedqty) as deduct,
					o.store_id,
					3 AS stock_type
				FROM " . DB_PREFIX . "order_product op
				LEFT JOIN " . DB_PREFIX . "order o
				ON op.order_id = o.order_id
				LEFT JOIN " . DB_PREFIX . "weight_class wc
				ON op.weight_class_id = wc.weight_class_id

				UNION ALL

				#purchase receive
				SELECT
					pr.date_added,
					prp.product_id,
					pr.add_by AS id,
					CONCAT(u.firstname, ' ', u.lastname) AS name,
					1 AS person_type,
					1 AS action,
					prp.quantity AS quantity,
					pr.store_id,
					4 AS stock_type
				FROM " . DB_PREFIX . "purchase_receive_product prp
				LEFT JOIN " . DB_PREFIX . "purchase_receive pr
				ON prp.purchase_receive_id = pr.purchase_receive_id
				LEFT JOIN " . DB_PREFIX . "user u
				ON pr.add_by = u.user_id
				WHERE 1
				AND pr.order_status_id = '5'

				UNION ALL

				#purchase invoice
				SELECT
					pi.date_added,
					pip.product_id,
					pi.add_by AS id,
					CONCAT(u.firstname, ' ', u.lastname) AS name,
					1 AS person_type,
					1 AS action,
					pip.quantity,
					pi.store_id,
					5 AS stock_type
				FROM " . DB_PREFIX . "purchase_invoice_product pip
				LEFT JOIN " . DB_PREFIX . "purchase_invoice pi
				ON pip.purchase_invoice_id = pi.purchase_invoice_id
				LEFT JOIN " . DB_PREFIX . "user u
				ON pi.add_by = u.user_id
				WHERE 1
				AND pip.product_id != 0
				AND pi.type IN (2, 3)
				AND pi.stock_affect = '1'
				AND pi.order_status_id = '5'

				UNION ALL

				#production
				SELECT
					p.date_added,
					ps.product_id,
					p.add_by AS id,
					CONCAT(u.firstname, ' ', u.lastname) AS name,
					1 AS person_type,
					0 AS action,
					ps.quantity,
					0 AS store_id,
					6 AS stock_type
				FROM " . DB_PREFIX . "production p
				LEFT JOIN " . DB_PREFIX . "production_stock ps
				ON p.production_id = ps.production_id
				LEFT JOIN " . DB_PREFIX . "user u
				ON p.add_by = u.user_id
				WHERE 1
				AND ps.product_id != 0
				AND p.status = '5'
			)a
			WHERE a.product_id = " . (int)$product_id . "
			$filter_open_date_statement
			$filter_close_date_statement
			$filter_store_id_statement
			ORDER BY a.date_added ASC
			$limit_statement
		)b
		";

		//tracing sql
		/*
		echo "<pre>";
		print_r($sqlDateRange);
		echo "</pre>";
		*/

		$queryDateRange = $this->db->query($sqlDateRange);

		//echo $this->getStock($queryDateRange->row['min_date'], $product_id, $store_id);

		$sqlSet = "SET @stock = " . (int)$this->getStock($queryDateRange->row['min_date'], $product_id, $store_id);
		$querySet = $this->db->query($sqlSet);

		$sql = "
		SELECT *,
		CASE WHEN action = 1 THEN @stock := @stock + a.quantity
		ELSE @stock := @stock - a.quantity END as balance
		FROM
		(

			#stock adjustment
			SELECT
				sai.date_added,
				sai.product_id,
				sa.invoice_prefix AS id,
				CONCAT(u.firstname, ' ', u.lastname) AS name,
				1 AS person_type,
				sai.action,
				sai.qty AS quantity,
                CASE WHEN sai.action = 1 THEN sai.qty
                ELSE NULL END as 'add',
                CASE WHEN sai.action = 1 THEN NULL
                ELSE sai.qty END as deduct,
				sa.store_id,
				1 AS stock_type
			FROM
				" . DB_PREFIX . "stock_adjustment_item sai,
				" . DB_PREFIX . "stock_adjustment sa,
				" . DB_PREFIX . "user u
			WHERE sai.stock_adjustment_id = sa.stock_adjustment_id
			AND sa.add_by = u.user_id

			UNION ALL

			#stock issue
			SELECT
				sii.date_added,
				sii.product_id,
				si.invoice_prefix AS id,
				CONCAT(u.firstname, ' ', u.lastname) AS name,
				1 AS person_type,
				0 AS action,
				sii.quantity,
				NULL as 'add',
				sii.quantity as deduct,
				si.store_id,
				1 AS stock_type
			FROM
				" . DB_PREFIX . "stock_issue_item sii,
				" . DB_PREFIX . "stock_issue si,
				" . DB_PREFIX . "user u
			WHERE sii.stock_issue_id = si.stock_issue_id
			AND si.add_by = u.user_id

			UNION ALL

			#received from store,出货
			SELECT
				st.received_date as date_added,
				std.product_id,
				st.transfer_no AS id,
				CONCAT(u.firstname, ' ', u.lastname) AS name,
				1 AS person_type,
				CASE WHEN st.from_store = '" . (int)$store_id . "' THEN 1 ELSE 0 END AS action,
				std.received_quantity AS quantity,
                CASE WHEN st.from_store = '" . (int)$store_id . "' THEN std.received_quantity ELSE NULL END AS 'add',
                CASE WHEN st.to_store = '" . (int)$store_id . "' THEN std.transfer_quantity ELSE NULL END AS deduct,
				st.to_store AS store_id,
				2 AS stock_type
			FROM
				" . DB_PREFIX . "stock_transfer_detail std,
				" . DB_PREFIX . "stock_transfer st,
				" . DB_PREFIX . "user u
			WHERE std.stock_transfer_id = st.stock_transfer_id
			AND st.created_by = u.user_id
			AND std.received_quantity > 0

			UNION ALL

			#tranfer to store,进货
			SELECT
				st.transfer_date as date_added,
				std.product_id,
				st.transfer_no AS id,
				CONCAT(u.firstname, ' ', u.lastname) AS name,
				1 AS person_type,
				CASE WHEN st.from_store = '" . (int)$store_id . "' THEN 1 ELSE 0 END AS action,
				std.transfer_quantity AS quantity,
                CASE WHEN st.from_store = '" . (int)$store_id . "' THEN std.transfer_quantity ELSE NULL END AS 'add',
                CASE WHEN st.to_store = '" . (int)$store_id . "' THEN std.transfer_quantity ELSE NULL END AS deduct,
				st.from_store AS store_id,
				2 AS stock_type
			FROM
				" . DB_PREFIX . "stock_transfer_detail std,
				" . DB_PREFIX . "stock_transfer st,
				" . DB_PREFIX . "user u
			WHERE std.stock_transfer_id = st.stock_transfer_id
			AND st.created_by = u.user_id
			AND std.transfer_quantity > 0

			UNION ALL

			#sold
			SELECT
				o.date_added,
				op.product_id,
				o.invoice_prefix AS id,
				CONCAT(o.firstname, ' ', o.lastname) AS name,
				2 AS person_type,
				0 as action,
				op.quantity,
                NULL as 'add',
                (op.quantity * (op.weight * wc.value) * op.usedqty) as deduct,
				o.store_id,
				3 AS stock_type
			FROM " . DB_PREFIX . "order_product op
			LEFT JOIN " . DB_PREFIX . "order o
			ON op.order_id = o.order_id
			LEFT JOIN " . DB_PREFIX . "weight_class wc
			ON op.weight_class_id = wc.weight_class_id

			UNION ALL

			#purchase receive
			SELECT
				pr.date_added,
				prp.product_id,
				pr.invoice_prefix AS id,
				CONCAT(u.firstname, ' ', u.lastname) AS name,
				1 AS person_type,
				1 AS action,
				prp.quantity,
				prp.quantity AS 'add',
				NULL AS deduct,
				pr.store_id,
				4 AS stock_type
			FROM " . DB_PREFIX . "purchase_receive_product prp
			LEFT JOIN " . DB_PREFIX . "purchase_receive pr
			ON prp.purchase_receive_id = pr.purchase_receive_id
			LEFT JOIN " . DB_PREFIX . "user u
			ON pr.add_by = u.user_id
			WHERE 1
			AND pr.order_status_id = '5'

			UNION ALL

			#purchase invoice
			SELECT
				pi.date_added,
				pip.product_id,
				pi.invoice_prefix AS id,
				CONCAT(u.firstname, ' ', u.lastname) AS name,
				1 AS person_type,
				1 AS action,
				pip.quantity,
				pip.quantity AS 'add',
				NULL AS deduct,
				pi.store_id,
				5 AS stock_type
			FROM " . DB_PREFIX . "purchase_invoice_product pip
			LEFT JOIN " . DB_PREFIX . "purchase_invoice pi
			ON pip.purchase_invoice_id = pi.purchase_invoice_id
			LEFT JOIN " . DB_PREFIX . "user u
			ON pi.add_by = u.user_id
			WHERE 1
			AND pip.product_id != 0
			AND pi.type IN (2, 3)
			AND pi.stock_affect = '1'
			AND pi.order_status_id = '5'

			UNION ALL

			#production
			SELECT
				p.date_added,
				ps.product_id,
				p.invoice_prefix AS id,
				CONCAT(u.firstname, ' ', u.lastname) AS name,
				1 AS person_type,
				0 AS action,
				ps.quantity,
				NULL AS 'add',
				ps.quantity AS deduct,
				0 AS store_id,
				6 AS stock_type
			FROM " . DB_PREFIX . "production p
			LEFT JOIN " . DB_PREFIX . "production_stock ps
			ON p.production_id = ps.production_id
			LEFT JOIN " . DB_PREFIX . "user u
			ON p.add_by = u.user_id
			WHERE 1
			AND ps.product_id != 0
			AND p.status = '5'
		)a
		WHERE a.product_id = " . (int)$product_id . "
		$filter_open_date_statement
		$filter_close_date_statement
		$filter_store_id_statement
		ORDER BY a.date_added ASC
		$limit_statement
		";

		//tracing sql
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/

		$query = $this->db->query($sql);
		return $query->rows;
	}

	// public function getProductStockInfoTotal($product_id, $data){
	// 	$open_date = !empty($data['filter_open_date']) ?
	// 	$data['filter_open_date'] :
	// 	date('Y-m-d');
	// 	$filter_open_date_statement = "AND a.date_added >= '" . $this->db->escape($open_date) . " 00:00:00'";

	// 	$close_date = !empty($data['filter_close_date']) ?
	// 	$data['filter_close_date'] :
	// 	date('Y-m-d') . ' 23:59:59';
	// 	$filter_close_date_statement = "AND a.date_added <= '" . $this->db->escape($close_date) . " 23:59:59'";

	// 	$store_id = $data['filter_store_id'] != '' && $data['filter_store_id'] != '*' ? $data['filter_store_id'] : '';

	// 	$filter_store_id_statement = $data['filter_store_id'] != ''  && $data['filter_store_id'] != '*'?
	// 	"AND a.store_id = " . $store_id :
	// 	'';

	// 	$sql = "
	// 	SELECT
	// 		COUNT(*) as total
	// 	FROM
	// 	(
	// 		SELECT
	// 			*
	// 		FROM
	// 		(
	// 			#stock adjustment
	// 			SELECT
	// 				sai.date_added,
	// 				sai.product_id,
	// 				sa.add_by AS id,
	// 				CONCAT(u.firstname, ' ', u.lastname) AS name,
	// 				1 AS person_type,
	// 				sai.action,
	// 				sai.qty AS quantity,
	// 				sa.store_id,
	// 				1 AS stock_type
	// 			FROM
	// 				" . DB_PREFIX . "stock_adjustment_item sai,
	// 				" . DB_PREFIX . "stock_adjustment sa,
	// 				" . DB_PREFIX . "user u
	// 			WHERE sai.stock_adjustment_id = sa.stock_adjustment_id
	// 			AND sa.add_by = u.user_id

	// 			UNION ALL

	// 			#stock issue
	// 			SELECT
	// 				sii.date_added,
	// 				sii.product_id,
	// 				si.add_by AS id,
	// 				CONCAT(u.firstname, ' ', u.lastname) AS name,
	// 				1 AS person_type,
	// 				0 AS action,
	// 				sii.quantity,
	// 				si.store_id,
	// 				1 AS stock_type
	// 			FROM
	// 				" . DB_PREFIX . "stock_issue_item sii,
	// 				" . DB_PREFIX . "stock_issue si,
	// 				" . DB_PREFIX . "user u
	// 			WHERE sii.stock_issue_id = si.stock_issue_id
	// 			AND si.add_by = u.user_id

	// 			UNION ALL

	// 			#received from store
	// 			SELECT
	// 				st.received_date as date_added,
	// 				std.product_id,
	// 				st.created_by AS id,
	// 				CONCAT(u.firstname, ' ', u.lastname) AS name,
	// 				1 AS person_type,
	// 				CASE WHEN st.from_store = '" . (int)$store_id . "' THEN 1 ELSE 0 END AS action,
	// 				std.received_quantity AS quantity,
	// 				st.to_store AS store_id,
	// 				2 AS stock_type
	// 			FROM
	// 				" . DB_PREFIX . "stock_transfer_detail std,
	// 				" . DB_PREFIX . "stock_transfer st,
	// 				" . DB_PREFIX . "user u
	// 			WHERE std.stock_transfer_id = st.stock_transfer_id
	// 			AND st.created_by = u.user_id
	// 			AND std.received_quantity > 0

	// 			UNION ALL

	// 			#tranfer to store
	// 			SELECT
	// 				st.transfer_date as date_added,
	// 				std.product_id,
	// 				st.created_by AS id,
	// 				CONCAT(u.firstname, ' ', u.lastname) AS name,
	// 				1 AS person_type,
	// 				CASE WHEN st.from_store = '" . (int)$store_id . "' THEN 1 ELSE 0 END AS action,
	// 				std.transfer_quantity AS quantity,
	// 				st.from_store AS store_id,
	// 				2 AS stock_type
	// 			FROM
	// 				" . DB_PREFIX . "stock_transfer_detail std,
	// 				" . DB_PREFIX . "stock_transfer st,
	// 				" . DB_PREFIX . "user u
	// 			WHERE std.stock_transfer_id = st.stock_transfer_id
	// 			AND st.created_by = u.user_id
	// 			AND std.transfer_quantity > 0

	// 			UNION ALL

	// 			#sold
	// 			SELECT
	// 				o.date_added,
	// 				op.product_id,
	// 				(
	// 					SELECT customer_card FROM " . DB_PREFIX . "customer WHERE customer_id = o.customer_id
	// 				)AS id,
	// 				CONCAT(o.firstname, ' ', o.lastname) AS name,
	// 				2 AS person_type,
	// 				0 as action,
	// 				(op.quantity * (op.weight * wc.value) * op.usedqty) as deduct,
	// 				o.store_id,
	// 				3 AS stock_type
	// 			FROM " . DB_PREFIX . "order_product op
	// 			LEFT JOIN " . DB_PREFIX . "order o
	// 			ON op.order_id = o.order_id
	// 			LEFT JOIN " . DB_PREFIX . "weight_class wc
	// 			ON op.weight_class_id = wc.weight_class_id

	// 			UNION ALL

	// 			#purchase receive
	// 			SELECT
	// 				pr.date_added,
	// 				prp.product_id,
	// 				pr.add_by AS id,
	// 				CONCAT(u.firstname, ' ', u.lastname) AS name,
	// 				1 AS person_type,
	// 				1 AS action,
	// 				prp.quantity,
	// 				pr.store_id,
	// 				4 AS stock_type
	// 			FROM " . DB_PREFIX . "purchase_receive_product prp
	// 			LEFT JOIN " . DB_PREFIX . "purchase_receive pr
	// 			ON prp.purchase_receive_id = pr.purchase_receive_id
	// 			LEFT JOIN " . DB_PREFIX . "user u
	// 			ON pr.add_by = u.user_id
	// 			WHERE 1
	// 			AND pr.order_status_id = '5'

	// 			UNION ALL

	// 			#purchase invoice
	// 			SELECT
	// 				pi.date_added,
	// 				pip.product_id,
	// 				pi.add_by AS id,
	// 				CONCAT(u.firstname, ' ', u.lastname) AS name,
	// 				1 AS person_type,
	// 				1 AS action,
	// 				pip.quantity,
	// 				pi.store_id,
	// 				5 AS stock_type
	// 			FROM " . DB_PREFIX . "purchase_invoice_product pip
	// 			LEFT JOIN " . DB_PREFIX . "purchase_invoice pi
	// 			ON pip.purchase_invoice_id = pi.purchase_invoice_id
	// 			LEFT JOIN " . DB_PREFIX . "user u
	// 			ON pi.add_by = u.user_id
	// 			WHERE 1
	// 			AND pip.product_id != 0
	// 			AND pi.type IN (2, 3)
	// 			AND pi.stock_affect = '1'
	// 			AND pi.order_status_id = '5'

	// 			UNION ALL
	// 			#production
	// 			SELECT
	// 				p.date_added,
	// 				ps.product_id,
	// 				p.add_by AS id,
	// 				CONCAT(u.firstname, ' ', u.lastname) AS name,
	// 				1 AS person_type,
	// 				0 AS action,
	// 				ps.quantity,
	// 				0 AS store_id,
	// 				6 AS stock_type
	// 			FROM " . DB_PREFIX . "production p
	// 			LEFT JOIN " . DB_PREFIX . "production_stock ps
	// 			ON p.production_id = ps.production_id
	// 			LEFT JOIN " . DB_PREFIX . "user u
	// 			ON p.add_by = u.user_id
	// 			WHERE 1
	// 			AND ps.product_id != 0
	// 			AND p.status = '5'
	// 		)a
	// 		WHERE a.product_id = " . (int)$product_id . "
	// 		$filter_open_date_statement
	// 		$filter_close_date_statement
	// 		$filter_store_id_statement
	// 		ORDER BY a.date_added ASC
	// 	)b
	// 	";

	// 	$query = $this->db->query($sql);
	// 	return $query->row['total'];
	// }

	public function getStock($datetime, $product_id, $store_id = '', $equal = false){
		$equal_statement = $equal ? "=" : "";

		$filter_store_id_statement = $store_id != '' && $store_id != '*'?
		"AND a.store_id = '" . (int)$store_id . "'" :
		"";

		$sql = "
		SELECT SUM(quantity) AS stock
		FROM
		(
			#stock adjustment
			SELECT
				sai.date_added,
				sai.product_id,
				case when sai.action = 1 THEN sai.qty
				ELSE (sai.qty * -1) END AS quantity,
				sa.store_id,
				'stock adjust' AS type
			FROM
				" . DB_PREFIX . "stock_adjustment_item sai,
				" . DB_PREFIX . "stock_adjustment sa
			WHERE sai.stock_adjustment_id = sa.stock_adjustment_id

			UNION ALL

			#stock issue
			SELECT
				sii.date_added,
				sii.product_id,
				(sii.quantity * -1) AS quantity,
				si.store_id,
				'stock issue' AS type
			FROM
				" . DB_PREFIX . "stock_issue_item sii,
				" . DB_PREFIX . "stock_issue si
			WHERE sii.stock_issue_id = si.stock_issue_id

			UNION ALL

			#received from store
			SELECT
				st.received_date as date_added,
				std.product_id,
				CASE WHEN st.from_store = '" . (int)$store_id . "' THEN std.received_quantity ELSE (std.received_quantity * -1) END AS quantity,
				st.to_store AS store_id,
				'store receive' AS type
			FROM
				" . DB_PREFIX . "stock_transfer_detail std,
				" . DB_PREFIX . "stock_transfer st
			WHERE std.stock_transfer_id = st.stock_transfer_id
			AND std.received_quantity > 0

			UNION ALL

			#tranfer to store store
			SELECT
				st.transfer_date as date_added,
				std.product_id,
				CASE WHEN st.to_store = '" . (int)$store_id . "' THEN (std.transfer_quantity * -1) ELSE std.transfer_quantity END AS quantity,
				st.from_store AS store_id,
				'store tranfer' AS type
			FROM
				" . DB_PREFIX . "stock_transfer_detail std,
				" . DB_PREFIX . "stock_transfer st
			WHERE std.stock_transfer_id = st.stock_transfer_id
			AND std.transfer_quantity > 0

			UNION ALL

			#sold
			SELECT
				o.date_added,
				op.product_id,
				((op.quantity * (op.weight * wc.value) * op.usedqty) * -1) AS quantity,
				o.store_id,
				'pos' AS type
			FROM " . DB_PREFIX . "order_product op
			LEFT JOIN " . DB_PREFIX . "order o
			ON op.order_id = o.order_id
			LEFT JOIN " . DB_PREFIX . "weight_class wc
			ON op.weight_class_id = wc.weight_class_id

			UNION ALL

			#purchase receive
			SELECT
				pr.date_added,
				prp.product_id,
				prp.quantity,
				pr.store_id,
				'purchase receiver' AS type
			FROM " . DB_PREFIX . "purchase_receive_product prp
			LEFT JOIN " . DB_PREFIX . "purchase_receive pr
			ON prp.purchase_receive_id = pr.purchase_receive_id
			WHERE 1
			AND pr.order_status_id = '5'

			UNION ALL

			#purchase invoice
			SELECT
				pi.date_added,
				pip.product_id,
				pip.quantity,
				pi.store_id,
				'purchase invoice' AS type
			FROM " . DB_PREFIX . "purchase_invoice_product pip
			LEFT JOIN " . DB_PREFIX . "purchase_invoice pi
			ON pip.purchase_invoice_id = pi.purchase_invoice_id
			WHERE 1
			AND stock_affect = '1'
			AND pip.product_id != '0'
			AND pi.type IN (2, 3)
			AND pi.order_status_id = '5'

			UNION ALL

			#production
			SELECT
				p.date_added,
				ps.product_id,
				ps.quantity,
				0 AS store_id,
				'production' AS type
			FROM " . DB_PREFIX . "production p
			LEFT JOIN " . DB_PREFIX . "production_stock ps
			ON p.production_id = ps.production_id
			LEFT JOIN " . DB_PREFIX . "user u
			ON p.add_by = u.user_id
			WHERE 1
			AND ps.product_id != 0
			AND p.status = '5'
		)a
		WHERE a.product_id = " . (int)$product_id . "
		AND a.date_added <" . $equal_statement . " '" . $this->db->escape($datetime) . "'
		$filter_store_id_statement
		";

		//tracing
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/
		$query = $this->db->query($sql);

		//echo "xxxxxxxx " . $query->row['stock'] . "<br />";

		return $query->row['stock'] ? $query->row['stock'] : 0;
	}

	public function productStockExists($product_id){
		$language_id = $this->config->get('config_language_id');

		$sql = "
		SELECT
			COUNT(*) AS total
		FROM(
			SELECT
				pts.product_id
			FROM
				" . DB_PREFIX . "product_to_store pts,
				" . DB_PREFIX . "product p,
				" . DB_PREFIX . "product_description pd,
				" . DB_PREFIX . "product_to_category ptc,
				" . DB_PREFIX . "category_description cd
			WHERE 1
			AND pts.product_id = p.product_id
			AND pts.product_id = pd.product_id
			AND pts.product_id = ptc.product_id
			AND ptc.category_id = cd.category_id
			AND pd.language_id = " . (int)$language_id . "
			AND cd.language_id = " . (int)$language_id . "
			GROUP BY pts.product_id
		)a
		WHERE a.product_id = " . (int)$product_id;

		$query = $this->db->query($sql);
		return $query->row['total'] > 0;
	}

	public function getOpenStock($datetime, $product_id, $store_id = ""){
		return $this->getStock($datetime, $product_id, $store_id, false);
	}

	public function getCloseStock($datetime, $product_id, $store_id = ""){
		return $this->getStock($datetime, $product_id, $store_id, true);
	}

	public function getStockCalculation($product_id, $data){
		$open_date = !empty($data['filter_open_date']) ?
		$data['filter_open_date'] :
		date('Y-m-d');
		$filter_open_date_statement = "AND a.date_added >= '" . $this->db->escape($open_date) . " 00:00:00'";

		$close_date = !empty($data['filter_close_date']) ?
		$data['filter_close_date'] :
		date('Y-m-d') . ' 23:59:59';
		$filter_close_date_statement = "AND a.date_added <= '" . $this->db->escape($close_date) . " 23:59:59'";

		$store_id = $data['filter_store_id'] != '' && $data['filter_store_id'] != '*' ? $data['filter_store_id'] : '';

		$filter_store_id_statement = $data['filter_store_id'] != '' && $data['filter_store_id'] != '*'?
		"AND a.store_id = " . $store_id :
		'';

		$sql = "
		SELECT
			SUM(a.add) AS total_add,
			SUM(a.deduct) AS total_deduct
		FROM
		(

			#stock adjustment
			SELECT
				sai.date_added,
				sai.product_id,
                CASE WHEN sai.action = 1 THEN sai.qty
                ELSE NULL END as 'add',
                CASE WHEN sai.action = 1 THEN NULL
                ELSE sai.qty END as deduct,
				sa.store_id
			FROM
				" . DB_PREFIX . "stock_adjustment_item sai,
				" . DB_PREFIX . "stock_adjustment sa
			WHERE sai.stock_adjustment_id = sa.stock_adjustment_id

			UNION ALL

			#stock issue
			SELECT
				sii.date_added,
				sii.product_id,
                NULL as 'add',
                sii.quantity as deduct,
				si.store_id
			FROM
				" . DB_PREFIX . "stock_issue_item sii,
				" . DB_PREFIX . "stock_issue si
			WHERE sii.stock_issue_id = si.stock_issue_id

			UNION ALL

			#received from store
			SELECT
				st.received_date as date_added,
				std.product_id,
                CASE WHEN st.from_store = '" . (int)$store_id . "' THEN std.received_quantity ELSE NULL END AS 'add',
                CASE WHEN st.to_store = '" . (int)$store_id . "' THEN std.received_quantity ELSE NULL END AS deduct,
				st.to_store AS store_id
			FROM
				" . DB_PREFIX . "stock_transfer_detail std,
				" . DB_PREFIX . "stock_transfer st
			WHERE std.stock_transfer_id = st.stock_transfer_id
			AND std.received_quantity > 0

			UNION ALL

			#tranfer to store
			SELECT
				st.transfer_date as date_added,
				std.product_id,
                CASE WHEN st.from_store = '" . (int)$store_id . "' THEN std.transfer_quantity ELSE NULL END AS 'add',
                CASE WHEN st.to_store = '" . (int)$store_id . "' THEN std.transfer_quantity ELSE NULL END AS deduct,
				st.from_store AS store_id
			FROM
				" . DB_PREFIX . "stock_transfer_detail std,
				" . DB_PREFIX . "stock_transfer st
			WHERE std.stock_transfer_id = st.stock_transfer_id
			AND std.transfer_quantity > 0

			UNION ALL

			#sold
			SELECT
				o.date_added,
				op.product_id,
                NULL as 'add',
               (op.quantity * (op.weight * wc.value) * op.usedqty) as deduct,
				o.store_id
			FROM " . DB_PREFIX . "order_product op
			LEFT JOIN " . DB_PREFIX . "order o
			ON op.order_id = o.order_id
			LEFT JOIN " . DB_PREFIX . "weight_class wc
			ON op.weight_class_id = wc.weight_class_id

			UNION ALL

			#purchase receive
			SELECT
				pr.date_added,
				prp.product_id,
				prp.quantity AS 'add',
				NULL AS deduct,
				pr.store_id
			FROM " . DB_PREFIX . "purchase_receive_product prp
			LEFT JOIN " . DB_PREFIX . "purchase_receive pr
			ON prp.purchase_receive_id = pr.purchase_receive_id
			WHERE 1
			AND pr.order_status_id = '5'

			UNION ALL

			#purchase invoice
			SELECT
				pi.date_added,
				pip.product_id,
				pip.quantity AS 'add',
				NULL AS deduct,
				pi.store_id
			FROM " . DB_PREFIX . "purchase_invoice_product pip
			LEFT JOIN " . DB_PREFIX . "purchase_invoice pi
			ON pip.purchase_invoice_id = pi.purchase_invoice_id
			WHERE 1
			AND pip.product_id != 0
			AND pi.type IN (2, 3)
			AND pi.stock_affect = '1'
			AND pi.order_status_id = '5'

			UNION ALL

			#production
			SELECT
				p.date_added,
				ps.product_id,
				NULL AS 'add',
				ps.quantity AS deduct,
				0 AS store_id 
			FROM " . DB_PREFIX . "production p
			LEFT JOIN " . DB_PREFIX . "production_stock ps
			ON p.production_id = ps.production_id
			LEFT JOIN " . DB_PREFIX . "user u
			ON p.add_by = u.user_id
			WHERE 1
			AND ps.product_id != 0
			AND p.status = '5'

		)a
		WHERE a.product_id = " . (int)$product_id . "
		$filter_open_date_statement
		$filter_close_date_statement
		$filter_store_id_statement
		";

		$query = $this->db->query($sql);
		return $query->row;
	}

	public function getCategoryall($data,$product_id){

		$filter_product = !empty($product_id) ?
		"AND p.product_id in (" . $product_id. ")":
		"";
		// $category = !empty($data['filter_category']) ? $data['filter_category'] : [];
		// print_r($data['filter_category']);
		// if(in_array(0,[$data['filter_category']])){
		// $filter_category = !empty($data['filter_category']) ?
		// "AND cd.category_id in  (" . $data['filter_category'] . ") or cd.category_id IS NULL  ":
		// "";
		// }else{

		$filter_category = !empty($data['filter_category']) ?
		"AND (CASE WHEN cd.category_id is NULL THEN '0' ELSE cd.category_id END) in (" . $data['filter_category'] . ")":
		"";
		// }
		//  print_r(in_array('0',$data['filter_category']));


		$category_sql = "
			SELECT 
			DISTINCT p.product_id as product_id ,
			GROUP_CONCAT(DISTINCT cd.name ,'') AS category
			FROM  " . DB_PREFIX . "product p
			LEFT JOIN " . DB_PREFIX . "product_to_category ptc
			ON p.product_id = ptc.product_id
			LEFT JOIN " . DB_PREFIX . "category_description cd
			ON ptc.category_id = cd.category_id AND cd.language_id = '" . (int) $this->config->get('config_language_id') . "'
			WHERE 1 
			$filter_product
			$filter_category
			GROUP BY p.product_id
			";

		$category_query = $this->db->query($category_sql);

		// print_r($category_query);

		$category_querys = ($category_query->rows);
		// $category_querys = array_column($category_query->rows,'product_id');

		return $category_querys;
	}

	//stock alert
	public function getProductStockAlert($data){

		$language_id = $this->config->get('config_language_id');

		$sort 	= isset($data['sort']) ? $data['sort'] : "quantity";


		$filter_search_type = !empty($data['filter_search_type']) ?
		"AND sii.remark  LIKE '%" . $this->db->escape($data['filter_search_type']) . "%'":
		"";
			$stock_issue = $this->db->query("SELECT sii.product_id as product_id FROM " . DB_PREFIX . "stock_issue si LEFT JOIN " . DB_PREFIX . "stock_issue_item sii ON si.stock_issue_id = sii.stock_issue_id WHERE 1 $filter_search_type") ;
			$stock_issues = array_column($stock_issue->rows,'product_id');
		
		$filter_status_id_statement = $data['filter_status_id'] !== NULL ?
		"AND p.status = '" . (int)$data['filter_status_id'] . "'":
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND pts.store_id = '" . (int)$data['filter_store_id'] . "'":
		"";

		$filter_price_from_statement = !empty($data['filter_price_from']) ?
		"AND p.price >= '" . $this->db->escape($data['filter_price_from']) . "'":
		"";

		$filter_price_to_statement = !empty($data['filter_price_to']) ?
		"AND p.price <= '" . $this->db->escape($data['filter_price_to']) . "'":
		"";

		$filter_search_type_statement = !empty($stock_issue->rows) ?
		"AND pts.product_id in (" . implode(',',$stock_issues) . ")":
		"";

		$filter_product_name_statement = !empty($data['filter_product_name']) ?
		"AND CONCAT(cn.name,'',en.name) LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'":
		"";

		$filter_product_code_statement = !empty($data['filter_product_code']) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'":
		"";

		// $filter_category = !empty($data['filter_category']) ?
		// "AND cd.category_id in (" . $data['filter_category'] . ")":
		// "";

		// $category_sql = "
		// 	SELECT 
		// 	DISTINCT pts.product_id as product_id ,
		// 	GROUP_CONCAT(DISTINCT cd.name) AS category
		// 	FROM  " . DB_PREFIX . "product_to_store pts
		// 	LEFT JOIN " . DB_PREFIX . "product_to_category ptc
		// 	ON pts.product_id = ptc.product_id
		// 	LEFT JOIN " . DB_PREFIX . "category_description cd
		// 	ON ptc.category_id = cd.category_id AND cd.language_id = '" . (int) $this->config->get('config_language_id') . "'
		// 	WHERE 1 
		// 	$filter_category
		// 	GROUP BY pts.product_id
		// 	";

		// $category_query = $this->db->query($category_sql);

		// // print_r($category_query);

		// $category_querys = array_column($category_query->rows,'product_id');

		// return $category_query->rows;

		$category_query = array_column($this->getCategoryall($data,[]),'product_id');

		// $category_querys = array_column($category_query,'product_id');

		$filter_category_statement = !empty($category_query) ?
		"AND pts.product_id in (" . implode(',',$category_query) . ")":
		"";

		$limit_statement = "";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$sname = $this->config->get('config_name');

		$order 	= "(SELECT SUM(onhand_quantity) FROM " . DB_PREFIX . "product_to_store WHERE product_id = pts.product_id AND store_id = '".$data['filter_store_id']."')";

		$lessvalue = "onhand_quantity - reorder_quantity";

		$sql = "
		SELECT
			CASE WHEN pts.store_id = 0 THEN '" . $this->db->escape($sname) . "' ELSE s.name END AS store_name,
			p.product_id,
			p.code,
			p.status,
			CONCAT(cn.name,'',en.name) AS name,
			cn.name AS chinesename,
			en.name AS englishname,
			pts.store_id,
			wcd.unit,
			p.product_type AS type,
			SUM(pts.onhand_quantity)  AS onhand_quantity,
			MIN(pts.reorder_quantity) AS reorder_quantity,
			( CASE WHEN SUM(pts.onhand_quantity) <= 0 then 1 WHEN SUM(pts.onhand_quantity) <= MIN(pts.reorder_quantity) THEN 1 ELSE 0 END ) AS less 
		FROM " . DB_PREFIX . "product_to_store pts
		LEFT JOIN " . DB_PREFIX . "product p
		ON pts.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description cn
		ON p.product_id = cn.product_id AND cn.language_id = '2'
		LEFT JOIN " . DB_PREFIX . "product_description en
		ON p.product_id = en.product_id AND en.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
		ON wcd.weight_class_id = p.weight_class_id AND wcd.language_id = '1'
		LEFT JOIN " . DB_PREFIX . "store s
		ON pts.store_id = s.store_id
		WHERE 1
		$filter_product_name_statement
		$filter_product_code_statement
		$filter_price_from_statement
		$filter_price_to_statement
		$filter_search_type_statement
		$filter_category_statement
		$filter_status_id_statement
		$filter_store_id_statement
		GROUP BY p.product_id, pts.store_id
		HAVING less = 1
		ORDER BY less DESC, onhand_quantity ASC, code ASC
		$limit_statement
		";

		//tracing sql code
		
		// echo "<pre>";
		// print_r($sql);	
		// echo "</pre>";
		

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getProductStockAlertTotal($data){

		$language_id = $this->config->get('config_language_id');

		$sort 	= isset($data['sort']) ? $data['sort'] : "quantity";

		$order 	= isset($data['order']) ? $data['order'] : "DESC";

		$filter_search_type = !empty($data['filter_search_type']) ?
		"AND sii.remark  LIKE '%" . $this->db->escape($data['filter_search_type']) . "%'":
		"";

			$stock_issue = $this->db->query("SELECT sii.product_id as product_id FROM " . DB_PREFIX . "stock_issue si LEFT JOIN " . DB_PREFIX . "stock_issue_item sii ON si.stock_issue_id = sii.stock_issue_id WHERE 1 $filter_search_type") ;
			$stock_issues = array_column($stock_issue->rows,'product_id');
		
		// print_r($stock_issues);
		// print_r(implode(",",$stock_issues));
		
		$filter_status_id_statement = $data['filter_status_id'] !== NULL ?
		"AND p.status = '" . (int)$data['filter_status_id'] . "'":
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND pts.store_id = '" . (int)$data['filter_store_id'] . "'":
		"";

		$filter_price_from_statement = !empty($data['filter_price_from']) ?
		"AND p.price >= '" . $this->db->escape($data['filter_price_from']) . "'":
		"";

		$filter_price_to_statement = !empty($data['filter_price_to']) ?
		"AND p.price <= '" . $this->db->escape($data['filter_price_to']) . "'":
		"";

		$filter_search_type_statement = !empty($stock_issue->rows) ?
		"AND pts.product_id in (" . implode(',',$stock_issues) . ")":
		"";

		$filter_product_name_statement = !empty($data['filter_product_name']) ?
		"AND CONCAT(cn.name,'',en.name) LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'":
		"";

		$filter_product_code_statement = !empty($data['filter_product_code']) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'":
		"";

		// $filter_category_statement = !empty($data['filter_category']) ?
		// "AND cd.name LIKE '%" . $this->db->escape($data['filter_category']) . "%'":
		// "";

		$category_query = array_column($this->getCategoryall($data,''),'product_id');

		$filter_category_statement = !empty($category_query) ?
		"AND pts.product_id in (" . implode(',',$category_query) . ")":
		"";

		$sname = $this->config->get('config_name');

		$sql = "
		SELECT COUNT(*) AS total FROM(
		SELECT
			CASE WHEN pts.store_id = 0 THEN '" . $this->db->escape($sname) . "' ELSE s.name END AS store_name,
			p.product_id,
			p.code,
			p.status,
			CONCAT(cn.name,'',en.name) as name,
			pts.store_id,
			wcd.unit,
			p.product_type AS type,
			SUM(pts.onhand_quantity)  AS onhand_quantity,
			MIN(pts.reorder_quantity) AS reorder_quantity,
			( CASE WHEN SUM(pts.onhand_quantity) <= 0 then 1 WHEN SUM(pts.onhand_quantity) <= MIN(pts.reorder_quantity) THEN 1 ELSE 0 END ) AS less 
			FROM " . DB_PREFIX . "product_to_store pts
			LEFT JOIN " . DB_PREFIX . "product p 
			ON pts.product_id = p.product_id
			LEFT JOIN " . DB_PREFIX . "product_description cn
			ON p.product_id = cn.product_id AND cn.language_id = '2'
			LEFT JOIN " . DB_PREFIX . "product_description en
			ON p.product_id = en.product_id AND en.language_id = '1'
			LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
			ON wcd.weight_class_id = p.weight_class_id
			LEFT JOIN " . DB_PREFIX . "store s
			ON pts.store_id = s.store_id
		WHERE 1
		$filter_product_name_statement
		$filter_product_code_statement
		$filter_price_from_statement
		$filter_price_to_statement
		$filter_search_type_statement
		$filter_category_statement
		$filter_status_id_statement
		$filter_store_id_statement
		GROUP BY product_id, store_id
		HAVING less = 1
		)a
		";

		//tracing sql code
		/*
		echo "<pre>";
		print_r($sql);
		echo "</pre>";
		*/

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function getProduct($product_id) {
		$sql = "SELECT pd.name, p.product_id, p.code, p.model, cd.name AS category_name, p.product_type FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON pd.product_id = p.product_id AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "' LEFT JOIN " . DB_PREFIX . "product_to_category ptc ON ptc.product_id = p.product_id LEFT JOIN " . DB_PREFIX . "category c ON c.category_id = ptc.category_id LEFT JOIN " . DB_PREFIX . "category_description cd ON cd.category_id = c.category_id AND cd.language_id = '" . (int)$this->config->get('config_language_id') . "' WHERE p.product_id = '" . (int)$product_id . "'";

		$query = $this->db->query($sql);

		return $query->row;
	}

    public function getCategories()
    {
        $query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "category_description WHERE language_id='" . (int) $this->config->get('config_language_id') . "' AND category_id ORDER BY category_id asc");

        return $query->rows;
    }
}
