<?php
class ModelReportProductStockAdjustment extends Model {
	public function getStockAdjustment($data){
		$sort 	= isset($data['sort']) ? $data['sort'] : "document_no";
		$order 	= isset($data['order']) ? $data['order'] : "ASC";
		
		$filter_document_no_start = (!empty($data['filter_document_no_start'])) ? 
		"AND sa.invoice_prefix >= '" . $this->db->escape($data['filter_document_no_start']) . "'" : 
		"";
		
		$filter_document_no_end = (!empty($data['filter_document_no_end'])) ? 
		"AND sa.invoice_prefix <= '" . $this->db->escape($data['filter_document_no_end']) . "'" : 
		"";
		
		$filter_date_from = (!empty($data['filter_date_from'])) ? 
		"AND DATE(sa.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_from']))) . "'" : 
		"";

		$filter_date_to = (!empty($data['filter_date_to'])) ? 
		"AND DATE(sa.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_to']))) . "'" : 
		"";
		
		$filter_description = (!empty($data['filter_description'])) ? 
		"AND sa.description LIKE '%" . $this->db->escape($data['filter_description']) . "%'" : 
		"";
		
		$filter_staff_name = (!empty($data['filter_staff_name'])) ? 
		"AND CONCAT(u.firstname,' ',u.lastname) LIKE '%" . $this->db->escape($data['filter_staff_name']) . "%'" : 
		"";
		
		$filter_product_code = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_product_name = (!empty($data['filter_product_name'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'" : 
		"";
		
		$filter_store_id = (!empty($data['filter_store_id'])) ? 
		"AND sa.store_id = '" . $this->db->escape($data['filter_store_id']) . "'" : 
		"";
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "SELECT 
					sa.invoice_prefix AS document_no,
					sa.date_added AS date,
					p.code AS product_code,
					pd_en.name AS english_name,
					pd_cn.name AS chinese_name,
					sai.action AS action,
					sai.qty AS adjusted_quantity,
					sa.description AS description,
					CONCAT(u.firstname,' ',u.lastname) AS staff_name
				FROM " . DB_PREFIX . "stock_adjustment sa 
				LEFT JOIN " . DB_PREFIX . "stock_adjustment_item sai 
				ON sai.stock_adjustment_id = sa.stock_adjustment_id 
				LEFT JOIN " . DB_PREFIX ."user u
				ON u.user_id = sa.add_by
				LEFT JOIN " . DB_PREFIX . "product p 
				ON p.product_id = sai.product_id 
				LEFT JOIN " . DB_PREFIX . "product_description pd_en 
				ON pd_en.product_id = p.product_id 
				AND pd_en.language_id = 1 
				LEFT JOIN " . DB_PREFIX . "product_description pd_cn 
				ON pd_cn.product_id = p.product_id 
				AND pd_cn.language_id = 2 
				WHERE 1
				$filter_document_no_start
				$filter_document_no_end
				$filter_date_from
				$filter_date_to
				$filter_description
				$filter_staff_name
				$filter_product_code
				$filter_product_name
				$filter_store_id
				ORDER BY $sort $order 
				$limit_statement";
	
		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getStockAdjustmentTotal($data){
		$filter_document_no_start = (!empty($data['filter_document_no_start'])) ? 
		"AND sa.invoice_prefix >= '" . $this->db->escape($data['filter_document_no_start']) . "'" : 
		"";
		
		$filter_document_no_end = (!empty($data['filter_document_no_end'])) ? 
		"AND sa.invoice_prefix <= '" . $this->db->escape($data['filter_document_no_end']) . "'" : 
		"";
		
		$filter_date_from = (!empty($data['filter_date_from'])) ? 
		"AND DATE(sa.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_from']))) . "'" : 
		"";

		$filter_date_to = (!empty($data['filter_date_to'])) ? 
		"AND DATE(sa.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_to']))) . "'" : 
		"";
		
		$filter_description = (!empty($data['filter_description'])) ? 
		"AND sa.description LIKE '%" . $this->db->escape($data['filter_description']) . "%'" : 
		"";
		
		$filter_staff_name = (!empty($data['filter_staff_name'])) ? 
		"AND CONCAT(u.firstname,' ',u.lastname) LIKE '%" . $this->db->escape($data['filter_staff_name']) . "%'" : 
		"";
		
		$filter_product_code = (!empty($data['filter_product_code'])) ? 
		"AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" : 
		"";
		
		$filter_product_name = (!empty($data['filter_product_name'])) ? 
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'" : 
		"";	
		
		$filter_store_id = (!empty($data['filter_store_id'])) ? 
		"AND sa.store_id = '" . $this->db->escape($data['filter_store_id']) . "'" : 
		"";
		
		$sql = "SELECT COUNT(*) AS total FROM(
				SELECT 
					sa.invoice_prefix AS document_no,
					sa.date_added AS date,
					p.code AS product_code,
					pd_en.name AS english_name,
					pd_cn.name AS chinese_name,
					sai.action AS action,
					sai.qty AS adjusted_quantity,
					sa.description AS description,
					CONCAT(u.firstname,' ',u.lastname) AS staff_name
				FROM " . DB_PREFIX . "stock_adjustment sa 
				LEFT JOIN " . DB_PREFIX . "stock_adjustment_item sai 
				ON sai.stock_adjustment_id = sa.stock_adjustment_id 
				LEFT JOIN " . DB_PREFIX ."user u
				ON u.user_id = sa.add_by
				LEFT JOIN " . DB_PREFIX . "product p 
				ON p.product_id = sai.product_id 
				LEFT JOIN " . DB_PREFIX . "product_description pd_en 
				ON pd_en.product_id = p.product_id 
				AND pd_en.language_id = 1 
				LEFT JOIN " . DB_PREFIX . "product_description pd_cn 
				ON pd_cn.product_id = p.product_id 
				AND pd_cn.language_id = 2 
				WHERE 1
				$filter_document_no_start
				$filter_document_no_end
				$filter_date_from
				$filter_date_to
				$filter_description
				$filter_staff_name
				$filter_product_code
				$filter_product_name
				$filter_store_id
				)a";
		
		$query = $this->db->query($sql);

		return $query->row['total'];
	}
}
?>