<?php
class ModelReportProductStock extends Model
{



    public function getProductStock($data)
    {

        $store_id = $data['filter_store_id'] != '' ? $data['filter_store_id'] : '';

        $store_id_statement = $data['filter_store_id'] != '' ? "AND store_id in ( " . $store_id . ")" : '';

        $location_id_statement = $data['filter_location'] != '' ? "AND location_id in (" . $data['filter_location'] . ")" : '';

        $batch_date_start_statement = $data['filter_batch_date_start'] != '' ? "AND batch_date >= '" . $data['filter_batch_date_start'] . "'" : '';

        $batch_date_end_statement = $data['filter_batch_date_end'] != '' ? "AND batch_date <= '" . $data['filter_batch_date_end'] . "'" : '';

        $filter_product_name = isset($data['filter_product_name']) ? explode(',', $data['filter_product_name']) : array();

        $filter_product_code = isset($data['filter_product_code']) ? explode(',', $data['filter_product_code']) : array();

        $category_statement = $data['filter_category'] != '' ? "AND (CASE WHEN cd.category_id is NULL THEN 0 ELSE cd.category_id END)  in (" . $data['filter_category'] . ")" : '';


        $filter_product_name_statement = "";

        foreach ($filter_product_name as $product_name) {
            $filter_product_name_statement .= empty($filter_product_name_statement) ? " CONCAT(en.name,' ',cn.name) LIKE '%" . $product_name . "%'" : " OR CONCAT(en.name,' ',cn.name) LIKE '%" . $product_name . "%'";
        }
        $filter_product_name_statement = !empty($filter_product_name_statement) ? " AND ($filter_product_name_statement)" : "";

        $filter_product_code_statement = "";

        foreach ($filter_product_code as $product_code) {
            $filter_product_code_statement .= empty($filter_product_code_statement) ? "p.code LIKE '%" . $product_code . "%'" : " OR p.code LIKE '%" . $product_code . "%'";
        }

        $filter_product_code_statement = !empty($filter_product_code_statement) ? " AND ($filter_product_code_statement)" : "";

        $sql = "
        SELECT
        p.product_id AS product_id,
        p.code AS code,
        en.name AS en_name,
        cn.name AS cn_name,
        wcd.unit,
        (CASE WHEN cd.category_id is NULL THEN 0 ELSE cd.category_id END) as category_id,
        GROUP_CONCAT(DISTINCT cd.name separator ', ')AS category,
        (CASE WHEN pts.store_id is NULL THEN 0 ELSE pts.store_id END) AS store_id,
        (CASE WHEN pts.location_id is NULL THEN 0 ELSE pts.location_id END) AS location_id,
        (CASE WHEN pts.batch_date is NULL THEN '0000-00-00' ELSE pts.batch_date END) AS batch_date,
        (CASE WHEN sum(pts.onhand_quantity) is NULL THEN 0 ELSE sum(pts.onhand_quantity) END) AS quantity
        FROM
            `oc_product` p
                LEFT JOIN
                    `oc_product_to_store` pts
                        ON p.product_id = pts.product_id
                LEFT JOIN
                    `oc_product_description` cn
                        ON p.product_id = cn.product_id AND cn.language_id = '2'
                LEFT JOIN
                    `oc_product_description` en
                        ON p.product_id = en.product_id AND en.language_id = '1'
                LEFT JOIN 
                    "  . DB_PREFIX . "product_to_category ptc
                    ON(ptc.product_id = p.product_id)
                LEFT JOIN 
                    "  . DB_PREFIX . "category_description cd
                    ON(cd.category_id = ptc.category_id
                    AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
                    )
                LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
                    ON(wcd.weight_class_id = p.weight_class_id
                    AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "'
                    )
    
            WHERE
                1
                $store_id_statement
                $location_id_statement
                $batch_date_start_statement
                $batch_date_end_statement
                $filter_product_name_statement
                $filter_product_code_statement
                $category_statement
                GROUP BY p.product_id,pts.store_id
                ORDER BY p.code ASC";
        // ,pts.location_id,pts.batch_date";

        // $sort_data = array(
        //     'product_id',
        //     'en_name',
        //     'cn_name',
        //     'code',
        //     'category',
        //     'store_id',
        //     'location_id',
        //     'batch_date',
        //     'quantity',
        // );

        // if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
        //     $sql .= " ORDER BY " . $data['sort'];
        // } else {
        //     $sql .= " ORDER BY cn_name,store_id,location_id";
        // }

        // if (isset($data['order']) && ($data['order'] == 'DESC')) {
        //     $sql .= " DESC";
        // } else {
        //     $sql .= " ASC";
        // }

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getProductStockItemAll()
    {
        $sql = "
        SELECT
        p.product_id AS product_id,
        p.code AS code,
        en.name AS en_name,
        cn.name AS cn_name,
        wcd.unit,
        cd.category_id,
        GROUP_CONCAT(DISTINCT cd.name separator ', ')AS category,
        (CASE WHEN pts.store_id is NULL THEN 0 ELSE pts.store_id END) AS store_id,
        (CASE WHEN pts.location_id is NULL THEN 0 ELSE pts.location_id END) AS location_id,
        (CASE WHEN pts.batch_date is NULL THEN '0000-00-00' ELSE pts.batch_date END) AS batch_date,
        (CASE WHEN sum(pts.onhand_quantity) is NULL THEN 0 ELSE sum(pts.onhand_quantity) END) AS quantity
        FROM
            `oc_product` p
                LEFT JOIN
                    `oc_product_to_store` pts
                        ON p.product_id = pts.product_id
                LEFT JOIN
                    `oc_product_description` cn
                        ON p.product_id = cn.product_id AND cn.language_id = '2'
                LEFT JOIN
                    `oc_product_description` en
                        ON p.product_id = en.product_id AND en.language_id = '1'
                LEFT JOIN 
                    "  . DB_PREFIX . "product_to_category ptc
                    ON(ptc.product_id = p.product_id)
                LEFT JOIN 
                    "  . DB_PREFIX . "category_description cd
                    ON(cd.category_id = ptc.category_id
                    AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
                    )
                LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
                    ON(wcd.weight_class_id = p.weight_class_id
                    AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "'
                    )
    
                GROUP BY p.product_id";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getProductStockItemSearched($data)
    {
        $store_id = $data['filter_store_id'] != '' ? $data['filter_store_id'] : '';

        $store_id_statement = $data['filter_store_id'] != '' ? "AND store_id in ( " . $store_id . ")" : '';

        $location_id_statement = $data['filter_location'] != '' ? "AND location_id in (" . $data['filter_location'] . ")" : '';

        $batch_date_start_statement = $data['filter_batch_date_start'] != '' ? "AND batch_date >= '" . $data['filter_batch_date_start'] . "'" : '';

        $batch_date_end_statement = $data['filter_batch_date_end'] != '' ? "AND batch_date <= '" . $data['filter_batch_date_end'] . "'" : '';

        $filter_product_name = isset($data['filter_product_name']) ? explode(',', $data['filter_product_name']) : array();

        $filter_product_code = isset($data['filter_product_code']) ? explode(',', $data['filter_product_code']) : array();

        $category_statement = $data['filter_category'] != '' ? "AND cd.category_id in (" . $data['filter_category'] . ")" : '';


        $filter_product_name_statement = "";

        foreach ($filter_product_name as $product_name) {
            $filter_product_name_statement .= empty($filter_product_name_statement) ? " CONCAT(en.name,' ',cn.name) LIKE '%" . $product_name . "%'" : " OR CONCAT(en.name,' ',cn.name) LIKE '%" . $product_name . "%'";
        }
        $filter_product_name_statement = !empty($filter_product_name_statement) ? " AND ($filter_product_name_statement)" : "";

        $filter_product_code_statement = "";

        foreach ($filter_product_code as $product_code) {
            $filter_product_code_statement .= empty($filter_product_code_statement) ? "p.code LIKE '%" . $product_code . "%'" : " OR p.code LIKE '%" . $product_code . "%'";
        }

        $filter_product_code_statement = !empty($filter_product_code_statement) ? " AND ($filter_product_code_statement)" : "";

        $sql = "
        SELECT
        p.product_id AS product_id,
        p.code AS code,
        en.name AS en_name,
        cn.name AS cn_name,
        wcd.unit,
        cd.category_id,
        GROUP_CONCAT(DISTINCT cd.name separator ', ')AS category,
        (CASE WHEN pts.store_id is NULL THEN 0 ELSE pts.store_id END) AS store_id,
        (CASE WHEN pts.location_id is NULL THEN 0 ELSE pts.location_id END) AS location_id,
        (CASE WHEN pts.batch_date is NULL THEN '0000-00-00' ELSE pts.batch_date END) AS batch_date,
        (CASE WHEN sum(pts.onhand_quantity) is NULL THEN 0 ELSE sum(pts.onhand_quantity) END) AS quantity
        FROM
            `oc_product` p
                LEFT JOIN
                    `oc_product_to_store` pts
                        ON p.product_id = pts.product_id
                LEFT JOIN
                    `oc_product_description` cn
                        ON p.product_id = cn.product_id AND cn.language_id = '2'
                LEFT JOIN
                    `oc_product_description` en
                        ON p.product_id = en.product_id AND en.language_id = '1'
                LEFT JOIN 
                    "  . DB_PREFIX . "product_to_category ptc
                    ON(ptc.product_id = p.product_id)
                LEFT JOIN 
                    "  . DB_PREFIX . "category_description cd
                    ON(cd.category_id = ptc.category_id
                    AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
                    )
                LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
                    ON(wcd.weight_class_id = p.weight_class_id
                    AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "'
                    )
    
            WHERE
                1
                $store_id_statement
                $location_id_statement
                $batch_date_start_statement
                $batch_date_end_statement
                $filter_product_name_statement
                $filter_product_code_statement
                $category_statement
                GROUP BY p.product_id,pts.store_id";
        // ,pts.location_id,pts.batch_date";


        $query = $this->db->query($sql);
        return $query->rows;
    }
    public function getProductStockItemSelected($product_id)
    {
        $sql = "
        SELECT
        p.product_id AS product_id,
        p.code AS code,
        en.name AS en_name,
        cn.name AS cn_name,
        wcd.unit,
        cd.category_id,
        GROUP_CONCAT(DISTINCT cd.name separator ', ')AS category,
        (CASE WHEN pts.store_id is NULL THEN 0 ELSE pts.store_id END) AS store_id,
        (CASE WHEN pts.location_id is NULL THEN 0 ELSE pts.location_id END) AS location_id,
        (CASE WHEN pts.batch_date is NULL THEN '0000-00-00' ELSE pts.batch_date END) AS batch_date,
        (CASE WHEN sum(pts.onhand_quantity) is NULL THEN 0 ELSE sum(pts.onhand_quantity) END) AS quantity
        FROM
            `oc_product` p
                LEFT JOIN
                    `oc_product_to_store` pts
                        ON p.product_id = pts.product_id
                LEFT JOIN
                    `oc_product_description` cn
                        ON p.product_id = cn.product_id AND cn.language_id = '2'
                LEFT JOIN
                    `oc_product_description` en
                        ON p.product_id = en.product_id AND en.language_id = '1'
                LEFT JOIN 
                    "  . DB_PREFIX . "product_to_category ptc
                    ON(ptc.product_id = p.product_id)
                LEFT JOIN 
                    "  . DB_PREFIX . "category_description cd
                    ON(cd.category_id = ptc.category_id
                    AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
                    )
                LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
                    ON(wcd.weight_class_id = p.weight_class_id
                    AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "'
                    )
    
                WHERE p.product_id = '" . (int)$product_id . "'";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getLocationName()
    {
        $sql = "SELECT location_id, concat(warehouse,'>',zone,'>',lot) as name
        FROM " . DB_PREFIX . "wms_location";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getLocations()
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "wms_location WHERE store_id = '" . (int)$this->session->data['store_id'] . "' ORDER BY warehouse,zone,lot");

        return $query->rows;
    }

    //get all location if user can view other store data
    public function getAllLocations()
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "wms_location ORDER BY warehouse,zone,lot");

        return $query->rows;
    }

    public function getCategories()
    {
        $query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "category_description WHERE language_id='" . (int) $this->config->get('config_language_id') . "' AND category_id ORDER BY category_id asc");

        return $query->rows;
    }

    public function getProductSummaryByStore($product_id, $store_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "product_to_store WHERE product_id='" . (int)$product_id . "' AND store_id='" . $store_id . "'";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getStock($datetime, $product_id, $store_id, $location_id, $batch_date)
    {

        $store_id_statement = " AND column_store_id ='" . (int)$store_id . "'";

        $location_id_statement = " AND column_location_id='" . (int)$location_id . "'";

        $batch_date_statement = " AND batch_date = '" . $batch_date . "'";

        $product_statement = "AND table_name.product_id = '" . (int)$product_id . "'";

        $sql = "
        SELECT
            SUM((CASE WHEN a.action = 1 THEN a.quantity ELSE (a.quantity * -1) END)) AS stock
        FROM
        (
            #stock return
            SELECT
                    'Stock Return' AS type,
                    sr.product_id,
                    sr.action,
                    sr.qty AS quantity,
                    0 AS store_id,
                    0 AS location_id,
                    '0000-00-00' AS batch_date
                FROM
                    `oc_stock_return` sr
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(sr.product_id = product.product_id )
                         LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(sr.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (sr.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (sr.product_id = en.product_id AND en.language_id = '1')
                    
                WHERE
                    1
                    " . str_replace('table_name', 'sr', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', '0', $store_id_statement) . "
                    AND sr.doc_date <  '" . $this->db->escape($datetime) . "'
                    AND sr.status   = 5

            UNION ALL
            #stock take
            SELECT
                    'Stock Take' AS type,
                    stp.product_id,
                    1 AS action,
                    stp.qty AS quantity,
                    st.store_id,
                    stp.location_id,
                    (CASE WHEN stp.batch_date is NULL THEN '0000-00-00' ELSE stp.batch_date END) AS batch_date
                FROM
                    `oc_stock_take_product` stp
                        LEFT JOIN
                            `oc_stock_take` st
                                ON stp.stock_take_id = st.stock_take_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                                ON(stp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(stp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (stp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (stp.product_id = en.product_id AND en.language_id = '1')
                    
                WHERE
                    1
                    " . str_replace('table_name', 'stp', $product_statement) . " 
                    " . str_replace('column_location_id', 'stp.location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'st.store_id', $store_id_statement) . "
                    AND st.doc_date  <  '" . $this->db->escape($datetime) . "'
                    AND st.status   = 5

            UNION ALL
            #lot transfer out
            SELECT
                    'Lot Transfer' AS type,
                    ltp.product_id,
                    0 AS action,
                    ltp.qty AS quantity,
                    lt.store_id,
                    ltp.source_location_id AS location_id,
                    (CASE WHEN ltp.batch_date is NULL THEN '0000-00-00' ELSE ltp.batch_date END) AS batch_date
                FROM
                    `oc_lot_transfer_product` ltp
                        LEFT JOIN
                            `oc_lot_transfer` lt
                                ON ltp.lot_transfer_id = lt.lot_transfer_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(ltp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(ltp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (ltp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (ltp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'ltp', $product_statement) . " 
                    " . str_replace('column_location_id', 'ltp.source_location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'lt.store_id', $store_id_statement) . "
                    AND lt.doc_date  <  '" . $this->db->escape($datetime) . "'
                    AND lt.status   = 5
            UNION ALL
            #lot transfer in
            SELECT
                    'Lot Transfer' AS type,
                    ltp.product_id,
                    1 AS action,
                    ltp.qty AS quantity,
                    lt.store_id,
                    ltp.target_location_id AS location_id,
                    (CASE WHEN ltp.batch_date is NULL THEN '0000-00-00' ELSE ltp.batch_date END) AS batch_date
                FROM
                    `oc_lot_transfer_product` ltp
                        LEFT JOIN
                            `oc_lot_transfer` lt
                                ON ltp.lot_transfer_id = lt.lot_transfer_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(ltp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(ltp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (ltp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (ltp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'ltp', $product_statement) . " 
                    " . str_replace('column_location_id', 'ltp.target_location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'lt.store_id', $store_id_statement) . "
                    AND lt.doc_date  <  '" . $this->db->escape($datetime) . "'
                    AND lt.status   = 5

            UNION ALL
            #stock received
            SELECT
                    'Stock Received' AS type,
                    srp.product_id,
                    1 AS action,
                    srp.quantity AS quantity,
                    srv.store_id,
                    srp.location_id,
                    '0000-00-00' AS batch_date
                FROM
                    `oc_stock_received_product` srp
                        LEFT JOIN
                            `oc_stock_received` srv
                                ON srp.stock_received_id = srv.stock_received_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(srp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(srp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (srp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (srp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'srp', $product_statement) . " 
                    " . str_replace('column_location_id', 'srp.location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'srv.store_id', $store_id_statement) . "
                    AND srv.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND srv.status   = 5

            UNION ALL
            #stock adjustment
            SELECT
                    'Stock Adjustment' AS type,
                    sai.product_id,
                    sai.action,
                    sai.qty AS quantity,
                    sa.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_stock_adjustment_item` sai
                        LEFT JOIN
                            `oc_stock_adjustment` sa
                                ON sai.stock_adjustment_id = sa.stock_adjustment_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(sai.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(sai.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (sai.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (sai.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'sai', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'sa.store_id', $store_id_statement) . "
                    AND sai.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND sa.status   = 5

            UNION ALL

            #stock issue
            SELECT
                    'Stock Issue' AS type,
                    sii.product_id,
                    0 AS action,
                    sii.quantity,
                    si.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_stock_issue_item` sii
                        LEFT JOIN
                            `oc_stock_issue` si
                                ON sii.stock_issue_id = si.stock_issue_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(sii.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(sii.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (sii.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (sii.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'sii', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'si.store_id', $store_id_statement) . "
                    AND sii.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND si.status   = 5

            UNION ALL

            #received from store,出货
            SELECT
                    'Stock Transfer' AS type,
                    std.product_id,
                    (CASE WHEN st.from_store = '" . (int)$store_id . "' THEN 1 ELSE 0 END) AS action,
                    std.received_quantity AS quantity,
                    st.to_store AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_stock_transfer_detail` std
                        LEFT JOIN
                            `oc_stock_transfer` st
                                ON std.stock_transfer_id = st.stock_transfer_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(std.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(std.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (std.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (std.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'std', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'st.to_store', $store_id_statement) . "
                    AND std.received_quantity > 0
                    AND st.received_date  <  '" . $this->db->escape($datetime) . "'
                    AND st.status >= 4

            UNION ALL

            #tranfer to store,进货
            SELECT
                    'Stock Transfer' AS type,
                    std.product_id,
                    (CASE WHEN st.from_store = '" . (int)$store_id . "' THEN 1 ELSE 0 END) AS action,
                    std.received_quantity AS quantity,
                    st.from_store AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_stock_transfer_detail` std
                        LEFT JOIN
                            `oc_stock_transfer` st
                                ON std.stock_transfer_id = st.stock_transfer_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(std.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(std.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (std.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (std.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'std', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'st.from_store', $store_id_statement) . "
                    AND std.received_quantity > 0
                    AND st.transfer_date  <  '" . $this->db->escape($datetime) . "'
                    AND st.status >= 4

            UNION ALL

            #sold sale order
            SELECT
                    'Order' AS type,
                    op.product_id,
                    0 as action,
                    ROUND(op.weight,2) AS quantity,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_order_product` op
                        LEFT JOIN
                            `oc_order` o
                                ON op.order_id = o.order_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(op.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(op.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (op.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (op.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'op', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'o.store_id', $store_id_statement) . "
                    AND o.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''
                    AND o.invoice_wholesaler = 0

            UNION ALL
            
            #sold order wholesaler
            SELECT
                    'Wholesale Order' AS type,
                    op.product_id,
                    0 as action,
                    ROUND(op.total_weight,2) AS quantity,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_order_product` op
                        LEFT JOIN
                            `oc_order` o
                                ON op.order_id = o.order_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(op.product_id = product.product_id )    
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(op.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (op.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (op.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'op', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'o.store_id', $store_id_statement) . "
                    AND o.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''
                    AND o.invoice_wholesaler = 1

            UNION ALL

            #herbal remedies
            SELECT
                    'Herbal Remedies' AS type,
                    csp.product_id,
                    0 as action,
                    t_weight AS quantity,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_clinicalsale_product` csp
                        LEFT JOIN
                            `oc_clinical_sale` cs
                                ON csp.clinical_sale_id = cs.clinical_sale_id
                        LEFT JOIN
                            `oc_order` o
                                ON cs.order_id = o.order_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(csp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(csp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (csp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (csp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'csp', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'o.store_id', $store_id_statement) . "
                    AND o.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''

            UNION ALL

            #purchase receive
            SELECT
                    'Purchase Received' AS type,
                    prp.product_id,
                    1 AS action,
                    prp.quantity,
                    pr.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_purchase_receive_product` prp
                        LEFT JOIN
                            `oc_purchase_receive` pr
                                ON prp.purchase_receive_id = pr.purchase_receive_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(prp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(prp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (prp.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (prp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'prp', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'pr.store_id', $store_id_statement) . "
                    AND pr.order_status_id = '5'
                    AND pr.date_added  <  '" . $this->db->escape($datetime) . "'

            UNION ALL

            #purchase invoice
            SELECT
                    'Purchase Invoice' AS type,
                    pip.product_id,
                    1 AS action,
                    pip.quantity,
                    pi.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_purchase_invoice_product` pip
                        LEFT JOIN
                            `oc_purchase_invoice` pi
                                ON pip.purchase_invoice_id = pi.purchase_invoice_id
                        LEFT JOIN " . DB_PREFIX . "product product
                            ON(pip.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(pip.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (pip.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (pip.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'pip', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'pi.store_id', $store_id_statement) . "
                    AND pip.product_id != 0
                    AND pi.type IN (3, 5, 6)
                    AND pi.stock_affect = '1'
                    AND pi.order_status_id = '5'
                    AND pi.date_added  <  '" . $this->db->escape($datetime) . "'

            UNION ALL

            #production
            SELECT
                    'Production' AS type,
                    ps.product_id,
                    0 as action,
                    ps.quantity,
                    0 AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_production` p
                        LEFT JOIN
                            `oc_production_stock` ps
                                ON ps.production_id = p.production_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(ps.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(ps.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (ps.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (ps.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'ps', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', '0', $store_id_statement) . "
                    AND ps.product_id != 0
                    AND p.status = '5'
                    AND p.date_added  <  '" . $this->db->escape($datetime) . "'

            UNION ALL

            #production add stock
            SELECT
                    'Production' AS type,
                    p.product_id,
                    1 AS action,
                    (p.actual_quantity - a.total_reject_quantity) AS quantity,
                    0 AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_production` p
                    LEFT JOIN 
                        (SELECT pro.production_id, (CASE WHEN SUM(proqc.reject_quantity) IS NULL THEN 0 ELSE SUM(proqc.reject_quantity) END) AS total_reject_quantity 
                            FROM `oc_production` pro 
                            LEFT JOIN `oc_production_qc` proqc 
                            ON proqc.production_id = pro.production_id 
                            GROUP BY pro.production_id)a 
                        ON a.production_id = p.production_id 
                    LEFT JOIN " . DB_PREFIX . "product product 
                        ON(p.product_id = product.product_id )
                    LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(p.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                    
                    LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (p.product_id = cn.product_id AND cn.language_id = '2')
                    
                    LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (p.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'p', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', '0', $store_id_statement) . "
                    AND p.product_id != 0
                    AND p.status = '5'
                    AND p.date_added  <  '" . $this->db->escape($datetime) . "'
            ) a
        WHERE 1
        $batch_date_statement
		";

        $query = $this->db->query($sql);
        return $query->row['stock'] ? $query->row['stock'] : 0;
    }

    public function updateProductQuantity($data)
    {
        foreach ($data as $row) {
            $sql = "UPDATE " . DB_PREFIX . "product_to_store
            SET onhand_quantity = '" . $row['close_qty'] . "'
            WHERE 
            product_id = '" . $row['product_id'] . "' 
            AND store_id = '" . $row['store_id'] . "'
            AND location_id = '" . $row['location_id'] . "'
            AND batch_date = '" . $row['batch_date'] . "'
            ";
            $this->db->query($sql);
            $rows_affected = $this->db->countAffected();
            if ($rows_affected > 0) {
                $this->logQtyChanged($row);
            }
        }
    }

    public function logQtyChanged($data)
    {
        $sql = "INSERT INTO " . DB_PREFIX . "product_to_store_log SET 
        product_id = '" . (int)$data['product_id'] . "',
        store_id = '" . (int)$data['store_id'] . "',
        location_id = '" . (int)$data['location_id'] . "',
        batch_date = '" . $data['batch_date'] . "',
        onhand_qty_before = '" . $data['onhand_quantity'] . "',
        onhand_qty_after = '" . $data['close_qty'] . "',
        modify_by = '" . (int)$data['modify_by'] . "',
        date_modified = NOW()
        ";
        $this->db->query($sql);
    }

    public function productdetail($product_id,$store_id) {

        $sql="
            SELECT 
                pts.product_id AS product_id,
                pts.store_id AS store_id,
                pts.location_id AS location_id,
                pts.batch_date AS batch_date,
                pts.onhand_quantity AS quantity,
                wl.warehouse AS warehouse,
                wl.lot AS lot,
                wl.zone AS zone
            FROM
            " . DB_PREFIX . "product_to_store pts
            LEFT JOIN " . DB_PREFIX . "wms_location wl
            ON pts.location_id = wl.location_id

            WHERE pts.product_id = '" . (int)$product_id . "' AND pts.store_id = '" . (int)$store_id . "'
        
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getProductOnhandQuantity($product_id,$store_id){
        $sql="
           SELECT
            
            SUM(pts.onhand_quantity) AS quantity
        FROM
        " . DB_PREFIX . "product_to_store pts

        WHERE pts.product_id = '". (int)$product_id . "' AND pts.store_id = '". (int)$store_id ."'
        ";
        $query = $this->db->query($sql);
        return $query->row['quantity'];
    }
}
