<?php
class ModelReportHerbalremediesSummaryByStock extends Model {
	public function getPaymentMethod(){
		$payment_methods = array();

		$sql = "SELECT DISTINCT payment_method FROM " . DB_PREFIX . "order";
		$query = $this->db->query($sql);

		foreach($query->rows as $payment_method) {
			$p_m = trim($payment_method['payment_method']);

			if(!empty($p_m)) $payment_methods[] = $payment_method['payment_method'];
		}

		return $payment_methods;
	}

    public function getHerbalremediesSummaryByStock($data){
		$sort 	= isset($data['sort']) ? $data['sort'] : "product_id";
		$order 	= isset($data['order']) ? $data['order'] : "ASC";

        $filter_payment_method= isset($data['filter_payment_method']) ? explode(',', $data['filter_payment_method']) : array();

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(IFNULL(o.invoice_date,o.date_added)) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(IFNULL(o.invoice_date,o.date_added)) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

        $filter_payment_status_statement = !empty($data['filter_payment_status']) ?
		"AND cs.order_action IN (" . $data['filter_payment_status'] . ")" :
		"";

		$filter_order_status_statement = !empty($data['filter_order_status']) ?
		"AND cs.clinicalsale_action in (" . $data['filter_order_status'] . ")" :
		"";

        $filter_category = !empty($data['filter_category']) ?
		"AND ptc.category_id in (" . $data['filter_category'] . ")":
		"";

        // $filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		// "AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		// "";

        $filter_payment_method_statement = "";

        foreach ($filter_payment_method as $filter_payment_methods) {
            $filter_payment_method_statement .= empty($filter_payment_method_statement) ? "o.payment_method LIKE '%" . $filter_payment_methods . "%'" : " OR o.payment_method LIKE '%" . $filter_payment_methods . "%'";
        }

        $filter_payment_method_statement = !empty($filter_payment_method_statement) ? "AND ($filter_payment_method_statement)" : "";
        

        #Used for get clinical_sale already paid based on date, payment method.
        $clinical_id = $this->db->query(" SELECT 
                cs.clinical_sale_id
            FROM `oc_clinical_sale` cs
            LEFT JOIN `oc_order` o
            ON (cs.order_id = o.order_id)
            WHERE 1
            $filter_order_status_statement     
            $filter_payment_status_statement
            $filter_date_start_statement
            $filter_date_end_statement 
            $filter_payment_method_statement");


    $clinical_ids = array_column($clinical_id->rows,'clinical_sale_id'); 
    // print_r($clinical_ids);


        #Used for get the product that in the category
        $product_id = $this->db->query("  SELECT 
                DISTINCT ptc.product_id
                FROM `oc_product_to_category` ptc
                WHERE 1 
                $filter_category ");

        $product_ids = array_column($product_id->rows,'product_id'); 


		// $filter_date_statement = "";

		// if((!empty($data['filter_date_start'])) || (!empty($data['filter_date_end']))){
		// 	$filter_date_statement = "
		// 	AND
		// 	(
		// 		(
		// 			cs.order_id != '0'";
		// 			$filter_date_statement .= (!empty($data['filter_date_start'])) ?
		// 			"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		// 			"";
		// 			$filter_date_statement .= (!empty($data['filter_date_end'])) ?
		// 			"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		// 			"";

		// 		$filter_date_statement .= "
		// 		)
		// 		OR
		// 		(
		// 			cs.order_id = '0'";
		// 			$filter_date_statement .= (!empty($data['filter_date_start'])) ?
		// 			"AND DATE(cs.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		// 			"";
		// 			$filter_date_statement .= (!empty($data['filter_date_end'])) ?
		// 			"AND DATE(cs.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		// 			"";

		// 		$filter_date_statement .= "
		// 		)
		// 	)
		// 	";
		// }

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND cs.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		

		/*$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND cs.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";*/
        if($clinical_ids != NULL){
            $clinical_id_statement = (!empty($clinical_ids)) ? 
            "AND csp.clinical_sale_id IN (". implode(",",$clinical_ids) ." )" :
            "";
        }else{
            $clinical_id_statement =  
            "AND csp.clinical_sale_id = NULL " ;
        }
       

        $product_id_statement = (!empty($product_ids)) ? 
        " AND csp.product_id IN (". implode(",",$product_ids) ." ) " :
        "";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_product_name_statement = (!empty($data['filter_product_name'])) ?
		"AND CONCAT(pd_cn.name,' ',pd_en.name) LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'" :
		"";


		$limit_statement = "";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

        #Used for get clinical sale/herbal remedies/medical record used product based on order purchased
    $sql = "SELECT 
        p.product_id,
        p.code,
        p.costprice,
        p.weight_class_id,
		p.price AS price,
        CONCAT(pd_cn.name,' ',pd_en.name) as product_name, 
        pd_cn.name AS chinese_name,
        pd_en.name AS english_name,
        (SELECT 
            GROUP_CONCAT(cd.name)
        FROM `oc_product_to_category` ptc
        LEFT JOIN `oc_category_description` cd
        ON (ptc.category_id = cd.category_id AND cd.language_id = 1)
        WHERE 1 
        AND ptc.product_id = csp.product_id GROUP BY csp.product_id) AS category,
        SUM(csp.t_weight * wc.value) as total_weight,
		SUM(csp.t_weight) as weight
        FROM oc_clinicalsale_product csp
        LEFT JOIN `oc_product` p
        ON (csp.product_id = p.product_id)
        LEFT JOIN " . DB_PREFIX . "weight_class wc
		ON p.weight_class_id = wc.weight_class_id
        LEFT JOIN `oc_product_description` pd_cn
        ON (p.product_id = pd_cn.product_id AND pd_cn.language_id = 2)
        LEFT JOIN `oc_product_description` pd_en
        ON (p.product_id = pd_en.product_id AND pd_en.language_id = 1)
        WHERE 1
        $clinical_id_statement
        $product_id_statement
        $filter_code_statement
        $filter_product_name_statement
        GROUP BY csp.product_id
        ORDER BY total_weight DESC,code ASC
        $limit_statement";

		// $sql = "
		// SELECT
		// 		csp.product_id AS product_id,
		// 		p.code AS code,
		// 		CASE WHEN (pd_en.name is NULL OR pd_en.name='') THEN '-' ELSE pd_en.name END AS en_name,
		// 		CASE WHEN (pd_cn.name is NULL OR pd_cn.name='') THEN '-' ELSE pd_cn.name END AS cn_name,
		// 		p.model,
		// 		p.costprice AS costprice,
		// 		cd.category_id AS category_id,
		// 		GROUP_CONCAT(cd.name) as category,
		// 		p.price AS price,
		// 		SUM(csp.t_weight) as weight,
		// 		p.weight_class_id AS weight_class_id,
		// 		SUM(csp.t_weight * wc.value) as total_weight,
		// 		csp.tax_code
		// 	FROM " . DB_PREFIX . "clinicalsale_product csp
		// 		LEFT JOIN " . DB_PREFIX . "clinical_sale cs 
		// 			ON csp.clinical_sale_id = cs.clinical_sale_id
		// 		LEFT JOIN " . DB_PREFIX . "product p 
		// 			ON csp.product_id = p.product_id
		// 		LEFT JOIN " . DB_PREFIX . "product_description pd_en 
		// 			ON p.product_id = pd_en.product_id AND pd_en.language_id = 1
		// 		LEFT JOIN " . DB_PREFIX . "product_description pd_cn 
		// 			ON p.product_id = pd_cn.product_id AND pd_cn.language_id = 2
		// 		LEFT JOIN " . DB_PREFIX . "weight_class wc
		// 			ON p.weight_class_id = wc.weight_class_id
		// 		LEFT JOIN " . DB_PREFIX . "order o
		// 			ON cs.order_id = o.order_id
		// 		LEFT JOIN " . DB_PREFIX . "product_to_category ptc
		// 			ON csp.product_id = ptc.product_id
		// 		LEFT JOIN " . DB_PREFIX . "category_description cd
		// 			ON ptc.category_id = cd.category_id AND cd.language_id = '" . (int)$this->config->get("config_language_id") . "'
		// 	WHERE 
		// 		1
		// 		AND cs.order_id <>''
		// 		$filter_store_id_statement
		// 		$filter_category
		// 		$filter_payment_status_statement
		// 		$filter_order_status_statement
		// 		$filter_payment_method_statement
		// 		$filter_code_statement
		// 		$filter_name_cn_statement
		// 		$filter_name_en_statement
		// 		$filter_model_statement
		// 	GROUP BY
		// 		csp.product_id,
		// 		p.code,
		// 		pd_en.name,
		// 		pd_cn.name,
		// 		p.costprice,
		// 		p.price
		// 	ORDER BY $sort $order
		// 	$limit_statement
		// ";

		// print_r($sql);

		$query = $this->db->query($sql);
       
		return $query->rows;
	}

    public function getHerbalremediesSummaryByStockTotal($data){
		$sort 	= isset($data['sort']) ? $data['sort'] : "date_added";
		$order 	= isset($data['order']) ? $data['order'] : "DESC";

        $filter_payment_method= isset($data['filter_payment_method']) ? explode(',', $data['filter_payment_method']) : array();

		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(IFNULL(o.invoice_date,o.date_added)) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(IFNULL(o.invoice_date,o.date_added)) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

        $filter_payment_status_statement = !empty($data['filter_payment_status']) ?
		"AND cs.order_action IN (" . $data['filter_payment_status'] . ")" :
		"";

		$filter_order_status_statement = !empty($data['filter_order_status']) ?
		"AND cs.clinicalsale_action in (" . $data['filter_order_status'] . ")" :
		"";

        $filter_category = !empty($data['filter_category']) ?
		"AND ptc.category_id in (" . $data['filter_category'] . ")":
		"";

        // $filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		// "AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		// "";

        $filter_payment_method_statement = "";

        foreach ($filter_payment_method as $filter_payment_methods) {
            $filter_payment_method_statement .= empty($filter_payment_method_statement) ? "o.payment_method LIKE '%" . $filter_payment_methods . "%'" : " OR o.payment_method LIKE '%" . $filter_payment_methods . "%'";
        }

        $filter_payment_method_statement = !empty($filter_payment_method_statement) ? "AND ($filter_payment_method_statement)" : "";
        

        #Used for get clinical_sale already paid based on date, payment method.
        $clinical_id = $this->db->query(" SELECT 
                cs.clinical_sale_id
            FROM `oc_clinical_sale` cs
            LEFT JOIN `oc_order` o
            ON (cs.order_id = o.order_id)
            WHERE 1
            $filter_order_status_statement     
            $filter_payment_status_statement
            $filter_date_start_statement
            $filter_date_end_statement 
            $filter_payment_method_statement");


    $clinical_ids = array_column($clinical_id->rows,'clinical_sale_id'); 
    // print_r($clinical_ids);


        #Used for get the product that in the category
        $product_id = $this->db->query("  SELECT 
                DISTINCT ptc.product_id
                FROM `oc_product_to_category` ptc
                WHERE 1 
                $filter_category ");

        $product_ids = array_column($product_id->rows,'product_id'); 

		// $filter_date_statement = "";

		// if((!empty($data['filter_date_start'])) || (!empty($data['filter_date_end']))){
		// 	$filter_date_statement = "
		// 	AND
		// 	(
		// 		(
		// 			cs.order_id != '0'";
		// 			$filter_date_statement .= (!empty($data['filter_date_start'])) ?
		// 			"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		// 			"";
		// 			$filter_date_statement .= (!empty($data['filter_date_end'])) ?
		// 			"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		// 			"";

		// 		$filter_date_statement .= "
		// 		)
		// 		OR
		// 		(
		// 			cs.order_id = '0'";
		// 			$filter_date_statement .= (!empty($data['filter_date_start'])) ?
		// 			"AND DATE(cs.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		// 			"";
		// 			$filter_date_statement .= (!empty($data['filter_date_end'])) ?
		// 			"AND DATE(cs.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		// 			"";

		// 		$filter_date_statement .= "
		// 		)
		// 	)
		// 	";
		// }

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND cs.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		/*$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND cs.order_action = '" . (int)$data['filter_payment_status'] . "'" :
		"";*/

        if($clinical_ids != NULL){
            $clinical_id_statement = (!empty($clinical_ids)) ? 
            "AND csp.clinical_sale_id IN (". implode(",",$clinical_ids) ." )" :
            "";
        }else{
            $clinical_id_statement =  
            "AND csp.clinical_sale_id = NULL " ;
        }
       

        $product_id_statement = (!empty($product_ids)) ? 
        " AND csp.product_id IN (". implode(",",$product_ids) ." ) " :
        "";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_product_name_statement = (!empty($data['filter_product_name'])) ?
		"AND CONCAT(pd_cn.name,' ',pd_en.name) LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'" :
		"";

        $sql = "SELECT COUNT(*) AS total_row
        FROM " . DB_PREFIX . "clinicalsale_product csp
        LEFT JOIN " . DB_PREFIX . "product p
        ON (csp.product_id = p.product_id)
        LEFT JOIN " . DB_PREFIX . "weight_class wc
		ON p.weight_class_id = wc.weight_class_id
        LEFT JOIN " . DB_PREFIX . "product_description pd_cn
        ON (p.product_id = pd_cn.product_id AND pd_cn.language_id = 2)
        LEFT JOIN " . DB_PREFIX . "product_description pd_en
        ON (p.product_id = pd_en.product_id AND pd_en.language_id = 1)
        WHERE 1
        $clinical_id_statement
        $product_id_statement
        $filter_code_statement
        $filter_product_name_statement
        ";

		// $sql = "
		// SELECT COUNT(*) AS total_row
		// FROM(
		// 	SELECT
		// 		csp.product_id,
		// 		p.code,
		// 		CASE WHEN (pd_en.name is NULL OR pd_en.name='') THEN '-' ELSE pd_en.name END AS en_name,
		// 		CASE WHEN (pd_cn.name is NULL OR pd_cn.name='') THEN '-' ELSE pd_cn.name END AS cn_name,
		// 		p.costprice,
		// 		p.price,
		// 		SUM(csp.t_weight) as weight,
		// 		p.weight_class_id
		// 	FROM " . DB_PREFIX . "clinicalsale_product csp
		// 	INNER JOIN " . DB_PREFIX . "clinical_sale cs
		// 	ON csp.clinical_sale_id = cs.clinical_sale_id
		// 	INNER JOIN " . DB_PREFIX . "product p
		// 	ON csp.product_id = p.product_id
		// 	INNER JOIN " . DB_PREFIX . "product_description pd_en
		// 	ON p.product_id = pd_en.product_id AND pd_en.language_id = 1
		// 	INNER JOIN " . DB_PREFIX . "product_description pd_cn
		// 	ON p.product_id = pd_cn.product_id AND pd_cn.language_id = 2
		// 	INNER JOIN " . DB_PREFIX . "weight_class wc
		// 	ON p.weight_class_id = wc.weight_class_id
		// 	LEFT JOIN " . DB_PREFIX . "order o
		// 	ON cs.order_id = o.order_id
		// 	LEFT JOIN " . DB_PREFIX . "product_to_category ptc
		// 	ON csp.product_id = ptc.product_id
		// 	WHERE 1
		// 	#AND cs.order_id != '0'
		// 	$filter_store_id_statement
		// 	$filter_payment_status_statement
		// 	$filter_order_status_statement
		// 	$filter_payment_method_statement
		// 	$filter_date_statement
		// 	$filter_code_statement
		// 	$filter_name_cn_statement
		// 	$filter_name_en_statement
		// 	$filter_model_statement
		// 	GROUP BY
		// 	csp.product_id,
		// 	p.code,
		// 	pd_en.name,
		// 	pd_cn.name,
		// 	p.costprice,
		// 	p.price
		// )a
		// ";

        // print_r($sql);

		$query = $this->db->query($sql);
		return $query->row['total_row'];
	}

    public function getHerbalremediesSummaryByStockTotalQuantity($data){
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ?
		"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
		"";

		$filter_date_end_statement = (!empty($data['filter_date_end'])) ?
		"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
		"";

		$filter_date_statement = "";

		if((!empty($data['filter_date_start'])) || (!empty($data['filter_date_end']))){
			$filter_date_statement = "
			AND
			(
				(
					cs.order_id != '0'";
					$filter_date_statement .= (!empty($data['filter_date_start'])) ?
					"AND DATE(o.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
					"";
					$filter_date_statement .= (!empty($data['filter_date_end'])) ?
					"AND DATE(o.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
					"";

				$filter_date_statement .= "
				)
				OR
				(
					cs.order_id = '0'";
					$filter_date_statement .= (!empty($data['filter_date_start'])) ?
					"AND DATE(cs.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_start']))) . "'" :
					"";
					$filter_date_statement .= (!empty($data['filter_date_end'])) ?
					"AND DATE(cs.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_end']))) . "'" :
					"";

				$filter_date_statement .= "
				)
			)
			";
		}

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND cs.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND cs.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";

		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND cs.order_action IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";

		$filter_order_status_statement = (!empty($data['filter_order_status'])) ?
		"AND cs.clinicalsale_action = '" . (int)$data['filter_order_status'] . "'" :
		"";

		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ?
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$filter_code_statement = (!empty($data['filter_code'])) ?
		"AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'" :
		"";

		$filter_name_cn_statement = (!empty($data['filter_name_cn'])) ?
		"AND pd_cn.name LIKE '%" . $this->db->escape($data['filter_name_cn']) . "%'" :
		"";

		$filter_name_en_statement = (!empty($data['filter_name_en'])) ?
		"AND pd_en.name LIKE '%" . $this->db->escape($data['filter_name_en']) . "%'" :
		"";

		$filter_model_statement = (!empty($data['filter_product_name'])) ?
		"AND p.model LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'" :
		"";

		$limit_statement = "";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$sql = "
		SELECT
			SUM(csp.t_weight * wc.value) as total_weight
		FROM " . DB_PREFIX . "clinicalsale_product csp
		INNER JOIN " . DB_PREFIX . "clinical_sale cs
		ON csp.clinical_sale_id = cs.clinical_sale_id
		INNER JOIN " . DB_PREFIX . "product p
		ON csp.product_id = p.product_id
		INNER JOIN " . DB_PREFIX . "product_description pd_en
		ON p.product_id = pd_en.product_id AND pd_en.language_id = 1
		INNER JOIN " . DB_PREFIX . "product_description pd_cn
		ON p.product_id = pd_cn.product_id AND pd_cn.language_id = 2
		INNER JOIN " . DB_PREFIX . "weight_class wc
		ON p.weight_class_id = wc.weight_class_id
		LEFT JOIN " . DB_PREFIX . "order o
		ON cs.order_id = o.order_id
		WHERE 1
		#AND cs.order_id != '0'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_order_status_statement
		$filter_payment_method_statement
		$filter_date_statement
		$filter_code_statement
		$filter_name_cn_statement
		$filter_name_en_statement
		$filter_model_statement
		";

		$query = $this->db->query($sql);
		return $query->row['total_weight'];
	}

    public function getcategory(){
		$language_id = $this->config->get('config_language_id');

		$sql = " SELECT cd.category_id as category_id , cd.name AS category_name  FROM " . DB_PREFIX . "category_description cd  WHERE cd.language_id = '" . (int)$language_id . "' ";
		$query = $this->db->query($sql);

		return $query->rows;

	}

	public function getAutocompleteProducts($data)
    {
        $return = false;
        // $sql = "";
        $sql = "
            SELECT p.code, p.price, p.costprice, p.model, p.product_id, pts.onhand_quantity, CONCAT(cn_pd.name,'',en_pd.name) AS name, cn_pd.name AS chinese_name, en_pd.name AS english_name, p.weight_class_id FROM `" . DB_PREFIX . "product` p LEFT JOIN `" . DB_PREFIX . "product_description` en_pd ON p.product_id = en_pd.product_id AND en_pd.language_id = '1' LEFT JOIN `" . DB_PREFIX . "product_description` cn_pd ON p.product_id = cn_pd.product_id AND cn_pd.language_id = '2' LEFT JOIN `" . DB_PREFIX . "product_to_store` pts ON p.product_id = pts.product_id AND pts.store_id = " . (int) $this->session->data['store_id'] . "
            
            WHERE 1 ";

        if (!empty($data['filter_name'])) {
            $sql .= " AND CONCAT(cn_pd.name,'',en_pd.name) LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
            $return = true;
        }
        if (!empty($data['filter_code'])) {
            $sql .= " AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'";
            $return = true;
        }
        if (!empty($data['filter_model'])) {
            $sql .= " AND p.model LIKE '%" . $this->db->escape($data['filter_model']) . "%'";
            $return = true;
        }
        if (!empty($data['filter_price'])) {
            $sql .= " AND p.price LIKE '%" . (float) $data['filter_price'] . "%'";
            $return = true;
        }
        if (!empty($data['filter_stock'])) {
            $sql .= " AND pts.onhand_quantity LIKE '%" . $this->db->escape($data['filter_stock']) . "%'";
            $return = true;
        }
        if (!empty($data['filter_search']) && !is_null($data['filter_search'])) {
            $sql .= " AND ( 
                CONCAT(cn_pd.name,'',en_pd.name) LIKE '%" . $this->db->escape($data['filter_search']) . "%' 
                OR p.code LIKE '%" . $this->db->escape($data['filter_search']) . "%'
                OR p.model LIKE '%" . $this->db->escape($data['filter_search']) . "%'
            )";
            $return = true;
        }
        $sql .= " GROUP BY p.product_id ORDER BY p.product_id ASC";
        if (!$return) {
            $sql .= " LIMIT 10";
        }

        $query = $this->db->query($sql);
        // echo '<pre>';
        // print_r($sql);
        // echo '</pre>';
        return $query->rows;
    }
}
