<?php
class ModelReportHerbalremedies extends Model{
	//filter by transaction
	public function getHerbalremediesByTransaction($data){

        $filter_payment_method= isset($data['filter_payment_method']) ? explode(',', $data['filter_payment_method']) : array();

		$filter_payment_method_statement = "";

        foreach ($filter_payment_method as $filter_payment_methods) {
            $filter_payment_method_statement .= empty($filter_payment_method_statement) ? "o.payment_method LIKE '%" . $filter_payment_methods . "%'" : " OR o.payment_method LIKE '%" . $filter_payment_methods . "%'";
        }

        $filter_payment_method_statement = !empty($filter_payment_method_statement) ? "AND ($filter_payment_method_statement)" : "";

		$sql = "SELECT  cs.clinical_sale_id,
		 				cs.sales_date,
						cs.invoice_prefix,
						cs.order_invoice_prefix,
						cs.collect_consultation_price AS collect_price,
						(CASE WHEN cs.collect_consultation_price = 1 THEN cs.clinicalsale_concultation ELSE 0 END) AS clinicalsale_consultation,
						c.customer_ic,
						cs.hide AS hide,
						u.user_id AS doctor_id,
						cs.clinicalsale_action AS status_id,
						cs.order_action AS payment_status,
						#os.name AS status_name,
						Date(CASE WHEN o.invoice_date IS NULL THEN o.date_added END) AS invoice_date,
						o.invoice_prefix AS invoice,
						o.payment_method,
						CONCAT(c.firstname, ' ', c.lastname) AS customer_name,
						CONCAT(u.firstname,' ',u.lastname,' ',u.chinesename) AS doctor_name,
						cs.total AS pos_total,
						(SELECT cst.value FROM oc_clinical_sale_total cst WHERE cst.clinical_sale_id = cs.clinical_sale_id AND cst.id = 1 AND cst.code = 'sub_total') AS medical_total,
						(SELECT cst.value FROM oc_clinical_sale_total cst WHERE cst.clinical_sale_id = cs.clinical_sale_id AND cst.id = 2 AND cst.code = 'sub_total') AS payment_total,
						(SELECT SUM(cst.`value`) FROM `oc_clinical_sale_total` cst  WHERE cst.`id` = 1 AND cst.`code` = 'sub_total' AND cst.`clinical_sale_id` = cs_consultation.`clinical_sale_id` ) AS medicine_total1,
						(SELECT SUM(cst.`value`)  FROM `oc_clinical_sale_total` cst   WHERE cst.`id` = 2 AND cst.`code` = 'sub_total' AND cst.`clinical_sale_id` = cs_no_consultation.`clinical_sale_id` ) AS medicine_total2,
						cs.gst AS tax,
						cs.clinicalsale_total AS total,
						cs.d_net_amount AS d_subtotal,
						cs.d_gst AS d_tax,
						cs.total_d_gst AS d_total
				FROM " . DB_PREFIX . "clinical_sale cs
				LEFT JOIN " . DB_PREFIX . "customer c
				ON cs.customer_id = c.customer_id
				LEFT JOIN " . DB_PREFIX . "user u
				ON cs.doctor_id = u.user_id
				LEFT JOIN " . DB_PREFIX . "order o
				ON cs.order_id = o.order_id
				LEFT JOIN oc_clinical_sale cs_consultation
				ON cs.clinical_sale_id = cs_consultation.clinical_sale_id AND cs_consultation.collect_consultation_price = 1
				LEFT JOIN oc_clinical_sale cs_no_consultation
				ON cs.clinical_sale_id = cs_no_consultation.clinical_sale_id  AND cs_no_consultation.collect_consultation_price = 0
				#LEFT JOIN " . DB_PREFIX . "order_status os
				#ON o.order_status_id = os.order_status_id
				WHERE 1
				$filter_payment_method_statement";

		if(!empty($data['filter_order_status_id'])) {
			$sql .= " AND cs.clinicalsale_action IN (" . $this->db->escape($data['filter_order_status_id']) . ")";
		}

		if(!empty($data['filter_date_start'])){
			$sql .= " AND DATE(cs.sales_date) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}

		if(!empty($data['filter_date_end'])){
			$sql .= " AND DATE(cs.sales_date) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		}

		if(!empty($data['filter_invoice_date_start'])){
			$sql .= " AND DATE(CASE WHEN o.invoice_date IS NULL THEN o.date_added END) >= '" . $this->db->escape($data['filter_invoice_date_start']) . "'";
		}

		if(!empty($data['filter_invoice_date_end'])){
			$sql .= " AND DATE(CASE WHEN o.invoice_date IS NULL THEN o.date_added END) <= '" . $this->db->escape($data['filter_invoice_date_end']) . "'";
		}

		if(!empty($data['filter_transaction_start'])){
			$sql .= " AND cs.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'";
		}

		if(!empty($data['filter_transaction_end'])){
			$sql .= " AND cs.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'";
		}

		if(!empty($data['filter_customer_card'])){
			$sql .= " AND c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'";
		}

	 	if(!empty($data['filter_customer_name'])){
			$sql .= " AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'";
		}

		if(!empty($data['filter_collect_consultation'])){
			$sql .= " AND cs.collect_consultation_price IN (" . $this->db->escape($data['filter_collect_consultation']) . ")";
		}

		if(!empty($data['filter_hide'])){
			$sql .= " AND cs.hide IN (" . $this->db->escape($data['filter_hide']) . ")";
		}

		if(!empty($data['filter_doctor_name'])){
			$sql .= " AND cs.doctor_id IN (" . $this->db->escape($data['filter_doctor_name']) . ")";
		}

		if($data['filter_store_id'] != ''){
			$sql .= " AND cs.store_id IN (" . $this->db->escape($data['filter_store_id']) . ")";
		}

		if(!empty($data['filter_payment_status'])){
			$sql .= " AND cs.order_action IN (" . $this->db->escape($data['filter_payment_status']) . ")";
		}

		$sort_data = array(
			'clinical_sale_id',
            'sales_date',
			'invoice_prefix',
			'invoice',
			'collect_consultation',
			'hide',
			'order_invoice_prefix',
			'collect_price',
			'payment_status',
			'status_id',
			'med_consultation',
			'invoice_date',
			'invoice',
			'invoice_date',
			'customer_ic',
            'customer_name',
			'doctor_name',
			'subtotal',
            'tax',
            'total',
			'pos_total',
            'd_subtotal',
			'd_tax',
			'd_total'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalHerbalremediesByTransaction($data){

		$filter_payment_method= isset($data['filter_payment_method']) ? explode(',', $data['filter_payment_method']) : array();

		$filter_payment_method_statement = "";

        foreach ($filter_payment_method as $filter_payment_methods) {
            $filter_payment_method_statement .= empty($filter_payment_method_statement) ? "o.payment_method LIKE '%" . $filter_payment_methods . "%'" : " OR o.payment_method LIKE '%" . $filter_payment_methods . "%'";
        }

        $filter_payment_method_statement = !empty($filter_payment_method_statement) ? "AND ($filter_payment_method_statement)" : "";
		$sql = "SELECT  cs.clinical_sale_id,
		 				cs.sales_date,
						cs.invoice_prefix,
						cs.order_invoice_prefix,
						cs.collect_consultation_price AS collect_price,
						(CASE WHEN cs.collect_consultation_price = 1 THEN cs.clinicalsale_concultation ELSE 0 END) AS clinicalsale_consultation,
						cs.hide AS hide,
						c.customer_ic,
						u.user_id AS doctor_id,
						cs.clinicalsale_action AS status_id,
						cs.order_action AS payment_status,
						#os.name AS status_name,
						Date(CASE WHEN o.invoice_date IS NULL THEN o.date_added END) AS invoice_date,
						o.invoice_prefix AS invoice,
						o.payment_method,
						CONCAT(c.firstname, ' ', c.lastname) AS customer_name,
						CONCAT(u.firstname,' ',u.lastname,' ',u.chinesename) AS doctor_name,
						cs.total AS pos_total,
						(SELECT cst.value FROM oc_clinical_sale_total cst WHERE cst.clinical_sale_id = cs.clinical_sale_id AND cst.id = 1 AND cst.code = 'sub_total') AS medical_total,
						(SELECT cst.value FROM oc_clinical_sale_total cst WHERE cst.clinical_sale_id = cs.clinical_sale_id AND cst.id = 2 AND cst.code = 'sub_total') AS payment_total,
						(SELECT SUM(cst.`value`) FROM `oc_clinical_sale_total` cst  WHERE cst.`id` = 1 AND cst.`code` = 'sub_total' AND cst.`clinical_sale_id` = cs_consultation.`clinical_sale_id` ) AS medicine_total1,
						(SELECT SUM(cst.`value`)  FROM `oc_clinical_sale_total` cst   WHERE cst.`id` = 2 AND cst.`code` = 'sub_total' AND cst.`clinical_sale_id` = cs_no_consultation.`clinical_sale_id` ) AS medicine_total2,
						cs.net_total AS subtotal,
						cs.gst AS tax,
						cs.clinicalsale_total AS total,
						cs.d_net_amount AS d_subtotal,
						cs.d_gst AS d_tax,
						cs.total_d_gst AS d_total
						
				FROM " . DB_PREFIX . "clinical_sale cs
				LEFT JOIN " . DB_PREFIX . "customer c
				ON cs.customer_id = c.customer_id
				LEFT JOIN " . DB_PREFIX . "user u
				ON cs.doctor_id = u.user_id
				LEFT JOIN " . DB_PREFIX . "order o
				ON cs.order_id = o.order_id
				LEFT JOIN oc_clinical_sale cs_consultation
				ON cs.clinical_sale_id = cs_consultation.clinical_sale_id AND cs_consultation.collect_consultation_price = 1
				LEFT JOIN oc_clinical_sale cs_no_consultation
				ON cs.clinical_sale_id = cs_no_consultation.clinical_sale_id  AND cs_no_consultation.collect_consultation_price = 0
				#LEFT JOIN " . DB_PREFIX . "order_status os
				#ON o.order_status_id = os.order_status_id
				WHERE 1
				$filter_payment_method_statement";


				if(!empty($data['filter_order_status_id'])) {
					$sql .= " AND cs.clinicalsale_action IN (" . $this->db->escape($data['filter_order_status_id']) . ")";
				}
		
				if(!empty($data['filter_date_start'])){
					$sql .= " AND DATE(cs.sales_date) >= '" . $this->db->escape($data['filter_date_start']) . "'";
				}
		
				if(!empty($data['filter_date_end'])){
					$sql .= " AND DATE(cs.sales_date) <= '" . $this->db->escape($data['filter_date_end']) . "'";
				}
		
				if(!empty($data['filter_invoice_date_start'])){
					$sql .= " AND DATE(CASE WHEN o.invoice_date IS NULL THEN o.date_added END) >= '" . $this->db->escape($data['filter_invoice_date_start']) . "'";
				}
		
				if(!empty($data['filter_invoice_date_end'])){
					$sql .= " AND DATE(CASE WHEN o.invoice_date IS NULL THEN o.date_added END) <= '" . $this->db->escape($data['filter_invoice_date_end']) . "'";
				}
		
				if(!empty($data['filter_transaction_start'])){
					$sql .= " AND cs.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'";
				}
		
				if(!empty($data['filter_transaction_end'])){
					$sql .= " AND cs.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'";
				}
		
				if(!empty($data['filter_customer_card'])){
					$sql .= " AND c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'";
				}
		
				 if(!empty($data['filter_customer_name'])){
					$sql .= " AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'";
				}
		
				if(!empty($data['filter_collect_consultation'])){
					$sql .= " AND cs.collect_consultation_price IN (" . $this->db->escape($data['filter_collect_consultation']) . ")";
				}
				if(!empty($data['filter_hide'])){
					$sql .= " AND cs.hide IN (" . $this->db->escape($data['filter_hide']) . ")";
				}
		
				if(!empty($data['filter_doctor_name'])){
					$sql .= " AND cs.doctor_id IN (" . $this->db->escape($data['filter_doctor_name']) . ")";
				}
		
				if($data['filter_store_id'] != ''){
					$sql .= " AND cs.store_id IN (" . $this->db->escape($data['filter_store_id']) . ")";
				}
		
				if(!empty($data['filter_payment_status'])){
					$sql .= " AND cs.order_action IN (" . $this->db->escape($data['filter_payment_status']) . ")";
				}
		

		$sort_data = array(
			'clinical_sale_id',
            'sales_date',
			'invoice_prefix',
			'invoice',
			'collect_consultation',
			'hide',
			'order_invoice_prefix',
			'collect_price',
			'payment_status',
			'status_id',
			'med_consultation',
			'invoice_date',
			'invoice',
			'invoice_date',
			'customer_ic',
            'customer_name',
			'doctor_name',
			'subtotal',
            'tax',
            'total',
			'pos_total',
            'd_subtotal',
			'd_tax',
			'd_total'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getHerbalremediesByDoctor($data){
		$sql = "SELECT cs.doctor_id AS doctor_id,
					   COUNT(cs.clinical_sale_id) AS total_cs,
					   (SELECT CONCAT(u.`firstname`,' ', u.`lastname`) FROM `" . DB_PREFIX . "user` u WHERE u.`user_id` = cs.`doctor_id`) AS doctor_name,
						SUM((SELECT SUM(cst.`value`) FROM `" . DB_PREFIX . "clinical_sale_total` cst WHERE cst.`code` = 'sub_total' AND cst.`id` = 1 AND cst.`clinical_sale_id` = cs.`clinical_sale_id`)) AS medical_total,
						SUM((CASE WHEN cs.`collect_consultation_price` = 1 THEN cs.`clinicalsale_concultation` ELSE 0 END)) AS consultation_total,
						SUM((SELECT SUM(cst.`value`) FROM `" . DB_PREFIX . "clinical_sale_total` cst WHERE cst.`code` = 'sub_total' AND cst.`id` = 2 AND cst.`clinical_sale_id` = cs.`clinical_sale_id`)) AS payment_total,
						sum((SELECT SUM(cst.`value`) FROM `oc_clinical_sale_total` cst  WHERE cst.`id` = 1 AND cst.`code` = 'sub_total' AND cst.`clinical_sale_id` = cs_consultation.`clinical_sale_id` )) AS medicine_total1,
						sum((SELECT SUM(cst.`value`)  FROM `oc_clinical_sale_total` cst   WHERE cst.`id` = 2 AND cst.`code` = 'sub_total' AND cst.`clinical_sale_id` = cs_no_consultation.`clinical_sale_id` )) AS medicine_total2
						FROM " . DB_PREFIX . "clinical_sale cs
						LEFT JOIN oc_clinical_sale cs_consultation
                        ON cs.clinical_sale_id = cs_consultation.clinical_sale_id AND cs_consultation.collect_consultation_price = 1
                        LEFT JOIN oc_clinical_sale cs_no_consultation
                        ON cs.clinical_sale_id = cs_no_consultation.clinical_sale_id  AND cs_no_consultation.collect_consultation_price = 0
				LEFT JOIN " . DB_PREFIX . "order o
				ON cs.order_id = o.order_id
				WHERE 1";

				

		if(!empty($data['filter_date_start'])){
			$sql .= " AND DATE(IFNULL(o.invoice_date,o.date_added)) >= DATE('" . $this->db->escape($data['filter_date_start']) . "')";
		}

		if(!empty($data['filter_date_end'])){
			$sql .= " AND DATE(IFNULL(o.invoice_date,o.date_added)) <= DATE('" . $this->db->escape($data['filter_date_end']) . "')";
		}

		if(!empty($data['filter_doctor_name'])){
			$sql .= " AND cs.doctor_id IN (" . (int)$data['filter_doctor_name'] . ")";
		}

		if(!empty($data['filter_store_id'])){
			$sql .= " AND cs.store_id IN (" . (int)$data['filter_store_id'] . ")";
		}

		if(!empty($data['filter_payment_status'])){
			$sql .= " AND cs.order_action  IN (" . $this->db->escape($data['filter_payment_status']) . ")";
		}

		if(!empty($data['filter_order_status_id'])){
			$sql .= " AND cs.clinicalsale_action  IN (" . $this->db->escape($data['filter_order_status_id']) . ")";
		}

		$sql .= " GROUP BY cs.doctor_id";

        // $sort_data = array(
        //     'doctor_id',
		// 	'name',
		// 	'total_cs',
        //     'subtotal',
        //     'tax',
        //     'total',
        //     'd_subtotal',
		// 	'd_tax',
		// 	'd_total'
		// );

		// if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
		// 	$sql .= " ORDER BY " . $data['sort'];
		// }

		// if (isset($data['order']) && ($data['order'] == 'DESC')) {
		// 	$sql .= " DESC";
		// } else {
		// 	$sql .= " ASC";
		// }

		// if (isset($data['start']) || isset($data['limit'])) {
		// 	if ($data['start'] < 0) {
		// 		$data['start'] = 0;
		// 	}

		// 	if ($data['limit'] < 1) {
		// 		$data['limit'] = 20;
		// 	}

		// 	$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		// }
		// echo"<pre>";
		// print_r($sql);
		// echo"</pre>";
		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalHerbalremediesByDoctor($data){
		$sql = "SELECT cs.doctor_id AS doctor_id,
				COUNT(cs.clinical_sale_id) AS total_cs,
				(SELECT CONCAT(u.`firstname`,' ', u.`lastname`) FROM `" . DB_PREFIX . "user` u WHERE u.`user_id` = cs.`doctor_id`) AS doctor_name,
				SUM((SELECT SUM(cst.`value`) FROM `" . DB_PREFIX . "clinical_sale_total` cst WHERE cst.`code` = 'sub_total' AND cst.`id` = 1 AND cst.`clinical_sale_id` = cs.`clinical_sale_id`)) AS medical_total,
				SUM((CASE WHEN cs.`collect_consultation_price` = 1 THEN cs.`clinicalsale_concultation` ELSE 0 END)) AS consultation_total,
				SUM((SELECT SUM(cst.`value`) FROM `" . DB_PREFIX . "clinical_sale_total` cst WHERE cst.`code` = 'sub_total' AND cst.`id` = 2 AND cst.`clinical_sale_id` = cs.`clinical_sale_id`)) AS payment_total,
				sum((SELECT SUM(cst.`value`) FROM `oc_clinical_sale_total` cst  WHERE cst.`id` = 1 AND cst.`code` = 'sub_total' AND cst.`clinical_sale_id` = cs_consultation.`clinical_sale_id` )) AS medicine_total1,
				sum((SELECT SUM(cst.`value`)  FROM `oc_clinical_sale_total` cst   WHERE cst.`id` = 2 AND cst.`code` = 'sub_total' AND cst.`clinical_sale_id` = cs_no_consultation.`clinical_sale_id` )) AS medicine_total2
				FROM " . DB_PREFIX . "clinical_sale cs
				LEFT JOIN oc_clinical_sale cs_consultation
				ON cs.clinical_sale_id = cs_consultation.clinical_sale_id AND cs_consultation.collect_consultation_price = 1
				LEFT JOIN oc_clinical_sale cs_no_consultation
				ON cs.clinical_sale_id = cs_no_consultation.clinical_sale_id  AND cs_no_consultation.collect_consultation_price = 0
		LEFT JOIN " . DB_PREFIX . "order o
		ON cs.order_id = o.order_id
		WHERE 1";
				if(!empty($data['filter_date_start'])){
					$sql .= " AND DATE(IFNULL(o.invoice_date,o.date_added)) >= DATE('" . $this->db->escape($data['filter_date_start']) . "')";
				}
		
				if(!empty($data['filter_date_end'])){
					$sql .= " AND DATE(IFNULL(o.invoice_date,o.date_added)) <= DATE('" . $this->db->escape($data['filter_date_end']) . "')";
				}
		
				if(!empty($data['filter_doctor_name'])){
					$sql .= " AND cs.doctor_id IN (" . (int)$data['filter_doctor_name'] . ")";
				}
		
				if(!empty($data['filter_store_id'])){
					$sql .= " AND cs.store_id IN (" . (int)$data['filter_store_id'] . ")";
				}
		
				if(!empty($data['filter_payment_status'])){
					$sql .= " AND cs.order_action  IN (" . $this->db->escape($data['filter_payment_status']) . ")";
				}
		
				if(!empty($data['filter_order_status_id'])){
					$sql .= " AND cs.clinicalsale_action  IN (" . $this->db->escape($data['filter_order_status_id']) . ")";
				}
		

		$sql .= " GROUP BY cs.doctor_id";

		// $sort_data = array(
        //     'doctor_id',
		// 	'name',
		// 	'total_cs',
        //     'subtotal',
        //     'tax',
        //     'total',
        //     'd_subtotal',
		// 	'd_tax',
		// 	'd_total'
		// );

		// if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
		// 	$sql .= " ORDER BY " . $data['sort'];
		// }

		// if (isset($data['order']) && ($data['order'] == 'DESC')) {
		// 	$sql .= " DESC";
		// } else {
		// 	$sql .= " ASC";
		// }
		
		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getHerbalremediesByDoctorInfo($doctor_id, $data){
		$sql = "SELECT clinical_sale_id,
					   sales_date,
					   invoice_prefix,
					   net_total AS subtotal,
					   gst AS tax,
					   clinicalsale_total AS total,
					   d_net_amount AS d_subtotal,
					   d_gst AS d_tax,
					   total_d_gst AS d_total
				FROM " . DB_PREFIX . "clinical_sale
				WHERE doctor_id = '" . (int)$doctor_id . "'";

		if(!empty($data['filter_date_start'])){
			$sql .= " AND DATE(sales_date) >= DATE('" . $this->db->escape($data['filter_date_start']) . "')";
		}

		if(!empty($data['filter_date_end'])){
			$sql .= " AND DATE(sales_date) <= DATE('" . $this->db->escape($data['filter_date_end']) . "')";
		}

		if($data['filter_store_id'] != ''){
			$sql .= " AND store_id = '" . (int)$data['filter_store_id'] . "'";
		}

		if(!empty($data['filter_payment_status'])){
			$sql .= " AND order_action = '" . (int)$data['filter_payment_status'] . "'";
		}

		if(!empty($data['filter_order_status_id'])){
			$sql .= " AND clinicalsale_action = '" . (int)$data['filter_order_status_id'] . "'";
		}

		$sort_data = array(
			'clinical_sale_id',
            'sales_date',
			'invoice_prefix',
            'subtotal',
            'tax',
            'total',
            'd_subtotal',
			'd_tax',
			'd_total'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalHerbalremediesByDoctorInfo($doctor_id, $data){
		$sql = "SELECT clinical_sale_id,
					   sales_date,
					   invoice_prefix,
					   net_total AS subtotal,
					   gst AS tax,
					   clinicalsale_total AS total,
					   d_net_amount AS d_subtotal,
					   d_gst AS d_tax,
					   total_d_gst AS d_total
				FROM " . DB_PREFIX . "clinical_sale
				WHERE doctor_id = '" . (int)$doctor_id . "'";

		if(!empty($data['filter_date_start'])){
			$sql .= " AND DATE(sales_date) >= DATE('" . $this->db->escape($data['filter_date_start']) . "')";
		}

		if(!empty($data['filter_date_end'])){
			$sql .= " AND DATE(sales_date) <= DATE('" . $this->db->escape($data['filter_date_end']) . "')";
		}

		if($data['filter_store_id'] != ''){
			$sql .= " AND store_id = '" . (int)$data['filter_store_id'] . "'";
		}

		if(!empty($data['filter_payment_status'])){
			$sql .= " AND order_action = '" . (int)$data['filter_payment_status'] . "'";
		}

		if(!empty($data['filter_order_status_id'])){
			$sql .= " AND clinicalsale_action = '" . (int)$data['filter_order_status_id'] . "'";
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}
	public function getdoctorlist(){
		$sql="SELECT u.user_id AS doctor_id, CONCAT(u.firstname,' ',u.lastname,' ',u.chinesename) AS doctor_name FROM " . DB_PREFIX . "user u WHERE  position = 2
		";
		$query = $this->db->query($sql);

		return $query->rows;
	}
	public function getcollectconsultation(){
		$sql = " SELECT DISTINCT cs.collect_consultation_price AS collect_price FROM " . DB_PREFIX . "clinical_sale cs WHERE 1 ";
		
		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getPaymentMethod(){
		$payment_methods = array();

		$sql = "SELECT DISTINCT payment_method FROM " . DB_PREFIX . "order";
		$query = $this->db->query($sql);

		foreach($query->rows as $payment_method) {
			$p_m = trim($payment_method['payment_method']);

			if(!empty($p_m)) $payment_methods[] = $payment_method['payment_method'];
		}

		return $payment_methods;
	}
	
}
?>
