<?php
class ModelReportCustomerInfo extends Model{
    public function getCustomers($data){
        $sql = "SELECT customer_id,
                       CONCAT(firstname, ' ', lastname) AS customer_name,
                       email,
                       customer_ic,
                       customer_card,
                       telephone,
                       gender,
                       date_added
                FROM " . DB_PREFIX . "customer WHERE 1";

        if(!empty($data['filter_date_start'])){
            $sql .= " AND DATE(date_added) >= DATE('" . $this->db->escape($data['filter_date_start']) . "')";
        }

        if(!empty($data['filter_date_end'])){
            $sql .= " AND DATE(date_added) <= DATE('" . $this->db->escape($data['filter_date_end']) . "')";
        }

        if(!empty($data['filter_customer_name'])){
            $sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']). "%'";
        }

        if(!empty($data['filter_customer_card'])){
            $sql .= " AND customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']). "%'";
        }

        if(!empty($data['filter_customer_ic'])){
            $sql .= " AND customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']). "%'";
        }

        if(!empty($data['filter_email'])){
            $sql .= " AND email LIKE '%" . $this->db->escape($data['filter_email']). "%'";
        }

        if(!empty($data['filter_telephone'])){
            $sql .= " AND telephone LIKE '%" . $this->db->escape($data['filter_telephone']). "%'";
        }

        if(isset($data['filter_gender'])){
            $sql .= " AND gender = '" . (int)$data['filter_gender'] . "'";
        }

        $sort_data = array(
           'customer_id',
           'customer_name',
           'gender',
           'customer_ic',
           'customer_card',
           'email',
           'date_added'
       );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		}

        if (in_array($data['sort'], $sort_data)) {
            if (isset($data['order']) && ($data['order'] == 'DESC')) {
                $sql .= " DESC";
            } else {
                $sql .= " ASC";
            }
        }		

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getHerbals($data, $customer_id){
        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_sale WHERE customer_id = '" . (int)$customer_id . "' AND clinicalsale_action= '5' AND order_action = '5'";

        if(!empty($data['filter_date_start'])){
            $sql .= " AND DATE(date_added) >= DATE('" . $this->db->escape($data['filter_date_start']) . "')";
        }

        if(!empty($data['filter_date_end'])){
            $sql .= " AND DATE(date_added) <= DATE('" . $this->db->escape($data['filter_date_end']) . "')";
        }

        if(isset($data['filter_doctor'])){
            $sql .= " AND doctor_id = '" . (int)$data['filter_doctor'] . "'";
        }

        $sql .= " ORDER BY clinical_sale_id DESC";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getServices($data, $customer_id){
        $sql = "SELECT * FROM " . DB_PREFIX . "service_form WHERE customer_id = '" . (int)$customer_id . "' AND serviceform_action = '5' AND order_action = '5'";

        if(!empty($data['filter_date_start'])){
            $sql .= " AND DATE(date_added) >= DATE('" . $this->db->escape($data['filter_date_start']) . "')";
        }

        if(!empty($data['filter_date_end'])){
            $sql .= " AND DATE(date_added) <= DATE('" . $this->db->escape($data['filter_date_end']) . "')";
        }

        $sql .= " ORDER BY service_form_id DESC";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getOrders($data, $customer_id){
        $sql = "SELECT * FROM " . DB_PREFIX . "order WHERE customer_id = '" . (int)$customer_id . "' AND order_status_id = '5'";

        if(!empty($data['filter_date_start'])){
            $sql .= " AND DATE(date_added) >= DATE('" . $this->db->escape($data['filter_date_start']) . "')";
        }

        if(!empty($data['filter_date_end'])){
            $sql .= " AND DATE(date_added) <= DATE('" . $this->db->escape($data['filter_date_end']) . "')";
        }

        $sql .= " ORDER BY order_id DESC";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getOrderTotals($order_id){
        $sql = "SELECT * FROM " . DB_PREFIX . "order_total WHERE order_id = '" . (int)$order_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getServiceItemBySevice($service_form_id, $data = array()) {
        $sql = "SELECT * FROM " . DB_PREFIX . "service_item WHERE service_form_id = '" . (int)$service_form_id . "'";

        if (!empty($data['filter_doctor'])) {
            $sql .= " AND user_id = '" . (int)$data['filter_doctor'] . "'";
        }
        
        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getClinicalService($clinicalservice_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_service cs LEFT JOIN " . DB_PREFIX . "clinical_service_description csd ON csd.clinicalservice_id = cs.clinicalservice_id AND csd.language_id = '" . (int)$this->config->get('config_language_id') . "' WHERE cs.clinicalservice_id = '" . (int)$clinicalservice_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getDoctors() {
        $sql = "SELECT * FROM " . DB_PREFIX . "user WHERE status = '1' AND position = '2'";

        $query = $this->db->query($sql);

        return $query->rows;
    }
}
?>