<?php
class ModelReportCouponRedemption extends Model {
	public function getCouponRedemptionByStock($data) {
		$language_id = $this->config->get('config_language_id');
		//$sort 	= isset($data['sort'])  ? $data['sort'] : "coupon_id";
		//$order 	= isset($data['order']) ? $data['order'] : "DESC";

		$sql 	= "SELECT crh.*, CONCAT(c.firstname, ' ', c.lastname) AS customer_name FROM `" . DB_PREFIX . "coupon_redemption_history` crh 
		LEFT JOIN oc_coupon co ON crh.coupon_id = co.coupon_id
		LEFT JOIN oc_customer c ON crh.customer_id = c.customer_id 
		LEFT JOIN oc_product p ON crh.product_id = p.product_id
		LEFT JOIN oc_product_description pd ON p.product_id = pd.product_id
		LEFT JOIN oc_store s ON crh.store_id = s.store_id
		WHERE 1 AND c.qr_code_promote <>'' AND pd.language_id = '" . (int)$language_id . "' " ;

		if (!empty($data['filter_coupon_redemption_history_id'])) {
			$sql .= " AND crh.coupon_redemption_history_id = '" . (int)$data['filter_coupon_redemption_history_id'] . "'";
		} 

		if (isset($data['filter_store_id'])) {
				$sql .= " AND crh.store_id = '" . (int)$data['filter_store_id'] . "'";
		}

		if (!empty($data['filter_coupon_redemption_status'])) {
			$sql .= " AND crh.status = '" . (int)$data['filter_coupon_redemption_status'] . "'";
		}

		if (!empty($data['filter_coupon_name'])) {
			$sql .= " AND co.name LIKE '%" . $this->db->escape($data['filter_coupon_name']) . "%'" ;
		} 

		if (!empty($data['filter_coupon_code'])) {
			$sql .= " AND co.code LIKE '%" . $this->db->escape($data['filter_coupon_code']) . "%'" ;
		} 

		if (!empty($data['filter_coupon_code'])) {
			$sql .= " AND co.code LIKE '%" . $this->db->escape($data['filter_coupon_code']) . "%'" ;
		} 

		if (!empty($data['filter_coupon_status'])) {
			$sql .= " AND co.status = '" . (int)$data['filter_coupon_status'] . "'";
		}

		if (!empty($data['filter_customer_name'])) {
			$sql .= " AND CONCAT(c.firstname, ' ' , c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'";
		}

		if (!empty($data['filter_telephone'])) {
			$sql .= " AND c.telephone = '" . $this->db->escape($data['filter_telephone']) ."'";
		}

		if (!empty($data['filter_gender'])) {
			$sql .= " AND c.gender = '" . (int)$data['filter_gender'] . "'";
		}

		if (!empty($data['filter_customer_ic'])) {
			$sql .= " AND c.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'";
		}

		if (!empty($data['filter_date_start']) && !empty($data['filter_date_end'])) {
            $sql .= " AND DATE(crh.date_added) BETWEEN DATE('" . $this->db->escape($data['filter_date_start']) . "') AND DATE('" . $this->db->escape($data['filter_date_end']) . "')";
        }

		if (!empty($data['filter_product_id'])) {
			$sql .= " AND crh.product_id = '" . (int)$data['filter_product_id'] . "'";
		}

		if (!empty($data['filter_product_name'])) {
			$sql .= " AND pd.name LIKE '%" . $this->db->escape($data['filter_product_name']) ."%'";
		}

		if (!empty($data['filter_product_code'])) {
			$sql .= " AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'";
		}

		if (!empty($data['filter_product_model'])) {
			$sql .= " AND p.model LIKE '%" . $this->db->escape($data['filter_product_model']) . "%'" ;
		}

		$sort_data = array(
			'crh.product_id',
			'pd.name',
			'customer_name',
			'c.telephone',
			'c.customer_ic',
			'co.name',
			'co.code',
			'co.status',
			'crh.status',
			'crh.date_added',
			'crh.store_id', 
			'crh.coupon_redemption_history_id'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY crh.date_added ";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC ";
		} else {
			$sql .= " ASC ";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 30;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query 	= $this->db->query($sql);
		return   $query->rows;
	}

	public function getCouponRedemptionByStockTotal($data) {
		$language_id = $this->config->get('config_language_id');
		$sort 	= isset($data['sort'])  ? $data['sort'] : "coupon_id";
		$order 	= isset($data['order']) ? $data['order'] : "DESC";
		$sql 	= "SELECT COUNT(*) AS count FROM `" . DB_PREFIX . "coupon_redemption_history` crh 
		LEFT JOIN oc_coupon co ON crh.coupon_id = co.coupon_id
		LEFT JOIN oc_customer c ON crh.customer_id = c.customer_id 
		LEFT JOIN oc_product p ON crh.product_id = p.product_id
		LEFT JOIN oc_product_description pd ON p.product_id = pd.product_id
		LEFT JOIN oc_store s ON crh.store_id = s.store_id
		WHERE 1 AND c.qr_code_promote <>'' AND pd.language_id = '" . (int)$language_id . "' " ;

		if (!empty($data['filter_coupon_redemption_history_id'])) {
			$sql .= " AND crh.coupon_redemption_history_id = '" . (int)$data['filter_coupon_redemption_history_id'] . "'";
		} 

		if (isset($data['filter_store_id'])) {
			$sql .= " AND crh.store_id = '" . (int)$data['filter_store_id'] . "'";
		}

		if (!empty($data['filter_coupon_redemption_status'])) {
			$sql .= " AND crh.status = '" . (int)$data['filter_coupon_redemption_status'] . "'";
		}

		if (!empty($data['filter_coupon_name'])) {
			$sql .= " AND co.name LIKE '%" . $this->db->escape($data['filter_coupon_name']) . "%'" ;
		} 

		if (!empty($data['filter_coupon_code'])) {
			$sql .= " AND co.code LIKE '%" . $this->db->escape($data['filter_coupon_code']) . "%'" ;
		} 

		if (!empty($data['filter_date_start']) && !empty($data['filter_date_end'])) {
            $sql .= " AND DATE(crh.date_added) BETWEEN DATE('" . $this->db->escape($data['filter_date_start']) . "') AND DATE('" . $this->db->escape($data['filter_date_end']) . "')";
        }

		if (!empty($data['filter_coupon_code'])) {
			$sql .= " AND co.code LIKE '%" . $this->db->escape($data['filter_coupon_code']) . "%'" ;
		} 

		if (!empty($data['filter_coupon_status'])) {
			$sql .= " AND co.status = '" . (int)$data['filter_coupon_status'] . "'";
		}

		if (!empty($data['filter_customer_name'])) {
			$sql .= " AND CONCAT(c.firstname, ' ' , c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'";
		}

		if (!empty($data['filter_telephone'])) {
			$sql .= " AND c.telephone = '" . $this->db->escape($data['filter_telephone']) ."'";
		}

		if (!empty($data['filter_gender'])) {
			$sql .= " AND c.gender = '" . (int)$data['filter_gender'] . "'";
		}

		if (!empty($data['filter_customer_ic'])) {
			$sql .= " AND c.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'";
		}

		if (!empty($data['filter_product_id'])) {
			$sql .= " AND crh.product_id = '" . (int)$data['filter_product_id'] . "'";
		}

		if (!empty($data['filter_product_name'])) {
			$sql .= " AND pd.name LIKE '%" . $this->db->escape($data['filter_product_name']) ."%'";
		}

		if (!empty($data['filter_product_code'])) {
			$sql .= " AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'";
		}

		if (!empty($data['filter_product_model'])) {
			$sql .= " AND p.model LIKE '%" . $this->db->escape($data['filter_product_model']) . "%'" ;
		}
		$query 	= $this->db->query($sql);
		return   $query->row['count'];
	}

	public function getCouponInfo($coupon_id) {
		$query = $this->db->query("SELECT c.coupon_id, c.name, c.code FROM `" . DB_PREFIX . "coupon` c WHERE 1 AND coupon_id = '" . (int)$coupon_id . "'");
		return $query->row;
	}

	public function getProductInfo($product_id) {
		$query = $this->db->query("SELECT p.code, p.model, p.product_id, pd.name FROM `" . DB_PREFIX . "product` p LEFT JOIN oc_product_description pd ON p.product_id = pd.product_id WHERE 1 AND p.product_id = '" . (int)$product_id . "' AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "'");
		return $query->row;
	}

	public function getStoreInfo($store_id) {
		$query = $this->db->query("SELECT s.name AS name FROM `" . DB_PREFIX . "store` s WHERE 1 AND store_id = '" . $store_id . "'");
		return $query->row;
	}

	public function getCustomerInfo($customer_id) {
		$query = $this->db->query("SELECT c.customer_id, c.gender, c.telephone, c.customer_ic, c.customer_card, CONCAT(c.firstname, ' ', c.lastname) AS name FROM `" . DB_PREFIX . "customer` c WHERE 1 AND customer_id = '" . (int)$customer_id ."'");
		return $query->row;
	}

	public function getFavouriteCustomer(){
		$query = $this->db->query("SELECT c.customer_id FROM `" . DB_PREFIX . "customer` c WHERE 1 AND c.qr_code_promote <>''");
		return $query->rows;
	}

	public function checkRedemption($customer_id){
		$query = $this->db->query("SELECT crh.customer_id FROM `" . DB_PREFIX . "coupon_redemption_history` crh WHERE 1 AND crh.customer_id = '" . (int)$customer_id . "'");
		return $query->row;
	}

	public function checkRedempted($customer_id){
		$query = $this->db->query("SELECT crh.customer_id FROM `" . DB_PREFIX . "coupon_redemption_history` crh WHERE 1 AND crh.customer_id = '" . (int)$customer_id . "' AND status = 1");
		return $query->row;
	}
}
