<?php

class ModelPrescriptionSymptom extends Model {

    public function getSymptoms($data = array()) {
        return array();
    }

    public function getSymptomList($data) {
        $sort = isset($data['sort']) ? $data['sort'] : "name";
        $order = isset($data['order']) ? $data['order'] : "ASC";
        $filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
        $filter_code = isset($data['filter_code']) ? $data['filter_code'] : false;
        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;
        $filter_pinyin = isset($data['filter_pinyin']) ? $data['filter_pinyin'] : false;
        $start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;
        $filter_name_statement = $filter_name ? "AND a.name LIKE '%" . $filter_name . "%'" : "";
        $filter_code_statement = $filter_code ? "AND " . DB_PREFIX . "symptom.code LIKE '%" . $filter_code . "%'" : "";
        $filter_pinyin_statement = $filter_pinyin ? "AND " . DB_PREFIX . "symptom.pinyin LIKE '%" . $filter_pinyin . "%'" : "";
        $filter_status_statement = $filter_status ? "AND " . DB_PREFIX . "symptom.status ='" . $filter_status . "'" : "";

        $sql = "

		SELECT *
		FROM " . DB_PREFIX . "symptom ,
		(
			SELECT *
			FROM " . DB_PREFIX . "symptom_name
			WHERE language_id = " . (int) $this->config->get('config_language_id') . "
		)a
		WHERE " . DB_PREFIX . "symptom.symptom_id = a.symptom_id
		AND " . DB_PREFIX . "symptom.parent_id = 0

		$filter_name_statement
		$filter_code_statement
		$filter_pinyin_statement
	        $filter_status_statement

		ORDER BY $sort $order

		LIMIT $start, $limit";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getSymptomItemList($symptom_id) {

        $symptomItemList = array();

        $sql = "
		SELECT *
		FROM " . DB_PREFIX . "symptom
		WHERE parent_id = $symptom_id";

        $query = $this->db->query($sql);
        $symptomItemRows = $query->rows;

        foreach ($symptomItemRows as $row => $symptomItem) {
            $data = array();
            $data["code"] = $symptomItem["code"];
            $data["pinyin"] = $symptomItem["pinyin"];
            $data["symptom_id"] = $symptomItem["symptom_id"];
            $data["symptom_name"] = array();

            $sql = "
                            
			SELECT *
			FROM " . DB_PREFIX . "symptom_name
			WHERE symptom_id = " . $symptomItem["symptom_id"];

            $query = $this->db->query($sql);

            $names = $query->rows;

            foreach ($names as $row => $name) {

                $data["symptom_name"][$name["language_id"]]["name"] = $name["name"];
            }

            $symptomItemList[] = $data;
        }

        return $symptomItemList;
    }

    public function getSymptomItem($symptom_id) {

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "symptom  d LEFT JOIN " . DB_PREFIX . "symptom_name dn ON (d.symptom_id = dn.symptom_id) WHERE d.parent_id = '" . (int) $symptom_id . "' AND dn.language_id = '" . (int) $this->config->get('config_language_id') . "'");

        return $query->rows;
    }

    public function getSymptomColumn($symptom_id, $column_name, $multirow = false, $language_id = NULL) {

        $language_id = $language_id ? $language_id : (int) $this->config->get('config_language_id');

        $sql = "

		SELECT b." . $column_name . "
		FROM(
			SELECT " . DB_PREFIX . "symptom.symptom_id, " . DB_PREFIX . "symptom.code, " . DB_PREFIX . "symptom.pinyin, a.name, " . DB_PREFIX . "symptom.sort_order, " . DB_PREFIX . "symptom.status

			FROM " . DB_PREFIX . "symptom ,
			(
				SELECT *
				FROM " . DB_PREFIX . "symptom_name
				WHERE language_id = $language_id

			)a
			WHERE " . DB_PREFIX . "symptom.symptom_id = a.symptom_id
			AND " . DB_PREFIX . "symptom.parent_id = 0
			AND " . DB_PREFIX . "symptom.symptom_id = " . $symptom_id . "
		)b";

        $query = $this->db->query($sql);

        return $multirow ? $query->rows[$column_name] : $query->row[$column_name];
    }

    public function addSymptom($data, $parent_id = 0) {
        $names = $data['symptom_name'];
        $code = $data['code'];
        $pinyin = isset($data['pinyin']) ? $data['pinyin'] : '';
        $status = isset($data['status']) ? $data['status'] : false;
        $sort_order = isset($data['sort_order']) ? $data['sort_order'] : 0;

        $symptomitems = isset($data['symptomitem']) ? $data['symptomitem'] : false;

        // insert symptom

        $sql = "INSERT INTO " . DB_PREFIX . "symptom(code, pinyin, parent_id, status, sort_order, createby, createdate)

		VALUES('$code', '$pinyin', '$parent_id', '$status', '$sort_order', '" . $this->session->data['user_id'] . "', NOW())";

        $query = $this->db->query($sql);

        // get last insert id

        $lastid = $this->db->getLastId();

        // insert symptom name

        foreach ($names as $language_id => $value) {

            $name = $value['name'];

            $sql = "INSERT INTO " . DB_PREFIX . "symptom_name(symptom_id, language_id, name)

			VALUES('$lastid', '$language_id', '$name')";

            $query = $this->db->query($sql);
        }

        // If have child, insert child

        if ($symptomitems) {

            foreach ($symptomitems as $symptomitem) {
                $symptomitem['status'] = $status;

                $this->addSymptom($symptomitem, $lastid);
            }
        }
        return $lastid;
    }

    public function editSymptom($id, $data) {
        $names = $data['symptom_name'];
        $code = $data['code'];
        $pinyin = isset($data['pinyin']) ? $data['pinyin'] : '';
        $status = isset($data['status']) ? $data['status'] : false;
        $sort_order = isset($data['sort_order']) ? $data['sort_order'] : 0;

        $symptomitems = isset($data['symptomitem']) ? $data['symptomitem'] : false;

        $sql = "

		UPDATE " . DB_PREFIX . "symptom SET
		code = '$code',
		pinyin = '$pinyin',
		status = '$status',
		sort_order = '$sort_order',
		modifyby = '" . $this->session->data['user_id'] . "',
		modifydate = NOW()
		WHERE symptom_id = '$id'
		";

        $query = $this->db->query($sql);

        foreach ($names as $language_id => $value) {
            $newname = $value['name'];
            $sql = "
			UPDATE " . DB_PREFIX . "symptom_name SET
			name = '$newname'
			WHERE symptom_id = '$id'
			AND language_id = $language_id
			";

            $query = $this->db->query($sql);
        }

        if ($symptomitems) {
            $survive_id = array();
            $updated_data = array();
            $new_data = array();
            $removed_data = array();

            foreach ($symptomitems as $symptomitempos => $symptomitem) {

                if (!empty($symptomitem["symptom_id"])) {

                    $symptomitem['status'] = $status;

                    $survive_id[] = $symptomitem["symptom_id"]; //track for survice symptom

                    $updated_data[] = array(//track for update symptom
                        'symptom_id' => $symptomitem["symptom_id"],
                        'data' => $symptomitem
                    );
                } else {

                    $symptomitem['status'] = $status;
                    $new_data[] = array(//track for new symptom
                        'data' => $symptomitem,
                        'parent_id' => $id
                    );
                }
            }

            $survive_id_statement = !empty($survive_id) ?
                    "AND symptom_id NOT IN('" . implode("','", $survive_id) . "')" :
                    NULL;

            $sql = "
			SELECT symptom_id
			FROM " . DB_PREFIX . "symptom
			WHERE parent_id = $id
			$survive_id_statement
			";

            $query = $this->db->query($sql);

            $outdatedSymptom = $query->rows;

            foreach ($outdatedSymptom as $osymptom)
                $this->deleteSymptom($osymptom['symptom_id']);

            foreach ($updated_data as $data)
                $this->editSymptom($data['symptom_id'], $data['data']);

            foreach ($new_data as $data)
                $this->addSymptom($data['data'], $data['parent_id']);
        } else {

            $sql = "
			SELECT COUNT(*) as total
			FROM " . DB_PREFIX . "symptom
			WHERE parent_id = $id
			";

            $query = $this->db->query($sql);
            $total = $query->row['total'];

            if ($total > 0) {
                $sql = "DELETE FROM " . DB_PREFIX . "symptom WHERE parent_id = $id";
                $query = $this->db->query($sql); //kill all child
            }
        }
    }

    public function deleteSymptom($symptom_id) {

        //$this->event->trigger('pre.admin.category.delete', $symptom_id);

        $sql = "
		SELECT symptom_id
		FROM " . DB_PREFIX . "symptom
		WHERE symptom_id = $symptom_id
		OR parent_id = $symptom_id
		";

        $query = $this->db->query($sql);

        $rows = $query->rows;

        foreach ($rows as $row => $row_data) {

            $row_id = $row_data['symptom_id'];

            $sql = "

			DELETE FROM " . DB_PREFIX . "symptom_name
			WHERE symptom_id = $row_id";

            $query = $this->db->query($sql);
        }


        $sql = "
		DELETE FROM " . DB_PREFIX . "symptom
		WHERE symptom_id = $symptom_id
		OR parent_id = $symptom_id";
        $query = $this->db->query($sql);

        $this->cache->delete('category');

        //$this->event->trigger('post.admin.category.delete', $symptom_id);
    }

    public function totalSymptom($data) {

        $filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
        $filter_code = isset($data['filter_code']) ? $data['filter_code'] : false;
        $filter_pinyin = isset($data['filter_pinyin']) ? $data['filter_pinyin'] : false;
        $filter_name_statement = $filter_name ? "AND a.name LIKE '%" . $filter_name . "%'" : "";
        $filter_code_statement = $filter_code ? "AND " . DB_PREFIX . "symptom.code LIKE '%" . $filter_code . "%'" : "";
        $filter_pinyin_statement = $filter_pinyin ? "AND " . DB_PREFIX . "symptom.pinyin LIKE '%" . $filter_pinyin . "%'" : "";

        $sql = "

		SELECT COUNT(*) AS total
		FROM " . DB_PREFIX . "symptom ,
		(
			SELECT *
			FROM " . DB_PREFIX . "symptom_name
			WHERE language_id = " . (int) $this->config->get('config_language_id') . "
		)a
		WHERE " . DB_PREFIX . "symptom.symptom_id = a.symptom_id
		AND " . DB_PREFIX . "symptom.parent_id = 0
		$filter_name_statement
		$filter_code_statement
		$filter_pinyin_statement";

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

}

?>