<?php

class ModelPrescriptionPulse extends Model {

    public function getPulses($data = array()) {
        return array();
    }

    public function getPulseList($data) {
        $sort = isset($data['sort']) ? $data['sort'] : "name";
        $order = isset($data['order']) ? $data['order'] : "ASC";

        $filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
        $filter_code = isset($data['filter_code']) ? $data['filter_code'] : false;
        $filter_pinyin = isset($data['filter_pinyin']) ? $data['filter_pinyin'] : false;
        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;
        $start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;

        $filter_name_statement = $filter_name ? "AND a.name LIKE '%" . $filter_name . "%'" : "";
        $filter_code_statement = $filter_code ? "AND " . DB_PREFIX . "pulse.code LIKE '%" . $filter_code . "%'" : "";
        $filter_status_statement = $filter_status ? "AND " . DB_PREFIX . "pulse.status ='" . $filter_status . "'" : "";
        $filter_pinyin_statement = $filter_pinyin ? "AND " . DB_PREFIX . "pulse.code LIKE '%" . $filter_pinyin . "%'" : "";

        $sql = "
		SELECT *
		FROM " . DB_PREFIX . "pulse ,
		(
			SELECT *
			FROM " . DB_PREFIX . "pulse_name
			WHERE language_id = " . (int) $this->config->get('config_language_id') . "
		)a
		WHERE " . DB_PREFIX . "pulse.pulse_id = a.pulse_id
		AND " . DB_PREFIX . "pulse.parent_id = 0
		$filter_name_statement
		$filter_code_statement
	    $filter_status_statement
		$filter_pinyin_statement
		ORDER BY $sort $order
		LIMIT $start, $limit";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getPulseItemList($pulse_id) {
        $pulseItemList = array();

        $sql = "
		SELECT *
		FROM " . DB_PREFIX . "pulse
		WHERE parent_id = $pulse_id";

        $query = $this->db->query($sql);
        $pulseItemRows = $query->rows;

        foreach ($pulseItemRows as $row => $pulseItem) {
            $data = array();
            $data["code"] = $pulseItem["code"];
            $data["pinyin"] = $pulseItem["pinyin"];
            $data["pulse_id"] = $pulseItem["pulse_id"];

            $data["pulse_name"] = array();
            $sql = "
			SELECT *
			FROM " . DB_PREFIX . "pulse_name
			WHERE pulse_id = " . $pulseItem["pulse_id"];
            $query = $this->db->query($sql);
            $names = $query->rows;

            foreach ($names as $row => $name) {
                $data["pulse_name"][$name["language_id"]]["name"] = $name["name"];
            }

            $pulseItemList[] = $data;
        }

        return $pulseItemList;
    }

    public function getPulseItem($pulse_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "pulse  d LEFT JOIN " . DB_PREFIX . "pulse_name dn ON (d.pulse_id = dn.pulse_id) WHERE d.parent_id = '" . (int) $pulse_id . "' AND dn.language_id = '" . (int) $this->config->get('config_language_id') . "'");

        return $query->rows;
    }

    public function getPulseColumn($pulse_id, $column_name, $multirow = false, $language_id = NULL) {
        $language_id = $language_id ? $language_id : (int) $this->config->get('config_language_id');

        $sql = "
		SELECT b." . $column_name . "
		FROM(
			SELECT " . DB_PREFIX . "pulse.pulse_id, " . DB_PREFIX . "pulse.code, " . DB_PREFIX . "pulse.pinyin, a.name, " . DB_PREFIX . "pulse.sort_order, " . DB_PREFIX . "pulse.status
			FROM " . DB_PREFIX . "pulse ,
			(
				SELECT *
				FROM " . DB_PREFIX . "pulse_name
				WHERE language_id = $language_id
			)a
			WHERE " . DB_PREFIX . "pulse.pulse_id = a.pulse_id
			AND " . DB_PREFIX . "pulse.parent_id = 0
			AND " . DB_PREFIX . "pulse.pulse_id = " . $pulse_id . "
		)b";
        $query = $this->db->query($sql);
        return $multirow ? $query->rows[$column_name] : $query->row[$column_name];
    }

    public function addPulse($data, $parent_id = 0) {
        // post data
        $names = $data['pulse_name'];
        $code = $data['code'];

        $pinyin = isset($data['pinyin']) ? $data['pinyin'] : '';
        $status = isset($data['status']) ? $data['status'] : false;
        $sort_order = isset($data['sort_order']) ? $data['sort_order'] : 0;

        $pulseitems = isset($data['pulseitem']) ? $data['pulseitem'] : false;

        // insert pulse
        $sql = "INSERT INTO " . DB_PREFIX . "pulse(code, pinyin, parent_id, status, sort_order, createby, createdate)
				VALUES('$code', '$pinyin', '$parent_id', '$status', '$sort_order', '" . $this->session->data['user_id'] . "', NOW())";
        $query = $this->db->query($sql);

        // get last insert id
        $lastid = $this->db->getLastId();

        // insert pulse name
        foreach ($names as $language_id => $value) {
            $name = $value['name'];

            $sql = "INSERT INTO " . DB_PREFIX . "pulse_name(pulse_id, language_id, name)
					VALUES('$lastid', '$language_id', '$name')";

            $query = $this->db->query($sql);
        }

        // If have child, insert child
        if ($pulseitems) {
            foreach ($pulseitems as $pulseitem) {
                $pulseitem['status'] = $status;
                $this->addPulse($pulseitem, $lastid);
            }
        }

        return $lastid;
    }

    public function editPulse($id, $data) {
        // post data
        $names = $data['pulse_name'];
        $code = $data['code'];

        $pinyin = isset($data['pinyin']) ? $data['pinyin'] : '';
        $status = isset($data['status']) ? $data['status'] : false;
        $sort_order = isset($data['sort_order']) ? $data['sort_order'] : 0;

        $pulseitems = isset($data['pulseitem']) ? $data['pulseitem'] : false;

        //general update
        $sql = "
		UPDATE " . DB_PREFIX . "pulse SET
		code = '$code',
		pinyin = '$pinyin',
		status = '$status',
		sort_order = '$sort_order',
		modifyby = '" . $this->session->data['user_id'] . "',
		modifydate = NOW()
		WHERE pulse_id = '$id'
		";
        $query = $this->db->query($sql);

        //name update
        foreach ($names as $language_id => $value) {
            $newname = $value['name'];
            $sql = "
			UPDATE " . DB_PREFIX . "pulse_name SET
			name = '$newname'
			WHERE pulse_id = '$id'
			AND language_id = $language_id
			";
            $query = $this->db->query($sql);
        }

        if ($pulseitems) {
            $survive_id = array();

            $updated_data = array();
            $new_data = array();
            $removed_data = array();

            foreach ($pulseitems as $pulseitempos => $pulseitem) {
                if (!empty($pulseitem["pulse_id"])) {
                    $pulseitem['status'] = $status;
                    $survive_id[] = $pulseitem["pulse_id"]; //track for survice pulse

                    $updated_data[] = array(//track for update pulse
                        'pulse_id' => $pulseitem["pulse_id"],
                        'data' => $pulseitem
                    );
                } else {
                    $pulseitem['status'] = $status;
                    $new_data[] = array(//track for new pulse
                        'data' => $pulseitem,
                        'parent_id' => $id
                    );
                }
            }

            // kill oudated pulse item
            $survive_id_statement = !empty($survive_id) ?
                    "AND pulse_id NOT IN('" . implode("','", $survive_id) . "')" :
                    NULL;
            $sql = "
			SELECT pulse_id
			FROM " . DB_PREFIX . "pulse
			WHERE parent_id = $id
			$survive_id_statement
			";



            $query = $this->db->query($sql);
            $outdatedPulse = $query->rows;
            foreach ($outdatedPulse as $opulse)
                $this->deletePulse($opulse['pulse_id']);

            // update pulse item
            foreach ($updated_data as $data)
                $this->editPulse($data['pulse_id'], $data['data']);

            // add new pulse item
            foreach ($new_data as $data)
                $this->addPulse($data['data'], $data['parent_id']);
        } else {
            // no child item, just kill all

            $sql = "
			SELECT COUNT(*) as total
			FROM " . DB_PREFIX . "pulse
			WHERE parent_id = $id
			";
            $query = $this->db->query($sql);
            $total = $query->row['total'];

            if ($total > 0) {
                $sql = "DELETE FROM " . DB_PREFIX . "pulse WHERE parent_id = $id";
                $query = $this->db->query($sql); //kill all child
            }
        }
    }

    public function deletePulse($pulse_id) {
        //	$this->event->trigger('pre.admin.category.delete', $pulse_id);
        //delete pulse multi language name
        $sql = "
		SELECT pulse_id
		FROM " . DB_PREFIX . "pulse
		WHERE pulse_id = $pulse_id
		OR parent_id = $pulse_id
		";
        $query = $this->db->query($sql);
        $rows = $query->rows;
        foreach ($rows as $row => $row_data) {
            $row_id = $row_data['pulse_id'];

            //delete pulse
            $sql = "
			DELETE FROM " . DB_PREFIX . "pulse_name
			WHERE pulse_id = $row_id";
            $query = $this->db->query($sql);
        }

        //delete pulse and pulse item
        $sql = "
		DELETE FROM " . DB_PREFIX . "pulse
		WHERE pulse_id = $pulse_id
		OR parent_id = $pulse_id";
        $query = $this->db->query($sql);

        $this->cache->delete('category');

        //	$this->event->trigger('post.admin.category.delete', $pulse_id);
    }

    public function totalPulse($data) {

        $filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
        $filter_code = isset($data['filter_code']) ? $data['filter_code'] : false;
        $filter_pinyin = isset($data['filter_pinyin']) ? $data['filter_pinyin'] : false;

        $filter_name_statement = $filter_name ? "AND a.name LIKE '%" . $filter_name . "%'" : "";
        $filter_code_statement = $filter_code ? "AND " . DB_PREFIX . "pulse.code LIKE '%" . $filter_code . "%'" : "";
        $filter_pinyin_statement = $filter_pinyin ? "AND " . DB_PREFIX . "pulse.pinyin LIKE '%" . $filter_pinyin . "%'" : "";

        $sql = "
		SELECT COUNT(*) AS total
		FROM " . DB_PREFIX . "pulse ,
		(
			SELECT *
			FROM " . DB_PREFIX . "pulse_name
			WHERE language_id = " . (int) $this->config->get('config_language_id') . "
		)a
		WHERE " . DB_PREFIX . "pulse.pulse_id = a.pulse_id
		AND " . DB_PREFIX . "pulse.parent_id = 0
		$filter_name_statement
		$filter_code_statement
		$filter_pinyin_statement";

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

}

?>
