<?php

class ModelPrescriptionDisease extends Model {

    public function getDiseases($data = array()) {
        return array();
    }

    public function getDiseaseList($data) {
        $sort = isset($data['sort']) ? $data['sort'] : "name";
        $order = isset($data['order']) ? $data['order'] : "ASC";
        $filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
        $filter_code = isset($data['filter_code']) ? $data['filter_code'] : false;
        $filter_pinyin = isset($data['filter_pinyin']) ? $data['filter_pinyin'] : false;
        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;
        $start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;
        $filter_name_statement = $filter_name ? "AND a.name LIKE '%" . $filter_name . "%'" : "";
        $filter_code_statement = $filter_code ? "AND " . DB_PREFIX . "disease.code LIKE '%" . $filter_code . "%'" : "";
        $filter_pinyin_statement = $filter_pinyin ? "AND " . DB_PREFIX . "disease.pinyin LIKE '%" . $filter_pinyin . "%'" : "";
        $filter_status_statement = $filter_status ? "AND " . DB_PREFIX . "disease.status ='" . $filter_status . "'" : "";

        $sql = "

		SELECT *
		FROM " . DB_PREFIX . "disease ,
		(
			SELECT *
			FROM " . DB_PREFIX . "disease_name
			WHERE language_id = " . (int) $this->config->get('config_language_id') . "
		)a
		WHERE " . DB_PREFIX . "disease.disease_id = a.disease_id
		AND " . DB_PREFIX . "disease.parent_id = 0
		$filter_name_statement
		$filter_code_statement
	    $filter_status_statement
		$filter_pinyin_statement
		ORDER BY $sort $order
		LIMIT $start, $limit";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getDiseaseItemList($disease_id) {
        $diseaseItemList = array();

        $sql = "

		SELECT *
		FROM " . DB_PREFIX . "disease
		WHERE parent_id = $disease_id";

        $query = $this->db->query($sql);
        $diseaseItemRows = $query->rows;

        foreach ($diseaseItemRows as $row => $diseaseItem) {
            $data = array();
            $data["code"] = $diseaseItem["code"];
            $data["pinyin"] = $diseaseItem["pinyin"];
            $data["disease_id"] = $diseaseItem["disease_id"];
            $data["disease_name"] = array();

            $sql = "

			SELECT *

			FROM " . DB_PREFIX . "disease_name

			WHERE disease_id = " . $diseaseItem["disease_id"];

            $query = $this->db->query($sql);
            $names = $query->rows;

            foreach ($names as $row => $name) {

                $data["disease_name"][$name["language_id"]]["name"] = $name["name"];

                $data["disease_name"][$name["language_id"]]["name_english"] = $name["name_english"];
            }

            $diseaseItemList[] = $data;
        }

        return $diseaseItemList;
    }

    public function getDiseaseItem($disease_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "disease  d
								   LEFT JOIN " . DB_PREFIX . "disease_name dn
								   ON (d.disease_id = dn.disease_id)
								   WHERE d.parent_id = '" . (int) $disease_id . "'
								   AND dn.language_id = '" . (int) $this->config->get('config_language_id') . "'");
        return $query->rows;
    }

    public function getDiseaseColumn($disease_id, $column_name, $multirow = false, $language_id = NULL) {

        $language_id = $language_id ? $language_id : (int) $this->config->get('config_language_id');

        $sql = "
		SELECT b." . $column_name . "
		FROM(
			SELECT " . DB_PREFIX . "disease.disease_id, " . DB_PREFIX . "disease.code, " . DB_PREFIX . "disease.pinyin, a.name, a.name_english, " . DB_PREFIX . "disease.sort_order, " . DB_PREFIX . "disease.status

			FROM " . DB_PREFIX . "disease ,

			(
				SELECT *
				FROM " . DB_PREFIX . "disease_name
				WHERE language_id = $language_id
			)a

			WHERE " . DB_PREFIX . "disease.disease_id = a.disease_id
			AND " . DB_PREFIX . "disease.parent_id = 0
			AND " . DB_PREFIX . "disease.disease_id = " . $disease_id . "
		)b";
        $query = $this->db->query($sql);

        return $multirow ? $query->rows[$column_name] : $query->row[$column_name];
    }

    public function addDisease($data, $parent_id = 0) {

        // post data

        $names = $data['disease_name'];
        $code = $data['code'];
        $pinyin = isset($data['pinyin']) ? $data['pinyin'] : '';
        $status = isset($data['status']) ? $data['status'] : false;
        $sort_order = isset($data['sort_order']) ? $data['sort_order'] : 0;
        $diseaseitems = isset($data['diseaseitem']) ? $data['diseaseitem'] : false;

        /* echo '<pre>';

          echo print_r($data);

          echo '</pre>'; */
        // insert disease
        $sql = "INSERT INTO " . DB_PREFIX . "disease(code, pinyin, parent_id, status, sort_order, createby, createdate)
				VALUES('$code', '$pinyin', '$parent_id', '$status', '$sort_order', '" . $this->session->data['user_id'] . "', NOW())";

        $query = $this->db->query($sql);

        // get last insert id
        $lastid = $this->db->getLastId();

        // insert disease name
        foreach ($names as $language_id => $value) {
            $name = $value['name'];
            $name_eng = $value['name_english'];

            $sql = "INSERT INTO " . DB_PREFIX . "disease_name(disease_id, language_id, name, name_english)
					VALUES('$lastid', '$language_id', '$name', '$name_eng')";

            $query = $this->db->query($sql);
        }

        // If have child, insert child

        if ($diseaseitems) {
            foreach ($diseaseitems as $diseaseitem) {
                $diseaseitem['status'] = $status;
                $this->addDisease($diseaseitem, $lastid);
            }
        }
        return $lastid;
    }

    public function editDisease($id, $data) {
        // post data
        $names = $data['disease_name'];
        $code = $data['code'];
        $pinyin = isset($data['pinyin']) ? $data['pinyin'] : '';
        $status = isset($data['status']) ? $data['status'] : false;
        $sort_order = isset($data['sort_order']) ? $data['sort_order'] : 0;
        $diseaseitems = isset($data['diseaseitem']) ? $data['diseaseitem'] : false;

        //general update

        $sql = "
		UPDATE " . DB_PREFIX . "disease SET
		code = '$code',
		pinyin = '$pinyin',
		status = '$status',
		sort_order = '$sort_order',
		modifyby = '" . $this->session->data['user_id'] . "',
		modifydate = NOW()
		WHERE disease_id = '$id'
		";

        $query = $this->db->query($sql);

        //name update
        foreach ($names as $language_id => $value) {
            $newname = $value['name'];
            $newnameenglish = $value['name_english'];
            $sql = "
			UPDATE " . DB_PREFIX . "disease_name SET
			name = '$newname',
			name_english = '$newnameenglish'
			WHERE disease_id = '$id'
			AND language_id = $language_id
			";
            $query = $this->db->query($sql);
        }

        // clear disease item language description
        $sql = "SELECT disease_id FROM " . DB_PREFIX . "disease WHERE parent_id = '" . (int) $id . "'";
        $query = $this->db->query($sql);
        foreach ($query->rows as $disease) {
            $sql = "
			DELETE FROM " . DB_PREFIX . "disease_name
			WHERE disease_id = '" . $disease['disease_id'] . "'
			";

            $this->db->query($sql);
        }

        // clear all disease child item
        $sql = "DELETE FROM " . DB_PREFIX . "disease WHERE parent_id = '" . (int) $id . "'";
        $query = $this->db->query($sql);

        if ($diseaseitems) {
            //insert new data
            foreach ($diseaseitems as $diseaseitempos => $diseaseitem) {
                $diseaseitem['status'] = $status;
                $this->addDisease($diseaseitem, $id);
            }
        }
    }

    public function deleteDisease($disease_id) {
        /*  $this->event->trigger('pre.admin.category.delete', $disease_id); */
        //delete disease multi language name
        $sql = "
		SELECT disease_id
		FROM " . DB_PREFIX . "disease
		WHERE disease_id = $disease_id
		OR parent_id = $disease_id
		";
        $query = $this->db->query($sql);
        $rows = $query->rows;

        foreach ($rows as $row => $row_data) {
            $row_id = $row_data['disease_id'];
            //delete disease

            $sql = "
			DELETE FROM " . DB_PREFIX . "disease_name
			WHERE disease_id = $row_id";

            $query = $this->db->query($sql);
        }

        //delete disease and disease item
        $sql = "

		DELETE FROM " . DB_PREFIX . "disease
		WHERE disease_id = $disease_id
		OR parent_id = $disease_id";
        $query = $this->db->query($sql);

        $this->cache->delete('category');

        /* $this->event->trigger('post.admin.category.delete', $disease_id); */
    }

    public function totalDisease($data) {

        $filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
        $filter_code = isset($data['filter_code']) ? $data['filter_code'] : false;
        $filter_pinyin = isset($data['filter_pinyin']) ? $data['filter_pinyin'] : false;
        $filter_name_statement = $filter_name ? "AND a.name LIKE '%" . $filter_name . "%'" : "";
        $filter_code_statement = $filter_code ? "AND " . DB_PREFIX . "disease.code LIKE '%" . $filter_code . "%'" : "";
        $filter_pinyin_statement = $filter_pinyin ? "AND " . DB_PREFIX . "disease.pinyin LIKE '%" . $filter_pinyin . "%'" : "";

        $sql = "

		SELECT COUNT(*) AS total
		FROM " . DB_PREFIX . "disease ,
		(
			SELECT *
			FROM " . DB_PREFIX . "disease_name
			WHERE language_id = " . (int) $this->config->get('config_language_id') . "
		)a
		WHERE " . DB_PREFIX . "disease.disease_id = a.disease_id
		AND " . DB_PREFIX . "disease.parent_id = 0
		$filter_name_statement
		$filter_code_statement
		$filter_pinyin_statement";

        //traking sql code
        $query = $this->db->query($sql);

        return $query->row['total'];
    }

}

?>
