<?php

class ModelPrescriptionConsultation extends Model {

    public function getConsultations($data = array()) {
        return array();
    }

    public function getConsultationList($data) {
        $sort = isset($data['sort']) ? $data['sort'] : "name";
        $order = isset($data['order']) ? $data['order'] : "ASC";
        $filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
        $filter_code = isset($data['filter_code']) ? $data['filter_code'] : false;
        $filter_pinyin = isset($data['filter_pinyin']) ? $data['filter_pinyin'] : false;
        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;
        $start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;
        $filter_name_statement = $filter_name ? "AND a.name LIKE '%" . $filter_name . "%'" : "";
        $filter_code_statement = $filter_code ? "AND " . DB_PREFIX . "consultation.code LIKE '%" . $filter_code . "%'" : "";
        $filter_pinyin_statement = $filter_pinyin ? "AND " . DB_PREFIX . "consultation.pinyin LIKE '%" . $filter_pinyin . "%'" : "";
        $filter_status_statement = $filter_status ? "AND " . DB_PREFIX . "consultation.status ='" . $filter_status . "'" : "";
        $sql = "
		SELECT *
		FROM " . DB_PREFIX . "consultation ,
		(
			SELECT *
			FROM " . DB_PREFIX . "consultation_name
			WHERE language_id = " . (int) $this->config->get('config_language_id') . "
		)a
		WHERE " . DB_PREFIX . "consultation.consultation_id = a.consultation_id
		AND " . DB_PREFIX . "consultation.parent_id = 0
		$filter_name_statement
		$filter_code_statement
		$filter_pinyin_statement
	    $filter_status_statement
		ORDER BY $sort $order
		LIMIT $start, $limit";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getConsultationItemList($consultation_id) {
        $consultationItemList = array();
        $sql = "
		SELECT *
		FROM " . DB_PREFIX . "consultation
		WHERE parent_id = $consultation_id";

        $query = $this->db->query($sql);
        $consultationItemRows = $query->rows;

        foreach ($consultationItemRows as $row => $consultationItem) {
            $data = array();
            $data["code"] = $consultationItem["code"];
            $data["pinyin"] = $consultationItem["pinyin"];
            $data["consultation_id"] = $consultationItem["consultation_id"];
            $data["consultation_name"] = array();
            $sql = "
			SELECT *
			FROM " . DB_PREFIX . "consultation_name
			WHERE consultation_id = " . $consultationItem["consultation_id"];
            $query = $this->db->query($sql);
            $names = $query->rows;
            foreach ($names as $row => $name) {
                $data["consultation_name"][$name["language_id"]]["name"] = $name["name"];
            }
            $consultationItemList[] = $data;
        }
        return $consultationItemList;
    }

    public function getConsultationItem($consultation_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "consultation  d LEFT JOIN " . DB_PREFIX . "consultation_name dn ON (d.consultation_id = dn.consultation_id) WHERE d.parent_id = '" . (int) $consultation_id . "' AND dn.language_id = '" . (int) $this->config->get('config_language_id') . "'");
        return $query->rows;
    }

    public function getConsultationColumn($consultation_id, $column_name, $multirow = false, $language_id = NULL) {
        $language_id = $language_id ? $language_id : (int) $this->config->get('config_language_id');
        $sql = "
		SELECT b." . $column_name . "
		FROM(
			SELECT " . DB_PREFIX . "consultation.consultation_id, " . DB_PREFIX . "consultation.code, " . DB_PREFIX . "consultation.pinyin, a.name, " . DB_PREFIX . "consultation.sort_order, " . DB_PREFIX . "consultation.status
			FROM " . DB_PREFIX . "consultation ,
			(
				SELECT *
				FROM " . DB_PREFIX . "consultation_name
				WHERE language_id = $language_id
			)a
			WHERE " . DB_PREFIX . "consultation.consultation_id = a.consultation_id
			AND " . DB_PREFIX . "consultation.parent_id = 0
			AND " . DB_PREFIX . "consultation.consultation_id = " . $consultation_id . "
		)b";
        $query = $this->db->query($sql);
        return $multirow ? $query->rows[$column_name] : $query->row[$column_name];
    }

    public function addConsultation($data, $parent_id = 0) {
        // post data
        $names = $data['consultation_name'];
        $code = $data['code'];
        $pinyin = isset($data['pinyin']) ? $data['pinyin'] : '';
        $status = isset($data['status']) ? $data['status'] : false;
        $sort_order = isset($data['sort_order']) ? $data['sort_order'] : 0;
        $consultationitems = isset($data['consultationitem']) ? $data['consultationitem'] : false;

        // insert consultation
        $sql = "INSERT INTO " . DB_PREFIX . "consultation(code, pinyin, parent_id, status, sort_order, createby, createdate)
				VALUES('$code', '$pinyin', '$parent_id', '$status', '$sort_order', '" . $this->session->data['user_id'] . "', NOW())";
        $query = $this->db->query($sql);
        // get last insert id
        $lastid = $this->db->getLastId();
        // insert consultation name
        foreach ($names as $language_id => $value) {
            $name = $value['name'];
            $sql = "INSERT INTO " . DB_PREFIX . "consultation_name(consultation_id, language_id, name)
					VALUES('$lastid', '$language_id', '$name')";
            $query = $this->db->query($sql);
        }
        // If have child, insert child
        if ($consultationitems) {
            foreach ($consultationitems as $consultationitem) {
                $consultationitem['status'] = $status;
                $this->addConsultation($consultationitem, $lastid);
            }
        }
        return $lastid;
    }

    public function editConsultation($id, $data) {
        // post data
        $names = $data['consultation_name'];
        $code = $data['code'];
        $pinyin = isset($data['pinyin']) ? $data['pinyin'] : '';
        $status = isset($data['status']) ? $data['status'] : false;
        $sort_order = isset($data['sort_order']) ? $data['sort_order'] : 0;
        $consultationitems = isset($data['consultationitem']) ? $data['consultationitem'] : false;

        //general update
        $sql = "
		UPDATE " . DB_PREFIX . "consultation SET
		code = '$code',
		pinyin = '$pinyin',
		status = '$status',
		sort_order = '$sort_order',
		modifyby = '" . $this->session->data['user_id'] . "',
		modifydate = NOW()
		WHERE consultation_id = '$id'
		";
        $query = $this->db->query($sql);

        //name update
        foreach ($names as $language_id => $value) {
            $newname = $value['name'];
            $sql = "
			UPDATE " . DB_PREFIX . "consultation_name SET
			name = '$newname'
			WHERE consultation_id = '$id'
			AND language_id = $language_id
			";
            $query = $this->db->query($sql);
        }

        if ($consultationitems) {
            $survive_id = array();

            $updated_data = array();
            $new_data = array();
            $removed_data = array();

            foreach ($consultationitems as $consultationitempos => $consultationitem) {
                if (!empty($consultationitem["consultation_id"])) {
                    $consultationitem['status'] = $status;
                    $survive_id[] = $consultationitem["consultation_id"]; //track for survice consultation

                    $updated_data[] = array(//track for update consultation

                        'consultation_id' => $consultationitem["consultation_id"],
                        'data' => $consultationitem
                    );
                } else {
                    $consultationitem['status'] = $status;

                    $new_data[] = array(//track for new consultation
                        'data' => $consultationitem,
                        'parent_id' => $id
                    );
                }
            }

            // kill oudated consultation item
            $survive_id_statement = !empty($survive_id) ?
                    "AND consultation_id NOT IN('" . implode("','", $survive_id) . "')" :
                    NULL;
            $sql = "
			SELECT consultation_id
			FROM " . DB_PREFIX . "consultation
			WHERE parent_id = $id
			$survive_id_statement
			";

            $query = $this->db->query($sql);
            $outdatedConsultation = $query->rows;
            foreach ($outdatedConsultation as $oconsultation)
                $this->deleteConsultation($oconsultation['consultation_id']);

            // update consultation item
            foreach ($updated_data as $data)
                $this->editConsultation($data['consultation_id'], $data['data']);

            // add new consultation item
            foreach ($new_data as $data)
                $this->addConsultation($data['data'], $data['parent_id']);
        } else {
            // no child item, just kill all

            $sql = "
			SELECT COUNT(*) as total
			FROM " . DB_PREFIX . "consultation
			WHERE parent_id = $id
			";
            $query = $this->db->query($sql);
            $total = $query->row['total'];

            if ($total > 0) {
                $sql = "DELETE FROM " . DB_PREFIX . "consultation WHERE parent_id = $id";
                $query = $this->db->query($sql); //kill all child
            }
        }
    }

    public function deleteConsultation($consultation_id) {
        //$this->event->trigger('pre.admin.category.delete', $consultation_id);
        //delete consultation multi language name
        $sql = "
		SELECT consultation_id
		FROM " . DB_PREFIX . "consultation
		WHERE consultation_id = $consultation_id
		OR parent_id = $consultation_id
		";
        $query = $this->db->query($sql);
        $rows = $query->rows;
        foreach ($rows as $row => $row_data) {
            $row_id = $row_data['consultation_id'];

            //delete consultation
            $sql = "
			DELETE FROM " . DB_PREFIX . "consultation_name
			WHERE consultation_id = $row_id";
            $query = $this->db->query($sql);
        }

        //delete consultation and consultation item
        $sql = "
		DELETE FROM " . DB_PREFIX . "consultation
		WHERE consultation_id = $consultation_id
		OR parent_id = $consultation_id";
        $query = $this->db->query($sql);

        $this->cache->delete('category');

        // $this->event->trigger('post.admin.category.delete', $consultation_id);
    }

    public function totalConsultation($data) {

        $filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
        $filter_code = isset($data['filter_code']) ? $data['filter_code'] : false;
        $filter_pinyin = isset($data['filter_pinyin']) ? $data['filter_pinyin'] : false;

        $filter_name_statement = $filter_name ? "AND a.name LIKE '%" . $filter_name . "%'" : "";
        $filter_code_statement = $filter_code ? "AND " . DB_PREFIX . "consultation.code LIKE '%" . $filter_code . "%'" : "";
        $filter_pinyin_statement = $filter_pinyin ? "AND " . DB_PREFIX . "consultation.pinyin LIKE '%" . $filter_pinyin . "%'" : "";

        $sql = "
		SELECT COUNT(*) AS total
		FROM " . DB_PREFIX . "consultation ,
		(
			SELECT *
			FROM " . DB_PREFIX . "consultation_name
			WHERE language_id = " . (int) $this->config->get('config_language_id') . "
		)a
		WHERE " . DB_PREFIX . "consultation.consultation_id = a.consultation_id
		AND " . DB_PREFIX . "consultation.parent_id = 0
		$filter_name_statement
		$filter_code_statement
		$filter_pinyin_statement";

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

}

?>
