<?php

class ModelPrescriptionAcupuncturePart extends Model {

    public function getAcupuncturePartList($data) {
        $sort = isset($data['sort']) ? $data['sort'] : "apd.name";
        $order = isset($data['order']) ? $data['order'] : "ASC";
        $filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
        $filter_code = isset($data['filter_code']) ? $data['filter_code'] : false;
        $filter_pinyin = isset($data['filter_pinyin']) ? $data['filter_pinyin'] : false;
        $start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;
        $filter_name_statement = $filter_name ? "AND apd.name LIKE '%" . $filter_name . "%'" : "";
        $filter_code_statement = $filter_code ? "AND ap.code LIKE '%" . $filter_code . "%'" : "";
        $filter_pinyin_statement = $filter_pinyin ? "AND ap.pinyin LIKE '%" . $filter_pinyin . "%'" : "";
        $sql = "SELECT *                FROM " . DB_PREFIX . "acupuncture_part ap                LEFT JOIN " . DB_PREFIX . "acupuncture_part_description apd                ON apd.acupuncture_part_id = ap.acupuncture_part_id                AND apd.language_id = '" . (int) $this->config->get('config_language_id') . "'                WHERE 1                $filter_name_statement                $filter_code_statement                $filter_pinyin_statement                ORDER BY $sort $order                LIMIT $start, $limit";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getTotalAcupunctureParts($data) {
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "acupuncture_part ap LEFT JOIN " . DB_PREFIX . "acupuncture_part_description apd ON apd.acupuncture_part_id = ap.acupuncture_part_id WHERE apd.language_id = '" . (int) $this->config->get('config_language_id') . "'";
        if (!empty($data['filter_name'])) {
            $sql .= " AND apd.name LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        } if (!empty($data['filter_code'])) {
            $sql .= " AND ap.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'";
        } if (!empty($data['filter_pinyin'])) {
            $sql .= " AND ap.pinyin LIKE '%" . $this->db->escape($data['filter_pinyin']) . "%'";
        } $query = $this->db->query($sql);
        return $query->row['total'];
    }

    public function getAcupunctureParts($data) {
        $sql = "SELECT ap.sort_order, apd.name, ap.acupuncture_part_id, ap.code, ap.pinyin FROM " . DB_PREFIX . "acupuncture_part ap LEFT JOIN " . DB_PREFIX . "acupuncture_part_description apd ON apd.acupuncture_part_id = ap.acupuncture_part_id WHERE apd.language_id = '" . (int) $this->config->get('config_language_id') . "'";
        if (!empty($data['filter_name'])) {
            $sql .= " AND apd.name LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        } if (!empty($data['filter_code'])) {
            $sql .= " AND ap.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'";
        } if (!empty($data['filter_pinyin'])) {
            $sql .= " AND ap.pinyin LIKE '%" . $this->db->escape($data['filter_pinyin']) . "%'";
        } $sort_data = array('name', 'code', 'pinyin', 'sort_order');
        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ASC";
        } if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        } if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            } if ($data['limit'] < 1) {
                $data['limit'] = 20;
            } $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        } $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getAcupuncturePart($acupuncture_part_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "acupuncture_part WHERE acupuncture_part_id = '" . (int) $acupuncture_part_id . "'";
        $query = $this->db->query($sql);
        $acupuncture_part = $query->row;
        $language_sql = "SELECT * FROM " . DB_PREFIX . "acupuncture_part_description WHERE acupuncture_part_id = '" . (int) $acupuncture_part_id . "'";
        $language_query = $this->db->query($language_sql);
        $language_result = $language_query->rows;
        foreach ($language_result as $language) {
            $name[$language['language_id']] = $language['name'];
        } $acupuncture_part['name'] = $name;
        return $acupuncture_part;
    }

    public function addAcupuncturePart($data) {
        $sql = "INSERT INTO " . DB_PREFIX . "acupuncture_part                SET code = '" . $this->db->escape($data['acupuncture_part_code']) . "',                  pinyin = '" . $this->db->escape($data['pinyin']) . "',                  sort_order = '" . (int) $data['acupuncture_part_sort_order'] . "',                  status = '" . (int) $data['status'] . "',                  date_added = NOW(),                  add_by = '" . (int) $this->session->data['user_id'] . "',                  date_modified = NOW(),                  modify_by = '" . (int) $this->session->data['user_id'] . "'";
        $query = $this->db->query($sql);
        $acupuncture_part_id = $this->db->getLastId();
        foreach ($data['acupuncture_part_name'] as $language_id => $value) {
            $sql_language = "INSERT INTO " . DB_PREFIX . "acupuncture_part_description                             SET acupuncture_part_id = '" . (int) $acupuncture_part_id . "',                             language_id = '" . (int) $language_id . "',                             name = '" . $this->db->escape($value) . "'";
            $language_query = $this->db->query($sql_language);
        } return $acupuncture_part_id;
    }

    public function editAcupuncturePart($acupuncture_part_id, $data) {
        $sql = "UPDATE " . DB_PREFIX . "acupuncture_part                SET code = '" . $this->db->escape($data['acupuncture_part_code']) . "',                pinyin = '" . $this->db->escape($data['pinyin']) . "',                 sort_order = '" . (int) $data['acupuncture_part_sort_order'] . "',                status = '" . (int) $data['status'] . "',                date_modified = NOW(),                modify_by = '" . (int) $this->session->data['user_id'] . "'                WHERE acupuncture_part_id = '" . (int) $acupuncture_part_id . "'";
        $query = $this->db->query($sql);
        foreach ($data['acupuncture_part_name'] as $language_id => $value) {
            $sql_language = "UPDATE " . DB_PREFIX . "acupuncture_part_description                             SET name = '" . $this->db->escape($value) . "'                             WHERE language_id = '" . (int) $language_id . "'                             AND acupuncture_part_id = '" . (int) $acupuncture_part_id . "'";
            $language_query = $this->db->query($sql_language);
        }
    }

    public function getAllAcupunctureItems() {
        $sql = "SELECT * FROM " . DB_PREFIX . "acupuncture WHERE parent_id > 0";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function deleteAcupuncturePart($acupuncture_part_id) {
        $this->db->query("DELETE FROM " . DB_PREFIX . "acupuncture_part WHERE acupuncture_part_id = '" . (int) $acupuncture_part_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "acupuncture_part_description WHERE acupuncture_part_id = '" . (int) $acupuncture_part_id . "'");
    }

} ?>